const sw=self,VERSION=4,resourceCacheName=`vscode-resource-cache-${VERSION}`,rootPath=sw.location.pathname.replace(/\/service-worker.js$/,""),searchParams=new URL(location.toString()).searchParams,remoteAuthority=searchParams.get("remoteAuthority");let outerIframeMessagePort;const resourceBaseAuthority=searchParams.get("vscode-resource-base-authority"),resolveTimeout=3e4;class RequestStore{constructor(){this.map=new Map,this.requestPool=0}create(){const e=++this.requestPool;let s;const o=new Promise(c=>s=c),r={resolve:s,promise:o};this.map.set(e,r);const i=setTimeout(()=>{clearTimeout(i);const c=this.map.get(e);if(c===r){c.resolve({status:"timeout"}),this.map.delete(e);return}},resolveTimeout);return{requestId:e,promise:o}}resolve(e,s){const o=this.map.get(e);return o?(o.resolve({status:"ok",value:s}),this.map.delete(e),!0):!1}}const resourceRequestStore=new RequestStore,localhostRequestStore=new RequestStore,unauthorized=()=>new Response("Unauthorized",{status:401}),notFound=()=>new Response("Not Found",{status:404}),methodNotAllowed=()=>new Response("Method Not Allowed",{status:405}),requestTimeout=()=>new Response("Request Timeout",{status:408});sw.addEventListener("message",async t=>{switch(t.data.channel){case"version":{outerIframeMessagePort=t.ports[0];const e=t.source;sw.clients.get(e.id).then(s=>{s&&s.postMessage({channel:"version",version:VERSION})});return}case"did-load-resource":{const e=t.data.data;resourceRequestStore.resolve(e.id,e)||console.log("Could not resolve unknown resource",e.path);return}case"did-load-localhost":{const e=t.data.data;localhostRequestStore.resolve(e.id,e.location)||console.log("Could not resolve unknown localhost",e.origin);return}default:{console.log("Unknown message");return}}}),sw.addEventListener("fetch",t=>{const e=new URL(t.request.url);if(typeof resourceBaseAuthority=="string"&&e.protocol==="https:"&&e.hostname.endsWith("."+resourceBaseAuthority))switch(t.request.method){case"GET":case"HEAD":{const s=e.hostname.slice(0,e.hostname.length-(resourceBaseAuthority.length+1)),o=s.split("+",1)[0],r=s.slice(o.length+1);return t.respondWith(processResourceRequest(t,{scheme:o,authority:r,path:e.pathname,query:e.search.replace(/^\?/,"")}))}default:return t.respondWith(methodNotAllowed())}if(e.origin!==sw.origin&&e.host===remoteAuthority)switch(t.request.method){case"GET":case"HEAD":return t.respondWith(processResourceRequest(t,{path:e.pathname,scheme:e.protocol.slice(0,e.protocol.length-1),authority:e.host,query:e.search.replace(/^\?/,"")}));default:return t.respondWith(methodNotAllowed())}if(e.origin!==sw.origin&&e.host.match(/^(localhost|127.0.0.1|0.0.0.0):(\d+)$/))return t.respondWith(processLocalhostRequest(t,e))}),sw.addEventListener("install",t=>{t.waitUntil(sw.skipWaiting())}),sw.addEventListener("activate",t=>{t.waitUntil(sw.clients.claim())});async function processResourceRequest(t,e){let s=await sw.clients.get(t.clientId);if(!s&&(s=await getWorkerClientForId(t.clientId),!s))return console.error("Could not find inner client for request"),notFound();const o=getWebviewIdForClient(s);if(!o&&s.type!=="worker"&&s.type!=="sharedworker")return console.error("Could not resolve webview id"),notFound();const r=t.request.method==="GET",p=(n,h)=>{if(n.status==="timeout")return requestTimeout();const a=n.value;if(a.status===304){if(h)return h.clone();throw new Error("No cache found")}if(a.status===401)return unauthorized();if(a.status!==200)return notFound();const f={"Access-Control-Allow-Origin":"*"},g=a.data.byteLength,w=t.request.headers.get("range");if(w){const d=w.match(/^bytes\=(\d+)\-(\d+)?$/g);if(d){const C=Number(d[1]),q=Number(d[2])||g-1;return new Response(a.data.slice(C,q+1),{status:206,headers:{...f,"Content-range":`bytes 0-${q}/${g}`}})}else return new Response(null,{status:416,headers:{...f,"Content-range":`*/${g}`}})}const u={...f,"Content-Type":a.mime,"Content-Length":g.toString()};a.etag&&(u.ETag=a.etag,u["Cache-Control"]="no-cache"),a.mtime&&(u["Last-Modified"]=new Date(a.mtime).toUTCString());const m=new URL(t.request.url).searchParams.get("vscode-coi");m==="3"?(u["Cross-Origin-Opener-Policy"]="same-origin",u["Cross-Origin-Embedder-Policy"]="require-corp"):m==="2"?u["Cross-Origin-Embedder-Policy"]="require-corp":m==="1"&&(u["Cross-Origin-Opener-Policy"]="same-origin");const y=new Response(a.data,{status:200,headers:u});return r&&a.etag&&caches.open(resourceCacheName).then(d=>d.put(t.request,y)),y.clone()};let i;r&&(i=await(await caches.open(resourceCacheName)).match(t.request));const{requestId:c,promise:l}=resourceRequestStore.create();if(o){const n=await getOuterIframeClient(o);if(!n.length)return console.log("Could not find parent client for request"),notFound();for(const h of n)h.postMessage({channel:"load-resource",id:c,scheme:e.scheme,authority:e.authority,path:e.path,query:e.query,ifNoneMatch:i?.headers.get("ETag")})}else(s.type==="worker"||s.type==="sharedworker")&&outerIframeMessagePort?.postMessage({channel:"load-resource",id:c,scheme:e.scheme,authority:e.authority,path:e.path,query:e.query,ifNoneMatch:i?.headers.get("ETag")});return l.then(n=>p(n,i))}async function processLocalhostRequest(t,e){const s=await sw.clients.get(t.clientId);if(!s)return fetch(t.request);const o=getWebviewIdForClient(s);if(!o)return console.error("Could not resolve webview id"),fetch(t.request);const r=e.origin,p=async l=>{if(l.status!=="ok"||!l.value)return fetch(t.request);const n=l.value,h=t.request.url.replace(new RegExp(`^${e.origin}(/|$)`),`${n}$1`);return new Response(null,{status:302,headers:{Location:h}})},{requestId:i,promise:c}=localhostRequestStore.create();if(o){const l=await getOuterIframeClient(o);if(!l.length)return console.log("Could not find parent client for request"),notFound();for(const n of l)n.postMessage({channel:"load-localhost",origin:r,id:i})}else(s.type==="worker"||s.type==="sharedworker")&&outerIframeMessagePort?.postMessage({channel:"load-localhost",origin:r,id:i});return c.then(p)}function getWebviewIdForClient(t){return new URL(t.url).searchParams.get("id")}async function getOuterIframeClient(t){return(await sw.clients.matchAll({includeUncontrolled:!0})).filter(s=>{const o=new URL(s.url);return(o.pathname===`${rootPath}/`||o.pathname===`${rootPath}/index.html`||o.pathname===`${rootPath}/index-no-csp.html`)&&o.searchParams.get("id")===t})}async function getWorkerClientForId(t){const e=await sw.clients.matchAll({type:"worker"}),s=await sw.clients.matchAll({type:"sharedworker"});return[...e,...s].find(r=>r.id===t)}

//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c146e3ead121cb276cbf6a1f7490a2abd12c8416-0e3bb7aa6702875e3de40b1d3e744a8304f7db3e/core/vs/workbench/contrib/webview/browser/pre/service-worker.js.map
