/*
 * 1DS JS SDK POST plugin, 3.2.13
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* TimeoutOverrideWrapper.ts
* @author  Nev Wylie (newylie)
* @copyright Microsoft 2022
* Simple internal timeout wrapper
*/
export function defaultSetTimeout(callback, ms) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    return setTimeout(callback, ms, args);
}
export function defaultClearTimeout(timeoutId) {
    clearTimeout(timeoutId);
}
export function createTimeoutWrapper(argSetTimeout, argClearTimeout) {
    return {
        set: argSetTimeout || defaultSetTimeout,
        clear: argClearTimeout || defaultClearTimeout
    };
}
//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c89e16d62ef8bc282bd272360e7a80562ac104a1-5345a682642cf58747f762929f3836a2b034c868/node_modules/@microsoft/1ds-post-js/dist-esm/src/TimeoutOverrideWrapper.js.map