"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.t = t;
exports.isZhCN = isZhCN;
const vscode = __importStar(require("vscode"));
const zh_cn_json_1 = __importDefault(require("./zh-cn.json"));
const en_json_1 = __importDefault(require("./en.json"));
/**
 * 获取当前语言的翻译对象
 */
function getMessages() {
    const isZhCN = vscode.env.language === 'zh-cn';
    return isZhCN ? zh_cn_json_1.default : en_json_1.default;
}
/**
 * 获取翻译文本
 * @param key 翻译键名
 * @param params 可选的替换参数
 */
function t(key, params) {
    const messages = getMessages();
    let text = messages[key] || key;
    if (params) {
        Object.entries(params).forEach(([paramKey, value]) => {
            text = text.replace(`{${paramKey}}`, value);
        });
    }
    return text;
}
/**
 * 判断当前是否为中文环境
 */
function isZhCN() {
    return vscode.env.language === 'zh-cn';
}
//# sourceMappingURL=index.js.map