"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function flatten(tree) {
    const result = {};
    for (const [glyphId, entry] of Object.entries(tree.individual)) {
        result[glyphId] = flattenEntry(entry);
    }
    for (const { range, entry } of tree.range) {
        const flattened = flattenEntry(entry);
        for (let glyphId = range[0]; glyphId < range[1]; glyphId++) {
            result[glyphId] = flattened;
        }
    }
    return result;
}
exports.default = flatten;
function flattenEntry(entry) {
    const result = {};
    if (entry.forward) {
        result.forward = flatten(entry.forward);
    }
    if (entry.reverse) {
        result.reverse = flatten(entry.reverse);
    }
    if (entry.lookup) {
        result.lookup = entry.lookup;
    }
    return result;
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c146e3ead121cb276cbf6a1f7490a2abd12c8416-5f7842a9cf57659d5985b9505693e7ede0f8723c/node_modules/font-ligatures/dist/flatten.js.map