import * as React from 'react';
import { DecoratorNode, LexicalNode, NodeKey, SerializedLexicalNode, Spread } from 'lexical';
export type SerializedMermaidNode = Spread<{
    code: string;
    type: 'mermaid';
}, SerializedLexicalNode>;
export declare class MermaidNode extends DecoratorNode<React.ReactElement> {
    __code: string;
    static getType(): string;
    static clone(node: MermaidNode): MermaidNode;
    constructor(code: string, key?: NodeKey);
    createDOM(): HTMLElement;
    updateDOM(): false;
    static importJSON(serializedNode: SerializedMermaidNode): MermaidNode;
    exportJSON(): SerializedMermaidNode;
    getCode(): string;
    setCode(code: string): void;
    decorate(): React.ReactElement;
}
export declare function $createMermaidNode(code: string): MermaidNode;
export declare function $isMermaidNode(node: LexicalNode | null | undefined): node is MermaidNode;
//# sourceMappingURL=MermaidNode.d.ts.map