import { DecoratorNode, DOMConversionMap, DOMExportOutput, EditorConfig, LexicalEditor, LexicalNode, NodeKey, SerializedLexicalNode, Spread } from 'lexical';
import * as React from 'react';
export interface TodoItem {
    id: string;
    content: string;
    dependencies?: string[];
}
export type SerializedTodoListNode = Spread<{
    todos: TodoItem[];
}, SerializedLexicalNode>;
export declare class TodoListNode extends DecoratorNode<React.ReactElement> {
    __todos: TodoItem[];
    static getType(): string;
    static clone(node: TodoListNode): TodoListNode;
    constructor(todos: TodoItem[], key?: NodeKey);
    createDOM(config: EditorConfig): HTMLElement;
    updateDOM(): false;
    exportDOM(): DOMExportOutput;
    static importDOM(): DOMConversionMap | null;
    exportJSON(): SerializedTodoListNode;
    static importJSON(serializedNode: SerializedTodoListNode): TodoListNode;
    getTodos(): TodoItem[];
    setTodos(todos: TodoItem[]): void;
    decorate(editor: LexicalEditor, config: EditorConfig): React.ReactElement;
}
export declare function $createTodoListNode(todos?: TodoItem[]): TodoListNode;
export declare function $isTodoListNode(node: LexicalNode | null | undefined): node is TodoListNode;
//# sourceMappingURL=TodoListNode.d.ts.map