#!/usr/bin/env node
/*! For license information please see index.js.LICENSE.txt */
(()=>{var __webpack_modules__={247:e=>{"use strict";e.exports=JSON.parse('{"$id":"query.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","required":["name","value"],"properties":{"name":{"type":"string"},"value":{"type":"string"},"comment":{"type":"string"}}}')},270:(e,t,a)=>{"use strict";const o=a(53908),r=a(78311);e.exports=(e,t,a)=>{let i=null,n=null,s=null;try{s=new r(t,a)}catch(e){return null}return e.forEach(e=>{s.test(e)&&(i&&1!==n.compare(e)||(i=e,n=new o(i,a)))}),i}},687:(e,t,a)=>{var o=a(19534).BigInteger,r=a(92236).ECCurveFp;function X9ECParameters(e,t,a,o){this.curve=e,this.g=t,this.n=a,this.h=o}function fromHex(e){return new o(e,16)}function secp128r1(){var e=fromHex("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"),t=fromHex("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC"),a=fromHex("E87579C11079F43DD824993C2CEE5ED3"),i=fromHex("FFFFFFFE0000000075A30D1B9038A115"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("04161FF7528B899B2D0C28607CA52C5B86CF5AC8395BAFEB13C02DA292DDED7A83");return new X9ECParameters(s,c,i,n)}function secp160k1(){var e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73"),t=o.ZERO,a=fromHex("7"),i=fromHex("0100000000000000000001B8FA16DFAB9ACA16B6B3"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("043B4C382CE37AA192A4019E763036F4F5DD4D7EBB938CF935318FDCED6BC28286531733C3F03C4FEE");return new X9ECParameters(s,c,i,n)}function secp160r1(){var e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF"),t=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC"),a=fromHex("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45"),i=fromHex("0100000000000000000001F4C8F927AED3CA752257"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("044A96B5688EF573284664698968C38BB913CBFC8223A628553168947D59DCC912042351377AC5FB32");return new X9ECParameters(s,c,i,n)}function secp192k1(){var e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37"),t=o.ZERO,a=fromHex("3"),i=fromHex("FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("04DB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7D9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9D");return new X9ECParameters(s,c,i,n)}function secp192r1(){var e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF"),t=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC"),a=fromHex("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1"),i=fromHex("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("04188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF101207192B95FFC8DA78631011ED6B24CDD573F977A11E794811");return new X9ECParameters(s,c,i,n)}function secp224r1(){var e=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001"),t=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE"),a=fromHex("B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4"),i=fromHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("04B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34");return new X9ECParameters(s,c,i,n)}function secp256r1(){var e=fromHex("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"),t=fromHex("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC"),a=fromHex("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B"),i=fromHex("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"),n=o.ONE,s=new r(e,t,a),c=s.decodePointHex("046B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C2964FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5");return new X9ECParameters(s,c,i,n)}X9ECParameters.prototype.getCurve=function x9getCurve(){return this.curve},X9ECParameters.prototype.getG=function x9getG(){return this.g},X9ECParameters.prototype.getN=function x9getN(){return this.n},X9ECParameters.prototype.getH=function x9getH(){return this.h},e.exports={secp128r1,secp160k1,secp160r1,secp192k1,secp192r1,secp224r1,secp256r1}},757:(e,t,a)=>{"use strict";var o=a(87016),r=a(54926),i=a(70388),n=a(12550),s=a(15442),c=a(76982),p=a(92861).Buffer;function OAuth(e){this.request=e,this.params=null}OAuth.prototype.buildParams=function(e,t,a,o,r,i){var c={};for(var p in e)c["oauth_"+p]=e[p];c.oauth_version||(c.oauth_version="1.0"),c.oauth_timestamp||(c.oauth_timestamp=Math.floor(Date.now()/1e3).toString()),c.oauth_nonce||(c.oauth_nonce=n().replace(/-/g,"")),c.oauth_signature_method||(c.oauth_signature_method="HMAC-SHA1");var u=c.oauth_consumer_secret||c.oauth_private_key;delete c.oauth_consumer_secret,delete c.oauth_private_key;var l=c.oauth_token_secret;delete c.oauth_token_secret;var m=c.oauth_realm;delete c.oauth_realm,delete c.oauth_transport_method;var f=t.protocol+"//"+t.host+t.pathname,h=i.parse([].concat(o,r,i.stringify(c)).join("&"));return c.oauth_signature=s.sign(c.oauth_signature_method,a,f,h,u,l),m&&(c.realm=m),c},OAuth.prototype.buildBodyHash=function(e,t){["HMAC-SHA1","RSA-SHA1"].indexOf(e.signature_method||"HMAC-SHA1")<0&&this.request.emit("error",new Error("oauth: "+e.signature_method+" signature_method not supported with body_hash signing."));var a=c.createHash("sha1");a.update(t||"");var o=a.digest("hex");return p.from(o,"hex").toString("base64")},OAuth.prototype.concatParams=function(e,t,a){a=a||"";var o=Object.keys(e).filter(function(e){return"realm"!==e&&"oauth_signature"!==e}).sort();return e.realm&&o.splice(0,0,"realm"),o.push("oauth_signature"),o.map(function(t){return t+"="+a+s.rfc3986(e[t])+a}).join(t)},OAuth.prototype.onRequest=function(e){var t=this;t.params=e;var a,n,s=t.request.uri||{},c=t.request.method||"",p=i(t.request.headers),u=t.request.body||"",l=t.request.qsLib||r,m=p.get("content-type")||"",f="application/x-www-form-urlencoded",h=e.transport_method||"header";m.slice(0,33)===f&&(m=f,a=u),s.query&&(n=s.query),"body"!==h||"POST"===c&&m===f||t.request.emit("error",new Error("oauth: transport_method of body requires POST and content-type "+f)),a||"boolean"!=typeof e.body_hash||(e.body_hash=t.buildBodyHash(e,t.request.body.toString()));var g=t.buildParams(e,s,c,n,a,l);switch(h){case"header":t.request.setHeader("Authorization","OAuth "+t.concatParams(g,",",'"'));break;case"query":var y=t.request.uri.href+=(n?"&":"?")+t.concatParams(g,"&");t.request.uri=o.parse(y),t.request.path=t.request.uri.path;break;case"body":t.request.body=(a?a+"&":"")+t.concatParams(g,"&");break;default:t.request.emit("error",new Error("oauth: transport_method invalid"))}},t.W=OAuth},920:(e,t,a)=>{"use strict";var o=a(69675),r=a(58859),i=a(14803),n=a(80507),s=a(72271)||n||i;e.exports=function getSideChannel(){var e,t={assert:function(e){if(!t.has(e))throw new o("Side channel does not contain "+r(e))},delete:function(t){return!!e&&e.delete(t)},get:function(t){return e&&e.get(t)},has:function(t){return!!e&&e.has(t)},set:function(t,a){e||(e=s()),e.set(t,a)}};return t}},1045:e=>{"use strict";e.exports=JSON.parse('{"$id":"cache.json#","$schema":"http://json-schema.org/draft-06/schema#","properties":{"beforeRequest":{"oneOf":[{"type":"null"},{"$ref":"beforeRequest.json#"}]},"afterRequest":{"oneOf":[{"type":"null"},{"$ref":"afterRequest.json#"}]},"comment":{"type":"string"}}}')},1143:(e,t,a)=>{var o=a(42613),r=a(39023);function jsSprintf(e){var t,a,i,n,s,c,p,u,l,m=["([^%]*)","%","(['\\-+ #0]*?)","([1-9]\\d*)?","(\\.([1-9]\\d*))?","[lhjztL]*?","([diouxXfFeEgGaAcCsSp%jr])"].join(""),f=new RegExp(m),h=Array.prototype.slice.call(arguments,1),g="",y=1;for(o.equal("string",typeof e);null!==(l=f.exec(e));)if(g+=l[1],e=e.substring(l[0].length),t=l[2]||"",a=l[3]||0,i=l[4]||"",s=!1,p=!1,c=" ","%"!=(n=l[6])){if(0===h.length)throw new Error("too few args to sprintf");if(u=h.shift(),y++,t.match(/[\' #]/))throw new Error("unsupported flags: "+t);if(i.length>0)throw new Error("non-zero precision not supported");switch(t.match(/-/)&&(s=!0),t.match(/0/)&&(c="0"),t.match(/\+/)&&(p=!0),n){case"s":if(null==u)throw new Error("argument "+y+": attempted to print undefined or null as a string");g+=doPad(c,a,s,u.toString());break;case"d":u=Math.floor(u);case"f":g+=(p=p&&u>0?"+":"")+doPad(c,a,s,u.toString());break;case"x":g+=doPad(c,a,s,u.toString(16));break;case"j":0===a&&(a=10),g+=r.inspect(u,!1,a);break;case"r":g+=dumpException(u);break;default:throw new Error("unsupported conversion: "+n)}}else g+="%";return g+=e}function jsFprintf(e){var t=Array.prototype.slice.call(arguments,1);return e.write(jsSprintf.apply(this,t))}function doPad(e,t,a,o){for(var r=o;r.length<t;)a?r+=e:r=e+r;return r}function dumpException(e){var t;if(!(e instanceof Error))throw new Error(jsSprintf("invalid type for %%r: %j",e));if(t="EXCEPTION: "+e.constructor.name+": "+e.stack,e.cause&&"function"==typeof e.cause){var a=e.cause();a&&(t+="\nCaused by: "+dumpException(a))}return t}t.sprintf=jsSprintf,t.printf=function jsPrintf(){var e=Array.prototype.slice.call(arguments);e.unshift(process.stdout),jsFprintf.apply(null,e)},t.fprintf=jsFprintf},1189:(e,t,a)=>{"use strict";var o=a(20181).Buffer;e.exports=function(e){var t=void 0;e.supportsNodeEncodingsExtension=!(o.from||new o(0)instanceof Uint8Array),e.extendNodeEncodings=function extendNodeEncodings(){if(!t){if(t={},!e.supportsNodeEncodingsExtension)return console.error("ACTION NEEDED: require('iconv-lite').extendNodeEncodings() is not supported in your version of Node"),void console.error("See more info at https://github.com/ashtuchkin/iconv-lite/wiki/Node-v4-compatibility");var r={hex:!0,utf8:!0,"utf-8":!0,ascii:!0,binary:!0,base64:!0,ucs2:!0,"ucs-2":!0,utf16le:!0,"utf-16le":!0};o.isNativeEncoding=function(e){return e&&r[e.toLowerCase()]};var i=a(20181).SlowBuffer;if(t.SlowBufferToString=i.prototype.toString,i.prototype.toString=function(a,r,i){return a=String(a||"utf8").toLowerCase(),o.isNativeEncoding(a)?t.SlowBufferToString.call(this,a,r,i):(void 0===r&&(r=0),void 0===i&&(i=this.length),e.decode(this.slice(r,i),a))},t.SlowBufferWrite=i.prototype.write,i.prototype.write=function(a,r,i,n){if(isFinite(r))isFinite(i)||(n=i,i=void 0);else{var s=n;n=r,r=i,i=s}r=+r||0;var c=this.length-r;if(i?(i=+i)>c&&(i=c):i=c,n=String(n||"utf8").toLowerCase(),o.isNativeEncoding(n))return t.SlowBufferWrite.call(this,a,r,i,n);if(a.length>0&&(i<0||r<0))throw new RangeError("attempt to write beyond buffer bounds");var p=e.encode(a,n);return p.length<i&&(i=p.length),p.copy(this,r,0,i),i},t.BufferIsEncoding=o.isEncoding,o.isEncoding=function(t){return o.isNativeEncoding(t)||e.encodingExists(t)},t.BufferByteLength=o.byteLength,o.byteLength=i.byteLength=function(a,r){return r=String(r||"utf8").toLowerCase(),o.isNativeEncoding(r)?t.BufferByteLength.call(this,a,r):e.encode(a,r).length},t.BufferToString=o.prototype.toString,o.prototype.toString=function(a,r,i){return a=String(a||"utf8").toLowerCase(),o.isNativeEncoding(a)?t.BufferToString.call(this,a,r,i):(void 0===r&&(r=0),void 0===i&&(i=this.length),e.decode(this.slice(r,i),a))},t.BufferWrite=o.prototype.write,o.prototype.write=function(a,r,i,n){var s=r,c=i,p=n;if(isFinite(r))isFinite(i)||(n=i,i=void 0);else{var u=n;n=r,r=i,i=u}if(n=String(n||"utf8").toLowerCase(),o.isNativeEncoding(n))return t.BufferWrite.call(this,a,s,c,p);r=+r||0;var l=this.length-r;if(i?(i=+i)>l&&(i=l):i=l,a.length>0&&(i<0||r<0))throw new RangeError("attempt to write beyond buffer bounds");var m=e.encode(a,n);return m.length<i&&(i=m.length),m.copy(this,r,0,i),i},e.supportsStreams){var n=a(2203).Readable;t.ReadableSetEncoding=n.prototype.setEncoding,n.prototype.setEncoding=function setEncoding(t,a){this._readableState.decoder=e.getDecoder(t,a),this._readableState.encoding=t},n.prototype.collect=e._collect}}},e.undoExtendNodeEncodings=function undoExtendNodeEncodings(){if(e.supportsNodeEncodingsExtension){if(!t)throw new Error("require('iconv-lite').undoExtendNodeEncodings(): Nothing to undo; extendNodeEncodings() is not called.");delete o.isNativeEncoding;var r=a(20181).SlowBuffer;if(r.prototype.toString=t.SlowBufferToString,r.prototype.write=t.SlowBufferWrite,o.isEncoding=t.BufferIsEncoding,o.byteLength=t.BufferByteLength,o.prototype.toString=t.BufferToString,o.prototype.write=t.BufferWrite,e.supportsStreams){var i=a(2203).Readable;i.prototype.setEncoding=t.ReadableSetEncoding,delete i.prototype.collect}t=void 0}}}},1239:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(94227),i=a(62586),n={keyword:"if",schemaType:["object","boolean"],trackErrors:!0,error:{message:({params:e})=>o.str`should match "${e.ifClause}" schema`,params:({params:e})=>o._`{failingKeyword: ${e.ifClause}}`},code(e){const{gen:t,parentSchema:a,it:r}=e;void 0===a.then&&void 0===a.else&&i.checkStrictMode(r,'"if" without "then" and "else" is ignored');const n=hasSchema(r,"then"),s=hasSchema(r,"else");if(!n&&!s)return;const c=t.let("valid",!0),p=t.name("_valid");if(function validateIf(){const t=e.subschema({keyword:"if",compositeRule:!0,createErrors:!1,allErrors:!1},p);e.mergeEvaluated(t)}(),e.reset(),n&&s){const a=t.let("ifClause");e.setParams({ifClause:a}),t.if(p,validateClause("then",a),validateClause("else",a))}else n?t.if(p,validateClause("then")):t.if(o.not(p),validateClause("else"));function validateClause(a,r){return()=>{const i=e.subschema({keyword:a},p);t.assign(c,p),e.mergeValidEvaluated(i,c),r?t.assign(r,o._`${a}`):e.setParams({ifClause:a})}}e.pass(c,()=>e.error(!0))}};function hasSchema(e,t){const a=e.schema[t];return void 0!==a&&!r.alwaysValidSchema(e,a)}t.default=n},1294:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.PromptArgumentSchema=t.ResourceUpdatedNotificationSchema=t.UnsubscribeRequestSchema=t.SubscribeRequestSchema=t.ResourceListChangedNotificationSchema=t.ReadResourceResultSchema=t.ReadResourceRequestSchema=t.ListResourceTemplatesResultSchema=t.ListResourceTemplatesRequestSchema=t.ListResourcesResultSchema=t.ListResourcesRequestSchema=t.ResourceTemplateSchema=t.ResourceSchema=t.BlobResourceContentsSchema=t.TextResourceContentsSchema=t.ResourceContentsSchema=t.PaginatedResultSchema=t.PaginatedRequestSchema=t.ProgressNotificationSchema=t.ProgressSchema=t.PingRequestSchema=t.isInitializedNotification=t.InitializedNotificationSchema=t.InitializeResultSchema=t.ServerCapabilitiesSchema=t.isInitializeRequest=t.InitializeRequestSchema=t.ClientCapabilitiesSchema=t.ImplementationSchema=t.CancelledNotificationSchema=t.EmptyResultSchema=t.JSONRPCMessageSchema=t.isJSONRPCError=t.JSONRPCErrorSchema=t.ErrorCode=t.isJSONRPCResponse=t.JSONRPCResponseSchema=t.isJSONRPCNotification=t.JSONRPCNotificationSchema=t.isJSONRPCRequest=t.JSONRPCRequestSchema=t.RequestIdSchema=t.ResultSchema=t.NotificationSchema=t.RequestSchema=t.CursorSchema=t.ProgressTokenSchema=t.JSONRPC_VERSION=t.SUPPORTED_PROTOCOL_VERSIONS=t.LATEST_PROTOCOL_VERSION=void 0,t.McpError=t.ServerResultSchema=t.ServerNotificationSchema=t.ServerRequestSchema=t.ClientResultSchema=t.ClientNotificationSchema=t.ClientRequestSchema=t.RootsListChangedNotificationSchema=t.ListRootsResultSchema=t.ListRootsRequestSchema=t.RootSchema=t.CompleteResultSchema=t.CompleteRequestSchema=t.PromptReferenceSchema=t.ResourceReferenceSchema=t.CreateMessageResultSchema=t.CreateMessageRequestSchema=t.SamplingMessageSchema=t.ModelPreferencesSchema=t.ModelHintSchema=t.LoggingMessageNotificationSchema=t.SetLevelRequestSchema=t.LoggingLevelSchema=t.ToolListChangedNotificationSchema=t.CallToolRequestSchema=t.CompatibilityCallToolResultSchema=t.CallToolResultSchema=t.ListToolsResultSchema=t.ListToolsRequestSchema=t.ToolSchema=t.ToolAnnotationsSchema=t.PromptListChangedNotificationSchema=t.GetPromptResultSchema=t.PromptMessageSchema=t.EmbeddedResourceSchema=t.AudioContentSchema=t.ImageContentSchema=t.TextContentSchema=t.GetPromptRequestSchema=t.ListPromptsResultSchema=t.ListPromptsRequestSchema=t.PromptSchema=void 0;const o=a(21614);t.LATEST_PROTOCOL_VERSION="2025-03-26",t.SUPPORTED_PROTOCOL_VERSIONS=[t.LATEST_PROTOCOL_VERSION,"2024-11-05","2024-10-07"],t.JSONRPC_VERSION="2.0",t.ProgressTokenSchema=o.z.union([o.z.string(),o.z.number().int()]),t.CursorSchema=o.z.string();const r=o.z.object({progressToken:o.z.optional(t.ProgressTokenSchema)}).passthrough(),i=o.z.object({_meta:o.z.optional(r)}).passthrough();t.RequestSchema=o.z.object({method:o.z.string(),params:o.z.optional(i)});const n=o.z.object({_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.NotificationSchema=o.z.object({method:o.z.string(),params:o.z.optional(n)}),t.ResultSchema=o.z.object({_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough(),t.RequestIdSchema=o.z.union([o.z.string(),o.z.number().int()]),t.JSONRPCRequestSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION),id:t.RequestIdSchema}).merge(t.RequestSchema).strict();t.isJSONRPCRequest=e=>t.JSONRPCRequestSchema.safeParse(e).success,t.JSONRPCNotificationSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION)}).merge(t.NotificationSchema).strict();t.isJSONRPCNotification=e=>t.JSONRPCNotificationSchema.safeParse(e).success,t.JSONRPCResponseSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION),id:t.RequestIdSchema,result:t.ResultSchema}).strict();var s;t.isJSONRPCResponse=e=>t.JSONRPCResponseSchema.safeParse(e).success,function(e){e[e.ConnectionClosed=-32e3]="ConnectionClosed",e[e.RequestTimeout=-32001]="RequestTimeout",e[e.ParseError=-32700]="ParseError",e[e.InvalidRequest=-32600]="InvalidRequest",e[e.MethodNotFound=-32601]="MethodNotFound",e[e.InvalidParams=-32602]="InvalidParams",e[e.InternalError=-32603]="InternalError"}(s||(t.ErrorCode=s={})),t.JSONRPCErrorSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION),id:t.RequestIdSchema,error:o.z.object({code:o.z.number().int(),message:o.z.string(),data:o.z.optional(o.z.unknown())})}).strict();t.isJSONRPCError=e=>t.JSONRPCErrorSchema.safeParse(e).success,t.JSONRPCMessageSchema=o.z.union([t.JSONRPCRequestSchema,t.JSONRPCNotificationSchema,t.JSONRPCResponseSchema,t.JSONRPCErrorSchema]),t.EmptyResultSchema=t.ResultSchema.strict(),t.CancelledNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/cancelled"),params:n.extend({requestId:t.RequestIdSchema,reason:o.z.string().optional()})}),t.ImplementationSchema=o.z.object({name:o.z.string(),version:o.z.string()}).passthrough(),t.ClientCapabilitiesSchema=o.z.object({experimental:o.z.optional(o.z.object({}).passthrough()),sampling:o.z.optional(o.z.object({}).passthrough()),roots:o.z.optional(o.z.object({listChanged:o.z.optional(o.z.boolean())}).passthrough())}).passthrough(),t.InitializeRequestSchema=t.RequestSchema.extend({method:o.z.literal("initialize"),params:i.extend({protocolVersion:o.z.string(),capabilities:t.ClientCapabilitiesSchema,clientInfo:t.ImplementationSchema})});t.isInitializeRequest=e=>t.InitializeRequestSchema.safeParse(e).success,t.ServerCapabilitiesSchema=o.z.object({experimental:o.z.optional(o.z.object({}).passthrough()),logging:o.z.optional(o.z.object({}).passthrough()),completions:o.z.optional(o.z.object({}).passthrough()),prompts:o.z.optional(o.z.object({listChanged:o.z.optional(o.z.boolean())}).passthrough()),resources:o.z.optional(o.z.object({subscribe:o.z.optional(o.z.boolean()),listChanged:o.z.optional(o.z.boolean())}).passthrough()),tools:o.z.optional(o.z.object({listChanged:o.z.optional(o.z.boolean())}).passthrough())}).passthrough(),t.InitializeResultSchema=t.ResultSchema.extend({protocolVersion:o.z.string(),capabilities:t.ServerCapabilitiesSchema,serverInfo:t.ImplementationSchema,instructions:o.z.optional(o.z.string())}),t.InitializedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/initialized")});t.isInitializedNotification=e=>t.InitializedNotificationSchema.safeParse(e).success,t.PingRequestSchema=t.RequestSchema.extend({method:o.z.literal("ping")}),t.ProgressSchema=o.z.object({progress:o.z.number(),total:o.z.optional(o.z.number())}).passthrough(),t.ProgressNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/progress"),params:n.merge(t.ProgressSchema).extend({progressToken:t.ProgressTokenSchema})}),t.PaginatedRequestSchema=t.RequestSchema.extend({params:i.extend({cursor:o.z.optional(t.CursorSchema)}).optional()}),t.PaginatedResultSchema=t.ResultSchema.extend({nextCursor:o.z.optional(t.CursorSchema)}),t.ResourceContentsSchema=o.z.object({uri:o.z.string(),mimeType:o.z.optional(o.z.string())}).passthrough(),t.TextResourceContentsSchema=t.ResourceContentsSchema.extend({text:o.z.string()}),t.BlobResourceContentsSchema=t.ResourceContentsSchema.extend({blob:o.z.string().base64()}),t.ResourceSchema=o.z.object({uri:o.z.string(),name:o.z.string(),description:o.z.optional(o.z.string()),mimeType:o.z.optional(o.z.string())}).passthrough(),t.ResourceTemplateSchema=o.z.object({uriTemplate:o.z.string(),name:o.z.string(),description:o.z.optional(o.z.string()),mimeType:o.z.optional(o.z.string())}).passthrough(),t.ListResourcesRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("resources/list")}),t.ListResourcesResultSchema=t.PaginatedResultSchema.extend({resources:o.z.array(t.ResourceSchema)}),t.ListResourceTemplatesRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("resources/templates/list")}),t.ListResourceTemplatesResultSchema=t.PaginatedResultSchema.extend({resourceTemplates:o.z.array(t.ResourceTemplateSchema)}),t.ReadResourceRequestSchema=t.RequestSchema.extend({method:o.z.literal("resources/read"),params:i.extend({uri:o.z.string()})}),t.ReadResourceResultSchema=t.ResultSchema.extend({contents:o.z.array(o.z.union([t.TextResourceContentsSchema,t.BlobResourceContentsSchema]))}),t.ResourceListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/resources/list_changed")}),t.SubscribeRequestSchema=t.RequestSchema.extend({method:o.z.literal("resources/subscribe"),params:i.extend({uri:o.z.string()})}),t.UnsubscribeRequestSchema=t.RequestSchema.extend({method:o.z.literal("resources/unsubscribe"),params:i.extend({uri:o.z.string()})}),t.ResourceUpdatedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/resources/updated"),params:n.extend({uri:o.z.string()})}),t.PromptArgumentSchema=o.z.object({name:o.z.string(),description:o.z.optional(o.z.string()),required:o.z.optional(o.z.boolean())}).passthrough(),t.PromptSchema=o.z.object({name:o.z.string(),description:o.z.optional(o.z.string()),arguments:o.z.optional(o.z.array(t.PromptArgumentSchema))}).passthrough(),t.ListPromptsRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("prompts/list")}),t.ListPromptsResultSchema=t.PaginatedResultSchema.extend({prompts:o.z.array(t.PromptSchema)}),t.GetPromptRequestSchema=t.RequestSchema.extend({method:o.z.literal("prompts/get"),params:i.extend({name:o.z.string(),arguments:o.z.optional(o.z.record(o.z.string()))})}),t.TextContentSchema=o.z.object({type:o.z.literal("text"),text:o.z.string()}).passthrough(),t.ImageContentSchema=o.z.object({type:o.z.literal("image"),data:o.z.string().base64(),mimeType:o.z.string()}).passthrough(),t.AudioContentSchema=o.z.object({type:o.z.literal("audio"),data:o.z.string().base64(),mimeType:o.z.string()}).passthrough(),t.EmbeddedResourceSchema=o.z.object({type:o.z.literal("resource"),resource:o.z.union([t.TextResourceContentsSchema,t.BlobResourceContentsSchema])}).passthrough(),t.PromptMessageSchema=o.z.object({role:o.z.enum(["user","assistant"]),content:o.z.union([t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema,t.EmbeddedResourceSchema])}).passthrough(),t.GetPromptResultSchema=t.ResultSchema.extend({description:o.z.optional(o.z.string()),messages:o.z.array(t.PromptMessageSchema)}),t.PromptListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/prompts/list_changed")}),t.ToolAnnotationsSchema=o.z.object({title:o.z.optional(o.z.string()),readOnlyHint:o.z.optional(o.z.boolean()),destructiveHint:o.z.optional(o.z.boolean()),idempotentHint:o.z.optional(o.z.boolean()),openWorldHint:o.z.optional(o.z.boolean())}).passthrough(),t.ToolSchema=o.z.object({name:o.z.string(),description:o.z.optional(o.z.string()),inputSchema:o.z.object({type:o.z.literal("object"),properties:o.z.optional(o.z.object({}).passthrough())}).passthrough(),annotations:o.z.optional(t.ToolAnnotationsSchema)}).passthrough(),t.ListToolsRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("tools/list")}),t.ListToolsResultSchema=t.PaginatedResultSchema.extend({tools:o.z.array(t.ToolSchema)}),t.CallToolResultSchema=t.ResultSchema.extend({content:o.z.array(o.z.union([t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema,t.EmbeddedResourceSchema])),isError:o.z.boolean().default(!1).optional()}),t.CompatibilityCallToolResultSchema=t.CallToolResultSchema.or(t.ResultSchema.extend({toolResult:o.z.unknown()})),t.CallToolRequestSchema=t.RequestSchema.extend({method:o.z.literal("tools/call"),params:i.extend({name:o.z.string(),arguments:o.z.optional(o.z.record(o.z.unknown()))})}),t.ToolListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/tools/list_changed")}),t.LoggingLevelSchema=o.z.enum(["debug","info","notice","warning","error","critical","alert","emergency"]),t.SetLevelRequestSchema=t.RequestSchema.extend({method:o.z.literal("logging/setLevel"),params:i.extend({level:t.LoggingLevelSchema})}),t.LoggingMessageNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/message"),params:n.extend({level:t.LoggingLevelSchema,logger:o.z.optional(o.z.string()),data:o.z.unknown()})}),t.ModelHintSchema=o.z.object({name:o.z.string().optional()}).passthrough(),t.ModelPreferencesSchema=o.z.object({hints:o.z.optional(o.z.array(t.ModelHintSchema)),costPriority:o.z.optional(o.z.number().min(0).max(1)),speedPriority:o.z.optional(o.z.number().min(0).max(1)),intelligencePriority:o.z.optional(o.z.number().min(0).max(1))}).passthrough(),t.SamplingMessageSchema=o.z.object({role:o.z.enum(["user","assistant"]),content:o.z.union([t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema])}).passthrough(),t.CreateMessageRequestSchema=t.RequestSchema.extend({method:o.z.literal("sampling/createMessage"),params:i.extend({messages:o.z.array(t.SamplingMessageSchema),systemPrompt:o.z.optional(o.z.string()),includeContext:o.z.optional(o.z.enum(["none","thisServer","allServers"])),temperature:o.z.optional(o.z.number()),maxTokens:o.z.number().int(),stopSequences:o.z.optional(o.z.array(o.z.string())),metadata:o.z.optional(o.z.object({}).passthrough()),modelPreferences:o.z.optional(t.ModelPreferencesSchema)})}),t.CreateMessageResultSchema=t.ResultSchema.extend({model:o.z.string(),stopReason:o.z.optional(o.z.enum(["endTurn","stopSequence","maxTokens"]).or(o.z.string())),role:o.z.enum(["user","assistant"]),content:o.z.discriminatedUnion("type",[t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema])}),t.ResourceReferenceSchema=o.z.object({type:o.z.literal("ref/resource"),uri:o.z.string()}).passthrough(),t.PromptReferenceSchema=o.z.object({type:o.z.literal("ref/prompt"),name:o.z.string()}).passthrough(),t.CompleteRequestSchema=t.RequestSchema.extend({method:o.z.literal("completion/complete"),params:i.extend({ref:o.z.union([t.PromptReferenceSchema,t.ResourceReferenceSchema]),argument:o.z.object({name:o.z.string(),value:o.z.string()}).passthrough()})}),t.CompleteResultSchema=t.ResultSchema.extend({completion:o.z.object({values:o.z.array(o.z.string()).max(100),total:o.z.optional(o.z.number().int()),hasMore:o.z.optional(o.z.boolean())}).passthrough()}),t.RootSchema=o.z.object({uri:o.z.string().startsWith("file://"),name:o.z.optional(o.z.string())}).passthrough(),t.ListRootsRequestSchema=t.RequestSchema.extend({method:o.z.literal("roots/list")}),t.ListRootsResultSchema=t.ResultSchema.extend({roots:o.z.array(t.RootSchema)}),t.RootsListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/roots/list_changed")}),t.ClientRequestSchema=o.z.union([t.PingRequestSchema,t.InitializeRequestSchema,t.CompleteRequestSchema,t.SetLevelRequestSchema,t.GetPromptRequestSchema,t.ListPromptsRequestSchema,t.ListResourcesRequestSchema,t.ListResourceTemplatesRequestSchema,t.ReadResourceRequestSchema,t.SubscribeRequestSchema,t.UnsubscribeRequestSchema,t.CallToolRequestSchema,t.ListToolsRequestSchema]),t.ClientNotificationSchema=o.z.union([t.CancelledNotificationSchema,t.ProgressNotificationSchema,t.InitializedNotificationSchema,t.RootsListChangedNotificationSchema]),t.ClientResultSchema=o.z.union([t.EmptyResultSchema,t.CreateMessageResultSchema,t.ListRootsResultSchema]),t.ServerRequestSchema=o.z.union([t.PingRequestSchema,t.CreateMessageRequestSchema,t.ListRootsRequestSchema]),t.ServerNotificationSchema=o.z.union([t.CancelledNotificationSchema,t.ProgressNotificationSchema,t.LoggingMessageNotificationSchema,t.ResourceUpdatedNotificationSchema,t.ResourceListChangedNotificationSchema,t.ToolListChangedNotificationSchema,t.PromptListChangedNotificationSchema]),t.ServerResultSchema=o.z.union([t.EmptyResultSchema,t.InitializeResultSchema,t.CompleteResultSchema,t.GetPromptResultSchema,t.ListPromptsResultSchema,t.ListResourcesResultSchema,t.ListResourceTemplatesResultSchema,t.ReadResourceResultSchema,t.CallToolResultSchema,t.ListToolsResultSchema]);class McpError extends Error{constructor(e,t,a){super(`MCP error ${e}: ${t}`),this.code=e,this.data=a,this.name="McpError"}}t.McpError=McpError},1372:(e,t,a)=>{const o=a(30677);e.exports=function(e){return e={allowMethods:"GET,HEAD,PUT,POST,DELETE,PATCH",secureContext:!1,...e},Array.isArray(e.exposeHeaders)&&(e.exposeHeaders=e.exposeHeaders.join(",")),Array.isArray(e.allowMethods)&&(e.allowMethods=e.allowMethods.join(",")),Array.isArray(e.allowHeaders)&&(e.allowHeaders=e.allowHeaders.join(",")),e.maxAge&&(e.maxAge=String(e.maxAge)),e.keepHeadersOnError=void 0===e.keepHeadersOnError||!!e.keepHeadersOnError,async function cors(t,a){const r=t.get("Origin");let i,n;if(t.vary("Origin"),"function"==typeof e.origin){if(i=await e.origin(t),!i)return await a()}else i=e.origin||"*";n="function"==typeof e.credentials?await e.credentials(t):!!e.credentials,n&&"*"===i&&(i=r);const s={};function set(e,a){t.set(e,a),s[e]=a}if("OPTIONS"!==t.method){if(set("Access-Control-Allow-Origin",i),!0===n&&set("Access-Control-Allow-Credentials","true"),e.exposeHeaders&&set("Access-Control-Expose-Headers",e.exposeHeaders),e.secureContext&&(set("Cross-Origin-Opener-Policy","same-origin"),set("Cross-Origin-Embedder-Policy","require-corp")),!e.keepHeadersOnError)return await a();try{return await a()}catch(e){const t=e.headers||{},a=o.append(t.vary||t.Vary||"","Origin");throw delete t.Vary,e.headers={...t,...s,vary:a},e}}else{if(!t.get("Access-Control-Request-Method"))return await a();t.set("Access-Control-Allow-Origin",i),!0===n&&t.set("Access-Control-Allow-Credentials","true"),e.maxAge&&t.set("Access-Control-Max-Age",e.maxAge),e.privateNetworkAccess&&t.get("Access-Control-Request-Private-Network")&&t.set("Access-Control-Allow-Private-Network","true"),e.allowMethods&&t.set("Access-Control-Allow-Methods",e.allowMethods),e.secureContext&&(set("Cross-Origin-Opener-Policy","same-origin"),set("Cross-Origin-Embedder-Policy","require-corp"));let o=e.allowHeaders;o||(o=t.get("Access-Control-Request-Headers")),o&&t.set("Access-Control-Allow-Headers",o),t.status=204}}}},1708:e=>{"use strict";e.exports=require("node:process")},2190:e=>{var t={"prs.":100,"x-":200,"x.":300,"vnd.":400,default:900},a={nginx:10,apache:20,iana:40,default:30},o={application:1,font:2,default:0};e.exports=function mimeScore(e,r="default"){if("application/octet-stream"===e)return 0;const[i,n]=e.split("/"),s=n.replace(/(\.|x-).*/,"$1");return(t[s]||t.default)+(a[r]||a.default)+(o[i]||o.default)+(1-e.length/100)}},2203:e=>{"use strict";e.exports=require("stream")},2538:(e,t,a)=>{var o=a(76982),r=a(87016).parse,i=["acl","location","logging","notification","partNumber","policy","requestPayment","torrent","uploadId","uploads","versionId","versioning","versions","website"];function authorization(e){return"AWS "+e.key+":"+sign(e)}function hmacSha1(e){return o.createHmac("sha1",e.secret).update(e.message).digest("base64")}function sign(e){return e.message=stringToSign(e),hmacSha1(e)}function stringToSign(e){var t=e.amazonHeaders||"";return t&&(t+="\n"),[e.verb,e.md5,e.contentType,e.date?e.date.toUTCString():"",t+e.resource].join("\n")}function queryStringToSign(e){return"GET\n\n\n"+e.date+"\n"+e.resource}e.exports=authorization,e.exports.authorization=authorization,e.exports.hmacSha1=hmacSha1,e.exports.sign=sign,e.exports.signQuery=function signQuery(e){return e.message=queryStringToSign(e),hmacSha1(e)},e.exports.stringToSign=stringToSign,e.exports.queryStringToSign=queryStringToSign,e.exports.canonicalizeHeaders=function canonicalizeHeaders(e){for(var t=[],a=Object.keys(e),o=0,r=a.length;o<r;++o){var i,n=e[i=a[o]];0===(i=i.toLowerCase()).indexOf("x-amz")&&t.push(i+":"+n)}return t.sort().join("\n")},e.exports.canonicalizeResource=function canonicalizeResource(e){var t=r(e,!0),a=t.pathname,o=[];return Object.keys(t.query).forEach(function(e){if(~i.indexOf(e)){var a=""==t.query[e]?"":"="+encodeURIComponent(t.query[e]);o.push(e+a)}}),a+(o.length?"?"+o.sort().join("&"):"")}},3319:(e,t,a)=>{var o=a(42613),r=a(54774).Buffer,i=a(16299),n=a(76395).newInvalidAsn1Error;function Reader(e){if(!e||!r.isBuffer(e))throw new TypeError("data must be a node Buffer");this._buf=e,this._size=e.length,this._len=0,this._offset=0}Object.defineProperty(Reader.prototype,"length",{enumerable:!0,get:function(){return this._len}}),Object.defineProperty(Reader.prototype,"offset",{enumerable:!0,get:function(){return this._offset}}),Object.defineProperty(Reader.prototype,"remain",{get:function(){return this._size-this._offset}}),Object.defineProperty(Reader.prototype,"buffer",{get:function(){return this._buf.slice(this._offset)}}),Reader.prototype.readByte=function(e){if(this._size-this._offset<1)return null;var t=255&this._buf[this._offset];return e||(this._offset+=1),t},Reader.prototype.peek=function(){return this.readByte(!0)},Reader.prototype.readLength=function(e){if(void 0===e&&(e=this._offset),e>=this._size)return null;var t=255&this._buf[e++];if(null===t)return null;if(128&~t)this._len=t;else{if(0===(t&=127))throw n("Indefinite length not supported");if(t>4)throw n("encoding too long");if(this._size-e<t)return null;this._len=0;for(var a=0;a<t;a++)this._len=(this._len<<8)+(255&this._buf[e++])}return e},Reader.prototype.readSequence=function(e){var t=this.peek();if(null===t)return null;if(void 0!==e&&e!==t)throw n("Expected 0x"+e.toString(16)+": got 0x"+t.toString(16));var a=this.readLength(this._offset+1);return null===a?null:(this._offset=a,t)},Reader.prototype.readInt=function(){return this._readTag(i.Integer)},Reader.prototype.readBoolean=function(){return 0!==this._readTag(i.Boolean)},Reader.prototype.readEnumeration=function(){return this._readTag(i.Enumeration)},Reader.prototype.readString=function(e,t){e||(e=i.OctetString);var a=this.peek();if(null===a)return null;if(a!==e)throw n("Expected 0x"+e.toString(16)+": got 0x"+a.toString(16));var o=this.readLength(this._offset+1);if(null===o)return null;if(this.length>this._size-o)return null;if(this._offset=o,0===this.length)return t?r.alloc(0):"";var s=this._buf.slice(this._offset,this._offset+this.length);return this._offset+=this.length,t?s:s.toString("utf8")},Reader.prototype.readOID=function(e){e||(e=i.OID);var t=this.readString(e,!0);if(null===t)return null;for(var a=[],o=0,r=0;r<t.length;r++){var n=255&t[r];o<<=7,o+=127&n,128&n||(a.push(o),o=0)}return o=a.shift(),a.unshift(o%40),a.unshift(o/40|0),a.join(".")},Reader.prototype._readTag=function(e){o.ok(void 0!==e);var t=this.peek();if(null===t)return null;if(t!==e)throw n("Expected 0x"+e.toString(16)+": got 0x"+t.toString(16));var a=this.readLength(this._offset+1);if(null===a)return null;if(this.length>4)throw n("Integer too long: "+this.length);if(this.length>this._size-a)return null;this._offset=a;for(var r=this._buf[this._offset],i=0,s=0;s<this.length;s++)i<<=8,i|=255&this._buf[this._offset++];return 128&~r||4===s||(i-=1<<8*s),i|0},e.exports=Reader},3927:(e,t,a)=>{"use strict";a(69278);var o,r=a(64756),i=a(58611),n=a(65692),s=a(24434),c=a(42613),p=a(39023),u=a(92861).Buffer;function TunnelingAgent(e){var t=this;t.options=e||{},t.proxyOptions=t.options.proxy||{},t.maxSockets=t.options.maxSockets||i.Agent.defaultMaxSockets,t.requests=[],t.sockets=[],t.on("free",function onFree(e,a,o){for(var r=0,i=t.requests.length;r<i;++r){var n=t.requests[r];if(n.host===a&&n.port===o)return t.requests.splice(r,1),void n.request.onSocket(e)}e.destroy(),t.removeSocket(e)})}function createSecureSocket(e,t){var a=this;TunnelingAgent.prototype.createSocket.call(a,e,function(o){var i=r.connect(0,mergeOptions({},a.options,{servername:e.host,socket:o}));a.sockets[a.sockets.indexOf(o)]=i,t(i)})}function mergeOptions(e){for(var t=1,a=arguments.length;t<a;++t){var o=arguments[t];if("object"==typeof o)for(var r=Object.keys(o),i=0,n=r.length;i<n;++i){var s=r[i];void 0!==o[s]&&(e[s]=o[s])}}return e}t.httpOverHttp=function httpOverHttp(e){var t=new TunnelingAgent(e);return t.request=i.request,t},t.httpsOverHttp=function httpsOverHttp(e){var t=new TunnelingAgent(e);return t.request=i.request,t.createSocket=createSecureSocket,t.defaultPort=443,t},t.httpOverHttps=function httpOverHttps(e){var t=new TunnelingAgent(e);return t.request=n.request,t},t.httpsOverHttps=function httpsOverHttps(e){var t=new TunnelingAgent(e);return t.request=n.request,t.createSocket=createSecureSocket,t.defaultPort=443,t},p.inherits(TunnelingAgent,s.EventEmitter),TunnelingAgent.prototype.addRequest=function addRequest(e,t){var a=this;"string"==typeof t&&(t={host:t,port:arguments[2],path:arguments[3]}),a.sockets.length>=this.maxSockets?a.requests.push({host:t.host,port:t.port,request:e}):a.createConnection({host:t.host,port:t.port,request:e})},TunnelingAgent.prototype.createConnection=function createConnection(e){var t=this;t.createSocket(e,function(a){function onFree(){t.emit("free",a,e.host,e.port)}function onCloseOrRemove(e){t.removeSocket(a),a.removeListener("free",onFree),a.removeListener("close",onCloseOrRemove),a.removeListener("agentRemove",onCloseOrRemove)}a.on("free",onFree),a.on("close",onCloseOrRemove),a.on("agentRemove",onCloseOrRemove),e.request.onSocket(a)})},TunnelingAgent.prototype.createSocket=function createSocket(e,t){var a=this,r={};a.sockets.push(r);var i=mergeOptions({},a.proxyOptions,{method:"CONNECT",path:e.host+":"+e.port,agent:!1});i.proxyAuth&&(i.headers=i.headers||{},i.headers["Proxy-Authorization"]="Basic "+u.from(i.proxyAuth).toString("base64")),o("making CONNECT request");var n=a.request(i);function onConnect(i,s,p){if(n.removeAllListeners(),s.removeAllListeners(),200===i.statusCode)c.equal(p.length,0),o("tunneling connection has established"),a.sockets[a.sockets.indexOf(r)]=s,t(s);else{o("tunneling socket could not be established, statusCode=%d",i.statusCode);var u=new Error("tunneling socket could not be established, statusCode="+i.statusCode);u.code="ECONNRESET",e.request.emit("error",u),a.removeSocket(r)}}n.useChunkedEncodingByDefault=!1,n.once("response",function onResponse(e){e.upgrade=!0}),n.once("upgrade",function onUpgrade(e,t,a){process.nextTick(function(){onConnect(e,t,a)})}),n.once("connect",onConnect),n.once("error",function onError(t){n.removeAllListeners(),o("tunneling socket could not be established, cause=%s\n",t.message,t.stack);var i=new Error("tunneling socket could not be established, cause="+t.message);i.code="ECONNRESET",e.request.emit("error",i),a.removeSocket(r)}),n.end()},TunnelingAgent.prototype.removeSocket=function removeSocket(e){var t=this.sockets.indexOf(e);if(-1!==t){this.sockets.splice(t,1);var a=this.requests.shift();a&&this.createConnection(a)}},o=process.env.NODE_DEBUG&&/\btunnel\b/.test(process.env.NODE_DEBUG)?function(){var e=Array.prototype.slice.call(arguments);"string"==typeof e[0]?e[0]="TUNNEL: "+e[0]:e.unshift("TUNNEL:"),console.error.apply(console,e)}:function(){},t.debug=o},4022:(e,t,a)=>{var o,r=a(10617),i=a(14117),n=a(7964);function validate(e,t){t=t||{};var s=(o=o||function createAjvInstance(){var e=new r({allErrors:!0});return e.addMetaSchema(a(64499)),e.addSchema(n),e}()).getSchema(e+".json");return new Promise(function(e,a){s(t)?e(t):a(new i(s.errors))})}t.afterRequest=function(e){return validate("afterRequest",e)},t.beforeRequest=function(e){return validate("beforeRequest",e)},t.browser=function(e){return validate("browser",e)},t.cache=function(e){return validate("cache",e)},t.content=function(e){return validate("content",e)},t.cookie=function(e){return validate("cookie",e)},t.creator=function(e){return validate("creator",e)},t.entry=function(e){return validate("entry",e)},t.har=function(e){return validate("har",e)},t.header=function(e){return validate("header",e)},t.log=function(e){return validate("log",e)},t.page=function(e){return validate("page",e)},t.pageTimings=function(e){return validate("pageTimings",e)},t.postData=function(e){return validate("postData",e)},t.query=function(e){return validate("query",e)},t.request=function(e){return validate("request",e)},t.response=function(e){return validate("response",e)},t.timings=function(e){return validate("timings",e)}},4042:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.CodeGen=t.Name=t.nil=t.stringify=t.str=t._=t.KeywordCxt=void 0;const o=a(13056);t.KeywordCxt=o.default;var r=a(99029);Object.defineProperty(t,"_",{enumerable:!0,get:function(){return r._}}),Object.defineProperty(t,"str",{enumerable:!0,get:function(){return r.str}}),Object.defineProperty(t,"stringify",{enumerable:!0,get:function(){return r.stringify}}),Object.defineProperty(t,"nil",{enumerable:!0,get:function(){return r.nil}}),Object.defineProperty(t,"Name",{enumerable:!0,get:function(){return r.Name}}),Object.defineProperty(t,"CodeGen",{enumerable:!0,get:function(){return r.CodeGen}});const i=a(34050),n=a(10396),s=a(73835),c=a(99029),p=a(66939),u=a(10208),l=a(94227),m=a(63837),f=["removeAdditional","useDefaults","coerceTypes"],h=new Set(["validate","serialize","parse","wrapper","root","schema","keyword","pattern","formats","validate$data","func","obj","Error"]),g={errorDataPath:"",format:"`validateFormats: false` can be used instead.",nullable:'"nullable" keyword is supported by default.',jsonPointers:"Deprecated jsPropertySyntax can be used instead.",extendRefs:"Deprecated ignoreKeywordsWithRef can be used instead.",missingRefs:"Pass empty schema with $id that should be ignored to ajv.addSchema.",processCode:"Use option `code: {process: (code, schemaEnv: object) => string}`",sourceCode:"Use option `code: {source: true}`",schemaId:"JSON Schema draft-04 is not supported in Ajv v7.",strictDefaults:"It is default now, see option `strict`.",strictKeywords:"It is default now, see option `strict`.",strictNumbers:"It is default now, see option `strict`.",uniqueItems:'"uniqueItems" keyword is always validated.',unknownFormats:"Disable strict mode or pass `true` to `ajv.addFormat` (or `formats` option).",cache:"Map is used as cache, schema object as key.",serialize:"Map is used as cache, schema object as key."},y={ignoreKeywordsWithRef:"",jsPropertySyntax:"",unicode:'"minLength"/"maxLength" account for unicode characters by default.'};function requiredOptions(e){var t,a,o,r,i,n,s,c,p,u,l,m;const f=null===(t=e.strict)||void 0===t||t,h=!!f&&"log",g=null===(a=e.code)||void 0===a?void 0:a.optimize,y=!0===g||void 0===g?1:g||0;return{strict:f,strictTypes:null!==(o=e.strictTypes)&&void 0!==o?o:h,strictTuples:null!==(r=e.strictTuples)&&void 0!==r?r:h,code:e.code?{...e.code,optimize:y}:{optimize:y},loopRequired:null!==(i=e.loopRequired)&&void 0!==i?i:1/0,loopEnum:null!==(n=e.loopEnum)&&void 0!==n?n:1/0,meta:null===(s=e.meta)||void 0===s||s,messages:null===(c=e.messages)||void 0===c||c,inlineRefs:null===(p=e.inlineRefs)||void 0===p||p,addUsedSchema:null===(u=e.addUsedSchema)||void 0===u||u,validateSchema:null===(l=e.validateSchema)||void 0===l||l,validateFormats:null===(m=e.validateFormats)||void 0===m||m}}class Ajv{constructor(e={}){this.schemas={},this.refs={},this.formats={},this._compilations=new Set,this._loading={},this._cache=new Map,e=this.opts={...e,...requiredOptions(e)};const{es5:t,lines:a}=this.opts.code;this.scope=new c.ValueScope({scope:{},prefixes:h,es5:t,lines:a}),this.logger=function getLogger(e){if(!1===e)return b;if(void 0===e)return console;if(e.log&&e.warn&&e.error)return e;throw new Error("logger must implement log, warn and error methods")}(e.logger);const o=e.validateFormats;e.validateFormats=!1,this.RULES=n.getRules(),checkOptions.call(this,g,e,"NOT SUPPORTED"),checkOptions.call(this,y,e,"DEPRECATED","warn"),this._metaOpts=getMetaSchemaOptions.call(this),e.formats&&addInitialFormats.call(this),this._addVocabularies(),this._addDefaultMetaSchema(),e.keywords&&addInitialKeywords.call(this,e.keywords),"object"==typeof e.meta&&this.addMetaSchema(e.meta),addInitialSchemas.call(this),e.validateFormats=o}_addVocabularies(){this.addKeyword("$async")}_addDefaultMetaSchema(){const{$data:e,meta:t}=this.opts;t&&e&&this.addMetaSchema(m,m.$id,!1)}defaultMeta(){const{meta:e}=this.opts;return this.opts.defaultMeta="object"==typeof e?e.$id||e:void 0}validate(e,t){let a;if("string"==typeof e){if(a=this.getSchema(e),!a)throw new Error(`no schema with key or ref "${e}"`)}else a=this.compile(e);const o=a(t);return"$async"in a||(this.errors=a.errors),o}compile(e,t){const a=this._addSchema(e,t);return a.validate||this._compileSchemaEnv(a)}compileAsync(e,t){if("function"!=typeof this.opts.loadSchema)throw new Error("options.loadSchema should be a function");const{loadSchema:a}=this.opts;return runCompileAsync.call(this,e,t);async function runCompileAsync(e,t){await loadMetaSchema.call(this,e.$schema);const a=this._addSchema(e,t);return a.validate||_compileAsync.call(this,a)}async function loadMetaSchema(e){e&&!this.getSchema(e)&&await runCompileAsync.call(this,{$ref:e},!0)}async function _compileAsync(e){try{return this._compileSchemaEnv(e)}catch(t){if(!(t instanceof i.MissingRefError))throw t;return checkLoaded.call(this,t),await loadMissingSchema.call(this,t.missingSchema),_compileAsync.call(this,e)}}function checkLoaded({missingSchema:e,missingRef:t}){if(this.refs[e])throw new Error(`AnySchema ${e} is loaded but ${t} cannot be resolved`)}async function loadMissingSchema(e){const a=await _loadSchema.call(this,e);this.refs[e]||await loadMetaSchema.call(this,a.$schema),this.refs[e]||this.addSchema(a,e,t)}async function _loadSchema(e){const t=this._loading[e];if(t)return t;try{return await(this._loading[e]=a(e))}finally{delete this._loading[e]}}}addSchema(e,t,a,o=this.opts.validateSchema){if(Array.isArray(e)){for(const t of e)this.addSchema(t,void 0,a,o);return this}let r;if("object"==typeof e&&(r=e.$id,void 0!==r&&"string"!=typeof r))throw new Error("schema id must be string");return t=p.normalizeId(t||r),this._checkUnique(t),this.schemas[t]=this._addSchema(e,a,o,!0),this}addMetaSchema(e,t,a=this.opts.validateSchema){return this.addSchema(e,t,!0,a),this}validateSchema(e,t){if("boolean"==typeof e)return!0;let a;if(a=e.$schema,void 0!==a&&"string"!=typeof a)throw new Error("$schema must be a string");if(a=a||this.opts.defaultMeta||this.defaultMeta(),!a)return this.logger.warn("meta-schema not available"),this.errors=null,!0;const o=this.validate(a,e);if(!o&&t){const e="schema is invalid: "+this.errorsText();if("log"!==this.opts.validateSchema)throw new Error(e);this.logger.error(e)}return o}getSchema(e){let t;for(;"string"==typeof(t=getSchEnv.call(this,e));)e=t;if(void 0===t){const a=new s.SchemaEnv({schema:{}});if(t=s.resolveSchema.call(this,a,e),!t)return;this.refs[e]=t}return t.validate||this._compileSchemaEnv(t)}removeSchema(e){if(e instanceof RegExp)return this._removeAllSchemas(this.schemas,e),this._removeAllSchemas(this.refs,e),this;switch(typeof e){case"undefined":return this._removeAllSchemas(this.schemas),this._removeAllSchemas(this.refs),this._cache.clear(),this;case"string":{const t=getSchEnv.call(this,e);return"object"==typeof t&&this._cache.delete(t.schema),delete this.schemas[e],delete this.refs[e],this}case"object":{const t=e;this._cache.delete(t);let a=e.$id;return a&&(a=p.normalizeId(a),delete this.schemas[a],delete this.refs[a]),this}default:throw new Error("ajv.removeSchema: invalid parameter")}}addVocabulary(e){for(const t of e)this.addKeyword(t);return this}addKeyword(e,t){let a;if("string"==typeof e)a=e,"object"==typeof t&&(this.logger.warn("these parameters are deprecated, see docs for addKeyword"),t.keyword=a);else{if("object"!=typeof e||void 0!==t)throw new Error("invalid addKeywords parameters");if(a=(t=e).keyword,Array.isArray(a)&&!a.length)throw new Error("addKeywords: keyword must be string or non-empty array")}if(checkKeyword.call(this,a,t),!t)return l.eachItem(a,e=>addRule.call(this,e)),this;keywordMetaschema.call(this,t);const o={...t,type:u.getJSONTypes(t.type),schemaType:u.getJSONTypes(t.schemaType)};return l.eachItem(a,0===o.type.length?e=>addRule.call(this,e,o):e=>o.type.forEach(t=>addRule.call(this,e,o,t))),this}getKeyword(e){const t=this.RULES.all[e];return"object"==typeof t?t.definition:!!t}removeKeyword(e){const{RULES:t}=this;delete t.keywords[e],delete t.all[e];for(const a of t.rules){const t=a.rules.findIndex(t=>t.keyword===e);t>=0&&a.rules.splice(t,1)}return this}addFormat(e,t){return"string"==typeof t&&(t=new RegExp(t)),this.formats[e]=t,this}errorsText(e=this.errors,{separator:t=", ",dataVar:a="data"}={}){return e&&0!==e.length?e.map(e=>`${a}${e.dataPath} ${e.message}`).reduce((e,a)=>e+t+a):"No errors"}$dataMetaSchema(e,t){const a=this.RULES.all;e=JSON.parse(JSON.stringify(e));for(const o of t){const t=o.split("/").slice(1);let r=e;for(const e of t)r=r[e];for(const e in a){const t=a[e];if("object"!=typeof t)continue;const{$data:o}=t.definition,i=r[e];o&&i&&(r[e]=schemaOrData(i))}}return e}_removeAllSchemas(e,t){for(const a in e){const o=e[a];t&&!t.test(a)||("string"==typeof o?delete e[a]:o&&!o.meta&&(this._cache.delete(o.schema),delete e[a]))}}_addSchema(e,t,a=this.opts.validateSchema,o=this.opts.addUsedSchema){if("object"!=typeof e){if(this.opts.jtd)throw new Error("schema must be object");if("boolean"!=typeof e)throw new Error("schema must be object or boolean")}let r=this._cache.get(e);if(void 0!==r)return r;const i=p.getSchemaRefs.call(this,e);r=new s.SchemaEnv({schema:e,meta:t,localRefs:i}),this._cache.set(r.schema,r);const n=r.baseId;return o&&!n.startsWith("#")&&(n&&this._checkUnique(n),this.refs[n]=r),a&&this.validateSchema(e,!0),r}_checkUnique(e){if(this.schemas[e]||this.refs[e])throw new Error(`schema with key or id "${e}" already exists`)}_compileSchemaEnv(e){if(e.meta?this._compileMetaSchema(e):s.compileSchema.call(this,e),!e.validate)throw new Error("ajv implementation error");return e.validate}_compileMetaSchema(e){const t=this.opts;this.opts=this._metaOpts;try{s.compileSchema.call(this,e)}finally{this.opts=t}}}function checkOptions(e,t,a,o="error"){for(const r in e){const i=r;i in t&&this.logger[o](`${a}: option ${r}. ${e[i]}`)}}function getSchEnv(e){return e=p.normalizeId(e),this.schemas[e]||this.refs[e]}function addInitialSchemas(){const e=this.opts.schemas;if(e)if(Array.isArray(e))this.addSchema(e);else for(const t in e)this.addSchema(e[t],t)}function addInitialFormats(){for(const e in this.opts.formats){const t=this.opts.formats[e];t&&this.addFormat(e,t)}}function addInitialKeywords(e){if(Array.isArray(e))this.addVocabulary(e);else{this.logger.warn("keywords option as map is deprecated, pass array");for(const t in e){const a=e[t];a.keyword||(a.keyword=t),this.addKeyword(a)}}}function getMetaSchemaOptions(){const e={...this.opts};for(const t of f)delete e[t];return e}t.default=Ajv,Ajv.ValidationError=i.ValidationError,Ajv.MissingRefError=i.MissingRefError;const b={log(){},warn(){},error(){}};const x=/^[a-z_$][a-z0-9_$:-]*$/i;function checkKeyword(e,t){const{RULES:a}=this;if(l.eachItem(e,e=>{if(a.keywords[e])throw new Error(`Keyword ${e} is already defined`);if(!x.test(e))throw new Error(`Keyword ${e} has invalid name`)}),t&&t.$data&&!("code"in t)&&!("validate"in t))throw new Error('$data keyword must have "code" or "validate" function')}function addRule(e,t,a){var o;const r=null==t?void 0:t.post;if(a&&r)throw new Error('keyword with "post" flag cannot have "type"');const{RULES:i}=this;let n=r?i.post:i.rules.find(({type:e})=>e===a);if(n||(n={type:a,rules:[]},i.rules.push(n)),i.keywords[e]=!0,!t)return;const s={keyword:e,definition:{...t,type:u.getJSONTypes(t.type),schemaType:u.getJSONTypes(t.schemaType)}};t.before?addBeforeRule.call(this,n,s,t.before):n.rules.push(s),i.all[e]=s,null===(o=t.implements)||void 0===o||o.forEach(e=>this.addKeyword(e))}function addBeforeRule(e,t,a){const o=e.rules.findIndex(e=>e.keyword===a);o>=0?e.rules.splice(o,0,t):(e.rules.push(t),this.logger.warn(`rule ${a} is not defined`))}function keywordMetaschema(e){let{metaSchema:t}=e;void 0!==t&&(e.$data&&this.opts.$data&&(t=schemaOrData(t)),e.validateSchema=this.compile(t,!0))}const w={$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"};function schemaOrData(e){return{anyOf:[e,w]}}},4047:(e,t,a)=>{e.exports={read:function read(e,t){"string"!=typeof e&&(o.buffer(e,"buf"),e=e.toString("ascii"));var a=e.split("\n");if(a[0].match(/^Private-key-format\: v1/)){var c=a[1].split(" "),u=parseInt(c[1],10),l=c[2];if(!p[u])throw new Error("Unsupported algorithm: "+l);return function readDNSSECPrivateKey(e,t){if(p[e].match(/^RSA-/))return function readDNSSECRSAPrivateKey(e){var t={};e.forEach(function(e){"Modulus:"===e.split(" ")[0]?t.n=elementToBuf(e):"PublicExponent:"===e.split(" ")[0]?t.e=elementToBuf(e):"PrivateExponent:"===e.split(" ")[0]?t.d=elementToBuf(e):"Prime1:"===e.split(" ")[0]?t.p=elementToBuf(e):"Prime2:"===e.split(" ")[0]?t.q=elementToBuf(e):"Exponent1:"===e.split(" ")[0]?t.dmodp=elementToBuf(e):"Exponent2:"===e.split(" ")[0]?t.dmodq=elementToBuf(e):"Coefficient:"===e.split(" ")[0]&&(t.iqmp=elementToBuf(e))});var a={type:"rsa",parts:[{name:"e",data:s.mpNormalize(t.e)},{name:"n",data:s.mpNormalize(t.n)},{name:"d",data:s.mpNormalize(t.d)},{name:"p",data:s.mpNormalize(t.p)},{name:"q",data:s.mpNormalize(t.q)},{name:"dmodp",data:s.mpNormalize(t.dmodp)},{name:"dmodq",data:s.mpNormalize(t.dmodq)},{name:"iqmp",data:s.mpNormalize(t.iqmp)}]};return new n(a)}(t);if("ECDSA-P384-SHA384"===p[e]||"ECDSA-P256-SHA256"===p[e]){var a=r.from(t[0].split(" ")[1],"base64"),o="nistp384",i=384;"ECDSA-P256-SHA256"===p[e]&&(o="nistp256",i=256);var c=s.publicFromPrivateECDSA(o,a).part.Q.data,u={type:"ecdsa",curve:o,size:i,parts:[{name:"curve",data:r.from(o)},{name:"d",data:a},{name:"Q",data:c}]};return new n(u)}throw new Error("Unsupported algorithm: "+p[e])}(u,a.slice(2))}var m=0;for(;a[m].match(/^\;/);)m++;if((a[m].match(/\. IN KEY /)||a[m].match(/\. IN DNSKEY /))&&0===a[m+1].length)return function readRFC3110(e){var t=e.split(" "),a=parseInt(t[5],10);if(!p[a])throw new Error("Unsupported algorithm: "+a);var o=t.slice(6,t.length).join(),n=r.from(o,"base64");if(p[a].match(/^RSA-/)){var c=n.readUInt8(0);if(3!=c&&1!=c)throw new Error("Cannot parse dnssec key: unsupported exponent length");var u=n.slice(1,c+1);u=s.mpNormalize(u);var l=n.slice(1+c);l=s.mpNormalize(l);var m={type:"rsa",parts:[]};return m.parts.push({name:"e",data:u}),m.parts.push({name:"n",data:l}),new i(m)}if("ECDSA-P384-SHA384"===p[a]||"ECDSA-P256-SHA256"===p[a]){var f="nistp384",h=384;p[a].match(/^ECDSA-P256-SHA256/)&&(f="nistp256",h=256);var g={type:"ecdsa",curve:f,size:h,parts:[{name:"curve",data:r.from(f)},{name:"Q",data:s.ecNormalize(n)}]};return new i(g)}throw new Error("Unsupported algorithm: "+p[a])}(a[m]);throw new Error("Cannot parse dnssec key")},write:function write(e,t){if(n.isPrivateKey(e)){if("rsa"===e.type)return function writeRSA(e,t){e.part.dmodp&&e.part.dmodq||s.addRSAMissing(e);var a="";a+="Private-key-format: v1.3\n",a+="Algorithm: "+function rsaAlgFromOptions(e){if(e&&e.hashAlgo&&"sha1"!==e.hashAlgo){if("sha256"===e.hashAlgo)return"8 (RSASHA256)";if("sha512"===e.hashAlgo)return"10 (RSASHA512)";throw new Error("Unknown or unsupported hash: "+e.hashAlgo)}return"5 (RSASHA1)"}(t)+"\n";var o=s.mpDenormalize(e.part.n.data);a+="Modulus: "+o.toString("base64")+"\n";var i=s.mpDenormalize(e.part.e.data);a+="PublicExponent: "+i.toString("base64")+"\n";var n=s.mpDenormalize(e.part.d.data);a+="PrivateExponent: "+n.toString("base64")+"\n";var c=s.mpDenormalize(e.part.p.data);a+="Prime1: "+c.toString("base64")+"\n";var p=s.mpDenormalize(e.part.q.data);a+="Prime2: "+p.toString("base64")+"\n";var u=s.mpDenormalize(e.part.dmodp.data);a+="Exponent1: "+u.toString("base64")+"\n";var l=s.mpDenormalize(e.part.dmodq.data);a+="Exponent2: "+l.toString("base64")+"\n";var m=s.mpDenormalize(e.part.iqmp.data);a+="Coefficient: "+m.toString("base64")+"\n";var f=new Date;return a+="Created: "+dnssecTimestamp(f)+"\n",a+="Publish: "+dnssecTimestamp(f)+"\n",a+="Activate: "+dnssecTimestamp(f)+"\n",r.from(a,"ascii")}(e,t);if("ecdsa"===e.type)return function writeECDSA(e,t){var a="";if(a+="Private-key-format: v1.3\n","nistp256"===e.curve)a+="Algorithm: 13 (ECDSAP256SHA256)\n";else{if("nistp384"!==e.curve)throw new Error("Unsupported curve");a+="Algorithm: 14 (ECDSAP384SHA384)\n"}var o=e.part.d.data.toString("base64");a+="PrivateKey: "+o+"\n";var i=new Date;return a+="Created: "+dnssecTimestamp(i)+"\n",a+="Publish: "+dnssecTimestamp(i)+"\n",a+="Activate: "+dnssecTimestamp(i)+"\n",r.from(a,"ascii")}(e);throw new Error("Unsupported algorithm: "+e.type)}throw i.isKey(e)?new Error('Format "dnssec" only supports writing private keys'):new Error("key is not a Key or PrivateKey")}};var o=a(94742),r=a(54774).Buffer,i=a(64479),n=a(90009),s=a(87461),c=(a(46309),a(82879),{"rsa-sha1":5,"rsa-sha256":8,"rsa-sha512":10,"ecdsa-p256-sha256":13,"ecdsa-p384-sha384":14}),p={};function elementToBuf(e){return r.from(e.split(" ")[1],"base64")}function dnssecTimestamp(e){var t=e.getFullYear()+""+(e.getMonth()+1)+e.getUTCDate();return t+=""+e.getUTCHours()+e.getUTCMinutes(),t+=e.getUTCSeconds()}Object.keys(c).forEach(function(e){p[c[e]]=e.toUpperCase()})},4224:e=>{"use strict";e.exports=function generate_not(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="errs__"+r,m=e.util.copy(e);m.level++;var f="valid"+m.level;if(e.opts.strictKeywords?"object"==typeof n&&Object.keys(n).length>0||!1===n:e.util.schemaHasRules(n,e.RULES.all)){m.schema=n,m.schemaPath=s,m.errSchemaPath=c,o+=" var "+l+" = errors;  ";var h,g=e.compositeRule;e.compositeRule=m.compositeRule=!0,m.createErrors=!1,m.opts.allErrors&&(h=m.opts.allErrors,m.opts.allErrors=!1),o+=" "+e.validate(m)+" ",m.createErrors=!0,h&&(m.opts.allErrors=h),e.compositeRule=m.compositeRule=g,o+=" if ("+f+") {   ";var y=y||[];y.push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: {} ",!1!==e.opts.messages&&(o+=" , message: 'should NOT be valid' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var b=o;o=y.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+b+"]); ":o+=" validate.errors = ["+b+"]; return false; ":o+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } else {  errors = "+l+"; if (vErrors !== null) { if ("+l+") vErrors.length = "+l+"; else vErrors = null; } ",e.opts.allErrors&&(o+=" } ")}else o+="  var err =   ",!1!==e.createErrors?(o+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: {} ",!1!==e.opts.messages&&(o+=" , message: 'should NOT be valid' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",p&&(o+=" if (false) { ");return o}},4558:e=>{"use strict";e.exports=preferredCharsets,e.exports.preferredCharsets=preferredCharsets;var t=/^\s*([^\s;]+)\s*(?:;(.*))?$/;function parseCharset(e,a){var o=t.exec(e);if(!o)return null;var r=o[1],i=1;if(o[2])for(var n=o[2].split(";"),s=0;s<n.length;s++){var c=n[s].trim().split("=");if("q"===c[0]){i=parseFloat(c[1]);break}}return{charset:r,q:i,i:a}}function specify(e,t,a){var o=0;if(t.charset.toLowerCase()===e.toLowerCase())o|=1;else if("*"!==t.charset)return null;return{i:a,o:t.i,q:t.q,s:o}}function preferredCharsets(e,t){var a=function parseAcceptCharset(e){for(var t=e.split(","),a=0,o=0;a<t.length;a++){var r=parseCharset(t[a].trim(),a);r&&(t[o++]=r)}return t.length=o,t}(void 0===e?"*":e||"");if(!t)return a.filter(isQuality).sort(compareSpecs).map(getFullCharset);var o=t.map(function getPriority(e,t){return function getCharsetPriority(e,t,a){for(var o={o:-1,q:0,s:0},r=0;r<t.length;r++){var i=specify(e,t[r],a);i&&(o.s-i.s||o.q-i.q||o.o-i.o)<0&&(o=i)}return o}(e,a,t)});return o.filter(isQuality).sort(compareSpecs).map(function getCharset(e){return t[o.indexOf(e)]})}function compareSpecs(e,t){return t.q-e.q||t.s-e.s||e.o-t.o||e.i-t.i||0}function getFullCharset(e){return e.charset}function isQuality(e){return e.q>0}},4710:(e,t,a)=>{"use strict";const o=a(29582),r=a(91034),i=a(13037);function formatOptions(e,t){const a={};return r(e).to(a),a.limit=e[t+"Limit"],a}function extendType(e,t){t&&(Array.isArray(t)||(t=[t]),t.forEach(function(t){e.push(t)}))}function checkEnable(e,t){return e.includes(t)}e.exports=function(e){e=e||{};const{detectJSON:t}=e,{onerror:a}=e,r=e.enableTypes||["json","form"],n=checkEnable(r,"form"),s=checkEnable(r,"json"),c=checkEnable(r,"text"),p=checkEnable(r,"xml");e.detectJSON=void 0,e.onerror=void 0,e.returnRawBody=!0;const u=["application/json","application/json-patch+json","application/vnd.api+json","application/csp-report","application/scim+json"],l=["application/x-www-form-urlencoded"],m=["text/plain"],f=["text/xml","application/xml"],h=formatOptions(e,"json"),g=formatOptions(e,"form"),y=formatOptions(e,"text"),b=formatOptions(e,"xml"),x=e.extendTypes||{};return extendType(u,x.json),extendType(l,x.form),extendType(m,x.text),extendType(f,x.xml),async function bodyParser(e,r){if(void 0!==e.request.body||e.disableBodyParser)return await r();try{const a=await async function parseBody(e){if(s&&(t&&t(e)||function isTypes(e,t){"string"==typeof e&&(e=e.replace(/;$/,""));return i.is(e,t)}(e.request.get("content-type"),u)))return await o.json(e,h);if(n&&e.request.is(l))return await o.form(e,g);if(c&&e.request.is(m))return await o.text(e,y)||"";if(p&&e.request.is(f))return await o.text(e,b)||"";return{}}(e);e.request.body="parsed"in a?a.parsed:{},void 0===e.request.rawBody&&(e.request.rawBody=a.raw)}catch(t){if(!a)throw t;a(t,e)}await r()}}},4982:(e,t,a)=>{var o=Array.prototype.slice,r=a(61264),i=a(5491),n=e.exports=function(e,t,a){return a||(a={}),e===t||(e instanceof Date&&t instanceof Date?e.getTime()===t.getTime():!e||!t||"object"!=typeof e&&"object"!=typeof t?a.strict?e===t:e==t:function objEquiv(e,t,a){var s,c;if(isUndefinedOrNull(e)||isUndefinedOrNull(t))return!1;if(e.prototype!==t.prototype)return!1;if(i(e))return!!i(t)&&(e=o.call(e),t=o.call(t),n(e,t,a));if(isBuffer(e)){if(!isBuffer(t))return!1;if(e.length!==t.length)return!1;for(s=0;s<e.length;s++)if(e[s]!==t[s])return!1;return!0}try{var p=r(e),u=r(t)}catch(e){return!1}if(p.length!=u.length)return!1;for(p.sort(),u.sort(),s=p.length-1;s>=0;s--)if(p[s]!=u[s])return!1;for(s=p.length-1;s>=0;s--)if(c=p[s],!n(e[c],t[c],a))return!1;return typeof e==typeof t}(e,t,a))};function isUndefinedOrNull(e){return null==e}function isBuffer(e){return!(!e||"object"!=typeof e||"number"!=typeof e.length)&&("function"==typeof e.copy&&"function"==typeof e.slice&&!(e.length>0&&"number"!=typeof e[0]))}},5342:(e,t,a)=>{"use strict";const o=a(97075);e.exports=(e,t,a)=>o(e,t,"<",a)},5491:(e,t)=>{var a="[object Arguments]"==function(){return Object.prototype.toString.call(arguments)}();function supported(e){return"[object Arguments]"==Object.prototype.toString.call(e)}function unsupported(e){return e&&"object"==typeof e&&"number"==typeof e.length&&Object.prototype.hasOwnProperty.call(e,"callee")&&!Object.prototype.propertyIsEnumerable.call(e,"callee")||!1}(t=e.exports=a?supported:unsupported).supported=supported,t.unsupported=unsupported},5545:(module,__unused_webpack_exports,__webpack_require__)=>{var callSiteToString=__webpack_require__(92244).callSiteToString,eventListenerCount=__webpack_require__(92244).eventListenerCount,relative=__webpack_require__(16928).relative;module.exports=depd;var basePath=process.cwd();function containsNamespace(e,t){for(var a=e.split(/[ ,]+/),o=String(t).toLowerCase(),r=0;r<a.length;r++){var i=a[r];if(i&&("*"===i||i.toLowerCase()===o))return!0}return!1}function convertDataDescriptorToAccessor(e,t,a){var o=Object.getOwnPropertyDescriptor(e,t),r=o.value;return o.get=function getter(){return r},o.writable&&(o.set=function setter(e){return r=e}),delete o.value,delete o.writable,Object.defineProperty(e,t,o),o}function createArgumentsString(e){for(var t="",a=0;a<e;a++)t+=", arg"+a;return t.substr(2)}function createStackString(e){var t=this.name+": "+this.namespace;this.message&&(t+=" deprecated "+this.message);for(var a=0;a<e.length;a++)t+="\n    at "+callSiteToString(e[a]);return t}function depd(e){if(!e)throw new TypeError("argument namespace is required");var t=callSiteLocation(getStack()[1])[0];function deprecate(e){log.call(deprecate,e)}return deprecate._file=t,deprecate._ignored=isignored(e),deprecate._namespace=e,deprecate._traced=istraced(e),deprecate._warned=Object.create(null),deprecate.function=wrapfunction,deprecate.property=wrapproperty,deprecate}function isignored(e){return!!process.noDeprecation||containsNamespace(process.env.NO_DEPRECATION||"",e)}function istraced(e){return!!process.traceDeprecation||containsNamespace(process.env.TRACE_DEPRECATION||"",e)}function log(e,t){var a=0!==eventListenerCount(process,"deprecation");if(a||!this._ignored){var o,r,i,n,s=0,c=!1,p=getStack(),u=this._file;for(t?(n=t,(i=callSiteLocation(p[1])).name=n.name,u=i[0]):i=n=callSiteLocation(p[s=2]);s<p.length;s++)if((r=(o=callSiteLocation(p[s]))[0])===u)c=!0;else if(r===this._file)u=this._file;else if(c)break;var l=o?n.join(":")+"__"+o.join(":"):void 0;if(void 0===l||!(l in this._warned)){this._warned[l]=!0;var m=e;if(m||(m=i!==n&&i.name?defaultMessage(i):defaultMessage(n)),a){var f=DeprecationError(this._namespace,m,p.slice(s));process.emit("deprecation",f)}else{var h=(process.stderr.isTTY?formatColor:formatPlain).call(this,m,o,p.slice(s));process.stderr.write(h+"\n","utf8")}}}}function callSiteLocation(e){var t=e.getFileName()||"<anonymous>",a=e.getLineNumber(),o=e.getColumnNumber();e.isEval()&&(t=e.getEvalOrigin()+", "+t);var r=[t,a,o];return r.callSite=e,r.name=e.getFunctionName(),r}function defaultMessage(e){var t=e.callSite,a=e.name;a||(a="<anonymous@"+formatLocation(e)+">");var o=t.getThis(),r=o&&t.getTypeName();return"Object"===r&&(r=void 0),"Function"===r&&(r=o.name||r),r&&t.getMethodName()?r+"."+a:a}function formatPlain(e,t,a){var o=(new Date).toUTCString()+" "+this._namespace+" deprecated "+e;if(this._traced){for(var r=0;r<a.length;r++)o+="\n    at "+callSiteToString(a[r]);return o}return t&&(o+=" at "+formatLocation(t)),o}function formatColor(e,t,a){var o="[36;1m"+this._namespace+"[22;39m [33;1mdeprecated[22;39m [0m"+e+"[39m";if(this._traced){for(var r=0;r<a.length;r++)o+="\n    [36mat "+callSiteToString(a[r])+"[39m";return o}return t&&(o+=" [36m"+formatLocation(t)+"[39m"),o}function formatLocation(e){return relative(basePath,e[0])+":"+e[1]+":"+e[2]}function getStack(){var e=Error.stackTraceLimit,t={},a=Error.prepareStackTrace;Error.prepareStackTrace=prepareObjectStackTrace,Error.stackTraceLimit=Math.max(10,e),Error.captureStackTrace(t);var o=t.stack.slice(1);return Error.prepareStackTrace=a,Error.stackTraceLimit=e,o}function prepareObjectStackTrace(e,t){return t}function wrapfunction(fn,message){if("function"!=typeof fn)throw new TypeError("argument fn must be a function");var args=createArgumentsString(fn.length),deprecate=this,stack=getStack(),site=callSiteLocation(stack[1]);site.name=fn.name;var deprecatedfn=eval("(function ("+args+') {\n"use strict"\nlog.call(deprecate, message, site)\nreturn fn.apply(this, arguments)\n})');return deprecatedfn}function wrapproperty(e,t,a){if(!e||"object"!=typeof e&&"function"!=typeof e)throw new TypeError("argument obj must be object");var o=Object.getOwnPropertyDescriptor(e,t);if(!o)throw new TypeError("must call property on owner object");if(!o.configurable)throw new TypeError("property must be configurable");var r=this,i=callSiteLocation(getStack()[1]);i.name=t,"value"in o&&(o=convertDataDescriptorToAccessor(e,t,a));var n=o.get,s=o.set;"function"==typeof n&&(o.get=function getter(){return log.call(r,a,i),n.apply(this,arguments)}),"function"==typeof s&&(o.set=function setter(){return log.call(r,a,i),s.apply(this,arguments)}),Object.defineProperty(e,t,o)}function DeprecationError(e,t,a){var o,r=new Error;return Object.defineProperty(r,"constructor",{value:DeprecationError}),Object.defineProperty(r,"message",{configurable:!0,enumerable:!1,value:t,writable:!0}),Object.defineProperty(r,"name",{enumerable:!1,configurable:!0,value:"DeprecationError",writable:!0}),Object.defineProperty(r,"namespace",{configurable:!0,enumerable:!1,value:e,writable:!0}),Object.defineProperty(r,"stack",{configurable:!0,enumerable:!1,get:function(){return void 0!==o?o:o=createStackString.call(this,a)},set:function setter(e){o=e}}),r}},6166:function(e,t,a){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.StdioServerTransport=void 0;const r=o(a(1708)),i=a(29560);t.StdioServerTransport=class StdioServerTransport{constructor(e=r.default.stdin,t=r.default.stdout){this._stdin=e,this._stdout=t,this._readBuffer=new i.ReadBuffer,this._started=!1,this._ondata=e=>{this._readBuffer.append(e),this.processReadBuffer()},this._onerror=e=>{var t;null===(t=this.onerror)||void 0===t||t.call(this,e)}}async start(){if(this._started)throw new Error("StdioServerTransport already started! If using Server class, note that connect() calls start() automatically.");this._started=!0,this._stdin.on("data",this._ondata),this._stdin.on("error",this._onerror)}processReadBuffer(){for(var e,t;;)try{const t=this._readBuffer.readMessage();if(null===t)break;null===(e=this.onmessage)||void 0===e||e.call(this,t)}catch(e){null===(t=this.onerror)||void 0===t||t.call(this,e)}}async close(){var e;this._stdin.off("data",this._ondata),this._stdin.off("error",this._onerror);0===this._stdin.listenerCount("data")&&this._stdin.pause(),this._readBuffer.clear(),null===(e=this.onclose)||void 0===e||e.call(this)}send(e){return new Promise(t=>{const a=(0,i.serializeMessage)(e);this._stdout.write(a)?t():this._stdout.once("drain",t)})}}},6176:(e,t,a)=>{"use strict";var o=a(79896),r=a(76982),{XMLParser:i,XMLBuilder:n}=a(86454),s=new i({ignoreDeclaration:!0,ignoreAttributes:!0,parseTagValue:!1}),c=new n;function camSafeUrlEncode(e){return encodeURIComponent(e).replace(/!/g,"%21").replace(/'/g,"%27").replace(/\(/g,"%28").replace(/\)/g,"%29").replace(/\*/g,"%2A")}var getObjectKeys=function(e,t){var a=[];for(var o in e)e.hasOwnProperty(o)&&a.push(t?camSafeUrlEncode(o).toLowerCase():o);return a.sort(function(e,t){return(e=e.toLowerCase())===(t=t.toLowerCase())?0:e>t?1:-1})},obj2str=function(e,t){var a,o,r,i=[],n=getObjectKeys(e);for(a=0;a<n.length;a++)r=void 0===e[o=n[a]]||null===e[o]?"":""+e[o],o=t?camSafeUrlEncode(o).toLowerCase():camSafeUrlEncode(o),r=camSafeUrlEncode(r)||"",i.push(o+"="+r);return i.join("&")},p=["content-disposition","content-encoding","content-length","content-md5","expect","expires","host","if-match","if-modified-since","if-none-match","if-unmodified-since","origin","range","transfer-encoding","pic-operations"],noop=function(){},clearKey=function(e){var t={};for(var a in e)e.hasOwnProperty(a)&&void 0!==e[a]&&null!==e[a]&&(t[a]=e[a]);return t};function clone(e){return map(e,function(e){return"object"==typeof e&&null!==e?clone(e):e})}function extend(e,t){return each(t,function(a,o){e[o]=t[o]}),e}function isArray(e){return e instanceof Array}function each(e,t){for(var a in e)e.hasOwnProperty(a)&&t(e[a],a)}function map(e,t){var a=isArray(e)?[]:{};for(var o in e)e.hasOwnProperty(o)&&(a[o]=t(e[o],o));return a}var formatParams=function(e,t){if(t=extend({},t),"getAuth"!==e&&"getV4Auth"!==e&&"getObjectUrl"!==e){var a=t.Headers||{};if(t&&"object"==typeof t){!function(){for(var e in t)t.hasOwnProperty(e)&&e.indexOf("x-cos-")>-1&&(a[e]=t[e])}();u.each({"x-cos-mfa":"MFA","Content-MD5":"ContentMD5","Content-Length":"ContentLength","Content-Type":"ContentType",Expect:"Expect",Expires:"Expires","Cache-Control":"CacheControl","Content-Disposition":"ContentDisposition","Content-Encoding":"ContentEncoding",Range:"Range","If-Modified-Since":"IfModifiedSince","If-Unmodified-Since":"IfUnmodifiedSince","If-Match":"IfMatch","If-None-Match":"IfNoneMatch","x-cos-copy-source":"CopySource","x-cos-copy-source-Range":"CopySourceRange","x-cos-metadata-directive":"MetadataDirective","x-cos-copy-source-If-Modified-Since":"CopySourceIfModifiedSince","x-cos-copy-source-If-Unmodified-Since":"CopySourceIfUnmodifiedSince","x-cos-copy-source-If-Match":"CopySourceIfMatch","x-cos-copy-source-If-None-Match":"CopySourceIfNoneMatch","x-cos-acl":"ACL","x-cos-grant-read":"GrantRead","x-cos-grant-write":"GrantWrite","x-cos-grant-full-control":"GrantFullControl","x-cos-grant-read-acp":"GrantReadAcp","x-cos-grant-write-acp":"GrantWriteAcp","x-cos-storage-class":"StorageClass","x-cos-traffic-limit":"TrafficLimit","x-cos-mime-limit":"MimeLimit","x-cos-server-side-encryption-customer-algorithm":"SSECustomerAlgorithm","x-cos-server-side-encryption-customer-key":"SSECustomerKey","x-cos-server-side-encryption-customer-key-MD5":"SSECustomerKeyMD5","x-cos-server-side-encryption":"ServerSideEncryption","x-cos-server-side-encryption-cos-kms-key-id":"SSEKMSKeyId","x-cos-server-side-encryption-context":"SSEContext","Pic-Operations":"PicOperations"},function(e,o){void 0!==t[e]&&(a[o]=t[e])}),t.Headers=clearKey(a)}}return t},getSkewTime=function(e){return Date.now()+(e||0)},u={noop,formatParams,apiWrapper:function(e,t){return function(a,o){var r=this;"function"==typeof a&&(o=a,a={}),a=formatParams(e,a);var formatResult=function(e){return e&&e.headers&&(e.headers["x-cos-request-id"]&&(e.RequestId=e.headers["x-cos-request-id"]),e.headers["x-ci-request-id"]&&(e.RequestId=e.headers["x-ci-request-id"]),e.headers["x-cos-version-id"]&&(e.VersionId=e.headers["x-cos-version-id"]),e.headers["x-cos-delete-marker"]&&(e.DeleteMarker=e.headers["x-cos-delete-marker"])),e},_callback=function(e,t){o&&o(formatResult(e),formatResult(t))},i=function(){if("getService"!==e&&"abortUploadTask"!==e){var t=function(e,t){var a=t.Bucket,o=t.Region,r=t.Key;if(e.indexOf("Bucket")>-1||"deleteMultipleObject"===e||"multipartList"===e||"listObjectVersions"===e){if(!a)return"Bucket";if(!o)return"Region"}else if(e.indexOf("Object")>-1||e.indexOf("multipart")>-1||"sliceUploadFile"===e||"abortUploadTask"===e||"uploadFile"===e){if(!a)return"Bucket";if(!o)return"Region";if(!r)return"Key"}return!1}(e,a);if(t)return"missing param "+t;if(a.Region){if(a.Region.indexOf("cos.")>-1)return'param Region should not be start with "cos."';if(!/^([a-z\d-]+)$/.test(a.Region))return"Region format error.";r.options.CompatibilityMode||-1!==a.Region.indexOf("-")||"yfb"===a.Region||"default"===a.Region||"accelerate"===a.Region||console.warn("warning: param Region format error, find help here: https://cloud.tencent.com/document/product/436/6224")}if(a.Bucket){if(!/^([a-z\d-]+)-(\d+)$/.test(a.Bucket))if(a.AppId)a.Bucket=a.Bucket+"-"+a.AppId;else{if(!r.options.AppId)return'Bucket should format as "test-1250000000".';a.Bucket=a.Bucket+"-"+r.options.AppId}a.AppId&&(console.warn('warning: AppId has been deprecated, Please put it at the end of parameter Bucket(E.g Bucket:"test-1250000000" ).'),delete a.AppId)}!r.options.UseRawKey&&a.Key&&"/"===a.Key.substr(0,1)&&(a.Key=a.Key.substr(1))}}(),n=["getAuth","getV4Auth","getObjectUrl"].includes(e)||e.indexOf("Stream")>-1;if(Promise&&!n&&!o)return new Promise(function(e,n){if(o=function(t,a){t?n(t):e(a)},i)return _callback(u.error(new Error(i)));t.call(r,a,_callback)});if(i)return _callback(u.error(new Error(i)));var s=t.call(r,a,_callback);return n?s:void 0}},xml2json:function(e){return s.parse(e)},json2xml:function(e){return c.build(e)},md5:function(e,t){return r.createHash("md5").update(e).digest(t||"hex")},clearKey,fileSlice:function(e,t,a,r){if(e)try{var i=o.createReadStream(e,{start:t,end:a-1});i.isSdkCreated=!0,r(i)}catch(e){}else r(null)},getBodyMd5:function(e,t,a){a=a||noop,e&&(t instanceof Buffer||"string"==typeof t)?a(u.md5(t)):a()},getFileMd5:function(e,t){var a=r.createHash("md5");e.on("data",function(e){a.update(e)}),e.on("error",function(e){t(u.error(e))}),e.on("end",function(){var e=a.digest("hex");t(null,e)})},binaryBase64:function(e){var t,a,o,r=[];for(t=0,a=e.length/2;t<a;t++)o=parseInt(e[2*t]+e[2*t+1],16),r.push(o);return Buffer.from(r).toString("base64")},extend,isArray,isInArray:function isInArray(e,t){for(var a=!1,o=0;o<e.length;o++)if(t===e[o]){a=!0;break}return a},makeArray:function makeArray(e){return isArray(e)?e:[e]},each,map,filter:function filter(e,t){var a=isArray(e),o=a?[]:{};for(var r in e)e.hasOwnProperty(r)&&t(e[r],r)&&(a?o.push(e[r]):o[r]=e[r]);return o},clone,attr:function attr(e,t,a){return e&&t in e?e[t]:a},uuid:function(){var S4=function(){return(65536*(1+Math.random())|0).toString(16).substring(1)};return S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4()},camSafeUrlEncode,throttleOnProgress:function(e,t){var a,o,r=this,i=0,n=0,s=Date.now();function update(){if(o=0,t&&"function"==typeof t){a=Date.now();var r,c=Math.max(0,Math.round((n-i)/((a-s)/1e3)*100)/100)||0;r=0===n&&0===e?1:Math.floor(n/e*100)/100||0,s=a,i=n;try{t({loaded:n,total:e,speed:c,percent:r})}catch(e){}}}return function(t,a){if(t&&(n=t.loaded,e=t.total),a)clearTimeout(o),update();else{if(o)return;o=setTimeout(update,r.options.ProgressInterval)}}},getFileSize:function(e,t,a){var r;if("sliceUploadFile"===e)return t.FilePath?void o.stat(t.FilePath,function(e,o){if(e){if(void 0===t.ContentLength)return a(e);r=t.ContentLength}else t.FileStat=o,t.FileStat.FilePath=t.FilePath,r=o.isDirectory()?0:o.size;t.ContentLength=r=r||0,a(null,r)}):void a(u.error(new Error("missing param FilePath")));if(void 0!==t.Body){if("string"==typeof t.Body&&(t.Body=global.Buffer.from(t.Body)),t.Body instanceof global.Buffer)r=t.Body.length;else{if("function"!=typeof t.Body.pipe)return void a(u.error(new Error("params Body format error, Only allow Buffer|Stream|String.")));r=void 0===t.ContentLength?void 0:t.ContentLength}t.ContentLength=r,a(null,r)}else a(u.error(new Error("missing param Body")))},getSkewTime,error:function(e,t){var a=e;if(e.message=e.message||null,"string"==typeof t?(e.error=t,e.message=t):"object"==typeof t&&null!==t&&(extend(e,t),(t.code||t.name)&&(e.code=t.code||t.name),t.message&&(e.message=t.message),t.stack&&(e.stack=t.stack)),"function"==typeof Object.defineProperty&&(Object.defineProperty(e,"name",{writable:!0,enumerable:!1}),Object.defineProperty(e,"message",{enumerable:!0})),e.name=t&&t.name||e.name||e.code||"Error",e.code||(e.code=e.name),!e.error){var o=Object.prototype.toString.call(e);"[object Object]"===o?e.error=clone(a):"[object Error]"===o&&(e={code:e.code||e.name||"Error",name:e.name||e.code||"Error",message:e.reason||e.message||"Error"})}return e},getAuth:function(e){var t,a=(e=e||{}).SecretId,o=e.SecretKey,i=e.KeyTime,n=(e.method||e.Method||"get").toLowerCase(),s=clone(e.Query||e.params||{}),c=function(e){var t={};for(var a in e){var o=a.toLowerCase();(o.indexOf("x-cos-")>-1||p.indexOf(o)>-1)&&(t[a]=e[a])}return t}(clone(e.Headers||e.headers||{})),u=e.Key||"";e.UseRawKey?t=e.Pathname||e.pathname||"/"+u:0!==(t=e.Pathname||e.pathname||u).indexOf("/")&&(t="/"+t);var l=!1!==e.ForceSignHost;if(!c.Host&&!c.host&&e.Bucket&&e.Region&&l&&(c.Host=e.Bucket+".cos."+e.Region+".myqcloud.com"),!a)throw new Error("missing param SecretId");if(!o)throw new Error("missing param SecretKey");var m=Math.round(getSkewTime(e.SystemClockOffset)/1e3)-1,f=m,h=e.Expires||e.expires;f+=void 0===h?900:1*h||0;var g=a,y=i||m+";"+f,b=i||m+";"+f,x=getObjectKeys(c,!0).join(";").toLowerCase(),w=getObjectKeys(s,!0).join(";").toLowerCase(),k=r.createHmac("sha1",o).update(b).digest("hex"),j=[n,t,obj2str(s,!0),obj2str(c,!0),""].join("\n");j=Buffer.from(j,"utf8");var C=["sha1",y,r.createHash("sha1").update(j).digest("hex"),""].join("\n");return["q-sign-algorithm=sha1","q-ak="+g,"q-sign-time="+y,"q-key-time="+b,"q-header-list="+x,"q-url-param-list="+w,"q-signature="+r.createHmac("sha1",k).update(C).digest("hex")].join("&")},callbackAfterStreamFinish:function(e,t){if(!e)return t;var a,o,r=2,i=!1,cb=function(e,n){i||((n&&!o||e||a)&&(o=n),e&&!a&&(a=e,o=null),(a||0===--r)&&(i=!0,t(a,o)))};return e.on("error",function(e){cb(e)}),e.on("finish",function(){cb()}),cb},getV4Auth:function(e){if(!e.SecretId)return console.error("missing param SecretId");if(!e.SecretKey)return console.error("missing param SecretKey");if(!e.Bucket)return console.error("missing param Bucket");var t=e.Bucket,a=t.substr(0,t.lastIndexOf("-")),o=t.substr(t.lastIndexOf("-")+1),i=Math.round(Math.random()*Math.pow(2,32)),n=Math.round(Date.now()/1e3),s=n+(void 0===e.Expires?900:e.Expires),c="/"+o+"/"+a+"/"+encodeURIComponent((e.Key||"").replace(/(^\/*)/g,"")).replace(/%2F/g,"/"),p="a="+o+"&b="+a+"&k="+e.SecretId+"&t="+n+"&e="+s+"&r="+i+"&f="+c,u=r.createHmac("sha1",e.SecretKey).update(p).digest();return Buffer.concat([u,Buffer.from(p)]).toString("base64")},isBrowser:!1,obj2str,isWeb:function(){return"object"==typeof window},isCIHost:function(e){return/^https?:\/\/([^/]+\.)?ci\.[^/]+/.test(e)},getSourceParams:function(e){var t=this.options.CopySourceParser;if(t)return t(e);var a=e.match(/^([^.]+-\d+)\.cos(v6|-cdc|-internal)?\.([^.]+)\.((myqcloud\.com)|(tencentcos\.cn))\/(.+)$/);return a?{Bucket:a[1],Region:a[3],Key:a[7]}:null},encodeBase64:function(e,t){let a=Buffer.from(e).toString("base64");return t&&(a=a.replaceAll("+","-").replaceAll("/","_").replaceAll("=","")),a},simplifyPath:function(e){const t=e.split("/"),a=[];for(const e of t)".."===e?a.length&&a.pop():e.length&&"."!==e&&a.push(e);return"/"+a.join("/")},parseResBody:function(e){var t;if(e&&"string"==typeof e){var a=e.trim(),o=0===a.indexOf("<"),r=0===a.indexOf("{");if(o)t=u.xml2json(e)||{};else if(r)try{var i=e.replace(/\n/g," "),n=JSON.parse(i);t="[object Object]"===Object.prototype.toString.call(n)?n:e}catch(a){t=e}else t=e}else t=e||{};return t}};e.exports=u},6188:e=>{"use strict";e.exports=Math.max},6549:e=>{"use strict";e.exports=Object.getOwnPropertyDescriptor},6573:e=>{"use strict";e.exports=function generate_items(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="valid"+r,m="errs__"+r,f=e.util.copy(e),h="";f.level++;var g="valid"+f.level,y="i"+r,b=f.dataLevel=e.dataLevel+1,x="data"+b,w=e.baseId;if(o+="var "+m+" = errors;var "+l+";",Array.isArray(n)){var k=e.schema.additionalItems;if(!1===k){o+=" "+l+" = "+u+".length <= "+n.length+"; ";var j=c;c=e.errSchemaPath+"/additionalItems",o+="  if (!"+l+") {   ";var C=C||[];C.push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+n.length+" } ",!1!==e.opts.messages&&(o+=" , message: 'should NOT have more than "+n.length+" items' "),e.opts.verbose&&(o+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var P=o;o=C.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+P+"]); ":o+=" validate.errors = ["+P+"]; return false; ":o+=" var err = "+P+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } ",c=j,p&&(h+="}",o+=" else { ")}var O=n;if(O)for(var I,z=-1,q=O.length-1;z<q;)if(I=O[z+=1],e.opts.strictKeywords?"object"==typeof I&&Object.keys(I).length>0||!1===I:e.util.schemaHasRules(I,e.RULES.all)){o+=" "+g+" = true; if ("+u+".length > "+z+") { ";var $=u+"["+z+"]";f.schema=I,f.schemaPath=s+"["+z+"]",f.errSchemaPath=c+"/"+z,f.errorPath=e.util.getPathExpr(e.errorPath,z,e.opts.jsonPointers,!0),f.dataPathArr[b]=z;var H=e.validate(f);f.baseId=w,e.util.varOccurences(H,x)<2?o+=" "+e.util.varReplace(H,x,$)+" ":o+=" var "+x+" = "+$+"; "+H+" ",o+=" }  ",p&&(o+=" if ("+g+") { ",h+="}")}if("object"==typeof k&&(e.opts.strictKeywords?"object"==typeof k&&Object.keys(k).length>0||!1===k:e.util.schemaHasRules(k,e.RULES.all))){f.schema=k,f.schemaPath=e.schemaPath+".additionalItems",f.errSchemaPath=e.errSchemaPath+"/additionalItems",o+=" "+g+" = true; if ("+u+".length > "+n.length+") {  for (var "+y+" = "+n.length+"; "+y+" < "+u+".length; "+y+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,y,e.opts.jsonPointers,!0);$=u+"["+y+"]";f.dataPathArr[b]=y;H=e.validate(f);f.baseId=w,e.util.varOccurences(H,x)<2?o+=" "+e.util.varReplace(H,x,$)+" ":o+=" var "+x+" = "+$+"; "+H+" ",p&&(o+=" if (!"+g+") break; "),o+=" } }  ",p&&(o+=" if ("+g+") { ",h+="}")}}else if(e.opts.strictKeywords?"object"==typeof n&&Object.keys(n).length>0||!1===n:e.util.schemaHasRules(n,e.RULES.all)){f.schema=n,f.schemaPath=s,f.errSchemaPath=c,o+="  for (var "+y+" = 0; "+y+" < "+u+".length; "+y+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,y,e.opts.jsonPointers,!0);$=u+"["+y+"]";f.dataPathArr[b]=y;H=e.validate(f);f.baseId=w,e.util.varOccurences(H,x)<2?o+=" "+e.util.varReplace(H,x,$)+" ":o+=" var "+x+" = "+$+"; "+H+" ",p&&(o+=" if (!"+g+") break; "),o+=" }"}return p&&(o+=" "+h+" if ("+m+" == errors) {"),o}},6585:e=>{var t=1e3,a=60*t,o=60*a,r=24*o,i=7*r,n=365.25*r;function plural(e,t,a,o){var r=t>=1.5*a;return Math.round(e/a)+" "+o+(r?"s":"")}e.exports=function(e,s){s=s||{};var c=typeof e;if("string"===c&&e.length>0)return function parse(e){if((e=String(e)).length>100)return;var s=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(!s)return;var c=parseFloat(s[1]);switch((s[2]||"ms").toLowerCase()){case"years":case"year":case"yrs":case"yr":case"y":return c*n;case"weeks":case"week":case"w":return c*i;case"days":case"day":case"d":return c*r;case"hours":case"hour":case"hrs":case"hr":case"h":return c*o;case"minutes":case"minute":case"mins":case"min":case"m":return c*a;case"seconds":case"second":case"secs":case"sec":case"s":return c*t;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return c;default:return}}(e);if("number"===c&&isFinite(e))return s.long?function fmtLong(e){var i=Math.abs(e);if(i>=r)return plural(e,i,r,"day");if(i>=o)return plural(e,i,o,"hour");if(i>=a)return plural(e,i,a,"minute");if(i>=t)return plural(e,i,t,"second");return e+" ms"}(e):function fmtShort(e){var i=Math.abs(e);if(i>=r)return Math.round(e/r)+"d";if(i>=o)return Math.round(e/o)+"h";if(i>=a)return Math.round(e/a)+"m";if(i>=t)return Math.round(e/t)+"s";return e+"ms"}(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))}},6641:(e,t,a)=>{var o=a(54774).Buffer,r={dsa:{parts:["p","q","g","y"],sizePart:"p"},rsa:{parts:["e","n"],sizePart:"n"},ecdsa:{parts:["curve","Q"],sizePart:"Q"},ed25519:{parts:["A"],sizePart:"A"}};r.curve25519=r.ed25519;var i={dsa:{parts:["p","q","g","y","x"]},rsa:{parts:["n","e","d","iqmp","p","q"]},ecdsa:{parts:["curve","Q","d"]},ed25519:{parts:["A","k"]}};i.curve25519=i.ed25519;var n={nistp256:{size:256,pkcs8oid:"1.2.840.10045.3.1.7",p:o.from("00ffffffff 00000001 00000000 0000000000000000 ffffffff ffffffff ffffffff".replace(/ /g,""),"hex"),a:o.from("00FFFFFFFF 00000001 00000000 0000000000000000 FFFFFFFF FFFFFFFF FFFFFFFC".replace(/ /g,""),"hex"),b:o.from("5ac635d8 aa3a93e7 b3ebbd55 769886bc651d06b0 cc53b0f6 3bce3c3e 27d2604b".replace(/ /g,""),"hex"),s:o.from("00c49d3608 86e70493 6a6678e1 139d26b7819f7e90".replace(/ /g,""),"hex"),n:o.from("00ffffffff 00000000 ffffffff ffffffffbce6faad a7179e84 f3b9cac2 fc632551".replace(/ /g,""),"hex"),G:o.from("046b17d1f2 e12c4247 f8bce6e5 63a440f277037d81 2deb33a0 f4a13945 d898c2964fe342e2 fe1a7f9b 8ee7eb4a 7c0f9e162bce3357 6b315ece cbb64068 37bf51f5".replace(/ /g,""),"hex")},nistp384:{size:384,pkcs8oid:"1.3.132.0.34",p:o.from("00ffffffff ffffffff ffffffff ffffffffffffffff ffffffff ffffffff fffffffeffffffff 00000000 00000000 ffffffff".replace(/ /g,""),"hex"),a:o.from("00FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFEFFFFFFFF 00000000 00000000 FFFFFFFC".replace(/ /g,""),"hex"),b:o.from("b3312fa7 e23ee7e4 988e056b e3f82d19181d9c6e fe814112 0314088f 5013875ac656398d 8a2ed19d 2a85c8ed d3ec2aef".replace(/ /g,""),"hex"),s:o.from("00a335926a a319a27a 1d00896a 6773a4827acdac73".replace(/ /g,""),"hex"),n:o.from("00ffffffff ffffffff ffffffff ffffffffffffffff ffffffff c7634d81 f4372ddf581a0db2 48b0a77a ecec196a ccc52973".replace(/ /g,""),"hex"),G:o.from("04aa87ca22 be8b0537 8eb1c71e f320ad746e1d3b62 8ba79b98 59f741e0 82542a385502f25d bf55296c 3a545e38 72760ab73617de4a 96262c6f 5d9e98bf 9292dc29f8f41dbd 289a147c e9da3113 b5f0b8c00a60b1ce 1d7e819d 7a431d7c 90ea0e5f".replace(/ /g,""),"hex")},nistp521:{size:521,pkcs8oid:"1.3.132.0.35",p:o.from("01ffffff ffffffff ffffffff ffffffffffffffff ffffffff ffffffff ffffffffffffffff ffffffff ffffffff ffffffffffffffff ffffffff ffffffff ffffffffffff".replace(/ /g,""),"hex"),a:o.from("01FFFFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFFFFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFC".replace(/ /g,""),"hex"),b:o.from("51953eb961 8e1c9a1f 929a21a0 b68540eea2da725b 99b315f3 b8b48991 8ef109e156193951 ec7e937b 1652c0bd 3bb1bf073573df88 3d2c34f1 ef451fd4 6b503f00".replace(/ /g,""),"hex"),s:o.from("00d09e8800 291cb853 96cc6717 393284aaa0da64ba".replace(/ /g,""),"hex"),n:o.from("01ffffffffff ffffffff ffffffff ffffffffffffffff ffffffff ffffffff fffffffa51868783 bf2f966b 7fcc0148 f709a5d03bb5c9b8 899c47ae bb6fb71e 91386409".replace(/ /g,""),"hex"),G:o.from("0400c6 858e06b7 0404e9cd 9e3ecb66 2395b4429c648139 053fb521 f828af60 6b4d3dbaa14b5e77 efe75928 fe1dc127 a2ffa8de3348b3c1 856a429b f97e7e31 c2e5bd660118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd998f54449 579b4468 17afbd17 273e662c97ee7299 5ef42640 c550b901 3fad0761353c7086 a272c240 88be9476 9fd16650".replace(/ /g,""),"hex")}};e.exports={info:r,privInfo:i,hashAlgs:{md5:!0,sha1:!0,sha256:!0,sha384:!0,sha512:!0},curves:n}},7011:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ResourceTemplate=t.McpServer=void 0;const o=a(27467),r=a(39340),i=a(21614),n=a(1294),s=a(20439),c=a(53945);t.McpServer=class McpServer{constructor(e,t){this._registeredResources={},this._registeredResourceTemplates={},this._registeredTools={},this._registeredPrompts={},this._toolHandlersInitialized=!1,this._completionHandlerInitialized=!1,this._resourceHandlersInitialized=!1,this._promptHandlersInitialized=!1,this.server=new o.Server(e,t)}async connect(e){return await this.server.connect(e)}async close(){await this.server.close()}setToolRequestHandlers(){this._toolHandlersInitialized||(this.server.assertCanSetRequestHandler(n.ListToolsRequestSchema.shape.method.value),this.server.assertCanSetRequestHandler(n.CallToolRequestSchema.shape.method.value),this.server.registerCapabilities({tools:{listChanged:!0}}),this.server.setRequestHandler(n.ListToolsRequestSchema,()=>({tools:Object.entries(this._registeredTools).filter(([,e])=>e.enabled).map(([e,t])=>({name:e,description:t.description,inputSchema:t.inputSchema?(0,r.zodToJsonSchema)(t.inputSchema,{strictUnions:!0}):p,annotations:t.annotations}))})),this.server.setRequestHandler(n.CallToolRequestSchema,async(e,t)=>{const a=this._registeredTools[e.params.name];if(!a)throw new n.McpError(n.ErrorCode.InvalidParams,`Tool ${e.params.name} not found`);if(!a.enabled)throw new n.McpError(n.ErrorCode.InvalidParams,`Tool ${e.params.name} disabled`);if(a.inputSchema){const o=await a.inputSchema.safeParseAsync(e.params.arguments);if(!o.success)throw new n.McpError(n.ErrorCode.InvalidParams,`Invalid arguments for tool ${e.params.name}: ${o.error.message}`);const r=o.data,i=a.callback;try{return await Promise.resolve(i(r,t))}catch(e){return{content:[{type:"text",text:e instanceof Error?e.message:String(e)}],isError:!0}}}else{const e=a.callback;try{return await Promise.resolve(e(t))}catch(e){return{content:[{type:"text",text:e instanceof Error?e.message:String(e)}],isError:!0}}}}),this._toolHandlersInitialized=!0)}setCompletionRequestHandler(){this._completionHandlerInitialized||(this.server.assertCanSetRequestHandler(n.CompleteRequestSchema.shape.method.value),this.server.setRequestHandler(n.CompleteRequestSchema,async e=>{switch(e.params.ref.type){case"ref/prompt":return this.handlePromptCompletion(e,e.params.ref);case"ref/resource":return this.handleResourceCompletion(e,e.params.ref);default:throw new n.McpError(n.ErrorCode.InvalidParams,`Invalid completion reference: ${e.params.ref}`)}}),this._completionHandlerInitialized=!0)}async handlePromptCompletion(e,t){const a=this._registeredPrompts[t.name];if(!a)throw new n.McpError(n.ErrorCode.InvalidParams,`Prompt ${t.name} not found`);if(!a.enabled)throw new n.McpError(n.ErrorCode.InvalidParams,`Prompt ${t.name} disabled`);if(!a.argsSchema)return u;const o=a.argsSchema.shape[e.params.argument.name];if(!(o instanceof s.Completable))return u;const r=o._def;return createCompletionResult(await r.complete(e.params.argument.value))}async handleResourceCompletion(e,t){const a=Object.values(this._registeredResourceTemplates).find(e=>e.resourceTemplate.uriTemplate.toString()===t.uri);if(!a){if(this._registeredResources[t.uri])return u;throw new n.McpError(n.ErrorCode.InvalidParams,`Resource template ${e.params.ref.uri} not found`)}const o=a.resourceTemplate.completeCallback(e.params.argument.name);if(!o)return u;return createCompletionResult(await o(e.params.argument.value))}setResourceRequestHandlers(){this._resourceHandlersInitialized||(this.server.assertCanSetRequestHandler(n.ListResourcesRequestSchema.shape.method.value),this.server.assertCanSetRequestHandler(n.ListResourceTemplatesRequestSchema.shape.method.value),this.server.assertCanSetRequestHandler(n.ReadResourceRequestSchema.shape.method.value),this.server.registerCapabilities({resources:{listChanged:!0}}),this.server.setRequestHandler(n.ListResourcesRequestSchema,async(e,t)=>{const a=Object.entries(this._registeredResources).filter(([e,t])=>t.enabled).map(([e,t])=>({uri:e,name:t.name,...t.metadata})),o=[];for(const e of Object.values(this._registeredResourceTemplates)){if(!e.resourceTemplate.listCallback)continue;const a=await e.resourceTemplate.listCallback(t);for(const t of a.resources)o.push({...t,...e.metadata})}return{resources:[...a,...o]}}),this.server.setRequestHandler(n.ListResourceTemplatesRequestSchema,async()=>({resourceTemplates:Object.entries(this._registeredResourceTemplates).map(([e,t])=>({name:e,uriTemplate:t.resourceTemplate.uriTemplate.toString(),...t.metadata}))})),this.server.setRequestHandler(n.ReadResourceRequestSchema,async(e,t)=>{const a=new URL(e.params.uri),o=this._registeredResources[a.toString()];if(o){if(!o.enabled)throw new n.McpError(n.ErrorCode.InvalidParams,`Resource ${a} disabled`);return o.readCallback(a,t)}for(const e of Object.values(this._registeredResourceTemplates)){const o=e.resourceTemplate.uriTemplate.match(a.toString());if(o)return e.readCallback(a,o,t)}throw new n.McpError(n.ErrorCode.InvalidParams,`Resource ${a} not found`)}),this.setCompletionRequestHandler(),this._resourceHandlersInitialized=!0)}setPromptRequestHandlers(){this._promptHandlersInitialized||(this.server.assertCanSetRequestHandler(n.ListPromptsRequestSchema.shape.method.value),this.server.assertCanSetRequestHandler(n.GetPromptRequestSchema.shape.method.value),this.server.registerCapabilities({prompts:{listChanged:!0}}),this.server.setRequestHandler(n.ListPromptsRequestSchema,()=>({prompts:Object.entries(this._registeredPrompts).filter(([,e])=>e.enabled).map(([e,t])=>{return{name:e,description:t.description,arguments:t.argsSchema?(a=t.argsSchema,Object.entries(a.shape).map(([e,t])=>({name:e,description:t.description,required:!t.isOptional()}))):void 0};var a})})),this.server.setRequestHandler(n.GetPromptRequestSchema,async(e,t)=>{const a=this._registeredPrompts[e.params.name];if(!a)throw new n.McpError(n.ErrorCode.InvalidParams,`Prompt ${e.params.name} not found`);if(!a.enabled)throw new n.McpError(n.ErrorCode.InvalidParams,`Prompt ${e.params.name} disabled`);if(a.argsSchema){const o=await a.argsSchema.safeParseAsync(e.params.arguments);if(!o.success)throw new n.McpError(n.ErrorCode.InvalidParams,`Invalid arguments for prompt ${e.params.name}: ${o.error.message}`);const r=o.data,i=a.callback;return await Promise.resolve(i(r,t))}{const e=a.callback;return await Promise.resolve(e(t))}}),this.setCompletionRequestHandler(),this._promptHandlersInitialized=!0)}resource(e,t,...a){let o;"object"==typeof a[0]&&(o=a.shift());const r=a[0];if("string"==typeof t){if(this._registeredResources[t])throw new Error(`Resource ${t} is already registered`);const a={name:e,metadata:o,readCallback:r,enabled:!0,disable:()=>a.update({enabled:!1}),enable:()=>a.update({enabled:!0}),remove:()=>a.update({uri:null}),update:e=>{void 0!==e.uri&&e.uri!==t&&(delete this._registeredResources[t],e.uri&&(this._registeredResources[e.uri]=a)),void 0!==e.name&&(a.name=e.name),void 0!==e.metadata&&(a.metadata=e.metadata),void 0!==e.callback&&(a.readCallback=e.callback),void 0!==e.enabled&&(a.enabled=e.enabled),this.sendResourceListChanged()}};return this._registeredResources[t]=a,this.setResourceRequestHandlers(),this.sendResourceListChanged(),a}{if(this._registeredResourceTemplates[e])throw new Error(`Resource template ${e} is already registered`);const a={resourceTemplate:t,metadata:o,readCallback:r,enabled:!0,disable:()=>a.update({enabled:!1}),enable:()=>a.update({enabled:!0}),remove:()=>a.update({name:null}),update:t=>{void 0!==t.name&&t.name!==e&&(delete this._registeredResourceTemplates[e],t.name&&(this._registeredResourceTemplates[t.name]=a)),void 0!==t.template&&(a.resourceTemplate=t.template),void 0!==t.metadata&&(a.metadata=t.metadata),void 0!==t.callback&&(a.readCallback=t.callback),void 0!==t.enabled&&(a.enabled=t.enabled),this.sendResourceListChanged()}};return this._registeredResourceTemplates[e]=a,this.setResourceRequestHandlers(),this.sendResourceListChanged(),a}}tool(e,...t){if(this._registeredTools[e])throw new Error(`Tool ${e} is already registered`);let a,o,r;if("string"==typeof t[0]&&(a=t.shift()),t.length>1){const e=t[0];isZodRawShape(e)?(o=t.shift(),t.length>1&&"object"==typeof t[0]&&null!==t[0]&&!isZodRawShape(t[0])&&(r=t.shift())):"object"==typeof e&&null!==e&&(r=t.shift())}const n=t[0],s={description:a,inputSchema:void 0===o?void 0:i.z.object(o),annotations:r,callback:n,enabled:!0,disable:()=>s.update({enabled:!1}),enable:()=>s.update({enabled:!0}),remove:()=>s.update({name:null}),update:t=>{void 0!==t.name&&t.name!==e&&(delete this._registeredTools[e],t.name&&(this._registeredTools[t.name]=s)),void 0!==t.description&&(s.description=t.description),void 0!==t.paramsSchema&&(s.inputSchema=i.z.object(t.paramsSchema)),void 0!==t.callback&&(s.callback=t.callback),void 0!==t.annotations&&(s.annotations=t.annotations),void 0!==t.enabled&&(s.enabled=t.enabled),this.sendToolListChanged()}};return this._registeredTools[e]=s,this.setToolRequestHandlers(),this.sendToolListChanged(),s}prompt(e,...t){if(this._registeredPrompts[e])throw new Error(`Prompt ${e} is already registered`);let a,o;"string"==typeof t[0]&&(a=t.shift()),t.length>1&&(o=t.shift());const r=t[0],n={description:a,argsSchema:void 0===o?void 0:i.z.object(o),callback:r,enabled:!0,disable:()=>n.update({enabled:!1}),enable:()=>n.update({enabled:!0}),remove:()=>n.update({name:null}),update:t=>{void 0!==t.name&&t.name!==e&&(delete this._registeredPrompts[e],t.name&&(this._registeredPrompts[t.name]=n)),void 0!==t.description&&(n.description=t.description),void 0!==t.argsSchema&&(n.argsSchema=i.z.object(t.argsSchema)),void 0!==t.callback&&(n.callback=t.callback),void 0!==t.enabled&&(n.enabled=t.enabled),this.sendPromptListChanged()}};return this._registeredPrompts[e]=n,this.setPromptRequestHandlers(),this.sendPromptListChanged(),n}isConnected(){return void 0!==this.server.transport}sendResourceListChanged(){this.isConnected()&&this.server.sendResourceListChanged()}sendToolListChanged(){this.isConnected()&&this.server.sendToolListChanged()}sendPromptListChanged(){this.isConnected()&&this.server.sendPromptListChanged()}};t.ResourceTemplate=class ResourceTemplate{constructor(e,t){this._callbacks=t,this._uriTemplate="string"==typeof e?new c.UriTemplate(e):e}get uriTemplate(){return this._uriTemplate}get listCallback(){return this._callbacks.list}completeCallback(e){var t;return null===(t=this._callbacks.complete)||void 0===t?void 0:t[e]}};const p={type:"object"};function isZodRawShape(e){if("object"!=typeof e||null===e)return!1;return 0===Object.keys(e).length||Object.values(e).some(isZodTypeLike)}function isZodTypeLike(e){return null!==e&&"object"==typeof e&&"parse"in e&&"function"==typeof e.parse&&"safeParse"in e&&"function"==typeof e.safeParse}function createCompletionResult(e){return{completion:{values:e.slice(0,100),total:e.length,hasMore:e.length>100}}}const u={completion:{values:[],hasMore:!1}}},7059:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t,a)=>o(e,t,a)<0},7106:e=>{"use strict";var t=e.exports=function(e,t,a){"function"==typeof t&&(a=t,t={}),_traverse(t,"function"==typeof(a=t.cb||a)?a:a.pre||function(){},a.post||function(){},e,"",e)};function _traverse(e,a,o,r,i,n,s,c,p,u){if(r&&"object"==typeof r&&!Array.isArray(r)){for(var l in a(r,i,n,s,c,p,u),r){var m=r[l];if(Array.isArray(m)){if(l in t.arrayKeywords)for(var f=0;f<m.length;f++)_traverse(e,a,o,m[f],i+"/"+l+"/"+f,n,i,l,r,f)}else if(l in t.propsKeywords){if(m&&"object"==typeof m)for(var h in m)_traverse(e,a,o,m[h],i+"/"+l+"/"+escapeJsonPtr(h),n,i,l,r,h)}else(l in t.keywords||e.allKeys&&!(l in t.skipKeywords))&&_traverse(e,a,o,m,i+"/"+l,n,i,l,r)}o(r,i,n,s,c,p,u)}}function escapeJsonPtr(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}t.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0,if:!0,then:!0,else:!0},t.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},t.propsKeywords={$defs:!0,definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},t.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7176:(e,t,a)=>{"use strict";var o,r=a(73126),i=a(75795);try{o=[].__proto__===Array.prototype}catch(e){if(!e||"object"!=typeof e||!("code"in e)||"ERR_PROTO_ACCESS"!==e.code)throw e}var n=!!o&&i&&i(Object.prototype,"__proto__"),s=Object,c=s.getPrototypeOf;e.exports=n&&"function"==typeof n.get?r([n.get]):"function"==typeof c&&function getDunder(e){return c(null==e?e:s(e))}},7598:(e,t,a)=>{e.exports=a(81813)},7600:e=>{"use strict";e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')},7870:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.assignDefaults=void 0;const o=a(99029),r=a(62586);function assignDefault(e,t,a){const{gen:i,compositeRule:n,data:s,opts:c}=e;if(void 0===a)return;const p=o._`${s}${o.getProperty(t)}`;if(n)return void r.checkStrictMode(e,`default is ignored for: ${p}`);let u=o._`${p} === undefined`;"empty"===c.useDefaults&&(u=o._`${u} || ${p} === null || ${p} === ""`),i.if(u,o._`${p} = ${o.stringify(a)}`)}t.assignDefaults=function assignDefaults(e,t){const{properties:a,items:o}=e.schema;if("object"===t&&a)for(const t in a)assignDefault(e,t,a[t].default);else"array"===t&&Array.isArray(o)&&o.forEach((t,a)=>assignDefault(e,a,t.default))}},7887:(e,t)=>{"use strict";function shouldUseGroup(e,t){return t.rules.some(t=>shouldUseRule(e,t))}function shouldUseRule(e,t){var a;return void 0!==e[t.keyword]||(null===(a=t.definition.implements)||void 0===a?void 0:a.some(t=>void 0!==e[t]))}Object.defineProperty(t,"__esModule",{value:!0}),t.shouldUseRule=t.shouldUseGroup=t.schemaHasRulesForType=void 0,t.schemaHasRulesForType=function schemaHasRulesForType({schema:e,self:t},a){const o=t.RULES.types[a];return o&&!0!==o&&shouldUseGroup(e,o)},t.shouldUseGroup=shouldUseGroup,t.shouldUseRule=shouldUseRule},7964:(e,t,a)=>{"use strict";e.exports={afterRequest:a(31662),beforeRequest:a(85159),browser:a(43083),cache:a(1045),content:a(67962),cookie:a(28443),creator:a(86771),entry:a(49367),har:a(85444),header:a(90948),log:a(93033),page:a(11958),pageTimings:a(97513),postData:a(38203),query:a(247),request:a(39290),response:a(95998),timings:a(64744)}},8468:e=>{"use strict";e.exports=function generate_oneOf(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="valid"+r,m="errs__"+r,f=e.util.copy(e),h="";f.level++;var g="valid"+f.level,y=f.baseId,b="prevValid"+r,x="passingSchemas"+r;o+="var "+m+" = errors , "+b+" = false , "+l+" = false , "+x+" = null; ";var w=e.compositeRule;e.compositeRule=f.compositeRule=!0;var k=n;if(k)for(var j,C=-1,P=k.length-1;C<P;)j=k[C+=1],(e.opts.strictKeywords?"object"==typeof j&&Object.keys(j).length>0||!1===j:e.util.schemaHasRules(j,e.RULES.all))?(f.schema=j,f.schemaPath=s+"["+C+"]",f.errSchemaPath=c+"/"+C,o+="  "+e.validate(f)+" ",f.baseId=y):o+=" var "+g+" = true; ",C&&(o+=" if ("+g+" && "+b+") { "+l+" = false; "+x+" = ["+x+", "+C+"]; } else { ",h+="}"),o+=" if ("+g+") { "+l+" = "+b+" = true; "+x+" = "+C+"; }";return e.compositeRule=f.compositeRule=w,o+=h+"if (!"+l+") {   var err =   ",!1!==e.createErrors?(o+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { passingSchemas: "+x+" } ",!1!==e.opts.messages&&(o+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&p&&(e.async?o+=" throw new ValidationError(vErrors); ":o+=" validate.errors = vErrors; return false; "),o+="} else {  errors = "+m+"; if (vErrors !== null) { if ("+m+") vErrors.length = "+m+"; else vErrors = null; }",e.opts.allErrors&&(o+=" } "),o}},8870:(e,t,a)=>{"use strict";var o=a(45143),r=a(16928).extname,i=a(70104),n=/^\s*([^;\s]*)(?:;|\s|$)/,s=/^text\//i;function charset(e){if(!e||"string"!=typeof e)return!1;var t=n.exec(e),a=t&&o[t[1].toLowerCase()];return a&&a.charset?a.charset:!(!t||!s.test(t[1]))&&"UTF-8"}function extension(e){if(!e||"string"!=typeof e)return!1;var a=n.exec(e),o=a&&t.extensions[a[1].toLowerCase()];return!(!o||!o.length)&&o[0]}function _preferredType(e,t,a){return(t?i(t,o[t].source):0)>(a?i(a,o[a].source):0)?t:a}function _preferredTypeLegacy(e,a,r){var i=["nginx","apache",void 0,"iana"],n=a?i.indexOf(o[a].source):0,s=r?i.indexOf(o[r].source):0;return"application/octet-stream"!==t.types[extension]&&(n>s||n===s&&"application/"===t.types[extension]?.slice(0,12))||n>s?a:r}t.charset=charset,t.charsets={lookup:charset},t.contentType=function contentType(e){if(!e||"string"!=typeof e)return!1;var a=-1===e.indexOf("/")?t.lookup(e):e;if(!a)return!1;if(-1===a.indexOf("charset")){var o=t.charset(a);o&&(a+="; charset="+o.toLowerCase())}return a},t.extension=extension,t.extensions=Object.create(null),t.lookup=function lookup(e){if(!e||"string"!=typeof e)return!1;var a=r("x."+e).toLowerCase().slice(1);if(!a)return!1;return t.types[a]||!1},t.types=Object.create(null),t._extensionConflicts=[],function populateMaps(e,a){Object.keys(o).forEach(function forEachMimeType(r){var i=o[r].extensions;if(i&&i.length){e[r]=i;for(var n=0;n<i.length;n++){var s=i[n];a[s]=_preferredType(s,a[s],r);const e=_preferredTypeLegacy(s,a[s],r);e!==a[s]&&t._extensionConflicts.push([s,e,a[s]])}}})}(t.extensions,t.types)},8904:(e,t,a)=>{"use strict";const o=a(12788),r={attributeNamePrefix:"@_",attributesGroupName:!1,textNodeName:"#text",ignoreAttributes:!0,cdataPropName:!1,format:!1,indentBy:"  ",suppressEmptyNode:!1,suppressUnpairedNode:!0,suppressBooleanAttributes:!0,tagValueProcessor:function(e,t){return t},attributeValueProcessor:function(e,t){return t},preserveOrder:!1,commentPropName:!1,unpairedTags:[],entities:[{regex:new RegExp("&","g"),val:"&amp;"},{regex:new RegExp(">","g"),val:"&gt;"},{regex:new RegExp("<","g"),val:"&lt;"},{regex:new RegExp("'","g"),val:"&apos;"},{regex:new RegExp('"',"g"),val:"&quot;"}],processEntities:!0,stopNodes:[],oneListGroup:!1};function Builder(e){this.options=Object.assign({},r,e),this.options.ignoreAttributes||this.options.attributesGroupName?this.isAttribute=function(){return!1}:(this.attrPrefixLen=this.options.attributeNamePrefix.length,this.isAttribute=isAttribute),this.processTextOrObjNode=processTextOrObjNode,this.options.format?(this.indentate=indentate,this.tagEndChar=">\n",this.newLine="\n"):(this.indentate=function(){return""},this.tagEndChar=">",this.newLine="")}function processTextOrObjNode(e,t,a){const o=this.j2x(e,a+1);return void 0!==e[this.options.textNodeName]&&1===Object.keys(e).length?this.buildTextValNode(e[this.options.textNodeName],t,o.attrStr,a):this.buildObjectNode(o.val,t,o.attrStr,a)}function indentate(e){return this.options.indentBy.repeat(e)}function isAttribute(e){return!!e.startsWith(this.options.attributeNamePrefix)&&e.substr(this.attrPrefixLen)}Builder.prototype.build=function(e){return this.options.preserveOrder?o(e,this.options):(Array.isArray(e)&&this.options.arrayNodeName&&this.options.arrayNodeName.length>1&&(e={[this.options.arrayNodeName]:e}),this.j2x(e,0).val)},Builder.prototype.j2x=function(e,t){let a="",o="";for(let r in e)if(void 0===e[r]);else if(null===e[r])"?"===r[0]?o+=this.indentate(t)+"<"+r+"?"+this.tagEndChar:o+=this.indentate(t)+"<"+r+"/"+this.tagEndChar;else if(e[r]instanceof Date)o+=this.buildTextValNode(e[r],r,"",t);else if("object"!=typeof e[r]){const i=this.isAttribute(r);if(i)a+=this.buildAttrPairStr(i,""+e[r]);else if(r===this.options.textNodeName){let t=this.options.tagValueProcessor(r,""+e[r]);o+=this.replaceEntitiesValue(t)}else o+=this.buildTextValNode(e[r],r,"",t)}else if(Array.isArray(e[r])){const a=e[r].length;let i="";for(let n=0;n<a;n++){const a=e[r][n];void 0===a||(null===a?"?"===r[0]?o+=this.indentate(t)+"<"+r+"?"+this.tagEndChar:o+=this.indentate(t)+"<"+r+"/"+this.tagEndChar:"object"==typeof a?this.options.oneListGroup?i+=this.j2x(a,t+1).val:i+=this.processTextOrObjNode(a,r,t):i+=this.buildTextValNode(a,r,"",t))}this.options.oneListGroup&&(i=this.buildObjectNode(i,r,"",t)),o+=i}else if(this.options.attributesGroupName&&r===this.options.attributesGroupName){const t=Object.keys(e[r]),o=t.length;for(let i=0;i<o;i++)a+=this.buildAttrPairStr(t[i],""+e[r][t[i]])}else o+=this.processTextOrObjNode(e[r],r,t);return{attrStr:a,val:o}},Builder.prototype.buildAttrPairStr=function(e,t){return t=this.options.attributeValueProcessor(e,""+t),t=this.replaceEntitiesValue(t),this.options.suppressBooleanAttributes&&"true"===t?" "+e:" "+e+'="'+t+'"'},Builder.prototype.buildObjectNode=function(e,t,a,o){if(""===e)return"?"===t[0]?this.indentate(o)+"<"+t+a+"?"+this.tagEndChar:this.indentate(o)+"<"+t+a+this.closeTag(t)+this.tagEndChar;{let r="</"+t+this.tagEndChar,i="";return"?"===t[0]&&(i="?",r=""),a&&-1===e.indexOf("<")?this.indentate(o)+"<"+t+a+i+">"+e+r:!1!==this.options.commentPropName&&t===this.options.commentPropName&&0===i.length?this.indentate(o)+`\x3c!--${e}--\x3e`+this.newLine:this.indentate(o)+"<"+t+a+i+this.tagEndChar+e+this.indentate(o)+r}},Builder.prototype.closeTag=function(e){let t="";return-1!==this.options.unpairedTags.indexOf(e)?this.options.suppressUnpairedNode||(t="/"):t=this.options.suppressEmptyNode?"/":`></${e}`,t},Builder.prototype.buildTextValNode=function(e,t,a,o){if(!1!==this.options.cdataPropName&&t===this.options.cdataPropName)return this.indentate(o)+`<![CDATA[${e}]]>`+this.newLine;if(!1!==this.options.commentPropName&&t===this.options.commentPropName)return this.indentate(o)+`\x3c!--${e}--\x3e`+this.newLine;if("?"===t[0])return this.indentate(o)+"<"+t+a+"?"+this.tagEndChar;{let r=this.options.tagValueProcessor(t,e);return r=this.replaceEntitiesValue(r),""===r?this.indentate(o)+"<"+t+a+this.closeTag(t)+this.tagEndChar:this.indentate(o)+"<"+t+a+">"+r+"</"+t+this.tagEndChar}},Builder.prototype.replaceEntitiesValue=function(e){if(e&&e.length>0&&this.options.processEntities)for(let t=0;t<this.options.entities.length;t++){const a=this.options.entities[t];e=e.replace(a.regex,a.val)}return e},e.exports=Builder},9314:e=>{var t={eachLimit:function(e,t,a,o){if(o=o||function(){},!e.length||t<=0)return o();var r=0,i=0,n=0;!function replenish(){if(r>=e.length)return o();for(;n<t&&i<e.length;)n+=1,a(e[(i+=1)-1],function(t){t?(o(t),o=function(){}):(n-=1,(r+=1)>=e.length?o():replenish())})}()},retry:function(e,t,a){var next=function(o){t(function(t,r){t&&o<e?next(o+1):a(t,r)})};e<1?a():next(1)}};e.exports=t},9400:(e,t,a)=>{const o=a(35334);function readEntityExp(e,t){let a="";for(;t<e.length&&"'"!==e[t]&&'"'!==e[t];t++)a+=e[t];if(a=a.trim(),-1!==a.indexOf(" "))throw new Error("External entites are not supported");const o=e[t++];let r="";for(;t<e.length&&e[t]!==o;t++)r+=e[t];return[a,r,t]}function isComment(e,t){return"!"===e[t+1]&&"-"===e[t+2]&&"-"===e[t+3]}function isEntity(e,t){return"!"===e[t+1]&&"E"===e[t+2]&&"N"===e[t+3]&&"T"===e[t+4]&&"I"===e[t+5]&&"T"===e[t+6]&&"Y"===e[t+7]}function isElement(e,t){return"!"===e[t+1]&&"E"===e[t+2]&&"L"===e[t+3]&&"E"===e[t+4]&&"M"===e[t+5]&&"E"===e[t+6]&&"N"===e[t+7]&&"T"===e[t+8]}function isAttlist(e,t){return"!"===e[t+1]&&"A"===e[t+2]&&"T"===e[t+3]&&"T"===e[t+4]&&"L"===e[t+5]&&"I"===e[t+6]&&"S"===e[t+7]&&"T"===e[t+8]}function isNotation(e,t){return"!"===e[t+1]&&"N"===e[t+2]&&"O"===e[t+3]&&"T"===e[t+4]&&"A"===e[t+5]&&"T"===e[t+6]&&"I"===e[t+7]&&"O"===e[t+8]&&"N"===e[t+9]}function validateEntityName(e){if(o.isName(e))return e;throw new Error(`Invalid entity name ${e}`)}e.exports=function readDocType(e,t){const a={};if("O"!==e[t+3]||"C"!==e[t+4]||"T"!==e[t+5]||"Y"!==e[t+6]||"P"!==e[t+7]||"E"!==e[t+8])throw new Error("Invalid Tag instead of DOCTYPE");{t+=9;let o=1,r=!1,i=!1,n="";for(;t<e.length;t++)if("<"!==e[t]||i)if(">"===e[t]){if(i?"-"===e[t-1]&&"-"===e[t-2]&&(i=!1,o--):o--,0===o)break}else"["===e[t]?r=!0:n+=e[t];else{if(r&&isEntity(e,t))t+=7,[entityName,val,t]=readEntityExp(e,t+1),-1===val.indexOf("&")&&(a[validateEntityName(entityName)]={regx:RegExp(`&${entityName};`,"g"),val});else if(r&&isElement(e,t))t+=8;else if(r&&isAttlist(e,t))t+=8;else if(r&&isNotation(e,t))t+=9;else{if(!isComment)throw new Error("Invalid DOCTYPE");i=!0}o++,n=""}if(0!==o)throw new Error("Unclosed DOCTYPE")}return{entities:a,i:t}}},9568:e=>{"use strict";e.exports=function generate_comment(e,t,a){var o=" ",r=e.schema[t],i=e.errSchemaPath+"/"+t,n=(e.opts.allErrors,e.util.toQuotedString(r));return!0===e.opts.$comment?o+=" console.log("+n+");":"function"==typeof e.opts.$comment&&(o+=" self._opts.$comment("+n+", "+e.util.toQuotedString(i)+", validate.root.schema);"),o}},9797:(e,t,a)=>{"use strict";const o=a(84865);e.exports=(e,t={})=>{if("function"!=typeof e)throw new TypeError(`Expected the first argument to be a function, got \`${typeof e}\``);const{wait:a=0,before:r=!1,after:i=!0}=t;if(!r&&!i)throw new Error("Both `before` and `after` are false, function wouldn't be called.");let n,s;const debouncedFunction=function(...t){const o=this,c=r&&!n;return clearTimeout(n),n=setTimeout(()=>{n=void 0,i&&(s=e.apply(o,t))},a),c&&(s=e.apply(o,t)),s};return o(debouncedFunction,e),debouncedFunction.cancel=()=>{n&&(clearTimeout(n),n=void 0)},debouncedFunction}},9957:(e,t,a)=>{"use strict";var o=Function.prototype.call,r=Object.prototype.hasOwnProperty,i=a(66743);e.exports=i.call(o,r)},9970:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t,a)=>o(t,e,a)},10076:e=>{"use strict";e.exports=Function.prototype.call},10208:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.reportTypeError=t.checkDataTypes=t.checkDataType=t.coerceAndCheckDataType=t.getJSONTypes=t.getSchemaTypes=t.DataType=void 0;const o=a(10396),r=a(7887),i=a(48708),n=a(99029),s=a(94227);var c;function getJSONTypes(e){const t=Array.isArray(e)?e:e?[e]:[];if(t.every(o.isJSONType))return t;throw new Error("type must be JSONType or JSONType[]: "+t.join(","))}!function(e){e[e.Correct=0]="Correct",e[e.Wrong=1]="Wrong"}(c=t.DataType||(t.DataType={})),t.getSchemaTypes=function getSchemaTypes(e){const t=getJSONTypes(e.type);if(t.includes("null")){if(!1===e.nullable)throw new Error("type: null contradicts nullable: false")}else{if(!t.length&&void 0!==e.nullable)throw new Error('"nullable" cannot be used without "type"');!0===e.nullable&&t.push("null")}return t},t.getJSONTypes=getJSONTypes,t.coerceAndCheckDataType=function coerceAndCheckDataType(e,t){const{gen:a,data:o,opts:i}=e,s=function coerceToTypes(e,t){return t?e.filter(e=>p.has(e)||"array"===t&&"array"===e):[]}(t,i.coerceTypes),u=t.length>0&&!(0===s.length&&1===t.length&&r.schemaHasRulesForType(e,t[0]));if(u){const r=checkDataTypes(t,o,i.strict,c.Wrong);a.if(r,()=>{s.length?function coerceData(e,t,a){const{gen:o,data:r,opts:i}=e,s=o.let("dataType",n._`typeof ${r}`),c=o.let("coerced",n._`undefined`);"array"===i.coerceTypes&&o.if(n._`${s} == 'object' && Array.isArray(${r}) && ${r}.length == 1`,()=>o.assign(r,n._`${r}[0]`).assign(s,n._`typeof ${r}`).if(checkDataTypes(t,r,i.strict),()=>o.assign(c,r)));o.if(n._`${c} !== undefined`);for(const e of a)(p.has(e)||"array"===e&&"array"===i.coerceTypes)&&coerceSpecificType(e);function coerceSpecificType(e){switch(e){case"string":return void o.elseIf(n._`${s} == "number" || ${s} == "boolean"`).assign(c,n._`"" + ${r}`).elseIf(n._`${r} === null`).assign(c,n._`""`);case"number":return void o.elseIf(n._`${s} == "boolean" || ${r} === null
              || (${s} == "string" && ${r} && ${r} == +${r})`).assign(c,n._`+${r}`);case"integer":return void o.elseIf(n._`${s} === "boolean" || ${r} === null
              || (${s} === "string" && ${r} && ${r} == +${r} && !(${r} % 1))`).assign(c,n._`+${r}`);case"boolean":return void o.elseIf(n._`${r} === "false" || ${r} === 0 || ${r} === null`).assign(c,!1).elseIf(n._`${r} === "true" || ${r} === 1`).assign(c,!0);case"null":return o.elseIf(n._`${r} === "" || ${r} === 0 || ${r} === false`),void o.assign(c,null);case"array":o.elseIf(n._`${s} === "string" || ${s} === "number"
              || ${s} === "boolean" || ${r} === null`).assign(c,n._`[${r}]`)}}o.else(),reportTypeError(e),o.endIf(),o.if(n._`${c} !== undefined`,()=>{o.assign(r,c),function assignParentData({gen:e,parentData:t,parentDataProperty:a},o){e.if(n._`${t} !== undefined`,()=>e.assign(n._`${t}[${a}]`,o))}(e,c)})}(e,t,s):reportTypeError(e)})}return u};const p=new Set(["string","number","integer","boolean","null"]);function checkDataType(e,t,a,o=c.Correct){const r=o===c.Correct?n.operators.EQ:n.operators.NEQ;let i;switch(e){case"null":return n._`${t} ${r} null`;case"array":i=n._`Array.isArray(${t})`;break;case"object":i=n._`${t} && typeof ${t} == "object" && !Array.isArray(${t})`;break;case"integer":i=numCond(n._`!(${t} % 1) && !isNaN(${t})`);break;case"number":i=numCond();break;default:return n._`typeof ${t} ${r} ${e}`}return o===c.Correct?i:n.not(i);function numCond(e=n.nil){return n.and(n._`typeof ${t} == "number"`,e,a?n._`isFinite(${t})`:n.nil)}}function checkDataTypes(e,t,a,o){if(1===e.length)return checkDataType(e[0],t,a,o);let r;const i=s.toHash(e);if(i.array&&i.object){const e=n._`typeof ${t} != "object"`;r=i.null?e:n._`!${t} || ${e}`,delete i.null,delete i.array,delete i.object}else r=n.nil;i.number&&delete i.integer;for(const e in i)r=n.and(r,checkDataType(e,t,a,o));return r}t.checkDataType=checkDataType,t.checkDataTypes=checkDataTypes;const u={message:({schema:e})=>n.str`should be ${e}`,params:({schema:e,schemaValue:t})=>"string"==typeof e?n._`{type: ${e}}`:n._`{type: ${t}}`};function reportTypeError(e){const t=function getTypeErrorContext(e){const{gen:t,data:a,schema:o}=e,r=s.schemaRefOrVal(e,o,"type");return{gen:t,keyword:"type",data:a,schema:o.type,schemaCode:r,schemaValue:r,parentSchema:o,params:{},it:e}}(e);i.reportError(t,u)}t.reportTypeError=reportTypeError},10396:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getRules=t.isJSONType=void 0;const a=new Set(["string","number","integer","boolean","null","object","array"]);t.isJSONType=function isJSONType(e){return"string"==typeof e&&a.has(e)},t.getRules=function getRules(){const e={number:{type:"number",rules:[]},string:{type:"string",rules:[]},array:{type:"array",rules:[]},object:{type:"object",rules:[]}};return{types:{...e,integer:!0,boolean:!0,null:!0},rules:[{rules:[]},e.number,e.string,e.array,e.object],post:{rules:[]},all:{},keywords:{}}}},10617:(e,t,a)=>{"use strict";var o=a(18568),r=a(80112),i=a(20780),n=a(48407),s=a(72492),c=a(27832),p=a(33127),u=a(69192),l=a(34610);e.exports=Ajv,Ajv.prototype.validate=function validate(e,t){var a;if("string"==typeof e){if(!(a=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{var o=this._addSchema(e);a=o.validate||this._compile(o)}var r=a(t);!0!==a.$async&&(this.errors=a.errors);return r},Ajv.prototype.compile=function compile(e,t){var a=this._addSchema(e,void 0,t);return a.validate||this._compile(a)},Ajv.prototype.addSchema=function addSchema(e,t,a,o){if(Array.isArray(e)){for(var i=0;i<e.length;i++)this.addSchema(e[i],void 0,a,o);return this}var n=this._getId(e);if(void 0!==n&&"string"!=typeof n)throw new Error("schema id must be string");return checkUnique(this,t=r.normalizeId(t||n)),this._schemas[t]=this._addSchema(e,a,o,!0),this},Ajv.prototype.addMetaSchema=function addMetaSchema(e,t,a){return this.addSchema(e,t,a,!0),this},Ajv.prototype.validateSchema=function validateSchema(e,t){var a=e.$schema;if(void 0!==a&&"string"!=typeof a)throw new Error("$schema must be a string");if(!(a=a||this._opts.defaultMeta||function defaultMeta(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(h)?h:void 0,e._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),this.errors=null,!0;var o=this.validate(a,e);if(!o&&t){var r="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(r);this.logger.error(r)}return o},Ajv.prototype.getSchema=function getSchema(e){var t=_getSchemaObj(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function _getSchemaFragment(e,t){var a=r.schema.call(e,{schema:{}},t);if(a){var i=a.schema,s=a.root,c=a.baseId,p=o.call(e,i,s,void 0,c);return e._fragments[t]=new n({ref:t,fragment:!0,schema:i,root:s,baseId:c,validate:p}),p}}(this,e)}},Ajv.prototype.removeSchema=function removeSchema(e){if(e instanceof RegExp)return _removeAllSchemas(this,this._schemas,e),_removeAllSchemas(this,this._refs,e),this;switch(typeof e){case"undefined":return _removeAllSchemas(this,this._schemas),_removeAllSchemas(this,this._refs),this._cache.clear(),this;case"string":var t=_getSchemaObj(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":var a=this._opts.serialize,o=a?a(e):e;this._cache.del(o);var i=this._getId(e);i&&(i=r.normalizeId(i),delete this._schemas[i],delete this._refs[i])}return this},Ajv.prototype.addFormat=function addFormat(e,t){"string"==typeof t&&(t=new RegExp(t));return this._formats[e]=t,this},Ajv.prototype.errorsText=function errorsText(e,t){if(!(e=e||this.errors))return"No errors";for(var a=void 0===(t=t||{}).separator?", ":t.separator,o=void 0===t.dataVar?"data":t.dataVar,r="",i=0;i<e.length;i++){var n=e[i];n&&(r+=o+n.dataPath+" "+n.message+a)}return r.slice(0,-a.length)},Ajv.prototype._addSchema=function _addSchema(e,t,a,o){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var i=this._opts.serialize,s=i?i(e):e,c=this._cache.get(s);if(c)return c;o=o||!1!==this._opts.addUsedSchema;var p=r.normalizeId(this._getId(e));p&&o&&checkUnique(this,p);var u,l=!1!==this._opts.validateSchema&&!t;l&&!(u=p&&p==r.normalizeId(e.$schema))&&this.validateSchema(e,!0);var m=r.ids.call(this,e),f=new n({id:p,schema:e,localRefs:m,cacheKey:s,meta:a});"#"!=p[0]&&o&&(this._refs[p]=f);this._cache.put(s,f),l&&u&&this.validateSchema(e,!0);return f},Ajv.prototype._compile=function _compile(e,t){if(e.compiling)return e.validate=callValidate,callValidate.schema=e.schema,callValidate.errors=null,callValidate.root=t||callValidate,!0===e.schema.$async&&(callValidate.$async=!0),callValidate;var a,r;e.compiling=!0,e.meta&&(a=this._opts,this._opts=this._metaOpts);try{r=o.call(this,e.schema,t,e.localRefs)}catch(t){throw delete e.validate,t}finally{e.compiling=!1,e.meta&&(this._opts=a)}return e.validate=r,e.refs=r.refs,e.refVal=r.refVal,e.root=r.root,r;function callValidate(){var t=e.validate,a=t.apply(this,arguments);return callValidate.errors=t.errors,a}},Ajv.prototype.compileAsync=a(48244);var m=a(62937);Ajv.prototype.addKeyword=m.add,Ajv.prototype.getKeyword=m.get,Ajv.prototype.removeKeyword=m.remove,Ajv.prototype.validateKeyword=m.validate;var f=a(80613);Ajv.ValidationError=f.Validation,Ajv.MissingRefError=f.MissingRef,Ajv.$dataMetaSchema=u;var h="http://json-schema.org/draft-07/schema",g=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],y=["/properties"];function Ajv(e){if(!(this instanceof Ajv))return new Ajv(e);e=this._opts=l.copy(e)||{},function setLogger(e){var t=e._opts.logger;if(!1===t)e.logger={log:noop,warn:noop,error:noop};else{if(void 0===t&&(t=console),!("object"==typeof t&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}(this),this._schemas={},this._refs={},this._fragments={},this._formats=c(e.format),this._cache=e.cache||new i,this._loadingSchemas={},this._compilations=[],this.RULES=p(),this._getId=function chooseGetId(e){switch(e.schemaId){case"auto":return _get$IdOrId;case"id":return _getId;default:return _get$Id}}(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=s),this._metaOpts=function getMetaSchemaOptions(e){for(var t=l.copy(e._opts),a=0;a<g.length;a++)delete t[g[a]];return t}(this),e.formats&&function addInitialFormats(e){for(var t in e._opts.formats){var a=e._opts.formats[t];e.addFormat(t,a)}}(this),e.keywords&&function addInitialKeywords(e){for(var t in e._opts.keywords){var a=e._opts.keywords[t];e.addKeyword(t,a)}}(this),function addDefaultMetaSchema(e){var t;e._opts.$data&&(t=a(61970),e.addMetaSchema(t,t.$id,!0));if(!1===e._opts.meta)return;var o=a(7600);e._opts.$data&&(o=u(o,y));e.addMetaSchema(o,h,!0),e._refs["http://json-schema.org/schema"]=h}(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),function addInitialSchemas(e){var t=e._opts.schemas;if(!t)return;if(Array.isArray(t))e.addSchema(t);else for(var a in t)e.addSchema(t[a],a)}(this)}function _getSchemaObj(e,t){return t=r.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function _removeAllSchemas(e,t,a){for(var o in t){var r=t[o];r.meta||a&&!a.test(o)||(e._cache.del(r.cacheKey),delete t[o])}}function _getId(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function _get$Id(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function _get$IdOrId(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function checkUnique(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function noop(){}},10705:e=>{"use strict";e.exports=JSON.parse('{"100":"Continue","101":"Switching Protocols","102":"Processing","103":"Early Hints","200":"OK","201":"Created","202":"Accepted","203":"Non-Authoritative Information","204":"No Content","205":"Reset Content","206":"Partial Content","207":"Multi-Status","208":"Already Reported","226":"IM Used","300":"Multiple Choices","301":"Moved Permanently","302":"Found","303":"See Other","304":"Not Modified","305":"Use Proxy","306":"(Unused)","307":"Temporary Redirect","308":"Permanent Redirect","400":"Bad Request","401":"Unauthorized","402":"Payment Required","403":"Forbidden","404":"Not Found","405":"Method Not Allowed","406":"Not Acceptable","407":"Proxy Authentication Required","408":"Request Timeout","409":"Conflict","410":"Gone","411":"Length Required","412":"Precondition Failed","413":"Payload Too Large","414":"URI Too Long","415":"Unsupported Media Type","416":"Range Not Satisfiable","417":"Expectation Failed","418":"I\'m a teapot","421":"Misdirected Request","422":"Unprocessable Entity","423":"Locked","424":"Failed Dependency","425":"Unordered Collection","426":"Upgrade Required","428":"Precondition Required","429":"Too Many Requests","431":"Request Header Fields Too Large","451":"Unavailable For Legal Reasons","500":"Internal Server Error","501":"Not Implemented","502":"Bad Gateway","503":"Service Unavailable","504":"Gateway Timeout","505":"HTTP Version Not Supported","506":"Variant Also Negotiates","507":"Insufficient Storage","508":"Loop Detected","509":"Bandwidth Limit Exceeded","510":"Not Extended","511":"Network Authentication Required"}')},11002:e=>{"use strict";e.exports=Function.prototype.apply},11054:(e,t,a)=>{"use strict";var o=a(92849),r=a(75997),i=a(64179).paramsHaveRequestBody;function initParams(e,t,a){"function"==typeof t&&(a=t);var r={};return null!==t&&"object"==typeof t?o(r,t,{uri:e}):o(r,"string"==typeof e?{uri:e}:e),r.callback=a||r.callback,r}function request(e,t,a){if(void 0===e)throw new Error("undefined is not a valid uri or options object.");var o=initParams(e,t,a);if("HEAD"===o.method&&i(o))throw new Error("HTTP HEAD requests MUST NOT include a request body.");return new request.Request(o)}function verbFunc(e){var t=e.toUpperCase();return function(e,a,o){var r=initParams(e,a,o);return r.method=t,request(r,r.callback)}}function wrapRequestMethod(e,t,a,r){return function(i,n,s){var c=initParams(i,n,s),p={};return o(!0,p,t,c),p.pool=c.pool||t.pool,r&&(p.method=r.toUpperCase()),"function"==typeof a&&(e=a),e(p,p.callback)}}request.get=verbFunc("get"),request.head=verbFunc("head"),request.options=verbFunc("options"),request.post=verbFunc("post"),request.put=verbFunc("put"),request.patch=verbFunc("patch"),request.del=verbFunc("delete"),request.delete=verbFunc("delete"),request.jar=function(e){return r.jar(e)},request.cookie=function(e){return r.parse(e)},request.defaults=function(e,t){var a=this;"function"==typeof(e=e||{})&&(t=e,e={});var o=wrapRequestMethod(a,e,t);return["get","head","post","put","patch","del","delete"].forEach(function(r){o[r]=wrapRequestMethod(a[r],e,t,r)}),o.cookie=wrapRequestMethod(a.cookie,e,t),o.jar=a.jar,o.defaults=a.defaults,o},request.forever=function(e,t){var a={};return t&&o(a,t),e&&(a.agentOptions=e),a.forever=!0,request.defaults(a)},e.exports=request,request.Request=a(65023),request.initParams=initParams,Object.defineProperty(request,"debug",{enumerable:!0,get:function(){return request.Request.debug},set:function(e){request.Request.debug=e}})},11076:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getRefs=void 0;const o=a(92626);t.getRefs=e=>{const t=(0,o.getDefaultOptions)(e),a=void 0!==t.name?[...t.basePath,t.definitionPath,t.name]:t.basePath;return{...t,currentPath:a,propertyPath:void 0,seen:new Map(Object.entries(t.definitions).map(([e,a])=>[a._def,{def:a._def,path:[...t.basePath,t.definitionPath,e],jsonSchema:void 0}]))}}},11102:(e,t,a)=>{var o=a(23826),r=a(4982);function assert(e,t,a,r){if(!e)throw o(t,a,r)}e.exports=assert,assert.fail=function(e,t,a){assert(!1,e,t,a)},assert.equal=function(e,t,a,o,r){assert(e==t,a,o,r)},assert.notEqual=function(e,t,a,o,r){assert(e!=t,a,o,r)},assert.ok=function(e,t,a,o){assert(e,t,a,o)},assert.strictEqual=function(e,t,a,o,r){assert(e===t,a,o,r)},assert.notStrictEqual=function(e,t,a,o,r){assert(e!==t,a,o,r)},assert.deepEqual=function(e,t,a,o,i){assert(r(e,t),a,o,i)},assert.notDeepEqual=function(e,t,a,o,i){assert(!r(e,t),a,o,i)}},11431:(e,t,a)=>{var o=a(42613),r=a(54774).Buffer,i=a(16299),n=a(76395).newInvalidAsn1Error,s={size:1024,growthFactor:8};function Writer(e){e=function merge(e,t){return o.ok(e),o.equal(typeof e,"object"),o.ok(t),o.equal(typeof t,"object"),Object.getOwnPropertyNames(e).forEach(function(a){if(!t[a]){var o=Object.getOwnPropertyDescriptor(e,a);Object.defineProperty(t,a,o)}}),t}(s,e||{}),this._buf=r.alloc(e.size||1024),this._size=this._buf.length,this._offset=0,this._options=e,this._seq=[]}Object.defineProperty(Writer.prototype,"buffer",{get:function(){if(this._seq.length)throw n(this._seq.length+" unended sequence(s)");return this._buf.slice(0,this._offset)}}),Writer.prototype.writeByte=function(e){if("number"!=typeof e)throw new TypeError("argument must be a Number");this._ensure(1),this._buf[this._offset++]=e},Writer.prototype.writeInt=function(e,t){if("number"!=typeof e)throw new TypeError("argument must be a Number");"number"!=typeof t&&(t=i.Integer);for(var a=4;(!(4286578688&e)||-8388608==(4286578688&e))&&a>1;)a--,e<<=8;if(a>4)throw n("BER ints cannot be > 0xffffffff");for(this._ensure(2+a),this._buf[this._offset++]=t,this._buf[this._offset++]=a;a-- >0;)this._buf[this._offset++]=(4278190080&e)>>>24,e<<=8},Writer.prototype.writeNull=function(){this.writeByte(i.Null),this.writeByte(0)},Writer.prototype.writeEnumeration=function(e,t){if("number"!=typeof e)throw new TypeError("argument must be a Number");return"number"!=typeof t&&(t=i.Enumeration),this.writeInt(e,t)},Writer.prototype.writeBoolean=function(e,t){if("boolean"!=typeof e)throw new TypeError("argument must be a Boolean");"number"!=typeof t&&(t=i.Boolean),this._ensure(3),this._buf[this._offset++]=t,this._buf[this._offset++]=1,this._buf[this._offset++]=e?255:0},Writer.prototype.writeString=function(e,t){if("string"!=typeof e)throw new TypeError("argument must be a string (was: "+typeof e+")");"number"!=typeof t&&(t=i.OctetString);var a=r.byteLength(e);this.writeByte(t),this.writeLength(a),a&&(this._ensure(a),this._buf.write(e,this._offset),this._offset+=a)},Writer.prototype.writeBuffer=function(e,t){if("number"!=typeof t)throw new TypeError("tag must be a number");if(!r.isBuffer(e))throw new TypeError("argument must be a buffer");this.writeByte(t),this.writeLength(e.length),this._ensure(e.length),e.copy(this._buf,this._offset,0,e.length),this._offset+=e.length},Writer.prototype.writeStringArray=function(e){if(!e instanceof Array)throw new TypeError("argument must be an Array[String]");var t=this;e.forEach(function(e){t.writeString(e)})},Writer.prototype.writeOID=function(e,t){if("string"!=typeof e)throw new TypeError("argument must be a string");if("number"!=typeof t&&(t=i.OID),!/^([0-9]+\.){3,}[0-9]+$/.test(e))throw new Error("argument is not a valid OID string");var a=e.split("."),o=[];o.push(40*parseInt(a[0],10)+parseInt(a[1],10)),a.slice(2).forEach(function(e){!function encodeOctet(e,t){t<128?e.push(t):t<16384?(e.push(t>>>7|128),e.push(127&t)):t<2097152?(e.push(t>>>14|128),e.push(t>>>7&255|128),e.push(127&t)):t<268435456?(e.push(t>>>21|128),e.push(t>>>14&255|128),e.push(t>>>7&255|128),e.push(127&t)):(e.push(t>>>28&255|128),e.push(t>>>21&255|128),e.push(t>>>14&255|128),e.push(t>>>7&255|128),e.push(127&t))}(o,parseInt(e,10))});var r=this;this._ensure(2+o.length),this.writeByte(t),this.writeLength(o.length),o.forEach(function(e){r.writeByte(e)})},Writer.prototype.writeLength=function(e){if("number"!=typeof e)throw new TypeError("argument must be a Number");if(this._ensure(4),e<=127)this._buf[this._offset++]=e;else if(e<=255)this._buf[this._offset++]=129,this._buf[this._offset++]=e;else if(e<=65535)this._buf[this._offset++]=130,this._buf[this._offset++]=e>>8,this._buf[this._offset++]=e;else{if(!(e<=16777215))throw n("Length too long (> 4 bytes)");this._buf[this._offset++]=131,this._buf[this._offset++]=e>>16,this._buf[this._offset++]=e>>8,this._buf[this._offset++]=e}},Writer.prototype.startSequence=function(e){"number"!=typeof e&&(e=i.Sequence|i.Constructor),this.writeByte(e),this._seq.push(this._offset),this._ensure(3),this._offset+=3},Writer.prototype.endSequence=function(){var e=this._seq.pop(),t=e+3,a=this._offset-t;if(a<=127)this._shift(t,a,-2),this._buf[e]=a;else if(a<=255)this._shift(t,a,-1),this._buf[e]=129,this._buf[e+1]=a;else if(a<=65535)this._buf[e]=130,this._buf[e+1]=a>>8,this._buf[e+2]=a;else{if(!(a<=16777215))throw n("Sequence too long");this._shift(t,a,1),this._buf[e]=131,this._buf[e+1]=a>>16,this._buf[e+2]=a>>8,this._buf[e+3]=a}},Writer.prototype._shift=function(e,t,a){o.ok(void 0!==e),o.ok(void 0!==t),o.ok(a),this._buf.copy(this._buf,e+a,e,e+t),this._offset+=a},Writer.prototype._ensure=function(e){if(o.ok(e),this._size-this._offset<e){var t=this._size*this._options.growthFactor;t-this._offset<e&&(t+=e);var a=r.alloc(t);this._buf.copy(a,0,0,this._offset),this._buf=a,this._size=t}},e.exports=Writer},11763:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t)=>o(e,t,!0)},11958:e=>{"use strict";e.exports=JSON.parse('{"$id":"page.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","optional":true,"required":["startedDateTime","id","title","pageTimings"],"properties":{"startedDateTime":{"type":"string","format":"date-time","pattern":"^(\\\\d{4})(-)?(\\\\d\\\\d)(-)?(\\\\d\\\\d)(T)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(\\\\.\\\\d+)?(Z|([+-])(\\\\d\\\\d)(:)?(\\\\d\\\\d))"},"id":{"type":"string","unique":true},"title":{"type":"string"},"pageTimings":{"$ref":"pageTimings.json#"},"comment":{"type":"string"}}}')},12146:(e,t)=>{"use strict";var a,o;Object.defineProperty(t,"__esModule",{value:!0}),t.getParsedType=t.ZodParsedType=t.objectUtil=t.util=void 0,function(e){e.assertEqual=e=>e,e.assertIs=function assertIs(e){},e.assertNever=function assertNever(e){throw new Error},e.arrayToEnum=e=>{const t={};for(const a of e)t[a]=a;return t},e.getValidEnumValues=t=>{const a=e.objectKeys(t).filter(e=>"number"!=typeof t[t[e]]),o={};for(const e of a)o[e]=t[e];return e.objectValues(o)},e.objectValues=t=>e.objectKeys(t).map(function(e){return t[e]}),e.objectKeys="function"==typeof Object.keys?e=>Object.keys(e):e=>{const t=[];for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&t.push(a);return t},e.find=(e,t)=>{for(const a of e)if(t(a))return a},e.isInteger="function"==typeof Number.isInteger?e=>Number.isInteger(e):e=>"number"==typeof e&&isFinite(e)&&Math.floor(e)===e,e.joinValues=function joinValues(e,t=" | "){return e.map(e=>"string"==typeof e?`'${e}'`:e).join(t)},e.jsonStringifyReplacer=(e,t)=>"bigint"==typeof t?t.toString():t}(a||(t.util=a={})),function(e){e.mergeShapes=(e,t)=>({...e,...t})}(o||(t.objectUtil=o={})),t.ZodParsedType=a.arrayToEnum(["string","nan","number","integer","float","boolean","date","bigint","symbol","function","undefined","null","array","object","unknown","promise","void","never","map","set"]);t.getParsedType=e=>{switch(typeof e){case"undefined":return t.ZodParsedType.undefined;case"string":return t.ZodParsedType.string;case"number":return isNaN(e)?t.ZodParsedType.nan:t.ZodParsedType.number;case"boolean":return t.ZodParsedType.boolean;case"function":return t.ZodParsedType.function;case"bigint":return t.ZodParsedType.bigint;case"symbol":return t.ZodParsedType.symbol;case"object":return Array.isArray(e)?t.ZodParsedType.array:null===e?t.ZodParsedType.null:e.then&&"function"==typeof e.then&&e.catch&&"function"==typeof e.catch?t.ZodParsedType.promise:"undefined"!=typeof Map&&e instanceof Map?t.ZodParsedType.map:"undefined"!=typeof Set&&e instanceof Set?t.ZodParsedType.set:"undefined"!=typeof Date&&e instanceof Date?t.ZodParsedType.date:t.ZodParsedType.object;default:return t.ZodParsedType.unknown}}},12550:(e,t,a)=>{var o=a(14551),r=a(60471);e.exports=function v4(e,t,a){var i=t&&a||0;"string"==typeof e&&(t="binary"===e?new Array(16):null,e=null);var n=(e=e||{}).random||(e.rng||o)();if(n[6]=15&n[6]|64,n[8]=63&n[8]|128,t)for(var s=0;s<16;++s)t[i+s]=n[s];return t||r(n)}},12661:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(25206),i=a(94227),n=a(62586),s={keyword:"contains",type:"array",schemaType:["object","boolean"],before:"uniqueItems",trackErrors:!0,error:{message:({params:{min:e,max:t}})=>void 0===t?o.str`should contain at least ${e} valid item(s)`:o.str`should contain at least ${e} and no more than ${t} valid item(s)`,params:({params:{min:e,max:t}})=>void 0===t?o._`{minContains: ${e}}`:o._`{minContains: ${e}, maxContains: ${t}}`},code(e){const{gen:t,schema:a,parentSchema:s,data:c,it:p}=e;let u,l;const{minContains:m,maxContains:f}=s;p.opts.next?(u=void 0===m?1:m,l=f):u=1;const h=t.const("len",o._`${c}.length`);if(e.setParams({min:u,max:l}),void 0===l&&0===u)return void n.checkStrictMode(p,'"minContains" == 0 without "maxContains": "contains" keyword ignored');if(void 0!==l&&u>l)return n.checkStrictMode(p,'"minContains" > "maxContains" is always invalid'),void e.fail();if(i.alwaysValidSchema(p,a)){let t=o._`${h} >= ${u}`;return void 0!==l&&(t=o._`${t} && ${h} <= ${l}`),void e.pass(t)}p.items=!0;const g=t.name("valid");if(void 0===l&&1===u)validateItems(g,()=>t.if(g,()=>t.break()));else{t.let(g,!1);const e=t.name("_valid"),a=t.let("count",0);validateItems(e,()=>t.if(e,()=>function checkLimits(e){t.code(o._`${e}++`),void 0===l?t.if(o._`${e} >= ${u}`,()=>t.assign(g,!0).break()):(t.if(o._`${e} > ${l}`,()=>t.assign(g,!1).break()),1===u?t.assign(g,!0):t.if(o._`${e} >= ${u}`,()=>t.assign(g,!0)))}(a)))}function validateItems(a,o){t.forRange("i",0,h,t=>{e.subschema({keyword:"contains",dataProp:t,dataPropType:r.Type.Num,compositeRule:!0},a),o()})}e.result(g,()=>e.reset())}};t.default=s},12739:function(e,t,a){"use strict";var o,r,i=this&&this.__classPrivateFieldGet||function(e,t,a,o){if("a"===a&&!o)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!o:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===a?o:"a"===a?o.call(e):o?o.value:t.get(e)},n=this&&this.__classPrivateFieldSet||function(e,t,a,o,r){if("m"===o)throw new TypeError("Private method is not writable");if("a"===o&&!r)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===o?r.call(e,a):r?r.value=a:t.set(e,a),a};Object.defineProperty(t,"__esModule",{value:!0}),t.boolean=t.bigint=t.array=t.any=t.coerce=t.ZodFirstPartyTypeKind=t.late=t.ZodSchema=t.Schema=t.custom=t.ZodReadonly=t.ZodPipeline=t.ZodBranded=t.BRAND=t.ZodNaN=t.ZodCatch=t.ZodDefault=t.ZodNullable=t.ZodOptional=t.ZodTransformer=t.ZodEffects=t.ZodPromise=t.ZodNativeEnum=t.ZodEnum=t.ZodLiteral=t.ZodLazy=t.ZodFunction=t.ZodSet=t.ZodMap=t.ZodRecord=t.ZodTuple=t.ZodIntersection=t.ZodDiscriminatedUnion=t.ZodUnion=t.ZodObject=t.ZodArray=t.ZodVoid=t.ZodNever=t.ZodUnknown=t.ZodAny=t.ZodNull=t.ZodUndefined=t.ZodSymbol=t.ZodDate=t.ZodBoolean=t.ZodBigInt=t.ZodNumber=t.ZodString=t.datetimeRegex=t.ZodType=void 0,t.NEVER=t.void=t.unknown=t.union=t.undefined=t.tuple=t.transformer=t.symbol=t.string=t.strictObject=t.set=t.record=t.promise=t.preprocess=t.pipeline=t.ostring=t.optional=t.onumber=t.oboolean=t.object=t.number=t.nullable=t.null=t.never=t.nativeEnum=t.nan=t.map=t.literal=t.lazy=t.intersection=t.instanceof=t.function=t.enum=t.effect=t.discriminatedUnion=t.date=void 0;const s=a(40627),c=a(69750),p=a(97231),u=a(12146),l=a(66837);class ParseInputLazyPath{constructor(e,t,a,o){this._cachedPath=[],this.parent=e,this.data=t,this._path=a,this._key=o}get path(){return this._cachedPath.length||(this._key instanceof Array?this._cachedPath.push(...this._path,...this._key):this._cachedPath.push(...this._path,this._key)),this._cachedPath}}const handleResult=(e,t)=>{if((0,p.isValid)(t))return{success:!0,data:t.value};if(!e.common.issues.length)throw new Error("Validation failed but no issues detected.");return{success:!1,get error(){if(this._error)return this._error;const t=new l.ZodError(e.common.issues);return this._error=t,this._error}}};function processCreateParams(e){if(!e)return{};const{errorMap:t,invalid_type_error:a,required_error:o,description:r}=e;if(t&&(a||o))throw new Error('Can\'t use "invalid_type_error" or "required_error" in conjunction with custom error map.');if(t)return{errorMap:t,description:r};return{errorMap:(t,r)=>{var i,n;const{message:s}=e;return"invalid_enum_value"===t.code?{message:null!=s?s:r.defaultError}:void 0===r.data?{message:null!==(i=null!=s?s:o)&&void 0!==i?i:r.defaultError}:"invalid_type"!==t.code?{message:r.defaultError}:{message:null!==(n=null!=s?s:a)&&void 0!==n?n:r.defaultError}},description:r}}class ZodType{get description(){return this._def.description}_getType(e){return(0,u.getParsedType)(e.data)}_getOrReturnCtx(e,t){return t||{common:e.parent.common,data:e.data,parsedType:(0,u.getParsedType)(e.data),schemaErrorMap:this._def.errorMap,path:e.path,parent:e.parent}}_processInputParams(e){return{status:new p.ParseStatus,ctx:{common:e.parent.common,data:e.data,parsedType:(0,u.getParsedType)(e.data),schemaErrorMap:this._def.errorMap,path:e.path,parent:e.parent}}}_parseSync(e){const t=this._parse(e);if((0,p.isAsync)(t))throw new Error("Synchronous parse encountered promise.");return t}_parseAsync(e){const t=this._parse(e);return Promise.resolve(t)}parse(e,t){const a=this.safeParse(e,t);if(a.success)return a.data;throw a.error}safeParse(e,t){var a;const o={common:{issues:[],async:null!==(a=null==t?void 0:t.async)&&void 0!==a&&a,contextualErrorMap:null==t?void 0:t.errorMap},path:(null==t?void 0:t.path)||[],schemaErrorMap:this._def.errorMap,parent:null,data:e,parsedType:(0,u.getParsedType)(e)},r=this._parseSync({data:e,path:o.path,parent:o});return handleResult(o,r)}"~validate"(e){var t,a;const o={common:{issues:[],async:!!this["~standard"].async},path:[],schemaErrorMap:this._def.errorMap,parent:null,data:e,parsedType:(0,u.getParsedType)(e)};if(!this["~standard"].async)try{const t=this._parseSync({data:e,path:[],parent:o});return(0,p.isValid)(t)?{value:t.value}:{issues:o.common.issues}}catch(e){(null===(a=null===(t=null==e?void 0:e.message)||void 0===t?void 0:t.toLowerCase())||void 0===a?void 0:a.includes("encountered"))&&(this["~standard"].async=!0),o.common={issues:[],async:!0}}return this._parseAsync({data:e,path:[],parent:o}).then(e=>(0,p.isValid)(e)?{value:e.value}:{issues:o.common.issues})}async parseAsync(e,t){const a=await this.safeParseAsync(e,t);if(a.success)return a.data;throw a.error}async safeParseAsync(e,t){const a={common:{issues:[],contextualErrorMap:null==t?void 0:t.errorMap,async:!0},path:(null==t?void 0:t.path)||[],schemaErrorMap:this._def.errorMap,parent:null,data:e,parsedType:(0,u.getParsedType)(e)},o=this._parse({data:e,path:a.path,parent:a}),r=await((0,p.isAsync)(o)?o:Promise.resolve(o));return handleResult(a,r)}refine(e,t){const getIssueProperties=e=>"string"==typeof t||void 0===t?{message:t}:"function"==typeof t?t(e):t;return this._refinement((t,a)=>{const o=e(t),setError=()=>a.addIssue({code:l.ZodIssueCode.custom,...getIssueProperties(t)});return"undefined"!=typeof Promise&&o instanceof Promise?o.then(e=>!!e||(setError(),!1)):!!o||(setError(),!1)})}refinement(e,t){return this._refinement((a,o)=>!!e(a)||(o.addIssue("function"==typeof t?t(a,o):t),!1))}_refinement(e){return new ZodEffects({schema:this,typeName:H.ZodEffects,effect:{type:"refinement",refinement:e}})}superRefine(e){return this._refinement(e)}constructor(e){this.spa=this.safeParseAsync,this._def=e,this.parse=this.parse.bind(this),this.safeParse=this.safeParse.bind(this),this.parseAsync=this.parseAsync.bind(this),this.safeParseAsync=this.safeParseAsync.bind(this),this.spa=this.spa.bind(this),this.refine=this.refine.bind(this),this.refinement=this.refinement.bind(this),this.superRefine=this.superRefine.bind(this),this.optional=this.optional.bind(this),this.nullable=this.nullable.bind(this),this.nullish=this.nullish.bind(this),this.array=this.array.bind(this),this.promise=this.promise.bind(this),this.or=this.or.bind(this),this.and=this.and.bind(this),this.transform=this.transform.bind(this),this.brand=this.brand.bind(this),this.default=this.default.bind(this),this.catch=this.catch.bind(this),this.describe=this.describe.bind(this),this.pipe=this.pipe.bind(this),this.readonly=this.readonly.bind(this),this.isNullable=this.isNullable.bind(this),this.isOptional=this.isOptional.bind(this),this["~standard"]={version:1,vendor:"zod",validate:e=>this["~validate"](e)}}optional(){return ZodOptional.create(this,this._def)}nullable(){return ZodNullable.create(this,this._def)}nullish(){return this.nullable().optional()}array(){return ZodArray.create(this)}promise(){return ZodPromise.create(this,this._def)}or(e){return ZodUnion.create([this,e],this._def)}and(e){return ZodIntersection.create(this,e,this._def)}transform(e){return new ZodEffects({...processCreateParams(this._def),schema:this,typeName:H.ZodEffects,effect:{type:"transform",transform:e}})}default(e){const t="function"==typeof e?e:()=>e;return new ZodDefault({...processCreateParams(this._def),innerType:this,defaultValue:t,typeName:H.ZodDefault})}brand(){return new ZodBranded({typeName:H.ZodBranded,type:this,...processCreateParams(this._def)})}catch(e){const t="function"==typeof e?e:()=>e;return new ZodCatch({...processCreateParams(this._def),innerType:this,catchValue:t,typeName:H.ZodCatch})}describe(e){return new(0,this.constructor)({...this._def,description:e})}pipe(e){return ZodPipeline.create(this,e)}readonly(){return ZodReadonly.create(this)}isOptional(){return this.safeParse(void 0).success}isNullable(){return this.safeParse(null).success}}t.ZodType=ZodType,t.Schema=ZodType,t.ZodSchema=ZodType;const m=/^c[^\s-]{8,}$/i,f=/^[0-9a-z]+$/,h=/^[0-9A-HJKMNP-TV-Z]{26}$/i,g=/^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/i,y=/^[a-z0-9_-]{21}$/i,b=/^[A-Za-z0-9-_]+\.[A-Za-z0-9-_]+\.[A-Za-z0-9-_]*$/,x=/^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/,w=/^(?!\.)(?!.*\.\.)([A-Z0-9_'+\-\.]*)[A-Z0-9_+-]@([A-Z0-9][A-Z0-9\-]*\.)+[A-Z]{2,}$/i;let k;const j=/^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/,C=/^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/(3[0-2]|[12]?[0-9])$/,P=/^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/,O=/^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/,I=/^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/,z=/^([0-9a-zA-Z-_]{4})*(([0-9a-zA-Z-_]{2}(==)?)|([0-9a-zA-Z-_]{3}(=)?))?$/,q="((\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-((0[13578]|1[02])-(0[1-9]|[12]\\d|3[01])|(0[469]|11)-(0[1-9]|[12]\\d|30)|(02)-(0[1-9]|1\\d|2[0-8])))",$=new RegExp(`^${q}$`);function timeRegexSource(e){let t="[0-5]\\d";e.precision?t=`${t}\\.\\d{${e.precision}}`:null==e.precision&&(t=`${t}(\\.\\d+)?`);return`([01]\\d|2[0-3]):[0-5]\\d(:${t})${e.precision?"+":"?"}`}function timeRegex(e){return new RegExp(`^${timeRegexSource(e)}$`)}function datetimeRegex(e){let t=`${q}T${timeRegexSource(e)}`;const a=[];return a.push(e.local?"Z?":"Z"),e.offset&&a.push("([+-]\\d{2}:?\\d{2})"),t=`${t}(${a.join("|")})`,new RegExp(`^${t}$`)}function isValidIP(e,t){return!("v4"!==t&&t||!j.test(e))||!("v6"!==t&&t||!P.test(e))}function isValidJWT(e,t){if(!b.test(e))return!1;try{const[a]=e.split("."),o=a.replace(/-/g,"+").replace(/_/g,"/").padEnd(a.length+(4-a.length%4)%4,"="),r=JSON.parse(atob(o));return"object"==typeof r&&null!==r&&(!(!r.typ||!r.alg)&&(!t||r.alg===t))}catch(e){return!1}}function isValidCidr(e,t){return!("v4"!==t&&t||!C.test(e))||!("v6"!==t&&t||!O.test(e))}t.datetimeRegex=datetimeRegex;class ZodString extends ZodType{_parse(e){this._def.coerce&&(e.data=String(e.data));if(this._getType(e)!==u.ZodParsedType.string){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.string,received:t.parsedType}),p.INVALID}const t=new p.ParseStatus;let a;for(const o of this._def.checks)if("min"===o.kind)e.data.length<o.value&&(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_small,minimum:o.value,type:"string",inclusive:!0,exact:!1,message:o.message}),t.dirty());else if("max"===o.kind)e.data.length>o.value&&(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_big,maximum:o.value,type:"string",inclusive:!0,exact:!1,message:o.message}),t.dirty());else if("length"===o.kind){const r=e.data.length>o.value,i=e.data.length<o.value;(r||i)&&(a=this._getOrReturnCtx(e,a),r?(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_big,maximum:o.value,type:"string",inclusive:!0,exact:!0,message:o.message}):i&&(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_small,minimum:o.value,type:"string",inclusive:!0,exact:!0,message:o.message}),t.dirty())}else if("email"===o.kind)w.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"email",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("emoji"===o.kind)k||(k=new RegExp("^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$","u")),k.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"emoji",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("uuid"===o.kind)g.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"uuid",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("nanoid"===o.kind)y.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"nanoid",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("cuid"===o.kind)m.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"cuid",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("cuid2"===o.kind)f.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"cuid2",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("ulid"===o.kind)h.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"ulid",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty());else if("url"===o.kind)try{new URL(e.data)}catch(r){a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"url",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()}else if("regex"===o.kind){o.regex.lastIndex=0;o.regex.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"regex",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty())}else if("trim"===o.kind)e.data=e.data.trim();else if("includes"===o.kind)e.data.includes(o.value,o.position)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_string,validation:{includes:o.value,position:o.position},message:o.message}),t.dirty());else if("toLowerCase"===o.kind)e.data=e.data.toLowerCase();else if("toUpperCase"===o.kind)e.data=e.data.toUpperCase();else if("startsWith"===o.kind)e.data.startsWith(o.value)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_string,validation:{startsWith:o.value},message:o.message}),t.dirty());else if("endsWith"===o.kind)e.data.endsWith(o.value)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_string,validation:{endsWith:o.value},message:o.message}),t.dirty());else if("datetime"===o.kind){datetimeRegex(o).test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_string,validation:"datetime",message:o.message}),t.dirty())}else if("date"===o.kind){$.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_string,validation:"date",message:o.message}),t.dirty())}else if("time"===o.kind){timeRegex(o).test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_string,validation:"time",message:o.message}),t.dirty())}else"duration"===o.kind?x.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"duration",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()):"ip"===o.kind?isValidIP(e.data,o.version)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"ip",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()):"jwt"===o.kind?isValidJWT(e.data,o.alg)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"jwt",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()):"cidr"===o.kind?isValidCidr(e.data,o.version)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"cidr",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()):"base64"===o.kind?I.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"base64",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()):"base64url"===o.kind?z.test(e.data)||(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{validation:"base64url",code:l.ZodIssueCode.invalid_string,message:o.message}),t.dirty()):u.util.assertNever(o);return{status:t.value,value:e.data}}_regex(e,t,a){return this.refinement(t=>e.test(t),{validation:t,code:l.ZodIssueCode.invalid_string,...c.errorUtil.errToObj(a)})}_addCheck(e){return new ZodString({...this._def,checks:[...this._def.checks,e]})}email(e){return this._addCheck({kind:"email",...c.errorUtil.errToObj(e)})}url(e){return this._addCheck({kind:"url",...c.errorUtil.errToObj(e)})}emoji(e){return this._addCheck({kind:"emoji",...c.errorUtil.errToObj(e)})}uuid(e){return this._addCheck({kind:"uuid",...c.errorUtil.errToObj(e)})}nanoid(e){return this._addCheck({kind:"nanoid",...c.errorUtil.errToObj(e)})}cuid(e){return this._addCheck({kind:"cuid",...c.errorUtil.errToObj(e)})}cuid2(e){return this._addCheck({kind:"cuid2",...c.errorUtil.errToObj(e)})}ulid(e){return this._addCheck({kind:"ulid",...c.errorUtil.errToObj(e)})}base64(e){return this._addCheck({kind:"base64",...c.errorUtil.errToObj(e)})}base64url(e){return this._addCheck({kind:"base64url",...c.errorUtil.errToObj(e)})}jwt(e){return this._addCheck({kind:"jwt",...c.errorUtil.errToObj(e)})}ip(e){return this._addCheck({kind:"ip",...c.errorUtil.errToObj(e)})}cidr(e){return this._addCheck({kind:"cidr",...c.errorUtil.errToObj(e)})}datetime(e){var t,a;return"string"==typeof e?this._addCheck({kind:"datetime",precision:null,offset:!1,local:!1,message:e}):this._addCheck({kind:"datetime",precision:void 0===(null==e?void 0:e.precision)?null:null==e?void 0:e.precision,offset:null!==(t=null==e?void 0:e.offset)&&void 0!==t&&t,local:null!==(a=null==e?void 0:e.local)&&void 0!==a&&a,...c.errorUtil.errToObj(null==e?void 0:e.message)})}date(e){return this._addCheck({kind:"date",message:e})}time(e){return"string"==typeof e?this._addCheck({kind:"time",precision:null,message:e}):this._addCheck({kind:"time",precision:void 0===(null==e?void 0:e.precision)?null:null==e?void 0:e.precision,...c.errorUtil.errToObj(null==e?void 0:e.message)})}duration(e){return this._addCheck({kind:"duration",...c.errorUtil.errToObj(e)})}regex(e,t){return this._addCheck({kind:"regex",regex:e,...c.errorUtil.errToObj(t)})}includes(e,t){return this._addCheck({kind:"includes",value:e,position:null==t?void 0:t.position,...c.errorUtil.errToObj(null==t?void 0:t.message)})}startsWith(e,t){return this._addCheck({kind:"startsWith",value:e,...c.errorUtil.errToObj(t)})}endsWith(e,t){return this._addCheck({kind:"endsWith",value:e,...c.errorUtil.errToObj(t)})}min(e,t){return this._addCheck({kind:"min",value:e,...c.errorUtil.errToObj(t)})}max(e,t){return this._addCheck({kind:"max",value:e,...c.errorUtil.errToObj(t)})}length(e,t){return this._addCheck({kind:"length",value:e,...c.errorUtil.errToObj(t)})}nonempty(e){return this.min(1,c.errorUtil.errToObj(e))}trim(){return new ZodString({...this._def,checks:[...this._def.checks,{kind:"trim"}]})}toLowerCase(){return new ZodString({...this._def,checks:[...this._def.checks,{kind:"toLowerCase"}]})}toUpperCase(){return new ZodString({...this._def,checks:[...this._def.checks,{kind:"toUpperCase"}]})}get isDatetime(){return!!this._def.checks.find(e=>"datetime"===e.kind)}get isDate(){return!!this._def.checks.find(e=>"date"===e.kind)}get isTime(){return!!this._def.checks.find(e=>"time"===e.kind)}get isDuration(){return!!this._def.checks.find(e=>"duration"===e.kind)}get isEmail(){return!!this._def.checks.find(e=>"email"===e.kind)}get isURL(){return!!this._def.checks.find(e=>"url"===e.kind)}get isEmoji(){return!!this._def.checks.find(e=>"emoji"===e.kind)}get isUUID(){return!!this._def.checks.find(e=>"uuid"===e.kind)}get isNANOID(){return!!this._def.checks.find(e=>"nanoid"===e.kind)}get isCUID(){return!!this._def.checks.find(e=>"cuid"===e.kind)}get isCUID2(){return!!this._def.checks.find(e=>"cuid2"===e.kind)}get isULID(){return!!this._def.checks.find(e=>"ulid"===e.kind)}get isIP(){return!!this._def.checks.find(e=>"ip"===e.kind)}get isCIDR(){return!!this._def.checks.find(e=>"cidr"===e.kind)}get isBase64(){return!!this._def.checks.find(e=>"base64"===e.kind)}get isBase64url(){return!!this._def.checks.find(e=>"base64url"===e.kind)}get minLength(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return e}get maxLength(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return e}}function floatSafeRemainder(e,t){const a=(e.toString().split(".")[1]||"").length,o=(t.toString().split(".")[1]||"").length,r=a>o?a:o;return parseInt(e.toFixed(r).replace(".",""))%parseInt(t.toFixed(r).replace(".",""))/Math.pow(10,r)}t.ZodString=ZodString,ZodString.create=e=>{var t;return new ZodString({checks:[],typeName:H.ZodString,coerce:null!==(t=null==e?void 0:e.coerce)&&void 0!==t&&t,...processCreateParams(e)})};class ZodNumber extends ZodType{constructor(){super(...arguments),this.min=this.gte,this.max=this.lte,this.step=this.multipleOf}_parse(e){this._def.coerce&&(e.data=Number(e.data));if(this._getType(e)!==u.ZodParsedType.number){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.number,received:t.parsedType}),p.INVALID}let t;const a=new p.ParseStatus;for(const o of this._def.checks)if("int"===o.kind)u.util.isInteger(e.data)||(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:"integer",received:"float",message:o.message}),a.dirty());else if("min"===o.kind){(o.inclusive?e.data<o.value:e.data<=o.value)&&(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.too_small,minimum:o.value,type:"number",inclusive:o.inclusive,exact:!1,message:o.message}),a.dirty())}else if("max"===o.kind){(o.inclusive?e.data>o.value:e.data>=o.value)&&(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.too_big,maximum:o.value,type:"number",inclusive:o.inclusive,exact:!1,message:o.message}),a.dirty())}else"multipleOf"===o.kind?0!==floatSafeRemainder(e.data,o.value)&&(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.not_multiple_of,multipleOf:o.value,message:o.message}),a.dirty()):"finite"===o.kind?Number.isFinite(e.data)||(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.not_finite,message:o.message}),a.dirty()):u.util.assertNever(o);return{status:a.value,value:e.data}}gte(e,t){return this.setLimit("min",e,!0,c.errorUtil.toString(t))}gt(e,t){return this.setLimit("min",e,!1,c.errorUtil.toString(t))}lte(e,t){return this.setLimit("max",e,!0,c.errorUtil.toString(t))}lt(e,t){return this.setLimit("max",e,!1,c.errorUtil.toString(t))}setLimit(e,t,a,o){return new ZodNumber({...this._def,checks:[...this._def.checks,{kind:e,value:t,inclusive:a,message:c.errorUtil.toString(o)}]})}_addCheck(e){return new ZodNumber({...this._def,checks:[...this._def.checks,e]})}int(e){return this._addCheck({kind:"int",message:c.errorUtil.toString(e)})}positive(e){return this._addCheck({kind:"min",value:0,inclusive:!1,message:c.errorUtil.toString(e)})}negative(e){return this._addCheck({kind:"max",value:0,inclusive:!1,message:c.errorUtil.toString(e)})}nonpositive(e){return this._addCheck({kind:"max",value:0,inclusive:!0,message:c.errorUtil.toString(e)})}nonnegative(e){return this._addCheck({kind:"min",value:0,inclusive:!0,message:c.errorUtil.toString(e)})}multipleOf(e,t){return this._addCheck({kind:"multipleOf",value:e,message:c.errorUtil.toString(t)})}finite(e){return this._addCheck({kind:"finite",message:c.errorUtil.toString(e)})}safe(e){return this._addCheck({kind:"min",inclusive:!0,value:Number.MIN_SAFE_INTEGER,message:c.errorUtil.toString(e)})._addCheck({kind:"max",inclusive:!0,value:Number.MAX_SAFE_INTEGER,message:c.errorUtil.toString(e)})}get minValue(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return e}get maxValue(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return e}get isInt(){return!!this._def.checks.find(e=>"int"===e.kind||"multipleOf"===e.kind&&u.util.isInteger(e.value))}get isFinite(){let e=null,t=null;for(const a of this._def.checks){if("finite"===a.kind||"int"===a.kind||"multipleOf"===a.kind)return!0;"min"===a.kind?(null===t||a.value>t)&&(t=a.value):"max"===a.kind&&(null===e||a.value<e)&&(e=a.value)}return Number.isFinite(t)&&Number.isFinite(e)}}t.ZodNumber=ZodNumber,ZodNumber.create=e=>new ZodNumber({checks:[],typeName:H.ZodNumber,coerce:(null==e?void 0:e.coerce)||!1,...processCreateParams(e)});class ZodBigInt extends ZodType{constructor(){super(...arguments),this.min=this.gte,this.max=this.lte}_parse(e){if(this._def.coerce)try{e.data=BigInt(e.data)}catch(t){return this._getInvalidInput(e)}if(this._getType(e)!==u.ZodParsedType.bigint)return this._getInvalidInput(e);let t;const a=new p.ParseStatus;for(const o of this._def.checks)if("min"===o.kind){(o.inclusive?e.data<o.value:e.data<=o.value)&&(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.too_small,type:"bigint",minimum:o.value,inclusive:o.inclusive,message:o.message}),a.dirty())}else if("max"===o.kind){(o.inclusive?e.data>o.value:e.data>=o.value)&&(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.too_big,type:"bigint",maximum:o.value,inclusive:o.inclusive,message:o.message}),a.dirty())}else"multipleOf"===o.kind?e.data%o.value!==BigInt(0)&&(t=this._getOrReturnCtx(e,t),(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.not_multiple_of,multipleOf:o.value,message:o.message}),a.dirty()):u.util.assertNever(o);return{status:a.value,value:e.data}}_getInvalidInput(e){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.bigint,received:t.parsedType}),p.INVALID}gte(e,t){return this.setLimit("min",e,!0,c.errorUtil.toString(t))}gt(e,t){return this.setLimit("min",e,!1,c.errorUtil.toString(t))}lte(e,t){return this.setLimit("max",e,!0,c.errorUtil.toString(t))}lt(e,t){return this.setLimit("max",e,!1,c.errorUtil.toString(t))}setLimit(e,t,a,o){return new ZodBigInt({...this._def,checks:[...this._def.checks,{kind:e,value:t,inclusive:a,message:c.errorUtil.toString(o)}]})}_addCheck(e){return new ZodBigInt({...this._def,checks:[...this._def.checks,e]})}positive(e){return this._addCheck({kind:"min",value:BigInt(0),inclusive:!1,message:c.errorUtil.toString(e)})}negative(e){return this._addCheck({kind:"max",value:BigInt(0),inclusive:!1,message:c.errorUtil.toString(e)})}nonpositive(e){return this._addCheck({kind:"max",value:BigInt(0),inclusive:!0,message:c.errorUtil.toString(e)})}nonnegative(e){return this._addCheck({kind:"min",value:BigInt(0),inclusive:!0,message:c.errorUtil.toString(e)})}multipleOf(e,t){return this._addCheck({kind:"multipleOf",value:e,message:c.errorUtil.toString(t)})}get minValue(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return e}get maxValue(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return e}}t.ZodBigInt=ZodBigInt,ZodBigInt.create=e=>{var t;return new ZodBigInt({checks:[],typeName:H.ZodBigInt,coerce:null!==(t=null==e?void 0:e.coerce)&&void 0!==t&&t,...processCreateParams(e)})};class ZodBoolean extends ZodType{_parse(e){this._def.coerce&&(e.data=Boolean(e.data));if(this._getType(e)!==u.ZodParsedType.boolean){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.boolean,received:t.parsedType}),p.INVALID}return(0,p.OK)(e.data)}}t.ZodBoolean=ZodBoolean,ZodBoolean.create=e=>new ZodBoolean({typeName:H.ZodBoolean,coerce:(null==e?void 0:e.coerce)||!1,...processCreateParams(e)});class ZodDate extends ZodType{_parse(e){this._def.coerce&&(e.data=new Date(e.data));if(this._getType(e)!==u.ZodParsedType.date){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.date,received:t.parsedType}),p.INVALID}if(isNaN(e.data.getTime())){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_date}),p.INVALID}const t=new p.ParseStatus;let a;for(const o of this._def.checks)"min"===o.kind?e.data.getTime()<o.value&&(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_small,message:o.message,inclusive:!0,exact:!1,minimum:o.value,type:"date"}),t.dirty()):"max"===o.kind?e.data.getTime()>o.value&&(a=this._getOrReturnCtx(e,a),(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_big,message:o.message,inclusive:!0,exact:!1,maximum:o.value,type:"date"}),t.dirty()):u.util.assertNever(o);return{status:t.value,value:new Date(e.data.getTime())}}_addCheck(e){return new ZodDate({...this._def,checks:[...this._def.checks,e]})}min(e,t){return this._addCheck({kind:"min",value:e.getTime(),message:c.errorUtil.toString(t)})}max(e,t){return this._addCheck({kind:"max",value:e.getTime(),message:c.errorUtil.toString(t)})}get minDate(){let e=null;for(const t of this._def.checks)"min"===t.kind&&(null===e||t.value>e)&&(e=t.value);return null!=e?new Date(e):null}get maxDate(){let e=null;for(const t of this._def.checks)"max"===t.kind&&(null===e||t.value<e)&&(e=t.value);return null!=e?new Date(e):null}}t.ZodDate=ZodDate,ZodDate.create=e=>new ZodDate({checks:[],coerce:(null==e?void 0:e.coerce)||!1,typeName:H.ZodDate,...processCreateParams(e)});class ZodSymbol extends ZodType{_parse(e){if(this._getType(e)!==u.ZodParsedType.symbol){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.symbol,received:t.parsedType}),p.INVALID}return(0,p.OK)(e.data)}}t.ZodSymbol=ZodSymbol,ZodSymbol.create=e=>new ZodSymbol({typeName:H.ZodSymbol,...processCreateParams(e)});class ZodUndefined extends ZodType{_parse(e){if(this._getType(e)!==u.ZodParsedType.undefined){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.undefined,received:t.parsedType}),p.INVALID}return(0,p.OK)(e.data)}}t.ZodUndefined=ZodUndefined,ZodUndefined.create=e=>new ZodUndefined({typeName:H.ZodUndefined,...processCreateParams(e)});class ZodNull extends ZodType{_parse(e){if(this._getType(e)!==u.ZodParsedType.null){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.null,received:t.parsedType}),p.INVALID}return(0,p.OK)(e.data)}}t.ZodNull=ZodNull,ZodNull.create=e=>new ZodNull({typeName:H.ZodNull,...processCreateParams(e)});class ZodAny extends ZodType{constructor(){super(...arguments),this._any=!0}_parse(e){return(0,p.OK)(e.data)}}t.ZodAny=ZodAny,ZodAny.create=e=>new ZodAny({typeName:H.ZodAny,...processCreateParams(e)});class ZodUnknown extends ZodType{constructor(){super(...arguments),this._unknown=!0}_parse(e){return(0,p.OK)(e.data)}}t.ZodUnknown=ZodUnknown,ZodUnknown.create=e=>new ZodUnknown({typeName:H.ZodUnknown,...processCreateParams(e)});class ZodNever extends ZodType{_parse(e){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.never,received:t.parsedType}),p.INVALID}}t.ZodNever=ZodNever,ZodNever.create=e=>new ZodNever({typeName:H.ZodNever,...processCreateParams(e)});class ZodVoid extends ZodType{_parse(e){if(this._getType(e)!==u.ZodParsedType.undefined){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.void,received:t.parsedType}),p.INVALID}return(0,p.OK)(e.data)}}t.ZodVoid=ZodVoid,ZodVoid.create=e=>new ZodVoid({typeName:H.ZodVoid,...processCreateParams(e)});class ZodArray extends ZodType{_parse(e){const{ctx:t,status:a}=this._processInputParams(e),o=this._def;if(t.parsedType!==u.ZodParsedType.array)return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.array,received:t.parsedType}),p.INVALID;if(null!==o.exactLength){const e=t.data.length>o.exactLength.value,r=t.data.length<o.exactLength.value;(e||r)&&((0,p.addIssueToContext)(t,{code:e?l.ZodIssueCode.too_big:l.ZodIssueCode.too_small,minimum:r?o.exactLength.value:void 0,maximum:e?o.exactLength.value:void 0,type:"array",inclusive:!0,exact:!0,message:o.exactLength.message}),a.dirty())}if(null!==o.minLength&&t.data.length<o.minLength.value&&((0,p.addIssueToContext)(t,{code:l.ZodIssueCode.too_small,minimum:o.minLength.value,type:"array",inclusive:!0,exact:!1,message:o.minLength.message}),a.dirty()),null!==o.maxLength&&t.data.length>o.maxLength.value&&((0,p.addIssueToContext)(t,{code:l.ZodIssueCode.too_big,maximum:o.maxLength.value,type:"array",inclusive:!0,exact:!1,message:o.maxLength.message}),a.dirty()),t.common.async)return Promise.all([...t.data].map((e,a)=>o.type._parseAsync(new ParseInputLazyPath(t,e,t.path,a)))).then(e=>p.ParseStatus.mergeArray(a,e));const r=[...t.data].map((e,a)=>o.type._parseSync(new ParseInputLazyPath(t,e,t.path,a)));return p.ParseStatus.mergeArray(a,r)}get element(){return this._def.type}min(e,t){return new ZodArray({...this._def,minLength:{value:e,message:c.errorUtil.toString(t)}})}max(e,t){return new ZodArray({...this._def,maxLength:{value:e,message:c.errorUtil.toString(t)}})}length(e,t){return new ZodArray({...this._def,exactLength:{value:e,message:c.errorUtil.toString(t)}})}nonempty(e){return this.min(1,e)}}function deepPartialify(e){if(e instanceof ZodObject){const t={};for(const a in e.shape){const o=e.shape[a];t[a]=ZodOptional.create(deepPartialify(o))}return new ZodObject({...e._def,shape:()=>t})}return e instanceof ZodArray?new ZodArray({...e._def,type:deepPartialify(e.element)}):e instanceof ZodOptional?ZodOptional.create(deepPartialify(e.unwrap())):e instanceof ZodNullable?ZodNullable.create(deepPartialify(e.unwrap())):e instanceof ZodTuple?ZodTuple.create(e.items.map(e=>deepPartialify(e))):e}t.ZodArray=ZodArray,ZodArray.create=(e,t)=>new ZodArray({type:e,minLength:null,maxLength:null,exactLength:null,typeName:H.ZodArray,...processCreateParams(t)});class ZodObject extends ZodType{constructor(){super(...arguments),this._cached=null,this.nonstrict=this.passthrough,this.augment=this.extend}_getCached(){if(null!==this._cached)return this._cached;const e=this._def.shape(),t=u.util.objectKeys(e);return this._cached={shape:e,keys:t}}_parse(e){if(this._getType(e)!==u.ZodParsedType.object){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.object,received:t.parsedType}),p.INVALID}const{status:t,ctx:a}=this._processInputParams(e),{shape:o,keys:r}=this._getCached(),i=[];if(!(this._def.catchall instanceof ZodNever&&"strip"===this._def.unknownKeys))for(const e in a.data)r.includes(e)||i.push(e);const n=[];for(const e of r){const t=o[e],r=a.data[e];n.push({key:{status:"valid",value:e},value:t._parse(new ParseInputLazyPath(a,r,a.path,e)),alwaysSet:e in a.data})}if(this._def.catchall instanceof ZodNever){const e=this._def.unknownKeys;if("passthrough"===e)for(const e of i)n.push({key:{status:"valid",value:e},value:{status:"valid",value:a.data[e]}});else if("strict"===e)i.length>0&&((0,p.addIssueToContext)(a,{code:l.ZodIssueCode.unrecognized_keys,keys:i}),t.dirty());else if("strip"!==e)throw new Error("Internal ZodObject error: invalid unknownKeys value.")}else{const e=this._def.catchall;for(const t of i){const o=a.data[t];n.push({key:{status:"valid",value:t},value:e._parse(new ParseInputLazyPath(a,o,a.path,t)),alwaysSet:t in a.data})}}return a.common.async?Promise.resolve().then(async()=>{const e=[];for(const t of n){const a=await t.key,o=await t.value;e.push({key:a,value:o,alwaysSet:t.alwaysSet})}return e}).then(e=>p.ParseStatus.mergeObjectSync(t,e)):p.ParseStatus.mergeObjectSync(t,n)}get shape(){return this._def.shape()}strict(e){return c.errorUtil.errToObj,new ZodObject({...this._def,unknownKeys:"strict",...void 0!==e?{errorMap:(t,a)=>{var o,r,i,n;const s=null!==(i=null===(r=(o=this._def).errorMap)||void 0===r?void 0:r.call(o,t,a).message)&&void 0!==i?i:a.defaultError;return"unrecognized_keys"===t.code?{message:null!==(n=c.errorUtil.errToObj(e).message)&&void 0!==n?n:s}:{message:s}}}:{}})}strip(){return new ZodObject({...this._def,unknownKeys:"strip"})}passthrough(){return new ZodObject({...this._def,unknownKeys:"passthrough"})}extend(e){return new ZodObject({...this._def,shape:()=>({...this._def.shape(),...e})})}merge(e){return new ZodObject({unknownKeys:e._def.unknownKeys,catchall:e._def.catchall,shape:()=>({...this._def.shape(),...e._def.shape()}),typeName:H.ZodObject})}setKey(e,t){return this.augment({[e]:t})}catchall(e){return new ZodObject({...this._def,catchall:e})}pick(e){const t={};return u.util.objectKeys(e).forEach(a=>{e[a]&&this.shape[a]&&(t[a]=this.shape[a])}),new ZodObject({...this._def,shape:()=>t})}omit(e){const t={};return u.util.objectKeys(this.shape).forEach(a=>{e[a]||(t[a]=this.shape[a])}),new ZodObject({...this._def,shape:()=>t})}deepPartial(){return deepPartialify(this)}partial(e){const t={};return u.util.objectKeys(this.shape).forEach(a=>{const o=this.shape[a];e&&!e[a]?t[a]=o:t[a]=o.optional()}),new ZodObject({...this._def,shape:()=>t})}required(e){const t={};return u.util.objectKeys(this.shape).forEach(a=>{if(e&&!e[a])t[a]=this.shape[a];else{let e=this.shape[a];for(;e instanceof ZodOptional;)e=e._def.innerType;t[a]=e}}),new ZodObject({...this._def,shape:()=>t})}keyof(){return createZodEnum(u.util.objectKeys(this.shape))}}t.ZodObject=ZodObject,ZodObject.create=(e,t)=>new ZodObject({shape:()=>e,unknownKeys:"strip",catchall:ZodNever.create(),typeName:H.ZodObject,...processCreateParams(t)}),ZodObject.strictCreate=(e,t)=>new ZodObject({shape:()=>e,unknownKeys:"strict",catchall:ZodNever.create(),typeName:H.ZodObject,...processCreateParams(t)}),ZodObject.lazycreate=(e,t)=>new ZodObject({shape:e,unknownKeys:"strip",catchall:ZodNever.create(),typeName:H.ZodObject,...processCreateParams(t)});class ZodUnion extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),a=this._def.options;if(t.common.async)return Promise.all(a.map(async e=>{const a={...t,common:{...t.common,issues:[]},parent:null};return{result:await e._parseAsync({data:t.data,path:t.path,parent:a}),ctx:a}})).then(function handleResults(e){for(const t of e)if("valid"===t.result.status)return t.result;for(const a of e)if("dirty"===a.result.status)return t.common.issues.push(...a.ctx.common.issues),a.result;const a=e.map(e=>new l.ZodError(e.ctx.common.issues));return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_union,unionErrors:a}),p.INVALID});{let e;const o=[];for(const r of a){const a={...t,common:{...t.common,issues:[]},parent:null},i=r._parseSync({data:t.data,path:t.path,parent:a});if("valid"===i.status)return i;"dirty"!==i.status||e||(e={result:i,ctx:a}),a.common.issues.length&&o.push(a.common.issues)}if(e)return t.common.issues.push(...e.ctx.common.issues),e.result;const r=o.map(e=>new l.ZodError(e));return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_union,unionErrors:r}),p.INVALID}}get options(){return this._def.options}}t.ZodUnion=ZodUnion,ZodUnion.create=(e,t)=>new ZodUnion({options:e,typeName:H.ZodUnion,...processCreateParams(t)});const getDiscriminator=e=>e instanceof ZodLazy?getDiscriminator(e.schema):e instanceof ZodEffects?getDiscriminator(e.innerType()):e instanceof ZodLiteral?[e.value]:e instanceof ZodEnum?e.options:e instanceof ZodNativeEnum?u.util.objectValues(e.enum):e instanceof ZodDefault?getDiscriminator(e._def.innerType):e instanceof ZodUndefined?[void 0]:e instanceof ZodNull?[null]:e instanceof ZodOptional?[void 0,...getDiscriminator(e.unwrap())]:e instanceof ZodNullable?[null,...getDiscriminator(e.unwrap())]:e instanceof ZodBranded||e instanceof ZodReadonly?getDiscriminator(e.unwrap()):e instanceof ZodCatch?getDiscriminator(e._def.innerType):[];class ZodDiscriminatedUnion extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e);if(t.parsedType!==u.ZodParsedType.object)return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.object,received:t.parsedType}),p.INVALID;const a=this.discriminator,o=t.data[a],r=this.optionsMap.get(o);return r?t.common.async?r._parseAsync({data:t.data,path:t.path,parent:t}):r._parseSync({data:t.data,path:t.path,parent:t}):((0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_union_discriminator,options:Array.from(this.optionsMap.keys()),path:[a]}),p.INVALID)}get discriminator(){return this._def.discriminator}get options(){return this._def.options}get optionsMap(){return this._def.optionsMap}static create(e,t,a){const o=new Map;for(const a of t){const t=getDiscriminator(a.shape[e]);if(!t.length)throw new Error(`A discriminator value for key \`${e}\` could not be extracted from all schema options`);for(const r of t){if(o.has(r))throw new Error(`Discriminator property ${String(e)} has duplicate value ${String(r)}`);o.set(r,a)}}return new ZodDiscriminatedUnion({typeName:H.ZodDiscriminatedUnion,discriminator:e,options:t,optionsMap:o,...processCreateParams(a)})}}function mergeValues(e,t){const a=(0,u.getParsedType)(e),o=(0,u.getParsedType)(t);if(e===t)return{valid:!0,data:e};if(a===u.ZodParsedType.object&&o===u.ZodParsedType.object){const a=u.util.objectKeys(t),o=u.util.objectKeys(e).filter(e=>-1!==a.indexOf(e)),r={...e,...t};for(const a of o){const o=mergeValues(e[a],t[a]);if(!o.valid)return{valid:!1};r[a]=o.data}return{valid:!0,data:r}}if(a===u.ZodParsedType.array&&o===u.ZodParsedType.array){if(e.length!==t.length)return{valid:!1};const a=[];for(let o=0;o<e.length;o++){const r=mergeValues(e[o],t[o]);if(!r.valid)return{valid:!1};a.push(r.data)}return{valid:!0,data:a}}return a===u.ZodParsedType.date&&o===u.ZodParsedType.date&&+e===+t?{valid:!0,data:e}:{valid:!1}}t.ZodDiscriminatedUnion=ZodDiscriminatedUnion;class ZodIntersection extends ZodType{_parse(e){const{status:t,ctx:a}=this._processInputParams(e),handleParsed=(e,o)=>{if((0,p.isAborted)(e)||(0,p.isAborted)(o))return p.INVALID;const r=mergeValues(e.value,o.value);return r.valid?(((0,p.isDirty)(e)||(0,p.isDirty)(o))&&t.dirty(),{status:t.value,value:r.data}):((0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_intersection_types}),p.INVALID)};return a.common.async?Promise.all([this._def.left._parseAsync({data:a.data,path:a.path,parent:a}),this._def.right._parseAsync({data:a.data,path:a.path,parent:a})]).then(([e,t])=>handleParsed(e,t)):handleParsed(this._def.left._parseSync({data:a.data,path:a.path,parent:a}),this._def.right._parseSync({data:a.data,path:a.path,parent:a}))}}t.ZodIntersection=ZodIntersection,ZodIntersection.create=(e,t,a)=>new ZodIntersection({left:e,right:t,typeName:H.ZodIntersection,...processCreateParams(a)});class ZodTuple extends ZodType{_parse(e){const{status:t,ctx:a}=this._processInputParams(e);if(a.parsedType!==u.ZodParsedType.array)return(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.array,received:a.parsedType}),p.INVALID;if(a.data.length<this._def.items.length)return(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_small,minimum:this._def.items.length,inclusive:!0,exact:!1,type:"array"}),p.INVALID;!this._def.rest&&a.data.length>this._def.items.length&&((0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_big,maximum:this._def.items.length,inclusive:!0,exact:!1,type:"array"}),t.dirty());const o=[...a.data].map((e,t)=>{const o=this._def.items[t]||this._def.rest;return o?o._parse(new ParseInputLazyPath(a,e,a.path,t)):null}).filter(e=>!!e);return a.common.async?Promise.all(o).then(e=>p.ParseStatus.mergeArray(t,e)):p.ParseStatus.mergeArray(t,o)}get items(){return this._def.items}rest(e){return new ZodTuple({...this._def,rest:e})}}t.ZodTuple=ZodTuple,ZodTuple.create=(e,t)=>{if(!Array.isArray(e))throw new Error("You must pass an array of schemas to z.tuple([ ... ])");return new ZodTuple({items:e,typeName:H.ZodTuple,rest:null,...processCreateParams(t)})};class ZodRecord extends ZodType{get keySchema(){return this._def.keyType}get valueSchema(){return this._def.valueType}_parse(e){const{status:t,ctx:a}=this._processInputParams(e);if(a.parsedType!==u.ZodParsedType.object)return(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.object,received:a.parsedType}),p.INVALID;const o=[],r=this._def.keyType,i=this._def.valueType;for(const e in a.data)o.push({key:r._parse(new ParseInputLazyPath(a,e,a.path,e)),value:i._parse(new ParseInputLazyPath(a,a.data[e],a.path,e)),alwaysSet:e in a.data});return a.common.async?p.ParseStatus.mergeObjectAsync(t,o):p.ParseStatus.mergeObjectSync(t,o)}get element(){return this._def.valueType}static create(e,t,a){return new ZodRecord(t instanceof ZodType?{keyType:e,valueType:t,typeName:H.ZodRecord,...processCreateParams(a)}:{keyType:ZodString.create(),valueType:e,typeName:H.ZodRecord,...processCreateParams(t)})}}t.ZodRecord=ZodRecord;class ZodMap extends ZodType{get keySchema(){return this._def.keyType}get valueSchema(){return this._def.valueType}_parse(e){const{status:t,ctx:a}=this._processInputParams(e);if(a.parsedType!==u.ZodParsedType.map)return(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.map,received:a.parsedType}),p.INVALID;const o=this._def.keyType,r=this._def.valueType,i=[...a.data.entries()].map(([e,t],i)=>({key:o._parse(new ParseInputLazyPath(a,e,a.path,[i,"key"])),value:r._parse(new ParseInputLazyPath(a,t,a.path,[i,"value"]))}));if(a.common.async){const e=new Map;return Promise.resolve().then(async()=>{for(const a of i){const o=await a.key,r=await a.value;if("aborted"===o.status||"aborted"===r.status)return p.INVALID;"dirty"!==o.status&&"dirty"!==r.status||t.dirty(),e.set(o.value,r.value)}return{status:t.value,value:e}})}{const e=new Map;for(const a of i){const o=a.key,r=a.value;if("aborted"===o.status||"aborted"===r.status)return p.INVALID;"dirty"!==o.status&&"dirty"!==r.status||t.dirty(),e.set(o.value,r.value)}return{status:t.value,value:e}}}}t.ZodMap=ZodMap,ZodMap.create=(e,t,a)=>new ZodMap({valueType:t,keyType:e,typeName:H.ZodMap,...processCreateParams(a)});class ZodSet extends ZodType{_parse(e){const{status:t,ctx:a}=this._processInputParams(e);if(a.parsedType!==u.ZodParsedType.set)return(0,p.addIssueToContext)(a,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.set,received:a.parsedType}),p.INVALID;const o=this._def;null!==o.minSize&&a.data.size<o.minSize.value&&((0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_small,minimum:o.minSize.value,type:"set",inclusive:!0,exact:!1,message:o.minSize.message}),t.dirty()),null!==o.maxSize&&a.data.size>o.maxSize.value&&((0,p.addIssueToContext)(a,{code:l.ZodIssueCode.too_big,maximum:o.maxSize.value,type:"set",inclusive:!0,exact:!1,message:o.maxSize.message}),t.dirty());const r=this._def.valueType;function finalizeSet(e){const a=new Set;for(const o of e){if("aborted"===o.status)return p.INVALID;"dirty"===o.status&&t.dirty(),a.add(o.value)}return{status:t.value,value:a}}const i=[...a.data.values()].map((e,t)=>r._parse(new ParseInputLazyPath(a,e,a.path,t)));return a.common.async?Promise.all(i).then(e=>finalizeSet(e)):finalizeSet(i)}min(e,t){return new ZodSet({...this._def,minSize:{value:e,message:c.errorUtil.toString(t)}})}max(e,t){return new ZodSet({...this._def,maxSize:{value:e,message:c.errorUtil.toString(t)}})}size(e,t){return this.min(e,t).max(e,t)}nonempty(e){return this.min(1,e)}}t.ZodSet=ZodSet,ZodSet.create=(e,t)=>new ZodSet({valueType:e,minSize:null,maxSize:null,typeName:H.ZodSet,...processCreateParams(t)});class ZodFunction extends ZodType{constructor(){super(...arguments),this.validate=this.implement}_parse(e){const{ctx:t}=this._processInputParams(e);if(t.parsedType!==u.ZodParsedType.function)return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.function,received:t.parsedType}),p.INVALID;function makeArgsIssue(e,a){return(0,p.makeIssue)({data:e,path:t.path,errorMaps:[t.common.contextualErrorMap,t.schemaErrorMap,(0,s.getErrorMap)(),s.defaultErrorMap].filter(e=>!!e),issueData:{code:l.ZodIssueCode.invalid_arguments,argumentsError:a}})}function makeReturnsIssue(e,a){return(0,p.makeIssue)({data:e,path:t.path,errorMaps:[t.common.contextualErrorMap,t.schemaErrorMap,(0,s.getErrorMap)(),s.defaultErrorMap].filter(e=>!!e),issueData:{code:l.ZodIssueCode.invalid_return_type,returnTypeError:a}})}const a={errorMap:t.common.contextualErrorMap},o=t.data;if(this._def.returns instanceof ZodPromise){const e=this;return(0,p.OK)(async function(...t){const r=new l.ZodError([]),i=await e._def.args.parseAsync(t,a).catch(e=>{throw r.addIssue(makeArgsIssue(t,e)),r}),n=await Reflect.apply(o,this,i);return await e._def.returns._def.type.parseAsync(n,a).catch(e=>{throw r.addIssue(makeReturnsIssue(n,e)),r})})}{const e=this;return(0,p.OK)(function(...t){const r=e._def.args.safeParse(t,a);if(!r.success)throw new l.ZodError([makeArgsIssue(t,r.error)]);const i=Reflect.apply(o,this,r.data),n=e._def.returns.safeParse(i,a);if(!n.success)throw new l.ZodError([makeReturnsIssue(i,n.error)]);return n.data})}}parameters(){return this._def.args}returnType(){return this._def.returns}args(...e){return new ZodFunction({...this._def,args:ZodTuple.create(e).rest(ZodUnknown.create())})}returns(e){return new ZodFunction({...this._def,returns:e})}implement(e){return this.parse(e)}strictImplement(e){return this.parse(e)}static create(e,t,a){return new ZodFunction({args:e||ZodTuple.create([]).rest(ZodUnknown.create()),returns:t||ZodUnknown.create(),typeName:H.ZodFunction,...processCreateParams(a)})}}t.ZodFunction=ZodFunction;class ZodLazy extends ZodType{get schema(){return this._def.getter()}_parse(e){const{ctx:t}=this._processInputParams(e);return this._def.getter()._parse({data:t.data,path:t.path,parent:t})}}t.ZodLazy=ZodLazy,ZodLazy.create=(e,t)=>new ZodLazy({getter:e,typeName:H.ZodLazy,...processCreateParams(t)});class ZodLiteral extends ZodType{_parse(e){if(e.data!==this._def.value){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{received:t.data,code:l.ZodIssueCode.invalid_literal,expected:this._def.value}),p.INVALID}return{status:"valid",value:e.data}}get value(){return this._def.value}}function createZodEnum(e,t){return new ZodEnum({values:e,typeName:H.ZodEnum,...processCreateParams(t)})}t.ZodLiteral=ZodLiteral,ZodLiteral.create=(e,t)=>new ZodLiteral({value:e,typeName:H.ZodLiteral,...processCreateParams(t)});class ZodEnum extends ZodType{constructor(){super(...arguments),o.set(this,void 0)}_parse(e){if("string"!=typeof e.data){const t=this._getOrReturnCtx(e),a=this._def.values;return(0,p.addIssueToContext)(t,{expected:u.util.joinValues(a),received:t.parsedType,code:l.ZodIssueCode.invalid_type}),p.INVALID}if(i(this,o,"f")||n(this,o,new Set(this._def.values),"f"),!i(this,o,"f").has(e.data)){const t=this._getOrReturnCtx(e),a=this._def.values;return(0,p.addIssueToContext)(t,{received:t.data,code:l.ZodIssueCode.invalid_enum_value,options:a}),p.INVALID}return(0,p.OK)(e.data)}get options(){return this._def.values}get enum(){const e={};for(const t of this._def.values)e[t]=t;return e}get Values(){const e={};for(const t of this._def.values)e[t]=t;return e}get Enum(){const e={};for(const t of this._def.values)e[t]=t;return e}extract(e,t=this._def){return ZodEnum.create(e,{...this._def,...t})}exclude(e,t=this._def){return ZodEnum.create(this.options.filter(t=>!e.includes(t)),{...this._def,...t})}}t.ZodEnum=ZodEnum,o=new WeakMap,ZodEnum.create=createZodEnum;class ZodNativeEnum extends ZodType{constructor(){super(...arguments),r.set(this,void 0)}_parse(e){const t=u.util.getValidEnumValues(this._def.values),a=this._getOrReturnCtx(e);if(a.parsedType!==u.ZodParsedType.string&&a.parsedType!==u.ZodParsedType.number){const e=u.util.objectValues(t);return(0,p.addIssueToContext)(a,{expected:u.util.joinValues(e),received:a.parsedType,code:l.ZodIssueCode.invalid_type}),p.INVALID}if(i(this,r,"f")||n(this,r,new Set(u.util.getValidEnumValues(this._def.values)),"f"),!i(this,r,"f").has(e.data)){const e=u.util.objectValues(t);return(0,p.addIssueToContext)(a,{received:a.data,code:l.ZodIssueCode.invalid_enum_value,options:e}),p.INVALID}return(0,p.OK)(e.data)}get enum(){return this._def.values}}t.ZodNativeEnum=ZodNativeEnum,r=new WeakMap,ZodNativeEnum.create=(e,t)=>new ZodNativeEnum({values:e,typeName:H.ZodNativeEnum,...processCreateParams(t)});class ZodPromise extends ZodType{unwrap(){return this._def.type}_parse(e){const{ctx:t}=this._processInputParams(e);if(t.parsedType!==u.ZodParsedType.promise&&!1===t.common.async)return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.promise,received:t.parsedType}),p.INVALID;const a=t.parsedType===u.ZodParsedType.promise?t.data:Promise.resolve(t.data);return(0,p.OK)(a.then(e=>this._def.type.parseAsync(e,{path:t.path,errorMap:t.common.contextualErrorMap})))}}t.ZodPromise=ZodPromise,ZodPromise.create=(e,t)=>new ZodPromise({type:e,typeName:H.ZodPromise,...processCreateParams(t)});class ZodEffects extends ZodType{innerType(){return this._def.schema}sourceType(){return this._def.schema._def.typeName===H.ZodEffects?this._def.schema.sourceType():this._def.schema}_parse(e){const{status:t,ctx:a}=this._processInputParams(e),o=this._def.effect||null,r={addIssue:e=>{(0,p.addIssueToContext)(a,e),e.fatal?t.abort():t.dirty()},get path(){return a.path}};if(r.addIssue=r.addIssue.bind(r),"preprocess"===o.type){const e=o.transform(a.data,r);if(a.common.async)return Promise.resolve(e).then(async e=>{if("aborted"===t.value)return p.INVALID;const o=await this._def.schema._parseAsync({data:e,path:a.path,parent:a});return"aborted"===o.status?p.INVALID:"dirty"===o.status||"dirty"===t.value?(0,p.DIRTY)(o.value):o});{if("aborted"===t.value)return p.INVALID;const o=this._def.schema._parseSync({data:e,path:a.path,parent:a});return"aborted"===o.status?p.INVALID:"dirty"===o.status||"dirty"===t.value?(0,p.DIRTY)(o.value):o}}if("refinement"===o.type){const executeRefinement=e=>{const t=o.refinement(e,r);if(a.common.async)return Promise.resolve(t);if(t instanceof Promise)throw new Error("Async refinement encountered during synchronous parse operation. Use .parseAsync instead.");return e};if(!1===a.common.async){const e=this._def.schema._parseSync({data:a.data,path:a.path,parent:a});return"aborted"===e.status?p.INVALID:("dirty"===e.status&&t.dirty(),executeRefinement(e.value),{status:t.value,value:e.value})}return this._def.schema._parseAsync({data:a.data,path:a.path,parent:a}).then(e=>"aborted"===e.status?p.INVALID:("dirty"===e.status&&t.dirty(),executeRefinement(e.value).then(()=>({status:t.value,value:e.value}))))}if("transform"===o.type){if(!1===a.common.async){const e=this._def.schema._parseSync({data:a.data,path:a.path,parent:a});if(!(0,p.isValid)(e))return e;const i=o.transform(e.value,r);if(i instanceof Promise)throw new Error("Asynchronous transform encountered during synchronous parse operation. Use .parseAsync instead.");return{status:t.value,value:i}}return this._def.schema._parseAsync({data:a.data,path:a.path,parent:a}).then(e=>(0,p.isValid)(e)?Promise.resolve(o.transform(e.value,r)).then(e=>({status:t.value,value:e})):e)}u.util.assertNever(o)}}t.ZodEffects=ZodEffects,t.ZodTransformer=ZodEffects,ZodEffects.create=(e,t,a)=>new ZodEffects({schema:e,typeName:H.ZodEffects,effect:t,...processCreateParams(a)}),ZodEffects.createWithPreprocess=(e,t,a)=>new ZodEffects({schema:t,effect:{type:"preprocess",transform:e},typeName:H.ZodEffects,...processCreateParams(a)});class ZodOptional extends ZodType{_parse(e){return this._getType(e)===u.ZodParsedType.undefined?(0,p.OK)(void 0):this._def.innerType._parse(e)}unwrap(){return this._def.innerType}}t.ZodOptional=ZodOptional,ZodOptional.create=(e,t)=>new ZodOptional({innerType:e,typeName:H.ZodOptional,...processCreateParams(t)});class ZodNullable extends ZodType{_parse(e){return this._getType(e)===u.ZodParsedType.null?(0,p.OK)(null):this._def.innerType._parse(e)}unwrap(){return this._def.innerType}}t.ZodNullable=ZodNullable,ZodNullable.create=(e,t)=>new ZodNullable({innerType:e,typeName:H.ZodNullable,...processCreateParams(t)});class ZodDefault extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e);let a=t.data;return t.parsedType===u.ZodParsedType.undefined&&(a=this._def.defaultValue()),this._def.innerType._parse({data:a,path:t.path,parent:t})}removeDefault(){return this._def.innerType}}t.ZodDefault=ZodDefault,ZodDefault.create=(e,t)=>new ZodDefault({innerType:e,typeName:H.ZodDefault,defaultValue:"function"==typeof t.default?t.default:()=>t.default,...processCreateParams(t)});class ZodCatch extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),a={...t,common:{...t.common,issues:[]}},o=this._def.innerType._parse({data:a.data,path:a.path,parent:{...a}});return(0,p.isAsync)(o)?o.then(e=>({status:"valid",value:"valid"===e.status?e.value:this._def.catchValue({get error(){return new l.ZodError(a.common.issues)},input:a.data})})):{status:"valid",value:"valid"===o.status?o.value:this._def.catchValue({get error(){return new l.ZodError(a.common.issues)},input:a.data})}}removeCatch(){return this._def.innerType}}t.ZodCatch=ZodCatch,ZodCatch.create=(e,t)=>new ZodCatch({innerType:e,typeName:H.ZodCatch,catchValue:"function"==typeof t.catch?t.catch:()=>t.catch,...processCreateParams(t)});class ZodNaN extends ZodType{_parse(e){if(this._getType(e)!==u.ZodParsedType.nan){const t=this._getOrReturnCtx(e);return(0,p.addIssueToContext)(t,{code:l.ZodIssueCode.invalid_type,expected:u.ZodParsedType.nan,received:t.parsedType}),p.INVALID}return{status:"valid",value:e.data}}}t.ZodNaN=ZodNaN,ZodNaN.create=e=>new ZodNaN({typeName:H.ZodNaN,...processCreateParams(e)}),t.BRAND=Symbol("zod_brand");class ZodBranded extends ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),a=t.data;return this._def.type._parse({data:a,path:t.path,parent:t})}unwrap(){return this._def.type}}t.ZodBranded=ZodBranded;class ZodPipeline extends ZodType{_parse(e){const{status:t,ctx:a}=this._processInputParams(e);if(a.common.async){return(async()=>{const e=await this._def.in._parseAsync({data:a.data,path:a.path,parent:a});return"aborted"===e.status?p.INVALID:"dirty"===e.status?(t.dirty(),(0,p.DIRTY)(e.value)):this._def.out._parseAsync({data:e.value,path:a.path,parent:a})})()}{const e=this._def.in._parseSync({data:a.data,path:a.path,parent:a});return"aborted"===e.status?p.INVALID:"dirty"===e.status?(t.dirty(),{status:"dirty",value:e.value}):this._def.out._parseSync({data:e.value,path:a.path,parent:a})}}static create(e,t){return new ZodPipeline({in:e,out:t,typeName:H.ZodPipeline})}}t.ZodPipeline=ZodPipeline;class ZodReadonly extends ZodType{_parse(e){const t=this._def.innerType._parse(e),freeze=e=>((0,p.isValid)(e)&&(e.value=Object.freeze(e.value)),e);return(0,p.isAsync)(t)?t.then(e=>freeze(e)):freeze(t)}unwrap(){return this._def.innerType}}function cleanParams(e,t){const a="function"==typeof e?e(t):"string"==typeof e?{message:e}:e;return"string"==typeof a?{message:a}:a}function custom(e,t={},a){return e?ZodAny.create().superRefine((o,r)=>{var i,n;const s=e(o);if(s instanceof Promise)return s.then(e=>{var i,n;if(!e){const e=cleanParams(t,o),s=null===(n=null!==(i=e.fatal)&&void 0!==i?i:a)||void 0===n||n;r.addIssue({code:"custom",...e,fatal:s})}});if(!s){const e=cleanParams(t,o),s=null===(n=null!==(i=e.fatal)&&void 0!==i?i:a)||void 0===n||n;r.addIssue({code:"custom",...e,fatal:s})}}):ZodAny.create()}var H;t.ZodReadonly=ZodReadonly,ZodReadonly.create=(e,t)=>new ZodReadonly({innerType:e,typeName:H.ZodReadonly,...processCreateParams(t)}),t.custom=custom,t.late={object:ZodObject.lazycreate},function(e){e.ZodString="ZodString",e.ZodNumber="ZodNumber",e.ZodNaN="ZodNaN",e.ZodBigInt="ZodBigInt",e.ZodBoolean="ZodBoolean",e.ZodDate="ZodDate",e.ZodSymbol="ZodSymbol",e.ZodUndefined="ZodUndefined",e.ZodNull="ZodNull",e.ZodAny="ZodAny",e.ZodUnknown="ZodUnknown",e.ZodNever="ZodNever",e.ZodVoid="ZodVoid",e.ZodArray="ZodArray",e.ZodObject="ZodObject",e.ZodUnion="ZodUnion",e.ZodDiscriminatedUnion="ZodDiscriminatedUnion",e.ZodIntersection="ZodIntersection",e.ZodTuple="ZodTuple",e.ZodRecord="ZodRecord",e.ZodMap="ZodMap",e.ZodSet="ZodSet",e.ZodFunction="ZodFunction",e.ZodLazy="ZodLazy",e.ZodLiteral="ZodLiteral",e.ZodEnum="ZodEnum",e.ZodEffects="ZodEffects",e.ZodNativeEnum="ZodNativeEnum",e.ZodOptional="ZodOptional",e.ZodNullable="ZodNullable",e.ZodDefault="ZodDefault",e.ZodCatch="ZodCatch",e.ZodPromise="ZodPromise",e.ZodBranded="ZodBranded",e.ZodPipeline="ZodPipeline",e.ZodReadonly="ZodReadonly"}(H||(t.ZodFirstPartyTypeKind=H={}));t.instanceof=(e,t={message:`Input not instance of ${e.name}`})=>custom(t=>t instanceof e,t);const V=ZodString.create;t.string=V;const G=ZodNumber.create;t.number=G;const W=ZodNaN.create;t.nan=W;const X=ZodBigInt.create;t.bigint=X;const Y=ZodBoolean.create;t.boolean=Y;const ee=ZodDate.create;t.date=ee;const te=ZodSymbol.create;t.symbol=te;const ae=ZodUndefined.create;t.undefined=ae;const oe=ZodNull.create;t.null=oe;const re=ZodAny.create;t.any=re;const ie=ZodUnknown.create;t.unknown=ie;const ne=ZodNever.create;t.never=ne;const se=ZodVoid.create;t.void=se;const ce=ZodArray.create;t.array=ce;const pe=ZodObject.create;t.object=pe;const ue=ZodObject.strictCreate;t.strictObject=ue;const le=ZodUnion.create;t.union=le;const de=ZodDiscriminatedUnion.create;t.discriminatedUnion=de;const me=ZodIntersection.create;t.intersection=me;const fe=ZodTuple.create;t.tuple=fe;const he=ZodRecord.create;t.record=he;const ge=ZodMap.create;t.map=ge;const ve=ZodSet.create;t.set=ve;const ye=ZodFunction.create;t.function=ye;const be=ZodLazy.create;t.lazy=be;const xe=ZodLiteral.create;t.literal=xe;const we=ZodEnum.create;t.enum=we;const ke=ZodNativeEnum.create;t.nativeEnum=ke;const je=ZodPromise.create;t.promise=je;const Se=ZodEffects.create;t.effect=Se,t.transformer=Se;const Ee=ZodOptional.create;t.optional=Ee;const _e=ZodNullable.create;t.nullable=_e;const Ce=ZodEffects.createWithPreprocess;t.preprocess=Ce;const Pe=ZodPipeline.create;t.pipeline=Pe;t.ostring=()=>V().optional();t.onumber=()=>G().optional();t.oboolean=()=>Y().optional(),t.coerce={string:e=>ZodString.create({...e,coerce:!0}),number:e=>ZodNumber.create({...e,coerce:!0}),boolean:e=>ZodBoolean.create({...e,coerce:!0}),bigint:e=>ZodBigInt.create({...e,coerce:!0}),date:e=>ZodDate.create({...e,coerce:!0})},t.NEVER=p.INVALID},12750:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(79896),r=a(39023),i=a(91124),n=a(76284),s=a(81597),c={chmodAttempt:i.attemptifyAsync(r.promisify(o.chmod),n.default.onChangeError),chownAttempt:i.attemptifyAsync(r.promisify(o.chown),n.default.onChangeError),closeAttempt:i.attemptifyAsync(r.promisify(o.close)),fsyncAttempt:i.attemptifyAsync(r.promisify(o.fsync)),mkdirAttempt:i.attemptifyAsync(r.promisify(o.mkdir)),realpathAttempt:i.attemptifyAsync(r.promisify(o.realpath)),statAttempt:i.attemptifyAsync(r.promisify(o.stat)),unlinkAttempt:i.attemptifyAsync(r.promisify(o.unlink)),closeRetry:s.retryifyAsync(r.promisify(o.close),n.default.isRetriableError),fsyncRetry:s.retryifyAsync(r.promisify(o.fsync),n.default.isRetriableError),openRetry:s.retryifyAsync(r.promisify(o.open),n.default.isRetriableError),readFileRetry:s.retryifyAsync(r.promisify(o.readFile),n.default.isRetriableError),renameRetry:s.retryifyAsync(r.promisify(o.rename),n.default.isRetriableError),statRetry:s.retryifyAsync(r.promisify(o.stat),n.default.isRetriableError),writeRetry:s.retryifyAsync(r.promisify(o.write),n.default.isRetriableError),chmodSyncAttempt:i.attemptifySync(o.chmodSync,n.default.onChangeError),chownSyncAttempt:i.attemptifySync(o.chownSync,n.default.onChangeError),closeSyncAttempt:i.attemptifySync(o.closeSync),mkdirSyncAttempt:i.attemptifySync(o.mkdirSync),realpathSyncAttempt:i.attemptifySync(o.realpathSync),statSyncAttempt:i.attemptifySync(o.statSync),unlinkSyncAttempt:i.attemptifySync(o.unlinkSync),closeSyncRetry:s.retryifySync(o.closeSync,n.default.isRetriableError),fsyncSyncRetry:s.retryifySync(o.fsyncSync,n.default.isRetriableError),openSyncRetry:s.retryifySync(o.openSync,n.default.isRetriableError),readFileSyncRetry:s.retryifySync(o.readFileSync,n.default.isRetriableError),renameSyncRetry:s.retryifySync(o.renameSync,n.default.isRetriableError),statSyncRetry:s.retryifySync(o.statSync,n.default.isRetriableError),writeSyncRetry:s.retryifySync(o.writeSync,n.default.isRetriableError)};t.default=c},12788:e=>{function arrToStr(e,t,a,o){let r="",i=!1;for(let n=0;n<e.length;n++){const s=e[n],c=propName(s);let p="";if(p=0===a.length?c:`${a}.${c}`,c===t.textNodeName){let e=s[c];isStopNode(p,t)||(e=t.tagValueProcessor(c,e),e=replaceEntitiesValue(e,t)),i&&(r+=o),r+=e,i=!1;continue}if(c===t.cdataPropName){i&&(r+=o),r+=`<![CDATA[${s[c][0][t.textNodeName]}]]>`,i=!1;continue}if(c===t.commentPropName){r+=o+`\x3c!--${s[c][0][t.textNodeName]}--\x3e`,i=!0;continue}if("?"===c[0]){const e=attr_to_str(s[":@"],t),a="?xml"===c?"":o;let n=s[c][0][t.textNodeName];n=0!==n.length?" "+n:"",r+=a+`<${c}${n}${e}?>`,i=!0;continue}let u=o;""!==u&&(u+=t.indentBy);const l=o+`<${c}${attr_to_str(s[":@"],t)}`,m=arrToStr(s[c],t,p,u);-1!==t.unpairedTags.indexOf(c)?t.suppressUnpairedNode?r+=l+">":r+=l+"/>":m&&0!==m.length||!t.suppressEmptyNode?m&&m.endsWith(">")?r+=l+`>${m}${o}</${c}>`:(r+=l+">",m&&""!==o&&(m.includes("/>")||m.includes("</"))?r+=o+t.indentBy+m+o:r+=m,r+=`</${c}>`):r+=l+"/>",i=!0}return r}function propName(e){const t=Object.keys(e);for(let e=0;e<t.length;e++){const a=t[e];if(":@"!==a)return a}}function attr_to_str(e,t){let a="";if(e&&!t.ignoreAttributes)for(let o in e){let r=t.attributeValueProcessor(o,e[o]);r=replaceEntitiesValue(r,t),!0===r&&t.suppressBooleanAttributes?a+=` ${o.substr(t.attributeNamePrefix.length)}`:a+=` ${o.substr(t.attributeNamePrefix.length)}="${r}"`}return a}function isStopNode(e,t){let a=(e=e.substr(0,e.length-t.textNodeName.length-1)).substr(e.lastIndexOf(".")+1);for(let o in t.stopNodes)if(t.stopNodes[o]===e||t.stopNodes[o]==="*."+a)return!0;return!1}function replaceEntitiesValue(e,t){if(e&&e.length>0&&t.processEntities)for(let a=0;a<t.entities.length;a++){const o=t.entities[a];e=e.replace(o.regex,o.val)}return e}e.exports=function toXml(e,t){let a="";return t.format&&t.indentBy.length>0&&(a="\n"),arrToStr(e,t,"",a)}},13037:(e,t,a)=>{"use strict";var o=a(80109),r=a(86049);function typeis(e,t){var a,r,i=t,n=function tryNormalizeType(e){if(!e)return null;try{return function normalizeType(e){var t=o.parse(e);return t.parameters=void 0,o.format(t)}(e)}catch(e){return null}}(e);if(!n)return!1;if(i&&!Array.isArray(i))for(i=new Array(arguments.length-1),a=0;a<i.length;a++)i[a]=arguments[a+1];if(!i||!i.length)return n;for(a=0;a<i.length;a++)if(mimeMatch(normalize(r=i[a]),n))return"+"===r[0]||-1!==r.indexOf("*")?n:r;return!1}function hasbody(e){return void 0!==e.headers["transfer-encoding"]||!isNaN(e.headers["content-length"])}function normalize(e){if("string"!=typeof e)return!1;switch(e){case"urlencoded":return"application/x-www-form-urlencoded";case"multipart":return"multipart/*"}return"+"===e[0]?"*/*"+e:-1===e.indexOf("/")?r.lookup(e):e}function mimeMatch(e,t){if(!1===e)return!1;var a=t.split("/"),o=e.split("/");return 2===a.length&&2===o.length&&(("*"===o[0]||o[0]===a[0])&&("*+"===o[1].substr(0,2)?o[1].length<=a[1].length+1&&o[1].substr(1)===a[1].substr(1-o[1].length):"*"===o[1]||o[1]===a[1]))}e.exports=function typeofrequest(e,t){var a=t;if(!hasbody(e))return null;if(arguments.length>2){a=new Array(arguments.length-1);for(var o=0;o<a.length;o++)a[o]=arguments[o+1]}return typeis(e.headers["content-type"],a)},e.exports.is=typeis,e.exports.hasBody=hasbody,e.exports.normalize=normalize,e.exports.match=mimeMatch},13056:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getData=void 0;const o=a(10208),r=a(94227),i=a(48708),n=a(99029),s=a(42023),c=a(25206);t.default=class KeywordCxt{constructor(e,t,a){if(function validateKeywordUsage({schema:e,opts:t,self:a},o,r){if(Array.isArray(o.keyword)?!o.keyword.includes(r):o.keyword!==r)throw new Error("ajv implementation error");const i=o.dependencies;if(null==i?void 0:i.some(t=>!Object.prototype.hasOwnProperty.call(e,t)))throw new Error(`parent schema must have dependencies of ${r}: ${i.join(",")}`);if(o.validateSchema){if(!o.validateSchema(e[r])){const e="keyword value is invalid: "+a.errorsText(o.validateSchema.errors);if("log"!==t.validateSchema)throw new Error(e);a.logger.error(e)}}}(e,t,a),this.gen=e.gen,this.allErrors=e.allErrors,this.keyword=a,this.data=e.data,this.schema=e.schema[a],this.$data=t.$data&&e.opts.$data&&this.schema&&this.schema.$data,this.schemaValue=r.schemaRefOrVal(e,this.schema,a,this.$data),this.schemaType=t.schemaType,this.parentSchema=e.schema,this.params={},this.it=e,this.def=t,this.$data)this.schemaCode=e.gen.const("vSchema",getData(this.$data,e));else if(this.schemaCode=this.schemaValue,!function validSchemaType(e,t,a=!1){return!t.length||t.some(t=>"array"===t?Array.isArray(e):"object"===t?e&&"object"==typeof e&&!Array.isArray(e):typeof e==t||a&&void 0===e)}(this.schema,t.schemaType,t.allowUndefined))throw new Error(`${a} value must be ${JSON.stringify(t.schemaType)}`);("code"in t?t.trackErrors:!1!==t.errors)&&(this.errsCount=e.gen.const("_errs",s.default.errors))}result(e,t,a){this.gen.if(n.not(e)),a?a():this.error(),t?(this.gen.else(),t(),this.allErrors&&this.gen.endIf()):this.allErrors?this.gen.endIf():this.gen.else()}pass(e,t){this.result(e,void 0,t)}fail(e){if(void 0===e)return this.error(),void(this.allErrors||this.gen.if(!1));this.gen.if(e),this.error(),this.allErrors?this.gen.endIf():this.gen.else()}fail$data(e){if(!this.$data)return this.fail(e);const{schemaCode:t}=this;this.fail(n._`${t} !== undefined && (${n.or(this.invalid$data(),e)})`)}error(e){(e?i.reportExtraError:i.reportError)(this,this.def.error)}$dataError(){i.reportError(this,this.def.$dataError||i.keyword$DataError)}reset(){if(void 0===this.errsCount)throw new Error('add "trackErrors" to keyword definition');i.resetErrorsCount(this.gen,this.errsCount)}ok(e){this.allErrors||this.gen.if(e)}setParams(e,t){t?Object.assign(this.params,e):this.params=e}block$data(e,t,a=n.nil){this.gen.block(()=>{this.check$data(e,a),t()})}check$data(e=n.nil,t=n.nil){if(!this.$data)return;const{gen:a,schemaCode:o,schemaType:r,def:i}=this;a.if(n.or(n._`${o} === undefined`,t)),e!==n.nil&&a.assign(e,!0),(r.length||i.validateSchema)&&(a.elseIf(this.invalid$data()),this.$dataError(),e!==n.nil&&a.assign(e,!1)),a.else()}invalid$data(){const{gen:e,schemaCode:t,schemaType:a,def:r,it:i}=this;return n.or(function wrong$DataType(){if(a.length){if(!(t instanceof n.Name))throw new Error("ajv implementation error");const e=Array.isArray(a)?a:[a];return n._`${o.checkDataTypes(e,t,i.opts.strict,o.DataType.Wrong)}`}return n.nil}(),function invalid$DataSchema(){if(r.validateSchema){const a=e.scopeValue("validate$data",{ref:r.validateSchema});return n._`!${a}(${t})`}return n.nil}())}subschema(e,t){return c.applySubschema(this.it,e,t)}mergeEvaluated(e,t){const{it:a,gen:o}=this;a.opts.unevaluated&&(!0!==a.props&&void 0!==e.props&&(a.props=r.mergeEvaluated.props(o,e.props,a.props,t)),!0!==a.items&&void 0!==e.items&&(a.items=r.mergeEvaluated.items(o,e.items,a.items,t)))}mergeValidEvaluated(e,t){const{it:a,gen:o}=this;if(a.opts.unevaluated&&(!0!==a.props||!0!==a.items))return o.if(t,()=>this.mergeEvaluated(e,n.Name)),!0}};const p=/^\/(?:[^~]|~0|~1)*$/,u=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function getData(e,{dataLevel:t,dataNames:a,dataPathArr:o}){let i,c;if(""===e)return s.default.rootData;if("/"===e[0]){if(!p.test(e))throw new Error(`Invalid JSON-pointer: ${e}`);i=e,c=s.default.rootData}else{const r=u.exec(e);if(!r)throw new Error(`Invalid JSON-pointer: ${e}`);const n=+r[1];if(i=r[2],"#"===i){if(n>=t)throw new Error(errorMsg("property/index",n));return o[t-n]}if(n>t)throw new Error(errorMsg("data",n));if(c=a[t-n],!i)return c}let l=c;const m=i.split("/");for(const e of m)e&&(c=n._`${c}${n.getProperty(r.unescapeJsonPointer(e))}`,l=n._`${l} && ${c}`);return l;function errorMsg(e,a){return`Cannot access ${e} ${a} levels up, current level is ${t}`}}t.getData=getData},13144:(e,t,a)=>{"use strict";var o=a(66743),r=a(11002),i=a(10076),n=a(47119);e.exports=n||o.call(i,r)},13193:e=>{"use strict";e.exports=require("string_decoder")},13491:function(e){(function(){var t,a,o,r,i,n;"undefined"!=typeof performance&&null!==performance&&performance.now?e.exports=function(){return performance.now()}:"undefined"!=typeof process&&null!==process&&process.hrtime?(e.exports=function(){return(t()-i)/1e6},a=process.hrtime,r=(t=function(){var e;return 1e9*(e=a())[0]+e[1]})(),n=1e9*process.uptime(),i=r-n):Date.now?(e.exports=function(){return Date.now()-o},o=Date.now()):(e.exports=function(){return(new Date).getTime()-o},o=(new Date).getTime())}).call(this)},13693:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.callRef=t.getValidate=void 0;const o=a(34050),r=a(15765),i=a(99029),n=a(42023),s=a(73835),c=a(94227),p={keyword:"$ref",schemaType:"string",code(e){const{gen:t,schema:a,it:r}=e,{baseId:n,schemaEnv:c,validateName:p,opts:u,self:l}=r;if("#"===a||"#/"===a)return function callRootRef(){if(c===c.root)return callRef(e,p,c,c.$async);const a=t.scopeValue("root",{ref:c.root});return callRef(e,i._`${a}.validate`,c.root,c.root.$async)}();const m=s.resolveRef.call(l,c.root,n,a);if(void 0===m)throw new o.MissingRefError(n,a);return m instanceof s.SchemaEnv?function callValidate(t){const a=getValidate(e,t);callRef(e,a,t,t.$async)}(m):function inlineRefSchema(o){const r=t.scopeValue("schema",!0===u.code.source?{ref:o,code:i.stringify(o)}:{ref:o}),n=t.name("valid"),s=e.subschema({schema:o,dataTypes:[],schemaPath:i.nil,topSchemaRef:r,errSchemaPath:a},n);e.mergeEvaluated(s),e.ok(n)}(m)}};function getValidate(e,t){const{gen:a}=e;return t.validate?a.scopeValue("validate",{ref:t.validate}):i._`${a.scopeValue("wrapper",{ref:t})}.validate`}function callRef(e,t,a,o){const{gen:s,it:p}=e,{allErrors:u,schemaEnv:l,opts:m}=p,f=m.passContext?n.default.this:i.nil;function addErrorsFrom(e){const t=i._`${e}.errors`;s.assign(n.default.vErrors,i._`${n.default.vErrors} === null ? ${t} : ${n.default.vErrors}.concat(${t})`),s.assign(n.default.errors,i._`${n.default.vErrors}.length`)}function addEvaluatedFrom(e){var t;if(!p.opts.unevaluated)return;const o=null===(t=null==a?void 0:a.validate)||void 0===t?void 0:t.evaluated;if(!0!==p.props)if(o&&!o.dynamicProps)void 0!==o.props&&(p.props=c.mergeEvaluated.props(s,o.props,p.props));else{const t=s.var("props",i._`${e}.evaluated.props`);p.props=c.mergeEvaluated.props(s,t,p.props,i.Name)}if(!0!==p.items)if(o&&!o.dynamicItems)void 0!==o.items&&(p.items=c.mergeEvaluated.items(s,o.items,p.items));else{const t=s.var("items",i._`${e}.evaluated.items`);p.items=c.mergeEvaluated.items(s,t,p.items,i.Name)}}o?function callAsyncRef(){if(!l.$async)throw new Error("async schema referenced by sync schema");const a=s.let("valid");s.try(()=>{s.code(i._`await ${r.callValidateCode(e,t,f)}`),addEvaluatedFrom(t),u||s.assign(a,!0)},e=>{s.if(i._`!(${e} instanceof ${p.ValidationError})`,()=>s.throw(e)),addErrorsFrom(e),u||s.assign(a,!1)}),e.ok(a)}():function callSyncRef(){e.result(r.callValidateCode(e,t,f),()=>addEvaluatedFrom(t),()=>addErrorsFrom(t))}()}t.getValidate=getValidate,t.callRef=callRef,t.default=p},13749:(e,t,a)=>{var o=a(38710),r=a(11054),i=a(86049),n=a(2203),s=a(6176),c=a(79896);function getObject(e,t){if(this.options.ObjectKeySimplifyCheck&&"/"===s.simplifyPath(e.Key))return void t(s.error(new Error("The Getobject Key is illegal")));var a,o=e.Query||{},r=e.QueryString||"";o["response-content-type"]=e.ResponseContentType,o["response-content-language"]=e.ResponseContentLanguage,o["response-expires"]=e.ResponseExpires,o["response-cache-control"]=e.ResponseCacheControl,o["response-content-disposition"]=e.ResponseContentDisposition,o["response-content-encoding"]=e.ResponseContentEncoding;var i=this,p=e.Output;e.ReturnStream?(p=new n.PassThrough,a="stream"):p&&"string"==typeof p?(p=c.createWriteStream(p),a="stream"):a=p&&"function"==typeof p.pipe?"stream":"buffer";var u,l,m,f,h,g,y=e.onProgress,b=(l=Date.now(),m=0,f=0,h=0,g=function(){if(u=0,y&&"function"==typeof y){var e=Date.now(),t=parseInt((f-m)/((e-l)/1e3)*100)/100||0,a=parseInt(f/h*100)/100||0;l=e,m=f;try{y({loaded:f,total:h,speed:t,percent:a})}catch(e){}}},function(e,t){if(e&&e.loaded&&(f=e.loaded,h=e.total),t)clearTimeout(u),g();else{if(u)return;u=setTimeout(g,i.options.ProgressInterval||1e3)}});if(submitRequest.call(this,{Action:"name/cos:GetObject",method:"GET",Bucket:e.Bucket,Region:e.Region,Key:e.Key,VersionId:e.VersionId,headers:e.Headers,qs:o,qsStr:r,rawBody:!0,outputStream:p,onDownloadProgress:b},function(o,r){if(b(null,!0),o){var i=o.statusCode;return e.Headers["If-Modified-Since"]&&i&&304===i?t(null,{NotModified:!0}):(p&&p.emit("error",o),t(o))}var n={};r.body&&("buffer"===a?n.Body=Buffer.from(r.body):"string"===a&&(n.Body=r.body)),s.extend(n,{ETag:s.attr(r.headers,"etag",""),statusCode:r.statusCode,headers:r.headers}),t(null,n)}),e.ReturnStream)return p}function selectObjectContent(e,t){if(!e.SelectType)return t(s.error(new Error("missing param SelectType")));var o,r=e.SelectRequest||{},i=s.json2xml({SelectRequest:r}),c=e.Headers;c["Content-Type"]="application/xml",c["Content-MD5"]=s.binaryBase64(s.md5(i));var p={},u=a(27809);return e.ReturnStream&&"raw"===e.DataType?o=new n.PassThrough:((o=new u).on("message:progress",function(t){"function"==typeof e.onProgress&&e.onProgress(t)}),o.on("message:stats",function(e){p.stats=e}),o.on("message:error",function(e){p.error=e})),submitRequest.call(this,{Action:"name/cos:GetObject",method:"POST",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,action:"select",qs:{"select-type":e.SelectType},VersionId:e.VersionId,body:i,rawBody:!0,outputStream:o},function(e,a){if(e&&204===e.statusCode)return t(null,{statusCode:e.statusCode});if(e)return o&&o.emit("error",e),t(e);if(p.error)return t(s.extend(p.error,{statusCode:a.statusCode,headers:a.headers}));var r={statusCode:a.statusCode,headers:a.headers};p.stats&&(r.Stats=p.stats),p.records&&(r.Payload=Buffer.concat(p.records)),t(null,r)}),e.ReturnStream||"raw"===e.DataType||(p.records=[],o.pipe(new n.Writable({write:function(e,t,a){p.records.push(e),a()},writev:function(e,t,a){e.forEach(function(t){p.records.push(e)}),a()}})),o.pipe(o)),e.ReturnStream?o:void 0}function decodeAcl(e){var t={GrantFullControl:[],GrantWrite:[],GrantRead:[],GrantReadAcp:[],GrantWriteAcp:[],ACL:""},a={FULL_CONTROL:"GrantFullControl",WRITE:"GrantWrite",READ:"GrantRead",READ_ACP:"GrantReadAcp",WRITE_ACP:"GrantWriteAcp"},o=(e&&e.AccessControlList||{}).Grant;o&&(o=s.isArray(o)?o:[o]);var r={READ:0,WRITE:0,FULL_CONTROL:0};return o&&o.length&&s.each(o,function(o){"qcs::cam::anyone:anyone"===o.Grantee.ID||"http://cam.qcloud.com/groups/global/AllUsers"===o.Grantee.URI?r[o.Permission]=1:o.Grantee.ID!==e.Owner.ID&&t[a[o.Permission]].push('id="'+o.Grantee.ID+'"')}),r.FULL_CONTROL||r.WRITE&&r.READ?t.ACL="public-read-write":r.READ?t.ACL="public-read":t.ACL="private",s.each(a,function(e){t[e]=uniqGrant(t[e].join(","))}),t}function uniqGrant(e){var t,a,o=e.split(","),r={};for(t=0;t<o.length;)r[a=o[t].trim()]?o.splice(t,1):(r[a]=!0,o[t]=a,t++);return o.join(",")}function getUrl(e){var t=e.bucket,a=t.substr(0,t.lastIndexOf("-")),o=t.substr(t.lastIndexOf("-")+1),r=e.domain,i=e.region,n=e.object;["http","https"].includes(e.protocol)&&(e.protocol=e.protocol+":");var c=e.protocol||(s.isBrowser&&"http:"===location.protocol?"http:":"https:");r||(r=["cn-south","cn-south-2","cn-north","cn-east","cn-southwest","sg"].indexOf(i)>-1?"{Region}.myqcloud.com":"cos.{Region}.myqcloud.com",e.ForcePathStyle||(r="{Bucket}."+r)),r=(r=r.replace(/\{\{AppId\}\}/gi,o).replace(/\{\{Bucket\}\}/gi,a).replace(/\{\{Region\}\}/gi,i).replace(/\{\{.*?\}\}/gi,"")).replace(/\{AppId\}/gi,o).replace(/\{BucketName\}/gi,a).replace(/\{Bucket\}/gi,t).replace(/\{Region\}/gi,i).replace(/\{.*?\}/gi,""),/^[a-zA-Z]+:\/\//.test(r)||(r=c+"//"+r),"/"===r.slice(-1)&&(r=r.slice(0,-1));var p=r;return e.ForcePathStyle&&(p+="/"+t),p+="/",n&&(p+=s.camSafeUrlEncode(n).replace(/%2F/g,"/")),e.isLocation&&(p=p.replace(/^https?:\/\//,"")),p}var getSignHost=function(e){if(!e.Bucket||!e.Region)return"";var t=void 0===e.UseAccelerate?this.options.UseAccelerate:e.UseAccelerate;return(e.Url||getUrl({ForcePathStyle:this.options.ForcePathStyle,protocol:this.options.Protocol,domain:this.options.Domain,bucket:e.Bucket,region:t?"accelerate":e.Region})).replace(/^https?:\/\/([^/]+)(\/.*)?$/,"$1")};function getAuthorizationAsync(e,t){var a=s.clone(e.Headers),o="";s.each(a,function(e,t){(""===e||["content-type","cache-control"].indexOf(t.toLowerCase())>-1)&&delete a[t],"host"===t.toLowerCase()&&(o=e)});var r=!1!==e.ForceSignHost;!o&&e.SignHost&&r&&(a.Host=e.SignHost);var i=!1,cb=function(e,a){i||(i=!0,a&&a.XCosSecurityToken&&!a.SecurityToken&&((a=s.clone(a)).SecurityToken=a.XCosSecurityToken,delete a.XCosSecurityToken),t&&t(e,a))},n=this,c=e.Bucket||"",p=e.Region||"",u=e.Key||"";n.options.ForcePathStyle&&c&&(u=c+"/"+u);var l="/"+u,m={},f=e.Scope;if(!f){var h=e.Action||"",g=e.ResourceKey||e.Key||"";f=e.Scope||[{action:h,bucket:c,region:p,prefix:g}]}var y=s.md5(JSON.stringify(f));n._StsCache=n._StsCache||[],function(){var e,t;for(e=n._StsCache.length-1;e>=0;e--){t=n._StsCache[e];var a=Math.round(s.getSkewTime(n.options.SystemClockOffset)/1e3)+30;if(t.StartTime&&a<t.StartTime||a>=t.ExpiredTime)n._StsCache.splice(e,1);else if(!t.ScopeLimit||t.ScopeLimit&&t.ScopeKey===y){m=t;break}}}();var b,calcAuthByTmpKey=function(){var t="";m.StartTime&&e.Expires?t=m.StartTime+";"+(m.StartTime+1*e.Expires):m.StartTime&&m.ExpiredTime&&(t=m.StartTime+";"+m.ExpiredTime);var o={Authorization:s.getAuth({SecretId:m.TmpSecretId,SecretKey:m.TmpSecretKey,Method:e.Method,Pathname:l,Query:e.Query,Headers:a,Expires:e.Expires,UseRawKey:n.options.UseRawKey,SystemClockOffset:n.options.SystemClockOffset,KeyTime:t,ForceSignHost:r}),SecurityToken:m.SecurityToken||m.XCosSecurityToken||"",Token:m.Token||"",ClientIP:m.ClientIP||"",ClientUA:m.ClientUA||"",SignFrom:"client"};cb(null,o)},checkAuthError=function(e){if(e.Authorization){var t=!1,a=e.Authorization;if(a)if(a.indexOf(" ")>-1)t=!1;else if(a.indexOf("q-sign-algorithm=")>-1&&a.indexOf("q-ak=")>-1&&a.indexOf("q-sign-time=")>-1&&a.indexOf("q-key-time=")>-1&&a.indexOf("q-url-param-list=")>-1)t=!0;else try{(a=Buffer.from(a,"base64").toString()).indexOf("a=")>-1&&a.indexOf("k=")>-1&&a.indexOf("t=")>-1&&a.indexOf("r=")>-1&&a.indexOf("b=")>-1&&(t=!0)}catch(e){}if(!t)return s.error(new Error("getAuthorization callback params format error"))}else{if(!e.TmpSecretId)return s.error(new Error('getAuthorization callback params missing "TmpSecretId"'));if(!e.TmpSecretKey)return s.error(new Error('getAuthorization callback params missing "TmpSecretKey"'));if(!e.SecurityToken&&!e.XCosSecurityToken)return s.error(new Error('getAuthorization callback params missing "SecurityToken"'));if(!e.ExpiredTime)return s.error(new Error('getAuthorization callback params missing "ExpiredTime"'));if(e.ExpiredTime&&10!==e.ExpiredTime.toString().length)return s.error(new Error('getAuthorization callback params "ExpiredTime" should be 10 digits'));if(e.StartTime&&10!==e.StartTime.toString().length)return s.error(new Error('getAuthorization callback params "StartTime" should be 10 StartTime'))}return!1};if(m.ExpiredTime&&m.ExpiredTime-s.getSkewTime(n.options.SystemClockOffset)/1e3>60)calcAuthByTmpKey();else if(n.options.getAuthorization)n.options.getAuthorization.call(n,{Bucket:c,Region:p,Method:e.Method,Key:u,Pathname:l,Query:e.Query,Headers:a,Scope:f,SystemClockOffset:n.options.SystemClockOffset,ForceSignHost:r},function(e){"string"==typeof e&&(e={Authorization:e});var t=checkAuthError(e);if(t)return cb(t);e.Authorization?cb(null,e):((m=e||{}).Scope=f,m.ScopeKey=y,n._StsCache.push(m),calcAuthByTmpKey())});else{if(!n.options.getSTS)return b={Authorization:s.getAuth({SecretId:e.SecretId||n.options.SecretId,SecretKey:e.SecretKey||n.options.SecretKey,Method:e.Method,Pathname:l,Query:e.Query,Headers:a,Expires:e.Expires,UseRawKey:n.options.UseRawKey,SystemClockOffset:n.options.SystemClockOffset,ForceSignHost:r}),SecurityToken:n.options.SecurityToken||n.options.XCosSecurityToken,SignFrom:"client"},cb(null,b),b;n.options.getSTS.call(n,{Bucket:c,Region:p},function(e){(m=e||{}).Scope=f,m.ScopeKey=y,m.TmpSecretId||(m.TmpSecretId=m.SecretId),m.TmpSecretKey||(m.TmpSecretKey=m.SecretKey);var t=checkAuthError(m);if(t)return cb(t);n._StsCache.push(m),calcAuthByTmpKey()})}return""}function allowRetry(e){var t=!1,a=!1,o=!1,r=e.headers&&(e.headers.date||e.headers.Date)||e.error&&e.error.ServerTime;try{var i=e.error.Code,n=e.error.Message;("RequestTimeTooSkewed"===i||"AccessDenied"===i&&"Request has expired"===n)&&(o=!0)}catch(e){}if(e){if(o&&r){var c=Date.parse(r);this.options.CorrectClockSkew&&Math.abs(s.getSkewTime(this.options.SystemClockOffset)-c)>=3e4&&(console.error("error: Local time is too skewed."),this.options.SystemClockOffset=c-Date.now(),t=!0)}else(5===Math.floor(e.statusCode/100)||"ECONNRESET"===e.code)&&(t=!0);if(e.statusCode){const o=Math.floor(e.statusCode/100),r=e.headers?e.headers["x-cos-request-id"]:"";[3,4,5].includes(o)&&!r&&(t=this.options.AutoSwitchHost,a=!0)}else t=this.options.AutoSwitchHost,a=!0}return{canRetry:t,networkError:a}}function canSwitchHost({requestUrl:e,clientCalcSign:t,networkError:a}){if(!this.options.AutoSwitchHost)return!1;if(!e)return!1;if(!t)return!1;if(!a)return!1;return/^https?:\/\/[^\/]*\.cos\.[^\/]*\.myqcloud\.com(\/.*)?$/.test(e)&&!/^https?:\/\/[^\/]*\.cos\.accelerate\.myqcloud\.com(\/.*)?$/.test(e)}function submitRequest(e,t){var a=this;!e.headers&&(e.headers={}),e.headers["User-Agent"]=a.options.UserAgent||"cos-nodejs-sdk-v5-"+o.version,!e.qs&&(e.qs={}),e.VersionId&&(e.qs.versionId=e.VersionId),e.qs=s.clearKey(e.qs),e.headers&&(e.headers=s.clearKey(e.headers)),e.qs&&(e.qs=s.clearKey(e.qs));var r=s.clone(e.qs);e.action&&(r[e.action]="");var i=e.SignHost||getSignHost.call(this,{Bucket:e.Bucket,Region:e.Region,Url:e.url}),next=function(o){var n=a.options.SystemClockOffset;e.SwitchHost&&(i=i.replace(/myqcloud.com/,"tencentcos.cn")),getAuthorizationAsync.call(a,{Bucket:e.Bucket||"",Region:e.Region||"",Method:e.method,Key:e.Key,Query:r,Headers:e.headers,SignHost:i,Action:e.Action,ResourceKey:e.ResourceKey,Scope:e.Scope,ForceSignHost:a.options.ForceSignHost,SwitchHost:e.SwitchHost},function(r,i){if(r)return t(r);e.AuthData=i,_submitRequest.call(a,e,function(r,s){let c=!1,p=!1;if(r){const e=allowRetry.call(a,r);c=e.canRetry||n!==a.options.SystemClockOffset,p=e.networkError}if(r&&(!e.body||!e.body.pipe)&&!e.outputStream&&o<2&&c){e.headers&&(delete e.headers.Authorization,delete e.headers.token,delete e.headers.clientIP,delete e.headers.clientUA,e.headers["x-cos-security-token"]&&delete e.headers["x-cos-security-token"],e.headers["x-ci-security-token"]&&delete e.headers["x-ci-security-token"]);const t=canSwitchHost.call(a,{requestUrl:r.url||"",clientCalcSign:"client"===i.SignFrom,networkError:p});e.SwitchHost=t,e.retry=!0,next(o+1)}else{if(r&&"name/cos:UploadPart"===e.Action){const e=canSwitchHost.call(a,{requestUrl:r.url||"",clientCalcSign:"client"===i.SignFrom,networkError:p});r.switchHost=e}t(r,s)}})})};next(1)}function _submitRequest(e,t){var a=this,o=e.TaskId;if(!o||a._isRunningTask(o)){var n,c=e.Bucket,p=e.Region,u=e.Key,l=e.method||"GET",m=e.url||e.Url,f=e.body,h=e.rawBody;f&&"function"==typeof f.pipe&&(n=f,f=null),this.options.UseAccelerate&&(p="accelerate"),m=m||getUrl({ForcePathStyle:a.options.ForcePathStyle,protocol:a.options.Protocol,domain:a.options.Domain,bucket:c,region:p,object:u}),e.SwitchHost&&(m=m.replace(/myqcloud.com/,"tencentcos.cn")),e.action&&(m=m+"?"+e.action),e.qsStr&&(m=m.indexOf("?")>-1?m+"&"+e.qsStr:m+"?"+e.qsStr);var g={method:l,url:m,headers:e.headers,qs:e.qs,body:f},y="x-cos-security-token";s.isCIHost(m)&&(y="x-ci-security-token"),g.headers.Authorization=e.AuthData.Authorization,e.AuthData.Token&&(g.headers.token=e.AuthData.Token),e.AuthData.ClientIP&&(g.headers.clientIP=e.AuthData.ClientIP),e.AuthData.ClientUA&&(g.headers.clientUA=e.AuthData.ClientUA),e.AuthData.SecurityToken&&(g.headers[y]=e.AuthData.SecurityToken),g.headers&&(g.headers=s.clearKey(g.headers)),e.retry&&(g.headers["x-cos-sdk-retry"]=!0),g=s.clearKey(g);var b=this.options.Ip;if(b&&(g.url=g.url.replace(/^(https?:\/\/)([^\/]+)/,function(e,t,a){return g.headers.Host=a,t+b})),!0!==this.options.StrictSsl&&(g.strictSSL=this.options.StrictSsl),this.options.Proxy&&(g.proxy=this.options.Proxy),"boolean"==typeof this.options.Tunnel&&(g.tunnel=this.options.Tunnel),this.options.Timeout&&(g.timeout=this.options.Timeout),this.options.KeepAlive&&(g.forever=!0),this.options.FollowRedirect||(g.followRedirect=!1),n){var x=!1;s.each(g.headers,function(e,t){"content-type"===t.toLowerCase()&&(x=!0)}),!x&&n.readable&&n.path&&n.mode&&!i.lookup(n.path)&&(g.headers["Content-Type"]="application/octet-stream")}e.outputStream&&(t=s.callbackAfterStreamFinish(e.outputStream,t)),a.emit("before-send",g);var w,k,j=r(g),cb=function(e,r){if(o&&a.off("inner-kill-task",killTask),!k){k=!0;var i={};w&&w.statusCode&&(i.statusCode=w.statusCode),w&&w.headers&&(i.headers=w.headers),e?(g.url&&(i.url=g.url),g.method&&(i.method=g.method),e=s.extend(e||{},i),t(e,null)):(r=s.extend(r||{},i),t(null,r)),j&&(j.removeAllListeners&&j.removeAllListeners(),j.on("error",function(){}),j=null)}},markLastBytesWritten=function(){try{Object.defineProperty(j.req.connection,"_lastBytesWritten",{enumerable:!0,configurable:!0,writable:!0,value:j.req.connection.bytesWritten})}catch(e){}};j.on("error",function(t){e.outputStream&&e.outputStream.close&&e.outputStream.close(),markLastBytesWritten(),cb(s.error(t))}),j.on("response",function(t){w=t;var a=t.headers["content-length"]||0,o=[],r=t.statusCode,i=2===Math.floor(r/100);if(i&&e.outputStream)j.on("end",function(){cb(null,{})});else if(a>=process.binding("buffer").kMaxLength&&"HEAD"!==g.method)cb(s.error(new Error("file size large than "+process.binding("buffer").kMaxLength+', please use "Output" Stream to getObject.')));else{j.on("data",function(e){o.push(e)}),j.on("end",function(){try{var e=Buffer.concat(o)}catch(e){return void cb(s.error(e))}var a=e.toString();if(h&&i)return cb(null,{body:e});var n=s.parseResBody(a),c=n&&n.Error;i?cb(null,n):cb(c?s.error(new Error(c.Message),{code:c.Code,error:c}):r?s.error(new Error(t.statusMessage),{code:""+r}):s.error(new Error("statusCode error"))),o=null})}});var killTask=function(e){e.TaskId===o&&(n&&n.isSdkCreated&&n.close&&n.close(),j&&j.abort&&j.abort(),a.off("inner-kill-task",killTask))};if(o&&a.on("inner-kill-task",killTask),j.once("end",function(){markLastBytesWritten()}),e.onProgress&&"function"==typeof e.onProgress){var C=g.headers["Content-Length"],P=Date.now(),O=0;j.on("drain",function(){var t=Date.now(),a=0;try{a=j.req.connection.bytesWritten-j.req._header.length-(j.req.connection._lastBytesWritten||0)}catch(e){}var o=C,r=parseInt((a-O)/((t-P)/1e3)*100)/100||0,i=parseInt(a/o*100)/100||0;P=t,O=a,e.onProgress({loaded:a,total:o,speed:r,percent:i})})}if(e.onDownloadProgress&&"function"==typeof e.onDownloadProgress){P=Date.now(),O=0;var I=0,z=0;j.on("response",function(t){z=t.headers["content-length"],j.on("data",function(t){I+=t.length;var a=Date.now(),o=parseInt((I-O)/((a-P)/1e3)*100)/100||0,r=parseInt(I/z*100)/100||0;P=a,O=I,e.onDownloadProgress({loaded:I,total:z,speed:o,percent:r})})})}return n&&(n.on("error",function(e){j&&j.abort&&j.abort(),cb(e)}),n.pipe(j)),e.outputStream&&(e.outputStream.on("error",function(e){j&&j.abort&&j.abort(),cb(e)}),j.pipe(e.outputStream)),j}}var p={getService:function getService(e,t){var a=this.options.Protocol||(s.isBrowser&&"http:"===location.protocol?"http:":"https:"),o=this.options.ServiceDomain,r=e.AppId||this.options.appId,i=e.Region;o?(o=o.replace(/\{\{AppId\}\}/gi,r||"").replace(/\{\{Region\}\}/gi,i||"").replace(/\{\{.*?\}\}/gi,""),/^[a-zA-Z]+:\/\//.test(o)||(o=a+"//"+o),"/"===o.slice(-1)&&(o=o.slice(0,-1))):o=i?a+"//cos."+i+".myqcloud.com":a+"//service.cos.myqcloud.com";var n="",c=i?"cos."+i+".myqcloud.com":"service.cos.myqcloud.com";c===o.replace(/^https?:\/\/([^/]+)(\/.*)?$/,"$1")&&(n=c),submitRequest.call(this,{Action:"name/cos:GetService",url:o,method:"GET",headers:e.Headers,SignHost:n,qs:{tagkey:e.TagKey,tagvalue:e.TagValue,"create-time":e.CreateTime,range:e.CreateRange,marker:e.Marker,"max-keys":e.MaxKeys}},function(e,a){if(e)return t(e);var o=a&&a.ListAllMyBucketsResult&&a.ListAllMyBucketsResult.Buckets&&a.ListAllMyBucketsResult.Buckets.Bucket||[];o=s.isArray(o)?o:[o];var r=a&&a.ListAllMyBucketsResult&&a.ListAllMyBucketsResult.Owner||{};t(null,{Buckets:o,Owner:r,statusCode:a.statusCode,headers:a.headers})})},putBucket:function putBucket(e,t){var a=this,o="",r={};e.BucketAZConfig&&(r.BucketAZConfig=e.BucketAZConfig),e.BucketArchConfig&&(r.BucketArchConfig=e.BucketArchConfig),(r.BucketAZConfig||r.BucketArchConfig)&&(o=s.json2xml({CreateBucketConfiguration:r})),submitRequest.call(this,{Action:"name/cos:PutBucket",method:"PUT",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,body:o},function(o,r){if(o)return t(o);var i=getUrl({protocol:a.options.Protocol,domain:a.options.Domain,bucket:e.Bucket,region:e.Region,isLocation:!0});t(null,{Location:i,statusCode:r.statusCode,headers:r.headers})})},headBucket:function headBucket(e,t){submitRequest.call(this,{Action:"name/cos:HeadBucket",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,method:"HEAD"},t)},getBucket:function getBucket(e,t){var a={};a.prefix=e.Prefix||"",a.delimiter=e.Delimiter,a.marker=e.Marker,a["max-keys"]=e.MaxKeys,a["encoding-type"]=e.EncodingType,submitRequest.call(this,{Action:"name/cos:GetBucket",ResourceKey:a.prefix,method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,qs:a},function(e,a){if(e)return t(e);var o=a.ListBucketResult||{},r=o.Contents||[],i=o.CommonPrefixes||[];r=s.isArray(r)?r:[r],i=s.isArray(i)?i:[i];var n=s.clone(o);s.extend(n,{Contents:r,CommonPrefixes:i,statusCode:a.statusCode,headers:a.headers}),t(null,n)})},deleteBucket:function deleteBucket(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucket",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,method:"DELETE"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketAcl:function putBucketAcl(e,t){var a=e.Headers,o="";if(e.AccessControlPolicy){var r=s.clone(e.AccessControlPolicy||{}),i=r.Grants||r.Grant;i=s.isArray(i)?i:[i],delete r.Grant,delete r.Grants,r.AccessControlList={Grant:i},o=s.json2xml({AccessControlPolicy:r}),a["Content-Type"]="application/xml",a["Content-MD5"]=s.binaryBase64(s.md5(o))}s.each(a,function(e,t){0===t.indexOf("x-cos-grant-")&&(a[t]=uniqGrant(a[t]))}),submitRequest.call(this,{Action:"name/cos:PutBucketACL",method:"PUT",Bucket:e.Bucket,Region:e.Region,headers:a,action:"acl",body:o},function(e,a){if(e)return t(e);t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketAcl:function getBucketAcl(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketACL",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"acl"},function(e,a){if(e)return t(e);var o=a.AccessControlPolicy||{},r=o.Owner||{},i=o.AccessControlList&&o.AccessControlList.Grant||[];i=s.isArray(i)?i:[i];var n=decodeAcl(o);a.headers&&a.headers["x-cos-acl"]&&(n.ACL=a.headers["x-cos-acl"]),n=s.extend(n,{Owner:r,Grants:i,statusCode:a.statusCode,headers:a.headers}),t(null,n)})},putBucketCors:function putBucketCors(e,t){var a=(e.CORSConfiguration||{}).CORSRules||e.CORSRules||[];a=s.clone(s.isArray(a)?a:[a]),s.each(a,function(e){s.each(["AllowedOrigin","AllowedHeader","AllowedMethod","ExposeHeader"],function(t){var a=t+"s",o=e[a]||e[t]||[];delete e[a],e[t]=s.isArray(o)?o:[o]})});var o={CORSRule:a};e.ResponseVary&&(o.ResponseVary=e.ResponseVary);var r=s.json2xml({CORSConfiguration:o}),i=e.Headers;i["Content-Type"]="application/xml",i["Content-MD5"]=s.binaryBase64(s.md5(r)),submitRequest.call(this,{Action:"name/cos:PutBucketCORS",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:r,action:"cors",headers:i},function(e,a){if(e)return t(e);t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketCors:function getBucketCors(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketCORS",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"cors"},function(e,a){if(e)if(404===e.statusCode&&e.error&&"NoSuchCORSConfiguration"===e.error.Code){var o={CORSRules:[],statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else t(e);else{var r=a.CORSConfiguration||{},i=r.CORSRules||r.CORSRule||[];i=s.clone(s.isArray(i)?i:[i]);var n=r.ResponseVary;s.each(i,function(e){s.each(["AllowedOrigin","AllowedHeader","AllowedMethod","ExposeHeader"],function(t){var a=t+"s",o=e[a]||e[t]||[];delete e[t],e[a]=s.isArray(o)?o:[o]})}),t(null,{CORSRules:i,ResponseVary:n,statusCode:a.statusCode,headers:a.headers})}})},deleteBucketCors:function deleteBucketCors(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketCORS",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"cors"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode||e.statusCode,headers:a.headers})})},getBucketLocation:function getBucketLocation(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketLocation",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"location"},t)},getBucketPolicy:function getBucketPolicy(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketPolicy",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"policy",rawBody:!0},function(e,a){if(e)return e.statusCode&&403===e.statusCode?t(s.error(e,{ErrorStatus:"Access Denied"})):e.statusCode&&405===e.statusCode?t(s.error(e,{ErrorStatus:"Method Not Allowed"})):e.statusCode&&404===e.statusCode?t(s.error(e,{ErrorStatus:"Policy Not Found"})):t(e);var o={};try{o=JSON.parse(a.body)}catch(e){}t(null,{Policy:o,statusCode:a.statusCode,headers:a.headers})})},putBucketPolicy:function putBucketPolicy(e,t){var a=e.Policy;try{"string"==typeof a&&(a=JSON.parse(a))}catch(e){}if(!a||"string"==typeof a)return t(s.error(new Error("Policy format error")));var o=JSON.stringify(a);a.version||(a.version="2.0");var r=e.Headers;r["Content-Type"]="application/json",r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketPolicy",method:"PUT",Bucket:e.Bucket,Region:e.Region,action:"policy",body:o,headers:r},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},deleteBucketPolicy:function deleteBucketPolicy(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketPolicy",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"policy"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode||e.statusCode,headers:a.headers})})},putBucketTagging:function putBucketTagging(e,t){var a=e.Tagging||{},o=a.TagSet||a.Tags||e.Tags||[];o=s.clone(s.isArray(o)?o:[o]);var r=s.json2xml({Tagging:{TagSet:{Tag:o}}}),i=e.Headers;i["Content-Type"]="application/xml",i["Content-MD5"]=s.binaryBase64(s.md5(r)),submitRequest.call(this,{Action:"name/cos:PutBucketTagging",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:r,action:"tagging",headers:i},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketTagging:function getBucketTagging(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketTagging",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"tagging"},function(e,a){if(e)if(404!==e.statusCode||!e.error||"Not Found"!==e.error&&"NoSuchTagSet"!==e.error.Code)t(e);else{var o={Tags:[],statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else{var r=[];try{r=a.Tagging.TagSet.Tag||[]}catch(e){}r=s.clone(s.isArray(r)?r:[r]),t(null,{Tags:r,statusCode:a.statusCode,headers:a.headers})}})},deleteBucketTagging:function deleteBucketTagging(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketTagging",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"tagging"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketLifecycle:function putBucketLifecycle(e,t){var a=(e.LifecycleConfiguration||{}).Rules||e.Rules||[];a=s.clone(a);var o=s.json2xml({LifecycleConfiguration:{Rule:a}}),r=e.Headers;r["Content-Type"]="application/xml",r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketLifecycle",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:o,action:"lifecycle",headers:r},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketLifecycle:function getBucketLifecycle(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketLifecycle",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"lifecycle"},function(e,a){if(e)if(404===e.statusCode&&e.error&&"NoSuchLifecycleConfiguration"===e.error.Code){var o={Rules:[],statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else t(e);else{var r=[];try{r=a.LifecycleConfiguration.Rule||[]}catch(e){}r=s.clone(s.isArray(r)?r:[r]),t(null,{Rules:r,statusCode:a.statusCode,headers:a.headers})}})},deleteBucketLifecycle:function deleteBucketLifecycle(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketLifecycle",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"lifecycle"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketVersioning:function putBucketVersioning(e,t){if(e.VersioningConfiguration){var a=e.VersioningConfiguration||{},o=s.json2xml({VersioningConfiguration:a}),r=e.Headers;r["Content-Type"]="application/xml",r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketVersioning",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:o,action:"versioning",headers:r},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})}else t(s.error(new Error("missing param VersioningConfiguration")))},getBucketVersioning:function getBucketVersioning(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketVersioning",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"versioning"},function(e,a){e||!a.VersioningConfiguration&&(a.VersioningConfiguration={}),t(e,a)})},putBucketReplication:function putBucketReplication(e,t){var a=s.clone(e.ReplicationConfiguration),o=s.json2xml({ReplicationConfiguration:a});o=(o=o.replace(/<(\/?)Rules>/gi,"<$1Rule>")).replace(/<(\/?)Tags>/gi,"<$1Tag>");var r=e.Headers;r["Content-Type"]="application/xml",r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketReplication",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:o,action:"replication",headers:r},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketReplication:function getBucketReplication(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketReplication",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"replication"},function(e,a){if(e)if(404!==e.statusCode||!e.error||"Not Found"!==e.error&&"ReplicationConfigurationnotFoundError"!==e.error.Code)t(e);else{var o={ReplicationConfiguration:{Rules:[]},statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else e||!a.ReplicationConfiguration&&(a.ReplicationConfiguration={}),a.ReplicationConfiguration.Rule&&(a.ReplicationConfiguration.Rules=s.makeArray(a.ReplicationConfiguration.Rule),delete a.ReplicationConfiguration.Rule),t(e,a)})},deleteBucketReplication:function deleteBucketReplication(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketReplication",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"replication"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketWebsite:function putBucketWebsite(e,t){if(e.WebsiteConfiguration){var a=s.clone(e.WebsiteConfiguration||{}),o=a.RoutingRules||a.RoutingRule||[];o=s.isArray(o)?o:[o],delete a.RoutingRule,delete a.RoutingRules,o.length&&(a.RoutingRules={RoutingRule:o});var r=s.json2xml({WebsiteConfiguration:a}),i=e.Headers;i["Content-Type"]="application/xml",i["Content-MD5"]=s.binaryBase64(s.md5(r)),submitRequest.call(this,{Action:"name/cos:PutBucketWebsite",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:r,action:"website",headers:i},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})}else t(s.error(new Error("missing param WebsiteConfiguration")))},getBucketWebsite:function getBucketWebsite(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketWebsite",method:"GET",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,action:"website"},function(e,a){if(e)if(404===e.statusCode&&"NoSuchWebsiteConfiguration"===e.error.Code){var o={WebsiteConfiguration:{},statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else t(e);else{var r=a.WebsiteConfiguration||{};if(r.RoutingRules){var i=s.clone(r.RoutingRules.RoutingRule||[]);i=s.makeArray(i),r.RoutingRules=i}t(null,{WebsiteConfiguration:r,statusCode:a.statusCode,headers:a.headers})}})},deleteBucketWebsite:function deleteBucketWebsite(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketWebsite",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"website"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketReferer:function putBucketReferer(e,t){if(e.RefererConfiguration){var a=s.clone(e.RefererConfiguration||{}),o=a.DomainList||{},r=o.Domains||o.Domain||[];(r=s.isArray(r)?r:[r]).length&&(a.DomainList={Domain:r});var i=s.json2xml({RefererConfiguration:a}),n=e.Headers;n["Content-Type"]="application/xml",n["Content-MD5"]=s.binaryBase64(s.md5(i)),submitRequest.call(this,{Action:"name/cos:PutBucketReferer",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:i,action:"referer",headers:n},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})}else t(s.error(new Error("missing param RefererConfiguration")))},getBucketReferer:function getBucketReferer(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketReferer",method:"GET",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,action:"referer"},function(e,a){if(e)if(404===e.statusCode&&"NoSuchRefererConfiguration"===e.error.Code){var o={WebsiteConfiguration:{},statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else t(e);else{var r=a.RefererConfiguration||{};if(r.DomainList){var i=s.makeArray(r.DomainList.Domain||[]);r.DomainList={Domains:i}}t(null,{RefererConfiguration:r,statusCode:a.statusCode,headers:a.headers})}})},putBucketDomain:function putBucketDomain(e,t){var a=(e.DomainConfiguration||{}).DomainRule||e.DomainRule||[];a=s.clone(a);var o=s.json2xml({DomainConfiguration:{DomainRule:a}}),r=e.Headers;r["Content-Type"]="application/xml",r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketDomain",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:o,action:"domain",headers:r},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketDomain:function getBucketDomain(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketDomain",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"domain"},function(e,a){if(e)return t(e);var o=[];try{o=a.DomainConfiguration.DomainRule||[]}catch(e){}o=s.clone(s.isArray(o)?o:[o]),t(null,{DomainRule:o,statusCode:a.statusCode,headers:a.headers})})},deleteBucketDomain:function deleteBucketDomain(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketDomain",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"domain"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketOrigin:function putBucketOrigin(e,t){var a=(e.OriginConfiguration||{}).OriginRule||e.OriginRule||[];a=s.clone(a);var o=s.json2xml({OriginConfiguration:{OriginRule:a}}),r=e.Headers;r["Content-Type"]="application/xml",r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketOrigin",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:o,action:"origin",headers:r},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketOrigin:function getBucketOrigin(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketOrigin",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"origin"},function(e,a){if(e)return t(e);var o=[];try{o=a.OriginConfiguration.OriginRule||[]}catch(e){}o=s.clone(s.isArray(o)?o:[o]),t(null,{OriginRule:o,statusCode:a.statusCode,headers:a.headers})})},deleteBucketOrigin:function deleteBucketOrigin(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketOrigin",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"origin"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketLogging:function putBucketLogging(e,t){var a=s.json2xml({BucketLoggingStatus:e.BucketLoggingStatus||""}),o=e.Headers;o["Content-Type"]="application/xml",o["Content-MD5"]=s.binaryBase64(s.md5(a)),submitRequest.call(this,{Action:"name/cos:PutBucketLogging",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:a,action:"logging",headers:o},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketLogging:function getBucketLogging(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketLogging",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"logging"},function(e,a){if(e)return t(e);t(null,{BucketLoggingStatus:a.BucketLoggingStatus,statusCode:a.statusCode,headers:a.headers})})},putBucketInventory:function putBucketInventory(e,t){var a=s.clone(e.InventoryConfiguration);if(a.OptionalFields){var o=a.OptionalFields||[];a.OptionalFields={Field:o}}if(a.Destination&&a.Destination.COSBucketDestination&&a.Destination.COSBucketDestination.Encryption){var r=a.Destination.COSBucketDestination.Encryption;Object.keys(r).indexOf("SSECOS")>-1&&(r["SSE-COS"]=r.SSECOS,delete r.SSECOS)}var i=s.json2xml({InventoryConfiguration:a}),n=e.Headers;n["Content-Type"]="application/xml",n["Content-MD5"]=s.binaryBase64(s.md5(i)),submitRequest.call(this,{Action:"name/cos:PutBucketInventory",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:i,action:"inventory",qs:{id:e.Id},headers:n},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketInventory:function getBucketInventory(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketInventory",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"inventory",qs:{id:e.Id}},function(e,a){if(e)return t(e);var o=a.InventoryConfiguration;if(o&&o.OptionalFields&&o.OptionalFields.Field){var r=o.OptionalFields.Field;s.isArray(r)||(r=[r]),o.OptionalFields=r}if(o.Destination&&o.Destination.COSBucketDestination&&o.Destination.COSBucketDestination.Encryption){var i=o.Destination.COSBucketDestination.Encryption;Object.keys(i).indexOf("SSE-COS")>-1&&(i.SSECOS=i["SSE-COS"],delete i["SSE-COS"])}t(null,{InventoryConfiguration:o,statusCode:a.statusCode,headers:a.headers})})},listBucketInventory:function listBucketInventory(e,t){submitRequest.call(this,{Action:"name/cos:ListBucketInventory",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"inventory",qs:{"continuation-token":e.ContinuationToken}},function(e,a){if(e)return t(e);var o=a.ListInventoryConfigurationResult,r=o.InventoryConfiguration||[];r=s.isArray(r)?r:[r],delete o.InventoryConfiguration,s.each(r,function(e){if(e&&e.OptionalFields&&e.OptionalFields.Field){var t=e.OptionalFields.Field;s.isArray(t)||(t=[t]),e.OptionalFields=t}if(e.Destination&&e.Destination.COSBucketDestination&&e.Destination.COSBucketDestination.Encryption){var a=e.Destination.COSBucketDestination.Encryption;Object.keys(a).indexOf("SSE-COS")>-1&&(a.SSECOS=a["SSE-COS"],delete a["SSE-COS"])}}),o.InventoryConfigurations=r,s.extend(o,{statusCode:a.statusCode,headers:a.headers}),t(null,o)})},deleteBucketInventory:function deleteBucketInventory(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketInventory",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"inventory",qs:{id:e.Id}},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},putBucketAccelerate:function putBucketAccelerate(e,t){if(e.AccelerateConfiguration){var a={AccelerateConfiguration:e.AccelerateConfiguration||{}},o=s.json2xml(a),r={"Content-Type":"application/xml"};r["Content-MD5"]=s.binaryBase64(s.md5(o)),submitRequest.call(this,{Action:"name/cos:PutBucketAccelerate",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:o,action:"accelerate",headers:r},function(e,a){if(e)return t(e);t(null,{statusCode:a.statusCode,headers:a.headers})})}else t(s.error(new Error("missing param AccelerateConfiguration")))},getBucketAccelerate:function getBucketAccelerate(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketAccelerate",method:"GET",Bucket:e.Bucket,Region:e.Region,action:"accelerate"},function(e,a){e||!a.AccelerateConfiguration&&(a.AccelerateConfiguration={}),t(e,a)})},putBucketEncryption:function putBucketEncryption(e,t){var a=e.ServerSideEncryptionConfiguration||{},o=a.Rule||a.Rules||[],r=s.json2xml({ServerSideEncryptionConfiguration:{Rule:o}}),i=e.Headers;i["Content-Type"]="application/xml",i["Content-MD5"]=s.binaryBase64(s.md5(r)),submitRequest.call(this,{Action:"name/cos:PutBucketEncryption",method:"PUT",Bucket:e.Bucket,Region:e.Region,body:r,action:"encryption",headers:i},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getBucketEncryption:function getBucketEncryption(e,t){submitRequest.call(this,{Action:"name/cos:GetBucketEncryption",method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"encryption"},function(e,a){if(e)if(404===e.statusCode&&"NoSuchEncryptionConfiguration"===e.code){var o={EncryptionConfiguration:{Rules:[]},statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else t(e);else{var r=s.makeArray(a.EncryptionConfiguration&&a.EncryptionConfiguration.Rule||[]);a.EncryptionConfiguration={Rules:r},t(e,a)}})},deleteBucketEncryption:function deleteBucketEncryption(e,t){submitRequest.call(this,{Action:"name/cos:DeleteBucketReplication",method:"DELETE",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"encryption"},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getObject,getObjectStream:function getObjectStream(e,t){return e.ReturnStream=!0,getObject.call(this,e,t)},headObject:function headObject(e,t){submitRequest.call(this,{Action:"name/cos:HeadObject",method:"HEAD",Bucket:e.Bucket,Region:e.Region,Key:e.Key,VersionId:e.VersionId,headers:e.Headers},function(a,o){if(a){var r=a.statusCode;return e.Headers["If-Modified-Since"]&&r&&304===r?t(null,{NotModified:!0,statusCode:r}):t(a)}o.ETag=s.attr(o.headers,"etag",""),t(null,o)})},listObjectVersions:function listObjectVersions(e,t){var a={};a.prefix=e.Prefix||"",a.delimiter=e.Delimiter,a["key-marker"]=e.KeyMarker,a["version-id-marker"]=e.VersionIdMarker,a["max-keys"]=e.MaxKeys,a["encoding-type"]=e.EncodingType,submitRequest.call(this,{Action:"name/cos:GetBucketObjectVersions",ResourceKey:a.prefix,method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,qs:a,action:"versions"},function(e,a){if(e)return t(e);var o=a.ListVersionsResult||{},r=o.DeleteMarker||[];r=s.isArray(r)?r:[r];var i=o.Version||[];i=s.isArray(i)?i:[i];var n=s.clone(o);delete n.DeleteMarker,delete n.Version,s.extend(n,{DeleteMarkers:r,Versions:i,statusCode:a.statusCode,headers:a.headers}),t(null,n)})},putObject:function putObject(e,t){var a=this,o=e.ContentLength,r=s.throttleOnProgress.call(a,o,e.onProgress),i=e.Headers;i["Cache-Control"]||i["cache-control"]||(i["Cache-Control"]=""),s.getBodyMd5(a.options.UploadCheckContentMd5,e.Body,function(i){i&&(e.Headers["Content-MD5"]=s.binaryBase64(i)),void 0!==e.ContentLength&&(e.Headers["Content-Length"]=e.ContentLength),r(null,!0),submitRequest.call(a,{Action:"name/cos:PutObject",TaskId:e.TaskId,method:"PUT",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,qs:e.Query,body:e.Body,onProgress:r},function(i,n){if(i)return r(null,!0),t(i);if(r({loaded:o,total:o},!0),n){var s=getUrl({ForcePathStyle:a.options.ForcePathStyle,protocol:a.options.Protocol,domain:a.options.Domain,bucket:e.Bucket,region:a.options.UseAccelerate?"accelerate":e.Region,object:e.Key});return s=s.substr(s.indexOf("://")+3),n.Location=s,n.headers&&n.headers.etag&&(n.ETag=n.headers.etag),t(null,n)}t(null,n)})})},deleteObject:function deleteObject(e,t){submitRequest.call(this,{Action:"name/cos:DeleteObject",method:"DELETE",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,VersionId:e.VersionId},function(e,a){if(e){var o=e.statusCode;return o&&404===o?t(null,{BucketNotFound:!0,statusCode:o}):t(e)}t(null,{statusCode:a.statusCode,headers:a.headers})})},getObjectAcl:function getObjectAcl(e,t){var a={};e.VersionId&&(a.versionId=e.VersionId),submitRequest.call(this,{Action:"name/cos:GetObjectACL",method:"GET",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,qs:a,action:"acl"},function(e,a){if(e)return t(e);var o=a.AccessControlPolicy||{},r=o.Owner||{},i=o.AccessControlList&&o.AccessControlList.Grant||[];i=s.isArray(i)?i:[i];var n=decodeAcl(o);delete n.GrantWrite,a.headers&&a.headers["x-cos-acl"]&&(n.ACL=a.headers["x-cos-acl"]),n=s.extend(n,{Owner:r,Grants:i,statusCode:a.statusCode,headers:a.headers}),t(null,n)})},putObjectAcl:function putObjectAcl(e,t){var a=e.Headers,o="";if(e.AccessControlPolicy){var r=s.clone(e.AccessControlPolicy||{}),i=r.Grants||r.Grant;i=s.isArray(i)?i:[i],delete r.Grant,delete r.Grants,r.AccessControlList={Grant:i},o=s.json2xml({AccessControlPolicy:r}),a["Content-Type"]="application/xml",a["Content-MD5"]=s.binaryBase64(s.md5(o))}s.each(a,function(e,t){0===t.indexOf("x-cos-grant-")&&(a[t]=uniqGrant(a[t]))}),submitRequest.call(this,{Action:"name/cos:PutObjectACL",method:"PUT",Bucket:e.Bucket,Region:e.Region,Key:e.Key,action:"acl",headers:a,body:o},function(e,a){if(e)return t(e);t(null,{statusCode:a.statusCode,headers:a.headers})})},optionsObject:function optionsObject(e,t){var a=e.Headers;a.Origin=e.Origin,a["Access-Control-Request-Method"]=e.AccessControlRequestMethod,a["Access-Control-Request-Headers"]=e.AccessControlRequestHeaders,submitRequest.call(this,{Action:"name/cos:OptionsObject",method:"OPTIONS",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:a},function(e,a){if(e)return e.statusCode&&403===e.statusCode?t(null,{OptionsForbidden:!0,statusCode:e.statusCode}):t(e);var o=a.headers||{};t(null,{AccessControlAllowOrigin:o["access-control-allow-origin"],AccessControlAllowMethods:o["access-control-allow-methods"],AccessControlAllowHeaders:o["access-control-allow-headers"],AccessControlExposeHeaders:o["access-control-expose-headers"],AccessControlMaxAge:o["access-control-max-age"],statusCode:a.statusCode,headers:a.headers})})},putObjectCopy:function putObjectCopy(e,t){var a=e.Headers;a["Cache-Control"]||a["cache-control"]||(a["Cache-Control"]="");var o=e.CopySource||"",r=s.getSourceParams.call(this,o);if(r){var i=r.Bucket,n=r.Region,c=decodeURIComponent(r.Key);submitRequest.call(this,{Scope:[{action:"name/cos:GetObject",bucket:i,region:n,prefix:c},{action:"name/cos:PutObject",bucket:e.Bucket,region:e.Region,prefix:e.Key}],method:"PUT",Bucket:e.Bucket,Region:e.Region,Key:e.Key,VersionId:e.VersionId,headers:e.Headers},function(e,a){if(e)return t(e);var o=s.clone(a.CopyObjectResult||{});s.extend(o,{statusCode:a.statusCode,headers:a.headers}),t(null,o)})}else t(s.error(new Error("CopySource format error")))},deleteMultipleObject:function deleteMultipleObject(e,t){var a=e.Objects||[],o=e.Quiet;a=s.isArray(a)?a:[a];var r=s.json2xml({Delete:{Object:a,Quiet:o||!1}}),i=e.Headers;i["Content-Type"]="application/xml",i["Content-MD5"]=s.binaryBase64(s.md5(r));var n=s.map(a,function(t){return{action:"name/cos:DeleteObject",bucket:e.Bucket,region:e.Region,prefix:t.Key}});submitRequest.call(this,{Scope:n,method:"POST",Bucket:e.Bucket,Region:e.Region,body:r,action:"delete",headers:i},function(e,a){if(e)return t(e);var o=a.DeleteResult||{},r=o.Deleted||[],i=o.Error||[];r=s.isArray(r)?r:[r],i=s.isArray(i)?i:[i];var n=s.clone(o);s.extend(n,{Error:i,Deleted:r,statusCode:a.statusCode,headers:a.headers}),t(null,n)})},restoreObject:function restoreObject(e,t){var a=e.Headers;if(e.RestoreRequest){var o=e.RestoreRequest||{},r=s.json2xml({RestoreRequest:o});a["Content-Type"]="application/xml",a["Content-MD5"]=s.binaryBase64(s.md5(r)),submitRequest.call(this,{Action:"name/cos:RestoreObject",method:"POST",Bucket:e.Bucket,Region:e.Region,Key:e.Key,VersionId:e.VersionId,body:r,action:"restore",headers:a},t)}else t(s.error(new Error("missing param RestoreRequest")))},putObjectTagging:function putObjectTagging(e,t){var a=e.Tagging||{},o=a.TagSet||a.Tags||e.Tags||[];o=s.clone(s.isArray(o)?o:[o]);var r=s.json2xml({Tagging:{TagSet:{Tag:o}}}),i=e.Headers;i["Content-Type"]="application/xml",i["Content-MD5"]=s.binaryBase64(s.md5(r)),submitRequest.call(this,{Action:"name/cos:PutObjectTagging",method:"PUT",Bucket:e.Bucket,Key:e.Key,Region:e.Region,body:r,action:"tagging",headers:i,VersionId:e.VersionId},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},getObjectTagging:function getObjectTagging(e,t){submitRequest.call(this,{Action:"name/cos:GetObjectTagging",method:"GET",Key:e.Key,Bucket:e.Bucket,Region:e.Region,headers:e.Headers,action:"tagging",VersionId:e.VersionId},function(e,a){if(e)if(404!==e.statusCode||!e.error||"Not Found"!==e.error&&"NoSuchTagSet"!==e.error.Code)t(e);else{var o={Tags:[],statusCode:e.statusCode};e.headers&&(o.headers=e.headers),t(null,o)}else{var r=[];try{r=a.Tagging.TagSet.Tag||[]}catch(e){}r=s.clone(s.isArray(r)?r:[r]),t(null,{Tags:r,statusCode:a.statusCode,headers:a.headers})}})},deleteObjectTagging:function deleteObjectTagging(e,t){submitRequest.call(this,{Action:"name/cos:DeleteObjectTagging",method:"DELETE",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,action:"tagging",VersionId:e.VersionId},function(e,a){return e&&204===e.statusCode?t(null,{statusCode:e.statusCode}):e?t(e):void t(null,{statusCode:a.statusCode,headers:a.headers})})},selectObjectContent,selectObjectContentStream:function selectObjectContentStream(e,t){return e.ReturnStream=!0,selectObjectContent.call(this,e,t)},appendObject:function appendObject(e,t){var a=e.Headers;a["Cache-Control"]||a["cache-control"]||(a["Cache-Control"]=""),submitRequest.call(this,{Action:"name/cos:AppendObject",method:"POST",Bucket:e.Bucket,Region:e.Region,action:"append",Key:e.Key,body:e.Body,qs:{position:e.Position},headers:e.Headers},function(e,a){if(e)return t(e);t(null,a)})},uploadPartCopy:function uploadPartCopy(e,t){var a=e.CopySource||"",o=s.getSourceParams.call(this,a);if(o){var r=o.Bucket,i=o.Region,n=decodeURIComponent(o.Key);submitRequest.call(this,{Scope:[{action:"name/cos:GetObject",bucket:r,region:i,prefix:n},{action:"name/cos:PutObject",bucket:e.Bucket,region:e.Region,prefix:e.Key}],method:"PUT",Bucket:e.Bucket,Region:e.Region,Key:e.Key,VersionId:e.VersionId,qs:{partNumber:e.PartNumber,uploadId:e.UploadId},headers:e.Headers},function(e,a){if(e)return t(e);var o=s.clone(a.CopyPartResult||{});s.extend(o,{statusCode:a.statusCode,headers:a.headers}),t(null,o)})}else t(s.error(new Error("CopySource format error")))},multipartInit:function multipartInit(e,t){var a=e.Headers;a["Cache-Control"]||a["cache-control"]||(a["Cache-Control"]=""),a["Content-Type"]||a["content-type"]||(a["Content-Type"]=e.Body&&e.Body.type||""),submitRequest.call(this,{Action:"name/cos:InitiateMultipartUpload",method:"POST",Bucket:e.Bucket,Region:e.Region,Key:e.Key,action:"uploads",headers:e.Headers,qs:e.Query},function(e,a){return e?t(e):(a=s.clone(a||{}))&&a.InitiateMultipartUploadResult?t(null,s.extend(a.InitiateMultipartUploadResult,{statusCode:a.statusCode,headers:a.headers})):void t(null,a)})},multipartUpload:function multipartUpload(e,t){var a=this;s.getFileSize("multipartUpload",e,function(){s.getBodyMd5(a.options.UploadCheckContentMd5,e.Body,function(o){o&&(e.Headers["Content-MD5"]=s.binaryBase64(o)),submitRequest.call(a,{Action:"name/cos:UploadPart",TaskId:e.TaskId,method:"PUT",Bucket:e.Bucket,Region:e.Region,Key:e.Key,qs:{partNumber:e.PartNumber,uploadId:e.UploadId},headers:e.Headers,onProgress:e.onProgress,body:e.Body||null,SwitchHost:e.SwitchHost},function(e,a){if(e)return t(e);t(null,{ETag:s.attr(a.headers,"etag",""),statusCode:a.statusCode,headers:a.headers})})})})},multipartComplete:function multipartComplete(e,t){for(var a=this,o=e.UploadId,r=e.Parts,i=0,n=r.length;i<n;i++)0!==r[i].ETag.indexOf('"')&&(r[i].ETag='"'+r[i].ETag+'"');var c=s.json2xml({CompleteMultipartUpload:{Part:r}});c=c.replace(/\n\s*/g,"");var p=e.Headers;p["Content-Type"]="application/xml",p["Content-MD5"]=s.binaryBase64(s.md5(c)),submitRequest.call(this,{Action:"name/cos:CompleteMultipartUpload",method:"POST",Bucket:e.Bucket,Region:e.Region,Key:e.Key,qs:{uploadId:o},body:c,headers:p},function(o,r){if(o)return t(o);var i=getUrl({ForcePathStyle:a.options.ForcePathStyle,protocol:a.options.Protocol,domain:a.options.Domain,bucket:e.Bucket,region:a.options.UseAccelerate?"accelerate":e.Region,object:e.Key,isLocation:!0}),n=r.CompleteMultipartUploadResult||{};n.ProcessResults&&n&&n.ProcessResults&&(n.UploadResult={OriginalInfo:{Key:n.Key,Location:i,ETag:n.ETag,ImageInfo:n.ImageInfo},ProcessResults:n.ProcessResults},delete n.ImageInfo,delete n.ProcessResults);var c=s.extend(n,{Location:i,statusCode:r.statusCode,headers:r.headers});t(null,c)})},multipartList:function multipartList(e,t){var a={};a.delimiter=e.Delimiter,a["encoding-type"]=e.EncodingType,a.prefix=e.Prefix||"",a["max-uploads"]=e.MaxUploads,a["key-marker"]=e.KeyMarker,a["upload-id-marker"]=e.UploadIdMarker,a=s.clearKey(a),submitRequest.call(this,{Action:"name/cos:ListMultipartUploads",ResourceKey:a.prefix,method:"GET",Bucket:e.Bucket,Region:e.Region,headers:e.Headers,qs:a,action:"uploads"},function(e,a){if(e)return t(e);if(a&&a.ListMultipartUploadsResult){var o=a.ListMultipartUploadsResult.Upload||[];o=s.isArray(o)?o:[o],a.ListMultipartUploadsResult.Upload=o}var r=s.clone(a.ListMultipartUploadsResult||{});s.extend(r,{statusCode:a.statusCode,headers:a.headers}),t(null,r)})},multipartListPart:function multipartListPart(e,t){var a={};a.uploadId=e.UploadId,a["encoding-type"]=e.EncodingType,a["max-parts"]=e.MaxParts,a["part-number-marker"]=e.PartNumberMarker,submitRequest.call(this,{Action:"name/cos:ListParts",method:"GET",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,qs:a},function(e,a){if(e)return t(e);var o=a.ListPartsResult||{},r=o.Part||[];r=s.isArray(r)?r:[r],o.Part=r;var i=s.clone(o);s.extend(i,{statusCode:a.statusCode,headers:a.headers}),t(null,i)})},multipartAbort:function multipartAbort(e,t){var a={};a.uploadId=e.UploadId,submitRequest.call(this,{Action:"name/cos:AbortMultipartUpload",method:"DELETE",Bucket:e.Bucket,Region:e.Region,Key:e.Key,headers:e.Headers,qs:a},function(e,a){if(e)return t(e);t(null,{statusCode:a.statusCode,headers:a.headers})})},request:function request(e,t){var a=e.Query||{};if(e.Url){var o=e.Url.match(/^https?:\/\/([^/]+)(\/[^?#]*)?(\?[^#]*)?(#.*)?$/),r=o&&o[2]||"";r&&!e.Key&&(e.Key=r.substr(1))}submitRequest.call(this,{method:e.Method,Bucket:e.Bucket,Region:e.Region,Key:e.Key,action:e.Action,headers:e.Headers,qs:a,body:e.Body,url:e.Url,rawBody:e.RawBody},function(e,a){if(e)return t(e);a&&a.body&&(a.Body=a.body,delete a.body),t(e,a)})},getObjectUrl:function getObjectUrl(e,t){var a=this,o=void 0===e.UseAccelerate?a.options.UseAccelerate:e.UseAccelerate,r=getUrl({ForcePathStyle:a.options.ForcePathStyle,protocol:e.Protocol||a.options.Protocol,domain:e.Domain||a.options.Domain,bucket:e.Bucket,region:o?"accelerate":e.Region,object:e.Key}),i="";e.Query&&(i+=s.obj2str(e.Query)),e.QueryString&&(i+=(i?"&":"")+e.QueryString);var n=r;if(void 0!==e.Sign&&!e.Sign)return i&&(n+="?"+i),t(null,{Url:n}),n;var c=getSignHost.call(this,{Bucket:e.Bucket,Region:e.Region,UseAccelerate:e.UseAccelerate,Url:r}),p=getAuthorizationAsync.call(this,{Action:"PUT"===(e.Method||"").toUpperCase()?"name/cos:PutObject":"name/cos:GetObject",Bucket:e.Bucket||"",Region:e.Region||"",Method:e.Method||"get",Key:e.Key,Expires:e.Expires,Headers:e.Headers,Query:e.Query,SignHost:c,ForceSignHost:!1!==e.ForceSignHost&&a.options.ForceSignHost},function(e,a){if(t)if(e)t(e);else{var o=r;o+="?"+(a.Authorization.indexOf("q-signature")>-1?function(e){var t=e.match(/q-url-param-list.*?(?=&)/g)[0],a="q-url-param-list="+encodeURIComponent(t.replace(/q-url-param-list=/,"")).toLowerCase(),o=new RegExp(t,"g");return e.replace(o,a)}(a.Authorization):"sign="+encodeURIComponent(a.Authorization)),a.SecurityToken&&(o+="&x-cos-security-token="+a.SecurityToken),a.ClientIP&&(o+="&clientIP="+a.ClientIP),a.ClientUA&&(o+="&clientUA="+a.ClientUA),a.Token&&(o+="&token="+a.Token),i&&(o+="&"+i),setTimeout(function(){t(null,{Url:o})})}});return p?(n+="?"+p.Authorization+(p.SecurityToken?"&x-cos-security-token="+p.SecurityToken:""),i&&(n+="&"+i)):i&&(n+="?"+i),n},getAuth:function getAuth(e){return s.getAuth({SecretId:e.SecretId||this.options.SecretId||"",SecretKey:e.SecretKey||this.options.SecretKey||"",Bucket:e.Bucket,Region:e.Region,Method:e.Method,Key:e.Key,Query:e.Query,Headers:e.Headers,Expires:e.Expires,UseRawKey:this.options.UseRawKey,SystemClockOffset:this.options.SystemClockOffset})},getV4Auth:function getV4Auth(e){return s.getV4Auth({SecretId:e.SecretId||this.options.SecretId||"",SecretKey:e.SecretKey||this.options.SecretKey||"",Bucket:e.Bucket,Key:e.Key,Expires:e.Expires})}};e.exports.init=function(e,t){t.transferToTaskMethod(p,"putObject"),s.each(p,function(t,a){e.prototype[a]=s.apiWrapper(a,t),function warnOldApi(e,t,a){s.each(["Cors","Acl"],function(o){if(e.slice(-o.length)===o){var r=e.slice(0,-o.length)+o.toUpperCase(),i=s.apiWrapper(e,t),n=!1;a[r]=function(){!n&&console.warn("warning: cos."+r+" has been deprecated. Please Use cos."+e+" instead."),n=!0,i.apply(this,arguments)}}})}(a,t,e.prototype)})}},13874:(e,t,a)=>{"use strict";const o=a(78311);e.exports=(e,t)=>{try{return new o(e,t).range||"*"}catch(e){return null}}},13999:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t,a)=>0!==o(e,t,a)},14015:(e,t,a)=>{"use strict";var o=a(88947).lowlevel.crypto_hash,r=0,Blowfish=function(){this.S=[new Uint32Array([3509652390,2564797868,805139163,3491422135,3101798381,1780907670,3128725573,4046225305,614570311,3012652279,134345442,2240740374,1667834072,1901547113,2757295779,4103290238,227898511,1921955416,1904987480,2182433518,2069144605,3260701109,2620446009,720527379,3318853667,677414384,3393288472,3101374703,2390351024,1614419982,1822297739,2954791486,3608508353,3174124327,2024746970,1432378464,3864339955,2857741204,1464375394,1676153920,1439316330,715854006,3033291828,289532110,2706671279,2087905683,3018724369,1668267050,732546397,1947742710,3462151702,2609353502,2950085171,1814351708,2050118529,680887927,999245976,1800124847,3300911131,1713906067,1641548236,4213287313,1216130144,1575780402,4018429277,3917837745,3693486850,3949271944,596196993,3549867205,258830323,2213823033,772490370,2760122372,1774776394,2652871518,566650946,4142492826,1728879713,2882767088,1783734482,3629395816,2517608232,2874225571,1861159788,326777828,3124490320,2130389656,2716951837,967770486,1724537150,2185432712,2364442137,1164943284,2105845187,998989502,3765401048,2244026483,1075463327,1455516326,1322494562,910128902,469688178,1117454909,936433444,3490320968,3675253459,1240580251,122909385,2157517691,634681816,4142456567,3825094682,3061402683,2540495037,79693498,3249098678,1084186820,1583128258,426386531,1761308591,1047286709,322548459,995290223,1845252383,2603652396,3431023940,2942221577,3202600964,3727903485,1712269319,422464435,3234572375,1170764815,3523960633,3117677531,1434042557,442511882,3600875718,1076654713,1738483198,4213154764,2393238008,3677496056,1014306527,4251020053,793779912,2902807211,842905082,4246964064,1395751752,1040244610,2656851899,3396308128,445077038,3742853595,3577915638,679411651,2892444358,2354009459,1767581616,3150600392,3791627101,3102740896,284835224,4246832056,1258075500,768725851,2589189241,3069724005,3532540348,1274779536,3789419226,2764799539,1660621633,3471099624,4011903706,913787905,3497959166,737222580,2514213453,2928710040,3937242737,1804850592,3499020752,2949064160,2386320175,2390070455,2415321851,4061277028,2290661394,2416832540,1336762016,1754252060,3520065937,3014181293,791618072,3188594551,3933548030,2332172193,3852520463,3043980520,413987798,3465142937,3030929376,4245938359,2093235073,3534596313,375366246,2157278981,2479649556,555357303,3870105701,2008414854,3344188149,4221384143,3956125452,2067696032,3594591187,2921233993,2428461,544322398,577241275,1471733935,610547355,4027169054,1432588573,1507829418,2025931657,3646575487,545086370,48609733,2200306550,1653985193,298326376,1316178497,3007786442,2064951626,458293330,2589141269,3591329599,3164325604,727753846,2179363840,146436021,1461446943,4069977195,705550613,3059967265,3887724982,4281599278,3313849956,1404054877,2845806497,146425753,1854211946]),new Uint32Array([1266315497,3048417604,3681880366,3289982499,290971e4,1235738493,2632868024,2414719590,3970600049,1771706367,1449415276,3266420449,422970021,1963543593,2690192192,3826793022,1062508698,1531092325,1804592342,2583117782,2714934279,4024971509,1294809318,4028980673,1289560198,2221992742,1669523910,35572830,157838143,1052438473,1016535060,1802137761,1753167236,1386275462,3080475397,2857371447,1040679964,2145300060,2390574316,1461121720,2956646967,4031777805,4028374788,33600511,2920084762,1018524850,629373528,3691585981,3515945977,2091462646,2486323059,586499841,988145025,935516892,3367335476,2599673255,2839830854,265290510,3972581182,2759138881,3795373465,1005194799,847297441,406762289,1314163512,1332590856,1866599683,4127851711,750260880,613907577,1450815602,3165620655,3734664991,3650291728,3012275730,3704569646,1427272223,778793252,1343938022,2676280711,2052605720,1946737175,3164576444,3914038668,3967478842,3682934266,1661551462,3294938066,4011595847,840292616,3712170807,616741398,312560963,711312465,1351876610,322626781,1910503582,271666773,2175563734,1594956187,70604529,3617834859,1007753275,1495573769,4069517037,2549218298,2663038764,504708206,2263041392,3941167025,2249088522,1514023603,1998579484,1312622330,694541497,2582060303,2151582166,1382467621,776784248,2618340202,3323268794,2497899128,2784771155,503983604,4076293799,907881277,423175695,432175456,1378068232,4145222326,3954048622,3938656102,3820766613,2793130115,2977904593,26017576,3274890735,3194772133,1700274565,1756076034,4006520079,3677328699,720338349,1533947780,354530856,688349552,3973924725,1637815568,332179504,3949051286,53804574,2852348879,3044236432,1282449977,3583942155,3416972820,4006381244,1617046695,2628476075,3002303598,1686838959,431878346,2686675385,1700445008,1080580658,1009431731,832498133,3223435511,2605976345,2271191193,2516031870,1648197032,4164389018,2548247927,300782431,375919233,238389289,3353747414,2531188641,2019080857,1475708069,455242339,2609103871,448939670,3451063019,1395535956,2413381860,1841049896,1491858159,885456874,4264095073,4001119347,1565136089,3898914787,1108368660,540939232,1173283510,2745871338,3681308437,4207628240,3343053890,4016749493,1699691293,1103962373,3625875870,2256883143,3830138730,1031889488,3479347698,1535977030,4236805024,3251091107,2132092099,1774941330,1199868427,1452454533,157007616,2904115357,342012276,595725824,1480756522,206960106,497939518,591360097,863170706,2375253569,3596610801,1814182875,2094937945,3421402208,1082520231,3463918190,2785509508,435703966,3908032597,1641649973,2842273706,3305899714,1510255612,2148256476,2655287854,3276092548,4258621189,236887753,3681803219,274041037,1734335097,3815195456,3317970021,1899903192,1026095262,4050517792,356393447,2410691914,3873677099,3682840055]),new Uint32Array([3913112168,2491498743,4132185628,2489919796,1091903735,1979897079,3170134830,3567386728,3557303409,857797738,1136121015,1342202287,507115054,2535736646,337727348,3213592640,1301675037,2528481711,1895095763,1721773893,3216771564,62756741,2142006736,835421444,2531993523,1442658625,3659876326,2882144922,676362277,1392781812,170690266,3921047035,1759253602,3611846912,1745797284,664899054,1329594018,3901205900,3045908486,2062866102,2865634940,3543621612,3464012697,1080764994,553557557,3656615353,3996768171,991055499,499776247,1265440854,648242737,3940784050,980351604,3713745714,1749149687,3396870395,4211799374,3640570775,1161844396,3125318951,1431517754,545492359,4268468663,3499529547,1437099964,2702547544,3433638243,2581715763,2787789398,1060185593,1593081372,2418618748,4260947970,69676912,2159744348,86519011,2512459080,3838209314,1220612927,3339683548,133810670,1090789135,1078426020,1569222167,845107691,3583754449,4072456591,1091646820,628848692,1613405280,3757631651,526609435,236106946,48312990,2942717905,3402727701,1797494240,859738849,992217954,4005476642,2243076622,3870952857,3732016268,765654824,3490871365,2511836413,1685915746,3888969200,1414112111,2273134842,3281911079,4080962846,172450625,2569994100,980381355,4109958455,2819808352,2716589560,2568741196,3681446669,3329971472,1835478071,660984891,3704678404,4045999559,3422617507,3040415634,1762651403,1719377915,3470491036,2693910283,3642056355,3138596744,1364962596,2073328063,1983633131,926494387,3423689081,2150032023,4096667949,1749200295,3328846651,309677260,2016342300,1779581495,3079819751,111262694,1274766160,443224088,298511866,1025883608,3806446537,1145181785,168956806,3641502830,3584813610,1689216846,3666258015,3200248200,1692713982,2646376535,4042768518,1618508792,1610833997,3523052358,4130873264,2001055236,3610705100,2202168115,4028541809,2961195399,1006657119,2006996926,3186142756,1430667929,3210227297,1314452623,4074634658,4101304120,2273951170,1399257539,3367210612,3027628629,1190975929,2062231137,2333990788,2221543033,2438960610,1181637006,548689776,2362791313,3372408396,3104550113,3145860560,296247880,1970579870,3078560182,3769228297,1714227617,3291629107,3898220290,166772364,1251581989,493813264,448347421,195405023,2709975567,677966185,3703036547,1463355134,2715995803,1338867538,1343315457,2802222074,2684532164,233230375,2599980071,2000651841,3277868038,1638401717,4028070440,3237316320,6314154,819756386,300326615,590932579,1405279636,3267499572,3150704214,2428286686,3959192993,3461946742,1862657033,1266418056,963775037,2089974820,2263052895,1917689273,448879540,3550394620,3981727096,150775221,3627908307,1303187396,508620638,2975983352,2726630617,1817252668,1876281319,1457606340,908771278,3720792119,3617206836,2455994898,1729034894,1080033504]),new Uint32Array([976866871,3556439503,2881648439,1522871579,1555064734,1336096578,3548522304,2579274686,3574697629,3205460757,3593280638,3338716283,3079412587,564236357,2993598910,1781952180,1464380207,3163844217,3332601554,1699332808,1393555694,1183702653,3581086237,1288719814,691649499,2847557200,2895455976,3193889540,2717570544,1781354906,1676643554,2592534050,3230253752,1126444790,2770207658,2633158820,2210423226,2615765581,2414155088,3127139286,673620729,2805611233,1269405062,4015350505,3341807571,4149409754,1057255273,2012875353,2162469141,2276492801,2601117357,993977747,3918593370,2654263191,753973209,36408145,2530585658,25011837,3520020182,2088578344,530523599,2918365339,1524020338,1518925132,3760827505,3759777254,1202760957,3985898139,3906192525,674977740,4174734889,2031300136,2019492241,3983892565,4153806404,3822280332,352677332,2297720250,60907813,90501309,3286998549,1016092578,2535922412,2839152426,457141659,509813237,4120667899,652014361,1966332200,2975202805,55981186,2327461051,676427537,3255491064,2882294119,3433927263,1307055953,942726286,933058658,2468411793,3933900994,4215176142,1361170020,2001714738,2830558078,3274259782,1222529897,1679025792,2729314320,3714953764,1770335741,151462246,3013232138,1682292957,1483529935,471910574,1539241949,458788160,3436315007,1807016891,3718408830,978976581,1043663428,3165965781,1927990952,4200891579,2372276910,3208408903,3533431907,1412390302,2931980059,4132332400,1947078029,3881505623,4168226417,2941484381,1077988104,1320477388,886195818,18198404,3786409e3,2509781533,112762804,3463356488,1866414978,891333506,18488651,661792760,1628790961,3885187036,3141171499,876946877,2693282273,1372485963,791857591,2686433993,3759982718,3167212022,3472953795,2716379847,445679433,3561995674,3504004811,3574258232,54117162,3331405415,2381918588,3769707343,4154350007,1140177722,4074052095,668550556,3214352940,367459370,261225585,2610173221,4209349473,3468074219,3265815641,314222801,3066103646,3808782860,282218597,3406013506,3773591054,379116347,1285071038,846784868,2669647154,3771962079,3550491691,2305946142,453669953,1268987020,3317592352,3279303384,3744833421,2610507566,3859509063,266596637,3847019092,517658769,3462560207,3443424879,370717030,4247526661,2224018117,4143653529,4112773975,2788324899,2477274417,1456262402,2901442914,1517677493,1846949527,2295493580,3734397586,2176403920,1280348187,1908823572,3871786941,846861322,1172426758,3287448474,3383383037,1655181056,3139813346,901632758,1897031941,2986607138,3066810236,3447102507,1393639104,373351379,950779232,625454576,3124240540,4148612726,2007998917,544563296,2244738638,2330496472,2058025392,1291430526,424198748,50039436,29584100,3605783033,2429876329,2791104160,1057563949,3255363231,3075367218,3463963227,1469046755,985887462])],this.P=new Uint32Array([608135816,2242054355,320440878,57701188,2752067618,698298832,137296536,3964562569,1160258022,953160567,3193202383,887688300,3232508343,3380367581,1065670069,3041331479,2450970073,2306472731])};function F(e,t,a){return(e[0][t[a+3]]+e[1][t[a+2]]^e[2][t[a+1]])+e[3][t[a]]}function stream2word(e,t){var a,o=0;for(a=0;a<4;a++,r++)r>=t&&(r=0),o=o<<8|e[r];return o}Blowfish.prototype.encipher=function(e,t){void 0===t&&(t=new Uint8Array(e.buffer),0!==e.byteOffset&&(t=t.subarray(e.byteOffset))),e[0]^=this.P[0];for(var a=1;a<16;a+=2)e[1]^=F(this.S,t,0)^this.P[a],e[0]^=F(this.S,t,4)^this.P[a+1];var o=e[0];e[0]=e[1]^this.P[17],e[1]=o},Blowfish.prototype.decipher=function(e){var t=new Uint8Array(e.buffer);0!==e.byteOffset&&(t=t.subarray(e.byteOffset)),e[0]^=this.P[17];for(var a=16;a>0;a-=2)e[1]^=F(this.S,t,0)^this.P[a],e[0]^=F(this.S,t,4)^this.P[a-1];var o=e[0];e[0]=e[1]^this.P[0],e[1]=o},Blowfish.prototype.expand0state=function(e,t){var a,o,i=new Uint32Array(2),n=new Uint8Array(i.buffer);for(a=0,r=0;a<18;a++)this.P[a]^=stream2word(e,t);for(r=0,a=0;a<18;a+=2)this.encipher(i,n),this.P[a]=i[0],this.P[a+1]=i[1];for(a=0;a<4;a++)for(o=0;o<256;o+=2)this.encipher(i,n),this.S[a][o]=i[0],this.S[a][o+1]=i[1]},Blowfish.prototype.expandstate=function(e,t,a,o){var i,n,s=new Uint32Array(2);for(i=0,r=0;i<18;i++)this.P[i]^=stream2word(a,o);for(i=0,r=0;i<18;i+=2)s[0]^=stream2word(e,t),s[1]^=stream2word(e,t),this.encipher(s),this.P[i]=s[0],this.P[i+1]=s[1];for(i=0;i<4;i++)for(n=0;n<256;n+=2)s[0]^=stream2word(e,t),s[1]^=stream2word(e,t),this.encipher(s),this.S[i][n]=s[0],this.S[i][n+1]=s[1];r=0},Blowfish.prototype.enc=function(e,t){for(var a=0;a<t;a++)this.encipher(e.subarray(2*a))},Blowfish.prototype.dec=function(e,t){for(var a=0;a<t;a++)this.decipher(e.subarray(2*a))};function bcrypt_hash(e,t,a){var o,r=new Blowfish,i=new Uint32Array(8),n=new Uint8Array([79,120,121,99,104,114,111,109,97,116,105,99,66,108,111,119,102,105,115,104,83,119,97,116,68,121,110,97,109,105,116,101]);for(r.expandstate(t,64,e,64),o=0;o<64;o++)r.expand0state(t,64),r.expand0state(e,64);for(o=0;o<8;o++)i[o]=stream2word(n,n.byteLength);for(o=0;o<64;o++)r.enc(i,i.byteLength/8);for(o=0;o<8;o++)a[4*o+3]=i[o]>>>24,a[4*o+2]=i[o]>>>16,a[4*o+1]=i[o]>>>8,a[4*o+0]=i[o]}e.exports={BLOCKS:8,HASHSIZE:32,hash:bcrypt_hash,pbkdf:function bcrypt_pbkdf(e,t,a,r,i,n,s){var c,p,u,l,m,f,h=new Uint8Array(64),g=new Uint8Array(64),y=new Uint8Array(32),b=new Uint8Array(32),x=new Uint8Array(r+4),w=n;if(s<1)return-1;if(0===t||0===r||0===n||n>y.byteLength*y.byteLength||r>1<<20)return-1;for(l=Math.floor((n+y.byteLength-1)/y.byteLength),u=Math.floor((n+l-1)/l),c=0;c<r;c++)x[c]=a[c];for(o(h,e,t),f=1;n>0;f++){for(x[r+0]=f>>>24,x[r+1]=f>>>16,x[r+2]=f>>>8,x[r+3]=f,o(g,x,r+4),bcrypt_hash(h,g,b),c=y.byteLength;c--;)y[c]=b[c];for(c=1;c<s;c++)for(o(g,b,b.byteLength),bcrypt_hash(h,g,b),p=0;p<y.byteLength;p++)y[p]^=b[p];for(u=Math.min(u,n),c=0;c<u&&!((m=c*l+(f-1))>=w);c++)i[m]=y[c];n-=c}return 0}}},14018:(e,t)=>{"use strict";function fmtDef(e,t){return{validate:e,compare:t}}Object.defineProperty(t,"__esModule",{value:!0}),t.formatNames=t.fastFormats=t.fullFormats=void 0,t.fullFormats={date:fmtDef(date,compareDate),time:fmtDef(time,compareTime),"date-time":fmtDef(function date_time(e){const t=e.split(i);return 2===t.length&&date(t[0])&&time(t[1],!0)},compareDateTime),duration:/^P(?!$)((\d+Y)?(\d+M)?(\d+D)?(T(?=\d)(\d+H)?(\d+M)?(\d+S)?)?|(\d+W)?)$/,uri:function uri(e){return n.test(e)&&s.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,url:/^(?:https?|ftp):\/\/(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)(?:\.(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$/i,regex:function regex(e){if(c.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}},uuid:/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,"json-pointer":/^(?:\/(?:[^~/]|~0|~1)*)*$/,"json-pointer-uri-fragment":/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,"relative-json-pointer":/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/},t.fastFormats={...t.fullFormats,date:fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d$/,compareDate),time:fmtDef(/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,compareTime),"date-time":fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,compareDateTime),uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i},t.formatNames=Object.keys(t.fullFormats);const a=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,o=[0,31,28,31,30,31,30,31,31,30,31,30,31];function date(e){const t=a.exec(e);if(!t)return!1;const r=+t[1],i=+t[2],n=+t[3];return i>=1&&i<=12&&n>=1&&n<=(2===i&&function isLeapYear(e){return e%4==0&&(e%100!=0||e%400==0)}(r)?29:o[i])}function compareDate(e,t){if(e&&t)return e>t?1:e<t?-1:0}const r=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;function time(e,t){const a=r.exec(e);if(!a)return!1;const o=+a[1],i=+a[2],n=+a[3],s=a[5];return(o<=23&&i<=59&&n<=59||23===o&&59===i&&60===n)&&(!t||""!==s)}function compareTime(e,t){if(!e||!t)return;const a=r.exec(e),o=r.exec(t);return a&&o?(e=a[1]+a[2]+a[3]+(a[4]||""))>(t=o[1]+o[2]+o[3]+(o[4]||""))?1:e<t?-1:0:void 0}const i=/t|\s/i;function compareDateTime(e,t){if(!e||!t)return;const[a,o]=e.split(i),[r,n]=t.split(i),s=compareDate(a,r);return void 0!==s?s||compareTime(o,n):void 0}const n=/\/|:/,s=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;const c=/[^\\]\\Z/},14117:e=>{function HARError(e){var t="validation failed";this.name="HARError",this.message=t,this.errors=e,"function"==typeof Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=new Error(t).stack}HARError.prototype=Error.prototype,e.exports=HARError},14235:(e,t,a)=>{var o=a(94742),r=(a(39023),a(1143)),i=a(45201),n=a(25543);function hasKey(e,t){return o.equal(typeof t,"string"),Object.prototype.hasOwnProperty.call(e,t)}function pluckv(e,t){if(null!==e&&"object"==typeof e){if(e.hasOwnProperty(t))return e[t];var a=t.indexOf(".");if(-1!=a){var o=t.substr(0,a);if(e.hasOwnProperty(o))return pluckv(e[o],t.substr(a+1))}}}function doFlattenIter(e,t,a,r){var i,n;if(0===t)return(i=a.slice(0)).push(e),void r(i);for(n in o.ok(null!==e),o.equal(typeof e,"object"),o.equal(typeof t,"number"),o.ok(t>=0),e)(i=a.slice(0)).push(n),doFlattenIter(e[n],t-1,i,r)}t.deepCopy=function deepCopy(e){var t,a,o="__deepCopy";if(e&&e[o])throw new Error("attempted deep copy of cyclic object");if(e&&e.constructor==Object){for(a in t={},e[o]=!0,e)a!=o&&(t[a]=deepCopy(e[a]));return delete e[o],t}if(e&&e.constructor==Array){for(t=[],e[o]=!0,a=0;a<e.length;a++)t.push(deepCopy(e[a]));return delete e[o],t}return e},t.deepEqual=function deepEqual(e,t){if(typeof e!=typeof t)return!1;if(null===e||null===t||"object"!=typeof e)return e===t;if(e.constructor!=t.constructor)return!1;var a;for(a in e){if(!t.hasOwnProperty(a))return!1;if(!deepEqual(e[a],t[a]))return!1}for(a in t)if(!e.hasOwnProperty(a))return!1;return!0},t.isEmpty=function isEmpty(e){var t;for(t in e)return!1;return!0},t.hasKey=hasKey,t.forEachKey=function forEachKey(e,t){for(var a in e)hasKey(e,a)&&t(a,e[a])},t.pluck=function pluck(e,t){return o.equal(typeof t,"string"),pluckv(e,t)},t.flattenObject=function flattenObject(e,t){if(0===t)return[e];o.ok(null!==e),o.equal(typeof e,"object"),o.equal(typeof t,"number"),o.ok(t>=0);var a,r=[];for(a in e)flattenObject(e[a],t-1).forEach(function(e){r.push([a].concat(e))});return r},t.flattenIter=function flattenIter(e,t,a){doFlattenIter(e,t,[],a)},t.validateJsonObject=validateJsonObjectJS,t.validateJsonObjectJS=validateJsonObjectJS,t.randElt=function randElt(e){return o.ok(Array.isArray(e)&&e.length>0,"randElt argument must be a non-empty array"),e[Math.floor(Math.random()*e.length)]},t.extraProperties=function extraProperties(e,t){o.ok("object"==typeof e&&null!==e,"obj argument must be a non-null object"),o.ok(Array.isArray(t),"allowed argument must be an array of strings");for(var a=0;a<t.length;a++)o.ok("string"==typeof t[a],"allowed argument must be an array of strings");return Object.keys(e).filter(function(e){return-1===t.indexOf(e)})},t.mergeObjects=mergeObjects,t.startsWith=function startsWith(e,t){return e.substr(0,t.length)==t},t.endsWith=function endsWith(e,t){return e.substr(e.length-t.length,t.length)==t},t.parseInteger=function parseInteger(e,t){o.string(e,"str"),o.optionalObject(t,"options");var a,r=!1,i=l;t&&(r=hasKey(t,"base"),i=mergeObjects(i,t),o.number(i.base,"options.base"),o.ok(i.base>=2,"options.base >= 2"),o.ok(i.base<=36,"options.base <= 36"),o.bool(i.allowSign,"options.allowSign"),o.bool(i.allowPrefix,"options.allowPrefix"),o.bool(i.allowTrailing,"options.allowTrailing"),o.bool(i.allowImprecise,"options.allowImprecise"),o.bool(i.trimWhitespace,"options.trimWhitespace"),o.bool(i.leadingZeroIsOctal,"options.leadingZeroIsOctal"),i.leadingZeroIsOctal&&o.ok(!r,'"base" and "leadingZeroIsOctal" are mutually exclusive'));var n,s=-1,c=i.base,m=1,f=0,h=0,w=e.length;if(i.trimWhitespace)for(;h<w&&isSpace(e.charCodeAt(h));)++h;i.allowSign&&("-"===e[h]?(h+=1,m=-1):"+"===e[h]&&(h+=1));"0"===e[h]&&(i.allowPrefix&&(s=function prefixToBase(e){return e===j||e===g?2:e===C||e===y?8:e===P||e===b?10:e===O||e===x?16:-1}(e.charCodeAt(h+1)),-1===s||r&&s!==c||(c=s,h+=2)),-1===s&&i.leadingZeroIsOctal&&(c=8));for(n=h;h<w&&(-1!==(a=translateDigit(e.charCodeAt(h)))&&a<c);++h)f*=c,f+=a;if(n===h)return new Error("invalid number: "+JSON.stringify(e));if(i.trimWhitespace)for(;h<w&&isSpace(e.charCodeAt(h));)++h;if(h<w&&!i.allowTrailing)return new Error("trailing characters after number: "+JSON.stringify(e.slice(h)));if(0===f)return 0;var k=f*m;if(!i.allowImprecise&&(f>p||k<u))return new Error("number is outside of the supported range: "+JSON.stringify(e.slice(n,h)));return k},t.iso8601=function iso8601(e){"number"==typeof e&&(e=new Date(e));return o.ok(e.constructor===Date),r.sprintf("%4d-%02d-%02dT%02d:%02d:%02d.%03dZ",e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())},t.rfc1123=function rfc1123(e){return r.sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",c[e.getUTCDay()],e.getUTCDate(),s[e.getUTCMonth()],e.getUTCFullYear(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds())},t.parseDateTime=function parseDateTime(e){var t=+e;return isNaN(t)?new Date(e):new Date(t)},t.hrtimediff=hrtimeDiff,t.hrtimeDiff=hrtimeDiff,t.hrtimeAccum=hrtimeAccum,t.hrtimeAdd=function hrtimeAdd(e,t){return assertHrtime(e),hrtimeAccum([e[0],e[1]],t)},t.hrtimeNanosec=function hrtimeNanosec(e){return assertHrtime(e),Math.floor(1e9*e[0]+e[1])},t.hrtimeMicrosec=function hrtimeMicrosec(e){return assertHrtime(e),Math.floor(1e6*e[0]+e[1]/1e3)},t.hrtimeMillisec=function hrtimeMillisec(e){return assertHrtime(e),Math.floor(1e3*e[0]+e[1]/1e6)};var s=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],c=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];var p=Number.MAX_SAFE_INTEGER||9007199254740991,u=Number.MIN_SAFE_INTEGER||-9007199254740991,l={base:10,allowSign:!0,allowPrefix:!1,allowTrailing:!1,allowImprecise:!1,trimWhitespace:!1,leadingZeroIsOctal:!1},m=48,f=57,h=65,g=66,y=79,b=84,x=88,w=90,k=97,j=98,C=111,P=116,O=120,I=122,z=48,q=55,$=87;function translateDigit(e){return e>=m&&e<=f?e-z:e>=h&&e<=w?e-q:e>=k&&e<=I?e-$:-1}function isSpace(e){return 32===e||e>=9&&e<=13||160===e||5760===e||6158===e||e>=8192&&e<=8202||8232===e||8233===e||8239===e||8287===e||12288===e||65279===e}function validateJsonObjectJS(e,t){var a=n.validate(t,e);if(0===a.errors.length)return null;var o,r,s=a.errors[0],c=s.property,p=s.message.toLowerCase();-1!=(o=p.indexOf("the property "))&&-1!=(r=p.indexOf(" is not defined in the schema and the schema does not allow additional properties"))&&(o+=13,c=""===c?p.substr(o,r-o):c+"."+p.substr(o,r-o),p="unsupported property");var u=new i.VError('property "%s": %s',c,p);return u.jsv_details=s,u}function assertHrtime(e){o.ok(e[0]>=0&&e[1]>=0,"negative numbers not allowed in hrtimes"),o.ok(e[1]<1e9,"nanoseconds column overflow")}function hrtimeDiff(e,t){assertHrtime(e),assertHrtime(t),o.ok(e[0]>t[0]||e[0]==t[0]&&e[1]>=t[1],"negative differences not allowed");var a=[e[0]-t[0],0];return e[1]>=t[1]?a[1]=e[1]-t[1]:(a[0]--,a[1]=1e9-(t[1]-e[1])),a}function hrtimeAccum(e,t){return assertHrtime(e),assertHrtime(t),e[1]+=t[1],e[1]>=1e9&&(e[0]++,e[1]-=1e9),e[0]+=t[0],e}function mergeObjects(e,t,a){var o,r;if(o={},a)for(r in a)o[r]=a[r];if(e)for(r in e)o[r]=e[r];if(t)for(r in t)o[r]=t[r];return o}},14276:e=>{"use strict";function listener(e,t){return function onevent(a){for(var o=new Array(arguments.length),r="error"===e?a:null,i=0;i<o.length;i++)o[i]=arguments[i];t(r,this,e,o)}}e.exports=function first(e,t){if(!Array.isArray(e))throw new TypeError("arg must be an array of [ee, events...] arrays");for(var a=[],o=0;o<e.length;o++){var r=e[o];if(!Array.isArray(r)||r.length<2)throw new TypeError("each array member must be [ee, events...]");for(var i=r[0],n=1;n<r.length;n++){var s=r[n],c=listener(s,callback);i.on(s,c),a.push({ee:i,event:s,fn:c})}}function callback(){cleanup(),t.apply(null,arguments)}function cleanup(){for(var e,t=0;t<a.length;t++)(e=a[t]).ee.removeListener(e.event,e.fn)}function thunk(e){t=e}return thunk.cancel=cleanup,thunk}},14426:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(62586),r={keyword:["then","else"],schemaType:["object","boolean"],code({keyword:e,parentSchema:t,it:a}){void 0===t.if&&o.checkStrictMode(a,`"${e}" without "if" is ignored`)}};t.default=r},14551:(e,t,a)=>{var o=a(76982);e.exports=function nodeRNG(){return o.randomBytes(16)}},14625:(e,t,a)=>{"use strict";const o=a(93360);e.exports=async({cwd:e}={})=>o("package.json",{cwd:e}),e.exports.sync=({cwd:e}={})=>o.sync("package.json",{cwd:e})},14727:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(16928),r=a(54763),i=a(12750),n={store:{},create:e=>{const t=`000000${Math.floor(16777215*Math.random()).toString(16)}`.slice(-6);return`${e}${`.tmp-${Date.now().toString().slice(-10)}${t}`}`},get:(e,t,a=!0)=>{const o=n.truncate(t(e));if(o in n.store)return n.get(e,t,a);n.store[o]=a;return[o,()=>delete n.store[o]]},purge:e=>{n.store[e]&&(delete n.store[e],i.default.unlinkAttempt(e))},purgeSync:e=>{n.store[e]&&(delete n.store[e],i.default.unlinkSyncAttempt(e))},purgeSyncAll:()=>{for(const e in n.store)n.purgeSync(e)},truncate:e=>{const t=o.basename(e);if(t.length<=r.LIMIT_BASENAME_LENGTH)return e;const a=/^(\.?)(.*?)((?:\.[^.]+)?(?:\.tmp-\d{10}[a-f0-9]{6})?)$/.exec(t);if(!a)return e;const i=t.length-r.LIMIT_BASENAME_LENGTH;return`${e.slice(0,-t.length)}${a[1]}${a[2].slice(0,-i)}${a[3]}`}};process.on("exit",n.purgeSyncAll),t.default=n},14803:(e,t,a)=>{"use strict";var o=a(58859),r=a(69675),listGetNode=function(e,t,a){for(var o,r=e;null!=(o=r.next);r=o)if(o.key===t)return r.next=o.next,a||(o.next=e.next,e.next=o),o};e.exports=function getSideChannelList(){var e,t={assert:function(e){if(!t.has(e))throw new r("Side channel does not contain "+o(e))},delete:function(t){var a=e&&e.next,o=function(e,t){if(e)return listGetNode(e,t,!0)}(e,t);return o&&a&&a===o&&(e=void 0),!!o},get:function(t){return function(e,t){if(e){var a=listGetNode(e,t);return a&&a.value}}(e,t)},has:function(t){return function(e,t){return!!e&&!!listGetNode(e,t)}(e,t)},set:function(t,a){e||(e={next:void 0}),function(e,t,a){var o=listGetNode(e,t);o?o.value=a:e.next={key:t,next:e.next,value:a}}(e,t,a)}};return t}},15442:(e,t,a)=>{var o=a(76982);function sha(e,t,a){return o.createHmac(a,e).update(t).digest("base64")}function rfc3986(e){return encodeURIComponent(e).replace(/!/g,"%21").replace(/\*/g,"%2A").replace(/\(/g,"%28").replace(/\)/g,"%29").replace(/'/g,"%27")}function compare(e,t){return e>t?1:e<t?-1:0}function generateBase(e,t,a){var o=function map(e){var t,a,o=[];for(t in e)if(a=e[t],Array.isArray(a))for(var r=0;r<a.length;r++)o.push([t,a[r]]);else if("object"==typeof a)for(var i in a)o.push([t+"["+i+"]",a[i]]);else o.push([t,a]);return o}(a).map(function(e){return[rfc3986(e[0]),rfc3986(e[1]||"")]}).sort(function(e,t){return compare(e[0],t[0])||compare(e[1],t[1])}).map(function(e){return e.join("=")}).join("&");return[rfc3986(e?e.toUpperCase():"GET"),rfc3986(t),rfc3986(o)].join("&")}function hmacsign(e,t,a,o,r){var i=generateBase(e,t,a);return sha([o||"",r||""].map(rfc3986).join("&"),i,"sha1")}function hmacsign256(e,t,a,o,r){var i=generateBase(e,t,a);return sha([o||"",r||""].map(rfc3986).join("&"),i,"sha256")}function rsasign(e,t,a,r,i){return function rsa(e,t){return o.createSign("RSA-SHA1").update(t).sign(e,"base64")}(r||"",generateBase(e,t,a))}function plaintext(e,t){return[e||"",t||""].map(rfc3986).join("&")}t.hmacsign=hmacsign,t.hmacsign256=hmacsign256,t.rsasign=rsasign,t.plaintext=plaintext,t.sign=function sign(e,t,a,o,r,i){var n,s=1;switch(e){case"RSA-SHA1":n=rsasign;break;case"HMAC-SHA1":n=hmacsign;break;case"HMAC-SHA256":n=hmacsign256;break;case"PLAINTEXT":n=plaintext,s=4;break;default:throw new Error("Signature method not supported: "+e)}return n.apply(null,[].slice.call(arguments,s))},t.rfc3986=rfc3986,t.generateBase=generateBase},15457:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(25206),i=a(94227),n=a(62586),s={keyword:"additionalItems",type:"array",schemaType:["boolean","object"],before:"uniqueItems",error:{message:({params:{len:e}})=>o.str`should NOT have more than ${e} items`,params:({params:{len:e}})=>o._`{limit: ${e}}`},code(e){const{gen:t,schema:a,parentSchema:s,data:c,it:p}=e,{items:u}=s;if(!Array.isArray(u))return void n.checkStrictMode(p,'"additionalItems" is ignored when "items" is not an array of schemas');p.items=!0;const l=t.const("len",o._`${c}.length`);if(!1===a)e.setParams({len:u.length}),e.pass(o._`${l} <= ${u.length}`);else if("object"==typeof a&&!i.alwaysValidSchema(p,a)){const a=t.var("valid",o._`${l} <= ${u.length}`);t.if(o.not(a),()=>function validateItems(a){t.forRange("i",u.length,l,i=>{e.subschema({keyword:"additionalItems",dataProp:i,dataPropType:r.Type.Num},a),p.allErrors||t.if(o.not(a),()=>t.break())})}(a)),e.ok(a)}}};t.default=s},15622:(e,t)=>{function objectToString(e){return Object.prototype.toString.call(e)}t.bJ=function isError(e){return"[object Error]"===objectToString(e)||e instanceof Error},Buffer.isBuffer},15649:(e,t,a)=>{"use strict";e.exports=function onFinished(e,t){if(!1!==isFinished(e))return i(t,null,e),e;return function attachListener(e,t){var a=e.__onFinished;a&&a.queue||(a=e.__onFinished=function createListener(e){function listener(t){if(e.__onFinished===listener&&(e.__onFinished=null),listener.queue){var a=listener.queue;listener.queue=null;for(var o=0;o<a.length;o++)a[o](t,e)}}return listener.queue=[],listener}(e),function attachFinishedListener(e,t){var a,o,i=!1;function onFinish(e){a.cancel(),o.cancel(),i=!0,t(e)}function onSocket(t){e.removeListener("socket",onSocket),i||a===o&&(o=r([[t,"error","close"]],onFinish))}if(a=o=r([[e,"end","finish"]],onFinish),e.socket)return void onSocket(e.socket);e.on("socket",onSocket),void 0===e.socket&&function patchAssignSocket(e,t){var a=e.assignSocket;if("function"!=typeof a)return;e.assignSocket=function _assignSocket(e){a.call(this,e),t(e)}}(e,onSocket)}(e,a));a.queue.push(t)}(e,function wrap(e){var t;o.AsyncResource&&(t=new o.AsyncResource(e.name||"bound-anonymous-fn"));if(!t||!t.runInAsyncScope)return e;return t.runInAsyncScope.bind(t,e,null)}(t)),e},e.exports.isFinished=isFinished;var o=function tryRequireAsyncHooks(){try{return a(90290)}catch(e){return{}}}(),r=a(14276),i="function"==typeof setImmediate?setImmediate:function(e){process.nextTick(e.bind.apply(e,arguments))};function isFinished(e){var t=e.socket;return"boolean"==typeof e.finished?Boolean(e.finished||t&&!t.writable):"boolean"==typeof e.complete?Boolean(e.upgrade||!t||!t.readable||e.complete&&!e.readable):void 0}},15765:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.validateUnion=t.validateArray=t.usePattern=t.callValidateCode=t.schemaProperties=t.allSchemaProperties=t.noPropertyInData=t.propertyInData=t.isOwnProperty=t.hasPropFunc=t.reportMissingProp=t.checkMissingProp=t.checkReportMissingProp=void 0;const o=a(99029),r=a(94227),i=a(25206),n=a(42023);function hasPropFunc(e){return e.scopeValue("func",{ref:Object.prototype.hasOwnProperty,code:o._`Object.prototype.hasOwnProperty`})}function isOwnProperty(e,t,a){return o._`${hasPropFunc(e)}.call(${t}, ${a})`}function noPropertyInData(e,t,a,r){const i=o._`${t}${o.getProperty(a)} === undefined`;return r?o.or(i,o.not(isOwnProperty(e,t,a))):i}function allSchemaProperties(e){return e?Object.keys(e).filter(e=>"__proto__"!==e):[]}t.checkReportMissingProp=function checkReportMissingProp(e,t){const{gen:a,data:r,it:i}=e;a.if(noPropertyInData(a,r,t,i.opts.ownProperties),()=>{e.setParams({missingProperty:o._`${t}`},!0),e.error()})},t.checkMissingProp=function checkMissingProp({gen:e,data:t,it:{opts:a}},r,i){return o.or(...r.map(r=>o.and(noPropertyInData(e,t,r,a.ownProperties),o._`${i} = ${r}`)))},t.reportMissingProp=function reportMissingProp(e,t){e.setParams({missingProperty:t},!0),e.error()},t.hasPropFunc=hasPropFunc,t.isOwnProperty=isOwnProperty,t.propertyInData=function propertyInData(e,t,a,r){const i=o._`${t}${o.getProperty(a)} !== undefined`;return r?o._`${i} && ${isOwnProperty(e,t,a)}`:i},t.noPropertyInData=noPropertyInData,t.allSchemaProperties=allSchemaProperties,t.schemaProperties=function schemaProperties(e,t){return allSchemaProperties(t).filter(a=>!r.alwaysValidSchema(e,t[a]))},t.callValidateCode=function callValidateCode({schemaCode:e,data:t,it:{gen:a,topSchemaRef:r,schemaPath:i,errorPath:s},it:c},p,u,l){const m=l?o._`${e}, ${t}, ${r}${i}`:t,f=[[n.default.dataPath,o.strConcat(n.default.dataPath,s)],[n.default.parentData,c.parentData],[n.default.parentDataProperty,c.parentDataProperty],[n.default.rootData,n.default.rootData]];c.opts.dynamicRef&&f.push([n.default.dynamicAnchors,n.default.dynamicAnchors]);const h=o._`${m}, ${a.object(...f)}`;return u!==o.nil?o._`${p}.call(${u}, ${h})`:o._`${p}(${h})`},t.usePattern=function usePattern(e,t){return e.scopeValue("pattern",{key:t,ref:new RegExp(t,"u"),code:o._`new RegExp(${t}, "u")`})},t.validateArray=function validateArray(e){const{gen:t,data:a,keyword:r,it:n}=e,s=t.name("valid");if(n.allErrors){const e=t.let("valid",!0);return validateItems(()=>t.assign(e,!1)),e}return t.var(s,!0),validateItems(()=>t.break()),s;function validateItems(n){const c=t.const("len",o._`${a}.length`);t.forRange("i",0,c,a=>{e.subschema({keyword:r,dataProp:a,dataPropType:i.Type.Num},s),t.if(o.not(s),n)})}},t.validateUnion=function validateUnion(e){const{gen:t,schema:a,keyword:i,it:n}=e;if(!Array.isArray(a))throw new Error("ajv implementation error");if(a.some(e=>r.alwaysValidSchema(n,e))&&!n.opts.unevaluated)return;const s=t.let("valid",!1),c=t.name("_valid");t.block(()=>a.forEach((a,r)=>{const n=e.subschema({keyword:i,schemaProp:r,compositeRule:!0},c);t.assign(s,o._`${s} || ${c}`);e.mergeValidEvaluated(n,c)||t.if(o.not(s))})),e.result(s,()=>e.reset(),()=>e.error(!0))}},15844:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(94227),r={keyword:"allOf",schemaType:"array",code(e){const{gen:t,schema:a,it:r}=e;if(!Array.isArray(a))throw new Error("ajv implementation error");const i=t.name("valid");a.forEach((t,a)=>{if(o.alwaysValidSchema(r,t))return;const n=e.subschema({keyword:"allOf",schemaProp:a},i);e.ok(i),e.mergeEvaluated(n)})}};t.default=r},16034:(e,t,a)=>{"use strict";const o=a(68626),r=new WeakMap,onetime=(e,t={})=>{if("function"!=typeof e)throw new TypeError("Expected a function");let a,i=0;const n=e.displayName||e.name||"<anonymous>",onetime=function(...o){if(r.set(onetime,++i),1===i)a=e.apply(this,o),e=null;else if(!0===t.throw)throw new Error(`Function \`${n}\` can only be called once`);return a};return o(onetime,e),r.set(onetime,i),onetime};e.exports=onetime,e.exports.default=onetime,e.exports.callCount=e=>{if(!r.has(e))throw new Error(`The given function \`${e.name}\` is not wrapped by the \`onetime\` package`);return r.get(e)}},16120:(e,t,a)=>{"use strict";const o=a(90165);class EndError extends Error{constructor(e){super(),this.value=e}}const testElement=(e,t)=>Promise.resolve(e).then(t),finder=e=>Promise.all(e).then(e=>!0===e[1]&&Promise.reject(new EndError(e[0])));e.exports=(e,t,a)=>{a=Object.assign({concurrency:1/0,preserveOrder:!0},a);const r=o(a.concurrency),i=[...e].map(e=>[e,r(testElement,e,t)]),n=o(a.preserveOrder?1:1/0);return Promise.all(i.map(e=>n(finder,e))).then(()=>{}).catch(e=>e instanceof EndError?e.value:Promise.reject(e))}},16260:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseCatchDef=void 0;const o=a(73524);t.parseCatchDef=(e,t)=>(0,o.parseDef)(e.innerType._def,t)},16299:e=>{e.exports={EOC:0,Boolean:1,Integer:2,BitString:3,OctetString:4,Null:5,OID:6,ObjectDescriptor:7,External:8,Real:9,Enumeration:10,PDV:11,Utf8String:12,RelativeOID:13,Sequence:16,Set:17,NumericString:18,PrintableString:19,T61String:20,VideotexString:21,IA5String:22,UTCTime:23,GeneralizedTime:24,GraphicString:25,VisibleString:26,GeneralString:28,UniversalString:29,CharacterString:30,BMPString:31,Constructor:32,Context:128}},16505:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o={keyword:"anyOf",schemaType:"array",trackErrors:!0,code:a(15765).validateUnion,error:{message:"should match some schema in anyOf"}};t.default=o},16549:e=>{"use strict";e.exports={437:"cp437",737:"cp737",775:"cp775",850:"cp850",852:"cp852",855:"cp855",856:"cp856",857:"cp857",858:"cp858",860:"cp860",861:"cp861",862:"cp862",863:"cp863",864:"cp864",865:"cp865",866:"cp866",869:"cp869",874:"windows874",922:"cp922",1046:"cp1046",1124:"cp1124",1125:"cp1125",1129:"cp1129",1133:"cp1133",1161:"cp1161",1162:"cp1162",1163:"cp1163",1250:"windows1250",1251:"windows1251",1252:"windows1252",1253:"windows1253",1254:"windows1254",1255:"windows1255",1256:"windows1256",1257:"windows1257",1258:"windows1258",28591:"iso88591",28592:"iso88592",28593:"iso88593",28594:"iso88594",28595:"iso88595",28596:"iso88596",28597:"iso88597",28598:"iso88598",28599:"iso88599",28600:"iso885910",28601:"iso885911",28603:"iso885913",28604:"iso885914",28605:"iso885915",28606:"iso885916",windows874:{type:"_sbcs",chars:"€����…�����������‘’“”•–—�������� กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"},win874:"windows874",cp874:"windows874",windows1250:{type:"_sbcs",chars:"€�‚�„…†‡�‰Š‹ŚŤŽŹ�‘’“”•–—�™š›śťžź ˇ˘Ł¤Ą¦§¨©Ş«¬­®Ż°±˛ł´µ¶·¸ąş»Ľ˝ľżŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐÖ×ŘŮÚŰÜÝŢßŕáâăäĺćçčéęëěíîďđńňóôőö÷řůúűüýţ˙"},win1250:"windows1250",cp1250:"windows1250",windows1251:{type:"_sbcs",chars:"ЂЃ‚ѓ„…†‡€‰Љ‹ЊЌЋЏђ‘’“”•–—�™љ›њќћџ ЎўЈ¤Ґ¦§Ё©Є«¬­®Ї°±Ііґµ¶·ё№є»јЅѕїАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя"},win1251:"windows1251",cp1251:"windows1251",windows1252:{type:"_sbcs",chars:"€�‚ƒ„…†‡ˆ‰Š‹Œ�Ž��‘’“”•–—˜™š›œ�žŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"},win1252:"windows1252",cp1252:"windows1252",windows1253:{type:"_sbcs",chars:"€�‚ƒ„…†‡�‰�‹�����‘’“”•–—�™�›���� ΅Ά£¤¥¦§¨©�«¬­®―°±²³΄µ¶·ΈΉΊ»Ό½ΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�"},win1253:"windows1253",cp1253:"windows1253",windows1254:{type:"_sbcs",chars:"€�‚ƒ„…†‡ˆ‰Š‹Œ����‘’“”•–—˜™š›œ��Ÿ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕÖ×ØÙÚÛÜİŞßàáâãäåæçèéêëìíîïğñòóôõö÷øùúûüışÿ"},win1254:"windows1254",cp1254:"windows1254",windows1255:{type:"_sbcs",chars:"€�‚ƒ„…†‡ˆ‰�‹�����‘’“”•–—˜™�›���� ¡¢£₪¥¦§¨©×«¬­®¯°±²³´µ¶·¸¹÷»¼½¾¿ְֱֲֳִֵֶַָֹֺֻּֽ־ֿ׀ׁׂ׃װױײ׳״�������אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�"},win1255:"windows1255",cp1255:"windows1255",windows1256:{type:"_sbcs",chars:"€پ‚ƒ„…†‡ˆ‰ٹ‹Œچژڈگ‘’“”•–—ک™ڑ›œ‌‍ں ،¢£¤¥¦§¨©ھ«¬­®¯°±²³´µ¶·¸¹؛»¼½¾؟ہءآأؤإئابةتثجحخدذرزسشصض×طظعغـفقكàلâمنهوçèéêëىيîïًٌٍَôُِ÷ّùْûü‎‏ے"},win1256:"windows1256",cp1256:"windows1256",windows1257:{type:"_sbcs",chars:"€�‚�„…†‡�‰�‹�¨ˇ¸�‘’“”•–—�™�›�¯˛� �¢£¤�¦§Ø©Ŗ«¬­®Æ°±²³´µ¶·ø¹ŗ»¼½¾æĄĮĀĆÄÅĘĒČÉŹĖĢĶĪĻŠŃŅÓŌÕÖ×ŲŁŚŪÜŻŽßąįāćäåęēčéźėģķīļšńņóōõö÷ųłśūüżž˙"},win1257:"windows1257",cp1257:"windows1257",windows1258:{type:"_sbcs",chars:"€�‚ƒ„…†‡ˆ‰�‹Œ����‘’“”•–—˜™�›œ��Ÿ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂĂÄÅÆÇÈÉÊË̀ÍÎÏĐÑ̉ÓÔƠÖ×ØÙÚÛÜỮßàáâăäåæçèéêë́íîïđṇ̃óôơö÷øùúûüư₫ÿ"},win1258:"windows1258",cp1258:"windows1258",iso88591:{type:"_sbcs",chars:" ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"},cp28591:"iso88591",iso88592:{type:"_sbcs",chars:" Ą˘Ł¤ĽŚ§¨ŠŞŤŹ­ŽŻ°ą˛ł´ľśˇ¸šşťź˝žżŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐÖ×ŘŮÚŰÜÝŢßŕáâăäĺćçčéęëěíîďđńňóôőö÷řůúűüýţ˙"},cp28592:"iso88592",iso88593:{type:"_sbcs",chars:" Ħ˘£¤�Ĥ§¨İŞĞĴ­�Ż°ħ²³´µĥ·¸ışğĵ½�żÀÁÂ�ÄĊĈÇÈÉÊËÌÍÎÏ�ÑÒÓÔĠÖ×ĜÙÚÛÜŬŜßàáâ�äċĉçèéêëìíîï�ñòóôġö÷ĝùúûüŭŝ˙"},cp28593:"iso88593",iso88594:{type:"_sbcs",chars:" ĄĸŖ¤ĨĻ§¨ŠĒĢŦ­Ž¯°ą˛ŗ´ĩļˇ¸šēģŧŊžŋĀÁÂÃÄÅÆĮČÉĘËĖÍÎĪĐŅŌĶÔÕÖ×ØŲÚÛÜŨŪßāáâãäåæįčéęëėíîīđņōķôõö÷øųúûüũū˙"},cp28594:"iso88594",iso88595:{type:"_sbcs",chars:" ЁЂЃЄЅІЇЈЉЊЋЌ­ЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя№ёђѓєѕіїјљњћќ§ўџ"},cp28595:"iso88595",iso88596:{type:"_sbcs",chars:" ���¤�������،­�������������؛���؟�ءآأؤإئابةتثجحخدذرزسشصضطظعغ�����ـفقكلمنهوىيًٌٍَُِّْ�������������"},cp28596:"iso88596",iso88597:{type:"_sbcs",chars:" ‘’£€₯¦§¨©ͺ«¬­�―°±²³΄΅Ά·ΈΉΊ»Ό½ΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ�ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώ�"},cp28597:"iso88597",iso88598:{type:"_sbcs",chars:" �¢£¤¥¦§¨©×«¬­®¯°±²³´µ¶·¸¹÷»¼½¾��������������������������������‗אבגדהוזחטיךכלםמןנסעףפץצקרשת��‎‏�"},cp28598:"iso88598",iso88599:{type:"_sbcs",chars:" ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕÖ×ØÙÚÛÜİŞßàáâãäåæçèéêëìíîïğñòóôõö÷øùúûüışÿ"},cp28599:"iso88599",iso885910:{type:"_sbcs",chars:" ĄĒĢĪĨĶ§ĻĐŠŦŽ­ŪŊ°ąēģīĩķ·ļđšŧž―ūŋĀÁÂÃÄÅÆĮČÉĘËĖÍÎÏÐŅŌÓÔÕÖŨØŲÚÛÜÝÞßāáâãäåæįčéęëėíîïðņōóôõöũøųúûüýþĸ"},cp28600:"iso885910",iso885911:{type:"_sbcs",chars:" กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"},cp28601:"iso885911",iso885913:{type:"_sbcs",chars:" ”¢£¤„¦§Ø©Ŗ«¬­®Æ°±²³“µ¶·ø¹ŗ»¼½¾æĄĮĀĆÄÅĘĒČÉŹĖĢĶĪĻŠŃŅÓŌÕÖ×ŲŁŚŪÜŻŽßąįāćäåęēčéźėģķīļšńņóōõö÷ųłśūüżž’"},cp28603:"iso885913",iso885914:{type:"_sbcs",chars:" Ḃḃ£ĊċḊ§Ẁ©ẂḋỲ­®ŸḞḟĠġṀṁ¶ṖẁṗẃṠỳẄẅṡÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏŴÑÒÓÔÕÖṪØÙÚÛÜÝŶßàáâãäåæçèéêëìíîïŵñòóôõöṫøùúûüýŷÿ"},cp28604:"iso885914",iso885915:{type:"_sbcs",chars:" ¡¢£€¥Š§š©ª«¬­®¯°±²³Žµ¶·ž¹º»ŒœŸ¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"},cp28605:"iso885915",iso885916:{type:"_sbcs",chars:" ĄąŁ€„Š§š©Ș«Ź­źŻ°±ČłŽ”¶·žčș»ŒœŸżÀÁÂĂÄĆÆÇÈÉÊËÌÍÎÏĐŃÒÓÔŐÖŚŰÙÚÛÜĘȚßàáâăäćæçèéêëìíîïđńòóôőöśűùúûüęțÿ"},cp28606:"iso885916",cp437:{type:"_sbcs",chars:"ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜ¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ibm437:"cp437",csibm437:"cp437",cp737:{type:"_sbcs",chars:"ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρσςτυφχψ░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀ωάέήϊίόύϋώΆΈΉΊΌΎΏ±≥≤ΪΫ÷≈°∙·√ⁿ²■ "},ibm737:"cp737",csibm737:"cp737",cp775:{type:"_sbcs",chars:"ĆüéāäģåćłēŖŗīŹÄÅÉæÆōöĢ¢ŚśÖÜø£Ø×¤ĀĪóŻżź”¦©®¬½¼Ł«»░▒▓│┤ĄČĘĖ╣║╗╝ĮŠ┐└┴┬├─┼ŲŪ╚╔╩╦╠═╬Žąčęėįšųūž┘┌█▄▌▐▀ÓßŌŃõÕµńĶķĻļņĒŅ’­±“¾¶§÷„°∙·¹³²■ "},ibm775:"cp775",csibm775:"cp775",cp850:{type:"_sbcs",chars:"ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø×ƒáíóúñÑªº¿®¬½¼¡«»░▒▓│┤ÁÂÀ©╣║╗╝¢¥┐└┴┬├─┼ãÃ╚╔╩╦╠═╬¤ðÐÊËÈıÍÎÏ┘┌█▄¦Ì▀ÓßÔÒõÕµþÞÚÛÙýÝ¯´­±‗¾¶§÷¸°¨·¹³²■ "},ibm850:"cp850",csibm850:"cp850",cp852:{type:"_sbcs",chars:"ÇüéâäůćçłëŐőîŹÄĆÉĹĺôöĽľŚśÖÜŤťŁ×čáíóúĄąŽžĘę¬źČş«»░▒▓│┤ÁÂĚŞ╣║╗╝Żż┐└┴┬├─┼Ăă╚╔╩╦╠═╬¤đĐĎËďŇÍÎě┘┌█▄ŢŮ▀ÓßÔŃńňŠšŔÚŕŰýÝţ´­˝˛ˇ˘§÷¸°¨˙űŘř■ "},ibm852:"cp852",csibm852:"cp852",cp855:{type:"_sbcs",chars:"ђЂѓЃёЁєЄѕЅіІїЇјЈљЉњЊћЋќЌўЎџЏюЮъЪаАбБцЦдДеЕфФгГ«»░▒▓│┤хХиИ╣║╗╝йЙ┐└┴┬├─┼кК╚╔╩╦╠═╬¤лЛмМнНоОп┘┌█▄Пя▀ЯрРсСтТуУжЖвВьЬ№­ыЫзЗшШэЭщЩчЧ§■ "},ibm855:"cp855",csibm855:"cp855",cp856:{type:"_sbcs",chars:"אבגדהוזחטיךכלםמןנסעףפץצקרשת�£�×����������®¬½¼�«»░▒▓│┤���©╣║╗╝¢¥┐└┴┬├─┼��╚╔╩╦╠═╬¤���������┘┌█▄¦�▀������µ�������¯´­±‗¾¶§÷¸°¨·¹³²■ "},ibm856:"cp856",csibm856:"cp856",cp857:{type:"_sbcs",chars:"ÇüéâäàåçêëèïîıÄÅÉæÆôöòûùİÖÜø£ØŞşáíóúñÑĞğ¿®¬½¼¡«»░▒▓│┤ÁÂÀ©╣║╗╝¢¥┐└┴┬├─┼ãÃ╚╔╩╦╠═╬¤ºªÊËÈ�ÍÎÏ┘┌█▄¦Ì▀ÓßÔÒõÕµ�×ÚÛÙìÿ¯´­±�¾¶§÷¸°¨·¹³²■ "},ibm857:"cp857",csibm857:"cp857",cp858:{type:"_sbcs",chars:"ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø×ƒáíóúñÑªº¿®¬½¼¡«»░▒▓│┤ÁÂÀ©╣║╗╝¢¥┐└┴┬├─┼ãÃ╚╔╩╦╠═╬¤ðÐÊËÈ€ÍÎÏ┘┌█▄¦Ì▀ÓßÔÒõÕµþÞÚÛÙýÝ¯´­±‗¾¶§÷¸°¨·¹³²■ "},ibm858:"cp858",csibm858:"cp858",cp860:{type:"_sbcs",chars:"ÇüéâãàÁçêÊèÍÔìÃÂÉÀÈôõòÚùÌÕÜ¢£Ù₧ÓáíóúñÑªº¿Ò¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ibm860:"cp860",csibm860:"cp860",cp861:{type:"_sbcs",chars:"ÇüéâäàåçêëèÐðÞÄÅÉæÆôöþûÝýÖÜø£Ø₧ƒáíóúÁÍÓÚ¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ibm861:"cp861",csibm861:"cp861",cp862:{type:"_sbcs",chars:"אבגדהוזחטיךכלםמןנסעףפץצקרשת¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ibm862:"cp862",csibm862:"cp862",cp863:{type:"_sbcs",chars:"ÇüéâÂà¶çêëèïî‗À§ÉÈÊôËÏûù¤ÔÜ¢£ÙÛƒ¦´óú¨¸³¯Î⌐¬½¼¾«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ibm863:"cp863",csibm863:"cp863",cp864:{type:"_sbcs",chars:"\0\b\t\n\v\f\r !\"#$٪&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~°·∙√▒─│┼┤┬├┴┐┌└┘β∞φ±½¼≈«»ﻷﻸ��ﻻﻼ� ­ﺂ£¤ﺄ��ﺎﺏﺕﺙ،ﺝﺡﺥ٠١٢٣٤٥٦٧٨٩ﻑ؛ﺱﺵﺹ؟¢ﺀﺁﺃﺅﻊﺋﺍﺑﺓﺗﺛﺟﺣﺧﺩﺫﺭﺯﺳﺷﺻﺿﻁﻅﻋﻏ¦¬÷×ﻉـﻓﻗﻛﻟﻣﻧﻫﻭﻯﻳﺽﻌﻎﻍﻡﹽّﻥﻩﻬﻰﻲﻐﻕﻵﻶﻝﻙﻱ■�"},ibm864:"cp864",csibm864:"cp864",cp865:{type:"_sbcs",chars:"ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø₧ƒáíóúñÑªº¿⌐¬½¼¡«¤░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ibm865:"cp865",csibm865:"cp865",cp866:{type:"_sbcs",chars:"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёЄєЇїЎў°∙·√№¤■ "},ibm866:"cp866",csibm866:"cp866",cp869:{type:"_sbcs",chars:"������Ά�·¬¦‘’Έ―ΉΊΪΌ��ΎΫ©Ώ²³ά£έήίϊΐόύΑΒΓΔΕΖΗ½ΘΙ«»░▒▓│┤ΚΛΜΝ╣║╗╝ΞΟ┐└┴┬├─┼ΠΡ╚╔╩╦╠═╬ΣΤΥΦΧΨΩαβγ┘┌█▄δε▀ζηθικλμνξοπρσςτ΄­±υφχ§ψ΅°¨ωϋΰώ■ "},ibm869:"cp869",csibm869:"cp869",cp922:{type:"_sbcs",chars:" ¡¢£¤¥¦§¨©ª«¬­®‾°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏŠÑÒÓÔÕÖ×ØÙÚÛÜÝŽßàáâãäåæçèéêëìíîïšñòóôõö÷øùúûüýžÿ"},ibm922:"cp922",csibm922:"cp922",cp1046:{type:"_sbcs",chars:"ﺈ×÷ﹱ■│─┐┌└┘ﹹﹻﹽﹿﹷﺊﻰﻳﻲﻎﻏﻐﻶﻸﻺﻼ ¤ﺋﺑﺗﺛﺟﺣ،­ﺧﺳ٠١٢٣٤٥٦٧٨٩ﺷ؛ﺻﺿﻊ؟ﻋءآأؤإئابةتثجحخدذرزسشصضطﻇعغﻌﺂﺄﺎﻓـفقكلمنهوىيًٌٍَُِّْﻗﻛﻟﻵﻷﻹﻻﻣﻧﻬﻩ�"},ibm1046:"cp1046",csibm1046:"cp1046",cp1124:{type:"_sbcs",chars:" ЁЂҐЄЅІЇЈЉЊЋЌ­ЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя№ёђґєѕіїјљњћќ§ўџ"},ibm1124:"cp1124",csibm1124:"cp1124",cp1125:{type:"_sbcs",chars:"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёҐґЄєІіЇї·√№¤■ "},ibm1125:"cp1125",csibm1125:"cp1125",cp1129:{type:"_sbcs",chars:" ¡¢£¤¥¦§œ©ª«¬­®¯°±²³Ÿµ¶·Œ¹º»¼½¾¿ÀÁÂĂÄÅÆÇÈÉÊË̀ÍÎÏĐÑ̉ÓÔƠÖ×ØÙÚÛÜỮßàáâăäåæçèéêë́íîïđṇ̃óôơö÷øùúûüư₫ÿ"},ibm1129:"cp1129",csibm1129:"cp1129",cp1133:{type:"_sbcs",chars:" ກຂຄງຈສຊຍດຕຖທນບປຜຝພຟມຢຣລວຫອຮ���ຯະາຳິີຶືຸູຼັົຽ���ເແໂໃໄ່້໊໋໌ໍໆ�ໜໝ₭����������������໐໑໒໓໔໕໖໗໘໙��¢¬¦�"},ibm1133:"cp1133",csibm1133:"cp1133",cp1161:{type:"_sbcs",chars:"��������������������������������่กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู้๊๋€฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛¢¬¦ "},ibm1161:"cp1161",csibm1161:"cp1161",cp1162:{type:"_sbcs",chars:"€…‘’“”•–— กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"},ibm1162:"cp1162",csibm1162:"cp1162",cp1163:{type:"_sbcs",chars:" ¡¢£€¥¦§œ©ª«¬­®¯°±²³Ÿµ¶·Œ¹º»¼½¾¿ÀÁÂĂÄÅÆÇÈÉÊË̀ÍÎÏĐÑ̉ÓÔƠÖ×ØÙÚÛÜỮßàáâăäåæçèéêë́íîïđṇ̃óôơö÷øùúûüư₫ÿ"},ibm1163:"cp1163",csibm1163:"cp1163",maccroatian:{type:"_sbcs",chars:"ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®Š™´¨≠ŽØ∞±≤≥∆µ∂∑∏š∫ªºΩžø¿¡¬√ƒ≈Ć«Č… ÀÃÕŒœĐ—“”‘’÷◊�©⁄¤‹›Æ»–·‚„‰ÂćÁčÈÍÎÏÌÓÔđÒÚÛÙıˆ˜¯πË˚¸Êæˇ"},maccyrillic:{type:"_sbcs",chars:"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†°¢£§•¶І®©™Ђђ≠Ѓѓ∞±≤≥іµ∂ЈЄєЇїЉљЊњјЅ¬√ƒ≈∆«»… ЋћЌќѕ–—“”‘’÷„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю¤"},macgreek:{type:"_sbcs",chars:"Ä¹²É³ÖÜ΅àâä΄¨çéèêë£™îï•½‰ôö¦­ùûü†ΓΔΘΛΞΠß®©ΣΪ§≠°·Α±≤≥¥ΒΕΖΗΙΚΜΦΫΨΩάΝ¬ΟΡ≈Τ«»… ΥΧΆΈœ–―“”‘’÷ΉΊΌΎέήίόΏύαβψδεφγηιξκλμνοπώρστθωςχυζϊϋΐΰ�"},maciceland:{type:"_sbcs",chars:"ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûüÝ°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤ÐðÞþý·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"},macroman:{type:"_sbcs",chars:"ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›ﬁﬂ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"},macromania:{type:"_sbcs",chars:"ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ĂŞ∞±≤≥¥µ∂∑∏π∫ªºΩăş¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›Ţţ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"},macthai:{type:"_sbcs",chars:"«»…“”�•‘’� กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู\ufeff​–—฿เแโใไๅๆ็่้๊๋์ํ™๏๐๑๒๓๔๕๖๗๘๙®©����"},macturkish:{type:"_sbcs",chars:"ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸĞğİıŞş‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙ�ˆ˜¯˘˙˚¸˝˛ˇ"},macukraine:{type:"_sbcs",chars:"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ†°Ґ£§•¶І®©™Ђђ≠Ѓѓ∞±≤≥іµґЈЄєЇїЉљЊњјЅ¬√ƒ≈∆«»… ЋћЌќѕ–—“”‘’÷„ЎўЏџ№Ёёяабвгдежзийклмнопрстуфхцчшщъыьэю¤"},koi8r:{type:"_sbcs",chars:"─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥ ⌡°²·÷═║╒ё╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡Ё╢╣╤╥╦╧╨╩╪╫╬©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"},koi8u:{type:"_sbcs",chars:"─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥ ⌡°²·÷═║╒ёє╔ії╗╘╙╚╛ґ╝╞╟╠╡ЁЄ╣ІЇ╦╧╨╩╪Ґ╬©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"},koi8ru:{type:"_sbcs",chars:"─│┌┐└┘├┤┬┴┼▀▄█▌▐░▒▓⌠■∙√≈≤≥ ⌡°²·÷═║╒ёє╔ії╗╘╙╚╛ґў╞╟╠╡ЁЄ╣ІЇ╦╧╨╩╪ҐЎ©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"},koi8t:{type:"_sbcs",chars:"қғ‚Ғ„…†‡�‰ҳ‹ҲҷҶ�Қ‘’“”•–—�™�›�����ӯӮё¤ӣ¦§���«¬­®�°±²Ё�Ӣ¶·�№�»���©юабцдефгхийклмнопярстужвьызшэщчъЮАБЦДЕФГХИЙКЛМНОПЯРСТУЖВЬЫЗШЭЩЧЪ"},armscii8:{type:"_sbcs",chars:" �և։)(»«—.՝,-֊…՜՛՞ԱաԲբԳգԴդԵեԶզԷէԸըԹթԺժԻիԼլԽխԾծԿկՀհՁձՂղՃճՄմՅյՆնՇշՈոՉչՊպՋջՌռՍսՎվՏտՐրՑցՒւՓփՔքՕօՖֆ՚�"},rk1048:{type:"_sbcs",chars:"ЂЃ‚ѓ„…†‡€‰Љ‹ЊҚҺЏђ‘’“”•–—�™љ›њқһџ ҰұӘ¤Ө¦§Ё©Ғ«¬­®Ү°±Ііөµ¶·ё№ғ»әҢңүАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя"},tcvn:{type:"_sbcs",chars:"\0ÚỤỪỬỮ\b\t\n\v\f\rỨỰỲỶỸÝỴ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÀẢÃÁẠẶẬÈẺẼÉẸỆÌỈĨÍỊÒỎÕÓỌỘỜỞỠỚỢÙỦŨ ĂÂÊÔƠƯĐăâêôơưđẶ̀̀̉̃́àảãáạẲằẳẵắẴẮẦẨẪẤỀặầẩẫấậèỂẻẽéẹềểễếệìỉỄẾỒĩíịòỔỏõóọồổỗốộờởỡớợùỖủũúụừửữứựỳỷỹýỵỐ"},georgianacademy:{type:"_sbcs",chars:"‚ƒ„…†‡ˆ‰Š‹Œ‘’“”•–—˜™š›œŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿აბგდევზთიკლმნოპჟრსტუფქღყშჩცძწჭხჯჰჱჲჳჴჵჶçèéêëìíîïðñòóôõö÷øùúûüýþÿ"},georgianps:{type:"_sbcs",chars:"‚ƒ„…†‡ˆ‰Š‹Œ‘’“”•–—˜™š›œŸ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿აბგდევზჱთიკლმნჲოპჟრსტჳუფქღყშჩცძწჭხჴჯჰჵæçèéêëìíîïðñòóôõö÷øùúûüýþÿ"},pt154:{type:"_sbcs",chars:"ҖҒӮғ„…ҶҮҲүҠӢҢҚҺҸҗ‘’“”•–—ҳҷҡӣңқһҹ ЎўЈӨҘҰ§Ё©Ә«¬ӯ®Ҝ°ұІіҙө¶·ё№ә»јҪҫҝАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя"},viscii:{type:"_sbcs",chars:"\0ẲẴẪ\b\t\n\v\f\rỶỸỴ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ẠẮẰẶẤẦẨẬẼẸẾỀỂỄỆỐỒỔỖỘỢỚỜỞỊỎỌỈỦŨỤỲÕắằặấầẩậẽẹếềểễệốồổỗỠƠộờởịỰỨỪỬơớƯÀÁÂÃẢĂẳẵÈÉÊẺÌÍĨỳĐứÒÓÔạỷừửÙÚỹỵÝỡưàáâãảăữẫèéêẻìíĩỉđựòóôõỏọụùúũủýợỮ"},iso646cn:{type:"_sbcs",chars:"\0\b\t\n\v\f\r !\"#¥%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}‾��������������������������������������������������������������������������������������������������������������������������������"},iso646jp:{type:"_sbcs",chars:"\0\b\t\n\v\f\r !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[¥]^_`abcdefghijklmnopqrstuvwxyz{|}‾��������������������������������������������������������������������������������������������������������������������������������"},hproman8:{type:"_sbcs",chars:" ÀÂÈÊËÎÏ´ˋˆ¨˜ÙÛ₤¯Ýý°ÇçÑñ¡¿¤£¥§ƒ¢âêôûáéóúàèòùäëöüÅîØÆåíøæÄìÖÜÉïßÔÁÃãÐðÍÌÓÒÕõŠšÚŸÿÞþ·µ¶¾—¼½ªº«■»±�"},macintosh:{type:"_sbcs",chars:"ÄÅÇÉÑÖÜáàâäãåçéèêëíìîïñóòôöõúùûü†°¢£§•¶ß®©™´¨≠ÆØ∞±≤≥¥µ∂∑∏π∫ªºΩæø¿¡¬√ƒ≈∆«»… ÀÃÕŒœ–—“”‘’÷◊ÿŸ⁄¤‹›ﬁﬂ‡·‚„‰ÂÊÁËÈÍÎÏÌÓÔ�ÒÚÛÙıˆ˜¯˘˙˚¸˝˛ˇ"},ascii:{type:"_sbcs",chars:"��������������������������������������������������������������������������������������������������������������������������������"},tis620:{type:"_sbcs",chars:"���������������������������������กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู����฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛����"}}},16698:e=>{"use strict";e.exports=require("node:async_hooks")},16874:e=>{"use strict";const t=Number.MAX_SAFE_INTEGER||9007199254740991;e.exports={MAX_LENGTH:256,MAX_SAFE_COMPONENT_LENGTH:16,MAX_SAFE_BUILD_LENGTH:250,MAX_SAFE_INTEGER:t,RELEASE_TYPES:["major","premajor","minor","preminor","patch","prepatch","prerelease"],SEMVER_SPEC_VERSION:"2.0.0",FLAG_INCLUDE_PRERELEASE:1,FLAG_LOOSE:2}},16928:e=>{"use strict";e.exports=require("path")},16963:e=>{"use strict";e.exports=function toIdentifier(e){return e.split(" ").map(function(e){return e.slice(0,1).toUpperCase()+e.slice(1)}).join("").replace(/[^ _0-9a-z]/gi,"")}},17013:(e,t,a)=>{"use strict";var o=a(24434).EventEmitter,r=a(79896).ReadStream,i=a(2203),n=a(43106);function noop(){}function onDrainClearBinding(){this._binding.clear()}function onOpenClose(){"number"==typeof this.fd&&this.close()}e.exports=function destroy(e,t){!function isFsReadStream(e){return e instanceof r}(e)?!function isZlibStream(e){return e instanceof n.Gzip||e instanceof n.Gunzip||e instanceof n.Deflate||e instanceof n.DeflateRaw||e instanceof n.Inflate||e instanceof n.InflateRaw||e instanceof n.Unzip}(e)?function hasDestroy(e){return e instanceof i&&"function"==typeof e.destroy}(e)&&e.destroy():function destroyZlibStream(e){"function"==typeof e.destroy?e._binding?(e.destroy(),e._processing?(e._needDrain=!0,e.once("drain",onDrainClearBinding)):e._binding.clear()):e._destroy&&e._destroy!==i.Transform.prototype._destroy?e.destroy():e._destroy&&"function"==typeof e.close?(e.destroyed=!0,e.close()):e.destroy():"function"==typeof e.close&&function closeZlibStream(e){if(!0===e._hadError){var t=null===e._binding?"_binding":"_handle";e[t]={close:function(){this[t]=null}}}e.close()}(e)}(e):function destroyReadStream(e){e.destroy(),"function"==typeof e.close&&e.on("open",onOpenClose)}(e);(function isEventEmitter(e){return e instanceof o})(e)&&t&&(e.removeAllListeners("error"),e.addListener("error",noop));return e}},17662:e=>{"use strict";e.exports=JSON.parse('{"100":"Continue","101":"Switching Protocols","102":"Processing","103":"Early Hints","200":"OK","201":"Created","202":"Accepted","203":"Non-Authoritative Information","204":"No Content","205":"Reset Content","206":"Partial Content","207":"Multi-Status","208":"Already Reported","226":"IM Used","300":"Multiple Choices","301":"Moved Permanently","302":"Found","303":"See Other","304":"Not Modified","305":"Use Proxy","307":"Temporary Redirect","308":"Permanent Redirect","400":"Bad Request","401":"Unauthorized","402":"Payment Required","403":"Forbidden","404":"Not Found","405":"Method Not Allowed","406":"Not Acceptable","407":"Proxy Authentication Required","408":"Request Timeout","409":"Conflict","410":"Gone","411":"Length Required","412":"Precondition Failed","413":"Payload Too Large","414":"URI Too Long","415":"Unsupported Media Type","416":"Range Not Satisfiable","417":"Expectation Failed","418":"I\'m a Teapot","421":"Misdirected Request","422":"Unprocessable Entity","423":"Locked","424":"Failed Dependency","425":"Too Early","426":"Upgrade Required","428":"Precondition Required","429":"Too Many Requests","431":"Request Header Fields Too Large","451":"Unavailable For Legal Reasons","500":"Internal Server Error","501":"Not Implemented","502":"Bad Gateway","503":"Service Unavailable","504":"Gateway Timeout","505":"HTTP Version Not Supported","506":"Variant Also Negotiates","507":"Insufficient Storage","508":"Loop Detected","509":"Bandwidth Limit Exceeded","510":"Not Extended","511":"Network Authentication Required"}')},17680:(e,t,a)=>{"use strict";const o=a(35334),r=a(23832),i=a(9400),n=a(17983);"<((!\\[CDATA\\[([\\s\\S]*?)(]]>))|((NAME:)?(NAME))([^>]*)>|((\\/)(NAME)\\s*>))([^<]*)".replace(/NAME/g,o.nameRegexp);function addExternalEntities(e){const t=Object.keys(e);for(let a=0;a<t.length;a++){const o=t[a];this.lastEntities[o]={regex:new RegExp("&"+o+";","g"),val:e[o]}}}function parseTextData(e,t,a,o,r,i,n){if(void 0!==e&&(this.options.trimValues&&!o&&(e=e.trim()),e.length>0)){n||(e=this.replaceEntitiesValue(e));const o=this.options.tagValueProcessor(t,e,a,r,i);if(null==o)return e;if(typeof o!=typeof e||o!==e)return o;if(this.options.trimValues)return parseValue(e,this.options.parseTagValue,this.options.numberParseOptions);return e.trim()===e?parseValue(e,this.options.parseTagValue,this.options.numberParseOptions):e}}function resolveNameSpace(e){if(this.options.removeNSPrefix){const t=e.split(":"),a="/"===e.charAt(0)?"/":"";if("xmlns"===t[0])return"";2===t.length&&(e=a+t[1])}return e}const s=new RegExp("([^\\s=]+)\\s*(=\\s*(['\"])([\\s\\S]*?)\\3)?","gm");function buildAttributesMap(e,t,a){if(!this.options.ignoreAttributes&&"string"==typeof e){const a=o.getAllMatches(e,s),r=a.length,i={};for(let e=0;e<r;e++){const o=this.resolveNameSpace(a[e][1]);let r=a[e][4],n=this.options.attributeNamePrefix+o;if(o.length)if(this.options.transformAttributeName&&(n=this.options.transformAttributeName(n)),"__proto__"===n&&(n="#__proto__"),void 0!==r){this.options.trimValues&&(r=r.trim()),r=this.replaceEntitiesValue(r);const e=this.options.attributeValueProcessor(o,r,t);i[n]=null==e?r:typeof e!=typeof r||e!==r?e:parseValue(r,this.options.parseAttributeValue,this.options.numberParseOptions)}else this.options.allowBooleanAttributes&&(i[n]=!0)}if(!Object.keys(i).length)return;if(this.options.attributesGroupName){const e={};return e[this.options.attributesGroupName]=i,e}return i}}const parseXml=function(e){e=e.replace(/\r\n?/g,"\n");const t=new r("!xml");let a=t,o="",n="";for(let s=0;s<e.length;s++){if("<"===e[s])if("/"===e[s+1]){const t=findClosingIndex(e,">",s,"Closing Tag is not closed.");let r=e.substring(s+2,t).trim();if(this.options.removeNSPrefix){const e=r.indexOf(":");-1!==e&&(r=r.substr(e+1))}this.options.transformTagName&&(r=this.options.transformTagName(r)),a&&(o=this.saveTextToParentTag(o,a,n));const i=n.substring(n.lastIndexOf(".")+1);if(r&&-1!==this.options.unpairedTags.indexOf(r))throw new Error(`Unpaired tag can not be used as closing tag: </${r}>`);let c=0;i&&-1!==this.options.unpairedTags.indexOf(i)?(c=n.lastIndexOf(".",n.lastIndexOf(".")-1),this.tagsNodeStack.pop()):c=n.lastIndexOf("."),n=n.substring(0,c),a=this.tagsNodeStack.pop(),o="",s=t}else if("?"===e[s+1]){let t=readTagExp(e,s,!1,"?>");if(!t)throw new Error("Pi Tag is not closed.");if(o=this.saveTextToParentTag(o,a,n),this.options.ignoreDeclaration&&"?xml"===t.tagName||this.options.ignorePiTags);else{const e=new r(t.tagName);e.add(this.options.textNodeName,""),t.tagName!==t.tagExp&&t.attrExpPresent&&(e[":@"]=this.buildAttributesMap(t.tagExp,n,t.tagName)),this.addChild(a,e,n)}s=t.closeIndex+1}else if("!--"===e.substr(s+1,3)){const t=findClosingIndex(e,"--\x3e",s+4,"Comment is not closed.");if(this.options.commentPropName){const r=e.substring(s+4,t-2);o=this.saveTextToParentTag(o,a,n),a.add(this.options.commentPropName,[{[this.options.textNodeName]:r}])}s=t}else if("!D"===e.substr(s+1,2)){const t=i(e,s);this.docTypeEntities=t.entities,s=t.i}else if("!["===e.substr(s+1,2)){const t=findClosingIndex(e,"]]>",s,"CDATA is not closed.")-2,r=e.substring(s+9,t);if(o=this.saveTextToParentTag(o,a,n),this.options.cdataPropName)a.add(this.options.cdataPropName,[{[this.options.textNodeName]:r}]);else{let e=this.parseTextData(r,a.tagname,n,!0,!1,!0);null==e&&(e=""),a.add(this.options.textNodeName,e)}s=t+2}else{let i=readTagExp(e,s,this.options.removeNSPrefix),c=i.tagName,p=i.tagExp,u=i.attrExpPresent,l=i.closeIndex;this.options.transformTagName&&(c=this.options.transformTagName(c)),a&&o&&"!xml"!==a.tagname&&(o=this.saveTextToParentTag(o,a,n,!1));const m=a;if(m&&-1!==this.options.unpairedTags.indexOf(m.tagname)&&(a=this.tagsNodeStack.pop(),n=n.substring(0,n.lastIndexOf("."))),c!==t.tagname&&(n+=n?"."+c:c),this.isItStopNode(this.options.stopNodes,n,c)){let t="";if(p.length>0&&p.lastIndexOf("/")===p.length-1)s=i.closeIndex;else if(-1!==this.options.unpairedTags.indexOf(c))s=i.closeIndex;else{const a=this.readStopNodeData(e,c,l+1);if(!a)throw new Error(`Unexpected end of ${c}`);s=a.i,t=a.tagContent}const o=new r(c);c!==p&&u&&(o[":@"]=this.buildAttributesMap(p,n,c)),t&&(t=this.parseTextData(t,c,n,!0,u,!0,!0)),n=n.substr(0,n.lastIndexOf(".")),o.add(this.options.textNodeName,t),this.addChild(a,o,n)}else{if(p.length>0&&p.lastIndexOf("/")===p.length-1){"/"===c[c.length-1]?(c=c.substr(0,c.length-1),p=c):p=p.substr(0,p.length-1),this.options.transformTagName&&(c=this.options.transformTagName(c));const e=new r(c);c!==p&&u&&(e[":@"]=this.buildAttributesMap(p,n,c)),this.addChild(a,e,n),n=n.substr(0,n.lastIndexOf("."))}else{const e=new r(c);this.tagsNodeStack.push(a),c!==p&&u&&(e[":@"]=this.buildAttributesMap(p,n,c)),this.addChild(a,e,n),a=e}o="",s=l}}else o+=e[s]}return t.child};function addChild(e,t,a){const o=this.options.updateTag(t.tagname,a,t[":@"]);!1===o||("string"==typeof o?(t.tagname=o,e.addChild(t)):e.addChild(t))}const replaceEntitiesValue=function(e){if(this.options.processEntities){for(let t in this.docTypeEntities){const a=this.docTypeEntities[t];e=e.replace(a.regx,a.val)}for(let t in this.lastEntities){const a=this.lastEntities[t];e=e.replace(a.regex,a.val)}if(this.options.htmlEntities)for(let t in this.htmlEntities){const a=this.htmlEntities[t];e=e.replace(a.regex,a.val)}e=e.replace(this.ampEntity.regex,this.ampEntity.val)}return e};function saveTextToParentTag(e,t,a,o){return e&&(void 0===o&&(o=0===Object.keys(t.child).length),void 0!==(e=this.parseTextData(e,t.tagname,a,!1,!!t[":@"]&&0!==Object.keys(t[":@"]).length,o))&&""!==e&&t.add(this.options.textNodeName,e),e=""),e}function isItStopNode(e,t,a){const o="*."+a;for(const a in e){const r=e[a];if(o===r||t===r)return!0}return!1}function findClosingIndex(e,t,a,o){const r=e.indexOf(t,a);if(-1===r)throw new Error(o);return r+t.length-1}function readTagExp(e,t,a,o=">"){const r=function tagExpWithClosingIndex(e,t,a=">"){let o,r="";for(let i=t;i<e.length;i++){let t=e[i];if(o)t===o&&(o="");else if('"'===t||"'"===t)o=t;else if(t===a[0]){if(!a[1])return{data:r,index:i};if(e[i+1]===a[1])return{data:r,index:i}}else"\t"===t&&(t=" ");r+=t}}(e,t+1,o);if(!r)return;let i=r.data;const n=r.index,s=i.search(/\s/);let c=i,p=!0;if(-1!==s&&(c=i.substr(0,s).replace(/\s\s*$/,""),i=i.substr(s+1)),a){const e=c.indexOf(":");-1!==e&&(c=c.substr(e+1),p=c!==r.data.substr(e+1))}return{tagName:c,tagExp:i,closeIndex:n,attrExpPresent:p}}function readStopNodeData(e,t,a){const o=a;let r=1;for(;a<e.length;a++)if("<"===e[a])if("/"===e[a+1]){const i=findClosingIndex(e,">",a,`${t} is not closed`);if(e.substring(a+2,i).trim()===t&&(r--,0===r))return{tagContent:e.substring(o,a),i};a=i}else if("?"===e[a+1]){a=findClosingIndex(e,"?>",a+1,"StopNode is not closed.")}else if("!--"===e.substr(a+1,3)){a=findClosingIndex(e,"--\x3e",a+3,"StopNode is not closed.")}else if("!["===e.substr(a+1,2)){a=findClosingIndex(e,"]]>",a,"StopNode is not closed.")-2}else{const o=readTagExp(e,a,">");if(o){(o&&o.tagName)===t&&"/"!==o.tagExp[o.tagExp.length-1]&&r++,a=o.closeIndex}}}function parseValue(e,t,a){if(t&&"string"==typeof e){const t=e.trim();return"true"===t||"false"!==t&&n(e,a)}return o.isExist(e)?e:""}e.exports=class OrderedObjParser{constructor(e){this.options=e,this.currentNode=null,this.tagsNodeStack=[],this.docTypeEntities={},this.lastEntities={apos:{regex:/&(apos|#39|#x27);/g,val:"'"},gt:{regex:/&(gt|#62|#x3E);/g,val:">"},lt:{regex:/&(lt|#60|#x3C);/g,val:"<"},quot:{regex:/&(quot|#34|#x22);/g,val:'"'}},this.ampEntity={regex:/&(amp|#38|#x26);/g,val:"&"},this.htmlEntities={space:{regex:/&(nbsp|#160);/g,val:" "},cent:{regex:/&(cent|#162);/g,val:"¢"},pound:{regex:/&(pound|#163);/g,val:"£"},yen:{regex:/&(yen|#165);/g,val:"¥"},euro:{regex:/&(euro|#8364);/g,val:"€"},copyright:{regex:/&(copy|#169);/g,val:"©"},reg:{regex:/&(reg|#174);/g,val:"®"},inr:{regex:/&(inr|#8377);/g,val:"₹"}},this.addExternalEntities=addExternalEntities,this.parseXml=parseXml,this.parseTextData=parseTextData,this.resolveNameSpace=resolveNameSpace,this.buildAttributesMap=buildAttributesMap,this.isItStopNode=isItStopNode,this.replaceEntitiesValue=replaceEntitiesValue,this.readStopNodeData=readStopNodeData,this.saveTextToParentTag=saveTextToParentTag,this.addChild=addChild}}},17833:(e,t,a)=>{t.formatArgs=function formatArgs(t){if(t[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+t[0]+(this.useColors?"%c ":" ")+"+"+e.exports.humanize(this.diff),!this.useColors)return;const a="color: "+this.color;t.splice(1,0,a,"color: inherit");let o=0,r=0;t[0].replace(/%[a-zA-Z%]/g,e=>{"%%"!==e&&(o++,"%c"===e&&(r=o))}),t.splice(r,0,a)},t.save=function save(e){try{e?t.storage.setItem("debug",e):t.storage.removeItem("debug")}catch(e){}},t.load=function load(){let e;try{e=t.storage.getItem("debug")||t.storage.getItem("DEBUG")}catch(e){}!e&&"undefined"!=typeof process&&"env"in process&&(e=process.env.DEBUG);return e},t.useColors=function useColors(){if("undefined"!=typeof window&&window.process&&("renderer"===window.process.type||window.process.__nwjs))return!0;if("undefined"!=typeof navigator&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/))return!1;let e;return"undefined"!=typeof document&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||"undefined"!=typeof window&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||"undefined"!=typeof navigator&&navigator.userAgent&&(e=navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/))&&parseInt(e[1],10)>=31||"undefined"!=typeof navigator&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)},t.storage=function localstorage(){try{return localStorage}catch(e){}}(),t.destroy=(()=>{let e=!1;return()=>{e||(e=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})(),t.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"],t.log=console.debug||console.log||(()=>{}),e.exports=a(40736)(t);const{formatters:o}=e.exports;o.j=function(e){try{return JSON.stringify(e)}catch(e){return"[UnexpectedJSONParseError]: "+e.message}}},17961:(e,t,a)=>{"use strict";var o=a(6176),r=a(90342),i=a(40193),n=a(13749),s=a(91116),c=a(38710),p={AppId:"",SecretId:"",SecretKey:"",SecurityToken:"",ChunkRetryTimes:2,FileParallelLimit:3,ChunkParallelLimit:3,ChunkSize:1048576,SliceSize:1048576,CopyChunkParallelLimit:20,CopyChunkSize:10485760,CopySliceSize:10485760,MaxPartNumber:1e4,ProgressInterval:1e3,Domain:"",ServiceDomain:"",Protocol:"",CompatibilityMode:!1,ForcePathStyle:!1,UseRawKey:!1,Timeout:0,CorrectClockSkew:!0,SystemClockOffset:0,UploadCheckContentMd5:!1,UploadQueueSize:1e3,UploadIdCacheLimit:500,Proxy:"",Tunnel:void 0,Ip:"",StrictSsl:!0,KeepAlive:!0,FollowRedirect:!1,UseAccelerate:!1,UserAgent:"",ConfCwd:"",ForceSignHost:!0,AutoSwitchHost:!0,CopySourceParser:null,ObjectKeySimplifyCheck:!0,Credentials:{secretId:"",secretKey:""}};const watch=(e,t,a)=>{let o=e[t];Object.defineProperty(e,t,{get:()=>o,set(e){o=e,a()}})};var COS=function(e){if(this.options=o.extend(o.clone(p),e||{}),this.options.FileParallelLimit=Math.max(1,this.options.FileParallelLimit),this.options.ChunkParallelLimit=Math.max(1,this.options.ChunkParallelLimit),this.options.ChunkRetryTimes=Math.max(0,this.options.ChunkRetryTimes),this.options.ChunkSize=Math.max(1048576,this.options.ChunkSize),this.options.CopyChunkParallelLimit=Math.max(1,this.options.CopyChunkParallelLimit),this.options.CopyChunkSize=Math.max(1048576,this.options.CopyChunkSize),this.options.CopySliceSize=Math.max(0,this.options.CopySliceSize),this.options.MaxPartNumber=Math.max(1024,Math.min(1e4,this.options.MaxPartNumber)),this.options.Timeout=Math.max(0,this.options.Timeout),this.options.AppId&&console.warn('warning: AppId has been deprecated, Please put it at the end of parameter Bucket(E.g: "test-1250000000").'),(this.options.secretId||this.options.secretKey)&&(this.options.secretId&&!this.options.SecretId&&(this.options.SecretId=this.options.secretId),this.options.secretKey&&!this.options.SecretKey&&(this.options.SecretKey=this.options.secretKey),console.warn("warning: Please change options secretId/secretKey to SecretId/SecretKey.")),this.options.Credentials.secretId&&this.options.Credentials.secretKey&&(this.options.SecretId=this.options.Credentials.secretId||"",this.options.SecretKey=this.options.Credentials.secretKey||""),this.options.SecretId&&this.options.SecretId.indexOf(" ")>-1&&(console.error("error: SecretId格式错误，请检查"),console.error("error: SecretId format is incorrect. Please check")),this.options.SecretKey&&this.options.SecretKey.indexOf(" ")>-1&&(console.error("error: SecretKey格式错误，请检查"),console.error("error: SecretKey format is incorrect. Please check")),o.isWeb()&&(console.log("Tip: 使用 electron 等跨平台技术可正常使用Nodejs SDK，请忽略下方浏览器环境警告"),console.warn("warning: cos-nodejs-sdk-v5 不支持浏览器使用，请改用 cos-js-sdk-v5，参考文档： https://cloud.tencent.com/document/product/436/11459"),console.warn("warning: cos-nodejs-sdk-v5 does not support browsers. Please use cos-js-sdk-v5 instead, See: https://cloud.tencent.com/document/product/436/11459")),this.options.ForcePathStyle)throw console.warn("cos-nodejs-sdk-v5不再支持使用path-style，仅支持使用virtual-hosted-style，参考文档：https://cloud.tencent.com/document/product/436/96243"),new Error("ForcePathStyle is not supported");r.init(this),i.init(this),watch(this.options.Credentials,"secretId",()=>{console.log("Credentials secretId changed"),this.options.SecretId=this.options.Credentials.secretId}),watch(this.options.Credentials,"secretKey",()=>{console.log("Credentials secretKey changed"),this.options.SecretKey=this.options.Credentials.secretKey})};n.init(COS,i),s.init(COS,i),COS.util={md5:o.md5,xml2json:o.xml2json,json2xml:o.json2xml,encodeBase64:o.encodeBase64},COS.getAuthorization=o.getAuth,COS.version=c.version,e.exports=COS},17983:e=>{const t=/^[-+]?0x[a-fA-F0-9]+$/,a=/^([\-\+])?(0*)([0-9]*(\.[0-9]*)?)$/,o={hex:!0,leadingZeros:!0,decimalPoint:".",eNotation:!0};e.exports=function toNumber(e,r={}){if(r=Object.assign({},o,r),!e||"string"!=typeof e)return e;let i=e.trim();if(void 0!==r.skipLike&&r.skipLike.test(i))return e;if("0"===e)return 0;if(r.hex&&t.test(i))return function parse_int(e,t){if(parseInt)return parseInt(e,t);if(Number.parseInt)return Number.parseInt(e,t);if(window&&window.parseInt)return window.parseInt(e,t);throw new Error("parseInt, Number.parseInt, window.parseInt are not supported")}(i,16);if(-1!==i.search(/[eE]/)){const t=i.match(/^([-\+])?(0*)([0-9]*(\.[0-9]*)?[eE][-\+]?[0-9]+)$/);if(t){if(r.leadingZeros)i=(t[1]||"")+t[3];else if("0"!==t[2]||"."!==t[3][0])return e;return r.eNotation?Number(i):e}return e}{const t=a.exec(i);if(t){const a=t[1],o=t[2];let n=function trimZeros(e){if(e&&-1!==e.indexOf("."))return"."===(e=e.replace(/0+$/,""))?e="0":"."===e[0]?e="0"+e:"."===e[e.length-1]&&(e=e.substr(0,e.length-1)),e;return e}(t[3]);if(!r.leadingZeros&&o.length>0&&a&&"."!==i[2])return e;if(!r.leadingZeros&&o.length>0&&!a&&"."!==i[1])return e;if(r.leadingZeros&&o===e)return 0;{const t=Number(i),s=""+t;return-1!==s.search(/[eE]/)?r.eNotation?t:e:-1!==i.indexOf(".")?"0"===s&&""===n||s===n||a&&s==="-"+n?t:e:o?n===s||a+n===s?t:e:i===s||i===a+s?t:e}}return e}}},18064:(e,t,a)=>{e.exports={read:function read(e,t){n.isBuffer(e)&&(e=e.toString("ascii"));var a=e.trim().split(/[ \t\n]+/g);if(a.length<2||a.length>3)throw new Error("Not a valid SSH certificate line");var o=a[0],r=a[1];return fromBuffer(r=n.from(r,"base64"),o)},verify:function verify(e,t){return!1},sign:function sign(e,t){void 0===e.signatures.openssh&&(e.signatures.openssh={});try{var a=toBuffer(e,!0)}catch(t){return delete e.signatures.openssh,!1}var o=e.signatures.openssh,r=void 0;"rsa"!==t.type&&"dsa"!==t.type||(r="sha1");var i=t.createSign(r);return i.write(a),o.signature=i.sign(),!0},signAsync:function signAsync(e,t,a){void 0===e.signatures.openssh&&(e.signatures.openssh={});try{var o=toBuffer(e,!0)}catch(t){return delete e.signatures.openssh,void a(t)}var r=e.signatures.openssh;t(o,function(e,t){if(e)a(e);else{try{t.toBuffer("ssh")}catch(e){return void a(e)}r.signature=t,a()}})},write:function write(e,t){void 0===t&&(t={});var a=toBuffer(e),o=getCertType(e.subjectKey)+" "+a.toString("base64");t.comment&&(o=o+" "+t.comment);return o},fromBuffer,toBuffer};var o=a(94742),r=a(46309),i=a(76982),n=a(54774).Buffer,s=a(6641),c=a(64479),p=(a(90009),a(45020)),u=a(34348),l=a(57114),m=a(87461),f=a(58219);var h={user:1,host:2};Object.keys(h).forEach(function(e){h[h[e]]=e});var g=/^ecdsa-sha2-([^@-]+)-cert-v01@openssh.com$/;function fromBuffer(e,t,a){var i=new r({buffer:e}),n=i.readString();if(void 0!==t&&n!==t)throw new Error("SSH certificate algorithm mismatch");void 0===t&&(t=n);var y={signatures:{}};y.signatures.openssh={},y.signatures.openssh.nonce=i.readBuffer();var b={},x=b.parts=[];b.type=function getAlg(e){if("ssh-rsa-cert-v01@openssh.com"===e)return"rsa";if("ssh-dss-cert-v01@openssh.com"===e)return"dsa";if(e.match(g))return"ecdsa";if("ssh-ed25519-cert-v01@openssh.com"===e)return"ed25519";throw new Error("Unsupported cert type "+e)}(t);for(var w=s.info[b.type].parts.length;x.length<w;)x.push(i.readPart());o.ok(x.length>=1,"key must have at least one part");var k=s.info[b.type];if("ecdsa"===b.type){var j=g.exec(t);o.ok(null!==j),o.strictEqual(j[1],x[0].data.toString())}for(var C=0;C<k.parts.length;++C)if(x[C].name=k.parts[C],"curve"!==x[C].name&&!1!==k.normalize){var P=x[C];P.data=m.mpNormalize(P.data)}y.subjectKey=new c(b),y.serial=i.readInt64();var O=h[i.readInt()];o.string(O,"valid cert type"),y.signatures.openssh.keyId=i.readString();for(var I=[],z=i.readBuffer(),q=new r({buffer:z});!q.atEnd();)I.push(q.readString());0===I.length&&(I=["*"]),y.subjects=I.map(function(e){if("user"===O)return p.forUser(e);if("host"===O)return p.forHost(e);throw new Error("Unknown identity type "+O)}),y.validFrom=int64ToDate(i.readInt64()),y.validUntil=int64ToDate(i.readInt64());for(var $,H=[],V=new r({buffer:i.readBuffer()});!V.atEnd();)($={critical:!0}).name=V.readString(),$.data=V.readBuffer(),H.push($);for(V=new r({buffer:i.readBuffer()});!V.atEnd();)($={critical:!1}).name=V.readString(),$.data=V.readBuffer(),H.push($);y.signatures.openssh.exts=H,i.readBuffer();var G=i.readBuffer();y.issuerKey=u.read(G),y.issuer=p.forHost("**");var W=i.readBuffer();return y.signatures.openssh.signature=l.parse(W,y.issuerKey.type,"ssh"),void 0!==a&&(a.remainder=i.remainder(),a.consumed=i._offset),new f(y)}function int64ToDate(e){var t=4294967296*e.readUInt32BE(0);t+=e.readUInt32BE(4);var a=new Date;return a.setTime(1e3*t),a.sourceInt64=e,a}function dateToInt64(e){if(void 0!==e.sourceInt64)return e.sourceInt64;var t=Math.round(e.getTime()/1e3),a=Math.floor(t/4294967296),o=Math.floor(t%4294967296),r=n.alloc(8);return r.writeUInt32BE(a,0),r.writeUInt32BE(o,4),r}function toBuffer(e,t){o.object(e.signatures.openssh,"signature for openssh format");var a=e.signatures.openssh;void 0===a.nonce&&(a.nonce=i.randomBytes(16));var c=new r({});c.writeString(getCertType(e.subjectKey)),c.writeBuffer(a.nonce);var p=e.subjectKey;s.info[p.type].parts.forEach(function(e){c.writePart(p.part[e])}),c.writeInt64(e.serial);var l=e.subjects[0].type;o.notStrictEqual(l,"unknown"),e.subjects.forEach(function(e){o.strictEqual(e.type,l)}),l=h[l],c.writeInt(l),void 0===a.keyId&&(a.keyId=e.subjects[0].type+"_"+(e.subjects[0].uid||e.subjects[0].hostname)),c.writeString(a.keyId);var m=new r({});e.subjects.forEach(function(e){l===h.host?m.writeString(e.hostname):l===h.user&&m.writeString(e.uid)}),c.writeBuffer(m.toBuffer()),c.writeInt64(dateToInt64(e.validFrom)),c.writeInt64(dateToInt64(e.validUntil));var f=a.exts;void 0===f&&(f=[]);var g=new r({});return f.forEach(function(e){!0===e.critical&&(g.writeString(e.name),g.writeBuffer(e.data))}),c.writeBuffer(g.toBuffer()),g=new r({}),f.forEach(function(e){!0!==e.critical&&(g.writeString(e.name),g.writeBuffer(e.data))}),c.writeBuffer(g.toBuffer()),c.writeBuffer(n.alloc(0)),m=u.write(e.issuerKey),c.writeBuffer(m),t||c.writeBuffer(a.signature.toBuffer("ssh")),c.toBuffer()}function getCertType(e){if("rsa"===e.type)return"ssh-rsa-cert-v01@openssh.com";if("dsa"===e.type)return"ssh-dss-cert-v01@openssh.com";if("ecdsa"===e.type)return"ecdsa-sha2-"+e.curve+"-cert-v01@openssh.com";if("ed25519"===e.type)return"ssh-ed25519-cert-v01@openssh.com";throw new Error("Unsupported key type "+e.type)}},18568:(e,t,a)=>{"use strict";var o=a(80112),r=a(34610),i=a(80613),n=a(72492),s=a(84247),c=r.ucs2length,p=a(32017),u=i.Validation;function checkCompiling(e,t,a){var o=compIndex.call(this,e,t,a);return o>=0?{index:o,compiling:!0}:(o=this._compilations.length,this._compilations[o]={schema:e,root:t,baseId:a},{index:o,compiling:!1})}function endCompiling(e,t,a){var o=compIndex.call(this,e,t,a);o>=0&&this._compilations.splice(o,1)}function compIndex(e,t,a){for(var o=0;o<this._compilations.length;o++){var r=this._compilations[o];if(r.schema==e&&r.root==t&&r.baseId==a)return o}return-1}function patternCode(e,t){return"var pattern"+e+" = new RegExp("+r.toQuotedString(t[e])+");"}function defaultCode(e){return"var default"+e+" = defaults["+e+"];"}function refValCode(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function customRuleCode(e){return"var customRule"+e+" = customRules["+e+"];"}function vars(e,t){if(!e.length)return"";for(var a="",o=0;o<e.length;o++)a+=t(o,e);return a}e.exports=function compile(e,t,a,l){var m=this,f=this._opts,h=[void 0],g={},y=[],b={},x=[],w={},k=[];t=t||{schema:e,refVal:h,refs:g};var j=checkCompiling.call(this,e,t,l),C=this._compilations[j.index];if(j.compiling)return C.callValidate=function callValidate(){var e=C.validate,t=e.apply(this,arguments);return callValidate.errors=e.errors,t};var P=this._formats,O=this.RULES;try{var I=localCompile(e,t,a,l);C.validate=I;var z=C.callValidate;return z&&(z.schema=I.schema,z.errors=null,z.refs=I.refs,z.refVal=I.refVal,z.root=I.root,z.$async=I.$async,f.sourceCode&&(z.source=I.source)),I}finally{endCompiling.call(this,e,t,l)}function localCompile(e,a,n,l){var b=!a||a&&a.schema==e;if(a.schema!=t.schema)return compile.call(m,e,a,n,l);var w,j=!0===e.$async,C=s({isTop:!0,schema:e,isRoot:b,baseId:l,root:a,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:i.MissingRef,RULES:O,validate:s,util:r,resolve:o,resolveRef,usePattern,useDefault,useCustomRule,opts:f,formats:P,logger:m.logger,self:m});C=vars(h,refValCode)+vars(y,patternCode)+vars(x,defaultCode)+vars(k,customRuleCode)+C,f.processCode&&(C=f.processCode(C,e));try{w=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",C)(m,O,P,t,h,x,k,p,c,u),h[0]=w}catch(e){throw m.logger.error("Error compiling schema, function code:",C),e}return w.schema=e,w.errors=null,w.refs=g,w.refVal=h,w.root=b?w:a,j&&(w.$async=!0),!0===f.sourceCode&&(w.source={code:C,patterns:y,defaults:x}),w}function resolveRef(e,r,i){r=o.url(e,r);var n,s,c=g[r];if(void 0!==c)return resolvedRef(n=h[c],s="refVal["+c+"]");if(!i&&t.refs){var p=t.refs[r];if(void 0!==p)return resolvedRef(n=t.refVal[p],s=addLocalRef(r,n))}s=addLocalRef(r);var u=o.call(m,localCompile,t,r);if(void 0===u){var l=a&&a[r];l&&(u=o.inlineRef(l,f.inlineRefs)?l:compile.call(m,l,t,a,e))}if(void 0!==u)return function replaceLocalRef(e,t){var a=g[e];h[a]=t}(r,u),resolvedRef(u,s);!function removeLocalRef(e){delete g[e]}(r)}function addLocalRef(e,t){var a=h.length;return h[a]=t,g[e]=a,"refVal"+a}function resolvedRef(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&!!e.$async}}function usePattern(e){var t=b[e];return void 0===t&&(t=b[e]=y.length,y[t]=e),"pattern"+t}function useDefault(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return r.toQuotedString(e);case"object":if(null===e)return"null";var t=n(e),a=w[t];return void 0===a&&(a=w[t]=x.length,x[a]=e),"default"+a}}function useCustomRule(e,t,a,o){if(!1!==m._opts.validateSchema){var r=e.definition.dependencies;if(r&&!r.every(function(e){return Object.prototype.hasOwnProperty.call(a,e)}))throw new Error("parent schema must have all required keywords: "+r.join(","));var i=e.definition.validateSchema;if(i)if(!i(t)){var n="keyword schema is invalid: "+m.errorsText(i.errors);if("log"!=m._opts.validateSchema)throw new Error(n);m.logger.error(n)}}var s,c=e.definition.compile,p=e.definition.inline,u=e.definition.macro;if(c)s=c.call(m,t,a,o);else if(u)s=u.call(m,t,a,o),!1!==f.validateSchema&&m.validateSchema(s,!0);else if(p)s=p.call(m,o,e.keyword,t,a);else if(!(s=e.definition.validate))return;if(void 0===s)throw new Error('custom keyword "'+e.keyword+'"failed to compile');var l=k.length;return k[l]=s,{code:"customRule"+l,validate:s}}}},18797:(e,t,a)=>{"use strict";var o=a(54774).Buffer;function Utf7Codec(e,t){this.iconv=t}t.utf7=Utf7Codec,t.unicode11utf7="utf7",Utf7Codec.prototype.encoder=Utf7Encoder,Utf7Codec.prototype.decoder=Utf7Decoder,Utf7Codec.prototype.bomAware=!0;var r=/[^A-Za-z0-9'\(\),-\.\/:\? \n\r\t]+/g;function Utf7Encoder(e,t){this.iconv=t.iconv}function Utf7Decoder(e,t){this.iconv=t.iconv,this.inBase64=!1,this.base64Accum=""}Utf7Encoder.prototype.write=function(e){return o.from(e.replace(r,function(e){return"+"+("+"===e?"":this.iconv.encode(e,"utf16-be").toString("base64").replace(/=+$/,""))+"-"}.bind(this)))},Utf7Encoder.prototype.end=function(){};for(var i=/[A-Za-z0-9\/+]/,n=[],s=0;s<256;s++)n[s]=i.test(String.fromCharCode(s));var c="+".charCodeAt(0),p="-".charCodeAt(0),u="&".charCodeAt(0);function Utf7IMAPCodec(e,t){this.iconv=t}function Utf7IMAPEncoder(e,t){this.iconv=t.iconv,this.inBase64=!1,this.base64Accum=o.alloc(6),this.base64AccumIdx=0}function Utf7IMAPDecoder(e,t){this.iconv=t.iconv,this.inBase64=!1,this.base64Accum=""}Utf7Decoder.prototype.write=function(e){for(var t="",a=0,r=this.inBase64,i=this.base64Accum,s=0;s<e.length;s++)if(r){if(!n[e[s]]){if(s==a&&e[s]==p)t+="+";else{var u=i+e.slice(a,s).toString();t+=this.iconv.decode(o.from(u,"base64"),"utf16-be")}e[s]!=p&&s--,a=s+1,r=!1,i=""}}else e[s]==c&&(t+=this.iconv.decode(e.slice(a,s),"ascii"),a=s+1,r=!0);if(r){var l=(u=i+e.slice(a).toString()).length-u.length%8;i=u.slice(l),u=u.slice(0,l),t+=this.iconv.decode(o.from(u,"base64"),"utf16-be")}else t+=this.iconv.decode(e.slice(a),"ascii");return this.inBase64=r,this.base64Accum=i,t},Utf7Decoder.prototype.end=function(){var e="";return this.inBase64&&this.base64Accum.length>0&&(e=this.iconv.decode(o.from(this.base64Accum,"base64"),"utf16-be")),this.inBase64=!1,this.base64Accum="",e},t.utf7imap=Utf7IMAPCodec,Utf7IMAPCodec.prototype.encoder=Utf7IMAPEncoder,Utf7IMAPCodec.prototype.decoder=Utf7IMAPDecoder,Utf7IMAPCodec.prototype.bomAware=!0,Utf7IMAPEncoder.prototype.write=function(e){for(var t=this.inBase64,a=this.base64Accum,r=this.base64AccumIdx,i=o.alloc(5*e.length+10),n=0,s=0;s<e.length;s++){var c=e.charCodeAt(s);32<=c&&c<=126?(t&&(r>0&&(n+=i.write(a.slice(0,r).toString("base64").replace(/\//g,",").replace(/=+$/,""),n),r=0),i[n++]=p,t=!1),t||(i[n++]=c,c===u&&(i[n++]=p))):(t||(i[n++]=u,t=!0),t&&(a[r++]=c>>8,a[r++]=255&c,r==a.length&&(n+=i.write(a.toString("base64").replace(/\//g,","),n),r=0)))}return this.inBase64=t,this.base64AccumIdx=r,i.slice(0,n)},Utf7IMAPEncoder.prototype.end=function(){var e=o.alloc(10),t=0;return this.inBase64&&(this.base64AccumIdx>0&&(t+=e.write(this.base64Accum.slice(0,this.base64AccumIdx).toString("base64").replace(/\//g,",").replace(/=+$/,""),t),this.base64AccumIdx=0),e[t++]=p,this.inBase64=!1),e.slice(0,t)};var l=n.slice();l[",".charCodeAt(0)]=!0,Utf7IMAPDecoder.prototype.write=function(e){for(var t="",a=0,r=this.inBase64,i=this.base64Accum,n=0;n<e.length;n++)if(r){if(!l[e[n]]){if(n==a&&e[n]==p)t+="&";else{var s=i+e.slice(a,n).toString().replace(/,/g,"/");t+=this.iconv.decode(o.from(s,"base64"),"utf16-be")}e[n]!=p&&n--,a=n+1,r=!1,i=""}}else e[n]==u&&(t+=this.iconv.decode(e.slice(a,n),"ascii"),a=n+1,r=!0);if(r){var c=(s=i+e.slice(a).toString().replace(/,/g,"/")).length-s.length%8;i=s.slice(c),s=s.slice(0,c),t+=this.iconv.decode(o.from(s,"base64"),"utf16-be")}else t+=this.iconv.decode(e.slice(a),"ascii");return this.inBase64=r,this.base64Accum=i,t},Utf7IMAPDecoder.prototype.end=function(){var e="";return this.inBase64&&this.base64Accum.length>0&&(e=this.iconv.decode(o.from(this.base64Accum,"base64"),"utf16-be")),this.inBase64=!1,this.base64Accum="",e}},18798:(e,t,a)=>{var o=a(78051),r=a(19500),i=a(26276);e.exports=function parallel(e,t,a){var n=r(e);for(;n.index<(n.keyedList||e).length;)o(e,t,n,function(e,t){e?a(e,t):0!==Object.keys(n.jobs).length||a(null,n.results)}),n.index++;return i.bind(n,a)}},19169:e=>{"use strict";e.exports=JSON.parse('[["0","\\u0000",127,"€"],["8140","丂丄丅丆丏丒丗丟丠両丣並丩丮丯丱丳丵丷丼乀乁乂乄乆乊乑乕乗乚乛乢乣乤乥乧乨乪",5,"乲乴",9,"乿",6,"亇亊"],["8180","亐亖亗亙亜亝亞亣亪亯亰亱亴亶亷亸亹亼亽亾仈仌仏仐仒仚仛仜仠仢仦仧仩仭仮仯仱仴仸仹仺仼仾伀伂",6,"伋伌伒",4,"伜伝伡伣伨伩伬伭伮伱伳伵伷伹伻伾",4,"佄佅佇",5,"佒佔佖佡佢佦佨佪佫佭佮佱佲併佷佸佹佺佽侀侁侂侅來侇侊侌侎侐侒侓侕侖侘侙侚侜侞侟価侢"],["8240","侤侫侭侰",4,"侶",8,"俀俁係俆俇俈俉俋俌俍俒",4,"俙俛俠俢俤俥俧俫俬俰俲俴俵俶俷俹俻俼俽俿",11],["8280","個倎倐們倓倕倖倗倛倝倞倠倢倣値倧倫倯",10,"倻倽倿偀偁偂偄偅偆偉偊偋偍偐",4,"偖偗偘偙偛偝",7,"偦",5,"偭",8,"偸偹偺偼偽傁傂傃傄傆傇傉傊傋傌傎",20,"傤傦傪傫傭",4,"傳",6,"傼"],["8340","傽",17,"僐",5,"僗僘僙僛",10,"僨僩僪僫僯僰僱僲僴僶",4,"僼",9,"儈"],["8380","儉儊儌",5,"儓",13,"儢",28,"兂兇兊兌兎兏児兒兓兗兘兙兛兝",4,"兣兤兦內兩兪兯兲兺兾兿冃冄円冇冊冋冎冏冐冑冓冔冘冚冝冞冟冡冣冦",4,"冭冮冴冸冹冺冾冿凁凂凃凅凈凊凍凎凐凒",5],["8440","凘凙凚凜凞凟凢凣凥",5,"凬凮凱凲凴凷凾刄刅刉刋刌刏刐刓刔刕刜刞刟刡刢刣別刦刧刪刬刯刱刲刴刵刼刾剄",5,"剋剎剏剒剓剕剗剘"],["8480","剙剚剛剝剟剠剢剣剤剦剨剫剬剭剮剰剱剳",9,"剾劀劃",4,"劉",6,"劑劒劔",6,"劜劤劥劦劧劮劯劰労",9,"勀勁勂勄勅勆勈勊勌勍勎勏勑勓勔動勗務",5,"勠勡勢勣勥",10,"勱",7,"勻勼勽匁匂匃匄匇匉匊匋匌匎"],["8540","匑匒匓匔匘匛匜匞匟匢匤匥匧匨匩匫匬匭匯",9,"匼匽區卂卄卆卋卌卍卐協単卙卛卝卥卨卪卬卭卲卶卹卻卼卽卾厀厁厃厇厈厊厎厏"],["8580","厐",4,"厖厗厙厛厜厞厠厡厤厧厪厫厬厭厯",6,"厷厸厹厺厼厽厾叀參",4,"収叏叐叒叓叕叚叜叝叞叡叢叧叴叺叾叿吀吂吅吇吋吔吘吙吚吜吢吤吥吪吰吳吶吷吺吽吿呁呂呄呅呇呉呌呍呎呏呑呚呝",4,"呣呥呧呩",7,"呴呹呺呾呿咁咃咅咇咈咉咊咍咑咓咗咘咜咞咟咠咡"],["8640","咢咥咮咰咲咵咶咷咹咺咼咾哃哅哊哋哖哘哛哠",4,"哫哬哯哰哱哴",5,"哻哾唀唂唃唄唅唈唊",4,"唒唓唕",5,"唜唝唞唟唡唥唦"],["8680","唨唩唫唭唲唴唵唶唸唹唺唻唽啀啂啅啇啈啋",4,"啑啒啓啔啗",4,"啝啞啟啠啢啣啨啩啫啯",5,"啹啺啽啿喅喆喌喍喎喐喒喓喕喖喗喚喛喞喠",6,"喨",8,"喲喴営喸喺喼喿",4,"嗆嗇嗈嗊嗋嗎嗏嗐嗕嗗",4,"嗞嗠嗢嗧嗩嗭嗮嗰嗱嗴嗶嗸",4,"嗿嘂嘃嘄嘅"],["8740","嘆嘇嘊嘋嘍嘐",7,"嘙嘚嘜嘝嘠嘡嘢嘥嘦嘨嘩嘪嘫嘮嘯嘰嘳嘵嘷嘸嘺嘼嘽嘾噀",11,"噏",4,"噕噖噚噛噝",4],["8780","噣噥噦噧噭噮噯噰噲噳噴噵噷噸噹噺噽",7,"嚇",6,"嚐嚑嚒嚔",14,"嚤",10,"嚰",6,"嚸嚹嚺嚻嚽",12,"囋",8,"囕囖囘囙囜団囥",5,"囬囮囯囲図囶囷囸囻囼圀圁圂圅圇國",6],["8840","園",9,"圝圞圠圡圢圤圥圦圧圫圱圲圴",4,"圼圽圿坁坃坄坅坆坈坉坋坒",4,"坘坙坢坣坥坧坬坮坰坱坲坴坵坸坹坺坽坾坿垀"],["8880","垁垇垈垉垊垍",4,"垔",6,"垜垝垞垟垥垨垪垬垯垰垱垳垵垶垷垹",8,"埄",6,"埌埍埐埑埓埖埗埛埜埞埡埢埣埥",7,"埮埰埱埲埳埵埶執埻埼埾埿堁堃堄堅堈堉堊堌堎堏堐堒堓堔堖堗堘堚堛堜堝堟堢堣堥",4,"堫",4,"報堲堳場堶",7],["8940","堾",5,"塅",6,"塎塏塐塒塓塕塖塗塙",4,"塟",5,"塦",4,"塭",16,"塿墂墄墆墇墈墊墋墌"],["8980","墍",4,"墔",4,"墛墜墝墠",7,"墪",17,"墽墾墿壀壂壃壄壆",10,"壒壓壔壖",13,"壥",5,"壭壯壱売壴壵壷壸壺",7,"夃夅夆夈",4,"夎夐夑夒夓夗夘夛夝夞夠夡夢夣夦夨夬夰夲夳夵夶夻"],["8a40","夽夾夿奀奃奅奆奊奌奍奐奒奓奙奛",4,"奡奣奤奦",12,"奵奷奺奻奼奾奿妀妅妉妋妌妎妏妐妑妔妕妘妚妛妜妝妟妠妡妢妦"],["8a80","妧妬妭妰妱妳",5,"妺妼妽妿",6,"姇姈姉姌姍姎姏姕姖姙姛姞",4,"姤姦姧姩姪姫姭",11,"姺姼姽姾娀娂娊娋娍娎娏娐娒娔娕娖娗娙娚娛娝娞娡娢娤娦娧娨娪",6,"娳娵娷",4,"娽娾娿婁",4,"婇婈婋",9,"婖婗婘婙婛",5],["8b40","婡婣婤婥婦婨婩婫",8,"婸婹婻婼婽婾媀",17,"媓",6,"媜",13,"媫媬"],["8b80","媭",4,"媴媶媷媹",4,"媿嫀嫃",5,"嫊嫋嫍",4,"嫓嫕嫗嫙嫚嫛嫝嫞嫟嫢嫤嫥嫧嫨嫪嫬",4,"嫲",22,"嬊",11,"嬘",25,"嬳嬵嬶嬸",7,"孁",6],["8c40","孈",7,"孒孖孞孠孡孧孨孫孭孮孯孲孴孶孷學孹孻孼孾孿宂宆宊宍宎宐宑宒宔宖実宧宨宩宬宭宮宯宱宲宷宺宻宼寀寁寃寈寉寊寋寍寎寏"],["8c80","寑寔",8,"寠寢寣實寧審",4,"寯寱",6,"寽対尀専尃尅將專尋尌對導尐尒尓尗尙尛尞尟尠尡尣尦尨尩尪尫尭尮尯尰尲尳尵尶尷屃屄屆屇屌屍屒屓屔屖屗屘屚屛屜屝屟屢層屧",6,"屰屲",6,"屻屼屽屾岀岃",4,"岉岊岋岎岏岒岓岕岝",4,"岤",4],["8d40","岪岮岯岰岲岴岶岹岺岻岼岾峀峂峃峅",5,"峌",5,"峓",5,"峚",6,"峢峣峧峩峫峬峮峯峱",9,"峼",4],["8d80","崁崄崅崈",5,"崏",4,"崕崗崘崙崚崜崝崟",4,"崥崨崪崫崬崯",4,"崵",7,"崿",7,"嵈嵉嵍",10,"嵙嵚嵜嵞",10,"嵪嵭嵮嵰嵱嵲嵳嵵",12,"嶃",21,"嶚嶛嶜嶞嶟嶠"],["8e40","嶡",21,"嶸",12,"巆",6,"巎",12,"巜巟巠巣巤巪巬巭"],["8e80","巰巵巶巸",4,"巿帀帄帇帉帊帋帍帎帒帓帗帞",7,"帨",4,"帯帰帲",4,"帹帺帾帿幀幁幃幆",5,"幍",6,"幖",4,"幜幝幟幠幣",14,"幵幷幹幾庁庂広庅庈庉庌庍庎庒庘庛庝庡庢庣庤庨",4,"庮",4,"庴庺庻庼庽庿",6],["8f40","廆廇廈廋",5,"廔廕廗廘廙廚廜",11,"廩廫",8,"廵廸廹廻廼廽弅弆弇弉弌弍弎弐弒弔弖弙弚弜弝弞弡弢弣弤"],["8f80","弨弫弬弮弰弲",6,"弻弽弾弿彁",14,"彑彔彙彚彛彜彞彟彠彣彥彧彨彫彮彯彲彴彵彶彸彺彽彾彿徃徆徍徎徏徑従徔徖徚徛徝從徟徠徢",5,"復徫徬徯",5,"徶徸徹徺徻徾",4,"忇忈忊忋忎忓忔忕忚忛応忞忟忢忣忥忦忨忩忬忯忰忲忳忴忶忷忹忺忼怇"],["9040","怈怉怋怌怐怑怓怗怘怚怞怟怢怣怤怬怭怮怰",4,"怶",4,"怽怾恀恄",6,"恌恎恏恑恓恔恖恗恘恛恜恞恟恠恡恥恦恮恱恲恴恵恷恾悀"],["9080","悁悂悅悆悇悈悊悋悎悏悐悑悓悕悗悘悙悜悞悡悢悤悥悧悩悪悮悰悳悵悶悷悹悺悽",7,"惇惈惉惌",4,"惒惓惔惖惗惙惛惞惡",4,"惪惱惲惵惷惸惻",4,"愂愃愄愅愇愊愋愌愐",4,"愖愗愘愙愛愜愝愞愡愢愥愨愩愪愬",18,"慀",6],["9140","慇慉態慍慏慐慒慓慔慖",6,"慞慟慠慡慣慤慥慦慩",6,"慱慲慳慴慶慸",18,"憌憍憏",4,"憕"],["9180","憖",6,"憞",8,"憪憫憭",9,"憸",5,"憿懀懁懃",4,"應懌",4,"懓懕",16,"懧",13,"懶",8,"戀",5,"戇戉戓戔戙戜戝戞戠戣戦戧戨戩戫戭戯戰戱戲戵戶戸",4,"扂扄扅扆扊"],["9240","扏扐払扖扗扙扚扜",6,"扤扥扨扱扲扴扵扷扸扺扻扽抁抂抃抅抆抇抈抋",5,"抔抙抜抝択抣抦抧抩抪抭抮抯抰抲抳抴抶抷抸抺抾拀拁"],["9280","拃拋拏拑拕拝拞拠拡拤拪拫拰拲拵拸拹拺拻挀挃挄挅挆挊挋挌挍挏挐挒挓挔挕挗挘挙挜挦挧挩挬挭挮挰挱挳",5,"挻挼挾挿捀捁捄捇捈捊捑捒捓捔捖",7,"捠捤捥捦捨捪捫捬捯捰捲捳捴捵捸捹捼捽捾捿掁掃掄掅掆掋掍掑掓掔掕掗掙",6,"採掤掦掫掯掱掲掵掶掹掻掽掿揀"],["9340","揁揂揃揅揇揈揊揋揌揑揓揔揕揗",6,"揟揢揤",4,"揫揬揮揯揰揱揳揵揷揹揺揻揼揾搃搄搆",4,"損搎搑搒搕",5,"搝搟搢搣搤"],["9380","搥搧搨搩搫搮",5,"搵",4,"搻搼搾摀摂摃摉摋",6,"摓摕摖摗摙",4,"摟",7,"摨摪摫摬摮",9,"摻",6,"撃撆撈",8,"撓撔撗撘撚撛撜撝撟",4,"撥撦撧撨撪撫撯撱撲撳撴撶撹撻撽撾撿擁擃擄擆",6,"擏擑擓擔擕擖擙據"],["9440","擛擜擝擟擠擡擣擥擧",24,"攁",7,"攊",7,"攓",4,"攙",8],["9480","攢攣攤攦",4,"攬攭攰攱攲攳攷攺攼攽敀",4,"敆敇敊敋敍敎敐敒敓敔敗敘敚敜敟敠敡敤敥敧敨敩敪敭敮敯敱敳敵敶數",14,"斈斉斊斍斎斏斒斔斕斖斘斚斝斞斠斢斣斦斨斪斬斮斱",7,"斺斻斾斿旀旂旇旈旉旊旍旐旑旓旔旕旘",7,"旡旣旤旪旫"],["9540","旲旳旴旵旸旹旻",4,"昁昄昅昇昈昉昋昍昐昑昒昖昗昘昚昛昜昞昡昢昣昤昦昩昪昫昬昮昰昲昳昷",4,"昽昿晀時晄",6,"晍晎晐晑晘"],["9580","晙晛晜晝晞晠晢晣晥晧晩",4,"晱晲晳晵晸晹晻晼晽晿暀暁暃暅暆暈暉暊暋暍暎暏暐暒暓暔暕暘",4,"暞",8,"暩",4,"暯",4,"暵暶暷暸暺暻暼暽暿",25,"曚曞",7,"曧曨曪",5,"曱曵曶書曺曻曽朁朂會"],["9640","朄朅朆朇朌朎朏朑朒朓朖朘朙朚朜朞朠",5,"朧朩朮朰朲朳朶朷朸朹朻朼朾朿杁杄杅杇杊杋杍杒杔杕杗",4,"杝杢杣杤杦杧杫杬杮東杴杶"],["9680","杸杹杺杻杽枀枂枃枅枆枈枊枌枍枎枏枑枒枓枔枖枙枛枟枠枡枤枦枩枬枮枱枲枴枹",7,"柂柅",9,"柕柖柗柛柟柡柣柤柦柧柨柪柫柭柮柲柵",7,"柾栁栂栃栄栆栍栐栒栔栕栘",4,"栞栟栠栢",6,"栫",6,"栴栵栶栺栻栿桇桋桍桏桒桖",5],["9740","桜桝桞桟桪桬",7,"桵桸",8,"梂梄梇",7,"梐梑梒梔梕梖梘",9,"梣梤梥梩梪梫梬梮梱梲梴梶梷梸"],["9780","梹",6,"棁棃",5,"棊棌棎棏棐棑棓棔棖棗棙棛",4,"棡棢棤",9,"棯棲棳棴棶棷棸棻棽棾棿椀椂椃椄椆",4,"椌椏椑椓",11,"椡椢椣椥",7,"椮椯椱椲椳椵椶椷椸椺椻椼椾楀楁楃",16,"楕楖楘楙楛楜楟"],["9840","楡楢楤楥楧楨楩楪楬業楯楰楲",4,"楺楻楽楾楿榁榃榅榊榋榌榎",5,"榖榗榙榚榝",9,"榩榪榬榮榯榰榲榳榵榶榸榹榺榼榽"],["9880","榾榿槀槂",7,"構槍槏槑槒槓槕",5,"槜槝槞槡",11,"槮槯槰槱槳",9,"槾樀",9,"樋",11,"標",5,"樠樢",5,"権樫樬樭樮樰樲樳樴樶",6,"樿",4,"橅橆橈",7,"橑",6,"橚"],["9940","橜",4,"橢橣橤橦",10,"橲",6,"橺橻橽橾橿檁檂檃檅",8,"檏檒",4,"檘",7,"檡",5],["9980","檧檨檪檭",114,"欥欦欨",6],["9a40","欯欰欱欳欴欵欶欸欻欼欽欿歀歁歂歄歅歈歊歋歍",11,"歚",7,"歨歩歫",13,"歺歽歾歿殀殅殈"],["9a80","殌殎殏殐殑殔殕殗殘殙殜",4,"殢",7,"殫",7,"殶殸",6,"毀毃毄毆",4,"毌毎毐毑毘毚毜",4,"毢",7,"毬毭毮毰毱毲毴毶毷毸毺毻毼毾",6,"氈",4,"氎氒気氜氝氞氠氣氥氫氬氭氱氳氶氷氹氺氻氼氾氿汃汄汅汈汋",4,"汑汒汓汖汘"],["9b40","汙汚汢汣汥汦汧汫",4,"汱汳汵汷汸決汻汼汿沀沄沇沊沋沍沎沑沒沕沖沗沘沚沜沝沞沠沢沨沬沯沰沴沵沶沷沺泀況泂泃泆泇泈泋泍泎泏泑泒泘"],["9b80","泙泚泜泝泟泤泦泧泩泬泭泲泴泹泿洀洂洃洅洆洈洉洊洍洏洐洑洓洔洕洖洘洜洝洟",5,"洦洨洩洬洭洯洰洴洶洷洸洺洿浀浂浄浉浌浐浕浖浗浘浛浝浟浡浢浤浥浧浨浫浬浭浰浱浲浳浵浶浹浺浻浽",4,"涃涄涆涇涊涋涍涏涐涒涖",4,"涜涢涥涬涭涰涱涳涴涶涷涹",5,"淁淂淃淈淉淊"],["9c40","淍淎淏淐淒淓淔淕淗淚淛淜淟淢淣淥淧淨淩淪淭淯淰淲淴淵淶淸淺淽",7,"渆渇済渉渋渏渒渓渕渘渙減渜渞渟渢渦渧渨渪測渮渰渱渳渵"],["9c80","渶渷渹渻",7,"湅",7,"湏湐湑湒湕湗湙湚湜湝湞湠",10,"湬湭湯",14,"満溁溂溄溇溈溊",4,"溑",6,"溙溚溛溝溞溠溡溣溤溦溨溩溫溬溭溮溰溳溵溸溹溼溾溿滀滃滄滅滆滈滉滊滌滍滎滐滒滖滘滙滛滜滝滣滧滪",5],["9d40","滰滱滲滳滵滶滷滸滺",7,"漃漄漅漇漈漊",4,"漐漑漒漖",9,"漡漢漣漥漦漧漨漬漮漰漲漴漵漷",6,"漿潀潁潂"],["9d80","潃潄潅潈潉潊潌潎",9,"潙潚潛潝潟潠潡潣潤潥潧",5,"潯潰潱潳潵潶潷潹潻潽",6,"澅澆澇澊澋澏",12,"澝澞澟澠澢",4,"澨",10,"澴澵澷澸澺",5,"濁濃",5,"濊",6,"濓",10,"濟濢濣濤濥"],["9e40","濦",7,"濰",32,"瀒",7,"瀜",6,"瀤",6],["9e80","瀫",9,"瀶瀷瀸瀺",17,"灍灎灐",13,"灟",11,"灮灱灲灳灴灷灹灺灻災炁炂炃炄炆炇炈炋炌炍炏炐炑炓炗炘炚炛炞",12,"炰炲炴炵炶為炾炿烄烅烆烇烉烋",12,"烚"],["9f40","烜烝烞烠烡烢烣烥烪烮烰",6,"烸烺烻烼烾",10,"焋",4,"焑焒焔焗焛",10,"焧",7,"焲焳焴"],["9f80","焵焷",13,"煆煇煈煉煋煍煏",12,"煝煟",4,"煥煩",4,"煯煰煱煴煵煶煷煹煻煼煾",5,"熅",4,"熋熌熍熎熐熑熒熓熕熖熗熚",4,"熡",6,"熩熪熫熭",5,"熴熶熷熸熺",8,"燄",9,"燏",4],["a040","燖",9,"燡燢燣燤燦燨",5,"燯",9,"燺",11,"爇",19],["a080","爛爜爞",9,"爩爫爭爮爯爲爳爴爺爼爾牀",6,"牉牊牋牎牏牐牑牓牔牕牗牘牚牜牞牠牣牤牥牨牪牫牬牭牰牱牳牴牶牷牸牻牼牽犂犃犅",4,"犌犎犐犑犓",11,"犠",11,"犮犱犲犳犵犺",6,"狅狆狇狉狊狋狌狏狑狓狔狕狖狘狚狛"],["a1a1","　、。·ˉˇ¨〃々—～‖…‘’“”〔〕〈",7,"〖〗【】±×÷∶∧∨∑∏∪∩∈∷√⊥∥∠⌒⊙∫∮≡≌≈∽∝≠≮≯≤≥∞∵∴♂♀°′″℃＄¤￠￡‰§№☆★○●◎◇◆□■△▲※→←↑↓〓"],["a2a1","ⅰ",9],["a2b1","⒈",19,"⑴",19,"①",9],["a2e5","㈠",9],["a2f1","Ⅰ",11],["a3a1","！＂＃￥％",88,"￣"],["a4a1","ぁ",82],["a5a1","ァ",85],["a6a1","Α",16,"Σ",6],["a6c1","α",16,"σ",6],["a6e0","︵︶︹︺︿﹀︽︾﹁﹂﹃﹄"],["a6ee","︻︼︷︸︱"],["a6f4","︳︴"],["a7a1","А",5,"ЁЖ",25],["a7d1","а",5,"ёж",25],["a840","ˊˋ˙–―‥‵℅℉↖↗↘↙∕∟∣≒≦≧⊿═",35,"▁",6],["a880","█",7,"▓▔▕▼▽◢◣◤◥☉⊕〒〝〞"],["a8a1","āáǎàēéěèīíǐìōóǒòūúǔùǖǘǚǜüêɑ"],["a8bd","ńň"],["a8c0","ɡ"],["a8c5","ㄅ",36],["a940","〡",8,"㊣㎎㎏㎜㎝㎞㎡㏄㏎㏑㏒㏕︰￢￤"],["a959","℡㈱"],["a95c","‐"],["a960","ー゛゜ヽヾ〆ゝゞ﹉",9,"﹔﹕﹖﹗﹙",8],["a980","﹢",4,"﹨﹩﹪﹫"],["a996","〇"],["a9a4","─",75],["aa40","狜狝狟狢",5,"狪狫狵狶狹狽狾狿猀猂猄",5,"猋猌猍猏猐猑猒猔猘猙猚猟猠猣猤猦猧猨猭猯猰猲猳猵猶猺猻猼猽獀",8],["aa80","獉獊獋獌獎獏獑獓獔獕獖獘",7,"獡",10,"獮獰獱"],["ab40","獲",11,"獿",4,"玅玆玈玊玌玍玏玐玒玓玔玕玗玘玙玚玜玝玞玠玡玣",5,"玪玬玭玱玴玵玶玸玹玼玽玾玿珁珃",4],["ab80","珋珌珎珒",6,"珚珛珜珝珟珡珢珣珤珦珨珪珫珬珮珯珰珱珳",4],["ac40","珸",10,"琄琇琈琋琌琍琎琑",8,"琜",5,"琣琤琧琩琫琭琯琱琲琷",4,"琽琾琿瑀瑂",11],["ac80","瑎",6,"瑖瑘瑝瑠",12,"瑮瑯瑱",4,"瑸瑹瑺"],["ad40","瑻瑼瑽瑿璂璄璅璆璈璉璊璌璍璏璑",10,"璝璟",7,"璪",15,"璻",12],["ad80","瓈",9,"瓓",8,"瓝瓟瓡瓥瓧",6,"瓰瓱瓲"],["ae40","瓳瓵瓸",6,"甀甁甂甃甅",7,"甎甐甒甔甕甖甗甛甝甞甠",4,"甦甧甪甮甴甶甹甼甽甿畁畂畃畄畆畇畉畊畍畐畑畒畓畕畖畗畘"],["ae80","畝",7,"畧畨畩畫",6,"畳畵當畷畺",4,"疀疁疂疄疅疇"],["af40","疈疉疊疌疍疎疐疓疕疘疛疜疞疢疦",4,"疭疶疷疺疻疿痀痁痆痋痌痎痏痐痑痓痗痙痚痜痝痟痠痡痥痩痬痭痮痯痲痳痵痶痷痸痺痻痽痾瘂瘄瘆瘇"],["af80","瘈瘉瘋瘍瘎瘏瘑瘒瘓瘔瘖瘚瘜瘝瘞瘡瘣瘧瘨瘬瘮瘯瘱瘲瘶瘷瘹瘺瘻瘽癁療癄"],["b040","癅",6,"癎",5,"癕癗",4,"癝癟癠癡癢癤",6,"癬癭癮癰",7,"癹発發癿皀皁皃皅皉皊皌皍皏皐皒皔皕皗皘皚皛"],["b080","皜",7,"皥",8,"皯皰皳皵",9,"盀盁盃啊阿埃挨哎唉哀皑癌蔼矮艾碍爱隘鞍氨安俺按暗岸胺案肮昂盎凹敖熬翱袄傲奥懊澳芭捌扒叭吧笆八疤巴拔跋靶把耙坝霸罢爸白柏百摆佰败拜稗斑班搬扳般颁板版扮拌伴瓣半办绊邦帮梆榜膀绑棒磅蚌镑傍谤苞胞包褒剥"],["b140","盄盇盉盋盌盓盕盙盚盜盝盞盠",4,"盦",7,"盰盳盵盶盷盺盻盽盿眀眂眃眅眆眊県眎",10,"眛眜眝眞眡眣眤眥眧眪眫"],["b180","眬眮眰",4,"眹眻眽眾眿睂睄睅睆睈",7,"睒",7,"睜薄雹保堡饱宝抱报暴豹鲍爆杯碑悲卑北辈背贝钡倍狈备惫焙被奔苯本笨崩绷甭泵蹦迸逼鼻比鄙笔彼碧蓖蔽毕毙毖币庇痹闭敝弊必辟壁臂避陛鞭边编贬扁便变卞辨辩辫遍标彪膘表鳖憋别瘪彬斌濒滨宾摈兵冰柄丙秉饼炳"],["b240","睝睞睟睠睤睧睩睪睭",11,"睺睻睼瞁瞂瞃瞆",5,"瞏瞐瞓",11,"瞡瞣瞤瞦瞨瞫瞭瞮瞯瞱瞲瞴瞶",4],["b280","瞼瞾矀",12,"矎",8,"矘矙矚矝",4,"矤病并玻菠播拨钵波博勃搏铂箔伯帛舶脖膊渤泊驳捕卜哺补埠不布步簿部怖擦猜裁材才财睬踩采彩菜蔡餐参蚕残惭惨灿苍舱仓沧藏操糙槽曹草厕策侧册测层蹭插叉茬茶查碴搽察岔差诧拆柴豺搀掺蝉馋谗缠铲产阐颤昌猖"],["b340","矦矨矪矯矰矱矲矴矵矷矹矺矻矼砃",5,"砊砋砎砏砐砓砕砙砛砞砠砡砢砤砨砪砫砮砯砱砲砳砵砶砽砿硁硂硃硄硆硈硉硊硋硍硏硑硓硔硘硙硚"],["b380","硛硜硞",11,"硯",7,"硸硹硺硻硽",6,"场尝常长偿肠厂敞畅唱倡超抄钞朝嘲潮巢吵炒车扯撤掣彻澈郴臣辰尘晨忱沉陈趁衬撑称城橙成呈乘程惩澄诚承逞骋秤吃痴持匙池迟弛驰耻齿侈尺赤翅斥炽充冲虫崇宠抽酬畴踌稠愁筹仇绸瞅丑臭初出橱厨躇锄雏滁除楚"],["b440","碄碅碆碈碊碋碏碐碒碔碕碖碙碝碞碠碢碤碦碨",7,"碵碶碷碸確碻碼碽碿磀磂磃磄磆磇磈磌磍磎磏磑磒磓磖磗磘磚",9],["b480","磤磥磦磧磩磪磫磭",4,"磳磵磶磸磹磻",5,"礂礃礄礆",6,"础储矗搐触处揣川穿椽传船喘串疮窗幢床闯创吹炊捶锤垂春椿醇唇淳纯蠢戳绰疵茨磁雌辞慈瓷词此刺赐次聪葱囱匆从丛凑粗醋簇促蹿篡窜摧崔催脆瘁粹淬翠村存寸磋撮搓措挫错搭达答瘩打大呆歹傣戴带殆代贷袋待逮"],["b540","礍",5,"礔",9,"礟",4,"礥",14,"礵",4,"礽礿祂祃祄祅祇祊",8,"祔祕祘祙祡祣"],["b580","祤祦祩祪祫祬祮祰",6,"祹祻",4,"禂禃禆禇禈禉禋禌禍禎禐禑禒怠耽担丹单郸掸胆旦氮但惮淡诞弹蛋当挡党荡档刀捣蹈倒岛祷导到稻悼道盗德得的蹬灯登等瞪凳邓堤低滴迪敌笛狄涤翟嫡抵底地蒂第帝弟递缔颠掂滇碘点典靛垫电佃甸店惦奠淀殿碉叼雕凋刁掉吊钓调跌爹碟蝶迭谍叠"],["b640","禓",6,"禛",11,"禨",10,"禴",4,"禼禿秂秄秅秇秈秊秌秎秏秐秓秔秖秗秙",5,"秠秡秢秥秨秪"],["b680","秬秮秱",6,"秹秺秼秾秿稁稄稅稇稈稉稊稌稏",4,"稕稖稘稙稛稜丁盯叮钉顶鼎锭定订丢东冬董懂动栋侗恫冻洞兜抖斗陡豆逗痘都督毒犊独读堵睹赌杜镀肚度渡妒端短锻段断缎堆兑队对墩吨蹲敦顿囤钝盾遁掇哆多夺垛躲朵跺舵剁惰堕蛾峨鹅俄额讹娥恶厄扼遏鄂饿恩而儿耳尔饵洱二"],["b740","稝稟稡稢稤",14,"稴稵稶稸稺稾穀",5,"穇",9,"穒",4,"穘",16],["b780","穩",6,"穱穲穳穵穻穼穽穾窂窅窇窉窊窋窌窎窏窐窓窔窙窚窛窞窡窢贰发罚筏伐乏阀法珐藩帆番翻樊矾钒繁凡烦反返范贩犯饭泛坊芳方肪房防妨仿访纺放菲非啡飞肥匪诽吠肺废沸费芬酚吩氛分纷坟焚汾粉奋份忿愤粪丰封枫蜂峰锋风疯烽逢冯缝讽奉凤佛否夫敷肤孵扶拂辐幅氟符伏俘服"],["b840","窣窤窧窩窪窫窮",4,"窴",10,"竀",10,"竌",9,"竗竘竚竛竜竝竡竢竤竧",5,"竮竰竱竲竳"],["b880","竴",4,"竻竼竾笀笁笂笅笇笉笌笍笎笐笒笓笖笗笘笚笜笝笟笡笢笣笧笩笭浮涪福袱弗甫抚辅俯釜斧脯腑府腐赴副覆赋复傅付阜父腹负富讣附妇缚咐噶嘎该改概钙盖溉干甘杆柑竿肝赶感秆敢赣冈刚钢缸肛纲岗港杠篙皋高膏羔糕搞镐稿告哥歌搁戈鸽胳疙割革葛格蛤阁隔铬个各给根跟耕更庚羹"],["b940","笯笰笲笴笵笶笷笹笻笽笿",5,"筆筈筊筍筎筓筕筗筙筜筞筟筡筣",10,"筯筰筳筴筶筸筺筼筽筿箁箂箃箄箆",6,"箎箏"],["b980","箑箒箓箖箘箙箚箛箞箟箠箣箤箥箮箯箰箲箳箵箶箷箹",7,"篂篃範埂耿梗工攻功恭龚供躬公宫弓巩汞拱贡共钩勾沟苟狗垢构购够辜菇咕箍估沽孤姑鼓古蛊骨谷股故顾固雇刮瓜剐寡挂褂乖拐怪棺关官冠观管馆罐惯灌贯光广逛瑰规圭硅归龟闺轨鬼诡癸桂柜跪贵刽辊滚棍锅郭国果裹过哈"],["ba40","篅篈築篊篋篍篎篏篐篒篔",4,"篛篜篞篟篠篢篣篤篧篨篩篫篬篭篯篰篲",4,"篸篹篺篻篽篿",7,"簈簉簊簍簎簐",5,"簗簘簙"],["ba80","簚",4,"簠",5,"簨簩簫",12,"簹",5,"籂骸孩海氦亥害骇酣憨邯韩含涵寒函喊罕翰撼捍旱憾悍焊汗汉夯杭航壕嚎豪毫郝好耗号浩呵喝荷菏核禾和何合盒貉阂河涸赫褐鹤贺嘿黑痕很狠恨哼亨横衡恒轰哄烘虹鸿洪宏弘红喉侯猴吼厚候后呼乎忽瑚壶葫胡蝴狐糊湖"],["bb40","籃",9,"籎",36,"籵",5,"籾",9],["bb80","粈粊",6,"粓粔粖粙粚粛粠粡粣粦粧粨粩粫粬粭粯粰粴",4,"粺粻弧虎唬护互沪户花哗华猾滑画划化话槐徊怀淮坏欢环桓还缓换患唤痪豢焕涣宦幻荒慌黄磺蝗簧皇凰惶煌晃幌恍谎灰挥辉徽恢蛔回毁悔慧卉惠晦贿秽会烩汇讳诲绘荤昏婚魂浑混豁活伙火获或惑霍货祸击圾基机畸稽积箕"],["bc40","粿糀糂糃糄糆糉糋糎",6,"糘糚糛糝糞糡",6,"糩",5,"糰",7,"糹糺糼",13,"紋",5],["bc80","紑",14,"紡紣紤紥紦紨紩紪紬紭紮細",6,"肌饥迹激讥鸡姬绩缉吉极棘辑籍集及急疾汲即嫉级挤几脊己蓟技冀季伎祭剂悸济寄寂计记既忌际妓继纪嘉枷夹佳家加荚颊贾甲钾假稼价架驾嫁歼监坚尖笺间煎兼肩艰奸缄茧检柬碱硷拣捡简俭剪减荐槛鉴践贱见键箭件"],["bd40","紷",54,"絯",7],["bd80","絸",32,"健舰剑饯渐溅涧建僵姜将浆江疆蒋桨奖讲匠酱降蕉椒礁焦胶交郊浇骄娇嚼搅铰矫侥脚狡角饺缴绞剿教酵轿较叫窖揭接皆秸街阶截劫节桔杰捷睫竭洁结解姐戒藉芥界借介疥诫届巾筋斤金今津襟紧锦仅谨进靳晋禁近烬浸"],["be40","継",12,"綧",6,"綯",42],["be80","線",32,"尽劲荆兢茎睛晶鲸京惊精粳经井警景颈静境敬镜径痉靖竟竞净炯窘揪究纠玖韭久灸九酒厩救旧臼舅咎就疚鞠拘狙疽居驹菊局咀矩举沮聚拒据巨具距踞锯俱句惧炬剧捐鹃娟倦眷卷绢撅攫抉掘倔爵觉决诀绝均菌钧军君峻"],["bf40","緻",62],["bf80","縺縼",4,"繂",4,"繈",21,"俊竣浚郡骏喀咖卡咯开揩楷凯慨刊堪勘坎砍看康慷糠扛抗亢炕考拷烤靠坷苛柯棵磕颗科壳咳可渴克刻客课肯啃垦恳坑吭空恐孔控抠口扣寇枯哭窟苦酷库裤夸垮挎跨胯块筷侩快宽款匡筐狂框矿眶旷况亏盔岿窥葵奎魁傀"],["c040","繞",35,"纃",23,"纜纝纞"],["c080","纮纴纻纼绖绤绬绹缊缐缞缷缹缻",6,"罃罆",9,"罒罓馈愧溃坤昆捆困括扩廓阔垃拉喇蜡腊辣啦莱来赖蓝婪栏拦篮阑兰澜谰揽览懒缆烂滥琅榔狼廊郎朗浪捞劳牢老佬姥酪烙涝勒乐雷镭蕾磊累儡垒擂肋类泪棱楞冷厘梨犁黎篱狸离漓理李里鲤礼莉荔吏栗丽厉励砾历利傈例俐"],["c140","罖罙罛罜罝罞罠罣",4,"罫罬罭罯罰罳罵罶罷罸罺罻罼罽罿羀羂",7,"羋羍羏",4,"羕",4,"羛羜羠羢羣羥羦羨",6,"羱"],["c180","羳",4,"羺羻羾翀翂翃翄翆翇翈翉翋翍翏",4,"翖翗翙",5,"翢翣痢立粒沥隶力璃哩俩联莲连镰廉怜涟帘敛脸链恋炼练粮凉梁粱良两辆量晾亮谅撩聊僚疗燎寥辽潦了撂镣廖料列裂烈劣猎琳林磷霖临邻鳞淋凛赁吝拎玲菱零龄铃伶羚凌灵陵岭领另令溜琉榴硫馏留刘瘤流柳六龙聋咙笼窿"],["c240","翤翧翨翪翫翬翭翯翲翴",6,"翽翾翿耂耇耈耉耊耎耏耑耓耚耛耝耞耟耡耣耤耫",5,"耲耴耹耺耼耾聀聁聄聅聇聈聉聎聏聐聑聓聕聖聗"],["c280","聙聛",13,"聫",5,"聲",11,"隆垄拢陇楼娄搂篓漏陋芦卢颅庐炉掳卤虏鲁麓碌露路赂鹿潞禄录陆戮驴吕铝侣旅履屡缕虑氯律率滤绿峦挛孪滦卵乱掠略抡轮伦仑沦纶论萝螺罗逻锣箩骡裸落洛骆络妈麻玛码蚂马骂嘛吗埋买麦卖迈脉瞒馒蛮满蔓曼慢漫"],["c340","聾肁肂肅肈肊肍",5,"肔肕肗肙肞肣肦肧肨肬肰肳肵肶肸肹肻胅胇",4,"胏",6,"胘胟胠胢胣胦胮胵胷胹胻胾胿脀脁脃脄脅脇脈脋"],["c380","脌脕脗脙脛脜脝脟",12,"脭脮脰脳脴脵脷脹",4,"脿谩芒茫盲氓忙莽猫茅锚毛矛铆卯茂冒帽貌贸么玫枚梅酶霉煤没眉媒镁每美昧寐妹媚门闷们萌蒙檬盟锰猛梦孟眯醚靡糜迷谜弥米秘觅泌蜜密幂棉眠绵冕免勉娩缅面苗描瞄藐秒渺庙妙蔑灭民抿皿敏悯闽明螟鸣铭名命谬摸"],["c440","腀",5,"腇腉腍腎腏腒腖腗腘腛",4,"腡腢腣腤腦腨腪腫腬腯腲腳腵腶腷腸膁膃",4,"膉膋膌膍膎膐膒",5,"膙膚膞",4,"膤膥"],["c480","膧膩膫",7,"膴",5,"膼膽膾膿臄臅臇臈臉臋臍",6,"摹蘑模膜磨摩魔抹末莫墨默沫漠寞陌谋牟某拇牡亩姆母墓暮幕募慕木目睦牧穆拿哪呐钠那娜纳氖乃奶耐奈南男难囊挠脑恼闹淖呢馁内嫩能妮霓倪泥尼拟你匿腻逆溺蔫拈年碾撵捻念娘酿鸟尿捏聂孽啮镊镍涅您柠狞凝宁"],["c540","臔",14,"臤臥臦臨臩臫臮",4,"臵",5,"臽臿舃與",4,"舎舏舑舓舕",5,"舝舠舤舥舦舧舩舮舲舺舼舽舿"],["c580","艀艁艂艃艅艆艈艊艌艍艎艐",7,"艙艛艜艝艞艠",7,"艩拧泞牛扭钮纽脓浓农弄奴努怒女暖虐疟挪懦糯诺哦欧鸥殴藕呕偶沤啪趴爬帕怕琶拍排牌徘湃派攀潘盘磐盼畔判叛乓庞旁耪胖抛咆刨炮袍跑泡呸胚培裴赔陪配佩沛喷盆砰抨烹澎彭蓬棚硼篷膨朋鹏捧碰坯砒霹批披劈琵毗"],["c640","艪艫艬艭艱艵艶艷艸艻艼芀芁芃芅芆芇芉芌芐芓芔芕芖芚芛芞芠芢芣芧芲芵芶芺芻芼芿苀苂苃苅苆苉苐苖苙苚苝苢苧苨苩苪苬苭苮苰苲苳苵苶苸"],["c680","苺苼",4,"茊茋茍茐茒茓茖茘茙茝",9,"茩茪茮茰茲茷茻茽啤脾疲皮匹痞僻屁譬篇偏片骗飘漂瓢票撇瞥拼频贫品聘乒坪苹萍平凭瓶评屏坡泼颇婆破魄迫粕剖扑铺仆莆葡菩蒲埔朴圃普浦谱曝瀑期欺栖戚妻七凄漆柒沏其棋奇歧畦崎脐齐旗祈祁骑起岂乞企启契砌器气迄弃汽泣讫掐"],["c740","茾茿荁荂荄荅荈荊",4,"荓荕",4,"荝荢荰",6,"荹荺荾",6,"莇莈莊莋莌莍莏莐莑莔莕莖莗莙莚莝莟莡",6,"莬莭莮"],["c780","莯莵莻莾莿菂菃菄菆菈菉菋菍菎菐菑菒菓菕菗菙菚菛菞菢菣菤菦菧菨菫菬菭恰洽牵扦钎铅千迁签仟谦乾黔钱钳前潜遣浅谴堑嵌欠歉枪呛腔羌墙蔷强抢橇锹敲悄桥瞧乔侨巧鞘撬翘峭俏窍切茄且怯窃钦侵亲秦琴勤芹擒禽寝沁青轻氢倾卿清擎晴氰情顷请庆琼穷秋丘邱球求囚酋泅趋区蛆曲躯屈驱渠"],["c840","菮華菳",4,"菺菻菼菾菿萀萂萅萇萈萉萊萐萒",5,"萙萚萛萞",5,"萩",7,"萲",5,"萹萺萻萾",7,"葇葈葉"],["c880","葊",6,"葒",4,"葘葝葞葟葠葢葤",4,"葪葮葯葰葲葴葷葹葻葼取娶龋趣去圈颧权醛泉全痊拳犬券劝缺炔瘸却鹊榷确雀裙群然燃冉染瓤壤攘嚷让饶扰绕惹热壬仁人忍韧任认刃妊纫扔仍日戎茸蓉荣融熔溶容绒冗揉柔肉茹蠕儒孺如辱乳汝入褥软阮蕊瑞锐闰润若弱撒洒萨腮鳃塞赛三叁"],["c940","葽",4,"蒃蒄蒅蒆蒊蒍蒏",7,"蒘蒚蒛蒝蒞蒟蒠蒢",12,"蒰蒱蒳蒵蒶蒷蒻蒼蒾蓀蓂蓃蓅蓆蓇蓈蓋蓌蓎蓏蓒蓔蓕蓗"],["c980","蓘",4,"蓞蓡蓢蓤蓧",4,"蓭蓮蓯蓱",10,"蓽蓾蔀蔁蔂伞散桑嗓丧搔骚扫嫂瑟色涩森僧莎砂杀刹沙纱傻啥煞筛晒珊苫杉山删煽衫闪陕擅赡膳善汕扇缮墒伤商赏晌上尚裳梢捎稍烧芍勺韶少哨邵绍奢赊蛇舌舍赦摄射慑涉社设砷申呻伸身深娠绅神沈审婶甚肾慎渗声生甥牲升绳"],["ca40","蔃",8,"蔍蔎蔏蔐蔒蔔蔕蔖蔘蔙蔛蔜蔝蔞蔠蔢",8,"蔭",9,"蔾",4,"蕄蕅蕆蕇蕋",10],["ca80","蕗蕘蕚蕛蕜蕝蕟",4,"蕥蕦蕧蕩",8,"蕳蕵蕶蕷蕸蕼蕽蕿薀薁省盛剩胜圣师失狮施湿诗尸虱十石拾时什食蚀实识史矢使屎驶始式示士世柿事拭誓逝势是嗜噬适仕侍释饰氏市恃室视试收手首守寿授售受瘦兽蔬枢梳殊抒输叔舒淑疏书赎孰熟薯暑曙署蜀黍鼠属术述树束戍竖墅庶数漱"],["cb40","薂薃薆薈",6,"薐",10,"薝",6,"薥薦薧薩薫薬薭薱",5,"薸薺",6,"藂",6,"藊",4,"藑藒"],["cb80","藔藖",5,"藝",6,"藥藦藧藨藪",14,"恕刷耍摔衰甩帅栓拴霜双爽谁水睡税吮瞬顺舜说硕朔烁斯撕嘶思私司丝死肆寺嗣四伺似饲巳松耸怂颂送宋讼诵搜艘擞嗽苏酥俗素速粟僳塑溯宿诉肃酸蒜算虽隋随绥髓碎岁穗遂隧祟孙损笋蓑梭唆缩琐索锁所塌他它她塔"],["cc40","藹藺藼藽藾蘀",4,"蘆",10,"蘒蘓蘔蘕蘗",15,"蘨蘪",13,"蘹蘺蘻蘽蘾蘿虀"],["cc80","虁",11,"虒虓處",4,"虛虜虝號虠虡虣",7,"獭挞蹋踏胎苔抬台泰酞太态汰坍摊贪瘫滩坛檀痰潭谭谈坦毯袒碳探叹炭汤塘搪堂棠膛唐糖倘躺淌趟烫掏涛滔绦萄桃逃淘陶讨套特藤腾疼誊梯剔踢锑提题蹄啼体替嚏惕涕剃屉天添填田甜恬舔腆挑条迢眺跳贴铁帖厅听烃"],["cd40","虭虯虰虲",6,"蚃",6,"蚎",4,"蚔蚖",5,"蚞",4,"蚥蚦蚫蚭蚮蚲蚳蚷蚸蚹蚻",4,"蛁蛂蛃蛅蛈蛌蛍蛒蛓蛕蛖蛗蛚蛜"],["cd80","蛝蛠蛡蛢蛣蛥蛦蛧蛨蛪蛫蛬蛯蛵蛶蛷蛺蛻蛼蛽蛿蜁蜄蜅蜆蜋蜌蜎蜏蜐蜑蜔蜖汀廷停亭庭挺艇通桐酮瞳同铜彤童桶捅筒统痛偷投头透凸秃突图徒途涂屠土吐兔湍团推颓腿蜕褪退吞屯臀拖托脱鸵陀驮驼椭妥拓唾挖哇蛙洼娃瓦袜歪外豌弯湾玩顽丸烷完碗挽晚皖惋宛婉万腕汪王亡枉网往旺望忘妄威"],["ce40","蜙蜛蜝蜟蜠蜤蜦蜧蜨蜪蜫蜬蜭蜯蜰蜲蜳蜵蜶蜸蜹蜺蜼蜽蝀",6,"蝊蝋蝍蝏蝐蝑蝒蝔蝕蝖蝘蝚",5,"蝡蝢蝦",7,"蝯蝱蝲蝳蝵"],["ce80","蝷蝸蝹蝺蝿螀螁螄螆螇螉螊螌螎",4,"螔螕螖螘",6,"螠",4,"巍微危韦违桅围唯惟为潍维苇萎委伟伪尾纬未蔚味畏胃喂魏位渭谓尉慰卫瘟温蚊文闻纹吻稳紊问嗡翁瓮挝蜗涡窝我斡卧握沃巫呜钨乌污诬屋无芜梧吾吴毋武五捂午舞伍侮坞戊雾晤物勿务悟误昔熙析西硒矽晰嘻吸锡牺"],["cf40","螥螦螧螩螪螮螰螱螲螴螶螷螸螹螻螼螾螿蟁",4,"蟇蟈蟉蟌",4,"蟔",6,"蟜蟝蟞蟟蟡蟢蟣蟤蟦蟧蟨蟩蟫蟬蟭蟯",9],["cf80","蟺蟻蟼蟽蟿蠀蠁蠂蠄",5,"蠋",7,"蠔蠗蠘蠙蠚蠜",4,"蠣稀息希悉膝夕惜熄烯溪汐犀檄袭席习媳喜铣洗系隙戏细瞎虾匣霞辖暇峡侠狭下厦夏吓掀锨先仙鲜纤咸贤衔舷闲涎弦嫌显险现献县腺馅羡宪陷限线相厢镶香箱襄湘乡翔祥详想响享项巷橡像向象萧硝霄削哮嚣销消宵淆晓"],["d040","蠤",13,"蠳",5,"蠺蠻蠽蠾蠿衁衂衃衆",5,"衎",5,"衕衖衘衚",6,"衦衧衪衭衯衱衳衴衵衶衸衹衺"],["d080","衻衼袀袃袆袇袉袊袌袎袏袐袑袓袔袕袗",4,"袝",4,"袣袥",5,"小孝校肖啸笑效楔些歇蝎鞋协挟携邪斜胁谐写械卸蟹懈泄泻谢屑薪芯锌欣辛新忻心信衅星腥猩惺兴刑型形邢行醒幸杏性姓兄凶胸匈汹雄熊休修羞朽嗅锈秀袖绣墟戌需虚嘘须徐许蓄酗叙旭序畜恤絮婿绪续轩喧宣悬旋玄"],["d140","袬袮袯袰袲",4,"袸袹袺袻袽袾袿裀裃裄裇裈裊裋裌裍裏裐裑裓裖裗裚",4,"裠裡裦裧裩",6,"裲裵裶裷裺裻製裿褀褁褃",5],["d180","褉褋",4,"褑褔",4,"褜",4,"褢褣褤褦褧褨褩褬褭褮褯褱褲褳褵褷选癣眩绚靴薛学穴雪血勋熏循旬询寻驯巡殉汛训讯逊迅压押鸦鸭呀丫芽牙蚜崖衙涯雅哑亚讶焉咽阉烟淹盐严研蜒岩延言颜阎炎沿奄掩眼衍演艳堰燕厌砚雁唁彦焰宴谚验殃央鸯秧杨扬佯疡羊洋阳氧仰痒养样漾邀腰妖瑶"],["d240","褸",8,"襂襃襅",24,"襠",5,"襧",19,"襼"],["d280","襽襾覀覂覄覅覇",26,"摇尧遥窑谣姚咬舀药要耀椰噎耶爷野冶也页掖业叶曳腋夜液一壹医揖铱依伊衣颐夷遗移仪胰疑沂宜姨彝椅蚁倚已乙矣以艺抑易邑屹亿役臆逸肄疫亦裔意毅忆义益溢诣议谊译异翼翌绎茵荫因殷音阴姻吟银淫寅饮尹引隐"],["d340","覢",30,"觃觍觓觔觕觗觘觙觛觝觟觠觡觢觤觧觨觩觪觬觭觮觰觱觲觴",6],["d380","觻",4,"訁",5,"計",21,"印英樱婴鹰应缨莹萤营荧蝇迎赢盈影颖硬映哟拥佣臃痈庸雍踊蛹咏泳涌永恿勇用幽优悠忧尤由邮铀犹油游酉有友右佑釉诱又幼迂淤于盂榆虞愚舆余俞逾鱼愉渝渔隅予娱雨与屿禹宇语羽玉域芋郁吁遇喻峪御愈欲狱育誉"],["d440","訞",31,"訿",8,"詉",21],["d480","詟",25,"詺",6,"浴寓裕预豫驭鸳渊冤元垣袁原援辕园员圆猿源缘远苑愿怨院曰约越跃钥岳粤月悦阅耘云郧匀陨允运蕴酝晕韵孕匝砸杂栽哉灾宰载再在咱攒暂赞赃脏葬遭糟凿藻枣早澡蚤躁噪造皂灶燥责择则泽贼怎增憎曾赠扎喳渣札轧"],["d540","誁",7,"誋",7,"誔",46],["d580","諃",32,"铡闸眨栅榨咋乍炸诈摘斋宅窄债寨瞻毡詹粘沾盏斩辗崭展蘸栈占战站湛绽樟章彰漳张掌涨杖丈帐账仗胀瘴障招昭找沼赵照罩兆肇召遮折哲蛰辙者锗蔗这浙珍斟真甄砧臻贞针侦枕疹诊震振镇阵蒸挣睁征狰争怔整拯正政"],["d640","諤",34,"謈",27],["d680","謤謥謧",30,"帧症郑证芝枝支吱蜘知肢脂汁之织职直植殖执值侄址指止趾只旨纸志挚掷至致置帜峙制智秩稚质炙痔滞治窒中盅忠钟衷终种肿重仲众舟周州洲诌粥轴肘帚咒皱宙昼骤珠株蛛朱猪诸诛逐竹烛煮拄瞩嘱主著柱助蛀贮铸筑"],["d740","譆",31,"譧",4,"譭",25],["d780","讇",24,"讬讱讻诇诐诪谉谞住注祝驻抓爪拽专砖转撰赚篆桩庄装妆撞壮状椎锥追赘坠缀谆准捉拙卓桌琢茁酌啄着灼浊兹咨资姿滋淄孜紫仔籽滓子自渍字鬃棕踪宗综总纵邹走奏揍租足卒族祖诅阻组钻纂嘴醉最罪尊遵昨左佐柞做作坐座"],["d840","谸",8,"豂豃豄豅豈豊豋豍",7,"豖豗豘豙豛",5,"豣",6,"豬",6,"豴豵豶豷豻",6,"貃貄貆貇"],["d880","貈貋貍",6,"貕貖貗貙",20,"亍丌兀丐廿卅丕亘丞鬲孬噩丨禺丿匕乇夭爻卮氐囟胤馗毓睾鼗丶亟鼐乜乩亓芈孛啬嘏仄厍厝厣厥厮靥赝匚叵匦匮匾赜卦卣刂刈刎刭刳刿剀剌剞剡剜蒯剽劂劁劐劓冂罔亻仃仉仂仨仡仫仞伛仳伢佤仵伥伧伉伫佞佧攸佚佝"],["d940","貮",62],["d980","賭",32,"佟佗伲伽佶佴侑侉侃侏佾佻侪佼侬侔俦俨俪俅俚俣俜俑俟俸倩偌俳倬倏倮倭俾倜倌倥倨偾偃偕偈偎偬偻傥傧傩傺僖儆僭僬僦僮儇儋仝氽佘佥俎龠汆籴兮巽黉馘冁夔勹匍訇匐凫夙兕亠兖亳衮袤亵脔裒禀嬴蠃羸冫冱冽冼"],["da40","贎",14,"贠赑赒赗赟赥赨赩赪赬赮赯赱赲赸",8,"趂趃趆趇趈趉趌",4,"趒趓趕",9,"趠趡"],["da80","趢趤",12,"趲趶趷趹趻趽跀跁跂跅跇跈跉跊跍跐跒跓跔凇冖冢冥讠讦讧讪讴讵讷诂诃诋诏诎诒诓诔诖诘诙诜诟诠诤诨诩诮诰诳诶诹诼诿谀谂谄谇谌谏谑谒谔谕谖谙谛谘谝谟谠谡谥谧谪谫谮谯谲谳谵谶卩卺阝阢阡阱阪阽阼陂陉陔陟陧陬陲陴隈隍隗隰邗邛邝邙邬邡邴邳邶邺"],["db40","跕跘跙跜跠跡跢跥跦跧跩跭跮跰跱跲跴跶跼跾",6,"踆踇踈踋踍踎踐踑踒踓踕",7,"踠踡踤",4,"踫踭踰踲踳踴踶踷踸踻踼踾"],["db80","踿蹃蹅蹆蹌",4,"蹓",5,"蹚",11,"蹧蹨蹪蹫蹮蹱邸邰郏郅邾郐郄郇郓郦郢郜郗郛郫郯郾鄄鄢鄞鄣鄱鄯鄹酃酆刍奂劢劬劭劾哿勐勖勰叟燮矍廴凵凼鬯厶弁畚巯坌垩垡塾墼壅壑圩圬圪圳圹圮圯坜圻坂坩垅坫垆坼坻坨坭坶坳垭垤垌垲埏垧垴垓垠埕埘埚埙埒垸埴埯埸埤埝"],["dc40","蹳蹵蹷",4,"蹽蹾躀躂躃躄躆躈",6,"躑躒躓躕",6,"躝躟",11,"躭躮躰躱躳",6,"躻",7],["dc80","軃",10,"軏",21,"堋堍埽埭堀堞堙塄堠塥塬墁墉墚墀馨鼙懿艹艽艿芏芊芨芄芎芑芗芙芫芸芾芰苈苊苣芘芷芮苋苌苁芩芴芡芪芟苄苎芤苡茉苷苤茏茇苜苴苒苘茌苻苓茑茚茆茔茕苠苕茜荑荛荜茈莒茼茴茱莛荞茯荏荇荃荟荀茗荠茭茺茳荦荥"],["dd40","軥",62],["dd80","輤",32,"荨茛荩荬荪荭荮莰荸莳莴莠莪莓莜莅荼莶莩荽莸荻莘莞莨莺莼菁萁菥菘堇萘萋菝菽菖萜萸萑萆菔菟萏萃菸菹菪菅菀萦菰菡葜葑葚葙葳蒇蒈葺蒉葸萼葆葩葶蒌蒎萱葭蓁蓍蓐蓦蒽蓓蓊蒿蒺蓠蒡蒹蒴蒗蓥蓣蔌甍蔸蓰蔹蔟蔺"],["de40","轅",32,"轪辀辌辒辝辠辡辢辤辥辦辧辪辬辭辮辯農辳辴辵辷辸辺辻込辿迀迃迆"],["de80","迉",4,"迏迒迖迗迚迠迡迣迧迬迯迱迲迴迵迶迺迻迼迾迿逇逈逌逎逓逕逘蕖蔻蓿蓼蕙蕈蕨蕤蕞蕺瞢蕃蕲蕻薤薨薇薏蕹薮薜薅薹薷薰藓藁藜藿蘧蘅蘩蘖蘼廾弈夼奁耷奕奚奘匏尢尥尬尴扌扪抟抻拊拚拗拮挢拶挹捋捃掭揶捱捺掎掴捭掬掊捩掮掼揲揸揠揿揄揞揎摒揆掾摅摁搋搛搠搌搦搡摞撄摭撖"],["df40","這逜連逤逥逧",5,"逰",4,"逷逹逺逽逿遀遃遅遆遈",4,"過達違遖遙遚遜",5,"遤遦遧適遪遫遬遯",4,"遶",6,"遾邁"],["df80","還邅邆邇邉邊邌",4,"邒邔邖邘邚邜邞邟邠邤邥邧邨邩邫邭邲邷邼邽邿郀摺撷撸撙撺擀擐擗擤擢攉攥攮弋忒甙弑卟叱叽叩叨叻吒吖吆呋呒呓呔呖呃吡呗呙吣吲咂咔呷呱呤咚咛咄呶呦咝哐咭哂咴哒咧咦哓哔呲咣哕咻咿哌哙哚哜咩咪咤哝哏哞唛哧唠哽唔哳唢唣唏唑唧唪啧喏喵啉啭啁啕唿啐唼"],["e040","郂郃郆郈郉郋郌郍郒郔郕郖郘郙郚郞郟郠郣郤郥郩郪郬郮郰郱郲郳郵郶郷郹郺郻郼郿鄀鄁鄃鄅",19,"鄚鄛鄜"],["e080","鄝鄟鄠鄡鄤",10,"鄰鄲",6,"鄺",8,"酄唷啖啵啶啷唳唰啜喋嗒喃喱喹喈喁喟啾嗖喑啻嗟喽喾喔喙嗪嗷嗉嘟嗑嗫嗬嗔嗦嗝嗄嗯嗥嗲嗳嗌嗍嗨嗵嗤辔嘞嘈嘌嘁嘤嘣嗾嘀嘧嘭噘嘹噗嘬噍噢噙噜噌噔嚆噤噱噫噻噼嚅嚓嚯囔囗囝囡囵囫囹囿圄圊圉圜帏帙帔帑帱帻帼"],["e140","酅酇酈酑酓酔酕酖酘酙酛酜酟酠酦酧酨酫酭酳酺酻酼醀",4,"醆醈醊醎醏醓",6,"醜",5,"醤",5,"醫醬醰醱醲醳醶醷醸醹醻"],["e180","醼",10,"釈釋釐釒",9,"針",8,"帷幄幔幛幞幡岌屺岍岐岖岈岘岙岑岚岜岵岢岽岬岫岱岣峁岷峄峒峤峋峥崂崃崧崦崮崤崞崆崛嵘崾崴崽嵬嵛嵯嵝嵫嵋嵊嵩嵴嶂嶙嶝豳嶷巅彳彷徂徇徉後徕徙徜徨徭徵徼衢彡犭犰犴犷犸狃狁狎狍狒狨狯狩狲狴狷猁狳猃狺"],["e240","釦",62],["e280","鈥",32,"狻猗猓猡猊猞猝猕猢猹猥猬猸猱獐獍獗獠獬獯獾舛夥飧夤夂饣饧",5,"饴饷饽馀馄馇馊馍馐馑馓馔馕庀庑庋庖庥庠庹庵庾庳赓廒廑廛廨廪膺忄忉忖忏怃忮怄忡忤忾怅怆忪忭忸怙怵怦怛怏怍怩怫怊怿怡恸恹恻恺恂"],["e340","鉆",45,"鉵",16],["e380","銆",7,"銏",24,"恪恽悖悚悭悝悃悒悌悛惬悻悱惝惘惆惚悴愠愦愕愣惴愀愎愫慊慵憬憔憧憷懔懵忝隳闩闫闱闳闵闶闼闾阃阄阆阈阊阋阌阍阏阒阕阖阗阙阚丬爿戕氵汔汜汊沣沅沐沔沌汨汩汴汶沆沩泐泔沭泷泸泱泗沲泠泖泺泫泮沱泓泯泾"],["e440","銨",5,"銯",24,"鋉",31],["e480","鋩",32,"洹洧洌浃浈洇洄洙洎洫浍洮洵洚浏浒浔洳涑浯涞涠浞涓涔浜浠浼浣渚淇淅淞渎涿淠渑淦淝淙渖涫渌涮渫湮湎湫溲湟溆湓湔渲渥湄滟溱溘滠漭滢溥溧溽溻溷滗溴滏溏滂溟潢潆潇漤漕滹漯漶潋潴漪漉漩澉澍澌潸潲潼潺濑"],["e540","錊",51,"錿",10],["e580","鍊",31,"鍫濉澧澹澶濂濡濮濞濠濯瀚瀣瀛瀹瀵灏灞宀宄宕宓宥宸甯骞搴寤寮褰寰蹇謇辶迓迕迥迮迤迩迦迳迨逅逄逋逦逑逍逖逡逵逶逭逯遄遑遒遐遨遘遢遛暹遴遽邂邈邃邋彐彗彖彘尻咫屐屙孱屣屦羼弪弩弭艴弼鬻屮妁妃妍妩妪妣"],["e640","鍬",34,"鎐",27],["e680","鎬",29,"鏋鏌鏍妗姊妫妞妤姒妲妯姗妾娅娆姝娈姣姘姹娌娉娲娴娑娣娓婀婧婊婕娼婢婵胬媪媛婷婺媾嫫媲嫒嫔媸嫠嫣嫱嫖嫦嫘嫜嬉嬗嬖嬲嬷孀尕尜孚孥孳孑孓孢驵驷驸驺驿驽骀骁骅骈骊骐骒骓骖骘骛骜骝骟骠骢骣骥骧纟纡纣纥纨纩"],["e740","鏎",7,"鏗",54],["e780","鐎",32,"纭纰纾绀绁绂绉绋绌绐绔绗绛绠绡绨绫绮绯绱绲缍绶绺绻绾缁缂缃缇缈缋缌缏缑缒缗缙缜缛缟缡",6,"缪缫缬缭缯",4,"缵幺畿巛甾邕玎玑玮玢玟珏珂珑玷玳珀珉珈珥珙顼琊珩珧珞玺珲琏琪瑛琦琥琨琰琮琬"],["e840","鐯",14,"鐿",43,"鑬鑭鑮鑯"],["e880","鑰",20,"钑钖钘铇铏铓铔铚铦铻锜锠琛琚瑁瑜瑗瑕瑙瑷瑭瑾璜璎璀璁璇璋璞璨璩璐璧瓒璺韪韫韬杌杓杞杈杩枥枇杪杳枘枧杵枨枞枭枋杷杼柰栉柘栊柩枰栌柙枵柚枳柝栀柃枸柢栎柁柽栲栳桠桡桎桢桄桤梃栝桕桦桁桧桀栾桊桉栩梵梏桴桷梓桫棂楮棼椟椠棹"],["e940","锧锳锽镃镈镋镕镚镠镮镴镵長",7,"門",42],["e980","閫",32,"椤棰椋椁楗棣椐楱椹楠楂楝榄楫榀榘楸椴槌榇榈槎榉楦楣楹榛榧榻榫榭槔榱槁槊槟榕槠榍槿樯槭樗樘橥槲橄樾檠橐橛樵檎橹樽樨橘橼檑檐檩檗檫猷獒殁殂殇殄殒殓殍殚殛殡殪轫轭轱轲轳轵轶轸轷轹轺轼轾辁辂辄辇辋"],["ea40","闌",27,"闬闿阇阓阘阛阞阠阣",6,"阫阬阭阯阰阷阸阹阺阾陁陃陊陎陏陑陒陓陖陗"],["ea80","陘陙陚陜陝陞陠陣陥陦陫陭",4,"陳陸",12,"隇隉隊辍辎辏辘辚軎戋戗戛戟戢戡戥戤戬臧瓯瓴瓿甏甑甓攴旮旯旰昊昙杲昃昕昀炅曷昝昴昱昶昵耆晟晔晁晏晖晡晗晷暄暌暧暝暾曛曜曦曩贲贳贶贻贽赀赅赆赈赉赇赍赕赙觇觊觋觌觎觏觐觑牮犟牝牦牯牾牿犄犋犍犏犒挈挲掰"],["eb40","隌階隑隒隓隕隖隚際隝",9,"隨",7,"隱隲隴隵隷隸隺隻隿雂雃雈雊雋雐雑雓雔雖",9,"雡",6,"雫"],["eb80","雬雭雮雰雱雲雴雵雸雺電雼雽雿霂霃霅霊霋霌霐霑霒霔霕霗",4,"霝霟霠搿擘耄毪毳毽毵毹氅氇氆氍氕氘氙氚氡氩氤氪氲攵敕敫牍牒牖爰虢刖肟肜肓肼朊肽肱肫肭肴肷胧胨胩胪胛胂胄胙胍胗朐胝胫胱胴胭脍脎胲胼朕脒豚脶脞脬脘脲腈腌腓腴腙腚腱腠腩腼腽腭腧塍媵膈膂膑滕膣膪臌朦臊膻"],["ec40","霡",8,"霫霬霮霯霱霳",4,"霺霻霼霽霿",18,"靔靕靗靘靚靜靝靟靣靤靦靧靨靪",7],["ec80","靲靵靷",4,"靽",7,"鞆",4,"鞌鞎鞏鞐鞓鞕鞖鞗鞙",4,"臁膦欤欷欹歃歆歙飑飒飓飕飙飚殳彀毂觳斐齑斓於旆旄旃旌旎旒旖炀炜炖炝炻烀炷炫炱烨烊焐焓焖焯焱煳煜煨煅煲煊煸煺熘熳熵熨熠燠燔燧燹爝爨灬焘煦熹戾戽扃扈扉礻祀祆祉祛祜祓祚祢祗祠祯祧祺禅禊禚禧禳忑忐"],["ed40","鞞鞟鞡鞢鞤",6,"鞬鞮鞰鞱鞳鞵",46],["ed80","韤韥韨韮",4,"韴韷",23,"怼恝恚恧恁恙恣悫愆愍慝憩憝懋懑戆肀聿沓泶淼矶矸砀砉砗砘砑斫砭砜砝砹砺砻砟砼砥砬砣砩硎硭硖硗砦硐硇硌硪碛碓碚碇碜碡碣碲碹碥磔磙磉磬磲礅磴礓礤礞礴龛黹黻黼盱眄眍盹眇眈眚眢眙眭眦眵眸睐睑睇睃睚睨"],["ee40","頏",62],["ee80","顎",32,"睢睥睿瞍睽瞀瞌瞑瞟瞠瞰瞵瞽町畀畎畋畈畛畲畹疃罘罡罟詈罨罴罱罹羁罾盍盥蠲钅钆钇钋钊钌钍钏钐钔钗钕钚钛钜钣钤钫钪钭钬钯钰钲钴钶",4,"钼钽钿铄铈",6,"铐铑铒铕铖铗铙铘铛铞铟铠铢铤铥铧铨铪"],["ef40","顯",5,"颋颎颒颕颙颣風",37,"飏飐飔飖飗飛飜飝飠",4],["ef80","飥飦飩",30,"铩铫铮铯铳铴铵铷铹铼铽铿锃锂锆锇锉锊锍锎锏锒",4,"锘锛锝锞锟锢锪锫锩锬锱锲锴锶锷锸锼锾锿镂锵镄镅镆镉镌镎镏镒镓镔镖镗镘镙镛镞镟镝镡镢镤",8,"镯镱镲镳锺矧矬雉秕秭秣秫稆嵇稃稂稞稔"],["f040","餈",4,"餎餏餑",28,"餯",26],["f080","饊",9,"饖",12,"饤饦饳饸饹饻饾馂馃馉稹稷穑黏馥穰皈皎皓皙皤瓞瓠甬鸠鸢鸨",4,"鸲鸱鸶鸸鸷鸹鸺鸾鹁鹂鹄鹆鹇鹈鹉鹋鹌鹎鹑鹕鹗鹚鹛鹜鹞鹣鹦",6,"鹱鹭鹳疒疔疖疠疝疬疣疳疴疸痄疱疰痃痂痖痍痣痨痦痤痫痧瘃痱痼痿瘐瘀瘅瘌瘗瘊瘥瘘瘕瘙"],["f140","馌馎馚",10,"馦馧馩",47],["f180","駙",32,"瘛瘼瘢瘠癀瘭瘰瘿瘵癃瘾瘳癍癞癔癜癖癫癯翊竦穸穹窀窆窈窕窦窠窬窨窭窳衤衩衲衽衿袂袢裆袷袼裉裢裎裣裥裱褚裼裨裾裰褡褙褓褛褊褴褫褶襁襦襻疋胥皲皴矜耒耔耖耜耠耢耥耦耧耩耨耱耋耵聃聆聍聒聩聱覃顸颀颃"],["f240","駺",62],["f280","騹",32,"颉颌颍颏颔颚颛颞颟颡颢颥颦虍虔虬虮虿虺虼虻蚨蚍蚋蚬蚝蚧蚣蚪蚓蚩蚶蛄蚵蛎蚰蚺蚱蚯蛉蛏蚴蛩蛱蛲蛭蛳蛐蜓蛞蛴蛟蛘蛑蜃蜇蛸蜈蜊蜍蜉蜣蜻蜞蜥蜮蜚蜾蝈蜴蜱蜩蜷蜿螂蜢蝽蝾蝻蝠蝰蝌蝮螋蝓蝣蝼蝤蝙蝥螓螯螨蟒"],["f340","驚",17,"驲骃骉骍骎骔骕骙骦骩",6,"骲骳骴骵骹骻骽骾骿髃髄髆",4,"髍髎髏髐髒體髕髖髗髙髚髛髜"],["f380","髝髞髠髢髣髤髥髧髨髩髪髬髮髰",8,"髺髼",6,"鬄鬅鬆蟆螈螅螭螗螃螫蟥螬螵螳蟋蟓螽蟑蟀蟊蟛蟪蟠蟮蠖蠓蟾蠊蠛蠡蠹蠼缶罂罄罅舐竺竽笈笃笄笕笊笫笏筇笸笪笙笮笱笠笥笤笳笾笞筘筚筅筵筌筝筠筮筻筢筲筱箐箦箧箸箬箝箨箅箪箜箢箫箴篑篁篌篝篚篥篦篪簌篾篼簏簖簋"],["f440","鬇鬉",5,"鬐鬑鬒鬔",10,"鬠鬡鬢鬤",10,"鬰鬱鬳",7,"鬽鬾鬿魀魆魊魋魌魎魐魒魓魕",5],["f480","魛",32,"簟簪簦簸籁籀臾舁舂舄臬衄舡舢舣舭舯舨舫舸舻舳舴舾艄艉艋艏艚艟艨衾袅袈裘裟襞羝羟羧羯羰羲籼敉粑粝粜粞粢粲粼粽糁糇糌糍糈糅糗糨艮暨羿翎翕翥翡翦翩翮翳糸絷綦綮繇纛麸麴赳趄趔趑趱赧赭豇豉酊酐酎酏酤"],["f540","魼",62],["f580","鮻",32,"酢酡酰酩酯酽酾酲酴酹醌醅醐醍醑醢醣醪醭醮醯醵醴醺豕鹾趸跫踅蹙蹩趵趿趼趺跄跖跗跚跞跎跏跛跆跬跷跸跣跹跻跤踉跽踔踝踟踬踮踣踯踺蹀踹踵踽踱蹉蹁蹂蹑蹒蹊蹰蹶蹼蹯蹴躅躏躔躐躜躞豸貂貊貅貘貔斛觖觞觚觜"],["f640","鯜",62],["f680","鰛",32,"觥觫觯訾謦靓雩雳雯霆霁霈霏霎霪霭霰霾龀龃龅",5,"龌黾鼋鼍隹隼隽雎雒瞿雠銎銮鋈錾鍪鏊鎏鐾鑫鱿鲂鲅鲆鲇鲈稣鲋鲎鲐鲑鲒鲔鲕鲚鲛鲞",5,"鲥",4,"鲫鲭鲮鲰",7,"鲺鲻鲼鲽鳄鳅鳆鳇鳊鳋"],["f740","鰼",62],["f780","鱻鱽鱾鲀鲃鲄鲉鲊鲌鲏鲓鲖鲗鲘鲙鲝鲪鲬鲯鲹鲾",4,"鳈鳉鳑鳒鳚鳛鳠鳡鳌",4,"鳓鳔鳕鳗鳘鳙鳜鳝鳟鳢靼鞅鞑鞒鞔鞯鞫鞣鞲鞴骱骰骷鹘骶骺骼髁髀髅髂髋髌髑魅魃魇魉魈魍魑飨餍餮饕饔髟髡髦髯髫髻髭髹鬈鬏鬓鬟鬣麽麾縻麂麇麈麋麒鏖麝麟黛黜黝黠黟黢黩黧黥黪黯鼢鼬鼯鼹鼷鼽鼾齄"],["f840","鳣",62],["f880","鴢",32],["f940","鵃",62],["f980","鶂",32],["fa40","鶣",62],["fa80","鷢",32],["fb40","鸃",27,"鸤鸧鸮鸰鸴鸻鸼鹀鹍鹐鹒鹓鹔鹖鹙鹝鹟鹠鹡鹢鹥鹮鹯鹲鹴",9,"麀"],["fb80","麁麃麄麅麆麉麊麌",5,"麔",8,"麞麠",5,"麧麨麩麪"],["fc40","麫",8,"麵麶麷麹麺麼麿",4,"黅黆黇黈黊黋黌黐黒黓黕黖黗黙黚點黡黣黤黦黨黫黬黭黮黰",8,"黺黽黿",6],["fc80","鼆",4,"鼌鼏鼑鼒鼔鼕鼖鼘鼚",5,"鼡鼣",8,"鼭鼮鼰鼱"],["fd40","鼲",4,"鼸鼺鼼鼿",4,"齅",10,"齒",38],["fd80","齹",5,"龁龂龍",11,"龜龝龞龡",4,"郎凉秊裏隣"],["fe40","兀嗀﨎﨏﨑﨓﨔礼﨟蘒﨡﨣﨤﨧﨨﨩"]]')},19283:(e,t,a)=>{var o=t,r=a(87016),i=a(83480),n=a(76982),s=a(26815)(1e3);function hmac(e,t,a){return n.createHmac("sha256",e).update(t,"utf8").digest(a)}function hash(e,t){return n.createHash("sha256").update(e,"utf8").digest(t)}function encodeRfc3986(e){return e.replace(/[!'()*]/g,function(e){return"%"+e.charCodeAt(0).toString(16).toUpperCase()})}function encodeRfc3986Full(e){return encodeRfc3986(encodeURIComponent(e))}var c={authorization:!0,connection:!0,"x-amzn-trace-id":!0,"user-agent":!0,expect:!0,"presigned-expires":!0,range:!0};function RequestSigner(e,t){"string"==typeof e&&(e=r.parse(e));var a=e.headers=Object.assign({},e.headers||{}),o=(!this.service||!this.region)&&this.matchHost(e.hostname||e.host||a.Host||a.host);this.request=e,this.credentials=t||this.defaultCredentials(),this.service=e.service||o[0]||"",this.region=e.region||o[1]||"us-east-1","email"===this.service&&(this.service="ses"),!e.method&&e.body&&(e.method="POST"),a.Host||a.host||(a.Host=e.hostname||e.host||this.createHost(),e.port&&(a.Host+=":"+e.port)),e.hostname||e.host||(e.hostname=a.Host||a.host),this.isCodeCommitGit="codecommit"===this.service&&"GIT"===e.method,this.extraHeadersToIgnore=e.extraHeadersToIgnore||Object.create(null),this.extraHeadersToInclude=e.extraHeadersToInclude||Object.create(null)}RequestSigner.prototype.matchHost=function(e){var t=((e||"").match(/([^\.]{1,63})\.(?:([^\.]{0,63})\.)?amazonaws\.com(\.cn)?$/)||[]).slice(1,3);if("es"!==t[1]&&"aoss"!==t[1]||(t=t.reverse()),"s3"==t[1])t[0]="s3",t[1]="us-east-1";else for(var a=0;a<2;a++)if(/^s3-/.test(t[a])){t[1]=t[a].slice(3),t[0]="s3";break}return t},RequestSigner.prototype.isSingleRegion=function(){return["s3","sdb"].indexOf(this.service)>=0&&"us-east-1"===this.region||["cloudfront","ls","route53","iam","importexport","sts"].indexOf(this.service)>=0},RequestSigner.prototype.createHost=function(){var e=this.isSingleRegion()?"":"."+this.region;return("ses"===this.service?"email":this.service)+e+".amazonaws.com"},RequestSigner.prototype.prepareRequest=function(){this.parsePath();var e,t=this.request,a=t.headers;t.signQuery?(this.parsedPath.query=e=this.parsedPath.query||{},this.credentials.sessionToken&&(e["X-Amz-Security-Token"]=this.credentials.sessionToken),"s3"!==this.service||e["X-Amz-Expires"]||(e["X-Amz-Expires"]=86400),e["X-Amz-Date"]?this.datetime=e["X-Amz-Date"]:e["X-Amz-Date"]=this.getDateTime(),e["X-Amz-Algorithm"]="AWS4-HMAC-SHA256",e["X-Amz-Credential"]=this.credentials.accessKeyId+"/"+this.credentialString(),e["X-Amz-SignedHeaders"]=this.signedHeaders()):(t.doNotModifyHeaders||this.isCodeCommitGit||(!t.body||a["Content-Type"]||a["content-type"]||(a["Content-Type"]="application/x-www-form-urlencoded; charset=utf-8"),!t.body||a["Content-Length"]||a["content-length"]||(a["Content-Length"]=Buffer.byteLength(t.body)),!this.credentials.sessionToken||a["X-Amz-Security-Token"]||a["x-amz-security-token"]||(a["X-Amz-Security-Token"]=this.credentials.sessionToken),"s3"!==this.service||a["X-Amz-Content-Sha256"]||a["x-amz-content-sha256"]||(a["X-Amz-Content-Sha256"]=hash(this.request.body||"","hex")),a["X-Amz-Date"]||a["x-amz-date"]?this.datetime=a["X-Amz-Date"]||a["x-amz-date"]:a["X-Amz-Date"]=this.getDateTime()),delete a.Authorization,delete a.authorization)},RequestSigner.prototype.sign=function(){return this.parsedPath||this.prepareRequest(),this.request.signQuery?this.parsedPath.query["X-Amz-Signature"]=this.signature():this.request.headers.Authorization=this.authHeader(),this.request.path=this.formatPath(),this.request},RequestSigner.prototype.getDateTime=function(){if(!this.datetime){var e=this.request.headers,t=new Date(e.Date||e.date||new Date);this.datetime=t.toISOString().replace(/[:\-]|\.\d{3}/g,""),this.isCodeCommitGit&&(this.datetime=this.datetime.slice(0,-1))}return this.datetime},RequestSigner.prototype.getDate=function(){return this.getDateTime().substr(0,8)},RequestSigner.prototype.authHeader=function(){return["AWS4-HMAC-SHA256 Credential="+this.credentials.accessKeyId+"/"+this.credentialString(),"SignedHeaders="+this.signedHeaders(),"Signature="+this.signature()].join(", ")},RequestSigner.prototype.signature=function(){var e,t,a,o=this.getDate(),r=[this.credentials.secretAccessKey,o,this.region,this.service].join(),i=s.get(r);return i||(e=hmac("AWS4"+this.credentials.secretAccessKey,o),t=hmac(e,this.region),a=hmac(t,this.service),i=hmac(a,"aws4_request"),s.set(r,i)),hmac(i,this.stringToSign(),"hex")},RequestSigner.prototype.stringToSign=function(){return["AWS4-HMAC-SHA256",this.getDateTime(),this.credentialString(),hash(this.canonicalString(),"hex")].join("\n")},RequestSigner.prototype.canonicalString=function(){this.parsedPath||this.prepareRequest();var e,t=this.parsedPath.path,a=this.parsedPath.query,o=this.request.headers,r="",i="s3"!==this.service,n="s3"===this.service||this.request.doNotEncodePath,s="s3"===this.service,c="s3"===this.service;if(e="s3"===this.service&&this.request.signQuery?"UNSIGNED-PAYLOAD":this.isCodeCommitGit?"":o["X-Amz-Content-Sha256"]||o["x-amz-content-sha256"]||hash(this.request.body||"","hex"),a){var p=Object.keys(a).reduce(function(e,t){return t?(e[encodeRfc3986Full(t)]=Array.isArray(a[t])&&c?a[t][0]:a[t],e):e},{}),u=[];Object.keys(p).sort().forEach(function(e){Array.isArray(p[e])?p[e].map(encodeRfc3986Full).sort().forEach(function(t){u.push(e+"="+t)}):u.push(e+"="+encodeRfc3986Full(p[e]))}),r=u.join("&")}return"/"!==t&&(i&&(t=t.replace(/\/{2,}/g,"/")),"/"!==(t=t.split("/").reduce(function(e,t){return i&&".."===t?e.pop():i&&"."===t||(n&&(t=decodeURIComponent(t.replace(/\+/g," "))),e.push(encodeRfc3986Full(t))),e},[]).join("/"))[0]&&(t="/"+t),s&&(t=t.replace(/%2F/g,"/"))),[this.request.method||"GET",t,r,this.canonicalHeaders()+"\n",this.signedHeaders(),e].join("\n")},RequestSigner.prototype.filterHeaders=function(){var e=this.request.headers,t=this.extraHeadersToInclude,a=this.extraHeadersToIgnore;this.filteredHeaders=Object.keys(e).map(function(t){return[t.toLowerCase(),e[t]]}).filter(function(e){return t[e[0]]||null==c[e[0]]&&!a[e[0]]}).sort(function(e,t){return e[0]<t[0]?-1:1})},RequestSigner.prototype.canonicalHeaders=function(){return this.filteredHeaders||this.filterHeaders(),this.filteredHeaders.map(function(e){return e[0]+":"+e[1].toString().trim().replace(/\s+/g," ")}).join("\n")},RequestSigner.prototype.signedHeaders=function(){return this.filteredHeaders||this.filterHeaders(),this.filteredHeaders.map(function(e){return e[0]}).join(";")},RequestSigner.prototype.credentialString=function(){return[this.getDate(),this.region,this.service,"aws4_request"].join("/")},RequestSigner.prototype.defaultCredentials=function(){var e=process.env;return{accessKeyId:e.AWS_ACCESS_KEY_ID||e.AWS_ACCESS_KEY,secretAccessKey:e.AWS_SECRET_ACCESS_KEY||e.AWS_SECRET_KEY,sessionToken:e.AWS_SESSION_TOKEN}},RequestSigner.prototype.parsePath=function(){var e=this.request.path||"/";/[^0-9A-Za-z;,/?:@&=+$\-_.!~*'()#%]/.test(e)&&(e=encodeURI(decodeURI(e)));var t=e.indexOf("?"),a=null;t>=0&&(a=i.parse(e.slice(t+1)),e=e.slice(0,t)),this.parsedPath={path:e,query:a}},RequestSigner.prototype.formatPath=function(){var e=this.parsedPath.path,t=this.parsedPath.query;return t?(null!=t[""]&&delete t[""],e+"?"+encodeRfc3986(i.stringify(t))):e},o.RequestSigner=RequestSigner,o.sign=function(e,t){return new RequestSigner(e,t).sign()}},19402:e=>{"use strict";var t=String.prototype.replace,a=/%20/g;e.exports={default:"RFC3986",formatters:{RFC1738:function(e){return t.call(e,a,"+")},RFC3986:function(e){return String(e)}},RFC1738:"RFC1738",RFC3986:"RFC3986"}},19500:e=>{e.exports=function state(e,t){var a=!Array.isArray(e),o={index:0,keyedList:a||t?Object.keys(e):null,jobs:{},results:a?{}:[],size:a?Object.keys(e).length:e.length};t&&o.keyedList.sort(a?t:function(a,o){return t(e[a],e[o])});return o}},19534:function(e,t){(function(){var t;function BigInteger(e,t,a){null!=e&&("number"==typeof e?this.fromNumber(e,t,a):null==t&&"string"!=typeof e?this.fromString(e,256):this.fromString(e,t))}function nbi(){return new BigInteger(null)}var a="undefined"!=typeof navigator;a&&"Microsoft Internet Explorer"==navigator.appName?(BigInteger.prototype.am=function am2(e,t,a,o,r,i){for(var n=32767&t,s=t>>15;--i>=0;){var c=32767&this[e],p=this[e++]>>15,u=s*c+p*n;r=((c=n*c+((32767&u)<<15)+a[o]+(1073741823&r))>>>30)+(u>>>15)+s*p+(r>>>30),a[o++]=1073741823&c}return r},t=30):a&&"Netscape"!=navigator.appName?(BigInteger.prototype.am=function am1(e,t,a,o,r,i){for(;--i>=0;){var n=t*this[e++]+a[o]+r;r=Math.floor(n/67108864),a[o++]=67108863&n}return r},t=26):(BigInteger.prototype.am=function am3(e,t,a,o,r,i){for(var n=16383&t,s=t>>14;--i>=0;){var c=16383&this[e],p=this[e++]>>14,u=s*c+p*n;r=((c=n*c+((16383&u)<<14)+a[o]+r)>>28)+(u>>14)+s*p,a[o++]=268435455&c}return r},t=28),BigInteger.prototype.DB=t,BigInteger.prototype.DM=(1<<t)-1,BigInteger.prototype.DV=1<<t;BigInteger.prototype.FV=Math.pow(2,52),BigInteger.prototype.F1=52-t,BigInteger.prototype.F2=2*t-52;var o,r,i=new Array;for(o="0".charCodeAt(0),r=0;r<=9;++r)i[o++]=r;for(o="a".charCodeAt(0),r=10;r<36;++r)i[o++]=r;for(o="A".charCodeAt(0),r=10;r<36;++r)i[o++]=r;function int2char(e){return"0123456789abcdefghijklmnopqrstuvwxyz".charAt(e)}function intAt(e,t){var a=i[e.charCodeAt(t)];return null==a?-1:a}function nbv(e){var t=nbi();return t.fromInt(e),t}function nbits(e){var t,a=1;return 0!=(t=e>>>16)&&(e=t,a+=16),0!=(t=e>>8)&&(e=t,a+=8),0!=(t=e>>4)&&(e=t,a+=4),0!=(t=e>>2)&&(e=t,a+=2),0!=(t=e>>1)&&(e=t,a+=1),a}function Classic(e){this.m=e}function Montgomery(e){this.m=e,this.mp=e.invDigit(),this.mpl=32767&this.mp,this.mph=this.mp>>15,this.um=(1<<e.DB-15)-1,this.mt2=2*e.t}function op_and(e,t){return e&t}function op_or(e,t){return e|t}function op_xor(e,t){return e^t}function op_andnot(e,t){return e&~t}function lbit(e){if(0==e)return-1;var t=0;return 65535&e||(e>>=16,t+=16),255&e||(e>>=8,t+=8),15&e||(e>>=4,t+=4),3&e||(e>>=2,t+=2),1&e||++t,t}function cbit(e){for(var t=0;0!=e;)e&=e-1,++t;return t}function NullExp(){}function nNop(e){return e}function Barrett(e){this.r2=nbi(),this.q3=nbi(),BigInteger.ONE.dlShiftTo(2*e.t,this.r2),this.mu=this.r2.divide(e),this.m=e}Classic.prototype.convert=function cConvert(e){return e.s<0||e.compareTo(this.m)>=0?e.mod(this.m):e},Classic.prototype.revert=function cRevert(e){return e},Classic.prototype.reduce=function cReduce(e){e.divRemTo(this.m,null,e)},Classic.prototype.mulTo=function cMulTo(e,t,a){e.multiplyTo(t,a),this.reduce(a)},Classic.prototype.sqrTo=function cSqrTo(e,t){e.squareTo(t),this.reduce(t)},Montgomery.prototype.convert=function montConvert(e){var t=nbi();return e.abs().dlShiftTo(this.m.t,t),t.divRemTo(this.m,null,t),e.s<0&&t.compareTo(BigInteger.ZERO)>0&&this.m.subTo(t,t),t},Montgomery.prototype.revert=function montRevert(e){var t=nbi();return e.copyTo(t),this.reduce(t),t},Montgomery.prototype.reduce=function montReduce(e){for(;e.t<=this.mt2;)e[e.t++]=0;for(var t=0;t<this.m.t;++t){var a=32767&e[t],o=a*this.mpl+((a*this.mph+(e[t]>>15)*this.mpl&this.um)<<15)&e.DM;for(e[a=t+this.m.t]+=this.m.am(0,o,e,t,0,this.m.t);e[a]>=e.DV;)e[a]-=e.DV,e[++a]++}e.clamp(),e.drShiftTo(this.m.t,e),e.compareTo(this.m)>=0&&e.subTo(this.m,e)},Montgomery.prototype.mulTo=function montMulTo(e,t,a){e.multiplyTo(t,a),this.reduce(a)},Montgomery.prototype.sqrTo=function montSqrTo(e,t){e.squareTo(t),this.reduce(t)},BigInteger.prototype.copyTo=function bnpCopyTo(e){for(var t=this.t-1;t>=0;--t)e[t]=this[t];e.t=this.t,e.s=this.s},BigInteger.prototype.fromInt=function bnpFromInt(e){this.t=1,this.s=e<0?-1:0,e>0?this[0]=e:e<-1?this[0]=e+this.DV:this.t=0},BigInteger.prototype.fromString=function bnpFromString(e,t){var a;if(16==t)a=4;else if(8==t)a=3;else if(256==t)a=8;else if(2==t)a=1;else if(32==t)a=5;else{if(4!=t)return void this.fromRadix(e,t);a=2}this.t=0,this.s=0;for(var o=e.length,r=!1,i=0;--o>=0;){var n=8==a?255&e[o]:intAt(e,o);n<0?"-"==e.charAt(o)&&(r=!0):(r=!1,0==i?this[this.t++]=n:i+a>this.DB?(this[this.t-1]|=(n&(1<<this.DB-i)-1)<<i,this[this.t++]=n>>this.DB-i):this[this.t-1]|=n<<i,(i+=a)>=this.DB&&(i-=this.DB))}8==a&&128&e[0]&&(this.s=-1,i>0&&(this[this.t-1]|=(1<<this.DB-i)-1<<i)),this.clamp(),r&&BigInteger.ZERO.subTo(this,this)},BigInteger.prototype.clamp=function bnpClamp(){for(var e=this.s&this.DM;this.t>0&&this[this.t-1]==e;)--this.t},BigInteger.prototype.dlShiftTo=function bnpDLShiftTo(e,t){var a;for(a=this.t-1;a>=0;--a)t[a+e]=this[a];for(a=e-1;a>=0;--a)t[a]=0;t.t=this.t+e,t.s=this.s},BigInteger.prototype.drShiftTo=function bnpDRShiftTo(e,t){for(var a=e;a<this.t;++a)t[a-e]=this[a];t.t=Math.max(this.t-e,0),t.s=this.s},BigInteger.prototype.lShiftTo=function bnpLShiftTo(e,t){var a,o=e%this.DB,r=this.DB-o,i=(1<<r)-1,n=Math.floor(e/this.DB),s=this.s<<o&this.DM;for(a=this.t-1;a>=0;--a)t[a+n+1]=this[a]>>r|s,s=(this[a]&i)<<o;for(a=n-1;a>=0;--a)t[a]=0;t[n]=s,t.t=this.t+n+1,t.s=this.s,t.clamp()},BigInteger.prototype.rShiftTo=function bnpRShiftTo(e,t){t.s=this.s;var a=Math.floor(e/this.DB);if(a>=this.t)t.t=0;else{var o=e%this.DB,r=this.DB-o,i=(1<<o)-1;t[0]=this[a]>>o;for(var n=a+1;n<this.t;++n)t[n-a-1]|=(this[n]&i)<<r,t[n-a]=this[n]>>o;o>0&&(t[this.t-a-1]|=(this.s&i)<<r),t.t=this.t-a,t.clamp()}},BigInteger.prototype.subTo=function bnpSubTo(e,t){for(var a=0,o=0,r=Math.min(e.t,this.t);a<r;)o+=this[a]-e[a],t[a++]=o&this.DM,o>>=this.DB;if(e.t<this.t){for(o-=e.s;a<this.t;)o+=this[a],t[a++]=o&this.DM,o>>=this.DB;o+=this.s}else{for(o+=this.s;a<e.t;)o-=e[a],t[a++]=o&this.DM,o>>=this.DB;o-=e.s}t.s=o<0?-1:0,o<-1?t[a++]=this.DV+o:o>0&&(t[a++]=o),t.t=a,t.clamp()},BigInteger.prototype.multiplyTo=function bnpMultiplyTo(e,t){var a=this.abs(),o=e.abs(),r=a.t;for(t.t=r+o.t;--r>=0;)t[r]=0;for(r=0;r<o.t;++r)t[r+a.t]=a.am(0,o[r],t,r,0,a.t);t.s=0,t.clamp(),this.s!=e.s&&BigInteger.ZERO.subTo(t,t)},BigInteger.prototype.squareTo=function bnpSquareTo(e){for(var t=this.abs(),a=e.t=2*t.t;--a>=0;)e[a]=0;for(a=0;a<t.t-1;++a){var o=t.am(a,t[a],e,2*a,0,1);(e[a+t.t]+=t.am(a+1,2*t[a],e,2*a+1,o,t.t-a-1))>=t.DV&&(e[a+t.t]-=t.DV,e[a+t.t+1]=1)}e.t>0&&(e[e.t-1]+=t.am(a,t[a],e,2*a,0,1)),e.s=0,e.clamp()},BigInteger.prototype.divRemTo=function bnpDivRemTo(e,t,a){var o=e.abs();if(!(o.t<=0)){var r=this.abs();if(r.t<o.t)return null!=t&&t.fromInt(0),void(null!=a&&this.copyTo(a));null==a&&(a=nbi());var i=nbi(),n=this.s,s=e.s,c=this.DB-nbits(o[o.t-1]);c>0?(o.lShiftTo(c,i),r.lShiftTo(c,a)):(o.copyTo(i),r.copyTo(a));var p=i.t,u=i[p-1];if(0!=u){var l=u*(1<<this.F1)+(p>1?i[p-2]>>this.F2:0),m=this.FV/l,f=(1<<this.F1)/l,h=1<<this.F2,g=a.t,y=g-p,b=null==t?nbi():t;for(i.dlShiftTo(y,b),a.compareTo(b)>=0&&(a[a.t++]=1,a.subTo(b,a)),BigInteger.ONE.dlShiftTo(p,b),b.subTo(i,i);i.t<p;)i[i.t++]=0;for(;--y>=0;){var x=a[--g]==u?this.DM:Math.floor(a[g]*m+(a[g-1]+h)*f);if((a[g]+=i.am(0,x,a,y,0,p))<x)for(i.dlShiftTo(y,b),a.subTo(b,a);a[g]<--x;)a.subTo(b,a)}null!=t&&(a.drShiftTo(p,t),n!=s&&BigInteger.ZERO.subTo(t,t)),a.t=p,a.clamp(),c>0&&a.rShiftTo(c,a),n<0&&BigInteger.ZERO.subTo(a,a)}}},BigInteger.prototype.invDigit=function bnpInvDigit(){if(this.t<1)return 0;var e=this[0];if(!(1&e))return 0;var t=3&e;return(t=(t=(t=(t=t*(2-(15&e)*t)&15)*(2-(255&e)*t)&255)*(2-((65535&e)*t&65535))&65535)*(2-e*t%this.DV)%this.DV)>0?this.DV-t:-t},BigInteger.prototype.isEven=function bnpIsEven(){return 0==(this.t>0?1&this[0]:this.s)},BigInteger.prototype.exp=function bnpExp(e,t){if(e>4294967295||e<1)return BigInteger.ONE;var a=nbi(),o=nbi(),r=t.convert(this),i=nbits(e)-1;for(r.copyTo(a);--i>=0;)if(t.sqrTo(a,o),(e&1<<i)>0)t.mulTo(o,r,a);else{var n=a;a=o,o=n}return t.revert(a)},BigInteger.prototype.toString=function bnToString(e){if(this.s<0)return"-"+this.negate().toString(e);var t;if(16==e)t=4;else if(8==e)t=3;else if(2==e)t=1;else if(32==e)t=5;else{if(4!=e)return this.toRadix(e);t=2}var a,o=(1<<t)-1,r=!1,i="",n=this.t,s=this.DB-n*this.DB%t;if(n-- >0)for(s<this.DB&&(a=this[n]>>s)>0&&(r=!0,i=int2char(a));n>=0;)s<t?(a=(this[n]&(1<<s)-1)<<t-s,a|=this[--n]>>(s+=this.DB-t)):(a=this[n]>>(s-=t)&o,s<=0&&(s+=this.DB,--n)),a>0&&(r=!0),r&&(i+=int2char(a));return r?i:"0"},BigInteger.prototype.negate=function bnNegate(){var e=nbi();return BigInteger.ZERO.subTo(this,e),e},BigInteger.prototype.abs=function bnAbs(){return this.s<0?this.negate():this},BigInteger.prototype.compareTo=function bnCompareTo(e){var t=this.s-e.s;if(0!=t)return t;var a=this.t;if(0!=(t=a-e.t))return this.s<0?-t:t;for(;--a>=0;)if(0!=(t=this[a]-e[a]))return t;return 0},BigInteger.prototype.bitLength=function bnBitLength(){return this.t<=0?0:this.DB*(this.t-1)+nbits(this[this.t-1]^this.s&this.DM)},BigInteger.prototype.mod=function bnMod(e){var t=nbi();return this.abs().divRemTo(e,null,t),this.s<0&&t.compareTo(BigInteger.ZERO)>0&&e.subTo(t,t),t},BigInteger.prototype.modPowInt=function bnModPowInt(e,t){var a;return a=e<256||t.isEven()?new Classic(t):new Montgomery(t),this.exp(e,a)},BigInteger.ZERO=nbv(0),BigInteger.ONE=nbv(1),NullExp.prototype.convert=nNop,NullExp.prototype.revert=nNop,NullExp.prototype.mulTo=function nMulTo(e,t,a){e.multiplyTo(t,a)},NullExp.prototype.sqrTo=function nSqrTo(e,t){e.squareTo(t)},Barrett.prototype.convert=function barrettConvert(e){if(e.s<0||e.t>2*this.m.t)return e.mod(this.m);if(e.compareTo(this.m)<0)return e;var t=nbi();return e.copyTo(t),this.reduce(t),t},Barrett.prototype.revert=function barrettRevert(e){return e},Barrett.prototype.reduce=function barrettReduce(e){for(e.drShiftTo(this.m.t-1,this.r2),e.t>this.m.t+1&&(e.t=this.m.t+1,e.clamp()),this.mu.multiplyUpperTo(this.r2,this.m.t+1,this.q3),this.m.multiplyLowerTo(this.q3,this.m.t+1,this.r2);e.compareTo(this.r2)<0;)e.dAddOffset(1,this.m.t+1);for(e.subTo(this.r2,e);e.compareTo(this.m)>=0;)e.subTo(this.m,e)},Barrett.prototype.mulTo=function barrettMulTo(e,t,a){e.multiplyTo(t,a),this.reduce(a)},Barrett.prototype.sqrTo=function barrettSqrTo(e,t){e.squareTo(t),this.reduce(t)};var n,s,c,p=[2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,947,953,967,971,977,983,991,997],u=(1<<26)/p[p.length-1];function rng_seed_time(){!function rng_seed_int(e){s[c++]^=255&e,s[c++]^=e>>8&255,s[c++]^=e>>16&255,s[c++]^=e>>24&255,c>=h&&(c-=h)}((new Date).getTime())}if(BigInteger.prototype.chunkSize=function bnpChunkSize(e){return Math.floor(Math.LN2*this.DB/Math.log(e))},BigInteger.prototype.toRadix=function bnpToRadix(e){if(null==e&&(e=10),0==this.signum()||e<2||e>36)return"0";var t=this.chunkSize(e),a=Math.pow(e,t),o=nbv(a),r=nbi(),i=nbi(),n="";for(this.divRemTo(o,r,i);r.signum()>0;)n=(a+i.intValue()).toString(e).substr(1)+n,r.divRemTo(o,r,i);return i.intValue().toString(e)+n},BigInteger.prototype.fromRadix=function bnpFromRadix(e,t){this.fromInt(0),null==t&&(t=10);for(var a=this.chunkSize(t),o=Math.pow(t,a),r=!1,i=0,n=0,s=0;s<e.length;++s){var c=intAt(e,s);c<0?"-"==e.charAt(s)&&0==this.signum()&&(r=!0):(n=t*n+c,++i>=a&&(this.dMultiply(o),this.dAddOffset(n,0),i=0,n=0))}i>0&&(this.dMultiply(Math.pow(t,i)),this.dAddOffset(n,0)),r&&BigInteger.ZERO.subTo(this,this)},BigInteger.prototype.fromNumber=function bnpFromNumber(e,t,a){if("number"==typeof t)if(e<2)this.fromInt(1);else for(this.fromNumber(e,a),this.testBit(e-1)||this.bitwiseTo(BigInteger.ONE.shiftLeft(e-1),op_or,this),this.isEven()&&this.dAddOffset(1,0);!this.isProbablePrime(t);)this.dAddOffset(2,0),this.bitLength()>e&&this.subTo(BigInteger.ONE.shiftLeft(e-1),this);else{var o=new Array,r=7&e;o.length=1+(e>>3),t.nextBytes(o),r>0?o[0]&=(1<<r)-1:o[0]=0,this.fromString(o,256)}},BigInteger.prototype.bitwiseTo=function bnpBitwiseTo(e,t,a){var o,r,i=Math.min(e.t,this.t);for(o=0;o<i;++o)a[o]=t(this[o],e[o]);if(e.t<this.t){for(r=e.s&this.DM,o=i;o<this.t;++o)a[o]=t(this[o],r);a.t=this.t}else{for(r=this.s&this.DM,o=i;o<e.t;++o)a[o]=t(r,e[o]);a.t=e.t}a.s=t(this.s,e.s),a.clamp()},BigInteger.prototype.changeBit=function bnpChangeBit(e,t){var a=BigInteger.ONE.shiftLeft(e);return this.bitwiseTo(a,t,a),a},BigInteger.prototype.addTo=function bnpAddTo(e,t){for(var a=0,o=0,r=Math.min(e.t,this.t);a<r;)o+=this[a]+e[a],t[a++]=o&this.DM,o>>=this.DB;if(e.t<this.t){for(o+=e.s;a<this.t;)o+=this[a],t[a++]=o&this.DM,o>>=this.DB;o+=this.s}else{for(o+=this.s;a<e.t;)o+=e[a],t[a++]=o&this.DM,o>>=this.DB;o+=e.s}t.s=o<0?-1:0,o>0?t[a++]=o:o<-1&&(t[a++]=this.DV+o),t.t=a,t.clamp()},BigInteger.prototype.dMultiply=function bnpDMultiply(e){this[this.t]=this.am(0,e-1,this,0,0,this.t),++this.t,this.clamp()},BigInteger.prototype.dAddOffset=function bnpDAddOffset(e,t){if(0!=e){for(;this.t<=t;)this[this.t++]=0;for(this[t]+=e;this[t]>=this.DV;)this[t]-=this.DV,++t>=this.t&&(this[this.t++]=0),++this[t]}},BigInteger.prototype.multiplyLowerTo=function bnpMultiplyLowerTo(e,t,a){var o,r=Math.min(this.t+e.t,t);for(a.s=0,a.t=r;r>0;)a[--r]=0;for(o=a.t-this.t;r<o;++r)a[r+this.t]=this.am(0,e[r],a,r,0,this.t);for(o=Math.min(e.t,t);r<o;++r)this.am(0,e[r],a,r,0,t-r);a.clamp()},BigInteger.prototype.multiplyUpperTo=function bnpMultiplyUpperTo(e,t,a){--t;var o=a.t=this.t+e.t-t;for(a.s=0;--o>=0;)a[o]=0;for(o=Math.max(t-this.t,0);o<e.t;++o)a[this.t+o-t]=this.am(t-o,e[o],a,0,0,this.t+o-t);a.clamp(),a.drShiftTo(1,a)},BigInteger.prototype.modInt=function bnpModInt(e){if(e<=0)return 0;var t=this.DV%e,a=this.s<0?e-1:0;if(this.t>0)if(0==t)a=this[0]%e;else for(var o=this.t-1;o>=0;--o)a=(t*a+this[o])%e;return a},BigInteger.prototype.millerRabin=function bnpMillerRabin(e){var t=this.subtract(BigInteger.ONE),a=t.getLowestSetBit();if(a<=0)return!1;var o=t.shiftRight(a);(e=e+1>>1)>p.length&&(e=p.length);for(var r=nbi(),i=0;i<e;++i){r.fromInt(p[Math.floor(Math.random()*p.length)]);var n=r.modPow(o,this);if(0!=n.compareTo(BigInteger.ONE)&&0!=n.compareTo(t)){for(var s=1;s++<a&&0!=n.compareTo(t);)if(0==(n=n.modPowInt(2,this)).compareTo(BigInteger.ONE))return!1;if(0!=n.compareTo(t))return!1}}return!0},BigInteger.prototype.clone=function bnClone(){var e=nbi();return this.copyTo(e),e},BigInteger.prototype.intValue=function bnIntValue(){if(this.s<0){if(1==this.t)return this[0]-this.DV;if(0==this.t)return-1}else{if(1==this.t)return this[0];if(0==this.t)return 0}return(this[1]&(1<<32-this.DB)-1)<<this.DB|this[0]},BigInteger.prototype.byteValue=function bnByteValue(){return 0==this.t?this.s:this[0]<<24>>24},BigInteger.prototype.shortValue=function bnShortValue(){return 0==this.t?this.s:this[0]<<16>>16},BigInteger.prototype.signum=function bnSigNum(){return this.s<0?-1:this.t<=0||1==this.t&&this[0]<=0?0:1},BigInteger.prototype.toByteArray=function bnToByteArray(){var e=this.t,t=new Array;t[0]=this.s;var a,o=this.DB-e*this.DB%8,r=0;if(e-- >0)for(o<this.DB&&(a=this[e]>>o)!=(this.s&this.DM)>>o&&(t[r++]=a|this.s<<this.DB-o);e>=0;)o<8?(a=(this[e]&(1<<o)-1)<<8-o,a|=this[--e]>>(o+=this.DB-8)):(a=this[e]>>(o-=8)&255,o<=0&&(o+=this.DB,--e)),128&a&&(a|=-256),0==r&&(128&this.s)!=(128&a)&&++r,(r>0||a!=this.s)&&(t[r++]=a);return t},BigInteger.prototype.equals=function bnEquals(e){return 0==this.compareTo(e)},BigInteger.prototype.min=function bnMin(e){return this.compareTo(e)<0?this:e},BigInteger.prototype.max=function bnMax(e){return this.compareTo(e)>0?this:e},BigInteger.prototype.and=function bnAnd(e){var t=nbi();return this.bitwiseTo(e,op_and,t),t},BigInteger.prototype.or=function bnOr(e){var t=nbi();return this.bitwiseTo(e,op_or,t),t},BigInteger.prototype.xor=function bnXor(e){var t=nbi();return this.bitwiseTo(e,op_xor,t),t},BigInteger.prototype.andNot=function bnAndNot(e){var t=nbi();return this.bitwiseTo(e,op_andnot,t),t},BigInteger.prototype.not=function bnNot(){for(var e=nbi(),t=0;t<this.t;++t)e[t]=this.DM&~this[t];return e.t=this.t,e.s=~this.s,e},BigInteger.prototype.shiftLeft=function bnShiftLeft(e){var t=nbi();return e<0?this.rShiftTo(-e,t):this.lShiftTo(e,t),t},BigInteger.prototype.shiftRight=function bnShiftRight(e){var t=nbi();return e<0?this.lShiftTo(-e,t):this.rShiftTo(e,t),t},BigInteger.prototype.getLowestSetBit=function bnGetLowestSetBit(){for(var e=0;e<this.t;++e)if(0!=this[e])return e*this.DB+lbit(this[e]);return this.s<0?this.t*this.DB:-1},BigInteger.prototype.bitCount=function bnBitCount(){for(var e=0,t=this.s&this.DM,a=0;a<this.t;++a)e+=cbit(this[a]^t);return e},BigInteger.prototype.testBit=function bnTestBit(e){var t=Math.floor(e/this.DB);return t>=this.t?0!=this.s:!!(this[t]&1<<e%this.DB)},BigInteger.prototype.setBit=function bnSetBit(e){return this.changeBit(e,op_or)},BigInteger.prototype.clearBit=function bnClearBit(e){return this.changeBit(e,op_andnot)},BigInteger.prototype.flipBit=function bnFlipBit(e){return this.changeBit(e,op_xor)},BigInteger.prototype.add=function bnAdd(e){var t=nbi();return this.addTo(e,t),t},BigInteger.prototype.subtract=function bnSubtract(e){var t=nbi();return this.subTo(e,t),t},BigInteger.prototype.multiply=function bnMultiply(e){var t=nbi();return this.multiplyTo(e,t),t},BigInteger.prototype.divide=function bnDivide(e){var t=nbi();return this.divRemTo(e,t,null),t},BigInteger.prototype.remainder=function bnRemainder(e){var t=nbi();return this.divRemTo(e,null,t),t},BigInteger.prototype.divideAndRemainder=function bnDivideAndRemainder(e){var t=nbi(),a=nbi();return this.divRemTo(e,t,a),new Array(t,a)},BigInteger.prototype.modPow=function bnModPow(e,t){var a,o,r=e.bitLength(),i=nbv(1);if(r<=0)return i;a=r<18?1:r<48?3:r<144?4:r<768?5:6,o=r<8?new Classic(t):t.isEven()?new Barrett(t):new Montgomery(t);var n=new Array,s=3,c=a-1,p=(1<<a)-1;if(n[1]=o.convert(this),a>1){var u=nbi();for(o.sqrTo(n[1],u);s<=p;)n[s]=nbi(),o.mulTo(u,n[s-2],n[s]),s+=2}var l,m,f=e.t-1,h=!0,g=nbi();for(r=nbits(e[f])-1;f>=0;){for(r>=c?l=e[f]>>r-c&p:(l=(e[f]&(1<<r+1)-1)<<c-r,f>0&&(l|=e[f-1]>>this.DB+r-c)),s=a;!(1&l);)l>>=1,--s;if((r-=s)<0&&(r+=this.DB,--f),h)n[l].copyTo(i),h=!1;else{for(;s>1;)o.sqrTo(i,g),o.sqrTo(g,i),s-=2;s>0?o.sqrTo(i,g):(m=i,i=g,g=m),o.mulTo(g,n[l],i)}for(;f>=0&&!(e[f]&1<<r);)o.sqrTo(i,g),m=i,i=g,g=m,--r<0&&(r=this.DB-1,--f)}return o.revert(i)},BigInteger.prototype.modInverse=function bnModInverse(e){var t=e.isEven();if(this.isEven()&&t||0==e.signum())return BigInteger.ZERO;for(var a=e.clone(),o=this.clone(),r=nbv(1),i=nbv(0),n=nbv(0),s=nbv(1);0!=a.signum();){for(;a.isEven();)a.rShiftTo(1,a),t?(r.isEven()&&i.isEven()||(r.addTo(this,r),i.subTo(e,i)),r.rShiftTo(1,r)):i.isEven()||i.subTo(e,i),i.rShiftTo(1,i);for(;o.isEven();)o.rShiftTo(1,o),t?(n.isEven()&&s.isEven()||(n.addTo(this,n),s.subTo(e,s)),n.rShiftTo(1,n)):s.isEven()||s.subTo(e,s),s.rShiftTo(1,s);a.compareTo(o)>=0?(a.subTo(o,a),t&&r.subTo(n,r),i.subTo(s,i)):(o.subTo(a,o),t&&n.subTo(r,n),s.subTo(i,s))}return 0!=o.compareTo(BigInteger.ONE)?BigInteger.ZERO:s.compareTo(e)>=0?s.subtract(e):s.signum()<0?(s.addTo(e,s),s.signum()<0?s.add(e):s):s},BigInteger.prototype.pow=function bnPow(e){return this.exp(e,new NullExp)},BigInteger.prototype.gcd=function bnGCD(e){var t=this.s<0?this.negate():this.clone(),a=e.s<0?e.negate():e.clone();if(t.compareTo(a)<0){var o=t;t=a,a=o}var r=t.getLowestSetBit(),i=a.getLowestSetBit();if(i<0)return t;for(r<i&&(i=r),i>0&&(t.rShiftTo(i,t),a.rShiftTo(i,a));t.signum()>0;)(r=t.getLowestSetBit())>0&&t.rShiftTo(r,t),(r=a.getLowestSetBit())>0&&a.rShiftTo(r,a),t.compareTo(a)>=0?(t.subTo(a,t),t.rShiftTo(1,t)):(a.subTo(t,a),a.rShiftTo(1,a));return i>0&&a.lShiftTo(i,a),a},BigInteger.prototype.isProbablePrime=function bnIsProbablePrime(e){var t,a=this.abs();if(1==a.t&&a[0]<=p[p.length-1]){for(t=0;t<p.length;++t)if(a[0]==p[t])return!0;return!1}if(a.isEven())return!1;for(t=1;t<p.length;){for(var o=p[t],r=t+1;r<p.length&&o<u;)o*=p[r++];for(o=a.modInt(o);t<r;)if(o%p[t++]==0)return!1}return a.millerRabin(e)},BigInteger.prototype.square=function bnSquare(){var e=nbi();return this.squareTo(e),e},BigInteger.prototype.Barrett=Barrett,null==s){var l;if(s=new Array,c=0,"undefined"!=typeof window&&window.crypto)if(window.crypto.getRandomValues){var m=new Uint8Array(32);for(window.crypto.getRandomValues(m),l=0;l<32;++l)s[c++]=m[l]}else if("Netscape"==navigator.appName&&navigator.appVersion<"5"){var f=window.crypto.random(32);for(l=0;l<f.length;++l)s[c++]=255&f.charCodeAt(l)}for(;c<h;)l=Math.floor(65536*Math.random()),s[c++]=l>>>8,s[c++]=255&l;c=0,rng_seed_time()}function rng_get_byte(){if(null==n){for(rng_seed_time(),(n=function prng_newstate(){return new Arcfour}()).init(s),c=0;c<s.length;++c)s[c]=0;c=0}return n.next()}function SecureRandom(){}function Arcfour(){this.i=0,this.j=0,this.S=new Array}SecureRandom.prototype.nextBytes=function rng_get_bytes(e){var t;for(t=0;t<e.length;++t)e[t]=rng_get_byte()},Arcfour.prototype.init=function ARC4init(e){var t,a,o;for(t=0;t<256;++t)this.S[t]=t;for(a=0,t=0;t<256;++t)a=a+this.S[t]+e[t%e.length]&255,o=this.S[t],this.S[t]=this.S[a],this.S[a]=o;this.i=0,this.j=0},Arcfour.prototype.next=function ARC4next(){var e;return this.i=this.i+1&255,this.j=this.j+this.S[this.i]&255,e=this.S[this.i],this.S[this.i]=this.S[this.j],this.S[this.j]=e,this.S[e+this.S[this.i]&255]};var h=256;BigInteger.SecureRandom=SecureRandom,BigInteger.BigInteger=BigInteger,e.exports=BigInteger}).call(this)},19584:e=>{"use strict";e.exports=JSON.parse('[["0","\\u0000",128],["a1","｡",62],["8140","　、。，．・：；？！゛゜´｀¨＾￣＿ヽヾゝゞ〃仝々〆〇ー―‐／＼～∥｜…‥‘’“”（）〔〕［］｛｝〈",9,"＋－±×"],["8180","÷＝≠＜＞≦≧∞∴♂♀°′″℃￥＄￠￡％＃＆＊＠§☆★○●◎◇◆□■△▲▽▼※〒→←↑↓〓"],["81b8","∈∋⊆⊇⊂⊃∪∩"],["81c8","∧∨￢⇒⇔∀∃"],["81da","∠⊥⌒∂∇≡≒≪≫√∽∝∵∫∬"],["81f0","Å‰♯♭♪†‡¶"],["81fc","◯"],["824f","０",9],["8260","Ａ",25],["8281","ａ",25],["829f","ぁ",82],["8340","ァ",62],["8380","ム",22],["839f","Α",16,"Σ",6],["83bf","α",16,"σ",6],["8440","А",5,"ЁЖ",25],["8470","а",5,"ёж",7],["8480","о",17],["849f","─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂"],["8740","①",19,"Ⅰ",9],["875f","㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㎡"],["877e","㍻"],["8780","〝〟№㏍℡㊤",4,"㈱㈲㈹㍾㍽㍼≒≡∫∮∑√⊥∠∟⊿∵∩∪"],["889f","亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭"],["8940","院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円"],["8980","園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改"],["8a40","魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫"],["8a80","橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄"],["8b40","機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救"],["8b80","朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈"],["8c40","掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨"],["8c80","劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向"],["8d40","后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降"],["8d80","項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷"],["8e40","察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止"],["8e80","死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周"],["8f40","宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳"],["8f80","準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾"],["9040","拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨"],["9080","逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線"],["9140","繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻"],["9180","操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只"],["9240","叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄"],["9280","逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓"],["9340","邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬"],["9380","凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入"],["9440","如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅"],["9480","楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美"],["9540","鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷"],["9580","斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋"],["9640","法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆"],["9680","摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉愈油癒"],["9740","諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲"],["9780","沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯"],["9840","蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕"],["989f","弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲"],["9940","僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭"],["9980","凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨"],["9a40","咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸"],["9a80","噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩"],["9b40","奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀"],["9b80","它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏"],["9c40","廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠"],["9c80","怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛"],["9d40","戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫"],["9d80","捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼"],["9e40","曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎"],["9e80","梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘椢椦棡椌棍棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣"],["9f40","檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯"],["9f80","麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌"],["e040","漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝"],["e080","烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱"],["e140","瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿"],["e180","痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬"],["e240","磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰"],["e280","窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆"],["e340","紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷"],["e380","縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋"],["e440","隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤"],["e480","艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈"],["e540","蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬"],["e580","蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞"],["e640","襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧"],["e680","諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊"],["e740","蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜"],["e780","轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮"],["e840","錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙"],["e880","閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰"],["e940","顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃"],["e980","騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈"],["ea40","鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯"],["ea80","黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠堯槇遙瑤凜熙"],["ed40","纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏"],["ed80","塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱"],["ee40","犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙"],["ee80","蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑"],["eeef","ⅰ",9,"￢￤＇＂"],["f040","",62],["f080","",124],["f140","",62],["f180","",124],["f240","",62],["f280","",124],["f340","",62],["f380","",124],["f440","",62],["f480","",124],["f540","",62],["f580","",124],["f640","",62],["f680","",124],["f740","",62],["f780","",124],["f840","",62],["f880","",124],["f940",""],["fa40","ⅰ",9,"Ⅰ",9,"￢￤＇＂㈱№℡∵纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊"],["fa80","兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯"],["fb40","涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神"],["fb80","祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙"],["fc40","髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑"]]')},19625:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.default={isFunction:e=>"function"==typeof e,isString:e=>"string"==typeof e,isUndefined:e=>void 0===e}},19628:(e,t,a)=>{"use strict";const o=a(53908),r=a(78311);e.exports=(e,t,a)=>{let i=null,n=null,s=null;try{s=new r(t,a)}catch(e){return null}return e.forEach(e=>{s.test(e)&&(i&&-1!==n.compare(e)||(i=e,n=new o(i,a)))}),i}},19642:e=>{"use strict";e.exports=JSON.parse('{"uChars":[128,165,169,178,184,216,226,235,238,244,248,251,253,258,276,284,300,325,329,334,364,463,465,467,469,471,473,475,477,506,594,610,712,716,730,930,938,962,970,1026,1104,1106,8209,8215,8218,8222,8231,8241,8244,8246,8252,8365,8452,8454,8458,8471,8482,8556,8570,8596,8602,8713,8720,8722,8726,8731,8737,8740,8742,8748,8751,8760,8766,8777,8781,8787,8802,8808,8816,8854,8858,8870,8896,8979,9322,9372,9548,9588,9616,9622,9634,9652,9662,9672,9676,9680,9702,9735,9738,9793,9795,11906,11909,11913,11917,11928,11944,11947,11951,11956,11960,11964,11979,12284,12292,12312,12319,12330,12351,12436,12447,12535,12543,12586,12842,12850,12964,13200,13215,13218,13253,13263,13267,13270,13384,13428,13727,13839,13851,14617,14703,14801,14816,14964,15183,15471,15585,16471,16736,17208,17325,17330,17374,17623,17997,18018,18212,18218,18301,18318,18760,18811,18814,18820,18823,18844,18848,18872,19576,19620,19738,19887,40870,59244,59336,59367,59413,59417,59423,59431,59437,59443,59452,59460,59478,59493,63789,63866,63894,63976,63986,64016,64018,64021,64025,64034,64037,64042,65074,65093,65107,65112,65127,65132,65375,65510,65536],"gbChars":[0,36,38,45,50,81,89,95,96,100,103,104,105,109,126,133,148,172,175,179,208,306,307,308,309,310,311,312,313,341,428,443,544,545,558,741,742,749,750,805,819,820,7922,7924,7925,7927,7934,7943,7944,7945,7950,8062,8148,8149,8152,8164,8174,8236,8240,8262,8264,8374,8380,8381,8384,8388,8390,8392,8393,8394,8396,8401,8406,8416,8419,8424,8437,8439,8445,8482,8485,8496,8521,8603,8936,8946,9046,9050,9063,9066,9076,9092,9100,9108,9111,9113,9131,9162,9164,9218,9219,11329,11331,11334,11336,11346,11361,11363,11366,11370,11372,11375,11389,11682,11686,11687,11692,11694,11714,11716,11723,11725,11730,11736,11982,11989,12102,12336,12348,12350,12384,12393,12395,12397,12510,12553,12851,12962,12973,13738,13823,13919,13933,14080,14298,14585,14698,15583,15847,16318,16434,16438,16481,16729,17102,17122,17315,17320,17402,17418,17859,17909,17911,17915,17916,17936,17939,17961,18664,18703,18814,18962,19043,33469,33470,33471,33484,33485,33490,33497,33501,33505,33513,33520,33536,33550,37845,37921,37948,38029,38038,38064,38065,38066,38069,38075,38076,38078,39108,39109,39113,39114,39115,39116,39265,39394,189000]}')},19713:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(94227),i={keyword:"propertyNames",type:"object",schemaType:["object","boolean"],error:{message:({params:e})=>o.str`property name '${e.propertyName}' is invalid`,params:({params:e})=>o._`{propertyName: ${e.propertyName}}`},code(e){const{gen:t,schema:a,data:i,it:n}=e;if(r.alwaysValidSchema(n,a))return;const s=t.name("valid");t.forIn("key",i,a=>{e.setParams({propertyName:a}),e.subschema({keyword:"propertyNames",data:a,dataTypes:["string"],propertyName:a,compositeRule:!0},s),t.if(o.not(s),()=>{e.error(!0),n.allErrors||t.break()})}),e.ok(s)}};t.default=i},20181:e=>{"use strict";e.exports=require("buffer")},20439:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Completable=t.McpZodTypeKind=void 0,t.completable=function completable(e,t){return Completable.create(e,{...e._def,complete:t})};const o=a(21614);var r;!function(e){e.Completable="McpCompletable"}(r||(t.McpZodTypeKind=r={}));class Completable extends o.ZodType{_parse(e){const{ctx:t}=this._processInputParams(e),a=t.data;return this._def.type._parse({data:a,path:t.path,parent:t})}unwrap(){return this._def.type}}function processCreateParams(e){if(!e)return{};const{errorMap:t,invalid_type_error:a,required_error:o,description:r}=e;if(t&&(a||o))throw new Error('Can\'t use "invalid_type_error" or "required_error" in conjunction with custom error map.');if(t)return{errorMap:t,description:r};return{errorMap:(t,r)=>{var i,n;const{message:s}=e;return"invalid_enum_value"===t.code?{message:null!=s?s:r.defaultError}:void 0===r.data?{message:null!==(i=null!=s?s:o)&&void 0!==i?i:r.defaultError}:"invalid_type"!==t.code?{message:r.defaultError}:{message:null!==(n=null!=s?s:a)&&void 0!==n?n:r.defaultError}},description:r}}t.Completable=Completable,Completable.create=(e,t)=>new Completable({type:e,typeName:r.Completable,complete:t.complete,...processCreateParams(t)})},20494:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(94227),i=a(62586),n=a(15765),s={keyword:"items",type:"array",schemaType:["object","array","boolean"],before:"uniqueItems",code(e){const{gen:t,schema:a,it:s}=e;if(Array.isArray(a))s.opts.unevaluated&&a.length&&!0!==s.items&&(s.items=r.mergeEvaluated.items(t,a.length,s.items)),function validateTuple(a){const{parentSchema:n,data:c}=e;if(s.opts.strictTuples&&!function fullTupleSchema(e,t){return e===t.minItems&&(e===t.maxItems||!1===t.additionalItems)}(a.length,n)){const e=`"items" is ${a.length}-tuple, but minItems or maxItems/additionalItems are not specified or different`;i.checkStrictMode(s,e,s.opts.strictTuples)}const p=t.name("valid"),u=t.const("len",o._`${c}.length`);a.forEach((a,i)=>{r.alwaysValidSchema(s,a)||(t.if(o._`${u} > ${i}`,()=>e.subschema({keyword:"items",schemaProp:i,dataProp:i},p)),e.ok(p))})}(a);else{if(s.items=!0,r.alwaysValidSchema(s,a))return;e.ok(n.validateArray(e))}}};t.default=s},20544:function(e,t,a){"use strict";var o=this&&this.__createBinding||(Object.create?function(e,t,a,o){void 0===o&&(o=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,o,r)}:function(e,t,a,o){void 0===o&&(o=a),e[o]=t[a]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&o(t,e,a);return r(t,e),t};Object.defineProperty(t,"__esModule",{value:!0}),t.req=t.json=t.toBuffer=void 0;const n=i(a(58611)),s=i(a(65692));async function toBuffer(e){let t=0;const a=[];for await(const o of e)t+=o.length,a.push(o);return Buffer.concat(a,t)}t.toBuffer=toBuffer,t.json=async function json(e){const t=(await toBuffer(e)).toString("utf8");try{return JSON.parse(t)}catch(e){const a=e;throw a.message+=` (input: ${t})`,a}},t.req=function req(e,t={}){const a=(("string"==typeof e?e:e.href).startsWith("https:")?s:n).request(e,t),o=new Promise((e,t)=>{a.once("response",e).once("error",t).end()});return a.then=o.then.bind(o),a}},20780:e=>{"use strict";var t=e.exports=function Cache(){this._cache={}};t.prototype.put=function Cache_put(e,t){this._cache[e]=t},t.prototype.get=function Cache_get(e){return this._cache[e]},t.prototype.del=function Cache_del(e){delete this._cache[e]},t.prototype.clear=function Cache_clear(){this._cache={}}},20802:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0})},20917:function(e,t,a){"use strict";var o=this&&this.__createBinding||(Object.create?function(e,t,a,o){void 0===o&&(o=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,o,r)}:function(e,t,a,o){void 0===o&&(o=a),e[o]=t[a]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&o(t,e,a);return r(t,e),t},n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||o(t,e,a)};Object.defineProperty(t,"__esModule",{value:!0}),t.Agent=void 0;const s=i(a(69278)),c=i(a(58611)),p=a(65692);n(a(20544),t);const u=Symbol("AgentBaseInternalState");class Agent extends c.Agent{constructor(e){super(e),this[u]={}}isSecureEndpoint(e){if(e){if("boolean"==typeof e.secureEndpoint)return e.secureEndpoint;if("string"==typeof e.protocol)return"https:"===e.protocol}const{stack:t}=new Error;return"string"==typeof t&&t.split("\n").some(e=>-1!==e.indexOf("(https.js:")||-1!==e.indexOf("node:https:"))}incrementSockets(e){if(this.maxSockets===1/0&&this.maxTotalSockets===1/0)return null;this.sockets[e]||(this.sockets[e]=[]);const t=new s.Socket({writable:!1});return this.sockets[e].push(t),this.totalSocketCount++,t}decrementSockets(e,t){if(!this.sockets[e]||null===t)return;const a=this.sockets[e],o=a.indexOf(t);-1!==o&&(a.splice(o,1),this.totalSocketCount--,0===a.length&&delete this.sockets[e])}getName(e){return this.isSecureEndpoint(e)?p.Agent.prototype.getName.call(this,e):super.getName(e)}createSocket(e,t,a){const o={...t,secureEndpoint:this.isSecureEndpoint(t)},r=this.getName(o),i=this.incrementSockets(r);Promise.resolve().then(()=>this.connect(e,o)).then(n=>{if(this.decrementSockets(r,i),n instanceof c.Agent)try{return n.addRequest(e,o)}catch(e){return a(e)}this[u].currentSocket=n,super.createSocket(e,t,a)},e=>{this.decrementSockets(r,i),a(e)})}createConnection(){const e=this[u].currentSocket;if(this[u].currentSocket=void 0,!e)throw new Error("No socket was returned in the `connect()` function");return e}get defaultPort(){return this[u].defaultPort??("https:"===this.protocol?443:80)}set defaultPort(e){this[u]&&(this[u].defaultPort=e)}get protocol(){return this[u].protocol??(this.isSecureEndpoint()?"https:":"http:")}set protocol(e){this[u]&&(this[u].protocol=e)}}t.Agent=Agent},21614:function(e,t,a){"use strict";var o=this&&this.__createBinding||(Object.create?function(e,t,a,o){void 0===o&&(o=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,o,r)}:function(e,t,a,o){void 0===o&&(o=a),e[o]=t[a]}),r=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),i=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a in e)"default"!==a&&Object.prototype.hasOwnProperty.call(e,a)&&o(t,e,a);return r(t,e),t},n=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||o(t,e,a)};Object.defineProperty(t,"__esModule",{value:!0}),t.z=void 0;const s=i(a(96555));t.z=s,n(a(96555),t),t.default=s},21849:(e,t,a)=>{"use strict";var o=a(79896),r=a(83480),i=a(4022),n=a(92849);function Har(e){this.request=e}Har.prototype.reducer=function(e,t){if(void 0===e[t.name])return e[t.name]=t.value,e;var a=[e[t.name],t.value];return e[t.name]=a,e},Har.prototype.prep=function(e){if(e.queryObj={},e.headersObj={},e.postData.jsonObj=!1,e.postData.paramsObj=!1,e.queryString&&e.queryString.length&&(e.queryObj=e.queryString.reduce(this.reducer,{})),e.headers&&e.headers.length&&(e.headersObj=e.headers.reduceRight(function(e,t){return e[t.name]=t.value,e},{})),e.cookies&&e.cookies.length){var t=e.cookies.map(function(e){return e.name+"="+e.value});t.length&&(e.headersObj.cookie=t.join("; "))}function some(t){return t.some(function(t){return 0===e.postData.mimeType.indexOf(t)})}if(some(["multipart/mixed","multipart/related","multipart/form-data","multipart/alternative"]))e.postData.mimeType="multipart/form-data";else if(some(["application/x-www-form-urlencoded"]))e.postData.params?(e.postData.paramsObj=e.postData.params.reduce(this.reducer,{}),e.postData.text=r.stringify(e.postData.paramsObj)):e.postData.text="";else if(some(["text/json","text/x-json","application/json","application/x-json"])&&(e.postData.mimeType="application/json",e.postData.text))try{e.postData.jsonObj=JSON.parse(e.postData.text)}catch(t){this.request.debug(t),e.postData.mimeType="text/plain"}return e},Har.prototype.options=function(e){if(!e.har)return e;var t={};if(n(t,e.har),t.log&&t.log.entries&&(t=t.log.entries[0]),t.url=t.url||e.url||e.uri||e.baseUrl||"/",t.httpVersion=t.httpVersion||"HTTP/1.1",t.queryString=t.queryString||[],t.headers=t.headers||[],t.cookies=t.cookies||[],t.postData=t.postData||{},t.postData.mimeType=t.postData.mimeType||"application/octet-stream",t.bodySize=0,t.headersSize=0,t.postData.size=0,!i.request(t))return e;var a=this.prep(t);function test(e){return 0===a.postData.mimeType.indexOf(e)}return a.url&&(e.url=a.url),a.method&&(e.method=a.method),Object.keys(a.queryObj).length&&(e.qs=a.queryObj),Object.keys(a.headersObj).length&&(e.headers=a.headersObj),test("application/x-www-form-urlencoded")?e.form=a.postData.paramsObj:test("application/json")?a.postData.jsonObj&&(e.body=a.postData.jsonObj,e.json=!0):test("multipart/form-data")?(e.formData={},a.postData.params.forEach(function(t){var a={};t.fileName||t.contentType?(t.fileName&&!t.value?a.value=o.createReadStream(t.fileName):t.value&&(a.value=t.value),t.fileName&&(a.options={filename:t.fileName,contentType:t.contentType?t.contentType:null}),e.formData[t.name]=a):e.formData[t.name]=t.value})):a.postData.text&&(e.body=a.postData.text),e},t.k=Har},21873:(e,t,a)=>{e.exports={parallel:a(18798),serial:a(52081),serialOrdered:a(90028)}},21968:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.handleServerStart=t.showPackageVersion=void 0;const o=a(7011),r=a(6166),i=a(21614),n=a(73364),s=a(79041),c=a(47255),p=a(67587),u=a(53903);t.showPackageVersion=()=>{console.log(`Package version: ${(0,p.getPackageVersion)()}`)};t.handleServerStart=async()=>{if(await(0,c.checkAndUpdateIfNeeded)())return void(0,c.restartProcess)();(0,t.showPackageVersion)(),await(async()=>{try{await(0,s.startServer)()}catch(e){console.error("❌ Failed to start API server:",e)}})();const e=(()=>{const e=new o.McpServer({name:"edgeone-pages-deploy-mcp-server",version:(0,p.getPackageVersion)()},{capabilities:{logging:{}}});return e.tool("deploy_folder","Deploy a folder containing web assets to EdgeOne Pages. Supports built projects (from build tools like Vite, Webpack, etc.), simple static file projects (HTML, CSS, JS files), and NextJS full-stack projects. Returns: deployment URL and project metadata.",{builtFolderPath:i.z.string().describe("Provide the absolute path to the folder containing deployable web assets (HTML, CSS, JS, images, etc.). This can be either a build output directory (like dist/, build/, out/) or a folder with static files ready for deployment."),workspacePath:i.z.string().describe("Provide the absolute path to the workspace folder."),projectType:i.z.enum(["fullstack","static"]).describe("Specify the project type. Choose 'fullstack' for NextJS full-stack projects, or 'static' for static sites and other build tool outputs. Note: If workspacePath contains any of the directories 'functions', 'node-functions', or 'edge-functions', it should be considered a fullstack project.")},async({builtFolderPath:e,workspacePath:t,projectType:a})=>{try{const o=await(0,n.deployFolderToEdgeOne)({builtFolderPath:e,workspacePath:t,projectType:a});return{content:[{type:"text",text:JSON.stringify(o,null,2)}]}}catch(e){return{content:[{type:"text",text:`${e.message||"Unknown error occurred"}`}],isError:!0}}}),e})(),a=new r.StdioServerTransport;await e.connect(a),(0,u.setupCodeBuddyIntegration)(e)}},22793:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseTupleDef=void 0;const o=a(73524);t.parseTupleDef=function parseTupleDef(e,t){return e.rest?{type:"array",minItems:e.items.length,items:e.items.map((e,a)=>(0,o.parseDef)(e._def,{...t,currentPath:[...t.currentPath,"items",`${a}`]})).reduce((e,t)=>void 0===t?e:[...e,t],[]),additionalItems:(0,o.parseDef)(e.rest._def,{...t,currentPath:[...t.currentPath,"additionalItems"]})}:{type:"array",minItems:e.items.length,maxItems:e.items.length,items:e.items.map((e,a)=>(0,o.parseDef)(e._def,{...t,currentPath:[...t.currentPath,"items",`${a}`]})).reduce((e,t)=>void 0===t?e:[...e,t],[])}}},23826:(e,t,a)=>{"use strict";var o=a(5545)("http-errors"),r=a(97270),i=a(85048),n=a(72017),s=a(16963);function codeClass(e){return Number(String(e).charAt(0)+"00")}function nameFunc(e,t){var a=Object.getOwnPropertyDescriptor(e,"name");a&&a.configurable&&(a.value=t,Object.defineProperty(e,"name",a))}function toClassName(e){return"Error"!==e.substr(-5)?e+"Error":e}e.exports=function createError(){for(var e,t,a=500,r={},n=0;n<arguments.length;n++){var s=arguments[n];if(s instanceof Error)a=(e=s).status||e.statusCode||a;else switch(typeof s){case"string":t=s;break;case"number":a=s,0!==n&&o("non-first-argument status code; replace with createError("+s+", ...)");break;case"object":r=s}}"number"==typeof a&&(a<400||a>=600)&&o("non-error status code; use only 4xx or 5xx status codes");("number"!=typeof a||!i[a]&&(a<400||a>=600))&&(a=500);var c=createError[a]||createError[codeClass(a)];e||(e=c?new c(t):new Error(t||i[a]),Error.captureStackTrace(e,createError));c&&e instanceof c&&e.status===a||(e.expose=a<500,e.status=e.statusCode=a);for(var p in r)"status"!==p&&"statusCode"!==p&&(e[p]=r[p]);return e},e.exports.HttpError=function createHttpErrorConstructor(){function HttpError(){throw new TypeError("cannot construct abstract class")}return n(HttpError,Error),HttpError}(),e.exports.isHttpError=function createIsHttpErrorFunction(e){return function isHttpError(t){return!(!t||"object"!=typeof t)&&(t instanceof e||t instanceof Error&&"boolean"==typeof t.expose&&"number"==typeof t.statusCode&&t.status===t.statusCode)}}(e.exports.HttpError),function populateConstructorExports(e,t,a){t.forEach(function forEachCode(t){var o,c=s(i[t]);switch(codeClass(t)){case 400:o=function createClientErrorConstructor(e,t,a){var o=toClassName(t);function ClientError(e){var t=null!=e?e:i[a],n=new Error(t);return Error.captureStackTrace(n,ClientError),r(n,ClientError.prototype),Object.defineProperty(n,"message",{enumerable:!0,configurable:!0,value:t,writable:!0}),Object.defineProperty(n,"name",{enumerable:!1,configurable:!0,value:o,writable:!0}),n}return n(ClientError,e),nameFunc(ClientError,o),ClientError.prototype.status=a,ClientError.prototype.statusCode=a,ClientError.prototype.expose=!0,ClientError}(a,c,t);break;case 500:o=function createServerErrorConstructor(e,t,a){var o=toClassName(t);function ServerError(e){var t=null!=e?e:i[a],n=new Error(t);return Error.captureStackTrace(n,ServerError),r(n,ServerError.prototype),Object.defineProperty(n,"message",{enumerable:!0,configurable:!0,value:t,writable:!0}),Object.defineProperty(n,"name",{enumerable:!1,configurable:!0,value:o,writable:!0}),n}return n(ServerError,e),nameFunc(ServerError,o),ServerError.prototype.status=a,ServerError.prototype.statusCode=a,ServerError.prototype.expose=!1,ServerError}(a,c,t)}o&&(e[t]=o,e[c]=o)}),e["I'mateapot"]=o.function(e.ImATeapot,'"I\'mateapot"; use "ImATeapot" instead')}(e.exports,i.codes,e.exports.HttpError)},23832:e=>{"use strict";e.exports=class XmlNode{constructor(e){this.tagname=e,this.child=[],this[":@"]={}}add(e,t){"__proto__"===e&&(e="#__proto__"),this.child.push({[e]:t})}addChild(e){"__proto__"===e.tagname&&(e.tagname="#__proto__"),e[":@"]&&Object.keys(e[":@"]).length>0?this.child.push({[e.tagname]:e.child,":@":e[":@"]}):this.child.push({[e.tagname]:e.child})}}},24302:(e,t,a)=>{"use strict";var o=a(54774).Buffer,r=a(31304),i=e.exports;i.encodings=null,i.defaultCharUnicode="�",i.defaultCharSingleByte="?",i.encode=function encode(e,t,a){e=""+(e||"");var r=i.getEncoder(t,a),n=r.write(e),s=r.end();return s&&s.length>0?o.concat([n,s]):n},i.decode=function decode(e,t,a){"string"==typeof e&&(i.skipDecodeWarning||(console.error("Iconv-lite warning: decode()-ing strings is deprecated. Refer to https://github.com/ashtuchkin/iconv-lite/wiki/Use-Buffers-when-decoding"),i.skipDecodeWarning=!0),e=o.from(""+(e||""),"binary"));var r=i.getDecoder(t,a),n=r.write(e),s=r.end();return s?n+s:n},i.encodingExists=function encodingExists(e){try{return i.getCodec(e),!0}catch(e){return!1}},i.toEncoding=i.encode,i.fromEncoding=i.decode,i._codecDataCache={},i.getCodec=function getCodec(e){i.encodings||(i.encodings=a(97071));for(var t=i._canonicalizeEncoding(e),o={};;){var r=i._codecDataCache[t];if(r)return r;var n=i.encodings[t];switch(typeof n){case"string":t=n;break;case"object":for(var s in n)o[s]=n[s];o.encodingName||(o.encodingName=t),t=n.type;break;case"function":return o.encodingName||(o.encodingName=t),r=new n(o,i),i._codecDataCache[o.encodingName]=r,r;default:throw new Error("Encoding not recognized: '"+e+"' (searched as: '"+t+"')")}}},i._canonicalizeEncoding=function(e){return(""+e).toLowerCase().replace(/:\d{4}$|[^0-9a-z]/g,"")},i.getEncoder=function getEncoder(e,t){var a=i.getCodec(e),o=new a.encoder(t,a);return a.bomAware&&t&&t.addBOM&&(o=new r.PrependBOM(o,t)),o},i.getDecoder=function getDecoder(e,t){var a=i.getCodec(e),o=new a.decoder(t,a);return!a.bomAware||t&&!1===t.stripBOM||(o=new r.StripBOM(o,t)),o};var n="undefined"!=typeof process&&process.versions&&process.versions.node;if(n){var s=n.split(".").map(Number);(s[0]>0||s[1]>=10)&&a(34899)(i),a(1189)(i)}},24434:e=>{"use strict";e.exports=require("events")},24493:(e,t,a)=>{"use strict";const o=a(53908);e.exports=(e,t)=>new o(e,t).patch},24876:e=>{"use strict";e.exports=require("punycode")},25054:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.handleCliCommand=void 0;const o=a(52056),r=a(21968),i=a(81244),n=a(66119);t.handleCliCommand=async e=>{if(e.help)return void console.log('\nEdgeOne Pages MCP Fullstack Server\n\nMCP USAGE:\n\nTencent Cloud International (default):\n{\n  "mcpServers": {\n    "edgeone-pages-mcp-fullstack-server": {\n      "command": "npx",\n      "args": ["edgeone-pages-mcp-fullstack"]\n    }\n  }\n}\n\nTencent Cloud China:\n{\n  "mcpServers": {\n    "edgeone-pages-mcp-fullstack-server": {\n      "command": "npx",\n      "args": ["edgeone-pages-mcp-fullstack", "--region", "china"]\n    }\n  }\n}\n');if(e.version)return void(0,r.showPackageVersion)();if(e.clear)return void await(0,i.handleClearConfig)();if(e.project)return void await(0,o.handleProjectQuery)(e.project);const t=e.region??"global";await(0,n.saveRegionToConfig)(t),e.region&&console.log(`✅ Region set to: ${e.region}`),await(0,n.clearConfig)(),await(0,r.handleServerStart)()}},25200:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t,a)=>o(e,t,a)<=0},25206:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.applySubschema=t.Type=void 0;const o=a(62586),r=a(94227),i=a(99029);var n;!function(e){e[e.Num=0]="Num",e[e.Str=1]="Str"}(n=t.Type||(t.Type={})),t.applySubschema=function applySubschema(e,t,a){const s=function getSubschema(e,{keyword:t,schemaProp:a,schema:o,schemaPath:n,errSchemaPath:s,topSchemaRef:c}){if(void 0!==t&&void 0!==o)throw new Error('both "keyword" and "schema" passed, only one allowed');if(void 0!==t){const o=e.schema[t];return void 0===a?{schema:o,schemaPath:i._`${e.schemaPath}${i.getProperty(t)}`,errSchemaPath:`${e.errSchemaPath}/${t}`}:{schema:o[a],schemaPath:i._`${e.schemaPath}${i.getProperty(t)}${i.getProperty(a)}`,errSchemaPath:`${e.errSchemaPath}/${t}/${r.escapeFragment(a)}`}}if(void 0!==o){if(void 0===n||void 0===s||void 0===c)throw new Error('"schemaPath", "errSchemaPath" and "topSchemaRef" are required with "schema"');return{schema:o,schemaPath:n,topSchemaRef:c,errSchemaPath:s}}throw new Error('either "keyword" or "schema" must be passed')}(e,t);!function extendSubschemaData(e,t,{dataProp:a,dataPropType:o,data:s,dataTypes:c,propertyName:p}){if(void 0!==s&&void 0!==a)throw new Error('both "data" and "dataProp" passed, only one allowed');const{gen:u}=t;if(void 0!==a){const{errorPath:s,dataPathArr:c,opts:p}=t;dataContextProps(u.let("data",i._`${t.data}${i.getProperty(a)}`,!0)),e.errorPath=i.str`${s}${function getErrorPath(e,t,a){if(e instanceof i.Name){const o=t===n.Num;return a?o?i._`"[" + ${e} + "]"`:i._`"['" + ${e} + "']"`:o?i._`"/" + ${e}`:i._`"/" + ${e}.replace(/~/g, "~0").replace(/\\//g, "~1")`}return a?i.getProperty(e).toString():"/"+r.escapeJsonPointer(e)}(a,o,p.jsPropertySyntax)}`,e.parentDataProperty=i._`${a}`,e.dataPathArr=[...c,e.parentDataProperty]}if(void 0!==s){dataContextProps(s instanceof i.Name?s:u.let("data",s,!0)),void 0!==p&&(e.propertyName=p)}c&&(e.dataTypes=c);function dataContextProps(a){e.data=a,e.dataLevel=t.dataLevel+1,e.dataTypes=[],t.definedProperties=new Set,e.parentData=t.data,e.dataNames=[...t.dataNames,a]}}(s,e,t),function extendSubschemaMode(e,{jtdDiscriminator:t,jtdMetadata:a,compositeRule:o,createErrors:r,allErrors:i}){void 0!==o&&(e.compositeRule=o);void 0!==r&&(e.createErrors=r);void 0!==i&&(e.allErrors=i);e.jtdDiscriminator=t,e.jtdMetadata=a}(s,t);const c={...e,...s,items:void 0,props:void 0};return o.subschemaCode(c,a),c}},25390:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function ucs2length(e){const t=e.length;let a,o=0,r=0;for(;r<t;)o++,a=e.charCodeAt(r++),a>=55296&&a<=56319&&r<t&&(a=e.charCodeAt(r),56320==(64512&a)&&r++);return o}},25477:(e,t)=>{"use strict";const a=/"(?:_|\\u005[Ff])(?:_|\\u005[Ff])(?:p|\\u0070)(?:r|\\u0072)(?:o|\\u006[Ff])(?:t|\\u0074)(?:o|\\u006[Ff])(?:_|\\u005[Ff])(?:_|\\u005[Ff])"\s*\:/;t.parse=function(e,...o){const r="object"==typeof o[0]&&o[0],i=o.length>1||!r?o[0]:void 0,n=o.length>1&&o[1]||r||{},s=JSON.parse(e,i);return"ignore"===n.protoAction?s:s&&"object"==typeof s&&e.match(a)?(t.scan(s,n),s):s},t.scan=function(e,t={}){let a=[e];for(;a.length;){const e=a;a=[];for(const o of e){if(Object.prototype.hasOwnProperty.call(o,"__proto__")){if("remove"!==t.protoAction)throw new SyntaxError("Object contains forbidden prototype property");delete o.__proto__}for(const e in o){const t=o[e];t&&"object"==typeof t&&a.push(o[e])}}}},t.safeParse=function(e,a){try{return t.parse(e,a)}catch(e){return null}}},25507:(e,t,a)=>{"use strict";const o=a(49903),r=a(84881),i=a(94099);e.exports=async function(e,t){e=e.req||e,t=i.clone(t);const a=e.headers["content-length"],n=e.headers["content-encoding"]||"identity";a&&"identity"===n&&(t.length=~~a),t.encoding=void 0===t.encoding?"utf8":t.encoding,t.limit=t.limit||"1mb";const s=await o(r(e),t);return t.returnRawBody?{parsed:s,raw:s}:s}},25508:e=>{"use strict";e.exports=function bytes(e,t){if("string"==typeof e)return parse(e);if("number"==typeof e)return format(e,t);return null},e.exports.format=format,e.exports.parse=parse;var t=/\B(?=(\d{3})+(?!\d))/g,a=/(?:\.0*|(\.[^0]+)0+)$/,o={b:1,kb:1024,mb:1<<20,gb:1<<30,tb:Math.pow(1024,4),pb:Math.pow(1024,5)},r=/^((-|\+)?(\d+(?:\.\d+)?)) *(kb|mb|gb|tb|pb)$/i;function format(e,r){if(!Number.isFinite(e))return null;var i=Math.abs(e),n=r&&r.thousandsSeparator||"",s=r&&r.unitSeparator||"",c=r&&void 0!==r.decimalPlaces?r.decimalPlaces:2,p=Boolean(r&&r.fixedDecimals),u=r&&r.unit||"";u&&o[u.toLowerCase()]||(u=i>=o.pb?"PB":i>=o.tb?"TB":i>=o.gb?"GB":i>=o.mb?"MB":i>=o.kb?"KB":"B");var l=(e/o[u.toLowerCase()]).toFixed(c);return p||(l=l.replace(a,"$1")),n&&(l=l.split(".").map(function(e,a){return 0===a?e.replace(t,n):e}).join(".")),l+s+u}function parse(e){if("number"==typeof e&&!isNaN(e))return e;if("string"!=typeof e)return null;var t,a=r.exec(e),i="b";return a?(t=parseFloat(a[1]),i=a[4].toLowerCase()):(t=parseInt(e,10),i="b"),isNaN(t)?null:Math.floor(o[i]*t)}},25543:function(e,t){var a;a=function(){return function(){var e=validate;e.Integer={type:"integer"};var t={String,Boolean,Number,Object,Array,Date};function validate(e,t){return validate(e,t,{changing:!1})}e.validate=validate,e.checkPropertyChange=function(e,t,a){return validate(e,t,{changing:a||"property"})};var validate=e._validate=function(e,a,o){o||(o={});var r=o.changing;function getType(e){return e.type||t[e.name]==e&&e.name.toLowerCase()}var i=[];function checkProp(e,t,a,n){var s;function addError(e){i.push({property:a,message:e})}if(a+=a?"number"==typeof n?"["+n+"]":void 0===n?"":"."+n:n,("object"!=typeof t||t instanceof Array)&&(a||"function"!=typeof t)&&(!t||!getType(t)))return"function"==typeof t?e instanceof t||addError("is not an instance of the class/constructor "+t.name):t&&addError("Invalid schema/property definition "+t),null;function checkType(e,t){if(e){if(!("string"!=typeof e||"any"==e||("null"==e?null===t:typeof t==e)||t instanceof Array&&"array"==e||t instanceof Date&&"date"==e||"integer"==e&&t%1==0))return[{property:a,message:t+" - "+typeof t+" value found, but a "+e+" is required"}];if(e instanceof Array){for(var o=[],r=0;r<e.length&&(o=checkType(e[r],t)).length;r++);if(o.length)return o}else if("object"==typeof e){var n=i;i=[],checkProp(t,e,a);var s=i;return i=n,s}}return[]}if(r&&t.readonly&&addError("is a readonly field, it can not be changed"),t.extends&&checkProp(e,t.extends,a,n),void 0===e)t.required&&addError("is missing and it is required");else if(i=i.concat(checkType(getType(t),e)),t.disallow&&!checkType(t.disallow,e).length&&addError(" disallowed value was matched"),null!==e){if(e instanceof Array){if(t.items){var c=t.items instanceof Array,p=t.items;for(n=0,s=e.length;n<s;n+=1)c&&(p=t.items[n]),o.coerce&&(e[n]=o.coerce(e[n],p)),i.concat(checkProp(e[n],p,a,n))}t.minItems&&e.length<t.minItems&&addError("There must be a minimum of "+t.minItems+" in the array"),t.maxItems&&e.length>t.maxItems&&addError("There must be a maximum of "+t.maxItems+" in the array")}else(t.properties||t.additionalProperties)&&i.concat(checkObj(e,t.properties,a,t.additionalProperties));if(t.pattern&&"string"==typeof e&&!e.match(t.pattern)&&addError("does not match the regex pattern "+t.pattern),t.maxLength&&"string"==typeof e&&e.length>t.maxLength&&addError("may only be "+t.maxLength+" characters long"),t.minLength&&"string"==typeof e&&e.length<t.minLength&&addError("must be at least "+t.minLength+" characters long"),void 0!==t.minimum&&typeof e==typeof t.minimum&&t.minimum>e&&addError("must have a minimum value of "+t.minimum),void 0!==t.maximum&&typeof e==typeof t.maximum&&t.maximum<e&&addError("must have a maximum value of "+t.maximum),t.enum){var u,l=t.enum;s=l.length;for(var m=0;m<s;m++)if(l[m]===e){u=1;break}u||addError("does not have a value in the enumeration "+l.join(", "))}"number"==typeof t.maxDecimal&&e.toString().match(new RegExp("\\.[0-9]{"+(t.maxDecimal+1)+",}"))&&addError("may only have "+t.maxDecimal+" digits of decimal places")}return null}function checkObj(e,t,a,n){if("object"==typeof t)for(var s in("object"!=typeof e||e instanceof Array)&&i.push({property:a,message:"an object is required"}),t)if(t.hasOwnProperty(s)&&"__proto__"!=s&&"constructor"!=s){var c=e.hasOwnProperty(s)?e[s]:void 0;if(void 0===c&&o.existingOnly)continue;var p=t[s];void 0===c&&p.default&&(c=e[s]=p.default),o.coerce&&s in e&&(c=e[s]=o.coerce(c,p)),checkProp(c,p,a,s)}for(s in e){if(e.hasOwnProperty(s)&&("_"!=s.charAt(0)||"_"!=s.charAt(1))&&t&&!t[s]&&!1===n){if(o.filter){delete e[s];continue}i.push({property:a,message:"The property "+s+" is not defined in the schema and the schema does not allow additional properties"})}var u=t&&t[s]&&t[s].requires;u&&!(u in e)&&i.push({property:a,message:"the presence of the property "+s+" requires that "+u+" also be present"}),c=e[s],!n||t&&"object"==typeof t&&s in t||(o.coerce&&(c=e[s]=o.coerce(c,n)),checkProp(c,n,a,s)),!r&&c&&c.$schema&&(i=i.concat(checkProp(c,c.$schema,a,s)))}return i}return a&&checkProp(e,a,"",r||""),!r&&e&&e.$schema&&checkProp(e,e.$schema,"",""),{valid:!i.length,errors:i}};return e.mustBeValid=function(e){if(!e.valid)throw new TypeError(e.errors.map(function(e){return"for property "+e.property+": "+e.message}).join(", \n"))},e}()}.apply(t,[]),void 0===a||(e.exports=a)},25884:e=>{"use strict";e.exports=(e,t=process.argv)=>{const a=e.startsWith("-")?"":1===e.length?"-":"--",o=t.indexOf(a+e),r=t.indexOf("--");return-1!==o&&(-1===r||o<r)}},25919:(e,t,a)=>{const o=a(87016).URLSearchParams;e.exports={stringify:e=>{const t=new o,addKey=(e,t,a)=>{const o="string"==typeof t||"number"==typeof t?t:"";a.append(e,o)};for(const[a,o]of Object.entries(e))if(Array.isArray(o)){const e=o.length;for(let r=0;r<e;r++)addKey(a,o[r],t)}else addKey(a,o,t);return t.toString()},parse:e=>{const t=new o(e),a={};for(const e of t.keys()){const o=t.getAll(e);a[e]=o.length<=1?o[0]:o}return a}}},26091:(e,t,a)=>{e.exports={read:function read(e,t){"string"==typeof e&&(e=i.from(e,"binary"));o.buffer(e,"buf");var a=new r.BerReader(e);if(a.readSequence(),Math.abs(a.length-a.remain)>1)throw new Error("DER sequence does not contain whole byte stream");var m=a.offset;a.readSequence();var f=a.offset+a.length,h=f;if(a.peek()===Local(0)){a.readSequence(Local(0));var g=a.readInt();o.ok(g<=3,"only x.509 versions up to v3 supported")}var y={signatures:{}},b=y.signatures.x509={};b.extras={},y.serial=function readMPInt(e,t){return o.strictEqual(e.peek(),r.Ber.Integer,t+" is not an Integer"),n.mpNormalize(e.readString(r.Ber.Integer,!0))}(a,"serial"),a.readSequence();var x=a.offset+a.length,w=a.readOID();if(void 0===l[w])throw new Error("unknown signature algorithm "+w);a._offset=x,y.issuer=s.parseAsn1(a),a.readSequence(),y.validFrom=readDate(a),y.validUntil=readDate(a),y.subjects=[s.parseAsn1(a)],a.readSequence(),x=a.offset+a.length,y.subjectKey=u.readPkcs8(void 0,"public",a),a._offset=x,a.peek()===Local(1)&&(a.readSequence(Local(1)),b.extras.issuerUniqueID=e.slice(a.offset,a.offset+a.length),a._offset+=a.length);a.peek()===Local(2)&&(a.readSequence(Local(2)),b.extras.subjectUniqueID=e.slice(a.offset,a.offset+a.length),a._offset+=a.length);if(a.peek()===Local(3)){a.readSequence(Local(3));var k=a.offset+a.length;for(a.readSequence();a.offset<k;)readExtension(y,e,a);o.strictEqual(a.offset,k)}o.strictEqual(a.offset,f),a.readSequence(),x=a.offset+a.length;var j=a.readOID(),C=l[j];if(void 0===C)throw new Error("unknown signature algorithm "+j);a._offset=x;var P=a.readString(r.Ber.BitString,!0);0===P[0]&&(P=P.slice(1));var O=C.split("-");return b.signature=c.parse(P,O[0],"asn1"),b.signature.hashAlgorithm=O[1],b.algo=C,b.cache=e.slice(m,h),new p(y)},verify:function verify(e,t){var a=e.signatures.x509;o.object(a,"x509 signature");var i=a.algo.split("-");if(i[0]!==t.type)return!1;var n=a.cache;if(void 0===n){var s=new r.BerWriter;writeTBSCert(e,s),n=s.buffer}var c=t.createVerify(i[1]);return c.write(n),c.verify(a.signature)},sign:function sign(e,t){void 0===e.signatures.x509&&(e.signatures.x509={});var a=e.signatures.x509;if(a.algo=t.type+"-"+t.defaultHashAlgorithm(),void 0===l[a.algo])return!1;var o=new r.BerWriter;writeTBSCert(e,o);var i=o.buffer;a.cache=i;var n=t.createSign();return n.write(i),e.signatures.x509.signature=n.sign(),!0},signAsync:function signAsync(e,t,a){void 0===e.signatures.x509&&(e.signatures.x509={});var o=e.signatures.x509,i=new r.BerWriter;writeTBSCert(e,i);var n=i.buffer;o.cache=n,t(n,function(e,t){e?a(e):(o.algo=t.type+"-"+t.hashAlgorithm,void 0!==l[o.algo]?(o.signature=t,a()):a(new Error('Invalid signing algorithm "'+o.algo+'"')))})},write:function write(e,t){var a=e.signatures.x509;o.object(a,"x509 signature");var n=new r.BerWriter;n.startSequence(),a.cache?(n._ensure(a.cache.length),a.cache.copy(n._buf,n._offset),n._offset+=a.cache.length):writeTBSCert(e,n);n.startSequence(),n.writeOID(l[a.algo]),a.algo.match(/^rsa-/)&&n.writeNull();n.endSequence();var s=a.signature.toBuffer("asn1"),c=i.alloc(s.length+1);return c[0]=0,s.copy(c,1),n.writeBuffer(c,r.Ber.BitString),n.endSequence(),n.buffer}};var o=a(94742),r=a(53100),i=a(54774).Buffer,n=(a(6641),a(87461)),s=(a(64479),a(90009),a(43809),a(45020)),c=a(57114),p=a(58219),u=a(78038);function Local(e){return r.Ber.Context|r.Ber.Constructor|e}function Context(e){return r.Ber.Context|e}var l={"rsa-md5":"1.2.840.113549.1.1.4","rsa-sha1":"1.2.840.113549.1.1.5","rsa-sha256":"1.2.840.113549.1.1.11","rsa-sha384":"1.2.840.113549.1.1.12","rsa-sha512":"1.2.840.113549.1.1.13","dsa-sha1":"1.2.840.10040.4.3","dsa-sha256":"2.16.840.1.101.3.4.3.2","ecdsa-sha1":"1.2.840.10045.4.1","ecdsa-sha256":"1.2.840.10045.4.3.2","ecdsa-sha384":"1.2.840.10045.4.3.3","ecdsa-sha512":"1.2.840.10045.4.3.4","ed25519-sha512":"1.3.101.112"};Object.keys(l).forEach(function(e){l[l[e]]=e}),l["1.3.14.3.2.3"]="rsa-md5",l["1.3.14.3.2.29"]="rsa-sha1";var m={issuerKeyId:"2.5.29.35",altName:"2.5.29.17",basicConstraints:"2.5.29.19",keyUsage:"2.5.29.15",extKeyUsage:"2.5.29.37"};function readDate(e){if(e.peek()===r.Ber.UTCTime)return function utcTimeToDate(e){var t=e.match(b);o.ok(t,"timestamps must be in UTC");var a=new Date,r=a.getUTCFullYear(),i=100*Math.floor(r/100),n=parseInt(t[1],10);n+=r%100<50&&n>=60?i-1:i;a.setUTCFullYear(n,parseInt(t[2],10)-1,parseInt(t[3],10)),a.setUTCHours(parseInt(t[4],10),parseInt(t[5],10)),t[6]&&t[6].length>0&&a.setUTCSeconds(parseInt(t[6],10));return a}(e.readString(r.Ber.UTCTime));if(e.peek()===r.Ber.GeneralizedTime)return function gTimeToDate(e){var t=e.match(x);o.ok(t);var a=new Date;a.setUTCFullYear(parseInt(t[1],10),parseInt(t[2],10)-1,parseInt(t[3],10)),a.setUTCHours(parseInt(t[4],10),parseInt(t[5],10)),t[6]&&t[6].length>0&&a.setUTCSeconds(parseInt(t[6],10));return a}(e.readString(r.Ber.GeneralizedTime));throw new Error("Unsupported date format")}function writeDate(e,t){t.getUTCFullYear()>=2050||t.getUTCFullYear()<1950?e.writeString(function dateToGTime(e){var t="";return t+=zeroPad(e.getUTCFullYear(),4),t+=zeroPad(e.getUTCMonth()+1),t+=zeroPad(e.getUTCDate()),t+=zeroPad(e.getUTCHours()),t+=zeroPad(e.getUTCMinutes()),t+=zeroPad(e.getUTCSeconds()),t+="Z"}(t),r.Ber.GeneralizedTime):e.writeString(function dateToUTCTime(e){var t="";return t+=zeroPad(e.getUTCFullYear()%100),t+=zeroPad(e.getUTCMonth()+1),t+=zeroPad(e.getUTCDate()),t+=zeroPad(e.getUTCHours()),t+=zeroPad(e.getUTCMinutes()),t+=zeroPad(e.getUTCSeconds()),t+="Z"}(t),r.Ber.UTCTime)}var f={OtherName:Local(0),RFC822Name:Context(1),DNSName:Context(2),X400Address:Local(3),DirectoryName:Local(4),EDIPartyName:Local(5),URI:Context(6),IPAddress:Context(7),OID:Context(8)},h={serverAuth:"1.3.6.1.5.5.7.3.1",clientAuth:"1.3.6.1.5.5.7.3.2",codeSigning:"1.3.6.1.5.5.7.3.3",joyentDocker:"1.3.6.1.4.1.38678.1.4.1",joyentCmon:"1.3.6.1.4.1.38678.1.4.2"},g={};Object.keys(h).forEach(function(e){g[h[e]]=e});var y=["signature","identity","keyEncryption","encryption","keyAgreement","ca","crl"];function readExtension(e,t,a){a.readSequence();var o,i,n=a.offset+a.length,c=a.readOID(),p=e.signatures.x509;switch(p.extras.exts||(p.extras.exts=[]),a.peek()===r.Ber.Boolean&&(i=a.readBoolean()),c){case m.basicConstraints:a.readSequence(r.Ber.OctetString),a.readSequence();var u=a.offset+a.length,l=!1;a.peek()===r.Ber.Boolean&&(l=a.readBoolean()),void 0===e.purposes&&(e.purposes=[]),!0===l&&e.purposes.push("ca");var h={oid:c,critical:i};a.offset<u&&a.peek()===r.Ber.Integer&&(h.pathLen=a.readInt()),p.extras.exts.push(h);break;case m.extKeyUsage:a.readSequence(r.Ber.OctetString),a.readSequence(),void 0===e.purposes&&(e.purposes=[]);for(var b=a.offset+a.length;a.offset<b;){var x=a.readOID();e.purposes.push(g[x]||x)}-1!==e.purposes.indexOf("serverAuth")&&-1===e.purposes.indexOf("clientAuth")?e.subjects.forEach(function(e){"host"!==e.type&&(e.type="host",e.hostname=e.uid||e.email||e.components[0].value)}):-1!==e.purposes.indexOf("clientAuth")&&-1===e.purposes.indexOf("serverAuth")&&e.subjects.forEach(function(e){"user"!==e.type&&(e.type="user",e.uid=e.hostname||e.email||e.components[0].value)}),p.extras.exts.push({oid:c,critical:i});break;case m.keyUsage:a.readSequence(r.Ber.OctetString);var w=a.readString(r.Ber.BitString,!0),k=function readBitField(e,t){for(var a=8*(e.length-1)-e[0],o={},r=0;r<a;++r){var i=1<<7-r%8,n=0!==(e[1+Math.floor(r/8)]&i),s=t[r];n&&"string"==typeof s&&(o[s]=!0)}return Object.keys(o)}(w,y);k.forEach(function(t){void 0===e.purposes&&(e.purposes=[]),-1===e.purposes.indexOf(t)&&e.purposes.push(t)}),p.extras.exts.push({oid:c,critical:i,bits:w});break;case m.altName:a.readSequence(r.Ber.OctetString),a.readSequence();for(var j=a.offset+a.length;a.offset<j;)switch(a.peek()){case f.OtherName:case f.EDIPartyName:a.readSequence(),a._offset+=a.length;break;case f.OID:a.readOID(f.OID);break;case f.RFC822Name:var C=a.readString(f.RFC822Name);o=s.forEmail(C),e.subjects[0].equals(o)||e.subjects.push(o);break;case f.DirectoryName:a.readSequence(f.DirectoryName),o=s.parseAsn1(a),e.subjects[0].equals(o)||e.subjects.push(o);break;case f.DNSName:var P=a.readString(f.DNSName);o=s.forHost(P),e.subjects[0].equals(o)||e.subjects.push(o);break;default:a.readString(a.peek())}p.extras.exts.push({oid:c,critical:i});break;default:p.extras.exts.push({oid:c,critical:i,data:a.readString(r.Ber.OctetString,!0)})}a._offset=n}var b=/^([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})?Z$/;var x=/^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})?Z$/;function zeroPad(e,t){void 0===t&&(t=2);for(var a=""+e;a.length<t;)a="0"+a;return a}function writeTBSCert(e,t){var a=e.signatures.x509;o.object(a,"x509 signature"),t.startSequence(),t.startSequence(Local(0)),t.writeInt(2),t.endSequence(),t.writeBuffer(n.mpNormalize(e.serial),r.Ber.Integer),t.startSequence(),t.writeOID(l[a.algo]),a.algo.match(/^rsa-/)&&t.writeNull(),t.endSequence(),e.issuer.toAsn1(t),t.startSequence(),writeDate(t,e.validFrom),writeDate(t,e.validUntil),t.endSequence();var i=e.subjects[0],s=e.subjects.slice(1);if(i.toAsn1(t),u.writePkcs8(t,e.subjectKey),a.extras&&a.extras.issuerUniqueID&&t.writeBuffer(a.extras.issuerUniqueID,Local(1)),a.extras&&a.extras.subjectUniqueID&&t.writeBuffer(a.extras.subjectUniqueID,Local(2)),s.length>0||"host"===i.type||void 0!==e.purposes&&e.purposes.length>0||a.extras&&a.extras.exts){t.startSequence(Local(3)),t.startSequence();var c=[];void 0!==e.purposes&&e.purposes.length>0&&(c.push({oid:m.basicConstraints,critical:!0}),c.push({oid:m.keyUsage,critical:!0}),c.push({oid:m.extKeyUsage,critical:!0})),c.push({oid:m.altName}),a.extras&&a.extras.exts&&(c=a.extras.exts);for(var p=0;p<c.length;++p){if(t.startSequence(),t.writeOID(c[p].oid),void 0!==c[p].critical&&t.writeBoolean(c[p].critical),c[p].oid===m.altName){t.startSequence(r.Ber.OctetString),t.startSequence(),"host"===i.type&&t.writeString(i.hostname,Context(2));for(var g=0;g<s.length;++g)"host"===s[g].type?t.writeString(s[g].hostname,f.DNSName):"email"===s[g].type?t.writeString(s[g].email,f.RFC822Name):(t.startSequence(f.DirectoryName),s[g].toAsn1(t),t.endSequence());t.endSequence(),t.endSequence()}else if(c[p].oid===m.basicConstraints){t.startSequence(r.Ber.OctetString),t.startSequence();var b=-1!==e.purposes.indexOf("ca"),x=c[p].pathLen;t.writeBoolean(b),void 0!==x&&t.writeInt(x),t.endSequence(),t.endSequence()}else if(c[p].oid===m.extKeyUsage)t.startSequence(r.Ber.OctetString),t.startSequence(),e.purposes.forEach(function(e){if("ca"!==e&&-1===y.indexOf(e)){var a=e;void 0!==h[e]&&(a=h[e]),t.writeOID(a)}}),t.endSequence(),t.endSequence();else if(c[p].oid===m.keyUsage){if(t.startSequence(r.Ber.OctetString),void 0!==c[p].bits)t.writeBuffer(c[p].bits,r.Ber.BitString);else{var w=writeBitField(e.purposes,y);t.writeBuffer(w,r.Ber.BitString)}t.endSequence()}else t.writeBuffer(c[p].data,r.Ber.OctetString);t.endSequence()}t.endSequence(),t.endSequence()}t.endSequence()}function writeBitField(e,t){var a=t.length,o=Math.ceil(a/8),r=8*o-a,n=i.alloc(1+o);n[0]=r;for(var s=0;s<a;++s){var c=1+Math.floor(s/8),p=1<<7-s%8,u=t[s];if(void 0!==u)-1!==e.indexOf(u)&&(n[c]|=p)}return n}},26276:(e,t,a)=>{var o=a(74555),r=a(72313);e.exports=function terminator(e){if(!Object.keys(this.jobs).length)return;this.index=this.size,o(this),r(e)(null,this.results)}},26461:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.formatLimitDefinition=void 0;const o=a(13056),r=a(99029),i=r.operators,n={formatMaximum:{okStr:"<=",ok:i.LTE,fail:i.GT},formatMinimum:{okStr:">=",ok:i.GTE,fail:i.LT},formatExclusiveMaximum:{okStr:"<",ok:i.LT,fail:i.GTE},formatExclusiveMinimum:{okStr:">",ok:i.GT,fail:i.LTE}},s={message:({keyword:e,schemaCode:t})=>r.str`should be ${n[e].okStr} ${t}`,params:({keyword:e,schemaCode:t})=>r._`{comparison: ${n[e].okStr}, limit: ${t}}`};t.formatLimitDefinition={keyword:Object.keys(n),type:"string",schemaType:"string",$data:!0,error:s,code(e){const{gen:t,data:a,schemaCode:i,keyword:s,it:c}=e,{opts:p,self:u}=c;if(!p.validateFormats)return;const l=new o.default(c,u.RULES.all.format.definition,"format");function compareCode(e){return r._`${e}.compare(${a}, ${i}) ${n[s].fail} 0`}l.$data?function validate$DataFormat(){const a=t.scopeValue("formats",{ref:u.formats,code:p.code.formats}),o=t.const("fmt",r._`${a}[${l.schemaCode}]`);e.fail$data(r.or(r._`typeof ${o} != "object"`,r._`${o} instanceof RegExp`,r._`typeof ${o}.compare != "function"`,compareCode(o)))}():function validateFormat(){const a=l.schema,o=u.formats[a];if(!o||!0===o)return;if("object"!=typeof o||o instanceof RegExp||"function"!=typeof o.compare)throw new Error(`"${s}": format "${a}" does not define "compare" function`);const i=t.scopeValue("formats",{key:a,ref:o,code:p.code.formats?r._`${p.code.formats}${r.getProperty(a)}`:void 0});e.fail$data(compareCode(i))}()},dependencies:["format"]};t.default=e=>(e.addKeyword(t.formatLimitDefinition),e)},26549:(e,t,a)=>{"use strict";var o=a(54774).Buffer;function Utf16BECodec(){}function Utf16BEEncoder(){}function Utf16BEDecoder(){this.overflowByte=-1}function Utf16Codec(e,t){this.iconv=t}function Utf16Encoder(e,t){void 0===(e=e||{}).addBOM&&(e.addBOM=!0),this.encoder=t.iconv.getEncoder("utf-16le",e)}function Utf16Decoder(e,t){this.decoder=null,this.initialBytes=[],this.initialBytesLen=0,this.options=e||{},this.iconv=t.iconv}function detectEncoding(e,t){var a=t||"utf-16le";if(e.length>=2)if(254==e[0]&&255==e[1])a="utf-16be";else if(255==e[0]&&254==e[1])a="utf-16le";else{for(var o=0,r=0,i=Math.min(e.length-e.length%2,64),n=0;n<i;n+=2)0===e[n]&&0!==e[n+1]&&r++,0!==e[n]&&0===e[n+1]&&o++;r>o?a="utf-16be":r<o&&(a="utf-16le")}return a}t.utf16be=Utf16BECodec,Utf16BECodec.prototype.encoder=Utf16BEEncoder,Utf16BECodec.prototype.decoder=Utf16BEDecoder,Utf16BECodec.prototype.bomAware=!0,Utf16BEEncoder.prototype.write=function(e){for(var t=o.from(e,"ucs2"),a=0;a<t.length;a+=2){var r=t[a];t[a]=t[a+1],t[a+1]=r}return t},Utf16BEEncoder.prototype.end=function(){},Utf16BEDecoder.prototype.write=function(e){if(0==e.length)return"";var t=o.alloc(e.length+1),a=0,r=0;for(-1!==this.overflowByte&&(t[0]=e[0],t[1]=this.overflowByte,a=1,r=2);a<e.length-1;a+=2,r+=2)t[r]=e[a+1],t[r+1]=e[a];return this.overflowByte=a==e.length-1?e[e.length-1]:-1,t.slice(0,r).toString("ucs2")},Utf16BEDecoder.prototype.end=function(){},t.utf16=Utf16Codec,Utf16Codec.prototype.encoder=Utf16Encoder,Utf16Codec.prototype.decoder=Utf16Decoder,Utf16Encoder.prototype.write=function(e){return this.encoder.write(e)},Utf16Encoder.prototype.end=function(){return this.encoder.end()},Utf16Decoder.prototype.write=function(e){if(!this.decoder){if(this.initialBytes.push(e),this.initialBytesLen+=e.length,this.initialBytesLen<16)return"";var t=detectEncoding(e=o.concat(this.initialBytes),this.options.defaultEncoding);this.decoder=this.iconv.getDecoder(t,this.options),this.initialBytes.length=this.initialBytesLen=0}return this.decoder.write(e)},Utf16Decoder.prototype.end=function(){if(!this.decoder){var e=o.concat(this.initialBytes),t=detectEncoding(e,this.options.defaultEncoding);this.decoder=this.iconv.getDecoder(t,this.options);var a=this.decoder.write(e),r=this.decoder.end();return r?a+r:a}return this.decoder.end()}},26815:e=>{function LruCache(e){this.capacity=0|e,this.map=Object.create(null),this.list=new DoublyLinkedList}function DoublyLinkedList(){this.firstNode=null,this.lastNode=null}function DoublyLinkedNode(e,t){this.key=e,this.val=t,this.prev=null,this.next=null}e.exports=function(e){return new LruCache(e)},LruCache.prototype.get=function(e){var t=this.map[e];if(null!=t)return this.used(t),t.val},LruCache.prototype.set=function(e,t){var a=this.map[e];if(null!=a)a.val=t;else{if(this.capacity||this.prune(),!this.capacity)return!1;a=new DoublyLinkedNode(e,t),this.map[e]=a,this.capacity--}return this.used(a),!0},LruCache.prototype.used=function(e){this.list.moveToFront(e)},LruCache.prototype.prune=function(){var e=this.list.pop();null!=e&&(delete this.map[e.key],this.capacity++)},DoublyLinkedList.prototype.moveToFront=function(e){this.firstNode!=e&&(this.remove(e),null==this.firstNode?(this.firstNode=e,this.lastNode=e,e.prev=null,e.next=null):(e.prev=null,e.next=this.firstNode,e.next.prev=e,this.firstNode=e))},DoublyLinkedList.prototype.pop=function(){var e=this.lastNode;return null!=e&&this.remove(e),e},DoublyLinkedList.prototype.remove=function(e){this.firstNode==e?this.firstNode=e.next:null!=e.prev&&(e.prev.next=e.next),this.lastNode==e?this.lastNode=e.prev:null!=e.next&&(e.next.prev=e.prev)}},27467:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Server=void 0;const o=a(77533),r=a(1294);class Server extends o.Protocol{constructor(e,t){var a;super(t),this._serverInfo=e,this._capabilities=null!==(a=null==t?void 0:t.capabilities)&&void 0!==a?a:{},this._instructions=null==t?void 0:t.instructions,this.setRequestHandler(r.InitializeRequestSchema,e=>this._oninitialize(e)),this.setNotificationHandler(r.InitializedNotificationSchema,()=>{var e;return null===(e=this.oninitialized)||void 0===e?void 0:e.call(this)})}registerCapabilities(e){if(this.transport)throw new Error("Cannot register capabilities after connecting to transport");this._capabilities=(0,o.mergeCapabilities)(this._capabilities,e)}assertCapabilityForMethod(e){var t,a;switch(e){case"sampling/createMessage":if(!(null===(t=this._clientCapabilities)||void 0===t?void 0:t.sampling))throw new Error(`Client does not support sampling (required for ${e})`);break;case"roots/list":if(!(null===(a=this._clientCapabilities)||void 0===a?void 0:a.roots))throw new Error(`Client does not support listing roots (required for ${e})`)}}assertNotificationCapability(e){switch(e){case"notifications/message":if(!this._capabilities.logging)throw new Error(`Server does not support logging (required for ${e})`);break;case"notifications/resources/updated":case"notifications/resources/list_changed":if(!this._capabilities.resources)throw new Error(`Server does not support notifying about resources (required for ${e})`);break;case"notifications/tools/list_changed":if(!this._capabilities.tools)throw new Error(`Server does not support notifying of tool list changes (required for ${e})`);break;case"notifications/prompts/list_changed":if(!this._capabilities.prompts)throw new Error(`Server does not support notifying of prompt list changes (required for ${e})`)}}assertRequestHandlerCapability(e){switch(e){case"sampling/createMessage":if(!this._capabilities.sampling)throw new Error(`Server does not support sampling (required for ${e})`);break;case"logging/setLevel":if(!this._capabilities.logging)throw new Error(`Server does not support logging (required for ${e})`);break;case"prompts/get":case"prompts/list":if(!this._capabilities.prompts)throw new Error(`Server does not support prompts (required for ${e})`);break;case"resources/list":case"resources/templates/list":case"resources/read":if(!this._capabilities.resources)throw new Error(`Server does not support resources (required for ${e})`);break;case"tools/call":case"tools/list":if(!this._capabilities.tools)throw new Error(`Server does not support tools (required for ${e})`)}}async _oninitialize(e){const t=e.params.protocolVersion;return this._clientCapabilities=e.params.capabilities,this._clientVersion=e.params.clientInfo,{protocolVersion:r.SUPPORTED_PROTOCOL_VERSIONS.includes(t)?t:r.LATEST_PROTOCOL_VERSION,capabilities:this.getCapabilities(),serverInfo:this._serverInfo,...this._instructions&&{instructions:this._instructions}}}getClientCapabilities(){return this._clientCapabilities}getClientVersion(){return this._clientVersion}getCapabilities(){return this._capabilities}async ping(){return this.request({method:"ping"},r.EmptyResultSchema)}async createMessage(e,t){return this.request({method:"sampling/createMessage",params:e},r.CreateMessageResultSchema,t)}async listRoots(e,t){return this.request({method:"roots/list",params:e},r.ListRootsResultSchema,t)}async sendLoggingMessage(e){return this.notification({method:"notifications/message",params:e})}async sendResourceUpdated(e){return this.notification({method:"notifications/resources/updated",params:e})}async sendResourceListChanged(){return this.notification({method:"notifications/resources/list_changed"})}async sendToolListChanged(){return this.notification({method:"notifications/tools/list_changed"})}async sendPromptListChanged(){return this.notification({method:"notifications/prompts/list_changed"})}}t.Server=Server},27687:(e,t,a)=>{"use strict";const o=a(70857),r=a(52018),i=a(25884),{env:n}=process;let s;function translateLevel(e){return 0!==e&&{level:e,hasBasic:!0,has256:e>=2,has16m:e>=3}}function supportsColor(e,t){if(0===s)return 0;if(i("color=16m")||i("color=full")||i("color=truecolor"))return 3;if(i("color=256"))return 2;if(e&&!t&&void 0===s)return 0;const a=s||0;if("dumb"===n.TERM)return a;if("win32"===process.platform){const e=o.release().split(".");return Number(e[0])>=10&&Number(e[2])>=10586?Number(e[2])>=14931?3:2:1}if("CI"in n)return["TRAVIS","CIRCLECI","APPVEYOR","GITLAB_CI","GITHUB_ACTIONS","BUILDKITE"].some(e=>e in n)||"codeship"===n.CI_NAME?1:a;if("TEAMCITY_VERSION"in n)return/^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(n.TEAMCITY_VERSION)?1:0;if("truecolor"===n.COLORTERM)return 3;if("TERM_PROGRAM"in n){const e=parseInt((n.TERM_PROGRAM_VERSION||"").split(".")[0],10);switch(n.TERM_PROGRAM){case"iTerm.app":return e>=3?3:2;case"Apple_Terminal":return 2}}return/-256(color)?$/i.test(n.TERM)?2:/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(n.TERM)||"COLORTERM"in n?1:a}i("no-color")||i("no-colors")||i("color=false")||i("color=never")?s=0:(i("color")||i("colors")||i("color=true")||i("color=always"))&&(s=1),"FORCE_COLOR"in n&&(s="true"===n.FORCE_COLOR?1:"false"===n.FORCE_COLOR?0:0===n.FORCE_COLOR.length?1:Math.min(parseInt(n.FORCE_COLOR,10),3)),e.exports={supportsColor:function getSupportLevel(e){return translateLevel(supportsColor(e,e&&e.isTTY))},stdout:translateLevel(supportsColor(!0,r.isatty(1))),stderr:translateLevel(supportsColor(!0,r.isatty(2)))}},27809:(e,t,a)=>{var{Transform:o}=a(2203),r=a(39023),i=a(6176);function SelectStream(e){if(!(this instanceof SelectStream))return new SelectStream(e);o.call(this,e),Object.assign(this,{totalLength:0,headerLength:0,payloadRestLength:0,header:null,chunk:Buffer.alloc(0),callback:null})}SelectStream.prototype={processChunk(e,t,a){Object.assign(this,{chunk:Buffer.concat([this.chunk,e],this.chunk.length+e.length),encoding:t,callback:a}),this.parseLength(),this.parseHeader(),this.parsePayload()},parseLength(){this.callback&&(this.totalLength&&this.headerLength||(this.chunk.length>=12?(this.totalLength=this.chunk.readInt32BE(0),this.headerLength=this.chunk.readInt32BE(4),this.payloadRestLength=this.totalLength-this.headerLength-16,this.chunk=this.chunk.slice(12)):(this.callback(),this.callback=null)))},parseHeader(){if(this.callback&&this.headerLength&&!this.header)if(this.chunk.length>=this.headerLength){for(var e={},t=0;t<this.headerLength;){var a=1*this.chunk[t],o=this.chunk.toString("ascii",t+1,t+1+a),r=this.chunk.readInt16BE(t+a+2),i=this.chunk.toString("ascii",t+a+4,t+a+4+r);e[o]=i,t+=a+4+r}this.header=e,this.chunk=this.chunk.slice(this.headerLength),this.checkErrorHeader()}else this.callback(),this.callback=null},parsePayload(){var e=this;this.callback&&(this.chunk.length<=this.payloadRestLength?(this.payloadRestLength-=this.chunk.length,this.pushData(this.chunk),this.chunk=Buffer.alloc(0)):this.chunk.length<this.payloadRestLength+4?(this.pushData(this.chunk.slice(0,this.payloadRestLength)),this.chunk=this.chunk.slice(this.payloadRestLength),this.payloadRestLength=0):(this.pushData(this.chunk.slice(0,this.payloadRestLength)),this.chunk=this.chunk.slice(this.payloadRestLength+4),this.totalLength=0,this.headerLength=0,this.payloadRestLength=0,this.header=null),!this.chunk.length||0===this.payloadRestLength&&this.chunk.length<4?(this.callback(),this.callback=null):process.nextTick(function(){e.processChunk(Buffer.alloc(0),e.encoding,e.callback)}))},pushData(e){if("Records"===this.header[":event-type"])this.push(e),this.emit("message:records",e);else if("Progress"===this.header[":event-type"]){var t=i.xml2json(e.toString()).Progress;this.emit("message:progress",t)}else if("Stats"===this.header[":event-type"]){var a=i.xml2json(e.toString()).Stats;this.emit("message:stats",a)}else if("error"===this.header[":event-type"]){var o=this.header[":error-code"],r=this.header[":error-message"],n=new Error(r);n.message=r,n.name=n.code=o,this.emit("message:error",n)}else this.emit("message:"+this.header[":event-type"].toLowerCase())},checkErrorHeader(){"error"===this.header[":message-type"]&&(this.callback(this.header),this.callback=null)},_transform(e,t,a){this.processChunk(e,t,a)},_flush(e){this.processChunk(Buffer.alloc(0),this.encoding,e)}},r.inherits(SelectStream,o),e.exports=SelectStream},27832:(e,t,a)=>{"use strict";var o=a(34610),r=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,i=[0,31,28,31,30,31,30,31,31,30,31,30,31],n=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,s=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,c=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,p=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,u=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,l=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,m=/^(?:\/(?:[^~/]|~0|~1)*)*$/,f=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,h=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function formats(e){return e="full"==e?"full":"fast",o.copy(formats[e])}function date(e){var t=e.match(r);if(!t)return!1;var a=+t[1],o=+t[2],n=+t[3];return o>=1&&o<=12&&n>=1&&n<=(2==o&&function isLeapYear(e){return e%4==0&&(e%100!=0||e%400==0)}(a)?29:i[o])}function time(e,t){var a=e.match(n);if(!a)return!1;var o=a[1],r=a[2],i=a[3],s=a[5];return(o<=23&&r<=59&&i<=59||23==o&&59==r&&60==i)&&(!t||s)}e.exports=formats,formats.fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":p,url:u,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:s,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex,uuid:l,"json-pointer":m,"json-pointer-uri-fragment":f,"relative-json-pointer":h},formats.full={date,time,"date-time":function date_time(e){var t=e.split(g);return 2==t.length&&date(t[0])&&time(t[1],!0)},uri:function uri(e){return y.test(e)&&c.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":p,url:u,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:s,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex,uuid:l,"json-pointer":m,"json-pointer-uri-fragment":f,"relative-json-pointer":h};var g=/t|\s/i;var y=/\/|:/;var b=/[^\\]\\Z/;function regex(e){if(b.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}},27935:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(32017),i={keyword:"const",$data:!0,error:{message:"should be equal to constant",params:({schemaCode:e})=>o._`{allowedValue: ${e}}`},code(e){const t=e.gen.scopeValue("func",{ref:r,code:o._`require("ajv/dist/compile/equal")`});e.fail$data(o._`!${t}(${e.data}, ${e.schemaCode})`)}};t.default=i},28147:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseBooleanDef=void 0,t.parseBooleanDef=function parseBooleanDef(){return{type:"boolean"}}},28443:e=>{"use strict";e.exports=JSON.parse('{"$id":"cookie.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","required":["name","value"],"properties":{"name":{"type":"string"},"value":{"type":"string"},"path":{"type":"string"},"domain":{"type":"string"},"expires":{"type":["string","null"],"format":"date-time"},"httpOnly":{"type":"boolean"},"secure":{"type":"boolean"},"comment":{"type":"string"}}}')},28643:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r=a(32017),i={keyword:"enum",schemaType:"array",$data:!0,error:{message:"should be equal to one of the allowed values",params:({schemaCode:e})=>o._`{allowedValues: ${e}}`},code(e){const{gen:t,data:a,$data:i,schema:n,schemaCode:s,it:c}=e;if(!i&&0===n.length)throw new Error("enum must have non-empty array");const p=n.length>=c.opts.loopEnum,u=e.gen.scopeValue("func",{ref:r,code:o._`require("ajv/dist/compile/equal")`});let l;if(p||i)l=t.let("valid"),e.block$data(l,function loopEnum(){t.assign(l,!1),t.forOf("v",s,e=>t.if(o._`${u}(${a}, ${e})`,()=>t.assign(l,!0).break()))});else{if(!Array.isArray(n))throw new Error("ajv implementation error");const e=t.const("vSchema",s);l=o.or(...n.map((t,r)=>function equalCode(e,t){const r=n[t];return r&&"object"==typeof r?o._`${u}(${a}, ${e}[${t}])`:o._`${a} === ${r}`}(e,r)))}e.pass(l)}};t.default=i},28727:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.boolOrEmptySchema=t.topBoolOrEmptySchema=void 0;const o=a(48708),r=a(99029),i=a(42023),n={message:"boolean schema is false"};function falseSchemaError(e,t){const{gen:a,data:r}=e,i={gen:a,keyword:"false schema",data:r,schema:!1,schemaCode:!1,schemaValue:!1,params:{},it:e};o.reportError(i,n,t)}t.topBoolOrEmptySchema=function topBoolOrEmptySchema(e){const{gen:t,schema:a,validateName:o}=e;!1===a?falseSchemaError(e,!1):"object"==typeof a&&!0===a.$async?t.return(i.default.data):(t.assign(r._`${o}.errors`,null),t.return(!0))},t.boolOrEmptySchema=function boolOrEmptySchema(e,t){const{gen:a,schema:o}=e;!1===o?(a.var(t,!1),falseSchemaError(e)):a.var(t,!0)}},29167:e=>{"use strict";e.exports=JSON.parse('[["0","\\u0000",127],["8141","갂갃갅갆갋",4,"갘갞갟갡갢갣갥",6,"갮갲갳갴"],["8161","갵갶갷갺갻갽갾갿걁",9,"걌걎",5,"걕"],["8181","걖걗걙걚걛걝",18,"걲걳걵걶걹걻",4,"겂겇겈겍겎겏겑겒겓겕",6,"겞겢",5,"겫겭겮겱",6,"겺겾겿곀곂곃곅곆곇곉곊곋곍",7,"곖곘",7,"곢곣곥곦곩곫곭곮곲곴곷",4,"곾곿괁괂괃괅괇",4,"괎괐괒괓"],["8241","괔괕괖괗괙괚괛괝괞괟괡",7,"괪괫괮",5],["8261","괶괷괹괺괻괽",6,"굆굈굊",5,"굑굒굓굕굖굗"],["8281","굙",7,"굢굤",7,"굮굯굱굲굷굸굹굺굾궀궃",4,"궊궋궍궎궏궑",10,"궞",5,"궥",17,"궸",7,"귂귃귅귆귇귉",6,"귒귔",7,"귝귞귟귡귢귣귥",18],["8341","귺귻귽귾긂",5,"긊긌긎",5,"긕",7],["8361","긝",18,"긲긳긵긶긹긻긼"],["8381","긽긾긿깂깄깇깈깉깋깏깑깒깓깕깗",4,"깞깢깣깤깦깧깪깫깭깮깯깱",6,"깺깾",5,"꺆",5,"꺍",46,"꺿껁껂껃껅",6,"껎껒",5,"껚껛껝",8],["8441","껦껧껩껪껬껮",5,"껵껶껷껹껺껻껽",8],["8461","꼆꼉꼊꼋꼌꼎꼏꼑",18],["8481","꼤",7,"꼮꼯꼱꼳꼵",6,"꼾꽀꽄꽅꽆꽇꽊",5,"꽑",10,"꽞",5,"꽦",18,"꽺",5,"꾁꾂꾃꾅꾆꾇꾉",6,"꾒꾓꾔꾖",5,"꾝",26,"꾺꾻꾽꾾"],["8541","꾿꿁",5,"꿊꿌꿏",4,"꿕",6,"꿝",4],["8561","꿢",5,"꿪",5,"꿲꿳꿵꿶꿷꿹",6,"뀂뀃"],["8581","뀅",6,"뀍뀎뀏뀑뀒뀓뀕",6,"뀞",9,"뀩",26,"끆끇끉끋끍끏끐끑끒끖끘끚끛끜끞",29,"끾끿낁낂낃낅",6,"낎낐낒",5,"낛낝낞낣낤"],["8641","낥낦낧낪낰낲낶낷낹낺낻낽",6,"냆냊",5,"냒"],["8661","냓냕냖냗냙",6,"냡냢냣냤냦",10],["8681","냱",22,"넊넍넎넏넑넔넕넖넗넚넞",4,"넦넧넩넪넫넭",6,"넶넺",5,"녂녃녅녆녇녉",6,"녒녓녖녗녙녚녛녝녞녟녡",22,"녺녻녽녾녿놁놃",4,"놊놌놎놏놐놑놕놖놗놙놚놛놝"],["8741","놞",9,"놩",15],["8761","놹",18,"뇍뇎뇏뇑뇒뇓뇕"],["8781","뇖",5,"뇞뇠",7,"뇪뇫뇭뇮뇯뇱",7,"뇺뇼뇾",5,"눆눇눉눊눍",6,"눖눘눚",5,"눡",18,"눵",6,"눽",26,"뉙뉚뉛뉝뉞뉟뉡",6,"뉪",4],["8841","뉯",4,"뉶",5,"뉽",6,"늆늇늈늊",4],["8861","늏늒늓늕늖늗늛",4,"늢늤늧늨늩늫늭늮늯늱늲늳늵늶늷"],["8881","늸",15,"닊닋닍닎닏닑닓",4,"닚닜닞닟닠닡닣닧닩닪닰닱닲닶닼닽닾댂댃댅댆댇댉",6,"댒댖",5,"댝",54,"덗덙덚덝덠덡덢덣"],["8941","덦덨덪덬덭덯덲덳덵덶덷덹",6,"뎂뎆",5,"뎍"],["8961","뎎뎏뎑뎒뎓뎕",10,"뎢",5,"뎩뎪뎫뎭"],["8981","뎮",21,"돆돇돉돊돍돏돑돒돓돖돘돚돜돞돟돡돢돣돥돦돧돩",18,"돽",18,"됑",6,"됙됚됛됝됞됟됡",6,"됪됬",7,"됵",15],["8a41","둅",10,"둒둓둕둖둗둙",6,"둢둤둦"],["8a61","둧",4,"둭",18,"뒁뒂"],["8a81","뒃",4,"뒉",19,"뒞",5,"뒥뒦뒧뒩뒪뒫뒭",7,"뒶뒸뒺",5,"듁듂듃듅듆듇듉",6,"듑듒듓듔듖",5,"듞듟듡듢듥듧",4,"듮듰듲",5,"듹",26,"딖딗딙딚딝"],["8b41","딞",5,"딦딫",4,"딲딳딵딶딷딹",6,"땂땆"],["8b61","땇땈땉땊땎땏땑땒땓땕",6,"땞땢",8],["8b81","땫",52,"떢떣떥떦떧떩떬떭떮떯떲떶",4,"떾떿뗁뗂뗃뗅",6,"뗎뗒",5,"뗙",18,"뗭",18],["8c41","똀",15,"똒똓똕똖똗똙",4],["8c61","똞",6,"똦",5,"똭",6,"똵",5],["8c81","똻",12,"뙉",26,"뙥뙦뙧뙩",50,"뚞뚟뚡뚢뚣뚥",5,"뚭뚮뚯뚰뚲",16],["8d41","뛃",16,"뛕",8],["8d61","뛞",17,"뛱뛲뛳뛵뛶뛷뛹뛺"],["8d81","뛻",4,"뜂뜃뜄뜆",33,"뜪뜫뜭뜮뜱",6,"뜺뜼",7,"띅띆띇띉띊띋띍",6,"띖",9,"띡띢띣띥띦띧띩",6,"띲띴띶",5,"띾띿랁랂랃랅",6,"랎랓랔랕랚랛랝랞"],["8e41","랟랡",6,"랪랮",5,"랶랷랹",8],["8e61","럂",4,"럈럊",19],["8e81","럞",13,"럮럯럱럲럳럵",6,"럾렂",4,"렊렋렍렎렏렑",6,"렚렜렞",5,"렦렧렩렪렫렭",6,"렶렺",5,"롁롂롃롅",11,"롒롔",7,"롞롟롡롢롣롥",6,"롮롰롲",5,"롹롺롻롽",7],["8f41","뢅",7,"뢎",17],["8f61","뢠",7,"뢩",6,"뢱뢲뢳뢵뢶뢷뢹",4],["8f81","뢾뢿룂룄룆",5,"룍룎룏룑룒룓룕",7,"룞룠룢",5,"룪룫룭룮룯룱",6,"룺룼룾",5,"뤅",18,"뤙",6,"뤡",26,"뤾뤿륁륂륃륅",6,"륍륎륐륒",5],["9041","륚륛륝륞륟륡",6,"륪륬륮",5,"륶륷륹륺륻륽"],["9061","륾",5,"릆릈릋릌릏",15],["9081","릟",12,"릮릯릱릲릳릵",6,"릾맀맂",5,"맊맋맍맓",4,"맚맜맟맠맢맦맧맩맪맫맭",6,"맶맻",4,"먂",5,"먉",11,"먖",33,"먺먻먽먾먿멁멃멄멅멆"],["9141","멇멊멌멏멐멑멒멖멗멙멚멛멝",6,"멦멪",5],["9161","멲멳멵멶멷멹",9,"몆몈몉몊몋몍",5],["9181","몓",20,"몪몭몮몯몱몳",4,"몺몼몾",5,"뫅뫆뫇뫉",14,"뫚",33,"뫽뫾뫿묁묂묃묅",7,"묎묐묒",5,"묙묚묛묝묞묟묡",6],["9241","묨묪묬",7,"묷묹묺묿",4,"뭆뭈뭊뭋뭌뭎뭑뭒"],["9261","뭓뭕뭖뭗뭙",7,"뭢뭤",7,"뭭",4],["9281","뭲",21,"뮉뮊뮋뮍뮎뮏뮑",18,"뮥뮦뮧뮩뮪뮫뮭",6,"뮵뮶뮸",7,"믁믂믃믅믆믇믉",6,"믑믒믔",35,"믺믻믽믾밁"],["9341","밃",4,"밊밎밐밒밓밙밚밠밡밢밣밦밨밪밫밬밮밯밲밳밵"],["9361","밶밷밹",6,"뱂뱆뱇뱈뱊뱋뱎뱏뱑",8],["9381","뱚뱛뱜뱞",37,"벆벇벉벊벍벏",4,"벖벘벛",4,"벢벣벥벦벩",6,"벲벶",5,"벾벿볁볂볃볅",7,"볎볒볓볔볖볗볙볚볛볝",22,"볷볹볺볻볽"],["9441","볾",5,"봆봈봊",5,"봑봒봓봕",8],["9461","봞",5,"봥",6,"봭",12],["9481","봺",5,"뵁",6,"뵊뵋뵍뵎뵏뵑",6,"뵚",9,"뵥뵦뵧뵩",22,"붂붃붅붆붋",4,"붒붔붖붗붘붛붝",6,"붥",10,"붱",6,"붹",24],["9541","뷒뷓뷖뷗뷙뷚뷛뷝",11,"뷪",5,"뷱"],["9561","뷲뷳뷵뷶뷷뷹",6,"븁븂븄븆",5,"븎븏븑븒븓"],["9581","븕",6,"븞븠",35,"빆빇빉빊빋빍빏",4,"빖빘빜빝빞빟빢빣빥빦빧빩빫",4,"빲빶",4,"빾빿뺁뺂뺃뺅",6,"뺎뺒",5,"뺚",13,"뺩",14],["9641","뺸",23,"뻒뻓"],["9661","뻕뻖뻙",6,"뻡뻢뻦",5,"뻭",8],["9681","뻶",10,"뼂",5,"뼊",13,"뼚뼞",33,"뽂뽃뽅뽆뽇뽉",6,"뽒뽓뽔뽖",44],["9741","뾃",16,"뾕",8],["9761","뾞",17,"뾱",7],["9781","뾹",11,"뿆",5,"뿎뿏뿑뿒뿓뿕",6,"뿝뿞뿠뿢",89,"쀽쀾쀿"],["9841","쁀",16,"쁒",5,"쁙쁚쁛"],["9861","쁝쁞쁟쁡",6,"쁪",15],["9881","쁺",21,"삒삓삕삖삗삙",6,"삢삤삦",5,"삮삱삲삷",4,"삾샂샃샄샆샇샊샋샍샎샏샑",6,"샚샞",5,"샦샧샩샪샫샭",6,"샶샸샺",5,"섁섂섃섅섆섇섉",6,"섑섒섓섔섖",5,"섡섢섥섨섩섪섫섮"],["9941","섲섳섴섵섷섺섻섽섾섿셁",6,"셊셎",5,"셖셗"],["9961","셙셚셛셝",6,"셦셪",5,"셱셲셳셵셶셷셹셺셻"],["9981","셼",8,"솆",5,"솏솑솒솓솕솗",4,"솞솠솢솣솤솦솧솪솫솭솮솯솱",11,"솾",5,"쇅쇆쇇쇉쇊쇋쇍",6,"쇕쇖쇙",6,"쇡쇢쇣쇥쇦쇧쇩",6,"쇲쇴",7,"쇾쇿숁숂숃숅",6,"숎숐숒",5,"숚숛숝숞숡숢숣"],["9a41","숤숥숦숧숪숬숮숰숳숵",16],["9a61","쉆쉇쉉",6,"쉒쉓쉕쉖쉗쉙",6,"쉡쉢쉣쉤쉦"],["9a81","쉧",4,"쉮쉯쉱쉲쉳쉵",6,"쉾슀슂",5,"슊",5,"슑",6,"슙슚슜슞",5,"슦슧슩슪슫슮",5,"슶슸슺",33,"싞싟싡싢싥",5,"싮싰싲싳싴싵싷싺싽싾싿쌁",6,"쌊쌋쌎쌏"],["9b41","쌐쌑쌒쌖쌗쌙쌚쌛쌝",6,"쌦쌧쌪",8],["9b61","쌳",17,"썆",7],["9b81","썎",25,"썪썫썭썮썯썱썳",4,"썺썻썾",5,"쎅쎆쎇쎉쎊쎋쎍",50,"쏁",22,"쏚"],["9c41","쏛쏝쏞쏡쏣",4,"쏪쏫쏬쏮",5,"쏶쏷쏹",5],["9c61","쏿",8,"쐉",6,"쐑",9],["9c81","쐛",8,"쐥",6,"쐭쐮쐯쐱쐲쐳쐵",6,"쐾",9,"쑉",26,"쑦쑧쑩쑪쑫쑭",6,"쑶쑷쑸쑺",5,"쒁",18,"쒕",6,"쒝",12],["9d41","쒪",13,"쒹쒺쒻쒽",8],["9d61","쓆",25],["9d81","쓠",8,"쓪",5,"쓲쓳쓵쓶쓷쓹쓻쓼쓽쓾씂",9,"씍씎씏씑씒씓씕",6,"씝",10,"씪씫씭씮씯씱",6,"씺씼씾",5,"앆앇앋앏앐앑앒앖앚앛앜앟앢앣앥앦앧앩",6,"앲앶",5,"앾앿얁얂얃얅얆얈얉얊얋얎얐얒얓얔"],["9e41","얖얙얚얛얝얞얟얡",7,"얪",9,"얶"],["9e61","얷얺얿",4,"엋엍엏엒엓엕엖엗엙",6,"엢엤엦엧"],["9e81","엨엩엪엫엯엱엲엳엵엸엹엺엻옂옃옄옉옊옋옍옎옏옑",6,"옚옝",6,"옦옧옩옪옫옯옱옲옶옸옺옼옽옾옿왂왃왅왆왇왉",6,"왒왖",5,"왞왟왡",10,"왭왮왰왲",5,"왺왻왽왾왿욁",6,"욊욌욎",5,"욖욗욙욚욛욝",6,"욦"],["9f41","욨욪",5,"욲욳욵욶욷욻",4,"웂웄웆",5,"웎"],["9f61","웏웑웒웓웕",6,"웞웟웢",5,"웪웫웭웮웯웱웲"],["9f81","웳",4,"웺웻웼웾",5,"윆윇윉윊윋윍",6,"윖윘윚",5,"윢윣윥윦윧윩",6,"윲윴윶윸윹윺윻윾윿읁읂읃읅",4,"읋읎읐읙읚읛읝읞읟읡",6,"읩읪읬",7,"읶읷읹읺읻읿잀잁잂잆잋잌잍잏잒잓잕잙잛",4,"잢잧",4,"잮잯잱잲잳잵잶잷"],["a041","잸잹잺잻잾쟂",5,"쟊쟋쟍쟏쟑",6,"쟙쟚쟛쟜"],["a061","쟞",5,"쟥쟦쟧쟩쟪쟫쟭",13],["a081","쟻",4,"젂젃젅젆젇젉젋",4,"젒젔젗",4,"젞젟젡젢젣젥",6,"젮젰젲",5,"젹젺젻젽젾젿졁",6,"졊졋졎",5,"졕",26,"졲졳졵졶졷졹졻",4,"좂좄좈좉좊좎",5,"좕",7,"좞좠좢좣좤"],["a141","좥좦좧좩",18,"좾좿죀죁"],["a161","죂죃죅죆죇죉죊죋죍",6,"죖죘죚",5,"죢죣죥"],["a181","죦",14,"죶",5,"죾죿줁줂줃줇",4,"줎　、。·‥…¨〃­―∥＼∼‘’“”〔〕〈",9,"±×÷≠≤≥∞∴°′″℃Å￠￡￥♂♀∠⊥⌒∂∇≡≒§※☆★○●◎◇◆□■△▲▽▼→←↑↓↔〓≪≫√∽∝∵∫∬∈∋⊆⊇⊂⊃∪∩∧∨￢"],["a241","줐줒",5,"줙",18],["a261","줭",6,"줵",18],["a281","쥈",7,"쥒쥓쥕쥖쥗쥙",6,"쥢쥤",7,"쥭쥮쥯⇒⇔∀∃´～ˇ˘˝˚˙¸˛¡¿ː∮∑∏¤℉‰◁◀▷▶♤♠♡♥♧♣⊙◈▣◐◑▒▤▥▨▧▦▩♨☏☎☜☞¶†‡↕↗↙↖↘♭♩♪♬㉿㈜№㏇™㏂㏘℡€®"],["a341","쥱쥲쥳쥵",6,"쥽",10,"즊즋즍즎즏"],["a361","즑",6,"즚즜즞",16],["a381","즯",16,"짂짃짅짆짉짋",4,"짒짔짗짘짛！",58,"￦］",32,"￣"],["a441","짞짟짡짣짥짦짨짩짪짫짮짲",5,"짺짻짽짾짿쨁쨂쨃쨄"],["a461","쨅쨆쨇쨊쨎",5,"쨕쨖쨗쨙",12],["a481","쨦쨧쨨쨪",28,"ㄱ",93],["a541","쩇",4,"쩎쩏쩑쩒쩓쩕",6,"쩞쩢",5,"쩩쩪"],["a561","쩫",17,"쩾",5,"쪅쪆"],["a581","쪇",16,"쪙",14,"ⅰ",9],["a5b0","Ⅰ",9],["a5c1","Α",16,"Σ",6],["a5e1","α",16,"σ",6],["a641","쪨",19,"쪾쪿쫁쫂쫃쫅"],["a661","쫆",5,"쫎쫐쫒쫔쫕쫖쫗쫚",5,"쫡",6],["a681","쫨쫩쫪쫫쫭",6,"쫵",18,"쬉쬊─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂┒┑┚┙┖┕┎┍┞┟┡┢┦┧┩┪┭┮┱┲┵┶┹┺┽┾╀╁╃",7],["a741","쬋",4,"쬑쬒쬓쬕쬖쬗쬙",6,"쬢",7],["a761","쬪",22,"쭂쭃쭄"],["a781","쭅쭆쭇쭊쭋쭍쭎쭏쭑",6,"쭚쭛쭜쭞",5,"쭥",7,"㎕㎖㎗ℓ㎘㏄㎣㎤㎥㎦㎙",9,"㏊㎍㎎㎏㏏㎈㎉㏈㎧㎨㎰",9,"㎀",4,"㎺",5,"㎐",4,"Ω㏀㏁㎊㎋㎌㏖㏅㎭㎮㎯㏛㎩㎪㎫㎬㏝㏐㏓㏃㏉㏜㏆"],["a841","쭭",10,"쭺",14],["a861","쮉",18,"쮝",6],["a881","쮤",19,"쮹",11,"ÆÐªĦ"],["a8a6","Ĳ"],["a8a8","ĿŁØŒºÞŦŊ"],["a8b1","㉠",27,"ⓐ",25,"①",14,"½⅓⅔¼¾⅛⅜⅝⅞"],["a941","쯅",14,"쯕",10],["a961","쯠쯡쯢쯣쯥쯦쯨쯪",18],["a981","쯽",14,"찎찏찑찒찓찕",6,"찞찟찠찣찤æđðħıĳĸŀłøœßþŧŋŉ㈀",27,"⒜",25,"⑴",14,"¹²³⁴ⁿ₁₂₃₄"],["aa41","찥찦찪찫찭찯찱",6,"찺찿",4,"챆챇챉챊챋챍챎"],["aa61","챏",4,"챖챚",5,"챡챢챣챥챧챩",6,"챱챲"],["aa81","챳챴챶",29,"ぁ",82],["ab41","첔첕첖첗첚첛첝첞첟첡",6,"첪첮",5,"첶첷첹"],["ab61","첺첻첽",6,"쳆쳈쳊",5,"쳑쳒쳓쳕",5],["ab81","쳛",8,"쳥",6,"쳭쳮쳯쳱",12,"ァ",85],["ac41","쳾쳿촀촂",5,"촊촋촍촎촏촑",6,"촚촜촞촟촠"],["ac61","촡촢촣촥촦촧촩촪촫촭",11,"촺",4],["ac81","촿",28,"쵝쵞쵟А",5,"ЁЖ",25],["acd1","а",5,"ёж",25],["ad41","쵡쵢쵣쵥",6,"쵮쵰쵲",5,"쵹",7],["ad61","춁",6,"춉",10,"춖춗춙춚춛춝춞춟"],["ad81","춠춡춢춣춦춨춪",5,"춱",18,"췅"],["ae41","췆",5,"췍췎췏췑",16],["ae61","췢",5,"췩췪췫췭췮췯췱",6,"췺췼췾",4],["ae81","츃츅츆츇츉츊츋츍",6,"츕츖츗츘츚",5,"츢츣츥츦츧츩츪츫"],["af41","츬츭츮츯츲츴츶",19],["af61","칊",13,"칚칛칝칞칢",5,"칪칬"],["af81","칮",5,"칶칷칹칺칻칽",6,"캆캈캊",5,"캒캓캕캖캗캙"],["b041","캚",5,"캢캦",5,"캮",12],["b061","캻",5,"컂",19],["b081","컖",13,"컦컧컩컪컭",6,"컶컺",5,"가각간갇갈갉갊감",7,"같",4,"갠갤갬갭갯갰갱갸갹갼걀걋걍걔걘걜거걱건걷걸걺검겁것겄겅겆겉겊겋게겐겔겜겝겟겠겡겨격겪견겯결겸겹겻겼경곁계곈곌곕곗고곡곤곧골곪곬곯곰곱곳공곶과곽관괄괆"],["b141","켂켃켅켆켇켉",6,"켒켔켖",5,"켝켞켟켡켢켣"],["b161","켥",6,"켮켲",5,"켹",11],["b181","콅",14,"콖콗콙콚콛콝",6,"콦콨콪콫콬괌괍괏광괘괜괠괩괬괭괴괵괸괼굄굅굇굉교굔굘굡굣구국군굳굴굵굶굻굼굽굿궁궂궈궉권궐궜궝궤궷귀귁귄귈귐귑귓규균귤그극근귿글긁금급긋긍긔기긱긴긷길긺김깁깃깅깆깊까깍깎깐깔깖깜깝깟깠깡깥깨깩깬깰깸"],["b241","콭콮콯콲콳콵콶콷콹",6,"쾁쾂쾃쾄쾆",5,"쾍"],["b261","쾎",18,"쾢",5,"쾩"],["b281","쾪",5,"쾱",18,"쿅",6,"깹깻깼깽꺄꺅꺌꺼꺽꺾껀껄껌껍껏껐껑께껙껜껨껫껭껴껸껼꼇꼈꼍꼐꼬꼭꼰꼲꼴꼼꼽꼿꽁꽂꽃꽈꽉꽐꽜꽝꽤꽥꽹꾀꾄꾈꾐꾑꾕꾜꾸꾹꾼꿀꿇꿈꿉꿋꿍꿎꿔꿜꿨꿩꿰꿱꿴꿸뀀뀁뀄뀌뀐뀔뀜뀝뀨끄끅끈끊끌끎끓끔끕끗끙"],["b341","쿌",19,"쿢쿣쿥쿦쿧쿩"],["b361","쿪",5,"쿲쿴쿶",5,"쿽쿾쿿퀁퀂퀃퀅",5],["b381","퀋",5,"퀒",5,"퀙",19,"끝끼끽낀낄낌낍낏낑나낙낚난낟날낡낢남납낫",4,"낱낳내낵낸낼냄냅냇냈냉냐냑냔냘냠냥너넉넋넌널넒넓넘넙넛넜넝넣네넥넨넬넴넵넷넸넹녀녁년녈념녑녔녕녘녜녠노녹논놀놂놈놉놋농높놓놔놘놜놨뇌뇐뇔뇜뇝"],["b441","퀮",5,"퀶퀷퀹퀺퀻퀽",6,"큆큈큊",5],["b461","큑큒큓큕큖큗큙",6,"큡",10,"큮큯"],["b481","큱큲큳큵",6,"큾큿킀킂",18,"뇟뇨뇩뇬뇰뇹뇻뇽누눅눈눋눌눔눕눗눙눠눴눼뉘뉜뉠뉨뉩뉴뉵뉼늄늅늉느늑는늘늙늚늠늡늣능늦늪늬늰늴니닉닌닐닒님닙닛닝닢다닥닦단닫",4,"닳담답닷",4,"닿대댁댄댈댐댑댓댔댕댜더덕덖던덛덜덞덟덤덥"],["b541","킕",14,"킦킧킩킪킫킭",5],["b561","킳킶킸킺",5,"탂탃탅탆탇탊",5,"탒탖",4],["b581","탛탞탟탡탢탣탥",6,"탮탲",5,"탹",11,"덧덩덫덮데덱덴델뎀뎁뎃뎄뎅뎌뎐뎔뎠뎡뎨뎬도독돈돋돌돎돐돔돕돗동돛돝돠돤돨돼됐되된될됨됩됫됴두둑둔둘둠둡둣둥둬뒀뒈뒝뒤뒨뒬뒵뒷뒹듀듄듈듐듕드득든듣들듦듬듭듯등듸디딕딘딛딜딤딥딧딨딩딪따딱딴딸"],["b641","턅",7,"턎",17],["b661","턠",15,"턲턳턵턶턷턹턻턼턽턾"],["b681","턿텂텆",5,"텎텏텑텒텓텕",6,"텞텠텢",5,"텩텪텫텭땀땁땃땄땅땋때땍땐땔땜땝땟땠땡떠떡떤떨떪떫떰떱떳떴떵떻떼떽뗀뗄뗌뗍뗏뗐뗑뗘뗬또똑똔똘똥똬똴뙈뙤뙨뚜뚝뚠뚤뚫뚬뚱뛔뛰뛴뛸뜀뜁뜅뜨뜩뜬뜯뜰뜸뜹뜻띄띈띌띔띕띠띤띨띰띱띳띵라락란랄람랍랏랐랑랒랖랗"],["b741","텮",13,"텽",6,"톅톆톇톉톊"],["b761","톋",20,"톢톣톥톦톧"],["b781","톩",6,"톲톴톶톷톸톹톻톽톾톿퇁",14,"래랙랜랠램랩랫랬랭랴략랸럇량러럭런럴럼럽럿렀렁렇레렉렌렐렘렙렛렝려력련렬렴렵렷렸령례롄롑롓로록론롤롬롭롯롱롸롼뢍뢨뢰뢴뢸룀룁룃룅료룐룔룝룟룡루룩룬룰룸룹룻룽뤄뤘뤠뤼뤽륀륄륌륏륑류륙륜률륨륩"],["b841","퇐",7,"퇙",17],["b861","퇫",8,"퇵퇶퇷퇹",13],["b881","툈툊",5,"툑",24,"륫륭르륵른를름릅릇릉릊릍릎리릭린릴림립릿링마막만많",4,"맘맙맛망맞맡맣매맥맨맬맴맵맷맸맹맺먀먁먈먕머먹먼멀멂멈멉멋멍멎멓메멕멘멜멤멥멧멨멩며멱면멸몃몄명몇몌모목몫몬몰몲몸몹못몽뫄뫈뫘뫙뫼"],["b941","툪툫툮툯툱툲툳툵",6,"툾퉀퉂",5,"퉉퉊퉋퉌"],["b961","퉍",14,"퉝",6,"퉥퉦퉧퉨"],["b981","퉩",22,"튂튃튅튆튇튉튊튋튌묀묄묍묏묑묘묜묠묩묫무묵묶문묻물묽묾뭄뭅뭇뭉뭍뭏뭐뭔뭘뭡뭣뭬뮈뮌뮐뮤뮨뮬뮴뮷므믄믈믐믓미믹민믿밀밂밈밉밋밌밍및밑바",4,"받",4,"밤밥밧방밭배백밴밸뱀뱁뱃뱄뱅뱉뱌뱍뱐뱝버벅번벋벌벎범법벗"],["ba41","튍튎튏튒튓튔튖",5,"튝튞튟튡튢튣튥",6,"튭"],["ba61","튮튯튰튲",5,"튺튻튽튾틁틃",4,"틊틌",5],["ba81","틒틓틕틖틗틙틚틛틝",6,"틦",9,"틲틳틵틶틷틹틺벙벚베벡벤벧벨벰벱벳벴벵벼벽변별볍볏볐병볕볘볜보복볶본볼봄봅봇봉봐봔봤봬뵀뵈뵉뵌뵐뵘뵙뵤뵨부북분붇불붉붊붐붑붓붕붙붚붜붤붰붸뷔뷕뷘뷜뷩뷰뷴뷸븀븃븅브븍븐블븜븝븟비빅빈빌빎빔빕빗빙빚빛빠빡빤"],["bb41","틻",4,"팂팄팆",5,"팏팑팒팓팕팗",4,"팞팢팣"],["bb61","팤팦팧팪팫팭팮팯팱",6,"팺팾",5,"퍆퍇퍈퍉"],["bb81","퍊",31,"빨빪빰빱빳빴빵빻빼빽뺀뺄뺌뺍뺏뺐뺑뺘뺙뺨뻐뻑뻔뻗뻘뻠뻣뻤뻥뻬뼁뼈뼉뼘뼙뼛뼜뼝뽀뽁뽄뽈뽐뽑뽕뾔뾰뿅뿌뿍뿐뿔뿜뿟뿡쀼쁑쁘쁜쁠쁨쁩삐삑삔삘삠삡삣삥사삭삯산삳살삵삶삼삽삿샀상샅새색샌샐샘샙샛샜생샤"],["bc41","퍪",17,"퍾퍿펁펂펃펅펆펇"],["bc61","펈펉펊펋펎펒",5,"펚펛펝펞펟펡",6,"펪펬펮"],["bc81","펯",4,"펵펶펷펹펺펻펽",6,"폆폇폊",5,"폑",5,"샥샨샬샴샵샷샹섀섄섈섐섕서",4,"섣설섦섧섬섭섯섰성섶세섹센셀셈셉셋셌셍셔셕션셜셤셥셧셨셩셰셴셸솅소속솎손솔솖솜솝솟송솥솨솩솬솰솽쇄쇈쇌쇔쇗쇘쇠쇤쇨쇰쇱쇳쇼쇽숀숄숌숍숏숑수숙순숟술숨숩숫숭"],["bd41","폗폙",7,"폢폤",7,"폮폯폱폲폳폵폶폷"],["bd61","폸폹폺폻폾퐀퐂",5,"퐉",13],["bd81","퐗",5,"퐞",25,"숯숱숲숴쉈쉐쉑쉔쉘쉠쉥쉬쉭쉰쉴쉼쉽쉿슁슈슉슐슘슛슝스슥슨슬슭슴습슷승시식신싣실싫심십싯싱싶싸싹싻싼쌀쌈쌉쌌쌍쌓쌔쌕쌘쌜쌤쌥쌨쌩썅써썩썬썰썲썸썹썼썽쎄쎈쎌쏀쏘쏙쏜쏟쏠쏢쏨쏩쏭쏴쏵쏸쐈쐐쐤쐬쐰"],["be41","퐸",7,"푁푂푃푅",14],["be61","푔",7,"푝푞푟푡푢푣푥",7,"푮푰푱푲"],["be81","푳",4,"푺푻푽푾풁풃",4,"풊풌풎",5,"풕",8,"쐴쐼쐽쑈쑤쑥쑨쑬쑴쑵쑹쒀쒔쒜쒸쒼쓩쓰쓱쓴쓸쓺쓿씀씁씌씐씔씜씨씩씬씰씸씹씻씽아악안앉않알앍앎앓암압앗았앙앝앞애액앤앨앰앱앳앴앵야약얀얄얇얌얍얏양얕얗얘얜얠얩어억언얹얻얼얽얾엄",6,"엌엎"],["bf41","풞",10,"풪",14],["bf61","풹",18,"퓍퓎퓏퓑퓒퓓퓕"],["bf81","퓖",5,"퓝퓞퓠",7,"퓩퓪퓫퓭퓮퓯퓱",6,"퓹퓺퓼에엑엔엘엠엡엣엥여역엮연열엶엷염",5,"옅옆옇예옌옐옘옙옛옜오옥온올옭옮옰옳옴옵옷옹옻와왁완왈왐왑왓왔왕왜왝왠왬왯왱외왹왼욀욈욉욋욍요욕욘욜욤욥욧용우욱운울욹욺움웁웃웅워웍원월웜웝웠웡웨"],["c041","퓾",5,"픅픆픇픉픊픋픍",6,"픖픘",5],["c061","픞",25],["c081","픸픹픺픻픾픿핁핂핃핅",6,"핎핐핒",5,"핚핛핝핞핟핡핢핣웩웬웰웸웹웽위윅윈윌윔윕윗윙유육윤율윰윱윳융윷으윽은을읊음읍읏응",7,"읜읠읨읫이익인일읽읾잃임입잇있잉잊잎자작잔잖잗잘잚잠잡잣잤장잦재잭잰잴잼잽잿쟀쟁쟈쟉쟌쟎쟐쟘쟝쟤쟨쟬저적전절젊"],["c141","핤핦핧핪핬핮",5,"핶핷핹핺핻핽",6,"햆햊햋"],["c161","햌햍햎햏햑",19,"햦햧"],["c181","햨",31,"점접젓정젖제젝젠젤젬젭젯젱져젼졀졈졉졌졍졔조족존졸졺좀좁좃종좆좇좋좌좍좔좝좟좡좨좼좽죄죈죌죔죕죗죙죠죡죤죵주죽준줄줅줆줌줍줏중줘줬줴쥐쥑쥔쥘쥠쥡쥣쥬쥰쥴쥼즈즉즌즐즘즙즛증지직진짇질짊짐집짓"],["c241","헊헋헍헎헏헑헓",4,"헚헜헞",5,"헦헧헩헪헫헭헮"],["c261","헯",4,"헶헸헺",5,"혂혃혅혆혇혉",6,"혒"],["c281","혖",5,"혝혞혟혡혢혣혥",7,"혮",9,"혺혻징짖짙짚짜짝짠짢짤짧짬짭짯짰짱째짹짼쨀쨈쨉쨋쨌쨍쨔쨘쨩쩌쩍쩐쩔쩜쩝쩟쩠쩡쩨쩽쪄쪘쪼쪽쫀쫄쫌쫍쫏쫑쫓쫘쫙쫠쫬쫴쬈쬐쬔쬘쬠쬡쭁쭈쭉쭌쭐쭘쭙쭝쭤쭸쭹쮜쮸쯔쯤쯧쯩찌찍찐찔찜찝찡찢찧차착찬찮찰참찹찻"],["c341","혽혾혿홁홂홃홄홆홇홊홌홎홏홐홒홓홖홗홙홚홛홝",4],["c361","홢",4,"홨홪",5,"홲홳홵",11],["c381","횁횂횄횆",5,"횎횏횑횒횓횕",7,"횞횠횢",5,"횩횪찼창찾채책챈챌챔챕챗챘챙챠챤챦챨챰챵처척천철첨첩첫첬청체첵첸첼쳄쳅쳇쳉쳐쳔쳤쳬쳰촁초촉촌촐촘촙촛총촤촨촬촹최쵠쵤쵬쵭쵯쵱쵸춈추축춘출춤춥춧충춰췄췌췐취췬췰췸췹췻췽츄츈츌츔츙츠측츤츨츰츱츳층"],["c441","횫횭횮횯횱",7,"횺횼",7,"훆훇훉훊훋"],["c461","훍훎훏훐훒훓훕훖훘훚",5,"훡훢훣훥훦훧훩",4],["c481","훮훯훱훲훳훴훶",5,"훾훿휁휂휃휅",11,"휒휓휔치칙친칟칠칡침칩칫칭카칵칸칼캄캅캇캉캐캑캔캘캠캡캣캤캥캬캭컁커컥컨컫컬컴컵컷컸컹케켁켄켈켐켑켓켕켜켠켤켬켭켯켰켱켸코콕콘콜콤콥콧콩콰콱콴콸쾀쾅쾌쾡쾨쾰쿄쿠쿡쿤쿨쿰쿱쿳쿵쿼퀀퀄퀑퀘퀭퀴퀵퀸퀼"],["c541","휕휖휗휚휛휝휞휟휡",6,"휪휬휮",5,"휶휷휹"],["c561","휺휻휽",6,"흅흆흈흊",5,"흒흓흕흚",4],["c581","흟흢흤흦흧흨흪흫흭흮흯흱흲흳흵",6,"흾흿힀힂",5,"힊힋큄큅큇큉큐큔큘큠크큭큰클큼큽킁키킥킨킬킴킵킷킹타탁탄탈탉탐탑탓탔탕태택탠탤탬탭탯탰탱탸턍터턱턴털턺텀텁텃텄텅테텍텐텔템텝텟텡텨텬텼톄톈토톡톤톨톰톱톳통톺톼퇀퇘퇴퇸툇툉툐투툭툰툴툼툽툿퉁퉈퉜"],["c641","힍힎힏힑",6,"힚힜힞",5],["c6a1","퉤튀튁튄튈튐튑튕튜튠튤튬튱트특튼튿틀틂틈틉틋틔틘틜틤틥티틱틴틸팀팁팃팅파팍팎판팔팖팜팝팟팠팡팥패팩팬팰팸팹팻팼팽퍄퍅퍼퍽펀펄펌펍펏펐펑페펙펜펠펨펩펫펭펴편펼폄폅폈평폐폘폡폣포폭폰폴폼폽폿퐁"],["c7a1","퐈퐝푀푄표푠푤푭푯푸푹푼푿풀풂품풉풋풍풔풩퓌퓐퓔퓜퓟퓨퓬퓰퓸퓻퓽프픈플픔픕픗피픽핀필핌핍핏핑하학한할핥함합핫항해핵핸핼햄햅햇했행햐향허헉헌헐헒험헙헛헝헤헥헨헬헴헵헷헹혀혁현혈혐협혓혔형혜혠"],["c8a1","혤혭호혹혼홀홅홈홉홋홍홑화확환활홧황홰홱홴횃횅회획횐횔횝횟횡효횬횰횹횻후훅훈훌훑훔훗훙훠훤훨훰훵훼훽휀휄휑휘휙휜휠휨휩휫휭휴휵휸휼흄흇흉흐흑흔흖흗흘흙흠흡흣흥흩희흰흴흼흽힁히힉힌힐힘힙힛힝"],["caa1","伽佳假價加可呵哥嘉嫁家暇架枷柯歌珂痂稼苛茄街袈訶賈跏軻迦駕刻却各恪慤殼珏脚覺角閣侃刊墾奸姦干幹懇揀杆柬桿澗癎看磵稈竿簡肝艮艱諫間乫喝曷渴碣竭葛褐蝎鞨勘坎堪嵌感憾戡敢柑橄減甘疳監瞰紺邯鑑鑒龕"],["cba1","匣岬甲胛鉀閘剛堈姜岡崗康强彊慷江畺疆糠絳綱羌腔舡薑襁講鋼降鱇介价個凱塏愷愾慨改槪漑疥皆盖箇芥蓋豈鎧開喀客坑更粳羹醵倨去居巨拒据據擧渠炬祛距踞車遽鉅鋸乾件健巾建愆楗腱虔蹇鍵騫乞傑杰桀儉劍劒檢"],["cca1","瞼鈐黔劫怯迲偈憩揭擊格檄激膈覡隔堅牽犬甄絹繭肩見譴遣鵑抉決潔結缺訣兼慊箝謙鉗鎌京俓倞傾儆勁勍卿坰境庚徑慶憬擎敬景暻更梗涇炅烱璟璥瓊痙硬磬竟競絅經耕耿脛莖警輕逕鏡頃頸驚鯨係啓堺契季屆悸戒桂械"],["cda1","棨溪界癸磎稽系繫繼計誡谿階鷄古叩告呱固姑孤尻庫拷攷故敲暠枯槁沽痼皐睾稿羔考股膏苦苽菰藁蠱袴誥賈辜錮雇顧高鼓哭斛曲梏穀谷鵠困坤崑昆梱棍滾琨袞鯤汨滑骨供公共功孔工恐恭拱控攻珙空蚣貢鞏串寡戈果瓜"],["cea1","科菓誇課跨過鍋顆廓槨藿郭串冠官寬慣棺款灌琯瓘管罐菅觀貫關館刮恝括适侊光匡壙廣曠洸炚狂珖筐胱鑛卦掛罫乖傀塊壞怪愧拐槐魁宏紘肱轟交僑咬喬嬌嶠巧攪敎校橋狡皎矯絞翹膠蕎蛟較轎郊餃驕鮫丘久九仇俱具勾"],["cfa1","區口句咎嘔坵垢寇嶇廐懼拘救枸柩構歐毆毬求溝灸狗玖球瞿矩究絿耉臼舅舊苟衢謳購軀逑邱鉤銶駒驅鳩鷗龜國局菊鞠鞫麴君窘群裙軍郡堀屈掘窟宮弓穹窮芎躬倦券勸卷圈拳捲權淃眷厥獗蕨蹶闕机櫃潰詭軌饋句晷歸貴"],["d0a1","鬼龜叫圭奎揆槻珪硅窺竅糾葵規赳逵閨勻均畇筠菌鈞龜橘克剋劇戟棘極隙僅劤勤懃斤根槿瑾筋芹菫覲謹近饉契今妗擒昑檎琴禁禽芩衾衿襟金錦伋及急扱汲級給亘兢矜肯企伎其冀嗜器圻基埼夔奇妓寄岐崎己幾忌技旗旣"],["d1a1","朞期杞棋棄機欺氣汽沂淇玘琦琪璂璣畸畿碁磯祁祇祈祺箕紀綺羈耆耭肌記譏豈起錡錤飢饑騎騏驥麒緊佶吉拮桔金喫儺喇奈娜懦懶拏拿癩",5,"那樂",4,"諾酪駱亂卵暖欄煖爛蘭難鸞捏捺南嵐枏楠湳濫男藍襤拉"],["d2a1","納臘蠟衲囊娘廊",4,"乃來內奈柰耐冷女年撚秊念恬拈捻寧寗努勞奴弩怒擄櫓爐瑙盧",5,"駑魯",10,"濃籠聾膿農惱牢磊腦賂雷尿壘",7,"嫩訥杻紐勒",5,"能菱陵尼泥匿溺多茶"],["d3a1","丹亶但單團壇彖斷旦檀段湍短端簞緞蛋袒鄲鍛撻澾獺疸達啖坍憺擔曇淡湛潭澹痰聃膽蕁覃談譚錟沓畓答踏遝唐堂塘幢戇撞棠當糖螳黨代垈坮大對岱帶待戴擡玳臺袋貸隊黛宅德悳倒刀到圖堵塗導屠島嶋度徒悼挑掉搗桃"],["d4a1","棹櫂淘渡滔濤燾盜睹禱稻萄覩賭跳蹈逃途道都鍍陶韜毒瀆牘犢獨督禿篤纛讀墩惇敦旽暾沌焞燉豚頓乭突仝冬凍動同憧東桐棟洞潼疼瞳童胴董銅兜斗杜枓痘竇荳讀豆逗頭屯臀芚遁遯鈍得嶝橙燈登等藤謄鄧騰喇懶拏癩羅"],["d5a1","蘿螺裸邏樂洛烙珞絡落諾酪駱丹亂卵欄欒瀾爛蘭鸞剌辣嵐擥攬欖濫籃纜藍襤覽拉臘蠟廊朗浪狼琅瑯螂郞來崍徠萊冷掠略亮倆兩凉梁樑粮粱糧良諒輛量侶儷勵呂廬慮戾旅櫚濾礪藜蠣閭驢驪麗黎力曆歷瀝礫轢靂憐戀攣漣"],["d6a1","煉璉練聯蓮輦連鍊冽列劣洌烈裂廉斂殮濂簾獵令伶囹寧岺嶺怜玲笭羚翎聆逞鈴零靈領齡例澧禮醴隷勞怒撈擄櫓潞瀘爐盧老蘆虜路輅露魯鷺鹵碌祿綠菉錄鹿麓論壟弄朧瀧瓏籠聾儡瀨牢磊賂賚賴雷了僚寮廖料燎療瞭聊蓼"],["d7a1","遼鬧龍壘婁屢樓淚漏瘻累縷蔞褸鏤陋劉旒柳榴流溜瀏琉瑠留瘤硫謬類六戮陸侖倫崙淪綸輪律慄栗率隆勒肋凜凌楞稜綾菱陵俚利厘吏唎履悧李梨浬犁狸理璃異痢籬罹羸莉裏裡里釐離鯉吝潾燐璘藺躪隣鱗麟林淋琳臨霖砬"],["d8a1","立笠粒摩瑪痲碼磨馬魔麻寞幕漠膜莫邈万卍娩巒彎慢挽晩曼滿漫灣瞞萬蔓蠻輓饅鰻唜抹末沫茉襪靺亡妄忘忙望網罔芒茫莽輞邙埋妹媒寐昧枚梅每煤罵買賣邁魅脈貊陌驀麥孟氓猛盲盟萌冪覓免冕勉棉沔眄眠綿緬面麵滅"],["d9a1","蔑冥名命明暝椧溟皿瞑茗蓂螟酩銘鳴袂侮冒募姆帽慕摸摹暮某模母毛牟牡瑁眸矛耗芼茅謀謨貌木沐牧目睦穆鶩歿沒夢朦蒙卯墓妙廟描昴杳渺猫竗苗錨務巫憮懋戊拇撫无楙武毋無珷畝繆舞茂蕪誣貿霧鵡墨默們刎吻問文"],["daa1","汶紊紋聞蚊門雯勿沕物味媚尾嵋彌微未梶楣渼湄眉米美薇謎迷靡黴岷悶愍憫敏旻旼民泯玟珉緡閔密蜜謐剝博拍搏撲朴樸泊珀璞箔粕縛膊舶薄迫雹駁伴半反叛拌搬攀斑槃泮潘班畔瘢盤盼磐磻礬絆般蟠返頒飯勃拔撥渤潑"],["dba1","發跋醱鉢髮魃倣傍坊妨尨幇彷房放方旁昉枋榜滂磅紡肪膀舫芳蒡蚌訪謗邦防龐倍俳北培徘拜排杯湃焙盃背胚裴裵褙賠輩配陪伯佰帛柏栢白百魄幡樊煩燔番磻繁蕃藩飜伐筏罰閥凡帆梵氾汎泛犯範范法琺僻劈壁擘檗璧癖"],["dca1","碧蘗闢霹便卞弁變辨辯邊別瞥鱉鼈丙倂兵屛幷昞昺柄棅炳甁病秉竝輧餠騈保堡報寶普步洑湺潽珤甫菩補褓譜輔伏僕匐卜宓復服福腹茯蔔複覆輹輻馥鰒本乶俸奉封峯峰捧棒烽熢琫縫蓬蜂逢鋒鳳不付俯傅剖副否咐埠夫婦"],["dda1","孚孵富府復扶敷斧浮溥父符簿缶腐腑膚艀芙莩訃負賦賻赴趺部釜阜附駙鳧北分吩噴墳奔奮忿憤扮昐汾焚盆粉糞紛芬賁雰不佛弗彿拂崩朋棚硼繃鵬丕備匕匪卑妃婢庇悲憊扉批斐枇榧比毖毗毘沸泌琵痺砒碑秕秘粃緋翡肥"],["dea1","脾臂菲蜚裨誹譬費鄙非飛鼻嚬嬪彬斌檳殯浜濱瀕牝玭貧賓頻憑氷聘騁乍事些仕伺似使俟僿史司唆嗣四士奢娑寫寺射巳師徙思捨斜斯柶査梭死沙泗渣瀉獅砂社祀祠私篩紗絲肆舍莎蓑蛇裟詐詞謝賜赦辭邪飼駟麝削數朔索"],["dfa1","傘刪山散汕珊産疝算蒜酸霰乷撒殺煞薩三參杉森渗芟蔘衫揷澁鈒颯上傷像償商喪嘗孀尙峠常床庠廂想桑橡湘爽牀狀相祥箱翔裳觴詳象賞霜塞璽賽嗇塞穡索色牲生甥省笙墅壻嶼序庶徐恕抒捿敍暑曙書栖棲犀瑞筮絮緖署"],["e0a1","胥舒薯西誓逝鋤黍鼠夕奭席惜昔晳析汐淅潟石碩蓆釋錫仙僊先善嬋宣扇敾旋渲煽琁瑄璇璿癬禪線繕羨腺膳船蘚蟬詵跣選銑鐥饍鮮卨屑楔泄洩渫舌薛褻設說雪齧剡暹殲纖蟾贍閃陝攝涉燮葉城姓宬性惺成星晟猩珹盛省筬"],["e1a1","聖聲腥誠醒世勢歲洗稅笹細說貰召嘯塑宵小少巢所掃搔昭梳沼消溯瀟炤燒甦疏疎瘙笑篠簫素紹蔬蕭蘇訴逍遡邵銷韶騷俗屬束涑粟續謖贖速孫巽損蓀遜飡率宋悚松淞訟誦送頌刷殺灑碎鎖衰釗修受嗽囚垂壽嫂守岫峀帥愁"],["e2a1","戍手授搜收數樹殊水洙漱燧狩獸琇璲瘦睡秀穗竪粹綏綬繡羞脩茱蒐蓚藪袖誰讐輸遂邃酬銖銹隋隧隨雖需須首髓鬚叔塾夙孰宿淑潚熟琡璹肅菽巡徇循恂旬栒楯橓殉洵淳珣盾瞬筍純脣舜荀蓴蕣詢諄醇錞順馴戌術述鉥崇崧"],["e3a1","嵩瑟膝蝨濕拾習褶襲丞乘僧勝升承昇繩蠅陞侍匙嘶始媤尸屎屍市弑恃施是時枾柴猜矢示翅蒔蓍視試詩諡豕豺埴寔式息拭植殖湜熄篒蝕識軾食飾伸侁信呻娠宸愼新晨燼申神紳腎臣莘薪藎蜃訊身辛辰迅失室實悉審尋心沁"],["e4a1","沈深瀋甚芯諶什十拾雙氏亞俄兒啞娥峨我牙芽莪蛾衙訝阿雅餓鴉鵝堊岳嶽幄惡愕握樂渥鄂鍔顎鰐齷安岸按晏案眼雁鞍顔鮟斡謁軋閼唵岩巖庵暗癌菴闇壓押狎鴨仰央怏昻殃秧鴦厓哀埃崖愛曖涯碍艾隘靄厄扼掖液縊腋額"],["e5a1","櫻罌鶯鸚也倻冶夜惹揶椰爺耶若野弱掠略約若葯蒻藥躍亮佯兩凉壤孃恙揚攘敭暘梁楊樣洋瀁煬痒瘍禳穰糧羊良襄諒讓釀陽量養圄御於漁瘀禦語馭魚齬億憶抑檍臆偃堰彦焉言諺孼蘖俺儼嚴奄掩淹嶪業円予余勵呂女如廬"],["e6a1","旅歟汝濾璵礖礪與艅茹輿轝閭餘驪麗黎亦力域役易曆歷疫繹譯轢逆驛嚥堧姸娟宴年延憐戀捐挻撚椽沇沿涎涓淵演漣烟然煙煉燃燕璉硏硯秊筵緣練縯聯衍軟輦蓮連鉛鍊鳶列劣咽悅涅烈熱裂說閱厭廉念捻染殮炎焰琰艶苒"],["e7a1","簾閻髥鹽曄獵燁葉令囹塋寧嶺嶸影怜映暎楹榮永泳渶潁濚瀛瀯煐營獰玲瑛瑩瓔盈穎纓羚聆英詠迎鈴鍈零霙靈領乂倪例刈叡曳汭濊猊睿穢芮藝蘂禮裔詣譽豫醴銳隸霓預五伍俉傲午吾吳嗚塢墺奧娛寤悟惡懊敖旿晤梧汚澳"],["e8a1","烏熬獒筽蜈誤鰲鼇屋沃獄玉鈺溫瑥瘟穩縕蘊兀壅擁瓮甕癰翁邕雍饔渦瓦窩窪臥蛙蝸訛婉完宛梡椀浣玩琓琬碗緩翫脘腕莞豌阮頑曰往旺枉汪王倭娃歪矮外嵬巍猥畏了僚僥凹堯夭妖姚寥寮尿嶢拗搖撓擾料曜樂橈燎燿瑤療"],["e9a1","窈窯繇繞耀腰蓼蟯要謠遙遼邀饒慾欲浴縟褥辱俑傭冗勇埇墉容庸慂榕涌湧溶熔瑢用甬聳茸蓉踊鎔鏞龍于佑偶優又友右宇寓尤愚憂旴牛玗瑀盂祐禑禹紆羽芋藕虞迂遇郵釪隅雨雩勖彧旭昱栯煜稶郁頊云暈橒殞澐熉耘芸蕓"],["eaa1","運隕雲韻蔚鬱亐熊雄元原員圓園垣媛嫄寃怨愿援沅洹湲源爰猿瑗苑袁轅遠阮院願鴛月越鉞位偉僞危圍委威尉慰暐渭爲瑋緯胃萎葦蔿蝟衛褘謂違韋魏乳侑儒兪劉唯喩孺宥幼幽庾悠惟愈愉揄攸有杻柔柚柳楡楢油洧流游溜"],["eba1","濡猶猷琉瑜由留癒硫紐維臾萸裕誘諛諭踰蹂遊逾遺酉釉鍮類六堉戮毓肉育陸倫允奫尹崙淪潤玧胤贇輪鈗閏律慄栗率聿戎瀜絨融隆垠恩慇殷誾銀隱乙吟淫蔭陰音飮揖泣邑凝應膺鷹依倚儀宜意懿擬椅毅疑矣義艤薏蟻衣誼"],["eca1","議醫二以伊利吏夷姨履已弛彛怡易李梨泥爾珥理異痍痢移罹而耳肄苡荑裏裡貽貳邇里離飴餌匿溺瀷益翊翌翼謚人仁刃印吝咽因姻寅引忍湮燐璘絪茵藺蚓認隣靭靷鱗麟一佚佾壹日溢逸鎰馹任壬妊姙恁林淋稔臨荏賃入卄"],["eda1","立笠粒仍剩孕芿仔刺咨姉姿子字孜恣慈滋炙煮玆瓷疵磁紫者自茨蔗藉諮資雌作勺嚼斫昨灼炸爵綽芍酌雀鵲孱棧殘潺盞岑暫潛箴簪蠶雜丈仗匠場墻壯奬將帳庄張掌暲杖樟檣欌漿牆狀獐璋章粧腸臟臧莊葬蔣薔藏裝贓醬長"],["eea1","障再哉在宰才材栽梓渽滓災縡裁財載齋齎爭箏諍錚佇低儲咀姐底抵杵楮樗沮渚狙猪疽箸紵苧菹著藷詛貯躇這邸雎齟勣吊嫡寂摘敵滴狄炙的積笛籍績翟荻謫賊赤跡蹟迪迹適鏑佃佺傳全典前剪塡塼奠專展廛悛戰栓殿氈澱"],["efa1","煎琠田甸畑癲筌箋箭篆纏詮輾轉鈿銓錢鐫電顚顫餞切截折浙癤竊節絶占岾店漸点粘霑鮎點接摺蝶丁井亭停偵呈姃定幀庭廷征情挺政整旌晶晸柾楨檉正汀淀淨渟湞瀞炡玎珽町睛碇禎程穽精綎艇訂諪貞鄭酊釘鉦鋌錠霆靖"],["f0a1","靜頂鼎制劑啼堤帝弟悌提梯濟祭第臍薺製諸蹄醍除際霽題齊俎兆凋助嘲弔彫措操早晁曺曹朝條棗槽漕潮照燥爪璪眺祖祚租稠窕粗糟組繰肇藻蚤詔調趙躁造遭釣阻雕鳥族簇足鏃存尊卒拙猝倧宗從悰慫棕淙琮種終綜縱腫"],["f1a1","踪踵鍾鐘佐坐左座挫罪主住侏做姝胄呪周嗾奏宙州廚晝朱柱株注洲湊澍炷珠疇籌紂紬綢舟蛛註誅走躊輳週酎酒鑄駐竹粥俊儁准埈寯峻晙樽浚準濬焌畯竣蠢逡遵雋駿茁中仲衆重卽櫛楫汁葺增憎曾拯烝甑症繒蒸證贈之只"],["f2a1","咫地址志持指摯支旨智枝枳止池沚漬知砥祉祗紙肢脂至芝芷蜘誌識贄趾遲直稙稷織職唇嗔塵振搢晉晋桭榛殄津溱珍瑨璡畛疹盡眞瞋秦縉縝臻蔯袗診賑軫辰進鎭陣陳震侄叱姪嫉帙桎瓆疾秩窒膣蛭質跌迭斟朕什執潗緝輯"],["f3a1","鏶集徵懲澄且侘借叉嗟嵯差次此磋箚茶蹉車遮捉搾着窄錯鑿齪撰澯燦璨瓚竄簒纂粲纘讚贊鑽餐饌刹察擦札紮僭參塹慘慙懺斬站讒讖倉倡創唱娼廠彰愴敞昌昶暢槍滄漲猖瘡窓脹艙菖蒼債埰寀寨彩採砦綵菜蔡采釵冊柵策"],["f4a1","責凄妻悽處倜刺剔尺慽戚拓擲斥滌瘠脊蹠陟隻仟千喘天川擅泉淺玔穿舛薦賤踐遷釧闡阡韆凸哲喆徹撤澈綴輟轍鐵僉尖沾添甛瞻簽籤詹諂堞妾帖捷牒疊睫諜貼輒廳晴淸聽菁請靑鯖切剃替涕滯締諦逮遞體初剿哨憔抄招梢"],["f5a1","椒楚樵炒焦硝礁礎秒稍肖艸苕草蕉貂超酢醋醮促囑燭矗蜀觸寸忖村邨叢塚寵悤憁摠總聰蔥銃撮催崔最墜抽推椎楸樞湫皺秋芻萩諏趨追鄒酋醜錐錘鎚雛騶鰍丑畜祝竺筑築縮蓄蹙蹴軸逐春椿瑃出朮黜充忠沖蟲衝衷悴膵萃"],["f6a1","贅取吹嘴娶就炊翠聚脆臭趣醉驟鷲側仄厠惻測層侈値嗤峙幟恥梔治淄熾痔痴癡稚穉緇緻置致蚩輜雉馳齒則勅飭親七柒漆侵寢枕沈浸琛砧針鍼蟄秤稱快他咤唾墮妥惰打拖朶楕舵陀馱駝倬卓啄坼度托拓擢晫柝濁濯琢琸託"],["f7a1","鐸呑嘆坦彈憚歎灘炭綻誕奪脫探眈耽貪塔搭榻宕帑湯糖蕩兌台太怠態殆汰泰笞胎苔跆邰颱宅擇澤撑攄兎吐土討慟桶洞痛筒統通堆槌腿褪退頹偸套妬投透鬪慝特闖坡婆巴把播擺杷波派爬琶破罷芭跛頗判坂板版瓣販辦鈑"],["f8a1","阪八叭捌佩唄悖敗沛浿牌狽稗覇貝彭澎烹膨愎便偏扁片篇編翩遍鞭騙貶坪平枰萍評吠嬖幣廢弊斃肺蔽閉陛佈包匍匏咆哺圃布怖抛抱捕暴泡浦疱砲胞脯苞葡蒲袍褒逋鋪飽鮑幅暴曝瀑爆輻俵剽彪慓杓標漂瓢票表豹飇飄驃"],["f9a1","品稟楓諷豊風馮彼披疲皮被避陂匹弼必泌珌畢疋筆苾馝乏逼下何厦夏廈昰河瑕荷蝦賀遐霞鰕壑學虐謔鶴寒恨悍旱汗漢澣瀚罕翰閑閒限韓割轄函含咸啣喊檻涵緘艦銜陷鹹合哈盒蛤閤闔陜亢伉姮嫦巷恒抗杭桁沆港缸肛航"],["faa1","行降項亥偕咳垓奚孩害懈楷海瀣蟹解該諧邂駭骸劾核倖幸杏荇行享向嚮珦鄕響餉饗香噓墟虛許憲櫶獻軒歇險驗奕爀赫革俔峴弦懸晛泫炫玄玹現眩睍絃絢縣舷衒見賢鉉顯孑穴血頁嫌俠協夾峽挾浹狹脅脇莢鋏頰亨兄刑型"],["fba1","形泂滎瀅灐炯熒珩瑩荊螢衡逈邢鎣馨兮彗惠慧暳蕙蹊醯鞋乎互呼壕壺好岵弧戶扈昊晧毫浩淏湖滸澔濠濩灝狐琥瑚瓠皓祜糊縞胡芦葫蒿虎號蝴護豪鎬頀顥惑或酷婚昏混渾琿魂忽惚笏哄弘汞泓洪烘紅虹訌鴻化和嬅樺火畵"],["fca1","禍禾花華話譁貨靴廓擴攫確碻穫丸喚奐宦幻患換歡晥桓渙煥環紈還驩鰥活滑猾豁闊凰幌徨恍惶愰慌晃晄榥況湟滉潢煌璜皇篁簧荒蝗遑隍黃匯回廻徊恢悔懷晦會檜淮澮灰獪繪膾茴蛔誨賄劃獲宖橫鐄哮嚆孝效斅曉梟涍淆"],["fda1","爻肴酵驍侯候厚后吼喉嗅帿後朽煦珝逅勛勳塤壎焄熏燻薰訓暈薨喧暄煊萱卉喙毁彙徽揮暉煇諱輝麾休携烋畦虧恤譎鷸兇凶匈洶胸黑昕欣炘痕吃屹紇訖欠欽歆吸恰洽翕興僖凞喜噫囍姬嬉希憙憘戱晞曦熙熹熺犧禧稀羲詰"]]')},29560:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ReadBuffer=void 0,t.deserializeMessage=deserializeMessage,t.serializeMessage=function serializeMessage(e){return JSON.stringify(e)+"\n"};const o=a(1294);function deserializeMessage(e){return o.JSONRPCMessageSchema.parse(JSON.parse(e))}t.ReadBuffer=class ReadBuffer{append(e){this._buffer=this._buffer?Buffer.concat([this._buffer,e]):e}readMessage(){if(!this._buffer)return null;const e=this._buffer.indexOf("\n");if(-1===e)return null;const t=this._buffer.toString("utf8",0,e).replace(/\r$/,"");return this._buffer=this._buffer.subarray(e+1),deserializeMessage(t)}clear(){this._buffer=void 0}}},29582:(e,t,a)=>{"use strict";(t=e.exports=a(50888)).json=a(56458),t.form=a(66354),t.text=a(25507)},29606:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseDefaultDef=void 0;const o=a(73524);t.parseDefaultDef=function parseDefaultDef(e,t){return{...(0,o.parseDef)(e.innerType._def,t),default:e.defaultValue()}}},30144:(e,t,a)=>{"use strict";const o=a(53908);e.exports=(e,t,a=!1)=>{if(e instanceof o)return e;try{return new o(e,t)}catch(e){if(!a)return null;throw e}}},30655:e=>{"use strict";var t=Object.defineProperty||!1;if(t)try{t({},"a",{value:1})}catch(e){t=!1}e.exports=t},30677:e=>{"use strict";e.exports=function vary(e,t){if(!e||!e.getHeader||!e.setHeader)throw new TypeError("res argument is required");var a=e.getHeader("Vary")||"",o=Array.isArray(a)?a.join(", "):String(a);(a=append(o,t))&&e.setHeader("Vary",a)},e.exports.append=append;var t=/^[!#$%&'*+\-.^_`|~0-9A-Za-z]+$/;function append(e,a){if("string"!=typeof e)throw new TypeError("header argument is required");if(!a)throw new TypeError("field argument is required");for(var o=Array.isArray(a)?a:parse(String(a)),r=0;r<o.length;r++)if(!t.test(o[r]))throw new TypeError("field argument contains an invalid header name");if("*"===e)return e;var i=e,n=parse(e.toLowerCase());if(-1!==o.indexOf("*")||-1!==n.indexOf("*"))return"*";for(var s=0;s<o.length;s++){var c=o[s].toLowerCase();-1===n.indexOf(c)&&(n.push(c),i=i?i+", "+o[s]:o[s])}return i}function parse(e){for(var t=0,a=[],o=0,r=0,i=e.length;r<i;r++)switch(e.charCodeAt(r)){case 32:o===t&&(o=t=r+1);break;case 44:a.push(e.substring(o,t)),o=t=r+1;break;default:t=r+1}return a.push(e.substring(o,t)),a}},30737:(e,t,a)=>{var o=a(80801),r=a(39023),i=a(16928),n=a(58611),s=a(65692),c=a(87016).parse,p=a(79896),u=a(86049),l=a(21873),m=a(41362);function FormData(e){if(!(this instanceof FormData))return new FormData;for(var t in this._overheadLength=0,this._valueLength=0,this._valuesToMeasure=[],o.call(this),e=e||{})this[t]=e[t]}e.exports=FormData,r.inherits(FormData,o),FormData.LINE_BREAK="\r\n",FormData.DEFAULT_CONTENT_TYPE="application/octet-stream",FormData.prototype.append=function(e,t,a){"string"==typeof(a=a||{})&&(a={filename:a});var i=o.prototype.append.bind(this);if("number"==typeof t&&(t=""+t),r.isArray(t))this._error(new Error("Arrays are not supported."));else{var n=this._multiPartHeader(e,t,a),s=this._multiPartFooter();i(n),i(t),i(s),this._trackLength(n,t,a)}},FormData.prototype._trackLength=function(e,t,a){var o=0;null!=a.knownLength?o+=+a.knownLength:Buffer.isBuffer(t)?o=t.length:"string"==typeof t&&(o=Buffer.byteLength(t)),this._valueLength+=o,this._overheadLength+=Buffer.byteLength(e)+FormData.LINE_BREAK.length,t&&(t.path||t.readable&&t.hasOwnProperty("httpVersion"))&&(a.knownLength||this._valuesToMeasure.push(t))},FormData.prototype._lengthRetriever=function(e,t){e.hasOwnProperty("fd")?null!=e.end&&e.end!=1/0&&null!=e.start?t(null,e.end+1-(e.start?e.start:0)):p.stat(e.path,function(a,o){var r;a?t(a):(r=o.size-(e.start?e.start:0),t(null,r))}):e.hasOwnProperty("httpVersion")?t(null,+e.headers["content-length"]):e.hasOwnProperty("httpModule")?(e.on("response",function(a){e.pause(),t(null,+a.headers["content-length"])}),e.resume()):t("Unknown stream")},FormData.prototype._multiPartHeader=function(e,t,a){if("string"==typeof a.header)return a.header;var o,r=this._getContentDisposition(t,a),i=this._getContentType(t,a),n="",s={"Content-Disposition":["form-data",'name="'+e+'"'].concat(r||[]),"Content-Type":[].concat(i||[])};for(var c in"object"==typeof a.header&&m(s,a.header),s)s.hasOwnProperty(c)&&null!=(o=s[c])&&(Array.isArray(o)||(o=[o]),o.length&&(n+=c+": "+o.join("; ")+FormData.LINE_BREAK));return"--"+this.getBoundary()+FormData.LINE_BREAK+n+FormData.LINE_BREAK},FormData.prototype._getContentDisposition=function(e,t){var a,o;return"string"==typeof t.filepath?a=i.normalize(t.filepath).replace(/\\/g,"/"):t.filename||e.name||e.path?a=i.basename(t.filename||e.name||e.path):e.readable&&e.hasOwnProperty("httpVersion")&&(a=i.basename(e.client._httpMessage.path)),a&&(o='filename="'+a+'"'),o},FormData.prototype._getContentType=function(e,t){var a=t.contentType;return!a&&e.name&&(a=u.lookup(e.name)),!a&&e.path&&(a=u.lookup(e.path)),!a&&e.readable&&e.hasOwnProperty("httpVersion")&&(a=e.headers["content-type"]),a||!t.filepath&&!t.filename||(a=u.lookup(t.filepath||t.filename)),a||"object"!=typeof e||(a=FormData.DEFAULT_CONTENT_TYPE),a},FormData.prototype._multiPartFooter=function(){return function(e){var t=FormData.LINE_BREAK;0===this._streams.length&&(t+=this._lastBoundary()),e(t)}.bind(this)},FormData.prototype._lastBoundary=function(){return"--"+this.getBoundary()+"--"+FormData.LINE_BREAK},FormData.prototype.getHeaders=function(e){var t,a={"content-type":"multipart/form-data; boundary="+this.getBoundary()};for(t in e)e.hasOwnProperty(t)&&(a[t.toLowerCase()]=e[t]);return a},FormData.prototype.getBoundary=function(){return this._boundary||this._generateBoundary(),this._boundary},FormData.prototype._generateBoundary=function(){for(var e="--------------------------",t=0;t<24;t++)e+=Math.floor(10*Math.random()).toString(16);this._boundary=e},FormData.prototype.getLengthSync=function(){var e=this._overheadLength+this._valueLength;return this._streams.length&&(e+=this._lastBoundary().length),this.hasKnownLength()||this._error(new Error("Cannot calculate proper length in synchronous way.")),e},FormData.prototype.hasKnownLength=function(){var e=!0;return this._valuesToMeasure.length&&(e=!1),e},FormData.prototype.getLength=function(e){var t=this._overheadLength+this._valueLength;this._streams.length&&(t+=this._lastBoundary().length),this._valuesToMeasure.length?l.parallel(this._valuesToMeasure,this._lengthRetriever,function(a,o){a?e(a):(o.forEach(function(e){t+=e}),e(null,t))}):process.nextTick(e.bind(this,null,t))},FormData.prototype.submit=function(e,t){var a,o,r={method:"post"};return"string"==typeof e?(e=c(e),o=m({port:e.port,path:e.pathname,host:e.hostname,protocol:e.protocol},r)):(o=m(e,r)).port||(o.port="https:"==o.protocol?443:80),o.headers=this.getHeaders(e.headers),a="https:"==o.protocol?s.request(o):n.request(o),this.getLength(function(e,o){e?this._error(e):(a.setHeader("Content-Length",o),this.pipe(a),t&&(a.on("error",t),a.on("response",t.bind(this,null))))}.bind(this)),a},FormData.prototype._error=function(e){this.error||(this.error=e,this.pause(),this.emit("error",e))},FormData.prototype.toString=function(){return"[object FormData]"}},31114:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseNumberDef=void 0;const o=a(98950);t.parseNumberDef=function parseNumberDef(e,t){const a={type:"number"};if(!e.checks)return a;for(const r of e.checks)switch(r.kind){case"int":a.type="integer",(0,o.addErrorMessage)(a,"type",r.message,t);break;case"min":"jsonSchema7"===t.target?r.inclusive?(0,o.setResponseValueAndErrors)(a,"minimum",r.value,r.message,t):(0,o.setResponseValueAndErrors)(a,"exclusiveMinimum",r.value,r.message,t):(r.inclusive||(a.exclusiveMinimum=!0),(0,o.setResponseValueAndErrors)(a,"minimum",r.value,r.message,t));break;case"max":"jsonSchema7"===t.target?r.inclusive?(0,o.setResponseValueAndErrors)(a,"maximum",r.value,r.message,t):(0,o.setResponseValueAndErrors)(a,"exclusiveMaximum",r.value,r.message,t):(r.inclusive||(a.exclusiveMaximum=!0),(0,o.setResponseValueAndErrors)(a,"maximum",r.value,r.message,t));break;case"multipleOf":(0,o.setResponseValueAndErrors)(a,"multipleOf",r.value,r.message,t)}return a}},31304:(e,t)=>{"use strict";function PrependBOMWrapper(e,t){this.encoder=e,this.addBOM=!0}function StripBOMWrapper(e,t){this.decoder=e,this.pass=!1,this.options=t||{}}t.PrependBOM=PrependBOMWrapper,PrependBOMWrapper.prototype.write=function(e){return this.addBOM&&(e="\ufeff"+e,this.addBOM=!1),this.encoder.write(e)},PrependBOMWrapper.prototype.end=function(){return this.encoder.end()},t.StripBOM=StripBOMWrapper,StripBOMWrapper.prototype.write=function(e){var t=this.decoder.write(e);return this.pass||!t||("\ufeff"===t[0]&&(t=t.slice(1),"function"==typeof this.options.stripBOM&&this.options.stripBOM()),this.pass=!0),t},StripBOMWrapper.prototype.end=function(){return this.decoder.end()}},31662:e=>{"use strict";e.exports=JSON.parse('{"$id":"afterRequest.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","optional":true,"required":["lastAccess","eTag","hitCount"],"properties":{"expires":{"type":"string","pattern":"^(\\\\d{4})(-)?(\\\\d\\\\d)(-)?(\\\\d\\\\d)(T)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(\\\\.\\\\d+)?(Z|([+-])(\\\\d\\\\d)(:)?(\\\\d\\\\d))?"},"lastAccess":{"type":"string","pattern":"^(\\\\d{4})(-)?(\\\\d\\\\d)(-)?(\\\\d\\\\d)(T)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(\\\\.\\\\d+)?(Z|([+-])(\\\\d\\\\d)(:)?(\\\\d\\\\d))?"},"eTag":{"type":"string"},"hitCount":{"type":"integer"},"comment":{"type":"string"}}}')},31729:(e,t,a)=>{"use strict";const o=a(30144);e.exports=(e,t)=>{const a=o(e,t);return a&&a.prerelease.length?a.prerelease:null}},31741:(e,t,a)=>{a(94742);var o=a(39023);function FingerprintFormatError(e,t){Error.captureStackTrace&&Error.captureStackTrace(this,FingerprintFormatError),this.name="FingerprintFormatError",this.fingerprint=e,this.format=t,this.message="Fingerprint format is not supported, or is invalid: ",void 0!==e&&(this.message+=" fingerprint = "+e),void 0!==t&&(this.message+=" format = "+t)}function InvalidAlgorithmError(e){Error.captureStackTrace&&Error.captureStackTrace(this,InvalidAlgorithmError),this.name="InvalidAlgorithmError",this.algorithm=e,this.message='Algorithm "'+e+'" is not supported'}function KeyParseError(e,t,a){Error.captureStackTrace&&Error.captureStackTrace(this,KeyParseError),this.name="KeyParseError",this.format=t,this.keyName=e,this.innerErr=a,this.message="Failed to parse "+e+" as a valid "+t+" format key: "+a.message}function SignatureParseError(e,t,a){Error.captureStackTrace&&Error.captureStackTrace(this,SignatureParseError),this.name="SignatureParseError",this.type=e,this.format=t,this.innerErr=a,this.message="Failed to parse the given data as a "+e+" signature in "+t+" format: "+a.message}function CertificateParseError(e,t,a){Error.captureStackTrace&&Error.captureStackTrace(this,CertificateParseError),this.name="CertificateParseError",this.format=t,this.certName=e,this.innerErr=a,this.message="Failed to parse "+e+" as a valid "+t+" format certificate: "+a.message}function KeyEncryptedError(e,t){Error.captureStackTrace&&Error.captureStackTrace(this,KeyEncryptedError),this.name="KeyEncryptedError",this.format=t,this.keyName=e,this.message="The "+t+" format key "+e+" is encrypted (password-protected), and no passphrase was provided in `options`"}o.inherits(FingerprintFormatError,Error),o.inherits(InvalidAlgorithmError,Error),o.inherits(KeyParseError,Error),o.inherits(SignatureParseError,Error),o.inherits(CertificateParseError,Error),o.inherits(KeyEncryptedError,Error),e.exports={FingerprintFormatError,InvalidAlgorithmError,KeyParseError,SignatureParseError,KeyEncryptedError,CertificateParseError}},32017:e=>{"use strict";e.exports=function equal(e,t){if(e===t)return!0;if(e&&t&&"object"==typeof e&&"object"==typeof t){if(e.constructor!==t.constructor)return!1;var a,o,r;if(Array.isArray(e)){if((a=e.length)!=t.length)return!1;for(o=a;0!==o--;)if(!equal(e[o],t[o]))return!1;return!0}if(e.constructor===RegExp)return e.source===t.source&&e.flags===t.flags;if(e.valueOf!==Object.prototype.valueOf)return e.valueOf()===t.valueOf();if(e.toString!==Object.prototype.toString)return e.toString()===t.toString();if((a=(r=Object.keys(e)).length)!==Object.keys(t).length)return!1;for(o=a;0!==o--;)if(!Object.prototype.hasOwnProperty.call(t,r[o]))return!1;for(o=a;0!==o--;){var i=r[o];if(!equal(e[i],t[i]))return!1}return!0}return e!=e&&t!=t}},32465:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.selectParser=void 0;const o=a(21614),r=a(62909),i=a(98598),n=a(87236),s=a(28147),c=a(46163),p=a(16260),u=a(85187),l=a(29606),m=a(68385),f=a(76750),h=a(40686),g=a(34836),y=a(39137),b=a(96773),x=a(85618),w=a(37294),k=a(41854),j=a(31114),C=a(46172),P=a(65867),O=a(79225),I=a(93858),z=a(87054),q=a(34519),$=a(73178),H=a(22793),V=a(97987),G=a(78348),W=a(95973),X=a(89729);t.selectParser=(e,t,a)=>{switch(t){case o.ZodFirstPartyTypeKind.ZodString:return(0,$.parseStringDef)(e,a);case o.ZodFirstPartyTypeKind.ZodNumber:return(0,j.parseNumberDef)(e,a);case o.ZodFirstPartyTypeKind.ZodObject:return(0,C.parseObjectDef)(e,a);case o.ZodFirstPartyTypeKind.ZodBigInt:return(0,n.parseBigintDef)(e,a);case o.ZodFirstPartyTypeKind.ZodBoolean:return(0,s.parseBooleanDef)();case o.ZodFirstPartyTypeKind.ZodDate:return(0,u.parseDateDef)(e,a);case o.ZodFirstPartyTypeKind.ZodUndefined:return(0,V.parseUndefinedDef)();case o.ZodFirstPartyTypeKind.ZodNull:return(0,w.parseNullDef)(a);case o.ZodFirstPartyTypeKind.ZodArray:return(0,i.parseArrayDef)(e,a);case o.ZodFirstPartyTypeKind.ZodUnion:case o.ZodFirstPartyTypeKind.ZodDiscriminatedUnion:return(0,G.parseUnionDef)(e,a);case o.ZodFirstPartyTypeKind.ZodIntersection:return(0,h.parseIntersectionDef)(e,a);case o.ZodFirstPartyTypeKind.ZodTuple:return(0,H.parseTupleDef)(e,a);case o.ZodFirstPartyTypeKind.ZodRecord:return(0,z.parseRecordDef)(e,a);case o.ZodFirstPartyTypeKind.ZodLiteral:return(0,g.parseLiteralDef)(e,a);case o.ZodFirstPartyTypeKind.ZodEnum:return(0,f.parseEnumDef)(e);case o.ZodFirstPartyTypeKind.ZodNativeEnum:return(0,b.parseNativeEnumDef)(e);case o.ZodFirstPartyTypeKind.ZodNullable:return(0,k.parseNullableDef)(e,a);case o.ZodFirstPartyTypeKind.ZodOptional:return(0,P.parseOptionalDef)(e,a);case o.ZodFirstPartyTypeKind.ZodMap:return(0,y.parseMapDef)(e,a);case o.ZodFirstPartyTypeKind.ZodSet:return(0,q.parseSetDef)(e,a);case o.ZodFirstPartyTypeKind.ZodLazy:return()=>e.getter()._def;case o.ZodFirstPartyTypeKind.ZodPromise:return(0,I.parsePromiseDef)(e,a);case o.ZodFirstPartyTypeKind.ZodNaN:case o.ZodFirstPartyTypeKind.ZodNever:return(0,x.parseNeverDef)();case o.ZodFirstPartyTypeKind.ZodEffects:return(0,m.parseEffectsDef)(e,a);case o.ZodFirstPartyTypeKind.ZodAny:return(0,r.parseAnyDef)();case o.ZodFirstPartyTypeKind.ZodUnknown:return(0,W.parseUnknownDef)();case o.ZodFirstPartyTypeKind.ZodDefault:return(0,l.parseDefaultDef)(e,a);case o.ZodFirstPartyTypeKind.ZodBranded:return(0,c.parseBrandedDef)(e,a);case o.ZodFirstPartyTypeKind.ZodReadonly:return(0,X.parseReadonlyDef)(e,a);case o.ZodFirstPartyTypeKind.ZodCatch:return(0,p.parseCatchDef)(e,a);case o.ZodFirstPartyTypeKind.ZodPipeline:return(0,O.parsePipelineDef)(e,a);case o.ZodFirstPartyTypeKind.ZodFunction:case o.ZodFirstPartyTypeKind.ZodVoid:case o.ZodFirstPartyTypeKind.ZodSymbol:default:return}}},32923:(e,t,a)=>{const{buildOptions:o}=a(50460),r=a(17680),{prettify:i}=a(75629),n=a(43918);e.exports=class XMLParser{constructor(e){this.externalEntities={},this.options=o(e)}parse(e,t){if("string"==typeof e);else{if(!e.toString)throw new Error("XML data is accepted in String or Bytes[] form.");e=e.toString()}if(t){!0===t&&(t={});const a=n.validate(e,t);if(!0!==a)throw Error(`${a.err.msg}:${a.err.line}:${a.err.col}`)}const a=new r(this.options);a.addExternalEntities(this.externalEntities);const o=a.parseXml(e);return this.options.preserveOrder||void 0===o?o:i(o,this.options)}addEntity(e,t){if(-1!==t.indexOf("&"))throw new Error("Entity value can't have '&'");if(-1!==e.indexOf("&")||-1!==e.indexOf(";"))throw new Error("An entity must be set without '&' and ';'. Eg. use '#xD' for '&#xD;'");if("&"===t)throw new Error("An entity with value '&' is not permitted");this.externalEntities[e]=t}}},32938:(e,t,a)=>{"use strict";const o=a(53908);e.exports=(e,t)=>new o(e,t).major},32949:(e,t,a)=>{"use strict";const o=a(16928),r=a(70857),i=r.homedir(),n=r.tmpdir(),{env:s}=process,envPaths=(e,t)=>{if("string"!=typeof e)throw new TypeError("Expected string, got "+typeof e);return(t=Object.assign({suffix:"nodejs"},t)).suffix&&(e+=`-${t.suffix}`),"darwin"===process.platform?(e=>{const t=o.join(i,"Library");return{data:o.join(t,"Application Support",e),config:o.join(t,"Preferences",e),cache:o.join(t,"Caches",e),log:o.join(t,"Logs",e),temp:o.join(n,e)}})(e):"win32"===process.platform?(e=>{const t=s.APPDATA||o.join(i,"AppData","Roaming"),a=s.LOCALAPPDATA||o.join(i,"AppData","Local");return{data:o.join(a,e,"Data"),config:o.join(t,e,"Config"),cache:o.join(a,e,"Cache"),log:o.join(a,e,"Log"),temp:o.join(n,e)}})(e):(e=>{const t=o.basename(i);return{data:o.join(s.XDG_DATA_HOME||o.join(i,".local","share"),e),config:o.join(s.XDG_CONFIG_HOME||o.join(i,".config"),e),cache:o.join(s.XDG_CACHE_HOME||o.join(i,".cache"),e),log:o.join(s.XDG_STATE_HOME||o.join(i,".local","state"),e),temp:o.join(n,t,e)}})(e)};e.exports=envPaths,e.exports.default=envPaths},33127:(e,t,a)=>{"use strict";var o=a(82005),r=a(34610).toHash;e.exports=function rules(){var e=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],t=["type","$comment"];return e.all=r(t),e.types=r(["number","integer","string","array","object","boolean","null"]),e.forEach(function(a){a.rules=a.rules.map(function(a){var r;if("object"==typeof a){var i=Object.keys(a)[0];r=a[i],a=i,r.forEach(function(a){t.push(a),e.all[a]=!0})}return t.push(a),e.all[a]={keyword:a,code:o[a],implements:r}}),e.all.$comment={keyword:"$comment",code:o.$comment},a.type&&(e.types[a.type]=a)}),e.keywords=r(t.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),e.custom={},e}},33276:e=>{"use strict";e.exports=function generate_enum(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="valid"+r,m=e.opts.$data&&n&&n.$data;m&&(o+=" var schema"+r+" = "+e.util.getData(n.$data,i,e.dataPathArr)+"; ");var f="i"+r,h="schema"+r;m||(o+=" var "+h+" = validate.schema"+s+";"),o+="var "+l+";",m&&(o+=" if (schema"+r+" === undefined) "+l+" = true; else if (!Array.isArray(schema"+r+")) "+l+" = false; else {"),o+=l+" = false;for (var "+f+"=0; "+f+"<"+h+".length; "+f+"++) if (equal("+u+", "+h+"["+f+"])) { "+l+" = true; break; }",m&&(o+="  }  "),o+=" if (!"+l+") {   ";var g=g||[];g.push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { allowedValues: schema"+r+" } ",!1!==e.opts.messages&&(o+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var y=o;return o=g.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+y+"]); ":o+=" validate.errors = ["+y+"]; return false; ":o+=" var err = "+y+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" }",p&&(o+=" else { "),o}},33645:(e,t,a)=>{e.exports={read:function read(e,t){var a,n,l=e.toString("ascii").split(/[\r\n]+/),m=!1,f=0;for(;f<l.length;)if((a=splitHeader(l[f++]))&&(n={"putty-user-key-file-2":2,"putty-user-key-file-3":3}[a[0].toLowerCase()])){m=!0;break}if(!m)throw new Error("No PuTTY format first line found");var h=a[1];a=splitHeader(l[f++]),o.equal(a[0].toLowerCase(),"encryption");var g=a[1];a=splitHeader(l[f++]),o.equal(a[0].toLowerCase(),"comment");var y=a[1];a=splitHeader(l[f++]),o.equal(a[0].toLowerCase(),"public-lines");var b=parseInt(a[1],10);if(!isFinite(b)||b<0||b>l.length)throw new Error("Invalid public-lines count");var x=r.from(l.slice(f,f+b).join(""),"base64"),w=i.algToKeyType(h),k=i.read(x);if(k.type!==w)throw new Error("Outer key algorithm mismatch");if(l[f+=b]){a=splitHeader(l[f++]),o.equal(a[0].toLowerCase(),"private-lines");var j=parseInt(a[1],10);if(!isFinite(j)||j<0||j>l.length)throw new Error("Invalid private-lines count");var C=r.from(l.slice(f,f+j).join(""),"base64");if("none"!==g&&3===n)throw new Error("Encrypted keys arenot supported for PuTTY format version 3");if("aes256-cbc"===g){if(!t.passphrase)throw new u.KeyEncryptedError(t.filename,"PEM");var P=r.alloc(16,0),O=c.createDecipheriv("aes-256-cbc",function derivePPK2EncryptionKey(e){var t=c.createHash("sha1").update(r.concat([r.from([0,0,0,0]),r.from(e)])).digest(),a=c.createHash("sha1").update(r.concat([r.from([0,0,0,1]),r.from(e)])).digest();return r.concat([t,a]).slice(0,32)}(t.passphrase),P);O.setAutoPadding(!1),C=r.concat([O.update(C),O.final()])}if((k=new p(k)).type!==w)throw new Error("Outer key algorithm mismatch");var I,z=new s({buffer:C});if("ssh-dss"===h)I=[{name:"x",data:z.readBuffer()}];else if("ssh-rsa"===h)I=[{name:"d",data:z.readBuffer()},{name:"p",data:z.readBuffer()},{name:"q",data:z.readBuffer()},{name:"iqmp",data:z.readBuffer()}];else if(h.match(/^ecdsa-sha2-nistp/))I=[{name:"d",data:z.readBuffer()}];else{if("ssh-ed25519"!==h)throw new Error("Unsupported PPK key type: "+h);I=[{name:"k",data:z.readBuffer()}]}k=new p({type:k.type,parts:k.parts.concat(I)})}return k.comment=y,k},write:function write(e,t){if(o.object(e),!n.isKey(e))throw new Error("Must be a public key");var a=i.keyTypeToAlg(e),s=i.write(e),c=e.comment||"",p=function wrap(e,t){var a=[],o=0;for(;o<e.length;)a.push(e.slice(o,o+64)),o+=64;return a}(s.toString("base64"));return p.unshift("Public-Lines: "+p.length),p.unshift("Comment: "+c),p.unshift("Encryption: none"),p.unshift("PuTTY-User-Key-File-2: "+a),r.from(p.join("\n")+"\n")}};var o=a(94742),r=a(54774).Buffer,i=a(34348),n=a(64479),s=a(46309),c=a(76982),p=a(90009),u=a(31741);function splitHeader(e){var t=e.indexOf(":");if(-1===t)return null;var a=e.slice(0,t);for(++t;" "===e[t];)++t;return[a,e.slice(t)]}},33673:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.keywordCode=void 0;const o=a(13056),r=a(48708),i=a(15765),n=a(99029),s=a(42023);function funcKeywordCode(e,t){var a;const{gen:o,keyword:c,schema:p,parentSchema:u,$data:l,it:m}=e;!function checkAsync({schemaEnv:e},t){if(t.async&&!e.$async)throw new Error("async keyword in sync schema")}(m,t);const f=!l&&t.compile?t.compile.call(m.self,p,u,m):t.validate,h=useKeyword(o,c,f),g=o.let("valid");function assignValid(a=(t.async?n._`await `:n.nil)){const r=m.opts.passContext?s.default.this:s.default.self,c=!("compile"in t&&!l||!1===t.schema);o.assign(g,n._`${a}${i.callValidateCode(e,h,r,c)}`,t.modifying)}function reportErrs(e){var a;o.if(n.not(null!==(a=t.valid)&&void 0!==a?a:g),e)}e.block$data(g,function validateKeyword(){if(!1===t.errors)assignValid(),t.modifying&&modifyData(e),reportErrs(()=>e.error());else{const a=t.async?function validateAsync(){const e=o.let("ruleErrs",null);return o.try(()=>assignValid(n._`await `),t=>o.assign(g,!1).if(n._`${t} instanceof ${m.ValidationError}`,()=>o.assign(e,n._`${t}.errors`),()=>o.throw(t))),e}():function validateSync(){const e=n._`${h}.errors`;return o.assign(e,null),assignValid(n.nil),e}();t.modifying&&modifyData(e),reportErrs(()=>function addErrs(e,t){const{gen:a}=e;a.if(n._`Array.isArray(${t})`,()=>{a.assign(s.default.vErrors,n._`${s.default.vErrors} === null ? ${t} : ${s.default.vErrors}.concat(${t})`).assign(s.default.errors,n._`${s.default.vErrors}.length`),r.extendErrors(e)},()=>e.error())}(e,a))}}),e.ok(null!==(a=t.valid)&&void 0!==a?a:g)}function modifyData(e){const{gen:t,data:a,it:o}=e;t.if(o.parentData,()=>t.assign(a,n._`${o.parentData}[${o.parentDataProperty}]`))}function useKeyword(e,t,a){if(void 0===a)throw new Error(`keyword "${t}" failed to compile`);return e.scopeValue("keyword","function"==typeof a?{ref:a}:{ref:a,code:n.stringify(a)})}t.keywordCode=function keywordCode(e,t,a,r){const i=new o.default(e,a,t);"code"in a?a.code(i,r):i.$data&&a.validate?funcKeywordCode(i,a):"macro"in a?function macroKeywordCode(e,t){const{gen:a,keyword:o,schema:r,parentSchema:i,it:s}=e,c=t.macro.call(s.self,r,i,s),p=useKeyword(a,o,c);!1!==s.opts.validateSchema&&s.self.validateSchema(c,!0);const u=a.name("valid");e.subschema({schema:c,schemaPath:n.nil,errSchemaPath:`${s.errSchemaPath}/${o}`,topSchemaRef:p,compositeRule:!0},u),e.pass(u,()=>e.error(!0))}(i,a):(a.compile||a.validate)&&funcKeywordCode(i,a)}},34003:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(15765),r=a(99029),i=a(62586),n={keyword:"required",type:"object",schemaType:"array",$data:!0,error:{message:({params:{missingProperty:e}})=>r.str`should have required property '${e}'`,params:({params:{missingProperty:e}})=>r._`{missingProperty: ${e}}`},code(e){const{gen:t,schema:a,schemaCode:n,data:s,$data:c,it:p}=e,{opts:u}=p;if(!c&&0===a.length)return;const l=a.length>=u.loopRequired;if(p.allErrors?function allErrorsMode(){if(l||c)e.block$data(r.nil,loopAllRequired);else for(const t of a)o.checkReportMissingProp(e,t)}():function exitOnErrorMode(){const i=t.let("missing");if(l||c){const a=t.let("valid",!0);e.block$data(a,()=>function loopUntilMissing(a,i){e.setParams({missingProperty:a}),t.forOf(a,n,()=>{t.assign(i,o.propertyInData(t,s,a,u.ownProperties)),t.if(r.not(i),()=>{e.error(),t.break()})},r.nil)}(i,a)),e.ok(a)}else t.if(o.checkMissingProp(e,a,i)),o.reportMissingProp(e,i),t.else()}(),u.strictRequired){const t=e.parentSchema.properties,{definedProperties:o}=e.it;for(const e of a)if(void 0===(null==t?void 0:t[e])&&!o.has(e)){const t=`required property "${e}" is not defined at "${p.schemaEnv.baseId+p.errSchemaPath}" (strictRequired)`;i.checkStrictMode(p,t,p.opts.strictRequired)}}function loopAllRequired(){t.forOf("prop",n,a=>{e.setParams({missingProperty:a}),t.if(o.noPropertyInData(t,s,a,u.ownProperties),()=>e.error())})}}};t.default=n},34050:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.MissingRefError=t.ValidationError=void 0;const o=a(66939);class ValidationError extends Error{constructor(e){super("validation failed"),this.errors=e,this.ajv=this.validation=!0}}t.ValidationError=ValidationError;class MissingRefError extends Error{constructor(e,t,a){super(a||`can't resolve reference ${t} from id ${e}`),this.missingRef=o.resolveUrl(e,t),this.missingSchema=o.normalizeId(o.getFullPath(this.missingRef))}}t.MissingRefError=MissingRefError,e.exports={ValidationError,MissingRefError}},34184:e=>{"use strict";e.exports=JSON.parse('[["8740","䏰䰲䘃䖦䕸𧉧䵷䖳𧲱䳢𧳅㮕䜶䝄䱇䱀𤊿𣘗𧍒𦺋𧃒䱗𪍑䝏䗚䲅𧱬䴇䪤䚡𦬣爥𥩔𡩣𣸆𣽡晍囻"],["8767","綕夝𨮹㷴霴𧯯寛𡵞媤㘥𩺰嫑宷峼杮薓𩥅瑡璝㡵𡵓𣚞𦀡㻬"],["87a1","𥣞㫵竼龗𤅡𨤍𣇪𠪊𣉞䌊蒄龖鐯䤰蘓墖靊鈘秐稲晠権袝瑌篅枂稬剏遆㓦珄𥶹瓆鿇垳䤯呌䄱𣚎堘穲𧭥讏䚮𦺈䆁𥶙箮𢒼鿈𢓁𢓉𢓌鿉蔄𣖻䂴鿊䓡𪷿拁灮鿋"],["8840","㇀",4,"𠄌㇅𠃑𠃍㇆㇇𠃋𡿨㇈𠃊㇉㇊㇋㇌𠄎㇍㇎ĀÁǍÀĒÉĚÈŌÓǑÒ࿿Ê̄Ế࿿Ê̌ỀÊāáǎàɑēéěèīíǐìōóǒòūúǔùǖǘǚ"],["88a1","ǜü࿿ê̄ế࿿ê̌ềêɡ⏚⏛"],["8940","𪎩𡅅"],["8943","攊"],["8946","丽滝鵎釟"],["894c","𧜵撑会伨侨兖兴农凤务动医华发变团声处备夲头学实実岚庆总斉柾栄桥济炼电纤纬纺织经统缆缷艺苏药视设询车轧轮"],["89a1","琑糼緍楆竉刧"],["89ab","醌碸酞肼"],["89b0","贋胶𠧧"],["89b5","肟黇䳍鷉鸌䰾𩷶𧀎鸊𪄳㗁"],["89c1","溚舾甙"],["89c5","䤑马骏龙禇𨑬𡷊𠗐𢫦两亁亀亇亿仫伷㑌侽㹈倃傈㑽㒓㒥円夅凛凼刅争剹劐匧㗇厩㕑厰㕓参吣㕭㕲㚁咓咣咴咹哐哯唘唣唨㖘唿㖥㖿嗗㗅"],["8a40","𧶄唥"],["8a43","𠱂𠴕𥄫喐𢳆㧬𠍁蹆𤶸𩓥䁓𨂾睺𢰸㨴䟕𨅝𦧲𤷪擝𠵼𠾴𠳕𡃴撍蹾𠺖𠰋𠽤𢲩𨉖𤓓"],["8a64","𠵆𩩍𨃩䟴𤺧𢳂骲㩧𩗴㿭㔆𥋇𩟔𧣈𢵄鵮頕"],["8a76","䏙𦂥撴哣𢵌𢯊𡁷㧻𡁯"],["8aa1","𦛚𦜖𧦠擪𥁒𠱃蹨𢆡𨭌𠜱"],["8aac","䠋𠆩㿺塳𢶍"],["8ab2","𤗈𠓼𦂗𠽌𠶖啹䂻䎺"],["8abb","䪴𢩦𡂝膪飵𠶜捹㧾𢝵跀嚡摼㹃"],["8ac9","𪘁𠸉𢫏𢳉"],["8ace","𡃈𣧂㦒㨆𨊛㕸𥹉𢃇噒𠼱𢲲𩜠㒼氽𤸻"],["8adf","𧕴𢺋𢈈𪙛𨳍𠹺𠰴𦠜羓𡃏𢠃𢤹㗻𥇣𠺌𠾍𠺪㾓𠼰𠵇𡅏𠹌"],["8af6","𠺫𠮩𠵈𡃀𡄽㿹𢚖搲𠾭"],["8b40","𣏴𧘹𢯎𠵾𠵿𢱑𢱕㨘𠺘𡃇𠼮𪘲𦭐𨳒𨶙𨳊閪哌苄喹"],["8b55","𩻃鰦骶𧝞𢷮煀腭胬尜𦕲脴㞗卟𨂽醶𠻺𠸏𠹷𠻻㗝𤷫㘉𠳖嚯𢞵𡃉𠸐𠹸𡁸𡅈𨈇𡑕𠹹𤹐𢶤婔𡀝𡀞𡃵𡃶垜𠸑"],["8ba1","𧚔𨋍𠾵𠹻𥅾㜃𠾶𡆀𥋘𪊽𤧚𡠺𤅷𨉼墙剨㘚𥜽箲孨䠀䬬鼧䧧鰟鮍𥭴𣄽嗻㗲嚉丨夂𡯁屮靑𠂆乛亻㔾尣彑忄㣺扌攵歺氵氺灬爫丬犭𤣩罒礻糹罓𦉪㓁"],["8bde","𦍋耂肀𦘒𦥑卝衤见𧢲讠贝钅镸长门𨸏韦页风飞饣𩠐鱼鸟黄歯龜丷𠂇阝户钢"],["8c40","倻淾𩱳龦㷉袏𤅎灷峵䬠𥇍㕙𥴰愢𨨲辧釶熑朙玺𣊁𪄇㲋𡦀䬐磤琂冮𨜏䀉橣𪊺䈣蘏𠩯稪𩥇𨫪靕灍匤𢁾鏴盙𨧣龧矝亣俰傼丯众龨吴綋墒壐𡶶庒庙忂𢜒斋"],["8ca1","𣏹椙橃𣱣泿"],["8ca7","爀𤔅玌㻛𤨓嬕璹讃𥲤𥚕窓篬糃繬苸薗龩袐龪躹龫迏蕟駠鈡龬𨶹𡐿䁱䊢娚"],["8cc9","顨杫䉶圽"],["8cce","藖𤥻芿𧄍䲁𦵴嵻𦬕𦾾龭龮宖龯曧繛湗秊㶈䓃𣉖𢞖䎚䔶"],["8ce6","峕𣬚諹屸㴒𣕑嵸龲煗䕘𤃬𡸣䱷㥸㑊𠆤𦱁諌侴𠈹妿腬顖𩣺弻"],["8d40","𠮟"],["8d42","𢇁𨥭䄂䚻𩁹㼇龳𪆵䃸㟖䛷𦱆䅼𨚲𧏿䕭㣔𥒚䕡䔛䶉䱻䵶䗪㿈𤬏㙡䓞䒽䇭崾嵈嵖㷼㠏嶤嶹㠠㠸幂庽弥徃㤈㤔㤿㥍惗愽峥㦉憷憹懏㦸戬抐拥挘㧸嚱"],["8da1","㨃揢揻搇摚㩋擀崕嘡龟㪗斆㪽旿晓㫲暒㬢朖㭂枤栀㭘桊梄㭲㭱㭻椉楃牜楤榟榅㮼槖㯝橥橴橱檂㯬檙㯲檫檵櫔櫶殁毁毪汵沪㳋洂洆洦涁㳯涤涱渕渘温溆𨧀溻滢滚齿滨滩漤漴㵆𣽁澁澾㵪㵵熷岙㶊瀬㶑灐灔灯灿炉𠌥䏁㗱𠻘"],["8e40","𣻗垾𦻓焾𥟠㙎榢𨯩孴穉𥣡𩓙穥穽𥦬窻窰竂竃燑𦒍䇊竚竝竪䇯咲𥰁笋筕笩𥌎𥳾箢筯莜𥮴𦱿篐萡箒箸𥴠㶭𥱥蒒篺簆簵𥳁籄粃𤢂粦晽𤕸糉糇糦籴糳糵糎"],["8ea1","繧䔝𦹄絝𦻖璍綉綫焵綳緒𤁗𦀩緤㴓緵𡟹緥𨍭縝𦄡𦅚繮纒䌫鑬縧罀罁罇礶𦋐駡羗𦍑羣𡙡𠁨䕜𣝦䔃𨌺翺𦒉者耈耝耨耯𪂇𦳃耻耼聡𢜔䦉𦘦𣷣𦛨朥肧𨩈脇脚墰𢛶汿𦒘𤾸擧𡒊舘𡡞橓𤩥𤪕䑺舩𠬍𦩒𣵾俹𡓽蓢荢𦬊𤦧𣔰𡝳𣷸芪椛芳䇛"],["8f40","蕋苐茚𠸖𡞴㛁𣅽𣕚艻苢茘𣺋𦶣𦬅𦮗𣗎㶿茝嗬莅䔋𦶥莬菁菓㑾𦻔橗蕚㒖𦹂𢻯葘𥯤葱㷓䓤檧葊𣲵祘蒨𦮖𦹷𦹃蓞萏莑䒠蒓蓤𥲑䉀𥳀䕃蔴嫲𦺙䔧蕳䔖枿蘖"],["8fa1","𨘥𨘻藁𧂈蘂𡖂𧃍䕫䕪蘨㙈𡢢号𧎚虾蝱𪃸蟮𢰧螱蟚蠏噡虬桖䘏衅衆𧗠𣶹𧗤衞袜䙛袴袵揁装睷𧜏覇覊覦覩覧覼𨨥觧𧤤𧪽誜瞓釾誐𧩙竩𧬺𣾏䜓𧬸煼謌謟𥐰𥕥謿譌譍誩𤩺讐讛誯𡛟䘕衏貛𧵔𧶏貫㜥𧵓賖𧶘𧶽贒贃𡤐賛灜贑𤳉㻐起"],["9040","趩𨀂𡀔𤦊㭼𨆼𧄌竧躭躶軃鋔輙輭𨍥𨐒辥錃𪊟𠩐辳䤪𨧞𨔽𣶻廸𣉢迹𪀔𨚼𨔁𢌥㦀𦻗逷𨔼𧪾遡𨕬𨘋邨𨜓郄𨛦邮都酧㫰醩釄粬𨤳𡺉鈎沟鉁鉢𥖹銹𨫆𣲛𨬌𥗛"],["90a1","𠴱錬鍫𨫡𨯫炏嫃𨫢𨫥䥥鉄𨯬𨰹𨯿鍳鑛躼閅閦鐦閠濶䊹𢙺𨛘𡉼𣸮䧟氜陻隖䅬隣𦻕懚隶磵𨫠隽双䦡𦲸𠉴𦐐𩂯𩃥𤫑𡤕𣌊霱虂霶䨏䔽䖅𤫩灵孁霛靜𩇕靗孊𩇫靟鐥僐𣂷𣂼鞉鞟鞱鞾韀韒韠𥑬韮琜𩐳響韵𩐝𧥺䫑頴頳顋顦㬎𧅵㵑𠘰𤅜"],["9140","𥜆飊颷飈飇䫿𦴧𡛓喰飡飦飬鍸餹𤨩䭲𩡗𩤅駵騌騻騐驘𥜥㛄𩂱𩯕髠髢𩬅髴䰎鬔鬭𨘀倴鬴𦦨㣃𣁽魐魀𩴾婅𡡣鮎𤉋鰂鯿鰌𩹨鷔𩾷𪆒𪆫𪃡𪄣𪇟鵾鶃𪄴鸎梈"],["91a1","鷄𢅛𪆓𪈠𡤻𪈳鴹𪂹𪊴麐麕麞麢䴴麪麯𤍤黁㭠㧥㴝伲㞾𨰫鼂鼈䮖鐤𦶢鼗鼖鼹嚟嚊齅馸𩂋韲葿齢齩竜龎爖䮾𤥵𤦻煷𤧸𤍈𤩑玞𨯚𡣺禟𨥾𨸶鍩鏳𨩄鋬鎁鏋𨥬𤒹爗㻫睲穃烐𤑳𤏸煾𡟯炣𡢾𣖙㻇𡢅𥐯𡟸㜢𡛻𡠹㛡𡝴𡣑𥽋㜣𡛀坛𤨥𡏾𡊨"],["9240","𡏆𡒶蔃𣚦蔃葕𤦔𧅥𣸱𥕜𣻻𧁒䓴𣛮𩦝𦼦柹㜳㰕㷧塬𡤢栐䁗𣜿𤃡𤂋𤄏𦰡哋嚞𦚱嚒𠿟𠮨𠸍鏆𨬓鎜仸儫㠙𤐶亼𠑥𠍿佋侊𥙑婨𠆫𠏋㦙𠌊𠐔㐵伩𠋀𨺳𠉵諚𠈌亘"],["92a1","働儍侢伃𤨎𣺊佂倮偬傁俌俥偘僼兙兛兝兞湶𣖕𣸹𣺿浲𡢄𣺉冨凃𠗠䓝𠒣𠒒𠒑赺𨪜𠜎剙劤𠡳勡鍮䙺熌𤎌𠰠𤦬𡃤槑𠸝瑹㻞璙琔瑖玘䮎𤪼𤂍叐㖄爏𤃉喴𠍅响𠯆圝鉝雴鍦埝垍坿㘾壋媙𨩆𡛺𡝯𡜐娬妸銏婾嫏娒𥥆𡧳𡡡𤊕㛵洅瑃娡𥺃"],["9340","媁𨯗𠐓鏠璌𡌃焅䥲鐈𨧻鎽㞠尞岞幞幈𡦖𡥼𣫮廍孏𡤃𡤄㜁𡢠㛝𡛾㛓脪𨩇𡶺𣑲𨦨弌弎𡤧𡞫婫𡜻孄蘔𧗽衠恾𢡠𢘫忛㺸𢖯𢖾𩂈𦽳懀𠀾𠁆𢘛憙憘恵𢲛𢴇𤛔𩅍"],["93a1","摱𤙥𢭪㨩𢬢𣑐𩣪𢹸挷𪑛撶挱揑𤧣𢵧护𢲡搻敫楲㯴𣂎𣊭𤦉𣊫唍𣋠𡣙𩐿曎𣊉𣆳㫠䆐𥖄𨬢𥖏𡛼𥕛𥐥磮𣄃𡠪𣈴㑤𣈏𣆂𤋉暎𦴤晫䮓昰𧡰𡷫晣𣋒𣋡昞𥡲㣑𣠺𣞼㮙𣞢𣏾瓐㮖枏𤘪梶栞㯄檾㡣𣟕𤒇樳橒櫉欅𡤒攑梘橌㯗橺歗𣿀𣲚鎠鋲𨯪𨫋"],["9440","銉𨀞𨧜鑧涥漋𤧬浧𣽿㶏渄𤀼娽渊塇洤硂焻𤌚𤉶烱牐犇犔𤞏𤜥兹𤪤𠗫瑺𣻸𣙟𤩊𤤗𥿡㼆㺱𤫟𨰣𣼵悧㻳瓌琼鎇琷䒟𦷪䕑疃㽣𤳙𤴆㽘畕癳𪗆㬙瑨𨫌𤦫𤦎㫻"],["94a1","㷍𤩎㻿𤧅𤣳釺圲鍂𨫣𡡤僟𥈡𥇧睸𣈲眎眏睻𤚗𣞁㩞𤣰琸璛㺿𤪺𤫇䃈𤪖𦆮錇𥖁砞碍碈磒珐祙𧝁𥛣䄎禛蒖禥樭𣻺稺秴䅮𡛦䄲鈵秱𠵌𤦌𠊙𣶺𡝮㖗啫㕰㚪𠇔𠰍竢婙𢛵𥪯𥪜娍𠉛磰娪𥯆竾䇹籝籭䈑𥮳𥺼𥺦糍𤧹𡞰粎籼粮檲緜縇緓罎𦉡"],["9540","𦅜𧭈綗𥺂䉪𦭵𠤖柖𠁎𣗏埄𦐒𦏸𤥢翝笧𠠬𥫩𥵃笌𥸎駦虅驣樜𣐿㧢𤧷𦖭騟𦖠蒀𧄧𦳑䓪脷䐂胆脉腂𦞴飃𦩂艢艥𦩑葓𦶧蘐𧈛媆䅿𡡀嬫𡢡嫤𡣘蚠蜨𣶏蠭𧐢娂"],["95a1","衮佅袇袿裦襥襍𥚃襔𧞅𧞄𨯵𨯙𨮜𨧹㺭蒣䛵䛏㟲訽訜𩑈彍鈫𤊄旔焩烄𡡅鵭貟賩𧷜妚矃姰䍮㛔踪躧𤰉輰轊䋴汘澻𢌡䢛潹溋𡟚鯩㚵𤤯邻邗啱䤆醻鐄𨩋䁢𨫼鐧𨰝𨰻蓥訫閙閧閗閖𨴴瑅㻂𤣿𤩂𤏪㻧𣈥随𨻧𨹦𨹥㻌𤧭𤩸𣿮琒瑫㻼靁𩂰"],["9640","桇䨝𩂓𥟟靝鍨𨦉𨰦𨬯𦎾銺嬑譩䤼珹𤈛鞛靱餸𠼦巁𨯅𤪲頟𩓚鋶𩗗釥䓀𨭐𤩧𨭤飜𨩅㼀鈪䤥萔餻饍𧬆㷽馛䭯馪驜𨭥𥣈檏騡嫾騯𩣱䮐𩥈馼䮽䮗鍽塲𡌂堢𤦸"],["96a1","𡓨硄𢜟𣶸棅㵽鑘㤧慐𢞁𢥫愇鱏鱓鱻鰵鰐魿鯏𩸭鮟𪇵𪃾鴡䲮𤄄鸘䲰鴌𪆴𪃭𪃳𩤯鶥蒽𦸒𦿟𦮂藼䔳𦶤𦺄𦷰萠藮𦸀𣟗𦁤秢𣖜𣙀䤭𤧞㵢鏛銾鍈𠊿碹鉷鑍俤㑀遤𥕝砽硔碶硋𡝗𣇉𤥁㚚佲濚濙瀞瀞吔𤆵垻壳垊鴖埗焴㒯𤆬燫𦱀𤾗嬨𡞵𨩉"],["9740","愌嫎娋䊼𤒈㜬䭻𨧼鎻鎸𡣖𠼝葲𦳀𡐓𤋺𢰦𤏁妔𣶷𦝁綨𦅛𦂤𤦹𤦋𨧺鋥珢㻩璴𨭣𡢟㻡𤪳櫘珳珻㻖𤨾𤪔𡟙𤩦𠎧𡐤𤧥瑈𤤖炥𤥶銄珦鍟𠓾錱𨫎𨨖鎆𨯧𥗕䤵𨪂煫"],["97a1","𤥃𠳿嚤𠘚𠯫𠲸唂秄𡟺緾𡛂𤩐𡡒䔮鐁㜊𨫀𤦭妰𡢿𡢃𧒄媡㛢𣵛㚰鉟婹𨪁𡡢鍴㳍𠪴䪖㦊僴㵩㵌𡎜煵䋻𨈘渏𩃤䓫浗𧹏灧沯㳖𣿭𣸭渂漌㵯𠏵畑㚼㓈䚀㻚䡱姄鉮䤾轁𨰜𦯀堒埈㛖𡑒烾𤍢𤩱𢿣𡊰𢎽梹楧𡎘𣓥𧯴𣛟𨪃𣟖𣏺𤲟樚𣚭𦲷萾䓟䓎"],["9840","𦴦𦵑𦲂𦿞漗𧄉茽𡜺菭𦲀𧁓𡟛妉媂𡞳婡婱𡤅𤇼㜭姯𡜼㛇熎鎐暚𤊥婮娫𤊓樫𣻹𧜶𤑛𤋊焝𤉙𨧡侰𦴨峂𤓎𧹍𤎽樌𤉖𡌄炦焳𤏩㶥泟勇𤩏繥姫崯㷳彜𤩝𡟟綤萦"],["98a1","咅𣫺𣌀𠈔坾𠣕𠘙㿥𡾞𪊶瀃𩅛嵰玏糓𨩙𩐠俈翧狍猐𧫴猸猹𥛶獁獈㺩𧬘遬燵𤣲珡臶㻊県㻑沢国琙琞琟㻢㻰㻴㻺瓓㼎㽓畂畭畲疍㽼痈痜㿀癍㿗癴㿜発𤽜熈嘣覀塩䀝睃䀹条䁅㗛瞘䁪䁯属瞾矋売砘点砜䂨砹硇硑硦葈𥔵礳栃礲䄃"],["9940","䄉禑禙辻稆込䅧窑䆲窼艹䇄竏竛䇏両筢筬筻簒簛䉠䉺类粜䊌粸䊔糭输烀𠳏総緔緐緽羮羴犟䎗耠耥笹耮耱联㷌垴炠肷胩䏭脌猪脎脒畠脔䐁㬹腖腙腚"],["99a1","䐓堺腼膄䐥膓䐭膥埯臁臤艔䒏芦艶苊苘苿䒰荗险榊萅烵葤惣蒈䔄蒾蓡蓸蔐蔸蕒䔻蕯蕰藠䕷虲蚒蚲蛯际螋䘆䘗袮裿褤襇覑𧥧訩訸誔誴豑賔賲贜䞘塟跃䟭仮踺嗘坔蹱嗵躰䠷軎転軤軭軲辷迁迊迌逳駄䢭飠鈓䤞鈨鉘鉫銱銮銿"],["9a40","鋣鋫鋳鋴鋽鍃鎄鎭䥅䥑麿鐗匁鐝鐭鐾䥪鑔鑹锭関䦧间阳䧥枠䨤靀䨵鞲韂噔䫤惨颹䬙飱塄餎餙冴餜餷饂饝饢䭰駅䮝騼鬏窃魩鮁鯝鯱鯴䱭鰠㝯𡯂鵉鰺"],["9aa1","黾噐鶓鶽鷀鷼银辶鹻麬麱麽黆铜黢黱黸竈齄𠂔𠊷𠎠椚铃妬𠓗塀铁㞹𠗕𠘕𠙶𡚺块煳𠫂𠫍𠮿呪吆𠯋咞𠯻𠰻𠱓𠱥𠱼惧𠲍噺𠲵𠳝𠳭𠵯𠶲𠷈楕鰯螥𠸄𠸎𠻗𠾐𠼭𠹳尠𠾼帋𡁜𡁏𡁶朞𡁻𡂈𡂖㙇𡂿𡃓𡄯𡄻卤蒭𡋣𡍵𡌶讁𡕷𡘙𡟃𡟇乸炻𡠭𡥪"],["9b40","𡨭𡩅𡰪𡱰𡲬𡻈拃𡻕𡼕熘桕𢁅槩㛈𢉼𢏗𢏺𢜪𢡱𢥏苽𢥧𢦓𢫕覥𢫨辠𢬎鞸𢬿顇骽𢱌"],["9b62","𢲈𢲷𥯨𢴈𢴒𢶷𢶕𢹂𢽴𢿌𣀳𣁦𣌟𣏞徱晈暿𧩹𣕧𣗳爁𤦺矗𣘚𣜖纇𠍆墵朎"],["9ba1","椘𣪧𧙗𥿢𣸑𣺹𧗾𢂚䣐䪸𤄙𨪚𤋮𤌍𤀻𤌴𤎖𤩅𠗊凒𠘑妟𡺨㮾𣳿𤐄𤓖垈𤙴㦛𤜯𨗨𩧉㝢𢇃譞𨭎駖𤠒𤣻𤨕爉𤫀𠱸奥𤺥𤾆𠝹軚𥀬劏圿煱𥊙𥐙𣽊𤪧喼𥑆𥑮𦭒釔㑳𥔿𧘲𥕞䜘𥕢𥕦𥟇𤤿𥡝偦㓻𣏌惞𥤃䝼𨥈𥪮𥮉𥰆𡶐垡煑澶𦄂𧰒遖𦆲𤾚譢𦐂𦑊"],["9c40","嵛𦯷輶𦒄𡤜諪𤧶𦒈𣿯𦔒䯀𦖿𦚵𢜛鑥𥟡憕娧晉侻嚹𤔡𦛼乪𤤴陖涏𦲽㘘襷𦞙𦡮𦐑𦡞營𦣇筂𩃀𠨑𦤦鄄𦤹穅鷰𦧺騦𦨭㙟𦑩𠀡禃𦨴𦭛崬𣔙菏𦮝䛐𦲤画补𦶮墶"],["9ca1","㜜𢖍𧁋𧇍㱔𧊀𧊅銁𢅺𧊋錰𧋦𤧐氹钟𧑐𠻸蠧裵𢤦𨑳𡞱溸𤨪𡠠㦤㚹尐秣䔿暶𩲭𩢤襃𧟌𧡘囖䃟𡘊㦡𣜯𨃨𡏅熭荦𧧝𩆨婧䲷𧂯𨦫𧧽𧨊𧬋𧵦𤅺筃祾𨀉澵𪋟樃𨌘厢𦸇鎿栶靝𨅯𨀣𦦵𡏭𣈯𨁈嶅𨰰𨂃圕頣𨥉嶫𤦈斾槕叒𤪥𣾁㰑朶𨂐𨃴𨄮𡾡𨅏"],["9d40","𨆉𨆯𨈚𨌆𨌯𨎊㗊𨑨𨚪䣺揦𨥖砈鉕𨦸䏲𨧧䏟𨧨𨭆𨯔姸𨰉輋𨿅𩃬筑𩄐𩄼㷷𩅞𤫊运犏嚋𩓧𩗩𩖰𩖸𩜲𩣑𩥉𩥪𩧃𩨨𩬎𩵚𩶛纟𩻸𩼣䲤镇𪊓熢𪋿䶑递𪗋䶜𠲜达嗁"],["9da1","辺𢒰边𤪓䔉繿潖檱仪㓤𨬬𧢝㜺躀𡟵𨀤𨭬𨮙𧨾𦚯㷫𧙕𣲷𥘵𥥖亚𥺁𦉘嚿𠹭踎孭𣺈𤲞揞拐𡟶𡡻攰嘭𥱊吚𥌑㷆𩶘䱽嘢嘞罉𥻘奵𣵀蝰东𠿪𠵉𣚺脗鵞贘瘻鱅癎瞹鍅吲腈苷嘥脲萘肽嗪祢噃吖𠺝㗎嘅嗱曱𨋢㘭甴嗰喺咗啲𠱁𠲖廐𥅈𠹶𢱢"],["9e40","𠺢麫絚嗞𡁵抝靭咔賍燶酶揼掹揾啩𢭃鱲𢺳冚㓟𠶧冧呍唞唓癦踭𦢊疱肶蠄螆裇膶萜𡃁䓬猄𤜆宐茋𦢓噻𢛴𧴯𤆣𧵳𦻐𧊶酰𡇙鈈𣳼𪚩𠺬𠻹牦𡲢䝎𤿂𧿹𠿫䃺"],["9ea1","鱝攟𢶠䣳𤟠𩵼𠿬𠸊恢𧖣𠿭"],["9ead","𦁈𡆇熣纎鵐业丄㕷嬍沲卧㚬㧜卽㚥𤘘墚𤭮舭呋垪𥪕𠥹"],["9ec5","㩒𢑥獴𩺬䴉鯭𣳾𩼰䱛𤾩𩖞𩿞葜𣶶𧊲𦞳𣜠挮紥𣻷𣸬㨪逈勌㹴㙺䗩𠒎癀嫰𠺶硺𧼮墧䂿噼鮋嵴癔𪐴麅䳡痹㟻愙𣃚𤏲"],["9ef5","噝𡊩垧𤥣𩸆刴𧂮㖭汊鵼"],["9f40","籖鬹埞𡝬屓擓𩓐𦌵𧅤蚭𠴨𦴢𤫢𠵱"],["9f4f","凾𡼏嶎霃𡷑麁遌笟鬂峑箣扨挵髿篏鬪籾鬮籂粆鰕篼鬉鼗鰛𤤾齚啳寃俽麘俲剠㸆勑坧偖妷帒韈鶫轜呩鞴饀鞺匬愰"],["9fa1","椬叚鰊鴂䰻陁榀傦畆𡝭駚剳"],["9fae","酙隁酜"],["9fb2","酑𨺗捿𦴣櫊嘑醎畺抅𠏼獏籰𥰡𣳽"],["9fc1","𤤙盖鮝个𠳔莾衂"],["9fc9","届槀僭坺刟巵从氱𠇲伹咜哚劚趂㗾弌㗳"],["9fdb","歒酼龥鮗頮颴骺麨麄煺笔"],["9fe7","毺蠘罸"],["9feb","嘠𪙊蹷齓"],["9ff0","跔蹏鸜踁抂𨍽踨蹵竓𤩷稾磘泪詧瘇"],["a040","𨩚鼦泎蟖痃𪊲硓咢贌狢獱謭猂瓱賫𤪻蘯徺袠䒷"],["a055","𡠻𦸅"],["a058","詾𢔛"],["a05b","惽癧髗鵄鍮鮏蟵"],["a063","蠏賷猬霡鮰㗖犲䰇籑饊𦅙慙䰄麖慽"],["a073","坟慯抦戹拎㩜懢厪𣏵捤栂㗒"],["a0a1","嵗𨯂迚𨸹"],["a0a6","僙𡵆礆匲阸𠼻䁥"],["a0ae","矾"],["a0b0","糂𥼚糚稭聦聣絍甅瓲覔舚朌聢𧒆聛瓰脃眤覉𦟌畓𦻑螩蟎臈螌詉貭譃眫瓸蓚㘵榲趦"],["a0d4","覩瑨涹蟁𤀑瓧㷛煶悤憜㳑煢恷"],["a0e2","罱𨬭牐惩䭾删㰘𣳇𥻗𧙖𥔱𡥄𡋾𩤃𦷜𧂭峁𦆭𨨏𣙷𠃮𦡆𤼎䕢嬟𦍌齐麦𦉫"],["a3c0","␀",31,"␡"],["c6a1","①",9,"⑴",9,"ⅰ",9,"丶丿亅亠冂冖冫勹匸卩厶夊宀巛⼳广廴彐彡攴无疒癶辵隶¨ˆヽヾゝゞ〃仝々〆〇ー［］✽ぁ",23],["c740","す",58,"ァアィイ"],["c7a1","ゥ",81,"А",5,"ЁЖ",4],["c840","Л",26,"ёж",25,"⇧↸↹㇏𠃌乚𠂊刂䒑"],["c8a1","龰冈龱𧘇"],["c8cd","￢￤＇＂㈱№℡゛゜⺀⺄⺆⺇⺈⺊⺌⺍⺕⺜⺝⺥⺧⺪⺬⺮⺶⺼⺾⻆⻊⻌⻍⻏⻖⻗⻞⻣"],["c8f5","ʃɐɛɔɵœøŋʊɪ"],["f9fe","￭"],["fa40","𠕇鋛𠗟𣿅蕌䊵珯况㙉𤥂𨧤鍄𡧛苮𣳈砼杄拟𤤳𨦪𠊠𦮳𡌅侫𢓭倈𦴩𧪄𣘀𤪱𢔓倩𠍾徤𠎀𠍇滛𠐟偽儁㑺儎顬㝃萖𤦤𠒇兠𣎴兪𠯿𢃼𠋥𢔰𠖎𣈳𡦃宂蝽𠖳𣲙冲冸"],["faa1","鴴凉减凑㳜凓𤪦决凢卂凭菍椾𣜭彻刋刦刼劵剗劔効勅簕蕂勠蘍𦬓包𨫞啉滙𣾀𠥔𣿬匳卄𠯢泋𡜦栛珕恊㺪㣌𡛨燝䒢卭却𨚫卾卿𡖖𡘓矦厓𨪛厠厫厮玧𥝲㽙玜叁叅汉义埾叙㪫𠮏叠𣿫𢶣叶𠱷吓灹唫晗浛呭𦭓𠵴啝咏咤䞦𡜍𠻝㶴𠵍"],["fb40","𨦼𢚘啇䳭启琗喆喩嘅𡣗𤀺䕒𤐵暳𡂴嘷曍𣊊暤暭噍噏磱囱鞇叾圀囯园𨭦㘣𡉏坆𤆥汮炋坂㚱𦱾埦𡐖堃𡑔𤍣堦𤯵塜墪㕡壠壜𡈼壻寿坃𪅐𤉸鏓㖡够梦㛃湙"],["fba1","𡘾娤啓𡚒蔅姉𠵎𦲁𦴪𡟜姙𡟻𡞲𦶦浱𡠨𡛕姹𦹅媫婣㛦𤦩婷㜈媖瑥嫓𦾡𢕔㶅𡤑㜲𡚸広勐孶斈孼𧨎䀄䡝𠈄寕慠𡨴𥧌𠖥寳宝䴐尅𡭄尓珎尔𡲥𦬨屉䣝岅峩峯嶋𡷹𡸷崐崘嵆𡺤岺巗苼㠭𤤁𢁉𢅳芇㠶㯂帮檊幵幺𤒼𠳓厦亷廐厨𡝱帉廴𨒂"],["fc40","廹廻㢠廼栾鐛弍𠇁弢㫞䢮𡌺强𦢈𢏐彘𢑱彣鞽𦹮彲鍀𨨶徧嶶㵟𥉐𡽪𧃸𢙨釖𠊞𨨩怱暅𡡷㥣㷇㘹垐𢞴祱㹀悞悤悳𤦂𤦏𧩓璤僡媠慤萤慂慈𦻒憁凴𠙖憇宪𣾷"],["fca1","𢡟懓𨮝𩥝懐㤲𢦀𢣁怣慜攞掋𠄘担𡝰拕𢸍捬𤧟㨗搸揸𡎎𡟼撐澊𢸶頔𤂌𥜝擡擥鑻㩦携㩗敍漖𤨨𤨣斅敭敟𣁾斵𤥀䬷旑䃘𡠩无旣忟𣐀昘𣇷𣇸晄𣆤𣆥晋𠹵晧𥇦晳晴𡸽𣈱𨗴𣇈𥌓矅𢣷馤朂𤎜𤨡㬫槺𣟂杞杧杢𤇍𩃭柗䓩栢湐鈼栁𣏦𦶠桝"],["fd40","𣑯槡樋𨫟楳棃𣗍椁椀㴲㨁𣘼㮀枬楡𨩊䋼椶榘㮡𠏉荣傐槹𣙙𢄪橅𣜃檝㯳枱櫈𩆜㰍欝𠤣惞欵歴𢟍溵𣫛𠎵𡥘㝀吡𣭚毡𣻼毜氷𢒋𤣱𦭑汚舦汹𣶼䓅𣶽𤆤𤤌𤤀"],["fda1","𣳉㛥㳫𠴲鮃𣇹𢒑羏样𦴥𦶡𦷫涖浜湼漄𤥿𤂅𦹲蔳𦽴凇沜渝萮𨬡港𣸯瑓𣾂秌湏媑𣁋濸㜍澝𣸰滺𡒗𤀽䕕鏰潄潜㵎潴𩅰㴻澟𤅄濓𤂑𤅕𤀹𣿰𣾴𤄿凟𤅖𤅗𤅀𦇝灋灾炧炁烌烕烖烟䄄㷨熴熖𤉷焫煅媈煊煮岜𤍥煏鍢𤋁焬𤑚𤨧𤨢熺𨯨炽爎"],["fe40","鑂爕夑鑃爤鍁𥘅爮牀𤥴梽牕牗㹕𣁄栍漽犂猪猫𤠣𨠫䣭𨠄猨献珏玪𠰺𦨮珉瑉𤇢𡛧𤨤昣㛅𤦷𤦍𤧻珷琕椃𤨦琹𠗃㻗瑜𢢭瑠𨺲瑇珤瑶莹瑬㜰瑴鏱樬璂䥓𤪌"],["fea1","𤅟𤩹𨮏孆𨰃𡢞瓈𡦈甎瓩甞𨻙𡩋寗𨺬鎅畍畊畧畮𤾂㼄𤴓疎瑝疞疴瘂瘬癑癏癯癶𦏵皐臯㟸𦤑𦤎皡皥皷盌𦾟葢𥂝𥅽𡸜眞眦着撯𥈠睘𣊬瞯𨥤𨥨𡛁矴砉𡍶𤨒棊碯磇磓隥礮𥗠磗礴碱𧘌辸袄𨬫𦂃𢘜禆褀椂禀𥡗禝𧬹礼禩渪𧄦㺨秆𩄍秔"]]')},34348:(e,t,a)=>{e.exports={read:read.bind(void 0,!1,void 0),readType:read.bind(void 0,!1),write:function write(e,t){o.object(e);var a,s=keyTypeToAlg(e),u=i.info[e.type];c.isPrivateKey(e)&&(u=i.privInfo[e.type]);var l=u.parts,m=new p({});for(m.writeString(s),a=0;a<l.length;++a){var f=e.part[l[a]].data;!1!==u.normalize&&(f="ed25519"===e.type?n.zeroPadToLength(f,32):n.mpNormalize(f)),"ed25519"===e.type&&"k"===l[a]&&(f=r.concat([f,e.part.A.data])),m.writeBuffer(f)}return m.toBuffer()},readPartial:read.bind(void 0,!0),readInternal:read,keyTypeToAlg,algToKeyType};var o=a(94742),r=a(54774).Buffer,i=a(6641),n=a(87461),s=a(64479),c=a(90009),p=a(46309);function algToKeyType(e){if(o.string(e),"ssh-dss"===e)return"dsa";if("ssh-rsa"===e)return"rsa";if("ssh-ed25519"===e)return"ed25519";if("ssh-curve25519"===e)return"curve25519";if(e.match(/^ecdsa-sha2-/))return"ecdsa";throw new Error("Unknown algorithm "+e)}function keyTypeToAlg(e){if(o.object(e),"dsa"===e.type)return"ssh-dss";if("rsa"===e.type)return"ssh-rsa";if("ed25519"===e.type)return"ssh-ed25519";if("curve25519"===e.type)return"ssh-curve25519";if("ecdsa"===e.type)return"ecdsa-sha2-"+e.part.curve.data.toString();throw new Error("Unknown key type "+e.type)}function read(e,t,a,u){"string"==typeof a&&(a=r.from(a)),o.buffer(a,"buf");var l={},m=l.parts=[],f=new p({buffer:a}),h=f.readString();o.ok(!f.atEnd(),"key must have at least one part"),l.type=algToKeyType(h);var g=i.info[l.type].parts.length;for(t&&"private"===t&&(g=i.privInfo[l.type].parts.length);!f.atEnd()&&m.length<g;)m.push(f.readPart());for(;!e&&!f.atEnd();)m.push(f.readPart());o.ok(m.length>=1,"key must have at least one part"),o.ok(e||f.atEnd(),"leftover bytes at end of key");var y=s,b=i.info[l.type];if("private"!==t&&b.parts.length===m.length||(b=i.privInfo[l.type],y=c),o.strictEqual(b.parts.length,m.length),"ecdsa"===l.type){var x=/^ecdsa-sha2-(.+)$/.exec(h);o.ok(null!==x),o.strictEqual(x[1],m[0].data.toString())}for(var w=!0,k=0;k<b.parts.length;++k){var j,C=m[k];if(C.name=b.parts[k],"ed25519"===l.type&&"k"===C.name&&(C.data=C.data.slice(0,32)),"curve"!==C.name&&!1!==b.normalize)(j="ed25519"===l.type?n.zeroPadToLength(C.data,32):n.mpNormalize(C.data)).toString("binary")!==C.data.toString("binary")&&(C.data=j,w=!1)}return w&&(l._rfc4253Cache=f.toBuffer()),e&&"object"==typeof e&&(e.remainder=f.remainder(),e.consumed=f._offset),new y(l)}},34458:e=>{"use strict";var t=/(?:^|,)\s*?no-cache\s*?(?:,|$)/;function parseHttpDate(e){var t=e&&Date.parse(e);return"number"==typeof t?t:NaN}e.exports=function fresh(e,a){var o=e["if-modified-since"],r=e["if-none-match"];if(!o&&!r)return!1;var i=e["cache-control"];if(i&&t.test(i))return!1;if(r&&"*"!==r){var n=a.etag;if(!n)return!1;for(var s=!0,c=function parseTokenList(e){for(var t=0,a=[],o=0,r=0,i=e.length;r<i;r++)switch(e.charCodeAt(r)){case 32:o===t&&(o=t=r+1);break;case 44:a.push(e.substring(o,t)),o=t=r+1;break;default:t=r+1}return a.push(e.substring(o,t)),a}(r),p=0;p<c.length;p++){var u=c[p];if(u===n||u==="W/"+n||"W/"+u===n){s=!1;break}}if(s)return!1}if(o){var l=a["last-modified"];if(!(l&&parseHttpDate(l)<=parseHttpDate(o)))return!1}return!0}},34486:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r={keyword:["maxProperties","minProperties"],type:"object",schemaType:"number",$data:!0,error:{message({keyword:e,schemaCode:t}){const a="maxProperties"===e?"more":"fewer";return o.str`should NOT have ${a} than ${t} items`},params:({schemaCode:e})=>o._`{limit: ${e}}`},code(e){const{keyword:t,data:a,schemaCode:r}=e,i="maxProperties"===t?o.operators.GT:o.operators.LT;e.fail$data(o._`Object.keys(${a}).length ${i} ${r}`)}};t.default=r},34519:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseSetDef=void 0;const o=a(98950),r=a(73524);t.parseSetDef=function parseSetDef(e,t){const a={type:"array",uniqueItems:!0,items:(0,r.parseDef)(e.valueType._def,{...t,currentPath:[...t.currentPath,"items"]})};return e.minSize&&(0,o.setResponseValueAndErrors)(a,"minItems",e.minSize.value,e.minSize.message,t),e.maxSize&&(0,o.setResponseValueAndErrors)(a,"maxItems",e.maxSize.value,e.maxSize.message,t),a}},34574:function(e,t,a){"use strict";var o,r=this&&this.__createBinding||(Object.create?function(e,t,a,o){void 0===o&&(o=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,o,r)}:function(e,t,a,o){void 0===o&&(o=a),e[o]=t[a]}),i=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__importStar||(o=function(e){return o=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t},o(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a=o(e),n=0;n<a.length;n++)"default"!==a[n]&&r(t,e,a[n]);return i(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.cacheManager=void 0;const s=n(a(91943)),c=n(a(16928)),p=n(a(70857));t.cacheManager=new class CacheManager{constructor(){this.cacheFilePath=c.join(p.homedir(),".edgeone","pages-cache.json")}async ensureCacheDir(){try{const e=c.dirname(this.cacheFilePath);await s.mkdir(e,{recursive:!0})}catch(e){console.warn(`[CacheManager] Failed to create cache directory: ${e}`)}}async loadCache(){try{const e=await s.readFile(this.cacheFilePath,"utf-8"),t=JSON.parse(e);return"1.0"!==t.cacheVersion?this.createEmptyCache():t}catch(e){return this.createEmptyCache()}}async saveCache(e){try{await this.ensureCacheDir(),await s.writeFile(this.cacheFilePath,JSON.stringify(e,null,2),"utf-8")}catch(e){console.warn(`[CacheManager] Failed to save cache: ${e}`)}}createEmptyCache(){return{cacheVersion:"1.0",entries:{}}}isExpired(e){return Date.now()>e.expiresAt}cleanExpiredEntries(e){const t={};for(const[a,o]of Object.entries(e.entries))this.isExpired(o)||(t[a]=o);return{...e,entries:t}}async getCachedResult(e){try{const t=(await this.loadCache()).entries[e];return t?this.isExpired(t)?(this.removeCachedResult(e).catch(()=>{}),null):t.data:null}catch(e){return console.warn(`[CacheManager] Failed to get cached result: ${e}`),null}}async setCachedResult(e,t){try{const a=await this.loadCache(),o=Date.now(),r=this.cleanExpiredEntries(a);r.entries[e]={data:t,timestamp:o,expiresAt:o+6e5},await this.saveCache(r)}catch(e){console.warn(`[CacheManager] Failed to set cached result: ${e}`)}}async removeCachedResult(e){try{const t=await this.loadCache();delete t.entries[e],await this.saveCache(t)}catch(e){console.warn(`[CacheManager] Failed to remove cached result: ${e}`)}}async clearCache(){try{await this.saveCache(this.createEmptyCache())}catch(e){console.warn(`[CacheManager] Failed to clear cache: ${e}`)}}}},34589:e=>{"use strict";e.exports=require("node:assert")},34610:(e,t,a)=>{"use strict";function checkDataType(e,t,a,o){var r=o?" !== ":" === ",i=o?" || ":" && ",n=o?"!":"",s=o?"":"!";switch(e){case"null":return t+r+"null";case"array":return n+"Array.isArray("+t+")";case"object":return"("+n+t+i+"typeof "+t+r+'"object"'+i+s+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+r+'"number"'+i+s+"("+t+" % 1)"+i+t+r+t+(a?i+n+"isFinite("+t+")":"")+")";case"number":return"(typeof "+t+r+'"'+e+'"'+(a?i+n+"isFinite("+t+")":"")+")";default:return"typeof "+t+r+'"'+e+'"'}}e.exports={copy:function copy(e,t){for(var a in t=t||{},e)t[a]=e[a];return t},checkDataType,checkDataTypes:function checkDataTypes(e,t,a){if(1===e.length)return checkDataType(e[0],t,a,!0);var o="",r=toHash(e);for(var i in r.array&&r.object&&(o=r.null?"(":"(!"+t+" || ",o+="typeof "+t+' !== "object")',delete r.null,delete r.array,delete r.object),r.number&&delete r.integer,r)o+=(o?" && ":"")+checkDataType(i,t,a,!0);return o},coerceToTypes:function coerceToTypes(e,t){if(Array.isArray(t)){for(var a=[],r=0;r<t.length;r++){var i=t[r];(o[i]||"array"===e&&"array"===i)&&(a[a.length]=i)}if(a.length)return a}else{if(o[t])return[t];if("array"===e&&"array"===t)return["array"]}},toHash,getProperty,escapeQuotes,equal:a(32017),ucs2length:a(95183),varOccurences:function varOccurences(e,t){t+="[^0-9]";var a=e.match(new RegExp(t,"g"));return a?a.length:0},varReplace:function varReplace(e,t,a){return t+="([^0-9])",a=a.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),a+"$1")},schemaHasRules:function schemaHasRules(e,t){if("boolean"==typeof e)return!e;for(var a in e)if(t[a])return!0},schemaHasRulesExcept:function schemaHasRulesExcept(e,t,a){if("boolean"==typeof e)return!e&&"not"!=a;for(var o in e)if(o!=a&&t[o])return!0},schemaUnknownRules:function schemaUnknownRules(e,t){if("boolean"==typeof e)return;for(var a in e)if(!t[a])return a},toQuotedString,getPathExpr:function getPathExpr(e,t,a,o){return joinPaths(e,a?"'/' + "+t+(o?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):o?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")},getPath:function getPath(e,t,a){var o=toQuotedString(a?"/"+escapeJsonPointer(t):getProperty(t));return joinPaths(e,o)},getData:function getData(e,t,a){var o,r,i,c;if(""===e)return"rootData";if("/"==e[0]){if(!n.test(e))throw new Error("Invalid JSON-pointer: "+e);r=e,i="rootData"}else{if(!(c=e.match(s)))throw new Error("Invalid JSON-pointer: "+e);if(o=+c[1],"#"==(r=c[2])){if(o>=t)throw new Error("Cannot access property/index "+o+" levels up, current level is "+t);return a[t-o]}if(o>t)throw new Error("Cannot access data "+o+" levels up, current level is "+t);if(i="data"+(t-o||""),!r)return i}for(var p=i,u=r.split("/"),l=0;l<u.length;l++){var m=u[l];m&&(p+=" && "+(i+=getProperty(unescapeJsonPointer(m))))}return p},unescapeFragment:function unescapeFragment(e){return unescapeJsonPointer(decodeURIComponent(e))},unescapeJsonPointer,escapeFragment:function escapeFragment(e){return encodeURIComponent(escapeJsonPointer(e))},escapeJsonPointer};var o=toHash(["string","number","integer","boolean","null"]);function toHash(e){for(var t={},a=0;a<e.length;a++)t[e[a]]=!0;return t}var r=/^[a-z$_][a-z$_0-9]*$/i,i=/'|\\/g;function getProperty(e){return"number"==typeof e?"["+e+"]":r.test(e)?"."+e:"['"+escapeQuotes(e)+"']"}function escapeQuotes(e){return e.replace(i,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function toQuotedString(e){return"'"+escapeQuotes(e)+"'"}var n=/^\/(?:[^~]|~0|~1)*$/,s=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function joinPaths(e,t){return'""'==e?t:(e+" + "+t).replace(/([^\\])' \+ '/g,"$1")}function escapeJsonPointer(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function unescapeJsonPointer(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}},34633:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.zodToJsonSchema=void 0;const o=a(73524),r=a(11076);t.zodToJsonSchema=(e,t)=>{const a=(0,r.getRefs)(t),i="object"==typeof t&&t.definitions?Object.entries(t.definitions).reduce((e,[t,r])=>({...e,[t]:(0,o.parseDef)(r._def,{...a,currentPath:[...a.basePath,a.definitionPath,t]},!0)??{}}),{}):void 0,n="string"==typeof t?t:"title"===t?.nameStrategy?void 0:t?.name,s=(0,o.parseDef)(e._def,void 0===n?a:{...a,currentPath:[...a.basePath,a.definitionPath,n]},!1)??{},c="object"==typeof t&&void 0!==t.name&&"title"===t.nameStrategy?t.name:void 0;void 0!==c&&(s.title=c);const p=void 0===n?i?{...s,[a.definitionPath]:i}:s:{$ref:[..."relative"===a.$refStrategy?[]:a.basePath,a.definitionPath,n].join("/"),[a.definitionPath]:{...i,[n]:s}};return"jsonSchema7"===a.target?p.$schema="http://json-schema.org/draft-07/schema#":"jsonSchema2019-09"!==a.target&&"openAi"!==a.target||(p.$schema="https://json-schema.org/draft/2019-09/schema#"),"openAi"===a.target&&("anyOf"in p||"oneOf"in p||"allOf"in p||"type"in p&&Array.isArray(p.type))&&console.warn("Warning: OpenAI may not support schemas with unions as roots! Try wrapping it in an object property."),p}},34836:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseLiteralDef=void 0,t.parseLiteralDef=function parseLiteralDef(e,t){const a=typeof e.value;return"bigint"!==a&&"number"!==a&&"boolean"!==a&&"string"!==a?{type:Array.isArray(e.value)?"array":"object"}:"openApi3"===t.target?{type:"bigint"===a?"integer":a,enum:[e.value]}:{type:"bigint"===a?"integer":a,const:e.value}}},34899:(e,t,a)=>{"use strict";var o=a(20181).Buffer,r=a(2203).Transform;function IconvLiteEncoderStream(e,t){this.conv=e,(t=t||{}).decodeStrings=!1,r.call(this,t)}function IconvLiteDecoderStream(e,t){this.conv=e,(t=t||{}).encoding=this.encoding="utf8",r.call(this,t)}e.exports=function(e){e.encodeStream=function encodeStream(t,a){return new IconvLiteEncoderStream(e.getEncoder(t,a),a)},e.decodeStream=function decodeStream(t,a){return new IconvLiteDecoderStream(e.getDecoder(t,a),a)},e.supportsStreams=!0,e.IconvLiteEncoderStream=IconvLiteEncoderStream,e.IconvLiteDecoderStream=IconvLiteDecoderStream,e._collect=IconvLiteDecoderStream.prototype.collect},IconvLiteEncoderStream.prototype=Object.create(r.prototype,{constructor:{value:IconvLiteEncoderStream}}),IconvLiteEncoderStream.prototype._transform=function(e,t,a){if("string"!=typeof e)return a(new Error("Iconv encoding stream needs strings as its input."));try{var o=this.conv.write(e);o&&o.length&&this.push(o),a()}catch(e){a(e)}},IconvLiteEncoderStream.prototype._flush=function(e){try{var t=this.conv.end();t&&t.length&&this.push(t),e()}catch(t){e(t)}},IconvLiteEncoderStream.prototype.collect=function(e){var t=[];return this.on("error",e),this.on("data",function(e){t.push(e)}),this.on("end",function(){e(null,o.concat(t))}),this},IconvLiteDecoderStream.prototype=Object.create(r.prototype,{constructor:{value:IconvLiteDecoderStream}}),IconvLiteDecoderStream.prototype._transform=function(e,t,a){if(!o.isBuffer(e))return a(new Error("Iconv decoding stream needs buffers as its input."));try{var r=this.conv.write(e);r&&r.length&&this.push(r,this.encoding),a()}catch(e){a(e)}},IconvLiteDecoderStream.prototype._flush=function(e){try{var t=this.conv.end();t&&t.length&&this.push(t,this.encoding),e()}catch(t){e(t)}},IconvLiteDecoderStream.prototype.collect=function(e){var t="";return this.on("error",e),this.on("data",function(e){t+=e}),this.on("end",function(){e(null,t)}),this}},35317:e=>{"use strict";e.exports=require("child_process")},35324:e=>{"use strict";e.exports=JSON.parse('{"application/1d-interleaved-parityfec":{"source":"iana"},"application/3gpdash-qoe-report+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/3gpp-ims+xml":{"source":"iana","compressible":true},"application/3gpphal+json":{"source":"iana","compressible":true},"application/3gpphalforms+json":{"source":"iana","compressible":true},"application/a2l":{"source":"iana"},"application/ace+cbor":{"source":"iana"},"application/ace+json":{"source":"iana","compressible":true},"application/ace-groupcomm+cbor":{"source":"iana"},"application/ace-trl+cbor":{"source":"iana"},"application/activemessage":{"source":"iana"},"application/activity+json":{"source":"iana","compressible":true},"application/aif+cbor":{"source":"iana"},"application/aif+json":{"source":"iana","compressible":true},"application/alto-cdni+json":{"source":"iana","compressible":true},"application/alto-cdnifilter+json":{"source":"iana","compressible":true},"application/alto-costmap+json":{"source":"iana","compressible":true},"application/alto-costmapfilter+json":{"source":"iana","compressible":true},"application/alto-directory+json":{"source":"iana","compressible":true},"application/alto-endpointcost+json":{"source":"iana","compressible":true},"application/alto-endpointcostparams+json":{"source":"iana","compressible":true},"application/alto-endpointprop+json":{"source":"iana","compressible":true},"application/alto-endpointpropparams+json":{"source":"iana","compressible":true},"application/alto-error+json":{"source":"iana","compressible":true},"application/alto-networkmap+json":{"source":"iana","compressible":true},"application/alto-networkmapfilter+json":{"source":"iana","compressible":true},"application/alto-propmap+json":{"source":"iana","compressible":true},"application/alto-propmapparams+json":{"source":"iana","compressible":true},"application/alto-tips+json":{"source":"iana","compressible":true},"application/alto-tipsparams+json":{"source":"iana","compressible":true},"application/alto-updatestreamcontrol+json":{"source":"iana","compressible":true},"application/alto-updatestreamparams+json":{"source":"iana","compressible":true},"application/aml":{"source":"iana"},"application/andrew-inset":{"source":"iana","extensions":["ez"]},"application/appinstaller":{"compressible":false,"extensions":["appinstaller"]},"application/applefile":{"source":"iana"},"application/applixware":{"source":"apache","extensions":["aw"]},"application/appx":{"compressible":false,"extensions":["appx"]},"application/appxbundle":{"compressible":false,"extensions":["appxbundle"]},"application/at+jwt":{"source":"iana"},"application/atf":{"source":"iana"},"application/atfx":{"source":"iana"},"application/atom+xml":{"source":"iana","compressible":true,"extensions":["atom"]},"application/atomcat+xml":{"source":"iana","compressible":true,"extensions":["atomcat"]},"application/atomdeleted+xml":{"source":"iana","compressible":true,"extensions":["atomdeleted"]},"application/atomicmail":{"source":"iana"},"application/atomsvc+xml":{"source":"iana","compressible":true,"extensions":["atomsvc"]},"application/atsc-dwd+xml":{"source":"iana","compressible":true,"extensions":["dwd"]},"application/atsc-dynamic-event-message":{"source":"iana"},"application/atsc-held+xml":{"source":"iana","compressible":true,"extensions":["held"]},"application/atsc-rdt+json":{"source":"iana","compressible":true},"application/atsc-rsat+xml":{"source":"iana","compressible":true,"extensions":["rsat"]},"application/atxml":{"source":"iana"},"application/auth-policy+xml":{"source":"iana","compressible":true},"application/automationml-aml+xml":{"source":"iana","compressible":true,"extensions":["aml"]},"application/automationml-amlx+zip":{"source":"iana","compressible":false,"extensions":["amlx"]},"application/bacnet-xdd+zip":{"source":"iana","compressible":false},"application/batch-smtp":{"source":"iana"},"application/bdoc":{"compressible":false,"extensions":["bdoc"]},"application/beep+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/bufr":{"source":"iana"},"application/c2pa":{"source":"iana"},"application/calendar+json":{"source":"iana","compressible":true},"application/calendar+xml":{"source":"iana","compressible":true,"extensions":["xcs"]},"application/call-completion":{"source":"iana"},"application/cals-1840":{"source":"iana"},"application/captive+json":{"source":"iana","compressible":true},"application/cbor":{"source":"iana"},"application/cbor-seq":{"source":"iana"},"application/cccex":{"source":"iana"},"application/ccmp+xml":{"source":"iana","compressible":true},"application/ccxml+xml":{"source":"iana","compressible":true,"extensions":["ccxml"]},"application/cda+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/cdfx+xml":{"source":"iana","compressible":true,"extensions":["cdfx"]},"application/cdmi-capability":{"source":"iana","extensions":["cdmia"]},"application/cdmi-container":{"source":"iana","extensions":["cdmic"]},"application/cdmi-domain":{"source":"iana","extensions":["cdmid"]},"application/cdmi-object":{"source":"iana","extensions":["cdmio"]},"application/cdmi-queue":{"source":"iana","extensions":["cdmiq"]},"application/cdni":{"source":"iana"},"application/ce+cbor":{"source":"iana"},"application/cea":{"source":"iana"},"application/cea-2018+xml":{"source":"iana","compressible":true},"application/cellml+xml":{"source":"iana","compressible":true},"application/cfw":{"source":"iana"},"application/cid-edhoc+cbor-seq":{"source":"iana"},"application/city+json":{"source":"iana","compressible":true},"application/city+json-seq":{"source":"iana"},"application/clr":{"source":"iana"},"application/clue+xml":{"source":"iana","compressible":true},"application/clue_info+xml":{"source":"iana","compressible":true},"application/cms":{"source":"iana"},"application/cnrp+xml":{"source":"iana","compressible":true},"application/coap-eap":{"source":"iana"},"application/coap-group+json":{"source":"iana","compressible":true},"application/coap-payload":{"source":"iana"},"application/commonground":{"source":"iana"},"application/concise-problem-details+cbor":{"source":"iana"},"application/conference-info+xml":{"source":"iana","compressible":true},"application/cose":{"source":"iana"},"application/cose-key":{"source":"iana"},"application/cose-key-set":{"source":"iana"},"application/cose-x509":{"source":"iana"},"application/cpl+xml":{"source":"iana","compressible":true,"extensions":["cpl"]},"application/csrattrs":{"source":"iana"},"application/csta+xml":{"source":"iana","compressible":true},"application/cstadata+xml":{"source":"iana","compressible":true},"application/csvm+json":{"source":"iana","compressible":true},"application/cu-seeme":{"source":"apache","extensions":["cu"]},"application/cwl":{"source":"iana","extensions":["cwl"]},"application/cwl+json":{"source":"iana","compressible":true},"application/cwl+yaml":{"source":"iana"},"application/cwt":{"source":"iana"},"application/cybercash":{"source":"iana"},"application/dart":{"compressible":true},"application/dash+xml":{"source":"iana","compressible":true,"extensions":["mpd"]},"application/dash-patch+xml":{"source":"iana","compressible":true,"extensions":["mpp"]},"application/dashdelta":{"source":"iana"},"application/davmount+xml":{"source":"iana","compressible":true,"extensions":["davmount"]},"application/dca-rft":{"source":"iana"},"application/dcd":{"source":"iana"},"application/dec-dx":{"source":"iana"},"application/dialog-info+xml":{"source":"iana","compressible":true},"application/dicom":{"source":"iana","extensions":["dcm"]},"application/dicom+json":{"source":"iana","compressible":true},"application/dicom+xml":{"source":"iana","compressible":true},"application/dii":{"source":"iana"},"application/dit":{"source":"iana"},"application/dns":{"source":"iana"},"application/dns+json":{"source":"iana","compressible":true},"application/dns-message":{"source":"iana"},"application/docbook+xml":{"source":"apache","compressible":true,"extensions":["dbk"]},"application/dots+cbor":{"source":"iana"},"application/dpop+jwt":{"source":"iana"},"application/dskpp+xml":{"source":"iana","compressible":true},"application/dssc+der":{"source":"iana","extensions":["dssc"]},"application/dssc+xml":{"source":"iana","compressible":true,"extensions":["xdssc"]},"application/dvcs":{"source":"iana"},"application/eat+cwt":{"source":"iana"},"application/eat+jwt":{"source":"iana"},"application/eat-bun+cbor":{"source":"iana"},"application/eat-bun+json":{"source":"iana","compressible":true},"application/eat-ucs+cbor":{"source":"iana"},"application/eat-ucs+json":{"source":"iana","compressible":true},"application/ecmascript":{"source":"apache","compressible":true,"extensions":["ecma"]},"application/edhoc+cbor-seq":{"source":"iana"},"application/edi-consent":{"source":"iana"},"application/edi-x12":{"source":"iana","compressible":false},"application/edifact":{"source":"iana","compressible":false},"application/efi":{"source":"iana"},"application/elm+json":{"source":"iana","charset":"UTF-8","compressible":true},"application/elm+xml":{"source":"iana","compressible":true},"application/emergencycalldata.cap+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/emergencycalldata.comment+xml":{"source":"iana","compressible":true},"application/emergencycalldata.control+xml":{"source":"iana","compressible":true},"application/emergencycalldata.deviceinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.ecall.msd":{"source":"iana"},"application/emergencycalldata.legacyesn+json":{"source":"iana","compressible":true},"application/emergencycalldata.providerinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.serviceinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.subscriberinfo+xml":{"source":"iana","compressible":true},"application/emergencycalldata.veds+xml":{"source":"iana","compressible":true},"application/emma+xml":{"source":"iana","compressible":true,"extensions":["emma"]},"application/emotionml+xml":{"source":"iana","compressible":true,"extensions":["emotionml"]},"application/encaprtp":{"source":"iana"},"application/entity-statement+jwt":{"source":"iana"},"application/epp+xml":{"source":"iana","compressible":true},"application/epub+zip":{"source":"iana","compressible":false,"extensions":["epub"]},"application/eshop":{"source":"iana"},"application/exi":{"source":"iana","extensions":["exi"]},"application/expect-ct-report+json":{"source":"iana","compressible":true},"application/express":{"source":"iana","extensions":["exp"]},"application/fastinfoset":{"source":"iana"},"application/fastsoap":{"source":"iana"},"application/fdf":{"source":"iana","extensions":["fdf"]},"application/fdt+xml":{"source":"iana","compressible":true,"extensions":["fdt"]},"application/fhir+json":{"source":"iana","charset":"UTF-8","compressible":true},"application/fhir+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/fido.trusted-apps+json":{"compressible":true},"application/fits":{"source":"iana"},"application/flexfec":{"source":"iana"},"application/font-sfnt":{"source":"iana"},"application/font-tdpfr":{"source":"iana","extensions":["pfr"]},"application/font-woff":{"source":"iana","compressible":false},"application/framework-attributes+xml":{"source":"iana","compressible":true},"application/geo+json":{"source":"iana","compressible":true,"extensions":["geojson"]},"application/geo+json-seq":{"source":"iana"},"application/geopackage+sqlite3":{"source":"iana"},"application/geopose+json":{"source":"iana","compressible":true},"application/geoxacml+json":{"source":"iana","compressible":true},"application/geoxacml+xml":{"source":"iana","compressible":true},"application/gltf-buffer":{"source":"iana"},"application/gml+xml":{"source":"iana","compressible":true,"extensions":["gml"]},"application/gnap-binding-jws":{"source":"iana"},"application/gnap-binding-jwsd":{"source":"iana"},"application/gnap-binding-rotation-jws":{"source":"iana"},"application/gnap-binding-rotation-jwsd":{"source":"iana"},"application/gpx+xml":{"source":"apache","compressible":true,"extensions":["gpx"]},"application/grib":{"source":"iana"},"application/gxf":{"source":"apache","extensions":["gxf"]},"application/gzip":{"source":"iana","compressible":false,"extensions":["gz"]},"application/h224":{"source":"iana"},"application/held+xml":{"source":"iana","compressible":true},"application/hjson":{"extensions":["hjson"]},"application/hl7v2+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/http":{"source":"iana"},"application/hyperstudio":{"source":"iana","extensions":["stk"]},"application/ibe-key-request+xml":{"source":"iana","compressible":true},"application/ibe-pkg-reply+xml":{"source":"iana","compressible":true},"application/ibe-pp-data":{"source":"iana"},"application/iges":{"source":"iana"},"application/im-iscomposing+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/index":{"source":"iana"},"application/index.cmd":{"source":"iana"},"application/index.obj":{"source":"iana"},"application/index.response":{"source":"iana"},"application/index.vnd":{"source":"iana"},"application/inkml+xml":{"source":"iana","compressible":true,"extensions":["ink","inkml"]},"application/iotp":{"source":"iana"},"application/ipfix":{"source":"iana","extensions":["ipfix"]},"application/ipp":{"source":"iana"},"application/isup":{"source":"iana"},"application/its+xml":{"source":"iana","compressible":true,"extensions":["its"]},"application/java-archive":{"source":"iana","compressible":false,"extensions":["jar","war","ear"]},"application/java-serialized-object":{"source":"apache","compressible":false,"extensions":["ser"]},"application/java-vm":{"source":"apache","compressible":false,"extensions":["class"]},"application/javascript":{"source":"apache","charset":"UTF-8","compressible":true,"extensions":["js"]},"application/jf2feed+json":{"source":"iana","compressible":true},"application/jose":{"source":"iana"},"application/jose+json":{"source":"iana","compressible":true},"application/jrd+json":{"source":"iana","compressible":true},"application/jscalendar+json":{"source":"iana","compressible":true},"application/jscontact+json":{"source":"iana","compressible":true},"application/json":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["json","map"]},"application/json-patch+json":{"source":"iana","compressible":true},"application/json-seq":{"source":"iana"},"application/json5":{"extensions":["json5"]},"application/jsonml+json":{"source":"apache","compressible":true,"extensions":["jsonml"]},"application/jsonpath":{"source":"iana"},"application/jwk+json":{"source":"iana","compressible":true},"application/jwk-set+json":{"source":"iana","compressible":true},"application/jwk-set+jwt":{"source":"iana"},"application/jwt":{"source":"iana"},"application/kpml-request+xml":{"source":"iana","compressible":true},"application/kpml-response+xml":{"source":"iana","compressible":true},"application/ld+json":{"source":"iana","compressible":true,"extensions":["jsonld"]},"application/lgr+xml":{"source":"iana","compressible":true,"extensions":["lgr"]},"application/link-format":{"source":"iana"},"application/linkset":{"source":"iana"},"application/linkset+json":{"source":"iana","compressible":true},"application/load-control+xml":{"source":"iana","compressible":true},"application/logout+jwt":{"source":"iana"},"application/lost+xml":{"source":"iana","compressible":true,"extensions":["lostxml"]},"application/lostsync+xml":{"source":"iana","compressible":true},"application/lpf+zip":{"source":"iana","compressible":false},"application/lxf":{"source":"iana"},"application/mac-binhex40":{"source":"iana","extensions":["hqx"]},"application/mac-compactpro":{"source":"apache","extensions":["cpt"]},"application/macwriteii":{"source":"iana"},"application/mads+xml":{"source":"iana","compressible":true,"extensions":["mads"]},"application/manifest+json":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["webmanifest"]},"application/marc":{"source":"iana","extensions":["mrc"]},"application/marcxml+xml":{"source":"iana","compressible":true,"extensions":["mrcx"]},"application/mathematica":{"source":"iana","extensions":["ma","nb","mb"]},"application/mathml+xml":{"source":"iana","compressible":true,"extensions":["mathml"]},"application/mathml-content+xml":{"source":"iana","compressible":true},"application/mathml-presentation+xml":{"source":"iana","compressible":true},"application/mbms-associated-procedure-description+xml":{"source":"iana","compressible":true},"application/mbms-deregister+xml":{"source":"iana","compressible":true},"application/mbms-envelope+xml":{"source":"iana","compressible":true},"application/mbms-msk+xml":{"source":"iana","compressible":true},"application/mbms-msk-response+xml":{"source":"iana","compressible":true},"application/mbms-protection-description+xml":{"source":"iana","compressible":true},"application/mbms-reception-report+xml":{"source":"iana","compressible":true},"application/mbms-register+xml":{"source":"iana","compressible":true},"application/mbms-register-response+xml":{"source":"iana","compressible":true},"application/mbms-schedule+xml":{"source":"iana","compressible":true},"application/mbms-user-service-description+xml":{"source":"iana","compressible":true},"application/mbox":{"source":"iana","extensions":["mbox"]},"application/media-policy-dataset+xml":{"source":"iana","compressible":true,"extensions":["mpf"]},"application/media_control+xml":{"source":"iana","compressible":true},"application/mediaservercontrol+xml":{"source":"iana","compressible":true,"extensions":["mscml"]},"application/merge-patch+json":{"source":"iana","compressible":true},"application/metalink+xml":{"source":"apache","compressible":true,"extensions":["metalink"]},"application/metalink4+xml":{"source":"iana","compressible":true,"extensions":["meta4"]},"application/mets+xml":{"source":"iana","compressible":true,"extensions":["mets"]},"application/mf4":{"source":"iana"},"application/mikey":{"source":"iana"},"application/mipc":{"source":"iana"},"application/missing-blocks+cbor-seq":{"source":"iana"},"application/mmt-aei+xml":{"source":"iana","compressible":true,"extensions":["maei"]},"application/mmt-usd+xml":{"source":"iana","compressible":true,"extensions":["musd"]},"application/mods+xml":{"source":"iana","compressible":true,"extensions":["mods"]},"application/moss-keys":{"source":"iana"},"application/moss-signature":{"source":"iana"},"application/mosskey-data":{"source":"iana"},"application/mosskey-request":{"source":"iana"},"application/mp21":{"source":"iana","extensions":["m21","mp21"]},"application/mp4":{"source":"iana","extensions":["mp4","mpg4","mp4s","m4p"]},"application/mpeg4-generic":{"source":"iana"},"application/mpeg4-iod":{"source":"iana"},"application/mpeg4-iod-xmt":{"source":"iana"},"application/mrb-consumer+xml":{"source":"iana","compressible":true},"application/mrb-publish+xml":{"source":"iana","compressible":true},"application/msc-ivr+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/msc-mixer+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/msix":{"compressible":false,"extensions":["msix"]},"application/msixbundle":{"compressible":false,"extensions":["msixbundle"]},"application/msword":{"source":"iana","compressible":false,"extensions":["doc","dot"]},"application/mud+json":{"source":"iana","compressible":true},"application/multipart-core":{"source":"iana"},"application/mxf":{"source":"iana","extensions":["mxf"]},"application/n-quads":{"source":"iana","extensions":["nq"]},"application/n-triples":{"source":"iana","extensions":["nt"]},"application/nasdata":{"source":"iana"},"application/news-checkgroups":{"source":"iana","charset":"US-ASCII"},"application/news-groupinfo":{"source":"iana","charset":"US-ASCII"},"application/news-transmission":{"source":"iana"},"application/nlsml+xml":{"source":"iana","compressible":true},"application/node":{"source":"iana","extensions":["cjs"]},"application/nss":{"source":"iana"},"application/oauth-authz-req+jwt":{"source":"iana"},"application/oblivious-dns-message":{"source":"iana"},"application/ocsp-request":{"source":"iana"},"application/ocsp-response":{"source":"iana"},"application/octet-stream":{"source":"iana","compressible":true,"extensions":["bin","dms","lrf","mar","so","dist","distz","pkg","bpk","dump","elc","deploy","exe","dll","deb","dmg","iso","img","msi","msp","msm","buffer"]},"application/oda":{"source":"iana","extensions":["oda"]},"application/odm+xml":{"source":"iana","compressible":true},"application/odx":{"source":"iana"},"application/oebps-package+xml":{"source":"iana","compressible":true,"extensions":["opf"]},"application/ogg":{"source":"iana","compressible":false,"extensions":["ogx"]},"application/ohttp-keys":{"source":"iana"},"application/omdoc+xml":{"source":"apache","compressible":true,"extensions":["omdoc"]},"application/onenote":{"source":"apache","extensions":["onetoc","onetoc2","onetmp","onepkg","one","onea"]},"application/opc-nodeset+xml":{"source":"iana","compressible":true},"application/oscore":{"source":"iana"},"application/oxps":{"source":"iana","extensions":["oxps"]},"application/p21":{"source":"iana"},"application/p21+zip":{"source":"iana","compressible":false},"application/p2p-overlay+xml":{"source":"iana","compressible":true,"extensions":["relo"]},"application/parityfec":{"source":"iana"},"application/passport":{"source":"iana"},"application/patch-ops-error+xml":{"source":"iana","compressible":true,"extensions":["xer"]},"application/pdf":{"source":"iana","compressible":false,"extensions":["pdf"]},"application/pdx":{"source":"iana"},"application/pem-certificate-chain":{"source":"iana"},"application/pgp-encrypted":{"source":"iana","compressible":false,"extensions":["pgp"]},"application/pgp-keys":{"source":"iana","extensions":["asc"]},"application/pgp-signature":{"source":"iana","extensions":["sig","asc"]},"application/pics-rules":{"source":"apache","extensions":["prf"]},"application/pidf+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/pidf-diff+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/pkcs10":{"source":"iana","extensions":["p10"]},"application/pkcs12":{"source":"iana"},"application/pkcs7-mime":{"source":"iana","extensions":["p7m","p7c"]},"application/pkcs7-signature":{"source":"iana","extensions":["p7s"]},"application/pkcs8":{"source":"iana","extensions":["p8"]},"application/pkcs8-encrypted":{"source":"iana"},"application/pkix-attr-cert":{"source":"iana","extensions":["ac"]},"application/pkix-cert":{"source":"iana","extensions":["cer"]},"application/pkix-crl":{"source":"iana","extensions":["crl"]},"application/pkix-pkipath":{"source":"iana","extensions":["pkipath"]},"application/pkixcmp":{"source":"iana","extensions":["pki"]},"application/pls+xml":{"source":"iana","compressible":true,"extensions":["pls"]},"application/poc-settings+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/postscript":{"source":"iana","compressible":true,"extensions":["ai","eps","ps"]},"application/ppsp-tracker+json":{"source":"iana","compressible":true},"application/private-token-issuer-directory":{"source":"iana"},"application/private-token-request":{"source":"iana"},"application/private-token-response":{"source":"iana"},"application/problem+json":{"source":"iana","compressible":true},"application/problem+xml":{"source":"iana","compressible":true},"application/provenance+xml":{"source":"iana","compressible":true,"extensions":["provx"]},"application/provided-claims+jwt":{"source":"iana"},"application/prs.alvestrand.titrax-sheet":{"source":"iana"},"application/prs.cww":{"source":"iana","extensions":["cww"]},"application/prs.cyn":{"source":"iana","charset":"7-BIT"},"application/prs.hpub+zip":{"source":"iana","compressible":false},"application/prs.implied-document+xml":{"source":"iana","compressible":true},"application/prs.implied-executable":{"source":"iana"},"application/prs.implied-object+json":{"source":"iana","compressible":true},"application/prs.implied-object+json-seq":{"source":"iana"},"application/prs.implied-object+yaml":{"source":"iana"},"application/prs.implied-structure":{"source":"iana"},"application/prs.mayfile":{"source":"iana"},"application/prs.nprend":{"source":"iana"},"application/prs.plucker":{"source":"iana"},"application/prs.rdf-xml-crypt":{"source":"iana"},"application/prs.vcfbzip2":{"source":"iana"},"application/prs.xsf+xml":{"source":"iana","compressible":true,"extensions":["xsf"]},"application/pskc+xml":{"source":"iana","compressible":true,"extensions":["pskcxml"]},"application/pvd+json":{"source":"iana","compressible":true},"application/qsig":{"source":"iana"},"application/raml+yaml":{"compressible":true,"extensions":["raml"]},"application/raptorfec":{"source":"iana"},"application/rdap+json":{"source":"iana","compressible":true},"application/rdf+xml":{"source":"iana","compressible":true,"extensions":["rdf","owl"]},"application/reginfo+xml":{"source":"iana","compressible":true,"extensions":["rif"]},"application/relax-ng-compact-syntax":{"source":"iana","extensions":["rnc"]},"application/remote-printing":{"source":"apache"},"application/reputon+json":{"source":"iana","compressible":true},"application/resolve-response+jwt":{"source":"iana"},"application/resource-lists+xml":{"source":"iana","compressible":true,"extensions":["rl"]},"application/resource-lists-diff+xml":{"source":"iana","compressible":true,"extensions":["rld"]},"application/rfc+xml":{"source":"iana","compressible":true},"application/riscos":{"source":"iana"},"application/rlmi+xml":{"source":"iana","compressible":true},"application/rls-services+xml":{"source":"iana","compressible":true,"extensions":["rs"]},"application/route-apd+xml":{"source":"iana","compressible":true,"extensions":["rapd"]},"application/route-s-tsid+xml":{"source":"iana","compressible":true,"extensions":["sls"]},"application/route-usd+xml":{"source":"iana","compressible":true,"extensions":["rusd"]},"application/rpki-checklist":{"source":"iana"},"application/rpki-ghostbusters":{"source":"iana","extensions":["gbr"]},"application/rpki-manifest":{"source":"iana","extensions":["mft"]},"application/rpki-publication":{"source":"iana"},"application/rpki-roa":{"source":"iana","extensions":["roa"]},"application/rpki-signed-tal":{"source":"iana"},"application/rpki-updown":{"source":"iana"},"application/rsd+xml":{"source":"apache","compressible":true,"extensions":["rsd"]},"application/rss+xml":{"source":"apache","compressible":true,"extensions":["rss"]},"application/rtf":{"source":"iana","compressible":true,"extensions":["rtf"]},"application/rtploopback":{"source":"iana"},"application/rtx":{"source":"iana"},"application/samlassertion+xml":{"source":"iana","compressible":true},"application/samlmetadata+xml":{"source":"iana","compressible":true},"application/sarif+json":{"source":"iana","compressible":true},"application/sarif-external-properties+json":{"source":"iana","compressible":true},"application/sbe":{"source":"iana"},"application/sbml+xml":{"source":"iana","compressible":true,"extensions":["sbml"]},"application/scaip+xml":{"source":"iana","compressible":true},"application/scim+json":{"source":"iana","compressible":true},"application/scvp-cv-request":{"source":"iana","extensions":["scq"]},"application/scvp-cv-response":{"source":"iana","extensions":["scs"]},"application/scvp-vp-request":{"source":"iana","extensions":["spq"]},"application/scvp-vp-response":{"source":"iana","extensions":["spp"]},"application/sdp":{"source":"iana","extensions":["sdp"]},"application/secevent+jwt":{"source":"iana"},"application/senml+cbor":{"source":"iana"},"application/senml+json":{"source":"iana","compressible":true},"application/senml+xml":{"source":"iana","compressible":true,"extensions":["senmlx"]},"application/senml-etch+cbor":{"source":"iana"},"application/senml-etch+json":{"source":"iana","compressible":true},"application/senml-exi":{"source":"iana"},"application/sensml+cbor":{"source":"iana"},"application/sensml+json":{"source":"iana","compressible":true},"application/sensml+xml":{"source":"iana","compressible":true,"extensions":["sensmlx"]},"application/sensml-exi":{"source":"iana"},"application/sep+xml":{"source":"iana","compressible":true},"application/sep-exi":{"source":"iana"},"application/session-info":{"source":"iana"},"application/set-payment":{"source":"iana"},"application/set-payment-initiation":{"source":"iana","extensions":["setpay"]},"application/set-registration":{"source":"iana"},"application/set-registration-initiation":{"source":"iana","extensions":["setreg"]},"application/sgml":{"source":"iana"},"application/sgml-open-catalog":{"source":"iana"},"application/shf+xml":{"source":"iana","compressible":true,"extensions":["shf"]},"application/sieve":{"source":"iana","extensions":["siv","sieve"]},"application/simple-filter+xml":{"source":"iana","compressible":true},"application/simple-message-summary":{"source":"iana"},"application/simplesymbolcontainer":{"source":"iana"},"application/sipc":{"source":"iana"},"application/slate":{"source":"iana"},"application/smil":{"source":"apache"},"application/smil+xml":{"source":"iana","compressible":true,"extensions":["smi","smil"]},"application/smpte336m":{"source":"iana"},"application/soap+fastinfoset":{"source":"iana"},"application/soap+xml":{"source":"iana","compressible":true},"application/sparql-query":{"source":"iana","extensions":["rq"]},"application/sparql-results+xml":{"source":"iana","compressible":true,"extensions":["srx"]},"application/spdx+json":{"source":"iana","compressible":true},"application/spirits-event+xml":{"source":"iana","compressible":true},"application/sql":{"source":"iana","extensions":["sql"]},"application/srgs":{"source":"iana","extensions":["gram"]},"application/srgs+xml":{"source":"iana","compressible":true,"extensions":["grxml"]},"application/sru+xml":{"source":"iana","compressible":true,"extensions":["sru"]},"application/ssdl+xml":{"source":"apache","compressible":true,"extensions":["ssdl"]},"application/sslkeylogfile":{"source":"iana"},"application/ssml+xml":{"source":"iana","compressible":true,"extensions":["ssml"]},"application/st2110-41":{"source":"iana"},"application/stix+json":{"source":"iana","compressible":true},"application/stratum":{"source":"iana"},"application/swid+cbor":{"source":"iana"},"application/swid+xml":{"source":"iana","compressible":true,"extensions":["swidtag"]},"application/tamp-apex-update":{"source":"iana"},"application/tamp-apex-update-confirm":{"source":"iana"},"application/tamp-community-update":{"source":"iana"},"application/tamp-community-update-confirm":{"source":"iana"},"application/tamp-error":{"source":"iana"},"application/tamp-sequence-adjust":{"source":"iana"},"application/tamp-sequence-adjust-confirm":{"source":"iana"},"application/tamp-status-query":{"source":"iana"},"application/tamp-status-response":{"source":"iana"},"application/tamp-update":{"source":"iana"},"application/tamp-update-confirm":{"source":"iana"},"application/tar":{"compressible":true},"application/taxii+json":{"source":"iana","compressible":true},"application/td+json":{"source":"iana","compressible":true},"application/tei+xml":{"source":"iana","compressible":true,"extensions":["tei","teicorpus"]},"application/tetra_isi":{"source":"iana"},"application/thraud+xml":{"source":"iana","compressible":true,"extensions":["tfi"]},"application/timestamp-query":{"source":"iana"},"application/timestamp-reply":{"source":"iana"},"application/timestamped-data":{"source":"iana","extensions":["tsd"]},"application/tlsrpt+gzip":{"source":"iana"},"application/tlsrpt+json":{"source":"iana","compressible":true},"application/tm+json":{"source":"iana","compressible":true},"application/tnauthlist":{"source":"iana"},"application/toc+cbor":{"source":"iana"},"application/token-introspection+jwt":{"source":"iana"},"application/toml":{"source":"iana","compressible":true,"extensions":["toml"]},"application/trickle-ice-sdpfrag":{"source":"iana"},"application/trig":{"source":"iana","extensions":["trig"]},"application/trust-chain+json":{"source":"iana","compressible":true},"application/trust-mark+jwt":{"source":"iana"},"application/trust-mark-delegation+jwt":{"source":"iana"},"application/ttml+xml":{"source":"iana","compressible":true,"extensions":["ttml"]},"application/tve-trigger":{"source":"iana"},"application/tzif":{"source":"iana"},"application/tzif-leap":{"source":"iana"},"application/ubjson":{"compressible":false,"extensions":["ubj"]},"application/uccs+cbor":{"source":"iana"},"application/ujcs+json":{"source":"iana","compressible":true},"application/ulpfec":{"source":"iana"},"application/urc-grpsheet+xml":{"source":"iana","compressible":true},"application/urc-ressheet+xml":{"source":"iana","compressible":true,"extensions":["rsheet"]},"application/urc-targetdesc+xml":{"source":"iana","compressible":true,"extensions":["td"]},"application/urc-uisocketdesc+xml":{"source":"iana","compressible":true},"application/vc":{"source":"iana"},"application/vc+cose":{"source":"iana"},"application/vc+jwt":{"source":"iana"},"application/vcard+json":{"source":"iana","compressible":true},"application/vcard+xml":{"source":"iana","compressible":true},"application/vemmi":{"source":"iana"},"application/vividence.scriptfile":{"source":"apache"},"application/vnd.1000minds.decision-model+xml":{"source":"iana","compressible":true,"extensions":["1km"]},"application/vnd.1ob":{"source":"iana"},"application/vnd.3gpp-prose+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-prose-pc3a+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-prose-pc3ach+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-prose-pc3ch+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-prose-pc8+xml":{"source":"iana","compressible":true},"application/vnd.3gpp-v2x-local-service-information":{"source":"iana"},"application/vnd.3gpp.5gnas":{"source":"iana"},"application/vnd.3gpp.5gsa2x":{"source":"iana"},"application/vnd.3gpp.5gsa2x-local-service-information":{"source":"iana"},"application/vnd.3gpp.5gsv2x":{"source":"iana"},"application/vnd.3gpp.5gsv2x-local-service-information":{"source":"iana"},"application/vnd.3gpp.access-transfer-events+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.bsf+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.crs+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.current-location-discovery+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.gmop+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.gtpc":{"source":"iana"},"application/vnd.3gpp.interworking-data":{"source":"iana"},"application/vnd.3gpp.lpp":{"source":"iana"},"application/vnd.3gpp.mc-signalling-ear":{"source":"iana"},"application/vnd.3gpp.mcdata-affiliation-command+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-msgstore-ctrl-request+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-payload":{"source":"iana"},"application/vnd.3gpp.mcdata-regroup+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-service-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-signalling":{"source":"iana"},"application/vnd.3gpp.mcdata-ue-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcdata-user-profile+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-affiliation-command+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-floor-request+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-location-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-mbms-usage-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-regroup+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-service-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-signed+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-ue-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-ue-init-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcptt-user-profile+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-affiliation-command+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-location-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-mbms-usage-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-regroup+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-service-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-transmission-request+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-ue-config+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mcvideo-user-profile+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.mid-call+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.ngap":{"source":"iana"},"application/vnd.3gpp.pfcp":{"source":"iana"},"application/vnd.3gpp.pic-bw-large":{"source":"iana","extensions":["plb"]},"application/vnd.3gpp.pic-bw-small":{"source":"iana","extensions":["psb"]},"application/vnd.3gpp.pic-bw-var":{"source":"iana","extensions":["pvb"]},"application/vnd.3gpp.pinapp-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.s1ap":{"source":"iana"},"application/vnd.3gpp.seal-group-doc+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-location-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-mbms-usage-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-network-qos-management-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-ue-config-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-unicast-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.seal-user-profile-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.sms":{"source":"iana"},"application/vnd.3gpp.sms+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.srvcc-ext+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.srvcc-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.state-and-event-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.ussd+xml":{"source":"iana","compressible":true},"application/vnd.3gpp.v2x":{"source":"iana"},"application/vnd.3gpp.vae-info+xml":{"source":"iana","compressible":true},"application/vnd.3gpp2.bcmcsinfo+xml":{"source":"iana","compressible":true},"application/vnd.3gpp2.sms":{"source":"iana"},"application/vnd.3gpp2.tcap":{"source":"iana","extensions":["tcap"]},"application/vnd.3lightssoftware.imagescal":{"source":"iana"},"application/vnd.3m.post-it-notes":{"source":"iana","extensions":["pwn"]},"application/vnd.accpac.simply.aso":{"source":"iana","extensions":["aso"]},"application/vnd.accpac.simply.imp":{"source":"iana","extensions":["imp"]},"application/vnd.acm.addressxfer+json":{"source":"iana","compressible":true},"application/vnd.acm.chatbot+json":{"source":"iana","compressible":true},"application/vnd.acucobol":{"source":"iana","extensions":["acu"]},"application/vnd.acucorp":{"source":"iana","extensions":["atc","acutc"]},"application/vnd.adobe.air-application-installer-package+zip":{"source":"apache","compressible":false,"extensions":["air"]},"application/vnd.adobe.flash.movie":{"source":"iana"},"application/vnd.adobe.formscentral.fcdt":{"source":"iana","extensions":["fcdt"]},"application/vnd.adobe.fxp":{"source":"iana","extensions":["fxp","fxpl"]},"application/vnd.adobe.partial-upload":{"source":"iana"},"application/vnd.adobe.xdp+xml":{"source":"iana","compressible":true,"extensions":["xdp"]},"application/vnd.adobe.xfdf":{"source":"apache","extensions":["xfdf"]},"application/vnd.aether.imp":{"source":"iana"},"application/vnd.afpc.afplinedata":{"source":"iana"},"application/vnd.afpc.afplinedata-pagedef":{"source":"iana"},"application/vnd.afpc.cmoca-cmresource":{"source":"iana"},"application/vnd.afpc.foca-charset":{"source":"iana"},"application/vnd.afpc.foca-codedfont":{"source":"iana"},"application/vnd.afpc.foca-codepage":{"source":"iana"},"application/vnd.afpc.modca":{"source":"iana"},"application/vnd.afpc.modca-cmtable":{"source":"iana"},"application/vnd.afpc.modca-formdef":{"source":"iana"},"application/vnd.afpc.modca-mediummap":{"source":"iana"},"application/vnd.afpc.modca-objectcontainer":{"source":"iana"},"application/vnd.afpc.modca-overlay":{"source":"iana"},"application/vnd.afpc.modca-pagesegment":{"source":"iana"},"application/vnd.age":{"source":"iana","extensions":["age"]},"application/vnd.ah-barcode":{"source":"apache"},"application/vnd.ahead.space":{"source":"iana","extensions":["ahead"]},"application/vnd.airzip.filesecure.azf":{"source":"iana","extensions":["azf"]},"application/vnd.airzip.filesecure.azs":{"source":"iana","extensions":["azs"]},"application/vnd.amadeus+json":{"source":"iana","compressible":true},"application/vnd.amazon.ebook":{"source":"apache","extensions":["azw"]},"application/vnd.amazon.mobi8-ebook":{"source":"iana"},"application/vnd.americandynamics.acc":{"source":"iana","extensions":["acc"]},"application/vnd.amiga.ami":{"source":"iana","extensions":["ami"]},"application/vnd.amundsen.maze+xml":{"source":"iana","compressible":true},"application/vnd.android.ota":{"source":"iana"},"application/vnd.android.package-archive":{"source":"apache","compressible":false,"extensions":["apk"]},"application/vnd.anki":{"source":"iana"},"application/vnd.anser-web-certificate-issue-initiation":{"source":"iana","extensions":["cii"]},"application/vnd.anser-web-funds-transfer-initiation":{"source":"apache","extensions":["fti"]},"application/vnd.antix.game-component":{"source":"iana","extensions":["atx"]},"application/vnd.apache.arrow.file":{"source":"iana"},"application/vnd.apache.arrow.stream":{"source":"iana"},"application/vnd.apache.parquet":{"source":"iana"},"application/vnd.apache.thrift.binary":{"source":"iana"},"application/vnd.apache.thrift.compact":{"source":"iana"},"application/vnd.apache.thrift.json":{"source":"iana"},"application/vnd.apexlang":{"source":"iana"},"application/vnd.api+json":{"source":"iana","compressible":true},"application/vnd.aplextor.warrp+json":{"source":"iana","compressible":true},"application/vnd.apothekende.reservation+json":{"source":"iana","compressible":true},"application/vnd.apple.installer+xml":{"source":"iana","compressible":true,"extensions":["mpkg"]},"application/vnd.apple.keynote":{"source":"iana","extensions":["key"]},"application/vnd.apple.mpegurl":{"source":"iana","extensions":["m3u8"]},"application/vnd.apple.numbers":{"source":"iana","extensions":["numbers"]},"application/vnd.apple.pages":{"source":"iana","extensions":["pages"]},"application/vnd.apple.pkpass":{"compressible":false,"extensions":["pkpass"]},"application/vnd.arastra.swi":{"source":"apache"},"application/vnd.aristanetworks.swi":{"source":"iana","extensions":["swi"]},"application/vnd.artisan+json":{"source":"iana","compressible":true},"application/vnd.artsquare":{"source":"iana"},"application/vnd.astraea-software.iota":{"source":"iana","extensions":["iota"]},"application/vnd.audiograph":{"source":"iana","extensions":["aep"]},"application/vnd.autodesk.fbx":{"extensions":["fbx"]},"application/vnd.autopackage":{"source":"iana"},"application/vnd.avalon+json":{"source":"iana","compressible":true},"application/vnd.avistar+xml":{"source":"iana","compressible":true},"application/vnd.balsamiq.bmml+xml":{"source":"iana","compressible":true,"extensions":["bmml"]},"application/vnd.balsamiq.bmpr":{"source":"iana"},"application/vnd.banana-accounting":{"source":"iana"},"application/vnd.bbf.usp.error":{"source":"iana"},"application/vnd.bbf.usp.msg":{"source":"iana"},"application/vnd.bbf.usp.msg+json":{"source":"iana","compressible":true},"application/vnd.bekitzur-stech+json":{"source":"iana","compressible":true},"application/vnd.belightsoft.lhzd+zip":{"source":"iana","compressible":false},"application/vnd.belightsoft.lhzl+zip":{"source":"iana","compressible":false},"application/vnd.bint.med-content":{"source":"iana"},"application/vnd.biopax.rdf+xml":{"source":"iana","compressible":true},"application/vnd.blink-idb-value-wrapper":{"source":"iana"},"application/vnd.blueice.multipass":{"source":"iana","extensions":["mpm"]},"application/vnd.bluetooth.ep.oob":{"source":"iana"},"application/vnd.bluetooth.le.oob":{"source":"iana"},"application/vnd.bmi":{"source":"iana","extensions":["bmi"]},"application/vnd.bpf":{"source":"iana"},"application/vnd.bpf3":{"source":"iana"},"application/vnd.businessobjects":{"source":"iana","extensions":["rep"]},"application/vnd.byu.uapi+json":{"source":"iana","compressible":true},"application/vnd.bzip3":{"source":"iana"},"application/vnd.c3voc.schedule+xml":{"source":"iana","compressible":true},"application/vnd.cab-jscript":{"source":"iana"},"application/vnd.canon-cpdl":{"source":"iana"},"application/vnd.canon-lips":{"source":"iana"},"application/vnd.capasystems-pg+json":{"source":"iana","compressible":true},"application/vnd.cendio.thinlinc.clientconf":{"source":"iana"},"application/vnd.century-systems.tcp_stream":{"source":"iana"},"application/vnd.chemdraw+xml":{"source":"iana","compressible":true,"extensions":["cdxml"]},"application/vnd.chess-pgn":{"source":"iana"},"application/vnd.chipnuts.karaoke-mmd":{"source":"iana","extensions":["mmd"]},"application/vnd.ciedi":{"source":"iana"},"application/vnd.cinderella":{"source":"iana","extensions":["cdy"]},"application/vnd.cirpack.isdn-ext":{"source":"iana"},"application/vnd.citationstyles.style+xml":{"source":"iana","compressible":true,"extensions":["csl"]},"application/vnd.claymore":{"source":"iana","extensions":["cla"]},"application/vnd.cloanto.rp9":{"source":"iana","extensions":["rp9"]},"application/vnd.clonk.c4group":{"source":"iana","extensions":["c4g","c4d","c4f","c4p","c4u"]},"application/vnd.cluetrust.cartomobile-config":{"source":"iana","extensions":["c11amc"]},"application/vnd.cluetrust.cartomobile-config-pkg":{"source":"iana","extensions":["c11amz"]},"application/vnd.cncf.helm.chart.content.v1.tar+gzip":{"source":"iana"},"application/vnd.cncf.helm.chart.provenance.v1.prov":{"source":"iana"},"application/vnd.cncf.helm.config.v1+json":{"source":"iana","compressible":true},"application/vnd.coffeescript":{"source":"iana"},"application/vnd.collabio.xodocuments.document":{"source":"iana"},"application/vnd.collabio.xodocuments.document-template":{"source":"iana"},"application/vnd.collabio.xodocuments.presentation":{"source":"iana"},"application/vnd.collabio.xodocuments.presentation-template":{"source":"iana"},"application/vnd.collabio.xodocuments.spreadsheet":{"source":"iana"},"application/vnd.collabio.xodocuments.spreadsheet-template":{"source":"iana"},"application/vnd.collection+json":{"source":"iana","compressible":true},"application/vnd.collection.doc+json":{"source":"iana","compressible":true},"application/vnd.collection.next+json":{"source":"iana","compressible":true},"application/vnd.comicbook+zip":{"source":"iana","compressible":false},"application/vnd.comicbook-rar":{"source":"iana"},"application/vnd.commerce-battelle":{"source":"iana"},"application/vnd.commonspace":{"source":"iana","extensions":["csp"]},"application/vnd.contact.cmsg":{"source":"iana","extensions":["cdbcmsg"]},"application/vnd.coreos.ignition+json":{"source":"iana","compressible":true},"application/vnd.cosmocaller":{"source":"iana","extensions":["cmc"]},"application/vnd.crick.clicker":{"source":"iana","extensions":["clkx"]},"application/vnd.crick.clicker.keyboard":{"source":"iana","extensions":["clkk"]},"application/vnd.crick.clicker.palette":{"source":"iana","extensions":["clkp"]},"application/vnd.crick.clicker.template":{"source":"iana","extensions":["clkt"]},"application/vnd.crick.clicker.wordbank":{"source":"iana","extensions":["clkw"]},"application/vnd.criticaltools.wbs+xml":{"source":"iana","compressible":true,"extensions":["wbs"]},"application/vnd.cryptii.pipe+json":{"source":"iana","compressible":true},"application/vnd.crypto-shade-file":{"source":"iana"},"application/vnd.cryptomator.encrypted":{"source":"iana"},"application/vnd.cryptomator.vault":{"source":"iana"},"application/vnd.ctc-posml":{"source":"iana","extensions":["pml"]},"application/vnd.ctct.ws+xml":{"source":"iana","compressible":true},"application/vnd.cups-pdf":{"source":"iana"},"application/vnd.cups-postscript":{"source":"iana"},"application/vnd.cups-ppd":{"source":"iana","extensions":["ppd"]},"application/vnd.cups-raster":{"source":"iana"},"application/vnd.cups-raw":{"source":"iana"},"application/vnd.curl":{"source":"iana"},"application/vnd.curl.car":{"source":"apache","extensions":["car"]},"application/vnd.curl.pcurl":{"source":"apache","extensions":["pcurl"]},"application/vnd.cyan.dean.root+xml":{"source":"iana","compressible":true},"application/vnd.cybank":{"source":"iana"},"application/vnd.cyclonedx+json":{"source":"iana","compressible":true},"application/vnd.cyclonedx+xml":{"source":"iana","compressible":true},"application/vnd.d2l.coursepackage1p0+zip":{"source":"iana","compressible":false},"application/vnd.d3m-dataset":{"source":"iana"},"application/vnd.d3m-problem":{"source":"iana"},"application/vnd.dart":{"source":"iana","compressible":true,"extensions":["dart"]},"application/vnd.data-vision.rdz":{"source":"iana","extensions":["rdz"]},"application/vnd.datalog":{"source":"iana"},"application/vnd.datapackage+json":{"source":"iana","compressible":true},"application/vnd.dataresource+json":{"source":"iana","compressible":true},"application/vnd.dbf":{"source":"iana","extensions":["dbf"]},"application/vnd.dcmp+xml":{"source":"iana","compressible":true,"extensions":["dcmp"]},"application/vnd.debian.binary-package":{"source":"iana"},"application/vnd.dece.data":{"source":"iana","extensions":["uvf","uvvf","uvd","uvvd"]},"application/vnd.dece.ttml+xml":{"source":"iana","compressible":true,"extensions":["uvt","uvvt"]},"application/vnd.dece.unspecified":{"source":"iana","extensions":["uvx","uvvx"]},"application/vnd.dece.zip":{"source":"iana","extensions":["uvz","uvvz"]},"application/vnd.denovo.fcselayout-link":{"source":"iana","extensions":["fe_launch"]},"application/vnd.desmume.movie":{"source":"iana"},"application/vnd.dir-bi.plate-dl-nosuffix":{"source":"iana"},"application/vnd.dm.delegation+xml":{"source":"iana","compressible":true},"application/vnd.dna":{"source":"iana","extensions":["dna"]},"application/vnd.document+json":{"source":"iana","compressible":true},"application/vnd.dolby.mlp":{"source":"apache","extensions":["mlp"]},"application/vnd.dolby.mobile.1":{"source":"iana"},"application/vnd.dolby.mobile.2":{"source":"iana"},"application/vnd.doremir.scorecloud-binary-document":{"source":"iana"},"application/vnd.dpgraph":{"source":"iana","extensions":["dpg"]},"application/vnd.dreamfactory":{"source":"iana","extensions":["dfac"]},"application/vnd.drive+json":{"source":"iana","compressible":true},"application/vnd.ds-keypoint":{"source":"apache","extensions":["kpxx"]},"application/vnd.dtg.local":{"source":"iana"},"application/vnd.dtg.local.flash":{"source":"iana"},"application/vnd.dtg.local.html":{"source":"iana"},"application/vnd.dvb.ait":{"source":"iana","extensions":["ait"]},"application/vnd.dvb.dvbisl+xml":{"source":"iana","compressible":true},"application/vnd.dvb.dvbj":{"source":"iana"},"application/vnd.dvb.esgcontainer":{"source":"iana"},"application/vnd.dvb.ipdcdftnotifaccess":{"source":"iana"},"application/vnd.dvb.ipdcesgaccess":{"source":"iana"},"application/vnd.dvb.ipdcesgaccess2":{"source":"iana"},"application/vnd.dvb.ipdcesgpdd":{"source":"iana"},"application/vnd.dvb.ipdcroaming":{"source":"iana"},"application/vnd.dvb.iptv.alfec-base":{"source":"iana"},"application/vnd.dvb.iptv.alfec-enhancement":{"source":"iana"},"application/vnd.dvb.notif-aggregate-root+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-container+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-generic+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-ia-msglist+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-ia-registration-request+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-ia-registration-response+xml":{"source":"iana","compressible":true},"application/vnd.dvb.notif-init+xml":{"source":"iana","compressible":true},"application/vnd.dvb.pfr":{"source":"iana"},"application/vnd.dvb.service":{"source":"iana","extensions":["svc"]},"application/vnd.dxr":{"source":"iana"},"application/vnd.dynageo":{"source":"iana","extensions":["geo"]},"application/vnd.dzr":{"source":"iana"},"application/vnd.easykaraoke.cdgdownload":{"source":"iana"},"application/vnd.ecdis-update":{"source":"iana"},"application/vnd.ecip.rlp":{"source":"iana"},"application/vnd.eclipse.ditto+json":{"source":"iana","compressible":true},"application/vnd.ecowin.chart":{"source":"iana","extensions":["mag"]},"application/vnd.ecowin.filerequest":{"source":"iana"},"application/vnd.ecowin.fileupdate":{"source":"iana"},"application/vnd.ecowin.series":{"source":"iana"},"application/vnd.ecowin.seriesrequest":{"source":"iana"},"application/vnd.ecowin.seriesupdate":{"source":"iana"},"application/vnd.efi.img":{"source":"iana"},"application/vnd.efi.iso":{"source":"iana"},"application/vnd.eln+zip":{"source":"iana","compressible":false},"application/vnd.emclient.accessrequest+xml":{"source":"iana","compressible":true},"application/vnd.enliven":{"source":"iana","extensions":["nml"]},"application/vnd.enphase.envoy":{"source":"iana"},"application/vnd.eprints.data+xml":{"source":"iana","compressible":true},"application/vnd.epson.esf":{"source":"iana","extensions":["esf"]},"application/vnd.epson.msf":{"source":"iana","extensions":["msf"]},"application/vnd.epson.quickanime":{"source":"iana","extensions":["qam"]},"application/vnd.epson.salt":{"source":"iana","extensions":["slt"]},"application/vnd.epson.ssf":{"source":"iana","extensions":["ssf"]},"application/vnd.ericsson.quickcall":{"source":"iana"},"application/vnd.erofs":{"source":"iana"},"application/vnd.espass-espass+zip":{"source":"iana","compressible":false},"application/vnd.eszigno3+xml":{"source":"iana","compressible":true,"extensions":["es3","et3"]},"application/vnd.etsi.aoc+xml":{"source":"iana","compressible":true},"application/vnd.etsi.asic-e+zip":{"source":"iana","compressible":false},"application/vnd.etsi.asic-s+zip":{"source":"iana","compressible":false},"application/vnd.etsi.cug+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvcommand+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvdiscovery+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvprofile+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsad-bc+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsad-cod+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsad-npvr+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvservice+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvsync+xml":{"source":"iana","compressible":true},"application/vnd.etsi.iptvueprofile+xml":{"source":"iana","compressible":true},"application/vnd.etsi.mcid+xml":{"source":"iana","compressible":true},"application/vnd.etsi.mheg5":{"source":"iana"},"application/vnd.etsi.overload-control-policy-dataset+xml":{"source":"iana","compressible":true},"application/vnd.etsi.pstn+xml":{"source":"iana","compressible":true},"application/vnd.etsi.sci+xml":{"source":"iana","compressible":true},"application/vnd.etsi.simservs+xml":{"source":"iana","compressible":true},"application/vnd.etsi.timestamp-token":{"source":"iana"},"application/vnd.etsi.tsl+xml":{"source":"iana","compressible":true},"application/vnd.etsi.tsl.der":{"source":"iana"},"application/vnd.eu.kasparian.car+json":{"source":"iana","compressible":true},"application/vnd.eudora.data":{"source":"iana"},"application/vnd.evolv.ecig.profile":{"source":"iana"},"application/vnd.evolv.ecig.settings":{"source":"iana"},"application/vnd.evolv.ecig.theme":{"source":"iana"},"application/vnd.exstream-empower+zip":{"source":"iana","compressible":false},"application/vnd.exstream-package":{"source":"iana"},"application/vnd.ezpix-album":{"source":"iana","extensions":["ez2"]},"application/vnd.ezpix-package":{"source":"iana","extensions":["ez3"]},"application/vnd.f-secure.mobile":{"source":"iana"},"application/vnd.familysearch.gedcom+zip":{"source":"iana","compressible":false},"application/vnd.fastcopy-disk-image":{"source":"iana"},"application/vnd.fdf":{"source":"apache","extensions":["fdf"]},"application/vnd.fdsn.mseed":{"source":"iana","extensions":["mseed"]},"application/vnd.fdsn.seed":{"source":"iana","extensions":["seed","dataless"]},"application/vnd.fdsn.stationxml+xml":{"source":"iana","charset":"XML-BASED","compressible":true},"application/vnd.ffsns":{"source":"iana"},"application/vnd.ficlab.flb+zip":{"source":"iana","compressible":false},"application/vnd.filmit.zfc":{"source":"iana"},"application/vnd.fints":{"source":"iana"},"application/vnd.firemonkeys.cloudcell":{"source":"iana"},"application/vnd.flographit":{"source":"iana","extensions":["gph"]},"application/vnd.fluxtime.clip":{"source":"iana","extensions":["ftc"]},"application/vnd.font-fontforge-sfd":{"source":"iana"},"application/vnd.framemaker":{"source":"iana","extensions":["fm","frame","maker","book"]},"application/vnd.freelog.comic":{"source":"iana"},"application/vnd.frogans.fnc":{"source":"apache","extensions":["fnc"]},"application/vnd.frogans.ltf":{"source":"apache","extensions":["ltf"]},"application/vnd.fsc.weblaunch":{"source":"iana","extensions":["fsc"]},"application/vnd.fujifilm.fb.docuworks":{"source":"iana"},"application/vnd.fujifilm.fb.docuworks.binder":{"source":"iana"},"application/vnd.fujifilm.fb.docuworks.container":{"source":"iana"},"application/vnd.fujifilm.fb.jfi+xml":{"source":"iana","compressible":true},"application/vnd.fujitsu.oasys":{"source":"iana","extensions":["oas"]},"application/vnd.fujitsu.oasys2":{"source":"iana","extensions":["oa2"]},"application/vnd.fujitsu.oasys3":{"source":"iana","extensions":["oa3"]},"application/vnd.fujitsu.oasysgp":{"source":"iana","extensions":["fg5"]},"application/vnd.fujitsu.oasysprs":{"source":"iana","extensions":["bh2"]},"application/vnd.fujixerox.art-ex":{"source":"iana"},"application/vnd.fujixerox.art4":{"source":"iana"},"application/vnd.fujixerox.ddd":{"source":"iana","extensions":["ddd"]},"application/vnd.fujixerox.docuworks":{"source":"iana","extensions":["xdw"]},"application/vnd.fujixerox.docuworks.binder":{"source":"iana","extensions":["xbd"]},"application/vnd.fujixerox.docuworks.container":{"source":"iana"},"application/vnd.fujixerox.hbpl":{"source":"iana"},"application/vnd.fut-misnet":{"source":"iana"},"application/vnd.futoin+cbor":{"source":"iana"},"application/vnd.futoin+json":{"source":"iana","compressible":true},"application/vnd.fuzzysheet":{"source":"iana","extensions":["fzs"]},"application/vnd.ga4gh.passport+jwt":{"source":"iana"},"application/vnd.genomatix.tuxedo":{"source":"iana","extensions":["txd"]},"application/vnd.genozip":{"source":"iana"},"application/vnd.gentics.grd+json":{"source":"iana","compressible":true},"application/vnd.gentoo.catmetadata+xml":{"source":"iana","compressible":true},"application/vnd.gentoo.ebuild":{"source":"iana"},"application/vnd.gentoo.eclass":{"source":"iana"},"application/vnd.gentoo.gpkg":{"source":"iana"},"application/vnd.gentoo.manifest":{"source":"iana"},"application/vnd.gentoo.pkgmetadata+xml":{"source":"iana","compressible":true},"application/vnd.gentoo.xpak":{"source":"iana"},"application/vnd.geo+json":{"source":"apache","compressible":true},"application/vnd.geocube+xml":{"source":"apache","compressible":true},"application/vnd.geogebra.file":{"source":"iana","extensions":["ggb"]},"application/vnd.geogebra.pinboard":{"source":"iana"},"application/vnd.geogebra.slides":{"source":"iana","extensions":["ggs"]},"application/vnd.geogebra.tool":{"source":"iana","extensions":["ggt"]},"application/vnd.geometry-explorer":{"source":"iana","extensions":["gex","gre"]},"application/vnd.geonext":{"source":"iana","extensions":["gxt"]},"application/vnd.geoplan":{"source":"iana","extensions":["g2w"]},"application/vnd.geospace":{"source":"iana","extensions":["g3w"]},"application/vnd.gerber":{"source":"iana"},"application/vnd.globalplatform.card-content-mgt":{"source":"iana"},"application/vnd.globalplatform.card-content-mgt-response":{"source":"iana"},"application/vnd.gmx":{"source":"iana","extensions":["gmx"]},"application/vnd.gnu.taler.exchange+json":{"source":"iana","compressible":true},"application/vnd.gnu.taler.merchant+json":{"source":"iana","compressible":true},"application/vnd.google-apps.audio":{},"application/vnd.google-apps.document":{"compressible":false,"extensions":["gdoc"]},"application/vnd.google-apps.drawing":{"compressible":false,"extensions":["gdraw"]},"application/vnd.google-apps.drive-sdk":{"compressible":false},"application/vnd.google-apps.file":{},"application/vnd.google-apps.folder":{"compressible":false},"application/vnd.google-apps.form":{"compressible":false,"extensions":["gform"]},"application/vnd.google-apps.fusiontable":{},"application/vnd.google-apps.jam":{"compressible":false,"extensions":["gjam"]},"application/vnd.google-apps.mail-layout":{},"application/vnd.google-apps.map":{"compressible":false,"extensions":["gmap"]},"application/vnd.google-apps.photo":{},"application/vnd.google-apps.presentation":{"compressible":false,"extensions":["gslides"]},"application/vnd.google-apps.script":{"compressible":false,"extensions":["gscript"]},"application/vnd.google-apps.shortcut":{},"application/vnd.google-apps.site":{"compressible":false,"extensions":["gsite"]},"application/vnd.google-apps.spreadsheet":{"compressible":false,"extensions":["gsheet"]},"application/vnd.google-apps.unknown":{},"application/vnd.google-apps.video":{},"application/vnd.google-earth.kml+xml":{"source":"iana","compressible":true,"extensions":["kml"]},"application/vnd.google-earth.kmz":{"source":"iana","compressible":false,"extensions":["kmz"]},"application/vnd.gov.sk.e-form+xml":{"source":"apache","compressible":true},"application/vnd.gov.sk.e-form+zip":{"source":"iana","compressible":false},"application/vnd.gov.sk.xmldatacontainer+xml":{"source":"iana","compressible":true,"extensions":["xdcf"]},"application/vnd.gpxsee.map+xml":{"source":"iana","compressible":true},"application/vnd.grafeq":{"source":"iana","extensions":["gqf","gqs"]},"application/vnd.gridmp":{"source":"iana"},"application/vnd.groove-account":{"source":"iana","extensions":["gac"]},"application/vnd.groove-help":{"source":"iana","extensions":["ghf"]},"application/vnd.groove-identity-message":{"source":"iana","extensions":["gim"]},"application/vnd.groove-injector":{"source":"iana","extensions":["grv"]},"application/vnd.groove-tool-message":{"source":"iana","extensions":["gtm"]},"application/vnd.groove-tool-template":{"source":"iana","extensions":["tpl"]},"application/vnd.groove-vcard":{"source":"iana","extensions":["vcg"]},"application/vnd.hal+json":{"source":"iana","compressible":true},"application/vnd.hal+xml":{"source":"iana","compressible":true,"extensions":["hal"]},"application/vnd.handheld-entertainment+xml":{"source":"iana","compressible":true,"extensions":["zmm"]},"application/vnd.hbci":{"source":"iana","extensions":["hbci"]},"application/vnd.hc+json":{"source":"iana","compressible":true},"application/vnd.hcl-bireports":{"source":"iana"},"application/vnd.hdt":{"source":"iana"},"application/vnd.heroku+json":{"source":"iana","compressible":true},"application/vnd.hhe.lesson-player":{"source":"iana","extensions":["les"]},"application/vnd.hp-hpgl":{"source":"iana","extensions":["hpgl"]},"application/vnd.hp-hpid":{"source":"iana","extensions":["hpid"]},"application/vnd.hp-hps":{"source":"iana","extensions":["hps"]},"application/vnd.hp-jlyt":{"source":"iana","extensions":["jlt"]},"application/vnd.hp-pcl":{"source":"iana","extensions":["pcl"]},"application/vnd.hp-pclxl":{"source":"iana","extensions":["pclxl"]},"application/vnd.hsl":{"source":"iana"},"application/vnd.httphone":{"source":"iana"},"application/vnd.hydrostatix.sof-data":{"source":"iana","extensions":["sfd-hdstx"]},"application/vnd.hyper+json":{"source":"iana","compressible":true},"application/vnd.hyper-item+json":{"source":"iana","compressible":true},"application/vnd.hyperdrive+json":{"source":"iana","compressible":true},"application/vnd.hzn-3d-crossword":{"source":"iana"},"application/vnd.ibm.afplinedata":{"source":"apache"},"application/vnd.ibm.electronic-media":{"source":"iana"},"application/vnd.ibm.minipay":{"source":"iana","extensions":["mpy"]},"application/vnd.ibm.modcap":{"source":"apache","extensions":["afp","listafp","list3820"]},"application/vnd.ibm.rights-management":{"source":"iana","extensions":["irm"]},"application/vnd.ibm.secure-container":{"source":"iana","extensions":["sc"]},"application/vnd.iccprofile":{"source":"iana","extensions":["icc","icm"]},"application/vnd.ieee.1905":{"source":"iana"},"application/vnd.igloader":{"source":"iana","extensions":["igl"]},"application/vnd.imagemeter.folder+zip":{"source":"iana","compressible":false},"application/vnd.imagemeter.image+zip":{"source":"iana","compressible":false},"application/vnd.immervision-ivp":{"source":"iana","extensions":["ivp"]},"application/vnd.immervision-ivu":{"source":"iana","extensions":["ivu"]},"application/vnd.ims.imsccv1p1":{"source":"iana"},"application/vnd.ims.imsccv1p2":{"source":"iana"},"application/vnd.ims.imsccv1p3":{"source":"iana"},"application/vnd.ims.lis.v2.result+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolconsumerprofile+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolproxy+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolproxy.id+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolsettings+json":{"source":"iana","compressible":true},"application/vnd.ims.lti.v2.toolsettings.simple+json":{"source":"iana","compressible":true},"application/vnd.informedcontrol.rms+xml":{"source":"iana","compressible":true},"application/vnd.informix-visionary":{"source":"apache"},"application/vnd.infotech.project":{"source":"iana"},"application/vnd.infotech.project+xml":{"source":"iana","compressible":true},"application/vnd.innopath.wamp.notification":{"source":"iana"},"application/vnd.insors.igm":{"source":"iana","extensions":["igm"]},"application/vnd.intercon.formnet":{"source":"iana","extensions":["xpw","xpx"]},"application/vnd.intergeo":{"source":"iana","extensions":["i2g"]},"application/vnd.intertrust.digibox":{"source":"iana"},"application/vnd.intertrust.nncp":{"source":"iana"},"application/vnd.intu.qbo":{"source":"iana","extensions":["qbo"]},"application/vnd.intu.qfx":{"source":"iana","extensions":["qfx"]},"application/vnd.ipfs.ipns-record":{"source":"iana"},"application/vnd.ipld.car":{"source":"iana"},"application/vnd.ipld.dag-cbor":{"source":"iana"},"application/vnd.ipld.dag-json":{"source":"iana"},"application/vnd.ipld.raw":{"source":"iana"},"application/vnd.iptc.g2.catalogitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.conceptitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.knowledgeitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.newsitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.newsmessage+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.packageitem+xml":{"source":"iana","compressible":true},"application/vnd.iptc.g2.planningitem+xml":{"source":"iana","compressible":true},"application/vnd.ipunplugged.rcprofile":{"source":"iana","extensions":["rcprofile"]},"application/vnd.irepository.package+xml":{"source":"iana","compressible":true,"extensions":["irp"]},"application/vnd.is-xpr":{"source":"iana","extensions":["xpr"]},"application/vnd.isac.fcs":{"source":"iana","extensions":["fcs"]},"application/vnd.iso11783-10+zip":{"source":"iana","compressible":false},"application/vnd.jam":{"source":"iana","extensions":["jam"]},"application/vnd.japannet-directory-service":{"source":"iana"},"application/vnd.japannet-jpnstore-wakeup":{"source":"iana"},"application/vnd.japannet-payment-wakeup":{"source":"iana"},"application/vnd.japannet-registration":{"source":"iana"},"application/vnd.japannet-registration-wakeup":{"source":"iana"},"application/vnd.japannet-setstore-wakeup":{"source":"iana"},"application/vnd.japannet-verification":{"source":"iana"},"application/vnd.japannet-verification-wakeup":{"source":"iana"},"application/vnd.jcp.javame.midlet-rms":{"source":"iana","extensions":["rms"]},"application/vnd.jisp":{"source":"iana","extensions":["jisp"]},"application/vnd.joost.joda-archive":{"source":"iana","extensions":["joda"]},"application/vnd.jsk.isdn-ngn":{"source":"iana"},"application/vnd.kahootz":{"source":"iana","extensions":["ktz","ktr"]},"application/vnd.kde.karbon":{"source":"iana","extensions":["karbon"]},"application/vnd.kde.kchart":{"source":"iana","extensions":["chrt"]},"application/vnd.kde.kformula":{"source":"iana","extensions":["kfo"]},"application/vnd.kde.kivio":{"source":"iana","extensions":["flw"]},"application/vnd.kde.kontour":{"source":"iana","extensions":["kon"]},"application/vnd.kde.kpresenter":{"source":"iana","extensions":["kpr","kpt"]},"application/vnd.kde.kspread":{"source":"iana","extensions":["ksp"]},"application/vnd.kde.kword":{"source":"iana","extensions":["kwd","kwt"]},"application/vnd.kdl":{"source":"iana"},"application/vnd.kenameaapp":{"source":"iana","extensions":["htke"]},"application/vnd.keyman.kmp+zip":{"source":"iana","compressible":false},"application/vnd.keyman.kmx":{"source":"iana"},"application/vnd.kidspiration":{"source":"iana","extensions":["kia"]},"application/vnd.kinar":{"source":"iana","extensions":["kne","knp"]},"application/vnd.koan":{"source":"iana","extensions":["skp","skd","skt","skm"]},"application/vnd.kodak-descriptor":{"source":"iana","extensions":["sse"]},"application/vnd.las":{"source":"iana"},"application/vnd.las.las+json":{"source":"iana","compressible":true},"application/vnd.las.las+xml":{"source":"iana","compressible":true,"extensions":["lasxml"]},"application/vnd.laszip":{"source":"iana"},"application/vnd.ldev.productlicensing":{"source":"iana"},"application/vnd.leap+json":{"source":"iana","compressible":true},"application/vnd.liberty-request+xml":{"source":"iana","compressible":true},"application/vnd.llamagraphics.life-balance.desktop":{"source":"iana","extensions":["lbd"]},"application/vnd.llamagraphics.life-balance.exchange+xml":{"source":"iana","compressible":true,"extensions":["lbe"]},"application/vnd.logipipe.circuit+zip":{"source":"iana","compressible":false},"application/vnd.loom":{"source":"iana"},"application/vnd.lotus-1-2-3":{"source":"iana","extensions":["123"]},"application/vnd.lotus-approach":{"source":"iana","extensions":["apr"]},"application/vnd.lotus-freelance":{"source":"iana","extensions":["pre"]},"application/vnd.lotus-notes":{"source":"iana","extensions":["nsf"]},"application/vnd.lotus-organizer":{"source":"iana","extensions":["org"]},"application/vnd.lotus-screencam":{"source":"iana","extensions":["scm"]},"application/vnd.lotus-wordpro":{"source":"iana","extensions":["lwp"]},"application/vnd.macports.portpkg":{"source":"iana","extensions":["portpkg"]},"application/vnd.mapbox-vector-tile":{"source":"iana","extensions":["mvt"]},"application/vnd.marlin.drm.actiontoken+xml":{"source":"iana","compressible":true},"application/vnd.marlin.drm.conftoken+xml":{"source":"iana","compressible":true},"application/vnd.marlin.drm.license+xml":{"source":"iana","compressible":true},"application/vnd.marlin.drm.mdcf":{"source":"iana"},"application/vnd.mason+json":{"source":"iana","compressible":true},"application/vnd.maxar.archive.3tz+zip":{"source":"iana","compressible":false},"application/vnd.maxmind.maxmind-db":{"source":"iana"},"application/vnd.mcd":{"source":"iana","extensions":["mcd"]},"application/vnd.mdl":{"source":"iana"},"application/vnd.mdl-mbsdf":{"source":"iana"},"application/vnd.medcalcdata":{"source":"iana","extensions":["mc1"]},"application/vnd.mediastation.cdkey":{"source":"iana","extensions":["cdkey"]},"application/vnd.medicalholodeck.recordxr":{"source":"iana"},"application/vnd.meridian-slingshot":{"source":"iana"},"application/vnd.mermaid":{"source":"iana"},"application/vnd.mfer":{"source":"iana","extensions":["mwf"]},"application/vnd.mfmp":{"source":"iana","extensions":["mfm"]},"application/vnd.micro+json":{"source":"iana","compressible":true},"application/vnd.micrografx.flo":{"source":"iana","extensions":["flo"]},"application/vnd.micrografx.igx":{"source":"iana","extensions":["igx"]},"application/vnd.microsoft.portable-executable":{"source":"iana"},"application/vnd.microsoft.windows.thumbnail-cache":{"source":"iana"},"application/vnd.miele+json":{"source":"iana","compressible":true},"application/vnd.mif":{"source":"iana","extensions":["mif"]},"application/vnd.minisoft-hp3000-save":{"source":"iana"},"application/vnd.mitsubishi.misty-guard.trustweb":{"source":"iana"},"application/vnd.mobius.daf":{"source":"iana","extensions":["daf"]},"application/vnd.mobius.dis":{"source":"iana","extensions":["dis"]},"application/vnd.mobius.mbk":{"source":"iana","extensions":["mbk"]},"application/vnd.mobius.mqy":{"source":"iana","extensions":["mqy"]},"application/vnd.mobius.msl":{"source":"iana","extensions":["msl"]},"application/vnd.mobius.plc":{"source":"iana","extensions":["plc"]},"application/vnd.mobius.txf":{"source":"iana","extensions":["txf"]},"application/vnd.modl":{"source":"iana"},"application/vnd.mophun.application":{"source":"iana","extensions":["mpn"]},"application/vnd.mophun.certificate":{"source":"iana","extensions":["mpc"]},"application/vnd.motorola.flexsuite":{"source":"iana"},"application/vnd.motorola.flexsuite.adsi":{"source":"iana"},"application/vnd.motorola.flexsuite.fis":{"source":"iana"},"application/vnd.motorola.flexsuite.gotap":{"source":"iana"},"application/vnd.motorola.flexsuite.kmr":{"source":"iana"},"application/vnd.motorola.flexsuite.ttc":{"source":"iana"},"application/vnd.motorola.flexsuite.wem":{"source":"iana"},"application/vnd.motorola.iprm":{"source":"iana"},"application/vnd.mozilla.xul+xml":{"source":"iana","compressible":true,"extensions":["xul"]},"application/vnd.ms-3mfdocument":{"source":"iana"},"application/vnd.ms-artgalry":{"source":"iana","extensions":["cil"]},"application/vnd.ms-asf":{"source":"iana"},"application/vnd.ms-cab-compressed":{"source":"iana","extensions":["cab"]},"application/vnd.ms-color.iccprofile":{"source":"apache"},"application/vnd.ms-excel":{"source":"iana","compressible":false,"extensions":["xls","xlm","xla","xlc","xlt","xlw"]},"application/vnd.ms-excel.addin.macroenabled.12":{"source":"iana","extensions":["xlam"]},"application/vnd.ms-excel.sheet.binary.macroenabled.12":{"source":"iana","extensions":["xlsb"]},"application/vnd.ms-excel.sheet.macroenabled.12":{"source":"iana","extensions":["xlsm"]},"application/vnd.ms-excel.template.macroenabled.12":{"source":"iana","extensions":["xltm"]},"application/vnd.ms-fontobject":{"source":"iana","compressible":true,"extensions":["eot"]},"application/vnd.ms-htmlhelp":{"source":"iana","extensions":["chm"]},"application/vnd.ms-ims":{"source":"iana","extensions":["ims"]},"application/vnd.ms-lrm":{"source":"iana","extensions":["lrm"]},"application/vnd.ms-office.activex+xml":{"source":"iana","compressible":true},"application/vnd.ms-officetheme":{"source":"iana","extensions":["thmx"]},"application/vnd.ms-opentype":{"source":"apache","compressible":true},"application/vnd.ms-outlook":{"compressible":false,"extensions":["msg"]},"application/vnd.ms-package.obfuscated-opentype":{"source":"apache"},"application/vnd.ms-pki.seccat":{"source":"apache","extensions":["cat"]},"application/vnd.ms-pki.stl":{"source":"apache","extensions":["stl"]},"application/vnd.ms-playready.initiator+xml":{"source":"iana","compressible":true},"application/vnd.ms-powerpoint":{"source":"iana","compressible":false,"extensions":["ppt","pps","pot"]},"application/vnd.ms-powerpoint.addin.macroenabled.12":{"source":"iana","extensions":["ppam"]},"application/vnd.ms-powerpoint.presentation.macroenabled.12":{"source":"iana","extensions":["pptm"]},"application/vnd.ms-powerpoint.slide.macroenabled.12":{"source":"iana","extensions":["sldm"]},"application/vnd.ms-powerpoint.slideshow.macroenabled.12":{"source":"iana","extensions":["ppsm"]},"application/vnd.ms-powerpoint.template.macroenabled.12":{"source":"iana","extensions":["potm"]},"application/vnd.ms-printdevicecapabilities+xml":{"source":"iana","compressible":true},"application/vnd.ms-printing.printticket+xml":{"source":"apache","compressible":true},"application/vnd.ms-printschematicket+xml":{"source":"iana","compressible":true},"application/vnd.ms-project":{"source":"iana","extensions":["mpp","mpt"]},"application/vnd.ms-tnef":{"source":"iana"},"application/vnd.ms-visio.viewer":{"extensions":["vdx"]},"application/vnd.ms-windows.devicepairing":{"source":"iana"},"application/vnd.ms-windows.nwprinting.oob":{"source":"iana"},"application/vnd.ms-windows.printerpairing":{"source":"iana"},"application/vnd.ms-windows.wsd.oob":{"source":"iana"},"application/vnd.ms-wmdrm.lic-chlg-req":{"source":"iana"},"application/vnd.ms-wmdrm.lic-resp":{"source":"iana"},"application/vnd.ms-wmdrm.meter-chlg-req":{"source":"iana"},"application/vnd.ms-wmdrm.meter-resp":{"source":"iana"},"application/vnd.ms-word.document.macroenabled.12":{"source":"iana","extensions":["docm"]},"application/vnd.ms-word.template.macroenabled.12":{"source":"iana","extensions":["dotm"]},"application/vnd.ms-works":{"source":"iana","extensions":["wps","wks","wcm","wdb"]},"application/vnd.ms-wpl":{"source":"iana","extensions":["wpl"]},"application/vnd.ms-xpsdocument":{"source":"iana","compressible":false,"extensions":["xps"]},"application/vnd.msa-disk-image":{"source":"iana"},"application/vnd.mseq":{"source":"iana","extensions":["mseq"]},"application/vnd.msgpack":{"source":"iana"},"application/vnd.msign":{"source":"iana"},"application/vnd.multiad.creator":{"source":"iana"},"application/vnd.multiad.creator.cif":{"source":"iana"},"application/vnd.music-niff":{"source":"iana"},"application/vnd.musician":{"source":"iana","extensions":["mus"]},"application/vnd.muvee.style":{"source":"iana","extensions":["msty"]},"application/vnd.mynfc":{"source":"iana","extensions":["taglet"]},"application/vnd.nacamar.ybrid+json":{"source":"iana","compressible":true},"application/vnd.nato.bindingdataobject+cbor":{"source":"iana"},"application/vnd.nato.bindingdataobject+json":{"source":"iana","compressible":true},"application/vnd.nato.bindingdataobject+xml":{"source":"iana","compressible":true,"extensions":["bdo"]},"application/vnd.nato.openxmlformats-package.iepd+zip":{"source":"iana","compressible":false},"application/vnd.ncd.control":{"source":"iana"},"application/vnd.ncd.reference":{"source":"iana"},"application/vnd.nearst.inv+json":{"source":"iana","compressible":true},"application/vnd.nebumind.line":{"source":"iana"},"application/vnd.nervana":{"source":"iana"},"application/vnd.netfpx":{"source":"iana"},"application/vnd.neurolanguage.nlu":{"source":"iana","extensions":["nlu"]},"application/vnd.nimn":{"source":"iana"},"application/vnd.nintendo.nitro.rom":{"source":"iana"},"application/vnd.nintendo.snes.rom":{"source":"iana"},"application/vnd.nitf":{"source":"iana","extensions":["ntf","nitf"]},"application/vnd.noblenet-directory":{"source":"iana","extensions":["nnd"]},"application/vnd.noblenet-sealer":{"source":"iana","extensions":["nns"]},"application/vnd.noblenet-web":{"source":"iana","extensions":["nnw"]},"application/vnd.nokia.catalogs":{"source":"iana"},"application/vnd.nokia.conml+wbxml":{"source":"iana"},"application/vnd.nokia.conml+xml":{"source":"iana","compressible":true},"application/vnd.nokia.iptv.config+xml":{"source":"iana","compressible":true},"application/vnd.nokia.isds-radio-presets":{"source":"iana"},"application/vnd.nokia.landmark+wbxml":{"source":"iana"},"application/vnd.nokia.landmark+xml":{"source":"iana","compressible":true},"application/vnd.nokia.landmarkcollection+xml":{"source":"iana","compressible":true},"application/vnd.nokia.n-gage.ac+xml":{"source":"iana","compressible":true,"extensions":["ac"]},"application/vnd.nokia.n-gage.data":{"source":"iana","extensions":["ngdat"]},"application/vnd.nokia.n-gage.symbian.install":{"source":"apache","extensions":["n-gage"]},"application/vnd.nokia.ncd":{"source":"iana"},"application/vnd.nokia.pcd+wbxml":{"source":"iana"},"application/vnd.nokia.pcd+xml":{"source":"iana","compressible":true},"application/vnd.nokia.radio-preset":{"source":"iana","extensions":["rpst"]},"application/vnd.nokia.radio-presets":{"source":"iana","extensions":["rpss"]},"application/vnd.novadigm.edm":{"source":"iana","extensions":["edm"]},"application/vnd.novadigm.edx":{"source":"iana","extensions":["edx"]},"application/vnd.novadigm.ext":{"source":"iana","extensions":["ext"]},"application/vnd.ntt-local.content-share":{"source":"iana"},"application/vnd.ntt-local.file-transfer":{"source":"iana"},"application/vnd.ntt-local.ogw_remote-access":{"source":"iana"},"application/vnd.ntt-local.sip-ta_remote":{"source":"iana"},"application/vnd.ntt-local.sip-ta_tcp_stream":{"source":"iana"},"application/vnd.oai.workflows":{"source":"iana"},"application/vnd.oai.workflows+json":{"source":"iana","compressible":true},"application/vnd.oai.workflows+yaml":{"source":"iana"},"application/vnd.oasis.opendocument.base":{"source":"iana"},"application/vnd.oasis.opendocument.chart":{"source":"iana","extensions":["odc"]},"application/vnd.oasis.opendocument.chart-template":{"source":"iana","extensions":["otc"]},"application/vnd.oasis.opendocument.database":{"source":"apache","extensions":["odb"]},"application/vnd.oasis.opendocument.formula":{"source":"iana","extensions":["odf"]},"application/vnd.oasis.opendocument.formula-template":{"source":"iana","extensions":["odft"]},"application/vnd.oasis.opendocument.graphics":{"source":"iana","compressible":false,"extensions":["odg"]},"application/vnd.oasis.opendocument.graphics-template":{"source":"iana","extensions":["otg"]},"application/vnd.oasis.opendocument.image":{"source":"iana","extensions":["odi"]},"application/vnd.oasis.opendocument.image-template":{"source":"iana","extensions":["oti"]},"application/vnd.oasis.opendocument.presentation":{"source":"iana","compressible":false,"extensions":["odp"]},"application/vnd.oasis.opendocument.presentation-template":{"source":"iana","extensions":["otp"]},"application/vnd.oasis.opendocument.spreadsheet":{"source":"iana","compressible":false,"extensions":["ods"]},"application/vnd.oasis.opendocument.spreadsheet-template":{"source":"iana","extensions":["ots"]},"application/vnd.oasis.opendocument.text":{"source":"iana","compressible":false,"extensions":["odt"]},"application/vnd.oasis.opendocument.text-master":{"source":"iana","extensions":["odm"]},"application/vnd.oasis.opendocument.text-master-template":{"source":"iana"},"application/vnd.oasis.opendocument.text-template":{"source":"iana","extensions":["ott"]},"application/vnd.oasis.opendocument.text-web":{"source":"iana","extensions":["oth"]},"application/vnd.obn":{"source":"iana"},"application/vnd.ocf+cbor":{"source":"iana"},"application/vnd.oci.image.manifest.v1+json":{"source":"iana","compressible":true},"application/vnd.oftn.l10n+json":{"source":"iana","compressible":true},"application/vnd.oipf.contentaccessdownload+xml":{"source":"iana","compressible":true},"application/vnd.oipf.contentaccessstreaming+xml":{"source":"iana","compressible":true},"application/vnd.oipf.cspg-hexbinary":{"source":"iana"},"application/vnd.oipf.dae.svg+xml":{"source":"iana","compressible":true},"application/vnd.oipf.dae.xhtml+xml":{"source":"iana","compressible":true},"application/vnd.oipf.mippvcontrolmessage+xml":{"source":"iana","compressible":true},"application/vnd.oipf.pae.gem":{"source":"iana"},"application/vnd.oipf.spdiscovery+xml":{"source":"iana","compressible":true},"application/vnd.oipf.spdlist+xml":{"source":"iana","compressible":true},"application/vnd.oipf.ueprofile+xml":{"source":"iana","compressible":true},"application/vnd.oipf.userprofile+xml":{"source":"iana","compressible":true},"application/vnd.olpc-sugar":{"source":"iana","extensions":["xo"]},"application/vnd.oma-scws-config":{"source":"iana"},"application/vnd.oma-scws-http-request":{"source":"iana"},"application/vnd.oma-scws-http-response":{"source":"iana"},"application/vnd.oma.bcast.associated-procedure-parameter+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.drm-trigger+xml":{"source":"apache","compressible":true},"application/vnd.oma.bcast.imd+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.ltkm":{"source":"iana"},"application/vnd.oma.bcast.notification+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.provisioningtrigger":{"source":"iana"},"application/vnd.oma.bcast.sgboot":{"source":"iana"},"application/vnd.oma.bcast.sgdd+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.sgdu":{"source":"iana"},"application/vnd.oma.bcast.simple-symbol-container":{"source":"iana"},"application/vnd.oma.bcast.smartcard-trigger+xml":{"source":"apache","compressible":true},"application/vnd.oma.bcast.sprov+xml":{"source":"iana","compressible":true},"application/vnd.oma.bcast.stkm":{"source":"iana"},"application/vnd.oma.cab-address-book+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-feature-handler+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-pcc+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-subs-invite+xml":{"source":"iana","compressible":true},"application/vnd.oma.cab-user-prefs+xml":{"source":"iana","compressible":true},"application/vnd.oma.dcd":{"source":"iana"},"application/vnd.oma.dcdc":{"source":"iana"},"application/vnd.oma.dd2+xml":{"source":"iana","compressible":true,"extensions":["dd2"]},"application/vnd.oma.drm.risd+xml":{"source":"iana","compressible":true},"application/vnd.oma.group-usage-list+xml":{"source":"iana","compressible":true},"application/vnd.oma.lwm2m+cbor":{"source":"iana"},"application/vnd.oma.lwm2m+json":{"source":"iana","compressible":true},"application/vnd.oma.lwm2m+tlv":{"source":"iana"},"application/vnd.oma.pal+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.detailed-progress-report+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.final-report+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.groups+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.invocation-descriptor+xml":{"source":"iana","compressible":true},"application/vnd.oma.poc.optimized-progress-report+xml":{"source":"iana","compressible":true},"application/vnd.oma.push":{"source":"iana"},"application/vnd.oma.scidm.messages+xml":{"source":"iana","compressible":true},"application/vnd.oma.xcap-directory+xml":{"source":"iana","compressible":true},"application/vnd.omads-email+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.omads-file+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.omads-folder+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.omaloc-supl-init":{"source":"iana"},"application/vnd.onepager":{"source":"iana"},"application/vnd.onepagertamp":{"source":"iana"},"application/vnd.onepagertamx":{"source":"iana"},"application/vnd.onepagertat":{"source":"iana"},"application/vnd.onepagertatp":{"source":"iana"},"application/vnd.onepagertatx":{"source":"iana"},"application/vnd.onvif.metadata":{"source":"iana"},"application/vnd.openblox.game+xml":{"source":"iana","compressible":true,"extensions":["obgx"]},"application/vnd.openblox.game-binary":{"source":"iana"},"application/vnd.openeye.oeb":{"source":"iana"},"application/vnd.openofficeorg.extension":{"source":"apache","extensions":["oxt"]},"application/vnd.openstreetmap.data+xml":{"source":"iana","compressible":true,"extensions":["osm"]},"application/vnd.opentimestamps.ots":{"source":"iana"},"application/vnd.openvpi.dspx+json":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.custom-properties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.customxmlproperties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawing+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.chart+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.extended-properties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.comments+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.presentation":{"source":"iana","compressible":false,"extensions":["pptx"]},"application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.presprops+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slide":{"source":"iana","extensions":["sldx"]},"application/vnd.openxmlformats-officedocument.presentationml.slide+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slideshow":{"source":"iana","extensions":["ppsx"]},"application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.tags+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.template":{"source":"iana","extensions":["potx"]},"application/vnd.openxmlformats-officedocument.presentationml.template.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":{"source":"iana","compressible":false,"extensions":["xlsx"]},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.template":{"source":"iana","extensions":["xltx"]},"application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.theme+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.themeoverride+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.vmldrawing":{"source":"iana"},"application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.document":{"source":"iana","compressible":false,"extensions":["docx"]},"application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.template":{"source":"iana","extensions":["dotx"]},"application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-package.core-properties+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml":{"source":"iana","compressible":true},"application/vnd.openxmlformats-package.relationships+xml":{"source":"iana","compressible":true},"application/vnd.oracle.resource+json":{"source":"iana","compressible":true},"application/vnd.orange.indata":{"source":"iana"},"application/vnd.osa.netdeploy":{"source":"iana"},"application/vnd.osgeo.mapguide.package":{"source":"iana","extensions":["mgp"]},"application/vnd.osgi.bundle":{"source":"iana"},"application/vnd.osgi.dp":{"source":"iana","extensions":["dp"]},"application/vnd.osgi.subsystem":{"source":"iana","extensions":["esa"]},"application/vnd.otps.ct-kip+xml":{"source":"iana","compressible":true},"application/vnd.oxli.countgraph":{"source":"iana"},"application/vnd.pagerduty+json":{"source":"iana","compressible":true},"application/vnd.palm":{"source":"iana","extensions":["pdb","pqa","oprc"]},"application/vnd.panoply":{"source":"iana"},"application/vnd.paos.xml":{"source":"iana"},"application/vnd.patentdive":{"source":"iana"},"application/vnd.patientecommsdoc":{"source":"iana"},"application/vnd.pawaafile":{"source":"iana","extensions":["paw"]},"application/vnd.pcos":{"source":"iana"},"application/vnd.pg.format":{"source":"iana","extensions":["str"]},"application/vnd.pg.osasli":{"source":"iana","extensions":["ei6"]},"application/vnd.piaccess.application-licence":{"source":"iana"},"application/vnd.picsel":{"source":"iana","extensions":["efif"]},"application/vnd.pmi.widget":{"source":"iana","extensions":["wg"]},"application/vnd.poc.group-advertisement+xml":{"source":"iana","compressible":true},"application/vnd.pocketlearn":{"source":"iana","extensions":["plf"]},"application/vnd.powerbuilder6":{"source":"iana","extensions":["pbd"]},"application/vnd.powerbuilder6-s":{"source":"iana"},"application/vnd.powerbuilder7":{"source":"iana"},"application/vnd.powerbuilder7-s":{"source":"iana"},"application/vnd.powerbuilder75":{"source":"iana"},"application/vnd.powerbuilder75-s":{"source":"iana"},"application/vnd.preminet":{"source":"iana"},"application/vnd.previewsystems.box":{"source":"iana","extensions":["box"]},"application/vnd.procrate.brushset":{"extensions":["brushset"]},"application/vnd.procreate.brush":{"extensions":["brush"]},"application/vnd.procreate.dream":{"extensions":["drm"]},"application/vnd.proteus.magazine":{"source":"iana","extensions":["mgz"]},"application/vnd.psfs":{"source":"iana"},"application/vnd.pt.mundusmundi":{"source":"iana"},"application/vnd.publishare-delta-tree":{"source":"iana","extensions":["qps"]},"application/vnd.pvi.ptid1":{"source":"iana","extensions":["ptid"]},"application/vnd.pwg-multiplexed":{"source":"iana"},"application/vnd.pwg-xhtml-print+xml":{"source":"iana","compressible":true,"extensions":["xhtm"]},"application/vnd.qualcomm.brew-app-res":{"source":"iana"},"application/vnd.quarantainenet":{"source":"iana"},"application/vnd.quark.quarkxpress":{"source":"iana","extensions":["qxd","qxt","qwd","qwt","qxl","qxb"]},"application/vnd.quobject-quoxdocument":{"source":"iana"},"application/vnd.radisys.moml+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-conf+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-conn+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-dialog+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-audit-stream+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-conf+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-base+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-fax-detect+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-fax-sendrecv+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-group+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-speech+xml":{"source":"iana","compressible":true},"application/vnd.radisys.msml-dialog-transform+xml":{"source":"iana","compressible":true},"application/vnd.rainstor.data":{"source":"iana"},"application/vnd.rapid":{"source":"iana"},"application/vnd.rar":{"source":"iana","extensions":["rar"]},"application/vnd.realvnc.bed":{"source":"iana","extensions":["bed"]},"application/vnd.recordare.musicxml":{"source":"iana","extensions":["mxl"]},"application/vnd.recordare.musicxml+xml":{"source":"iana","compressible":true,"extensions":["musicxml"]},"application/vnd.relpipe":{"source":"iana"},"application/vnd.renlearn.rlprint":{"source":"iana"},"application/vnd.resilient.logic":{"source":"iana"},"application/vnd.restful+json":{"source":"iana","compressible":true},"application/vnd.rig.cryptonote":{"source":"iana","extensions":["cryptonote"]},"application/vnd.rim.cod":{"source":"apache","extensions":["cod"]},"application/vnd.rn-realmedia":{"source":"apache","extensions":["rm"]},"application/vnd.rn-realmedia-vbr":{"source":"apache","extensions":["rmvb"]},"application/vnd.route66.link66+xml":{"source":"iana","compressible":true,"extensions":["link66"]},"application/vnd.rs-274x":{"source":"iana"},"application/vnd.ruckus.download":{"source":"iana"},"application/vnd.s3sms":{"source":"iana"},"application/vnd.sailingtracker.track":{"source":"iana","extensions":["st"]},"application/vnd.sar":{"source":"iana"},"application/vnd.sbm.cid":{"source":"iana"},"application/vnd.sbm.mid2":{"source":"iana"},"application/vnd.scribus":{"source":"iana"},"application/vnd.sealed.3df":{"source":"iana"},"application/vnd.sealed.csf":{"source":"iana"},"application/vnd.sealed.doc":{"source":"iana"},"application/vnd.sealed.eml":{"source":"iana"},"application/vnd.sealed.mht":{"source":"iana"},"application/vnd.sealed.net":{"source":"iana"},"application/vnd.sealed.ppt":{"source":"iana"},"application/vnd.sealed.tiff":{"source":"iana"},"application/vnd.sealed.xls":{"source":"iana"},"application/vnd.sealedmedia.softseal.html":{"source":"iana"},"application/vnd.sealedmedia.softseal.pdf":{"source":"iana"},"application/vnd.seemail":{"source":"iana","extensions":["see"]},"application/vnd.seis+json":{"source":"iana","compressible":true},"application/vnd.sema":{"source":"iana","extensions":["sema"]},"application/vnd.semd":{"source":"iana","extensions":["semd"]},"application/vnd.semf":{"source":"iana","extensions":["semf"]},"application/vnd.shade-save-file":{"source":"iana"},"application/vnd.shana.informed.formdata":{"source":"iana","extensions":["ifm"]},"application/vnd.shana.informed.formtemplate":{"source":"iana","extensions":["itp"]},"application/vnd.shana.informed.interchange":{"source":"iana","extensions":["iif"]},"application/vnd.shana.informed.package":{"source":"iana","extensions":["ipk"]},"application/vnd.shootproof+json":{"source":"iana","compressible":true},"application/vnd.shopkick+json":{"source":"iana","compressible":true},"application/vnd.shp":{"source":"iana"},"application/vnd.shx":{"source":"iana"},"application/vnd.sigrok.session":{"source":"iana"},"application/vnd.simtech-mindmapper":{"source":"iana","extensions":["twd","twds"]},"application/vnd.siren+json":{"source":"iana","compressible":true},"application/vnd.sketchometry":{"source":"iana"},"application/vnd.smaf":{"source":"iana","extensions":["mmf"]},"application/vnd.smart.notebook":{"source":"iana"},"application/vnd.smart.teacher":{"source":"iana","extensions":["teacher"]},"application/vnd.smintio.portals.archive":{"source":"iana"},"application/vnd.snesdev-page-table":{"source":"iana"},"application/vnd.software602.filler.form+xml":{"source":"iana","compressible":true,"extensions":["fo"]},"application/vnd.software602.filler.form-xml-zip":{"source":"iana"},"application/vnd.solent.sdkm+xml":{"source":"iana","compressible":true,"extensions":["sdkm","sdkd"]},"application/vnd.spotfire.dxp":{"source":"iana","extensions":["dxp"]},"application/vnd.spotfire.sfs":{"source":"iana","extensions":["sfs"]},"application/vnd.sqlite3":{"source":"iana"},"application/vnd.sss-cod":{"source":"iana"},"application/vnd.sss-dtf":{"source":"iana"},"application/vnd.sss-ntf":{"source":"iana"},"application/vnd.stardivision.calc":{"source":"apache","extensions":["sdc"]},"application/vnd.stardivision.draw":{"source":"apache","extensions":["sda"]},"application/vnd.stardivision.impress":{"source":"apache","extensions":["sdd"]},"application/vnd.stardivision.math":{"source":"apache","extensions":["smf"]},"application/vnd.stardivision.writer":{"source":"apache","extensions":["sdw","vor"]},"application/vnd.stardivision.writer-global":{"source":"apache","extensions":["sgl"]},"application/vnd.stepmania.package":{"source":"iana","extensions":["smzip"]},"application/vnd.stepmania.stepchart":{"source":"iana","extensions":["sm"]},"application/vnd.street-stream":{"source":"iana"},"application/vnd.sun.wadl+xml":{"source":"iana","compressible":true,"extensions":["wadl"]},"application/vnd.sun.xml.calc":{"source":"apache","extensions":["sxc"]},"application/vnd.sun.xml.calc.template":{"source":"apache","extensions":["stc"]},"application/vnd.sun.xml.draw":{"source":"apache","extensions":["sxd"]},"application/vnd.sun.xml.draw.template":{"source":"apache","extensions":["std"]},"application/vnd.sun.xml.impress":{"source":"apache","extensions":["sxi"]},"application/vnd.sun.xml.impress.template":{"source":"apache","extensions":["sti"]},"application/vnd.sun.xml.math":{"source":"apache","extensions":["sxm"]},"application/vnd.sun.xml.writer":{"source":"apache","extensions":["sxw"]},"application/vnd.sun.xml.writer.global":{"source":"apache","extensions":["sxg"]},"application/vnd.sun.xml.writer.template":{"source":"apache","extensions":["stw"]},"application/vnd.sus-calendar":{"source":"iana","extensions":["sus","susp"]},"application/vnd.svd":{"source":"iana","extensions":["svd"]},"application/vnd.swiftview-ics":{"source":"iana"},"application/vnd.sybyl.mol2":{"source":"iana"},"application/vnd.sycle+xml":{"source":"iana","compressible":true},"application/vnd.syft+json":{"source":"iana","compressible":true},"application/vnd.symbian.install":{"source":"apache","extensions":["sis","sisx"]},"application/vnd.syncml+xml":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["xsm"]},"application/vnd.syncml.dm+wbxml":{"source":"iana","charset":"UTF-8","extensions":["bdm"]},"application/vnd.syncml.dm+xml":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["xdm"]},"application/vnd.syncml.dm.notification":{"source":"iana"},"application/vnd.syncml.dmddf+wbxml":{"source":"iana"},"application/vnd.syncml.dmddf+xml":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["ddf"]},"application/vnd.syncml.dmtnds+wbxml":{"source":"iana"},"application/vnd.syncml.dmtnds+xml":{"source":"iana","charset":"UTF-8","compressible":true},"application/vnd.syncml.ds.notification":{"source":"iana"},"application/vnd.tableschema+json":{"source":"iana","compressible":true},"application/vnd.tao.intent-module-archive":{"source":"iana","extensions":["tao"]},"application/vnd.tcpdump.pcap":{"source":"iana","extensions":["pcap","cap","dmp"]},"application/vnd.think-cell.ppttc+json":{"source":"iana","compressible":true},"application/vnd.tmd.mediaflex.api+xml":{"source":"iana","compressible":true},"application/vnd.tml":{"source":"iana"},"application/vnd.tmobile-livetv":{"source":"iana","extensions":["tmo"]},"application/vnd.tri.onesource":{"source":"iana"},"application/vnd.trid.tpt":{"source":"iana","extensions":["tpt"]},"application/vnd.triscape.mxs":{"source":"iana","extensions":["mxs"]},"application/vnd.trueapp":{"source":"iana","extensions":["tra"]},"application/vnd.truedoc":{"source":"iana"},"application/vnd.ubisoft.webplayer":{"source":"iana"},"application/vnd.ufdl":{"source":"iana","extensions":["ufd","ufdl"]},"application/vnd.uic.osdm+json":{"source":"iana","compressible":true},"application/vnd.uiq.theme":{"source":"iana","extensions":["utz"]},"application/vnd.umajin":{"source":"iana","extensions":["umj"]},"application/vnd.unity":{"source":"iana","extensions":["unityweb"]},"application/vnd.uoml+xml":{"source":"iana","compressible":true,"extensions":["uoml","uo"]},"application/vnd.uplanet.alert":{"source":"iana"},"application/vnd.uplanet.alert-wbxml":{"source":"iana"},"application/vnd.uplanet.bearer-choice":{"source":"iana"},"application/vnd.uplanet.bearer-choice-wbxml":{"source":"iana"},"application/vnd.uplanet.cacheop":{"source":"iana"},"application/vnd.uplanet.cacheop-wbxml":{"source":"iana"},"application/vnd.uplanet.channel":{"source":"iana"},"application/vnd.uplanet.channel-wbxml":{"source":"iana"},"application/vnd.uplanet.list":{"source":"iana"},"application/vnd.uplanet.list-wbxml":{"source":"iana"},"application/vnd.uplanet.listcmd":{"source":"iana"},"application/vnd.uplanet.listcmd-wbxml":{"source":"iana"},"application/vnd.uplanet.signal":{"source":"iana"},"application/vnd.uri-map":{"source":"iana"},"application/vnd.valve.source.material":{"source":"iana"},"application/vnd.vcx":{"source":"iana","extensions":["vcx"]},"application/vnd.vd-study":{"source":"iana"},"application/vnd.vectorworks":{"source":"iana"},"application/vnd.vel+json":{"source":"iana","compressible":true},"application/vnd.veraison.tsm-report+cbor":{"source":"iana"},"application/vnd.veraison.tsm-report+json":{"source":"iana","compressible":true},"application/vnd.verimatrix.vcas":{"source":"iana"},"application/vnd.veritone.aion+json":{"source":"iana","compressible":true},"application/vnd.veryant.thin":{"source":"iana"},"application/vnd.ves.encrypted":{"source":"iana"},"application/vnd.vidsoft.vidconference":{"source":"iana"},"application/vnd.visio":{"source":"iana","extensions":["vsd","vst","vss","vsw","vsdx","vtx"]},"application/vnd.visionary":{"source":"iana","extensions":["vis"]},"application/vnd.vividence.scriptfile":{"source":"iana"},"application/vnd.vocalshaper.vsp4":{"source":"iana"},"application/vnd.vsf":{"source":"iana","extensions":["vsf"]},"application/vnd.wap.sic":{"source":"iana"},"application/vnd.wap.slc":{"source":"iana"},"application/vnd.wap.wbxml":{"source":"iana","charset":"UTF-8","extensions":["wbxml"]},"application/vnd.wap.wmlc":{"source":"iana","extensions":["wmlc"]},"application/vnd.wap.wmlscriptc":{"source":"iana","extensions":["wmlsc"]},"application/vnd.wasmflow.wafl":{"source":"iana"},"application/vnd.webturbo":{"source":"iana","extensions":["wtb"]},"application/vnd.wfa.dpp":{"source":"iana"},"application/vnd.wfa.p2p":{"source":"iana"},"application/vnd.wfa.wsc":{"source":"iana"},"application/vnd.windows.devicepairing":{"source":"iana"},"application/vnd.wmc":{"source":"iana"},"application/vnd.wmf.bootstrap":{"source":"iana"},"application/vnd.wolfram.mathematica":{"source":"iana"},"application/vnd.wolfram.mathematica.package":{"source":"iana"},"application/vnd.wolfram.player":{"source":"iana","extensions":["nbp"]},"application/vnd.wordlift":{"source":"iana"},"application/vnd.wordperfect":{"source":"iana","extensions":["wpd"]},"application/vnd.wqd":{"source":"iana","extensions":["wqd"]},"application/vnd.wrq-hp3000-labelled":{"source":"iana"},"application/vnd.wt.stf":{"source":"iana","extensions":["stf"]},"application/vnd.wv.csp+wbxml":{"source":"iana"},"application/vnd.wv.csp+xml":{"source":"iana","compressible":true},"application/vnd.wv.ssp+xml":{"source":"iana","compressible":true},"application/vnd.xacml+json":{"source":"iana","compressible":true},"application/vnd.xara":{"source":"iana","extensions":["xar"]},"application/vnd.xarin.cpj":{"source":"iana"},"application/vnd.xecrets-encrypted":{"source":"iana"},"application/vnd.xfdl":{"source":"iana","extensions":["xfdl"]},"application/vnd.xfdl.webform":{"source":"iana"},"application/vnd.xmi+xml":{"source":"iana","compressible":true},"application/vnd.xmpie.cpkg":{"source":"iana"},"application/vnd.xmpie.dpkg":{"source":"iana"},"application/vnd.xmpie.plan":{"source":"iana"},"application/vnd.xmpie.ppkg":{"source":"iana"},"application/vnd.xmpie.xlim":{"source":"iana"},"application/vnd.yamaha.hv-dic":{"source":"iana","extensions":["hvd"]},"application/vnd.yamaha.hv-script":{"source":"iana","extensions":["hvs"]},"application/vnd.yamaha.hv-voice":{"source":"iana","extensions":["hvp"]},"application/vnd.yamaha.openscoreformat":{"source":"iana","extensions":["osf"]},"application/vnd.yamaha.openscoreformat.osfpvg+xml":{"source":"iana","compressible":true,"extensions":["osfpvg"]},"application/vnd.yamaha.remote-setup":{"source":"iana"},"application/vnd.yamaha.smaf-audio":{"source":"iana","extensions":["saf"]},"application/vnd.yamaha.smaf-phrase":{"source":"iana","extensions":["spf"]},"application/vnd.yamaha.through-ngn":{"source":"iana"},"application/vnd.yamaha.tunnel-udpencap":{"source":"iana"},"application/vnd.yaoweme":{"source":"iana"},"application/vnd.yellowriver-custom-menu":{"source":"iana","extensions":["cmp"]},"application/vnd.zul":{"source":"iana","extensions":["zir","zirz"]},"application/vnd.zzazz.deck+xml":{"source":"iana","compressible":true,"extensions":["zaz"]},"application/voicexml+xml":{"source":"iana","compressible":true,"extensions":["vxml"]},"application/voucher-cms+json":{"source":"iana","compressible":true},"application/voucher-jws+json":{"source":"iana","compressible":true},"application/vp":{"source":"iana"},"application/vp+cose":{"source":"iana"},"application/vp+jwt":{"source":"iana"},"application/vq-rtcpxr":{"source":"iana"},"application/wasm":{"source":"iana","compressible":true,"extensions":["wasm"]},"application/watcherinfo+xml":{"source":"iana","compressible":true,"extensions":["wif"]},"application/webpush-options+json":{"source":"iana","compressible":true},"application/whoispp-query":{"source":"iana"},"application/whoispp-response":{"source":"iana"},"application/widget":{"source":"iana","extensions":["wgt"]},"application/winhlp":{"source":"apache","extensions":["hlp"]},"application/wita":{"source":"iana"},"application/wordperfect5.1":{"source":"iana"},"application/wsdl+xml":{"source":"iana","compressible":true,"extensions":["wsdl"]},"application/wspolicy+xml":{"source":"iana","compressible":true,"extensions":["wspolicy"]},"application/x-7z-compressed":{"source":"apache","compressible":false,"extensions":["7z"]},"application/x-abiword":{"source":"apache","extensions":["abw"]},"application/x-ace-compressed":{"source":"apache","extensions":["ace"]},"application/x-amf":{"source":"apache"},"application/x-apple-diskimage":{"source":"apache","extensions":["dmg"]},"application/x-arj":{"compressible":false,"extensions":["arj"]},"application/x-authorware-bin":{"source":"apache","extensions":["aab","x32","u32","vox"]},"application/x-authorware-map":{"source":"apache","extensions":["aam"]},"application/x-authorware-seg":{"source":"apache","extensions":["aas"]},"application/x-bcpio":{"source":"apache","extensions":["bcpio"]},"application/x-bdoc":{"compressible":false,"extensions":["bdoc"]},"application/x-bittorrent":{"source":"apache","extensions":["torrent"]},"application/x-blender":{"extensions":["blend"]},"application/x-blorb":{"source":"apache","extensions":["blb","blorb"]},"application/x-bzip":{"source":"apache","compressible":false,"extensions":["bz"]},"application/x-bzip2":{"source":"apache","compressible":false,"extensions":["bz2","boz"]},"application/x-cbr":{"source":"apache","extensions":["cbr","cba","cbt","cbz","cb7"]},"application/x-cdlink":{"source":"apache","extensions":["vcd"]},"application/x-cfs-compressed":{"source":"apache","extensions":["cfs"]},"application/x-chat":{"source":"apache","extensions":["chat"]},"application/x-chess-pgn":{"source":"apache","extensions":["pgn"]},"application/x-chrome-extension":{"extensions":["crx"]},"application/x-cocoa":{"source":"nginx","extensions":["cco"]},"application/x-compress":{"source":"apache"},"application/x-compressed":{"extensions":["rar"]},"application/x-conference":{"source":"apache","extensions":["nsc"]},"application/x-cpio":{"source":"apache","extensions":["cpio"]},"application/x-csh":{"source":"apache","extensions":["csh"]},"application/x-deb":{"compressible":false},"application/x-debian-package":{"source":"apache","extensions":["deb","udeb"]},"application/x-dgc-compressed":{"source":"apache","extensions":["dgc"]},"application/x-director":{"source":"apache","extensions":["dir","dcr","dxr","cst","cct","cxt","w3d","fgd","swa"]},"application/x-doom":{"source":"apache","extensions":["wad"]},"application/x-dtbncx+xml":{"source":"apache","compressible":true,"extensions":["ncx"]},"application/x-dtbook+xml":{"source":"apache","compressible":true,"extensions":["dtb"]},"application/x-dtbresource+xml":{"source":"apache","compressible":true,"extensions":["res"]},"application/x-dvi":{"source":"apache","compressible":false,"extensions":["dvi"]},"application/x-envoy":{"source":"apache","extensions":["evy"]},"application/x-eva":{"source":"apache","extensions":["eva"]},"application/x-font-bdf":{"source":"apache","extensions":["bdf"]},"application/x-font-dos":{"source":"apache"},"application/x-font-framemaker":{"source":"apache"},"application/x-font-ghostscript":{"source":"apache","extensions":["gsf"]},"application/x-font-libgrx":{"source":"apache"},"application/x-font-linux-psf":{"source":"apache","extensions":["psf"]},"application/x-font-pcf":{"source":"apache","extensions":["pcf"]},"application/x-font-snf":{"source":"apache","extensions":["snf"]},"application/x-font-speedo":{"source":"apache"},"application/x-font-sunos-news":{"source":"apache"},"application/x-font-type1":{"source":"apache","extensions":["pfa","pfb","pfm","afm"]},"application/x-font-vfont":{"source":"apache"},"application/x-freearc":{"source":"apache","extensions":["arc"]},"application/x-futuresplash":{"source":"apache","extensions":["spl"]},"application/x-gca-compressed":{"source":"apache","extensions":["gca"]},"application/x-glulx":{"source":"apache","extensions":["ulx"]},"application/x-gnumeric":{"source":"apache","extensions":["gnumeric"]},"application/x-gramps-xml":{"source":"apache","extensions":["gramps"]},"application/x-gtar":{"source":"apache","extensions":["gtar"]},"application/x-gzip":{"source":"apache"},"application/x-hdf":{"source":"apache","extensions":["hdf"]},"application/x-httpd-php":{"compressible":true,"extensions":["php"]},"application/x-install-instructions":{"source":"apache","extensions":["install"]},"application/x-ipynb+json":{"compressible":true,"extensions":["ipynb"]},"application/x-iso9660-image":{"source":"apache","extensions":["iso"]},"application/x-iwork-keynote-sffkey":{"extensions":["key"]},"application/x-iwork-numbers-sffnumbers":{"extensions":["numbers"]},"application/x-iwork-pages-sffpages":{"extensions":["pages"]},"application/x-java-archive-diff":{"source":"nginx","extensions":["jardiff"]},"application/x-java-jnlp-file":{"source":"apache","compressible":false,"extensions":["jnlp"]},"application/x-javascript":{"compressible":true},"application/x-keepass2":{"extensions":["kdbx"]},"application/x-latex":{"source":"apache","compressible":false,"extensions":["latex"]},"application/x-lua-bytecode":{"extensions":["luac"]},"application/x-lzh-compressed":{"source":"apache","extensions":["lzh","lha"]},"application/x-makeself":{"source":"nginx","extensions":["run"]},"application/x-mie":{"source":"apache","extensions":["mie"]},"application/x-mobipocket-ebook":{"source":"apache","extensions":["prc","mobi"]},"application/x-mpegurl":{"compressible":false},"application/x-ms-application":{"source":"apache","extensions":["application"]},"application/x-ms-shortcut":{"source":"apache","extensions":["lnk"]},"application/x-ms-wmd":{"source":"apache","extensions":["wmd"]},"application/x-ms-wmz":{"source":"apache","extensions":["wmz"]},"application/x-ms-xbap":{"source":"apache","extensions":["xbap"]},"application/x-msaccess":{"source":"apache","extensions":["mdb"]},"application/x-msbinder":{"source":"apache","extensions":["obd"]},"application/x-mscardfile":{"source":"apache","extensions":["crd"]},"application/x-msclip":{"source":"apache","extensions":["clp"]},"application/x-msdos-program":{"extensions":["exe"]},"application/x-msdownload":{"source":"apache","extensions":["exe","dll","com","bat","msi"]},"application/x-msmediaview":{"source":"apache","extensions":["mvb","m13","m14"]},"application/x-msmetafile":{"source":"apache","extensions":["wmf","wmz","emf","emz"]},"application/x-msmoney":{"source":"apache","extensions":["mny"]},"application/x-mspublisher":{"source":"apache","extensions":["pub"]},"application/x-msschedule":{"source":"apache","extensions":["scd"]},"application/x-msterminal":{"source":"apache","extensions":["trm"]},"application/x-mswrite":{"source":"apache","extensions":["wri"]},"application/x-netcdf":{"source":"apache","extensions":["nc","cdf"]},"application/x-ns-proxy-autoconfig":{"compressible":true,"extensions":["pac"]},"application/x-nzb":{"source":"apache","extensions":["nzb"]},"application/x-perl":{"source":"nginx","extensions":["pl","pm"]},"application/x-pilot":{"source":"nginx","extensions":["prc","pdb"]},"application/x-pkcs12":{"source":"apache","compressible":false,"extensions":["p12","pfx"]},"application/x-pkcs7-certificates":{"source":"apache","extensions":["p7b","spc"]},"application/x-pkcs7-certreqresp":{"source":"apache","extensions":["p7r"]},"application/x-pki-message":{"source":"iana"},"application/x-rar-compressed":{"source":"apache","compressible":false,"extensions":["rar"]},"application/x-redhat-package-manager":{"source":"nginx","extensions":["rpm"]},"application/x-research-info-systems":{"source":"apache","extensions":["ris"]},"application/x-sea":{"source":"nginx","extensions":["sea"]},"application/x-sh":{"source":"apache","compressible":true,"extensions":["sh"]},"application/x-shar":{"source":"apache","extensions":["shar"]},"application/x-shockwave-flash":{"source":"apache","compressible":false,"extensions":["swf"]},"application/x-silverlight-app":{"source":"apache","extensions":["xap"]},"application/x-sql":{"source":"apache","extensions":["sql"]},"application/x-stuffit":{"source":"apache","compressible":false,"extensions":["sit"]},"application/x-stuffitx":{"source":"apache","extensions":["sitx"]},"application/x-subrip":{"source":"apache","extensions":["srt"]},"application/x-sv4cpio":{"source":"apache","extensions":["sv4cpio"]},"application/x-sv4crc":{"source":"apache","extensions":["sv4crc"]},"application/x-t3vm-image":{"source":"apache","extensions":["t3"]},"application/x-tads":{"source":"apache","extensions":["gam"]},"application/x-tar":{"source":"apache","compressible":true,"extensions":["tar"]},"application/x-tcl":{"source":"apache","extensions":["tcl","tk"]},"application/x-tex":{"source":"apache","extensions":["tex"]},"application/x-tex-tfm":{"source":"apache","extensions":["tfm"]},"application/x-texinfo":{"source":"apache","extensions":["texinfo","texi"]},"application/x-tgif":{"source":"apache","extensions":["obj"]},"application/x-ustar":{"source":"apache","extensions":["ustar"]},"application/x-virtualbox-hdd":{"compressible":true,"extensions":["hdd"]},"application/x-virtualbox-ova":{"compressible":true,"extensions":["ova"]},"application/x-virtualbox-ovf":{"compressible":true,"extensions":["ovf"]},"application/x-virtualbox-vbox":{"compressible":true,"extensions":["vbox"]},"application/x-virtualbox-vbox-extpack":{"compressible":false,"extensions":["vbox-extpack"]},"application/x-virtualbox-vdi":{"compressible":true,"extensions":["vdi"]},"application/x-virtualbox-vhd":{"compressible":true,"extensions":["vhd"]},"application/x-virtualbox-vmdk":{"compressible":true,"extensions":["vmdk"]},"application/x-wais-source":{"source":"apache","extensions":["src"]},"application/x-web-app-manifest+json":{"compressible":true,"extensions":["webapp"]},"application/x-www-form-urlencoded":{"source":"iana","compressible":true},"application/x-x509-ca-cert":{"source":"iana","extensions":["der","crt","pem"]},"application/x-x509-ca-ra-cert":{"source":"iana"},"application/x-x509-next-ca-cert":{"source":"iana"},"application/x-xfig":{"source":"apache","extensions":["fig"]},"application/x-xliff+xml":{"source":"apache","compressible":true,"extensions":["xlf"]},"application/x-xpinstall":{"source":"apache","compressible":false,"extensions":["xpi"]},"application/x-xz":{"source":"apache","extensions":["xz"]},"application/x-zip-compressed":{"extensions":["zip"]},"application/x-zmachine":{"source":"apache","extensions":["z1","z2","z3","z4","z5","z6","z7","z8"]},"application/x400-bp":{"source":"iana"},"application/xacml+xml":{"source":"iana","compressible":true},"application/xaml+xml":{"source":"apache","compressible":true,"extensions":["xaml"]},"application/xcap-att+xml":{"source":"iana","compressible":true,"extensions":["xav"]},"application/xcap-caps+xml":{"source":"iana","compressible":true,"extensions":["xca"]},"application/xcap-diff+xml":{"source":"iana","compressible":true,"extensions":["xdf"]},"application/xcap-el+xml":{"source":"iana","compressible":true,"extensions":["xel"]},"application/xcap-error+xml":{"source":"iana","compressible":true},"application/xcap-ns+xml":{"source":"iana","compressible":true,"extensions":["xns"]},"application/xcon-conference-info+xml":{"source":"iana","compressible":true},"application/xcon-conference-info-diff+xml":{"source":"iana","compressible":true},"application/xenc+xml":{"source":"iana","compressible":true,"extensions":["xenc"]},"application/xfdf":{"source":"iana","extensions":["xfdf"]},"application/xhtml+xml":{"source":"iana","compressible":true,"extensions":["xhtml","xht"]},"application/xhtml-voice+xml":{"source":"apache","compressible":true},"application/xliff+xml":{"source":"iana","compressible":true,"extensions":["xlf"]},"application/xml":{"source":"iana","compressible":true,"extensions":["xml","xsl","xsd","rng"]},"application/xml-dtd":{"source":"iana","compressible":true,"extensions":["dtd"]},"application/xml-external-parsed-entity":{"source":"iana"},"application/xml-patch+xml":{"source":"iana","compressible":true},"application/xmpp+xml":{"source":"iana","compressible":true},"application/xop+xml":{"source":"iana","compressible":true,"extensions":["xop"]},"application/xproc+xml":{"source":"apache","compressible":true,"extensions":["xpl"]},"application/xslt+xml":{"source":"iana","compressible":true,"extensions":["xsl","xslt"]},"application/xspf+xml":{"source":"apache","compressible":true,"extensions":["xspf"]},"application/xv+xml":{"source":"iana","compressible":true,"extensions":["mxml","xhvml","xvml","xvm"]},"application/yaml":{"source":"iana"},"application/yang":{"source":"iana","extensions":["yang"]},"application/yang-data+cbor":{"source":"iana"},"application/yang-data+json":{"source":"iana","compressible":true},"application/yang-data+xml":{"source":"iana","compressible":true},"application/yang-patch+json":{"source":"iana","compressible":true},"application/yang-patch+xml":{"source":"iana","compressible":true},"application/yang-sid+json":{"source":"iana","compressible":true},"application/yin+xml":{"source":"iana","compressible":true,"extensions":["yin"]},"application/zip":{"source":"iana","compressible":false,"extensions":["zip"]},"application/zip+dotlottie":{"extensions":["lottie"]},"application/zlib":{"source":"iana"},"application/zstd":{"source":"iana"},"audio/1d-interleaved-parityfec":{"source":"iana"},"audio/32kadpcm":{"source":"iana"},"audio/3gpp":{"source":"iana","compressible":false,"extensions":["3gpp"]},"audio/3gpp2":{"source":"iana"},"audio/aac":{"source":"iana","extensions":["adts","aac"]},"audio/ac3":{"source":"iana"},"audio/adpcm":{"source":"apache","extensions":["adp"]},"audio/amr":{"source":"iana","extensions":["amr"]},"audio/amr-wb":{"source":"iana"},"audio/amr-wb+":{"source":"iana"},"audio/aptx":{"source":"iana"},"audio/asc":{"source":"iana"},"audio/atrac-advanced-lossless":{"source":"iana"},"audio/atrac-x":{"source":"iana"},"audio/atrac3":{"source":"iana"},"audio/basic":{"source":"iana","compressible":false,"extensions":["au","snd"]},"audio/bv16":{"source":"iana"},"audio/bv32":{"source":"iana"},"audio/clearmode":{"source":"iana"},"audio/cn":{"source":"iana"},"audio/dat12":{"source":"iana"},"audio/dls":{"source":"iana"},"audio/dsr-es201108":{"source":"iana"},"audio/dsr-es202050":{"source":"iana"},"audio/dsr-es202211":{"source":"iana"},"audio/dsr-es202212":{"source":"iana"},"audio/dv":{"source":"iana"},"audio/dvi4":{"source":"iana"},"audio/eac3":{"source":"iana"},"audio/encaprtp":{"source":"iana"},"audio/evrc":{"source":"iana"},"audio/evrc-qcp":{"source":"iana"},"audio/evrc0":{"source":"iana"},"audio/evrc1":{"source":"iana"},"audio/evrcb":{"source":"iana"},"audio/evrcb0":{"source":"iana"},"audio/evrcb1":{"source":"iana"},"audio/evrcnw":{"source":"iana"},"audio/evrcnw0":{"source":"iana"},"audio/evrcnw1":{"source":"iana"},"audio/evrcwb":{"source":"iana"},"audio/evrcwb0":{"source":"iana"},"audio/evrcwb1":{"source":"iana"},"audio/evs":{"source":"iana"},"audio/flac":{"source":"iana"},"audio/flexfec":{"source":"iana"},"audio/fwdred":{"source":"iana"},"audio/g711-0":{"source":"iana"},"audio/g719":{"source":"iana"},"audio/g722":{"source":"iana"},"audio/g7221":{"source":"iana"},"audio/g723":{"source":"iana"},"audio/g726-16":{"source":"iana"},"audio/g726-24":{"source":"iana"},"audio/g726-32":{"source":"iana"},"audio/g726-40":{"source":"iana"},"audio/g728":{"source":"iana"},"audio/g729":{"source":"iana"},"audio/g7291":{"source":"iana"},"audio/g729d":{"source":"iana"},"audio/g729e":{"source":"iana"},"audio/gsm":{"source":"iana"},"audio/gsm-efr":{"source":"iana"},"audio/gsm-hr-08":{"source":"iana"},"audio/ilbc":{"source":"iana"},"audio/ip-mr_v2.5":{"source":"iana"},"audio/isac":{"source":"apache"},"audio/l16":{"source":"iana"},"audio/l20":{"source":"iana"},"audio/l24":{"source":"iana","compressible":false},"audio/l8":{"source":"iana"},"audio/lpc":{"source":"iana"},"audio/matroska":{"source":"iana"},"audio/melp":{"source":"iana"},"audio/melp1200":{"source":"iana"},"audio/melp2400":{"source":"iana"},"audio/melp600":{"source":"iana"},"audio/mhas":{"source":"iana"},"audio/midi":{"source":"apache","extensions":["mid","midi","kar","rmi"]},"audio/midi-clip":{"source":"iana"},"audio/mobile-xmf":{"source":"iana","extensions":["mxmf"]},"audio/mp3":{"compressible":false,"extensions":["mp3"]},"audio/mp4":{"source":"iana","compressible":false,"extensions":["m4a","mp4a","m4b"]},"audio/mp4a-latm":{"source":"iana"},"audio/mpa":{"source":"iana"},"audio/mpa-robust":{"source":"iana"},"audio/mpeg":{"source":"iana","compressible":false,"extensions":["mpga","mp2","mp2a","mp3","m2a","m3a"]},"audio/mpeg4-generic":{"source":"iana"},"audio/musepack":{"source":"apache"},"audio/ogg":{"source":"iana","compressible":false,"extensions":["oga","ogg","spx","opus"]},"audio/opus":{"source":"iana"},"audio/parityfec":{"source":"iana"},"audio/pcma":{"source":"iana"},"audio/pcma-wb":{"source":"iana"},"audio/pcmu":{"source":"iana"},"audio/pcmu-wb":{"source":"iana"},"audio/prs.sid":{"source":"iana"},"audio/qcelp":{"source":"iana"},"audio/raptorfec":{"source":"iana"},"audio/red":{"source":"iana"},"audio/rtp-enc-aescm128":{"source":"iana"},"audio/rtp-midi":{"source":"iana"},"audio/rtploopback":{"source":"iana"},"audio/rtx":{"source":"iana"},"audio/s3m":{"source":"apache","extensions":["s3m"]},"audio/scip":{"source":"iana"},"audio/silk":{"source":"apache","extensions":["sil"]},"audio/smv":{"source":"iana"},"audio/smv-qcp":{"source":"iana"},"audio/smv0":{"source":"iana"},"audio/sofa":{"source":"iana"},"audio/sp-midi":{"source":"iana"},"audio/speex":{"source":"iana"},"audio/t140c":{"source":"iana"},"audio/t38":{"source":"iana"},"audio/telephone-event":{"source":"iana"},"audio/tetra_acelp":{"source":"iana"},"audio/tetra_acelp_bb":{"source":"iana"},"audio/tone":{"source":"iana"},"audio/tsvcis":{"source":"iana"},"audio/uemclip":{"source":"iana"},"audio/ulpfec":{"source":"iana"},"audio/usac":{"source":"iana"},"audio/vdvi":{"source":"iana"},"audio/vmr-wb":{"source":"iana"},"audio/vnd.3gpp.iufp":{"source":"iana"},"audio/vnd.4sb":{"source":"iana"},"audio/vnd.audiokoz":{"source":"iana"},"audio/vnd.celp":{"source":"iana"},"audio/vnd.cisco.nse":{"source":"iana"},"audio/vnd.cmles.radio-events":{"source":"iana"},"audio/vnd.cns.anp1":{"source":"iana"},"audio/vnd.cns.inf1":{"source":"iana"},"audio/vnd.dece.audio":{"source":"iana","extensions":["uva","uvva"]},"audio/vnd.digital-winds":{"source":"iana","extensions":["eol"]},"audio/vnd.dlna.adts":{"source":"iana"},"audio/vnd.dolby.heaac.1":{"source":"iana"},"audio/vnd.dolby.heaac.2":{"source":"iana"},"audio/vnd.dolby.mlp":{"source":"iana"},"audio/vnd.dolby.mps":{"source":"iana"},"audio/vnd.dolby.pl2":{"source":"iana"},"audio/vnd.dolby.pl2x":{"source":"iana"},"audio/vnd.dolby.pl2z":{"source":"iana"},"audio/vnd.dolby.pulse.1":{"source":"iana"},"audio/vnd.dra":{"source":"iana","extensions":["dra"]},"audio/vnd.dts":{"source":"iana","extensions":["dts"]},"audio/vnd.dts.hd":{"source":"iana","extensions":["dtshd"]},"audio/vnd.dts.uhd":{"source":"iana"},"audio/vnd.dvb.file":{"source":"iana"},"audio/vnd.everad.plj":{"source":"iana"},"audio/vnd.hns.audio":{"source":"iana"},"audio/vnd.lucent.voice":{"source":"iana","extensions":["lvp"]},"audio/vnd.ms-playready.media.pya":{"source":"iana","extensions":["pya"]},"audio/vnd.nokia.mobile-xmf":{"source":"iana"},"audio/vnd.nortel.vbk":{"source":"iana"},"audio/vnd.nuera.ecelp4800":{"source":"iana","extensions":["ecelp4800"]},"audio/vnd.nuera.ecelp7470":{"source":"iana","extensions":["ecelp7470"]},"audio/vnd.nuera.ecelp9600":{"source":"iana","extensions":["ecelp9600"]},"audio/vnd.octel.sbc":{"source":"iana"},"audio/vnd.presonus.multitrack":{"source":"iana"},"audio/vnd.qcelp":{"source":"apache"},"audio/vnd.rhetorex.32kadpcm":{"source":"iana"},"audio/vnd.rip":{"source":"iana","extensions":["rip"]},"audio/vnd.rn-realaudio":{"compressible":false},"audio/vnd.sealedmedia.softseal.mpeg":{"source":"iana"},"audio/vnd.vmx.cvsd":{"source":"iana"},"audio/vnd.wave":{"compressible":false},"audio/vorbis":{"source":"iana","compressible":false},"audio/vorbis-config":{"source":"iana"},"audio/wav":{"compressible":false,"extensions":["wav"]},"audio/wave":{"compressible":false,"extensions":["wav"]},"audio/webm":{"source":"apache","compressible":false,"extensions":["weba"]},"audio/x-aac":{"source":"apache","compressible":false,"extensions":["aac"]},"audio/x-aiff":{"source":"apache","extensions":["aif","aiff","aifc"]},"audio/x-caf":{"source":"apache","compressible":false,"extensions":["caf"]},"audio/x-flac":{"source":"apache","extensions":["flac"]},"audio/x-m4a":{"source":"nginx","extensions":["m4a"]},"audio/x-matroska":{"source":"apache","extensions":["mka"]},"audio/x-mpegurl":{"source":"apache","extensions":["m3u"]},"audio/x-ms-wax":{"source":"apache","extensions":["wax"]},"audio/x-ms-wma":{"source":"apache","extensions":["wma"]},"audio/x-pn-realaudio":{"source":"apache","extensions":["ram","ra"]},"audio/x-pn-realaudio-plugin":{"source":"apache","extensions":["rmp"]},"audio/x-realaudio":{"source":"nginx","extensions":["ra"]},"audio/x-tta":{"source":"apache"},"audio/x-wav":{"source":"apache","extensions":["wav"]},"audio/xm":{"source":"apache","extensions":["xm"]},"chemical/x-cdx":{"source":"apache","extensions":["cdx"]},"chemical/x-cif":{"source":"apache","extensions":["cif"]},"chemical/x-cmdf":{"source":"apache","extensions":["cmdf"]},"chemical/x-cml":{"source":"apache","extensions":["cml"]},"chemical/x-csml":{"source":"apache","extensions":["csml"]},"chemical/x-pdb":{"source":"apache"},"chemical/x-xyz":{"source":"apache","extensions":["xyz"]},"font/collection":{"source":"iana","extensions":["ttc"]},"font/otf":{"source":"iana","compressible":true,"extensions":["otf"]},"font/sfnt":{"source":"iana"},"font/ttf":{"source":"iana","compressible":true,"extensions":["ttf"]},"font/woff":{"source":"iana","extensions":["woff"]},"font/woff2":{"source":"iana","extensions":["woff2"]},"image/aces":{"source":"iana","extensions":["exr"]},"image/apng":{"source":"iana","compressible":false,"extensions":["apng"]},"image/avci":{"source":"iana","extensions":["avci"]},"image/avcs":{"source":"iana","extensions":["avcs"]},"image/avif":{"source":"iana","compressible":false,"extensions":["avif"]},"image/bmp":{"source":"iana","compressible":true,"extensions":["bmp","dib"]},"image/cgm":{"source":"iana","extensions":["cgm"]},"image/dicom-rle":{"source":"iana","extensions":["drle"]},"image/dpx":{"source":"iana","extensions":["dpx"]},"image/emf":{"source":"iana","extensions":["emf"]},"image/fits":{"source":"iana","extensions":["fits"]},"image/g3fax":{"source":"iana","extensions":["g3"]},"image/gif":{"source":"iana","compressible":false,"extensions":["gif"]},"image/heic":{"source":"iana","extensions":["heic"]},"image/heic-sequence":{"source":"iana","extensions":["heics"]},"image/heif":{"source":"iana","extensions":["heif"]},"image/heif-sequence":{"source":"iana","extensions":["heifs"]},"image/hej2k":{"source":"iana","extensions":["hej2"]},"image/ief":{"source":"iana","extensions":["ief"]},"image/j2c":{"source":"iana"},"image/jaii":{"source":"iana","extensions":["jaii"]},"image/jais":{"source":"iana","extensions":["jais"]},"image/jls":{"source":"iana","extensions":["jls"]},"image/jp2":{"source":"iana","compressible":false,"extensions":["jp2","jpg2"]},"image/jpeg":{"source":"iana","compressible":false,"extensions":["jpg","jpeg","jpe"]},"image/jph":{"source":"iana","extensions":["jph"]},"image/jphc":{"source":"iana","extensions":["jhc"]},"image/jpm":{"source":"iana","compressible":false,"extensions":["jpm","jpgm"]},"image/jpx":{"source":"iana","compressible":false,"extensions":["jpx","jpf"]},"image/jxl":{"source":"iana","extensions":["jxl"]},"image/jxr":{"source":"iana","extensions":["jxr"]},"image/jxra":{"source":"iana","extensions":["jxra"]},"image/jxrs":{"source":"iana","extensions":["jxrs"]},"image/jxs":{"source":"iana","extensions":["jxs"]},"image/jxsc":{"source":"iana","extensions":["jxsc"]},"image/jxsi":{"source":"iana","extensions":["jxsi"]},"image/jxss":{"source":"iana","extensions":["jxss"]},"image/ktx":{"source":"iana","extensions":["ktx"]},"image/ktx2":{"source":"iana","extensions":["ktx2"]},"image/naplps":{"source":"iana"},"image/pjpeg":{"compressible":false,"extensions":["jfif"]},"image/png":{"source":"iana","compressible":false,"extensions":["png"]},"image/prs.btif":{"source":"iana","extensions":["btif","btf"]},"image/prs.pti":{"source":"iana","extensions":["pti"]},"image/pwg-raster":{"source":"iana"},"image/sgi":{"source":"apache","extensions":["sgi"]},"image/svg+xml":{"source":"iana","compressible":true,"extensions":["svg","svgz"]},"image/t38":{"source":"iana","extensions":["t38"]},"image/tiff":{"source":"iana","compressible":false,"extensions":["tif","tiff"]},"image/tiff-fx":{"source":"iana","extensions":["tfx"]},"image/vnd.adobe.photoshop":{"source":"iana","compressible":true,"extensions":["psd"]},"image/vnd.airzip.accelerator.azv":{"source":"iana","extensions":["azv"]},"image/vnd.clip":{"source":"iana"},"image/vnd.cns.inf2":{"source":"iana"},"image/vnd.dece.graphic":{"source":"iana","extensions":["uvi","uvvi","uvg","uvvg"]},"image/vnd.djvu":{"source":"iana","extensions":["djvu","djv"]},"image/vnd.dvb.subtitle":{"source":"iana","extensions":["sub"]},"image/vnd.dwg":{"source":"iana","extensions":["dwg"]},"image/vnd.dxf":{"source":"iana","extensions":["dxf"]},"image/vnd.fastbidsheet":{"source":"iana","extensions":["fbs"]},"image/vnd.fpx":{"source":"iana","extensions":["fpx"]},"image/vnd.fst":{"source":"iana","extensions":["fst"]},"image/vnd.fujixerox.edmics-mmr":{"source":"iana","extensions":["mmr"]},"image/vnd.fujixerox.edmics-rlc":{"source":"iana","extensions":["rlc"]},"image/vnd.globalgraphics.pgb":{"source":"iana"},"image/vnd.microsoft.icon":{"source":"iana","compressible":true,"extensions":["ico"]},"image/vnd.mix":{"source":"iana"},"image/vnd.mozilla.apng":{"source":"iana"},"image/vnd.ms-dds":{"compressible":true,"extensions":["dds"]},"image/vnd.ms-modi":{"source":"iana","extensions":["mdi"]},"image/vnd.ms-photo":{"source":"apache","extensions":["wdp"]},"image/vnd.net-fpx":{"source":"iana","extensions":["npx"]},"image/vnd.pco.b16":{"source":"iana","extensions":["b16"]},"image/vnd.radiance":{"source":"iana"},"image/vnd.sealed.png":{"source":"iana"},"image/vnd.sealedmedia.softseal.gif":{"source":"iana"},"image/vnd.sealedmedia.softseal.jpg":{"source":"iana"},"image/vnd.svf":{"source":"iana"},"image/vnd.tencent.tap":{"source":"iana","extensions":["tap"]},"image/vnd.valve.source.texture":{"source":"iana","extensions":["vtf"]},"image/vnd.wap.wbmp":{"source":"iana","extensions":["wbmp"]},"image/vnd.xiff":{"source":"iana","extensions":["xif"]},"image/vnd.zbrush.pcx":{"source":"iana","extensions":["pcx"]},"image/webp":{"source":"iana","extensions":["webp"]},"image/wmf":{"source":"iana","extensions":["wmf"]},"image/x-3ds":{"source":"apache","extensions":["3ds"]},"image/x-adobe-dng":{"extensions":["dng"]},"image/x-cmu-raster":{"source":"apache","extensions":["ras"]},"image/x-cmx":{"source":"apache","extensions":["cmx"]},"image/x-emf":{"source":"iana"},"image/x-freehand":{"source":"apache","extensions":["fh","fhc","fh4","fh5","fh7"]},"image/x-icon":{"source":"apache","compressible":true,"extensions":["ico"]},"image/x-jng":{"source":"nginx","extensions":["jng"]},"image/x-mrsid-image":{"source":"apache","extensions":["sid"]},"image/x-ms-bmp":{"source":"nginx","compressible":true,"extensions":["bmp"]},"image/x-pcx":{"source":"apache","extensions":["pcx"]},"image/x-pict":{"source":"apache","extensions":["pic","pct"]},"image/x-portable-anymap":{"source":"apache","extensions":["pnm"]},"image/x-portable-bitmap":{"source":"apache","extensions":["pbm"]},"image/x-portable-graymap":{"source":"apache","extensions":["pgm"]},"image/x-portable-pixmap":{"source":"apache","extensions":["ppm"]},"image/x-rgb":{"source":"apache","extensions":["rgb"]},"image/x-tga":{"source":"apache","extensions":["tga"]},"image/x-wmf":{"source":"iana"},"image/x-xbitmap":{"source":"apache","extensions":["xbm"]},"image/x-xcf":{"compressible":false},"image/x-xpixmap":{"source":"apache","extensions":["xpm"]},"image/x-xwindowdump":{"source":"apache","extensions":["xwd"]},"message/bhttp":{"source":"iana"},"message/cpim":{"source":"iana"},"message/delivery-status":{"source":"iana"},"message/disposition-notification":{"source":"iana","extensions":["disposition-notification"]},"message/external-body":{"source":"iana"},"message/feedback-report":{"source":"iana"},"message/global":{"source":"iana","extensions":["u8msg"]},"message/global-delivery-status":{"source":"iana","extensions":["u8dsn"]},"message/global-disposition-notification":{"source":"iana","extensions":["u8mdn"]},"message/global-headers":{"source":"iana","extensions":["u8hdr"]},"message/http":{"source":"iana","compressible":false},"message/imdn+xml":{"source":"iana","compressible":true},"message/mls":{"source":"iana"},"message/news":{"source":"apache"},"message/ohttp-req":{"source":"iana"},"message/ohttp-res":{"source":"iana"},"message/partial":{"source":"iana","compressible":false},"message/rfc822":{"source":"iana","compressible":true,"extensions":["eml","mime","mht","mhtml"]},"message/s-http":{"source":"apache"},"message/sip":{"source":"iana"},"message/sipfrag":{"source":"iana"},"message/tracking-status":{"source":"iana"},"message/vnd.si.simp":{"source":"apache"},"message/vnd.wfa.wsc":{"source":"iana","extensions":["wsc"]},"model/3mf":{"source":"iana","extensions":["3mf"]},"model/e57":{"source":"iana"},"model/gltf+json":{"source":"iana","compressible":true,"extensions":["gltf"]},"model/gltf-binary":{"source":"iana","compressible":true,"extensions":["glb"]},"model/iges":{"source":"iana","compressible":false,"extensions":["igs","iges"]},"model/jt":{"source":"iana","extensions":["jt"]},"model/mesh":{"source":"iana","compressible":false,"extensions":["msh","mesh","silo"]},"model/mtl":{"source":"iana","extensions":["mtl"]},"model/obj":{"source":"iana","extensions":["obj"]},"model/prc":{"source":"iana","extensions":["prc"]},"model/step":{"source":"iana","extensions":["step","stp","stpnc","p21","210"]},"model/step+xml":{"source":"iana","compressible":true,"extensions":["stpx"]},"model/step+zip":{"source":"iana","compressible":false,"extensions":["stpz"]},"model/step-xml+zip":{"source":"iana","compressible":false,"extensions":["stpxz"]},"model/stl":{"source":"iana","extensions":["stl"]},"model/u3d":{"source":"iana","extensions":["u3d"]},"model/vnd.bary":{"source":"iana","extensions":["bary"]},"model/vnd.cld":{"source":"iana","extensions":["cld"]},"model/vnd.collada+xml":{"source":"iana","compressible":true,"extensions":["dae"]},"model/vnd.dwf":{"source":"iana","extensions":["dwf"]},"model/vnd.flatland.3dml":{"source":"iana"},"model/vnd.gdl":{"source":"iana","extensions":["gdl"]},"model/vnd.gs-gdl":{"source":"apache"},"model/vnd.gs.gdl":{"source":"iana"},"model/vnd.gtw":{"source":"iana","extensions":["gtw"]},"model/vnd.moml+xml":{"source":"iana","compressible":true},"model/vnd.mts":{"source":"iana","extensions":["mts"]},"model/vnd.opengex":{"source":"iana","extensions":["ogex"]},"model/vnd.parasolid.transmit.binary":{"source":"iana","extensions":["x_b"]},"model/vnd.parasolid.transmit.text":{"source":"iana","extensions":["x_t"]},"model/vnd.pytha.pyox":{"source":"iana","extensions":["pyo","pyox"]},"model/vnd.rosette.annotated-data-model":{"source":"iana"},"model/vnd.sap.vds":{"source":"iana","extensions":["vds"]},"model/vnd.usda":{"source":"iana","extensions":["usda"]},"model/vnd.usdz+zip":{"source":"iana","compressible":false,"extensions":["usdz"]},"model/vnd.valve.source.compiled-map":{"source":"iana","extensions":["bsp"]},"model/vnd.vtu":{"source":"iana","extensions":["vtu"]},"model/vrml":{"source":"iana","compressible":false,"extensions":["wrl","vrml"]},"model/x3d+binary":{"source":"apache","compressible":false,"extensions":["x3db","x3dbz"]},"model/x3d+fastinfoset":{"source":"iana","extensions":["x3db"]},"model/x3d+vrml":{"source":"apache","compressible":false,"extensions":["x3dv","x3dvz"]},"model/x3d+xml":{"source":"iana","compressible":true,"extensions":["x3d","x3dz"]},"model/x3d-vrml":{"source":"iana","extensions":["x3dv"]},"multipart/alternative":{"source":"iana","compressible":false},"multipart/appledouble":{"source":"iana"},"multipart/byteranges":{"source":"iana"},"multipart/digest":{"source":"iana"},"multipart/encrypted":{"source":"iana","compressible":false},"multipart/form-data":{"source":"iana","compressible":false},"multipart/header-set":{"source":"iana"},"multipart/mixed":{"source":"iana"},"multipart/multilingual":{"source":"iana"},"multipart/parallel":{"source":"iana"},"multipart/related":{"source":"iana","compressible":false},"multipart/report":{"source":"iana"},"multipart/signed":{"source":"iana","compressible":false},"multipart/vnd.bint.med-plus":{"source":"iana"},"multipart/voice-message":{"source":"iana"},"multipart/x-mixed-replace":{"source":"iana"},"text/1d-interleaved-parityfec":{"source":"iana"},"text/cache-manifest":{"source":"iana","compressible":true,"extensions":["appcache","manifest"]},"text/calendar":{"source":"iana","extensions":["ics","ifb"]},"text/calender":{"compressible":true},"text/cmd":{"compressible":true},"text/coffeescript":{"extensions":["coffee","litcoffee"]},"text/cql":{"source":"iana"},"text/cql-expression":{"source":"iana"},"text/cql-identifier":{"source":"iana"},"text/css":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["css"]},"text/csv":{"source":"iana","compressible":true,"extensions":["csv"]},"text/csv-schema":{"source":"iana"},"text/directory":{"source":"iana"},"text/dns":{"source":"iana"},"text/ecmascript":{"source":"apache"},"text/encaprtp":{"source":"iana"},"text/enriched":{"source":"iana"},"text/fhirpath":{"source":"iana"},"text/flexfec":{"source":"iana"},"text/fwdred":{"source":"iana"},"text/gff3":{"source":"iana"},"text/grammar-ref-list":{"source":"iana"},"text/hl7v2":{"source":"iana"},"text/html":{"source":"iana","compressible":true,"extensions":["html","htm","shtml"]},"text/jade":{"extensions":["jade"]},"text/javascript":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["js","mjs"]},"text/jcr-cnd":{"source":"iana"},"text/jsx":{"compressible":true,"extensions":["jsx"]},"text/less":{"compressible":true,"extensions":["less"]},"text/markdown":{"source":"iana","compressible":true,"extensions":["md","markdown"]},"text/mathml":{"source":"nginx","extensions":["mml"]},"text/mdx":{"compressible":true,"extensions":["mdx"]},"text/mizar":{"source":"iana"},"text/n3":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["n3"]},"text/parameters":{"source":"iana","charset":"UTF-8"},"text/parityfec":{"source":"iana"},"text/plain":{"source":"iana","compressible":true,"extensions":["txt","text","conf","def","list","log","in","ini"]},"text/provenance-notation":{"source":"iana","charset":"UTF-8"},"text/prs.fallenstein.rst":{"source":"iana"},"text/prs.lines.tag":{"source":"iana","extensions":["dsc"]},"text/prs.prop.logic":{"source":"iana"},"text/prs.texi":{"source":"iana"},"text/raptorfec":{"source":"iana"},"text/red":{"source":"iana"},"text/rfc822-headers":{"source":"iana"},"text/richtext":{"source":"iana","compressible":true,"extensions":["rtx"]},"text/rtf":{"source":"iana","compressible":true,"extensions":["rtf"]},"text/rtp-enc-aescm128":{"source":"iana"},"text/rtploopback":{"source":"iana"},"text/rtx":{"source":"iana"},"text/sgml":{"source":"iana","extensions":["sgml","sgm"]},"text/shaclc":{"source":"iana"},"text/shex":{"source":"iana","extensions":["shex"]},"text/slim":{"extensions":["slim","slm"]},"text/spdx":{"source":"iana","extensions":["spdx"]},"text/strings":{"source":"iana"},"text/stylus":{"extensions":["stylus","styl"]},"text/t140":{"source":"iana"},"text/tab-separated-values":{"source":"iana","compressible":true,"extensions":["tsv"]},"text/troff":{"source":"iana","extensions":["t","tr","roff","man","me","ms"]},"text/turtle":{"source":"iana","charset":"UTF-8","extensions":["ttl"]},"text/ulpfec":{"source":"iana"},"text/uri-list":{"source":"iana","compressible":true,"extensions":["uri","uris","urls"]},"text/vcard":{"source":"iana","compressible":true,"extensions":["vcard"]},"text/vnd.a":{"source":"iana"},"text/vnd.abc":{"source":"iana"},"text/vnd.ascii-art":{"source":"iana"},"text/vnd.curl":{"source":"iana","extensions":["curl"]},"text/vnd.curl.dcurl":{"source":"apache","extensions":["dcurl"]},"text/vnd.curl.mcurl":{"source":"apache","extensions":["mcurl"]},"text/vnd.curl.scurl":{"source":"apache","extensions":["scurl"]},"text/vnd.debian.copyright":{"source":"iana","charset":"UTF-8"},"text/vnd.dmclientscript":{"source":"iana"},"text/vnd.dvb.subtitle":{"source":"iana","extensions":["sub"]},"text/vnd.esmertec.theme-descriptor":{"source":"iana","charset":"UTF-8"},"text/vnd.exchangeable":{"source":"iana"},"text/vnd.familysearch.gedcom":{"source":"iana","extensions":["ged"]},"text/vnd.ficlab.flt":{"source":"iana"},"text/vnd.fly":{"source":"iana","extensions":["fly"]},"text/vnd.fmi.flexstor":{"source":"iana","extensions":["flx"]},"text/vnd.gml":{"source":"iana"},"text/vnd.graphviz":{"source":"iana","extensions":["gv"]},"text/vnd.hans":{"source":"iana"},"text/vnd.hgl":{"source":"iana"},"text/vnd.in3d.3dml":{"source":"iana","extensions":["3dml"]},"text/vnd.in3d.spot":{"source":"iana","extensions":["spot"]},"text/vnd.iptc.newsml":{"source":"iana"},"text/vnd.iptc.nitf":{"source":"iana"},"text/vnd.latex-z":{"source":"iana"},"text/vnd.motorola.reflex":{"source":"iana"},"text/vnd.ms-mediapackage":{"source":"iana"},"text/vnd.net2phone.commcenter.command":{"source":"iana"},"text/vnd.radisys.msml-basic-layout":{"source":"iana"},"text/vnd.senx.warpscript":{"source":"iana"},"text/vnd.si.uricatalogue":{"source":"apache"},"text/vnd.sosi":{"source":"iana"},"text/vnd.sun.j2me.app-descriptor":{"source":"iana","charset":"UTF-8","extensions":["jad"]},"text/vnd.trolltech.linguist":{"source":"iana","charset":"UTF-8"},"text/vnd.vcf":{"source":"iana"},"text/vnd.wap.si":{"source":"iana"},"text/vnd.wap.sl":{"source":"iana"},"text/vnd.wap.wml":{"source":"iana","extensions":["wml"]},"text/vnd.wap.wmlscript":{"source":"iana","extensions":["wmls"]},"text/vnd.zoo.kcl":{"source":"iana"},"text/vtt":{"source":"iana","charset":"UTF-8","compressible":true,"extensions":["vtt"]},"text/wgsl":{"source":"iana","extensions":["wgsl"]},"text/x-asm":{"source":"apache","extensions":["s","asm"]},"text/x-c":{"source":"apache","extensions":["c","cc","cxx","cpp","h","hh","dic"]},"text/x-component":{"source":"nginx","extensions":["htc"]},"text/x-fortran":{"source":"apache","extensions":["f","for","f77","f90"]},"text/x-gwt-rpc":{"compressible":true},"text/x-handlebars-template":{"extensions":["hbs"]},"text/x-java-source":{"source":"apache","extensions":["java"]},"text/x-jquery-tmpl":{"compressible":true},"text/x-lua":{"extensions":["lua"]},"text/x-markdown":{"compressible":true,"extensions":["mkd"]},"text/x-nfo":{"source":"apache","extensions":["nfo"]},"text/x-opml":{"source":"apache","extensions":["opml"]},"text/x-org":{"compressible":true,"extensions":["org"]},"text/x-pascal":{"source":"apache","extensions":["p","pas"]},"text/x-processing":{"compressible":true,"extensions":["pde"]},"text/x-sass":{"extensions":["sass"]},"text/x-scss":{"extensions":["scss"]},"text/x-setext":{"source":"apache","extensions":["etx"]},"text/x-sfv":{"source":"apache","extensions":["sfv"]},"text/x-suse-ymp":{"compressible":true,"extensions":["ymp"]},"text/x-uuencode":{"source":"apache","extensions":["uu"]},"text/x-vcalendar":{"source":"apache","extensions":["vcs"]},"text/x-vcard":{"source":"apache","extensions":["vcf"]},"text/xml":{"source":"iana","compressible":true,"extensions":["xml"]},"text/xml-external-parsed-entity":{"source":"iana"},"text/yaml":{"compressible":true,"extensions":["yaml","yml"]},"video/1d-interleaved-parityfec":{"source":"iana"},"video/3gpp":{"source":"iana","extensions":["3gp","3gpp"]},"video/3gpp-tt":{"source":"iana"},"video/3gpp2":{"source":"iana","extensions":["3g2"]},"video/av1":{"source":"iana"},"video/bmpeg":{"source":"iana"},"video/bt656":{"source":"iana"},"video/celb":{"source":"iana"},"video/dv":{"source":"iana"},"video/encaprtp":{"source":"iana"},"video/evc":{"source":"iana"},"video/ffv1":{"source":"iana"},"video/flexfec":{"source":"iana"},"video/h261":{"source":"iana","extensions":["h261"]},"video/h263":{"source":"iana","extensions":["h263"]},"video/h263-1998":{"source":"iana"},"video/h263-2000":{"source":"iana"},"video/h264":{"source":"iana","extensions":["h264"]},"video/h264-rcdo":{"source":"iana"},"video/h264-svc":{"source":"iana"},"video/h265":{"source":"iana"},"video/h266":{"source":"iana"},"video/iso.segment":{"source":"iana","extensions":["m4s"]},"video/jpeg":{"source":"iana","extensions":["jpgv"]},"video/jpeg2000":{"source":"iana"},"video/jpm":{"source":"apache","extensions":["jpm","jpgm"]},"video/jxsv":{"source":"iana"},"video/lottie+json":{"source":"iana","compressible":true},"video/matroska":{"source":"iana"},"video/matroska-3d":{"source":"iana"},"video/mj2":{"source":"iana","extensions":["mj2","mjp2"]},"video/mp1s":{"source":"iana"},"video/mp2p":{"source":"iana"},"video/mp2t":{"source":"iana","extensions":["ts","m2t","m2ts","mts"]},"video/mp4":{"source":"iana","compressible":false,"extensions":["mp4","mp4v","mpg4"]},"video/mp4v-es":{"source":"iana"},"video/mpeg":{"source":"iana","compressible":false,"extensions":["mpeg","mpg","mpe","m1v","m2v"]},"video/mpeg4-generic":{"source":"iana"},"video/mpv":{"source":"iana"},"video/nv":{"source":"iana"},"video/ogg":{"source":"iana","compressible":false,"extensions":["ogv"]},"video/parityfec":{"source":"iana"},"video/pointer":{"source":"iana"},"video/quicktime":{"source":"iana","compressible":false,"extensions":["qt","mov"]},"video/raptorfec":{"source":"iana"},"video/raw":{"source":"iana"},"video/rtp-enc-aescm128":{"source":"iana"},"video/rtploopback":{"source":"iana"},"video/rtx":{"source":"iana"},"video/scip":{"source":"iana"},"video/smpte291":{"source":"iana"},"video/smpte292m":{"source":"iana"},"video/ulpfec":{"source":"iana"},"video/vc1":{"source":"iana"},"video/vc2":{"source":"iana"},"video/vnd.cctv":{"source":"iana"},"video/vnd.dece.hd":{"source":"iana","extensions":["uvh","uvvh"]},"video/vnd.dece.mobile":{"source":"iana","extensions":["uvm","uvvm"]},"video/vnd.dece.mp4":{"source":"iana"},"video/vnd.dece.pd":{"source":"iana","extensions":["uvp","uvvp"]},"video/vnd.dece.sd":{"source":"iana","extensions":["uvs","uvvs"]},"video/vnd.dece.video":{"source":"iana","extensions":["uvv","uvvv"]},"video/vnd.directv.mpeg":{"source":"iana"},"video/vnd.directv.mpeg-tts":{"source":"iana"},"video/vnd.dlna.mpeg-tts":{"source":"iana"},"video/vnd.dvb.file":{"source":"iana","extensions":["dvb"]},"video/vnd.fvt":{"source":"iana","extensions":["fvt"]},"video/vnd.hns.video":{"source":"iana"},"video/vnd.iptvforum.1dparityfec-1010":{"source":"iana"},"video/vnd.iptvforum.1dparityfec-2005":{"source":"iana"},"video/vnd.iptvforum.2dparityfec-1010":{"source":"iana"},"video/vnd.iptvforum.2dparityfec-2005":{"source":"iana"},"video/vnd.iptvforum.ttsavc":{"source":"iana"},"video/vnd.iptvforum.ttsmpeg2":{"source":"iana"},"video/vnd.motorola.video":{"source":"iana"},"video/vnd.motorola.videop":{"source":"iana"},"video/vnd.mpegurl":{"source":"iana","extensions":["mxu","m4u"]},"video/vnd.ms-playready.media.pyv":{"source":"iana","extensions":["pyv"]},"video/vnd.nokia.interleaved-multimedia":{"source":"iana"},"video/vnd.nokia.mp4vr":{"source":"iana"},"video/vnd.nokia.videovoip":{"source":"iana"},"video/vnd.objectvideo":{"source":"iana"},"video/vnd.planar":{"source":"iana"},"video/vnd.radgamettools.bink":{"source":"iana"},"video/vnd.radgamettools.smacker":{"source":"apache"},"video/vnd.sealed.mpeg1":{"source":"iana"},"video/vnd.sealed.mpeg4":{"source":"iana"},"video/vnd.sealed.swf":{"source":"iana"},"video/vnd.sealedmedia.softseal.mov":{"source":"iana"},"video/vnd.uvvu.mp4":{"source":"iana","extensions":["uvu","uvvu"]},"video/vnd.vivo":{"source":"iana","extensions":["viv"]},"video/vnd.youtube.yt":{"source":"iana"},"video/vp8":{"source":"iana"},"video/vp9":{"source":"iana"},"video/webm":{"source":"apache","compressible":false,"extensions":["webm"]},"video/x-f4v":{"source":"apache","extensions":["f4v"]},"video/x-fli":{"source":"apache","extensions":["fli"]},"video/x-flv":{"source":"apache","compressible":false,"extensions":["flv"]},"video/x-m4v":{"source":"apache","extensions":["m4v"]},"video/x-matroska":{"source":"apache","compressible":false,"extensions":["mkv","mk3d","mks"]},"video/x-mng":{"source":"apache","extensions":["mng"]},"video/x-ms-asf":{"source":"apache","extensions":["asf","asx"]},"video/x-ms-vob":{"source":"apache","extensions":["vob"]},"video/x-ms-wm":{"source":"apache","extensions":["wm"]},"video/x-ms-wmv":{"source":"apache","compressible":false,"extensions":["wmv"]},"video/x-ms-wmx":{"source":"apache","extensions":["wmx"]},"video/x-ms-wvx":{"source":"apache","extensions":["wvx"]},"video/x-msvideo":{"source":"apache","extensions":["avi"]},"video/x-sgi-movie":{"source":"apache","extensions":["movie"]},"video/x-smv":{"source":"apache","extensions":["smv"]},"x-conference/x-cooltalk":{"source":"apache","extensions":["ice"]},"x-shader/x-fragment":{"compressible":true},"x-shader/x-vertex":{"compressible":true}}')},35334:(e,t)=>{"use strict";const a=":A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD",o="["+a+"]["+(a+"\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040")+"]*",r=new RegExp("^"+o+"$");t.isExist=function(e){return void 0!==e},t.isEmptyObject=function(e){return 0===Object.keys(e).length},t.merge=function(e,t,a){if(t){const o=Object.keys(t),r=o.length;for(let i=0;i<r;i++)e[o[i]]="strict"===a?[t[o[i]]]:t[o[i]]}},t.getValue=function(e){return t.isExist(e)?e:""},t.isName=function(e){const t=r.exec(e);return!(null==t)},t.getAllMatches=function(e,t){const a=[];let o=t.exec(e);for(;o;){const r=[];r.startIndex=t.lastIndex-o[0].length;const i=o.length;for(let e=0;e<i;e++)r.push(o[e]);a.push(r),o=t.exec(e)}return a},t.nameRegexp=o},35345:e=>{"use strict";e.exports=URIError},35580:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t,a)=>o(e,t,a)>0},36556:(e,t,a)=>{"use strict";var o=a(70453),r=a(73126),i=r([o("%String.prototype.indexOf%")]);e.exports=function callBoundIntrinsic(e,t){var a=o(e,!!t);return"function"==typeof a&&i(e,".prototype.")>-1?r([a]):a}},37067:e=>{"use strict";e.exports=require("node:http")},37201:(e,t,a)=>{"use strict";const o=a(79896);e.exports=e=>new Promise(t=>{o.access(e,e=>{t(!e)})}),e.exports.sync=e=>{try{return o.accessSync(e),!0}catch(e){return!1}}},37294:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseNullDef=void 0,t.parseNullDef=function parseNullDef(e){return"openApi3"===e.target?{enum:["null"],nullable:!0}:{type:"null"}}},37404:e=>{"use strict";function formatHostname(e){return e.replace(/^\.*/,".").toLowerCase()}function parseNoProxyZone(e){var t=(e=e.trim().toLowerCase()).split(":",2);return{hostname:formatHostname(t[0]),port:t[1],hasPort:e.indexOf(":")>-1}}e.exports=function getProxyFromURI(e){var t=process.env.NO_PROXY||process.env.no_proxy||"";return"*"===t||""!==t&&function uriInNoProxy(e,t){var a=e.port||("https:"===e.protocol?"443":"80"),o=formatHostname(e.hostname);return t.split(",").map(parseNoProxyZone).some(function(e){var t=o.indexOf(e.hostname),r=t>-1&&t===o.length-e.hostname.length;return e.hasPort?a===e.port&&r:r})}(e,t)?null:"http:"===e.protocol?process.env.HTTP_PROXY||process.env.http_proxy||null:"https:"===e.protocol&&(process.env.HTTPS_PROXY||process.env.https_proxy||process.env.HTTP_PROXY||process.env.http_proxy)||null}},37720:(e,t,a)=>{"use strict";var o=a(74765),r=Object.prototype.hasOwnProperty,i=Array.isArray,n=function(){for(var e=[],t=0;t<256;++t)e.push("%"+((t<16?"0":"")+t.toString(16)).toUpperCase());return e}(),s=function arrayToObject(e,t){for(var a=t&&t.plainObjects?{__proto__:null}:{},o=0;o<e.length;++o)void 0!==e[o]&&(a[o]=e[o]);return a},c=1024;e.exports={arrayToObject:s,assign:function assignSingleSource(e,t){return Object.keys(t).reduce(function(e,a){return e[a]=t[a],e},e)},combine:function combine(e,t){return[].concat(e,t)},compact:function compact(e){for(var t=[{obj:{o:e},prop:"o"}],a=[],o=0;o<t.length;++o)for(var r=t[o],n=r.obj[r.prop],s=Object.keys(n),c=0;c<s.length;++c){var p=s[c],u=n[p];"object"==typeof u&&null!==u&&-1===a.indexOf(u)&&(t.push({obj:n,prop:p}),a.push(u))}return function compactQueue(e){for(;e.length>1;){var t=e.pop(),a=t.obj[t.prop];if(i(a)){for(var o=[],r=0;r<a.length;++r)void 0!==a[r]&&o.push(a[r]);t.obj[t.prop]=o}}}(t),e},decode:function(e,t,a){var o=e.replace(/\+/g," ");if("iso-8859-1"===a)return o.replace(/%[0-9a-f]{2}/gi,unescape);try{return decodeURIComponent(o)}catch(e){return o}},encode:function encode(e,t,a,r,i){if(0===e.length)return e;var s=e;if("symbol"==typeof e?s=Symbol.prototype.toString.call(e):"string"!=typeof e&&(s=String(e)),"iso-8859-1"===a)return escape(s).replace(/%u[0-9a-f]{4}/gi,function(e){return"%26%23"+parseInt(e.slice(2),16)+"%3B"});for(var p="",u=0;u<s.length;u+=c){for(var l=s.length>=c?s.slice(u,u+c):s,m=[],f=0;f<l.length;++f){var h=l.charCodeAt(f);45===h||46===h||95===h||126===h||h>=48&&h<=57||h>=65&&h<=90||h>=97&&h<=122||i===o.RFC1738&&(40===h||41===h)?m[m.length]=l.charAt(f):h<128?m[m.length]=n[h]:h<2048?m[m.length]=n[192|h>>6]+n[128|63&h]:h<55296||h>=57344?m[m.length]=n[224|h>>12]+n[128|h>>6&63]+n[128|63&h]:(f+=1,h=65536+((1023&h)<<10|1023&l.charCodeAt(f)),m[m.length]=n[240|h>>18]+n[128|h>>12&63]+n[128|h>>6&63]+n[128|63&h])}p+=m.join("")}return p},isBuffer:function isBuffer(e){return!(!e||"object"!=typeof e)&&!!(e.constructor&&e.constructor.isBuffer&&e.constructor.isBuffer(e))},isRegExp:function isRegExp(e){return"[object RegExp]"===Object.prototype.toString.call(e)},maybeMap:function maybeMap(e,t){if(i(e)){for(var a=[],o=0;o<e.length;o+=1)a.push(t(e[o]));return a}return t(e)},merge:function merge(e,t,a){if(!t)return e;if("object"!=typeof t&&"function"!=typeof t){if(i(e))e.push(t);else{if(!e||"object"!=typeof e)return[e,t];(a&&(a.plainObjects||a.allowPrototypes)||!r.call(Object.prototype,t))&&(e[t]=!0)}return e}if(!e||"object"!=typeof e)return[e].concat(t);var o=e;return i(e)&&!i(t)&&(o=s(e,a)),i(e)&&i(t)?(t.forEach(function(t,o){if(r.call(e,o)){var i=e[o];i&&"object"==typeof i&&t&&"object"==typeof t?e[o]=merge(i,t,a):e.push(t)}else e[o]=t}),e):Object.keys(t).reduce(function(e,o){var i=t[o];return r.call(e,o)?e[o]=merge(e[o],i,a):e[o]=i,e},o)}}},37791:(e,t,a)=>{"use strict";var o=a(61177);t.permuteDomain=function permuteDomain(e){var t=o.getPublicSuffix(e);if(!t)return null;if(t==e)return[e];for(var a=e.slice(0,-(t.length+1)).split(".").reverse(),r=t,i=[r];a.length;)r=a.shift()+"."+r,i.push(r);return i}},38093:(e,t,a)=>{e.exports=a(39023).inspect},38203:e=>{"use strict";e.exports=JSON.parse('{"$id":"postData.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","optional":true,"required":["mimeType"],"properties":{"mimeType":{"type":"string"},"text":{"type":"string"},"params":{"type":"array","required":["name"],"properties":{"name":{"type":"string"},"value":{"type":"string"},"fileName":{"type":"string"},"contentType":{"type":"string"},"comment":{"type":"string"}}},"comment":{"type":"string"}}}')},38486:(e,t,a)=>{"use strict";const o=a(88997),r=new Set(["__proto__","prototype","constructor"]);function getPathSegments(e){const t=e.split("."),a=[];for(let e=0;e<t.length;e++){let o=t[e];for(;"\\"===o[o.length-1]&&void 0!==t[e+1];)o=o.slice(0,-1)+".",o+=t[++e];a.push(o)}return a.some(e=>r.has(e))?[]:a}e.exports={get(e,t,a){if(!o(e)||"string"!=typeof t)return void 0===a?e:a;const r=getPathSegments(t);if(0!==r.length){for(let t=0;t<r.length;t++)if(null==(e=e[r[t]])){if(t!==r.length-1)return a;break}return void 0===e?a:e}},set(e,t,a){if(!o(e)||"string"!=typeof t)return e;const r=e,i=getPathSegments(t);for(let t=0;t<i.length;t++){const r=i[t];o(e[r])||(e[r]={}),t===i.length-1&&(e[r]=a),e=e[r]}return r},delete(e,t){if(!o(e)||"string"!=typeof t)return!1;const a=getPathSegments(t);for(let t=0;t<a.length;t++){const r=a[t];if(t===a.length-1)return delete e[r],!0;if(e=e[r],!o(e))return!1}},has(e,t){if(!o(e)||"string"!=typeof t)return!1;const a=getPathSegments(t);if(0===a.length)return!1;for(let t=0;t<a.length;t++){if(!o(e))return!1;if(!(a[t]in e))return!1;e=e[a[t]]}return!0}}},38539:e=>{"use strict";e.exports=function generate_pattern(e,t,a){var o,r=" ",i=e.level,n=e.dataLevel,s=e.schema[t],c=e.schemaPath+e.util.getProperty(t),p=e.errSchemaPath+"/"+t,u=!e.opts.allErrors,l="data"+(n||""),m=e.opts.$data&&s&&s.$data;m?(r+=" var schema"+i+" = "+e.util.getData(s.$data,n,e.dataPathArr)+"; ",o="schema"+i):o=s,r+="if ( ",m&&(r+=" ("+o+" !== undefined && typeof "+o+" != 'string') || "),r+=" !"+(m?"(new RegExp("+o+"))":e.usePattern(s))+".test("+l+") ) {   ";var f=f||[];f.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(p)+" , params: { pattern:  ",r+=m?""+o:""+e.util.toQuotedString(s),r+="  } ",!1!==e.opts.messages&&(r+=" , message: 'should match pattern \"",r+=m?"' + "+o+" + '":""+e.util.escapeQuotes(s),r+="\"' "),e.opts.verbose&&(r+=" , schema:  ",r+=m?"validate.schema"+c:""+e.util.toQuotedString(s),r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+l+" "),r+=" } "):r+=" {} ";var h=r;return r=f.pop(),!e.compositeRule&&u?e.async?r+=" throw new ValidationError(["+h+"]); ":r+=" validate.errors = ["+h+"]; return false; ":r+=" var err = "+h+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",u&&(r+=" else { "),r}},38660:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(15765),r=a(99029),i=a(42023),n=a(25206),s=a(94227),c={keyword:"additionalProperties",type:["object"],schemaType:["boolean","object"],allowUndefined:!0,trackErrors:!0,error:{message:"should NOT have additional properties",params:({params:e})=>r._`{additionalProperty: ${e.additionalProperty}}`},code(e){const{gen:t,schema:a,parentSchema:c,data:p,errsCount:u,it:l}=e;if(!u)throw new Error("ajv implementation error");const{allErrors:m,opts:f}=l;if(l.props=!0,"all"!==f.removeAdditional&&s.alwaysValidSchema(l,a))return;const h=o.allSchemaProperties(c.properties),g=o.allSchemaProperties(c.patternProperties);function deleteAdditional(e){t.code(r._`delete ${p}[${e}]`)}function additionalPropertyCode(o){if("all"===f.removeAdditional||f.removeAdditional&&!1===a)deleteAdditional(o);else{if(!1===a)return e.setParams({additionalProperty:o}),e.error(),void(m||t.break());if("object"==typeof a&&!s.alwaysValidSchema(l,a)){const a=t.name("valid");"failing"===f.removeAdditional?(applyAdditionalSchema(o,a,!1),t.if(r.not(a),()=>{e.reset(),deleteAdditional(o)})):(applyAdditionalSchema(o,a),m||t.if(r.not(a),()=>t.break()))}}}function applyAdditionalSchema(t,a,o){const r={keyword:"additionalProperties",dataProp:t,dataPropType:n.Type.Str};!1===o&&Object.assign(r,{compositeRule:!0,createErrors:!1,allErrors:!1}),e.subschema(r,a)}!function checkAdditionalProperties(){t.forIn("key",p,e=>{h.length||g.length?t.if(function isAdditional(e){let a;if(h.length>8){const r=s.schemaRefOrVal(l,c.properties,"properties");a=o.isOwnProperty(t,r,e)}else a=h.length?r.or(...h.map(t=>r._`${e} === ${t}`)):r.nil;g.length&&(a=r.or(a,...g.map(a=>r._`${o.usePattern(t,a)}.test(${e})`)));return r.not(a)}(e),()=>additionalPropertyCode(e)):additionalPropertyCode(e)})}(),e.ok(r._`${u} === ${i.default.errors}`)}};t.default=c},38710:e=>{"use strict";e.exports=JSON.parse('{"name":"cos-nodejs-sdk-v5","version":"2.14.7","description":"cos nodejs sdk v5","main":"index.js","types":"index.d.ts","scripts":{"prettier":"prettier --write sdk demo/demo.js test/test.js index.d.ts","demo":"node demo/demo.js","demo-sts":"node demo/demo-sts.js","demo-sts-scope":"node demo/demo-sts-scope.js","test":"mocha test/test.js","cov":"istanbul cover _mocha -- -u exports \'test/test.js\'","nyc":"nyc --reporter=clover --reporter=cobertura mocha --reporter xunit --reporter-options output=mocha.xml test/test.js","csp":"mocha test/csp.js"},"repository":{"type":"git","url":"git+https://github.com/tencentyun/cos-nodejs-sdk-v5.git"},"keywords":["tencent","tencent cloud","qcloud","cos","cos-sdk"],"author":"carsonxu","license":"ISC","bugs":{"url":"https://github.com/tencentyun/cos-nodejs-sdk-v5/issues"},"homepage":"https://github.com/tencentyun/cos-nodejs-sdk-v5#readme","dependencies":{"conf":"^9.0.0","fast-xml-parser":"4.2.5","mime-types":"^2.1.24","request":"^2.88.2"},"devDependencies":{"@types/node":"^14.14.20","batch":"^0.6.1","crc64-ecma182.js":"^1.0.0","mocha":"^4.0.1","nyc":"^15.1.0","prettier":"^3.0.1","qcloud-cos-sts":"^3.0.0"},"engines":{"node":">= 6"}}')},38768:e=>{"use strict";e.exports=function generate_dependencies(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="errs__"+r,m=e.util.copy(e),f="";m.level++;var h="valid"+m.level,g={},y={},b=e.opts.ownProperties;for(j in n)if("__proto__"!=j){var x=n[j],w=Array.isArray(x)?y:g;w[j]=x}o+="var "+l+" = errors;";var k=e.errorPath;for(var j in o+="var missing"+r+";",y)if((w=y[j]).length){if(o+=" if ( "+u+e.util.getProperty(j)+" !== undefined ",b&&(o+=" && Object.prototype.hasOwnProperty.call("+u+", '"+e.util.escapeQuotes(j)+"') "),p){o+=" && ( ";var C=w;if(C)for(var P=-1,O=C.length-1;P<O;){V=C[P+=1],P&&(o+=" || "),o+=" ( ( "+(Y=u+(X=e.util.getProperty(V)))+" === undefined ",b&&(o+=" || ! Object.prototype.hasOwnProperty.call("+u+", '"+e.util.escapeQuotes(V)+"') "),o+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?V:X)+") ) "}o+=")) {  ";var I="missing"+r,z="' + "+I+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(k,I,!0):k+" + "+I);var q=q||[];q.push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { property: '"+e.util.escapeQuotes(j)+"', missingProperty: '"+z+"', depsCount: "+w.length+", deps: '"+e.util.escapeQuotes(1==w.length?w[0]:w.join(", "))+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should have ",1==w.length?o+="property "+e.util.escapeQuotes(w[0]):o+="properties "+e.util.escapeQuotes(w.join(", ")),o+=" when property "+e.util.escapeQuotes(j)+" is present' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var $=o;o=q.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+$+"]); ":o+=" validate.errors = ["+$+"]; return false; ":o+=" var err = "+$+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{o+=" ) { ";var H=w;if(H)for(var V,G=-1,W=H.length-1;G<W;){V=H[G+=1];var X=e.util.getProperty(V),Y=(z=e.util.escapeQuotes(V),u+X);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(k,V,e.opts.jsonPointers)),o+=" if ( "+Y+" === undefined ",b&&(o+=" || ! Object.prototype.hasOwnProperty.call("+u+", '"+e.util.escapeQuotes(V)+"') "),o+=") {  var err =   ",!1!==e.createErrors?(o+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { property: '"+e.util.escapeQuotes(j)+"', missingProperty: '"+z+"', depsCount: "+w.length+", deps: '"+e.util.escapeQuotes(1==w.length?w[0]:w.join(", "))+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should have ",1==w.length?o+="property "+e.util.escapeQuotes(w[0]):o+="properties "+e.util.escapeQuotes(w.join(", ")),o+=" when property "+e.util.escapeQuotes(j)+" is present' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}o+=" }   ",p&&(f+="}",o+=" else { ")}e.errorPath=k;var ee=m.baseId;for(var j in g){x=g[j];(e.opts.strictKeywords?"object"==typeof x&&Object.keys(x).length>0||!1===x:e.util.schemaHasRules(x,e.RULES.all))&&(o+=" "+h+" = true; if ( "+u+e.util.getProperty(j)+" !== undefined ",b&&(o+=" && Object.prototype.hasOwnProperty.call("+u+", '"+e.util.escapeQuotes(j)+"') "),o+=") { ",m.schema=x,m.schemaPath=s+e.util.getProperty(j),m.errSchemaPath=c+"/"+e.util.escapeFragment(j),o+="  "+e.validate(m)+" ",m.baseId=ee,o+=" }  ",p&&(o+=" if ("+h+") { ",f+="}"))}return p&&(o+="   "+f+" if ("+l+" == errors) {"),o}},38833:(e,t,a)=>{"use strict";const o=a(2203);e.exports=e=>e instanceof o||null!==e&&"object"==typeof e&&!!e.readable&&"function"==typeof e.pipe&&"function"==typeof e.read&&"boolean"==typeof e.readable&&"boolean"==typeof e.readableObjectMode&&"function"==typeof e.destroy&&"boolean"==typeof e.destroyed},39023:e=>{"use strict";e.exports=require("util")},39137:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseMapDef=void 0;const o=a(73524),r=a(87054);t.parseMapDef=function parseMapDef(e,t){return"record"===t.mapStrategy?(0,r.parseRecordDef)(e,t):{type:"array",maxItems:125,items:{type:"array",items:[(0,o.parseDef)(e.keyType._def,{...t,currentPath:[...t.currentPath,"items","items","0"]})||{},(0,o.parseDef)(e.valueType._def,{...t,currentPath:[...t.currentPath,"items","items","1"]})||{}],minItems:2,maxItems:2}}}},39228:(e,t,a)=>{"use strict";var o=a(96330)("cookies"),r=a(72760),i=a(58611),n=/^[\u0009\u0020-\u007e\u0080-\u00ff]+$/,s=/^(?:low|medium|high)$/i,c=Object.create(null),p=/[\^$\\.*+?()[\]{}|]/g,u=/[;=]/,l=/[;]/,m=/^(?:lax|none|strict)$/i;function Cookies(e,t,a){if(!(this instanceof Cookies))return new Cookies(e,t,a);this.secure=void 0,this.request=e,this.response=t,a&&(Array.isArray(a)?(o('"keys" argument; provide using options {"keys": [...]}'),this.keys=new r(a)):a.constructor&&"Keygrip"===a.constructor.name?(o('"keys" argument; provide using options {"keys": keygrip}'),this.keys=a):(this.keys=Array.isArray(a.keys)?new r(a.keys):a.keys,this.secure=a.secure))}function Cookie(e,t,a){if(!n.test(e)||u.test(e))throw new TypeError("argument name is invalid");if(t&&(!n.test(t)||l.test(t)))throw new TypeError("argument value is invalid");for(var e in this.name=e,this.value=t||"",a)this[e]=a[e];if(this.value||(this.expires=new Date(0),this.maxAge=null),this.path&&!n.test(this.path))throw new TypeError("option path is invalid");if(this.domain&&!n.test(this.domain))throw new TypeError("option domain is invalid");if("number"==typeof this.maxAge?isNaN(this.maxAge)||!isFinite(this.maxAge):this.maxAge)throw new TypeError("option maxAge is invalid");if(this.priority&&!s.test(this.priority))throw new TypeError("option priority is invalid");if(this.sameSite&&!0!==this.sameSite&&!m.test(this.sameSite))throw new TypeError("option sameSite is invalid")}function pushCookie(e,t){if(t.overwrite)for(var a=e.length-1;a>=0;a--)0===e[a].indexOf(t.name+"=")&&e.splice(a,1);e.push(t.toHeader())}Cookies.prototype.get=function(e,t){var a,o,r,i,n,s,u=e+".sig",l=t&&void 0!==t.signed?t.signed:!!this.keys;if((a=this.request.headers.cookie)&&(o=a.match(function getPattern(e){c[e]||(c[e]=new RegExp("(?:^|;) *"+e.replace(p,"\\$&")+"=([^;]*)"));return c[e]}(e)),o)){if('"'===(r=o[1])[0]&&(r=r.slice(1,-1)),!t||!l)return r;if(i=this.get(u)){if(n=e+"="+r,!this.keys)throw new Error(".keys required for signed cookies");if(!((s=this.keys.index(n,i))<0))return s&&this.set(u,this.keys.sign(n),{signed:!1}),r;this.set(u,null,{path:"/",signed:!1})}}},Cookies.prototype.set=function(e,t,a){var r=this.response,n=this.request,s=r.getHeader("Set-Cookie")||[],c=new Cookie(e,t,a),p=a&&void 0!==a.signed?a.signed:!!this.keys,u=void 0===this.secure?"https"===n.protocol||function isRequestEncrypted(e){return e.socket?e.socket.encrypted:e.connection.encrypted}(n):Boolean(this.secure);if("string"==typeof s&&(s=[s]),!u&&a&&a.secure)throw new Error("Cannot send secure cookie over unencrypted connection");if(c.secure=a&&void 0!==a.secure?a.secure:u,a&&"secureProxy"in a&&(o('"secureProxy" option; use "secure" option, provide "secure" to constructor if needed'),c.secure=a.secureProxy),pushCookie(s,c),a&&p){if(!this.keys)throw new Error(".keys required for signed cookies");c.value=this.keys.sign(c.toString()),c.name+=".sig",pushCookie(s,c)}return(r.set?i.OutgoingMessage.prototype.setHeader:r.setHeader).call(r,"Set-Cookie",s),this},Cookie.prototype.path="/",Cookie.prototype.expires=void 0,Cookie.prototype.domain=void 0,Cookie.prototype.httpOnly=!0,Cookie.prototype.partitioned=!1,Cookie.prototype.priority=void 0,Cookie.prototype.sameSite=!1,Cookie.prototype.secure=!1,Cookie.prototype.overwrite=!1,Cookie.prototype.toString=function(){return this.name+"="+this.value},Cookie.prototype.toHeader=function(){var e=this.toString();return this.maxAge&&(this.expires=new Date(Date.now()+this.maxAge)),this.path&&(e+="; path="+this.path),this.expires&&(e+="; expires="+this.expires.toUTCString()),this.domain&&(e+="; domain="+this.domain),this.priority&&(e+="; priority="+this.priority.toLowerCase()),this.sameSite&&(e+="; samesite="+(!0===this.sameSite?"strict":this.sameSite.toLowerCase())),this.secure&&(e+="; secure"),this.httpOnly&&(e+="; httponly"),this.partitioned&&(e+="; partitioned"),e},Object.defineProperty(Cookie.prototype,"maxage",{configurable:!0,enumerable:!0,get:function(){return this.maxAge},set:function(e){return this.maxAge=e}}),o.property(Cookie.prototype,"maxage",'"maxage"; use "maxAge" instead'),Cookies.connect=Cookies.express=function(e){return function(t,a,o){t.cookies=a.cookies=new Cookies(t,a,{keys:e}),o()}},Cookies.Cookie=Cookie,e.exports=Cookies},39290:e=>{"use strict";e.exports=JSON.parse('{"$id":"request.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","required":["method","url","httpVersion","cookies","headers","queryString","headersSize","bodySize"],"properties":{"method":{"type":"string"},"url":{"type":"string","format":"uri"},"httpVersion":{"type":"string"},"cookies":{"type":"array","items":{"$ref":"cookie.json#"}},"headers":{"type":"array","items":{"$ref":"header.json#"}},"queryString":{"type":"array","items":{"$ref":"query.json#"}},"postData":{"$ref":"postData.json#"},"headersSize":{"type":"integer"},"bodySize":{"type":"integer"},"comment":{"type":"string"}}}')},39340:function(e,t,a){"use strict";var o=this&&this.__createBinding||(Object.create?function(e,t,a,o){void 0===o&&(o=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,o,r)}:function(e,t,a,o){void 0===o&&(o=a),e[o]=t[a]}),r=this&&this.__exportStar||function(e,t){for(var a in e)"default"===a||Object.prototype.hasOwnProperty.call(t,a)||o(t,e,a)};Object.defineProperty(t,"__esModule",{value:!0}),r(a(92626),t),r(a(11076),t),r(a(98950),t),r(a(73524),t),r(a(20802),t),r(a(62909),t),r(a(98598),t),r(a(87236),t),r(a(28147),t),r(a(46163),t),r(a(16260),t),r(a(85187),t),r(a(29606),t),r(a(68385),t),r(a(76750),t),r(a(40686),t),r(a(34836),t),r(a(39137),t),r(a(96773),t),r(a(85618),t),r(a(37294),t),r(a(41854),t),r(a(31114),t),r(a(46172),t),r(a(65867),t),r(a(79225),t),r(a(93858),t),r(a(89729),t),r(a(87054),t),r(a(34519),t),r(a(73178),t),r(a(22793),t),r(a(97987),t),r(a(78348),t),r(a(95973),t),r(a(32465),t),r(a(34633),t);const i=a(34633);t.default=i.zodToJsonSchema},39954:(e,t,a)=>{var o=a(94742),r=a(76982),i=(a(58611),a(39023)),n=a(96716),s=a(14235),c=a(89320),p=a(39023).format,u=c.HASH_ALGOS,l=c.PK_ALGOS,m=c.InvalidAlgorithmError,f=c.HttpSignatureError,h=c.validateAlgorithm,g='Signature keyId="%s",algorithm="%s",headers="%s",signature="%s"';function MissingHeaderError(e){f.call(this,e,MissingHeaderError)}function StrictParsingError(e){f.call(this,e,StrictParsingError)}function RequestSigner(e){o.object(e,"options");var t=[];if(void 0!==e.algorithm&&(o.string(e.algorithm,"options.algorithm"),t=h(e.algorithm)),this.rs_alg=t,void 0!==e.sign)o.func(e.sign,"options.sign"),this.rs_signFunc=e.sign;else if("hmac"===t[0]&&void 0!==e.key){if(o.string(e.keyId,"options.keyId"),this.rs_keyId=e.keyId,"string"!=typeof e.key&&!Buffer.isBuffer(e.key))throw new TypeError("options.key for HMAC must be a string or Buffer");this.rs_signer=r.createHmac(t[1].toUpperCase(),e.key),this.rs_signer.sign=function(){var e=this.digest("base64");return{hashAlgorithm:t[1],toString:function(){return e}}}}else{if(void 0===e.key)throw new TypeError("options.sign (func) or options.key is required");var a=e.key;if(("string"==typeof a||Buffer.isBuffer(a))&&(a=n.parsePrivateKey(a)),o.ok(n.PrivateKey.isPrivateKey(a,[1,2]),"options.key must be a sshpk.PrivateKey"),this.rs_key=a,o.string(e.keyId,"options.keyId"),this.rs_keyId=e.keyId,!l[a.type])throw new m(a.type.toUpperCase()+" type keys are not supported");if(void 0!==t[0]&&a.type!==t[0])throw new m("options.key must be a "+t[0].toUpperCase()+" key, was given a "+a.type.toUpperCase()+" key instead");this.rs_signer=a.createSign(t[1])}this.rs_headers=[],this.rs_lines=[]}i.inherits(MissingHeaderError,f),i.inherits(StrictParsingError,f),RequestSigner.prototype.writeHeader=function(e,t){if(o.string(e,"header"),e=e.toLowerCase(),o.string(t,"value"),this.rs_headers.push(e),this.rs_signFunc)this.rs_lines.push(e+": "+t);else{var a=e+": "+t;this.rs_headers.length>0&&(a="\n"+a),this.rs_signer.update(a)}return t},RequestSigner.prototype.writeDateHeader=function(){return this.writeHeader("date",s.rfc1123(new Date))},RequestSigner.prototype.writeTarget=function(e,t){o.string(e,"method"),o.string(t,"path"),e=e.toLowerCase(),this.writeHeader("(request-target)",e+" "+t)},RequestSigner.prototype.sign=function(e){if(o.func(e,"callback"),this.rs_headers.length<1)throw new Error("At least one header must be signed");var t,a;if(this.rs_signFunc){var r=this.rs_lines.join("\n"),i=this;this.rs_signFunc(r,function(r,n){if(r)e(r);else{try{o.object(n,"signature"),o.string(n.keyId,"signature.keyId"),o.string(n.algorithm,"signature.algorithm"),o.string(n.signature,"signature.signature"),t=h(n.algorithm),a=p(g,n.keyId,n.algorithm,i.rs_headers.join(" "),n.signature)}catch(t){return void e(t)}e(null,a)}})}else{try{var n=this.rs_signer.sign()}catch(t){return void e(t)}t=(this.rs_alg[0]||this.rs_key.type)+"-"+n.hashAlgorithm;var s=n.toString();a=p(g,this.rs_keyId,t,this.rs_headers.join(" "),s),e(null,a)}},e.exports={isSigner:function(e){return"object"==typeof e&&e instanceof RequestSigner},createSigner:function createSigner(e){return new RequestSigner(e)},signRequest:function signRequest(e,t){o.object(e,"request"),o.object(t,"options"),o.optionalString(t.algorithm,"options.algorithm"),o.string(t.keyId,"options.keyId"),o.optionalArrayOfString(t.headers,"options.headers"),o.optionalString(t.httpVersion,"options.httpVersion"),e.getHeader("Date")||e.setHeader("Date",s.rfc1123(new Date)),t.headers||(t.headers=["date"]),t.httpVersion||(t.httpVersion="1.1");var a,i=[];t.algorithm&&(t.algorithm=t.algorithm.toLowerCase(),i=h(t.algorithm));var c,f="";for(a=0;a<t.headers.length;a++){if("string"!=typeof t.headers[a])throw new TypeError("options.headers must be an array of Strings");var y=t.headers[a].toLowerCase();if("request-line"===y){if(t.strict)throw new StrictParsingError("request-line is not a valid header with strict parsing enabled.");f+=e.method+" "+e.path+" HTTP/"+t.httpVersion}else if("(request-target)"===y)f+="(request-target): "+e.method.toLowerCase()+" "+e.path;else{var b=e.getHeader(y);if(void 0===b||""===b)throw new MissingHeaderError(y+" was not in the request");f+=y+": "+b}a+1<t.headers.length&&(f+="\n")}if(e.hasOwnProperty("_stringToSign")&&(e._stringToSign=f),"hmac"===i[0]){if("string"!=typeof t.key&&!Buffer.isBuffer(t.key))throw new TypeError("options.key must be a string or Buffer");var x=r.createHmac(i[1].toUpperCase(),t.key);x.update(f),c=x.digest("base64")}else{var w=t.key;if(("string"==typeof w||Buffer.isBuffer(w))&&(w=n.parsePrivateKey(t.key)),o.ok(n.PrivateKey.isPrivateKey(w,[1,2]),"options.key must be a sshpk.PrivateKey"),!l[w.type])throw new m(w.type.toUpperCase()+" type keys are not supported");if(void 0!==i[0]&&w.type!==i[0])throw new m("options.key must be a "+i[0].toUpperCase()+" key, was given a "+w.type.toUpperCase()+" key instead");var k=w.createSign(i[1]);k.update(f);var j=k.sign();if(!u[j.hashAlgorithm])throw new m(j.hashAlgorithm.toUpperCase()+" is not a supported hash algorithm");t.algorithm=w.type+"-"+j.hashAlgorithm,c=j.toString(),o.notStrictEqual(c,"","empty signature produced")}var C=t.authorizationHeaderName||"Authorization";return e.setHeader(C,p(g,t.keyId,t.algorithm,t.headers.join(" "),c)),!0}}},40117:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(13056),r=a(15765),i=a(94227),n=a(38660),s={keyword:"properties",type:"object",schemaType:"object",code(e){const{gen:t,schema:a,parentSchema:s,data:c,it:p}=e;"all"===p.opts.removeAdditional&&void 0===s.additionalProperties&&n.default.code(new o.default(p,n.default,"additionalProperties"));const u=r.allSchemaProperties(a);for(const e of u)p.definedProperties.add(e);p.opts.unevaluated&&u.length&&!0!==p.props&&(p.props=i.mergeEvaluated.props(t,i.toHash(u),p.props));const l=u.filter(e=>!i.alwaysValidSchema(p,a[e]));if(0===l.length)return;const m=t.name("valid");for(const a of l)hasDefault(a)?applyPropertySchema(a):(t.if(r.propertyInData(t,c,a,p.opts.ownProperties)),applyPropertySchema(a),p.allErrors||t.else().var(m,!0),t.endIf()),e.it.definedProperties.add(a),e.ok(m);function hasDefault(e){return p.opts.useDefaults&&!p.compositeRule&&void 0!==a[e].default}function applyPropertySchema(t){e.subschema({keyword:"properties",schemaProp:t,dataProp:t},m)}}};t.default=s},40137:(e,t,a)=>{"use strict";e.exports=function contentDisposition(e,t){var a=t||{},r=a.type||"attachment",i=function createparams(e,t){if(void 0===e)return;var a={};if("string"!=typeof e)throw new TypeError("filename must be a string");void 0===t&&(t=!0);if("string"!=typeof t&&"boolean"!=typeof t)throw new TypeError("fallback must be a string or boolean");if("string"==typeof t&&c.test(t))throw new TypeError("fallback must be ISO-8859-1 string");var r=o(e),i=m.test(r),s="string"!=typeof t?t&&getlatin1(r):o(t),p="string"==typeof s&&s!==r;(p||!i||n.test(r))&&(a["filename*"]=r);(i||p)&&(a.filename=p?s:r);return a}(e,a.fallback);return function format(e){var t=e.parameters,a=e.type;if(!a||"string"!=typeof a||!f.test(a))throw new TypeError("invalid type");var o=String(a).toLowerCase();if(t&&"object"==typeof t)for(var r,i=Object.keys(t).sort(),n=0;n<i.length;n++){var s="*"===(r=i[n]).substr(-1)?ustring(t[r]):qstring(t[r]);o+="; "+r+"="+s}return o}(new ContentDisposition(r,i))},e.exports.parse=function parse(e){if(!e||"string"!=typeof e)throw new TypeError("argument string is required");var t=g.exec(e);if(!t)throw new TypeError("invalid type format");var a,o,r=t[0].length,i=t[1].toLowerCase(),n=[],s={};r=l.lastIndex=";"===t[0].substr(-1)?r-1:r;for(;t=l.exec(e);){if(t.index!==r)throw new TypeError("invalid parameter format");if(r+=t[0].length,a=t[1].toLowerCase(),o=t[2],-1!==n.indexOf(a))throw new TypeError("invalid duplicate parameter");n.push(a),a.indexOf("*")+1!==a.length?"string"!=typeof s[a]&&('"'===o[0]&&(o=o.substr(1,o.length-2).replace(p,"$1")),s[a]=o):(a=a.slice(0,-1),o=decodefield(o),s[a]=o)}if(-1!==r&&r!==e.length)throw new TypeError("invalid parameter format");return new ContentDisposition(i,s)};var o=a(16928).basename,r=a(92861).Buffer,i=/[\x00-\x20"'()*,/:;<=>?@[\\\]{}\x7f]/g,n=/%[0-9A-Fa-f]{2}/,s=/%([0-9A-Fa-f]{2})/g,c=/[^\x20-\x7e\xa0-\xff]/g,p=/\\([\u0000-\u007f])/g,u=/([\\"])/g,l=/;[\x09\x20]*([!#$%&'*+.0-9A-Z^_`a-z|~-]+)[\x09\x20]*=[\x09\x20]*("(?:[\x20!\x23-\x5b\x5d-\x7e\x80-\xff]|\\[\x20-\x7e])*"|[!#$%&'*+.0-9A-Z^_`a-z|~-]+)[\x09\x20]*/g,m=/^[\x20-\x7e\x80-\xff]+$/,f=/^[!#$%&'*+.0-9A-Z^_`a-z|~-]+$/,h=/^([A-Za-z0-9!#$%&+\-^_`{}~]+)'(?:[A-Za-z]{2,3}(?:-[A-Za-z]{3}){0,3}|[A-Za-z]{4,8}|)'((?:%[0-9A-Fa-f]{2}|[A-Za-z0-9!#$&+.^_`|~-])+)$/,g=/^([!#$%&'*+.0-9A-Z^_`a-z|~-]+)[\x09\x20]*(?:$|;)/;function decodefield(e){var t=h.exec(e);if(!t)throw new TypeError("invalid extended field value");var a,o=t[1].toLowerCase(),i=t[2].replace(s,pdecode);switch(o){case"iso-8859-1":a=getlatin1(i);break;case"utf-8":a=r.from(i,"binary").toString("utf8");break;default:throw new TypeError("unsupported charset in extended field")}return a}function getlatin1(e){return String(e).replace(c,"?")}function pdecode(e,t){return String.fromCharCode(parseInt(t,16))}function pencode(e){return"%"+String(e).charCodeAt(0).toString(16).toUpperCase()}function qstring(e){return'"'+String(e).replace(u,"\\$1")+'"'}function ustring(e){var t=String(e);return"UTF-8''"+encodeURIComponent(t).replace(i,pencode)}function ContentDisposition(e,t){this.type=e,this.parameters=t}},40193:(e,t,a)=>{var o=a(42474),r=a(6176),i={};e.exports.transferToTaskMethod=function(e,t){i[t]=e[t],e[t]=function(e,a){e.SkipTask?i[t].call(this,e,a):this._addTask(t,e,a)}},e.exports.init=function(e){var t,a,n=[],s={},c=0,p=0,formatTask=function(e){var t={id:e.id,Bucket:e.Bucket,Region:e.Region,Key:e.Key,FilePath:e.FilePath,state:e.state,loaded:e.loaded,size:e.size,speed:e.speed,percent:e.percent,hashPercent:e.hashPercent,error:e.error};return e.FilePath&&(t.FilePath=e.FilePath),t},u=(a=function(){t=0,e.emit("task-list-update",{list:r.map(n,formatTask)}),e.emit("list-update",{list:r.map(n,formatTask)})},function(){t||(t=setTimeout(a))}),clearQueue=function(){if(!(n.length<=e.options.UploadQueueSize)){for(var t=0;t<p&&t<n.length&&n.length>e.options.UploadQueueSize;){var a="waiting"===n[t].state||"checking"===n[t].state||"uploading"===n[t].state;n[t]&&a?t++:(s[n[t].id]&&delete s[n[t].id],n.splice(t,1),p--)}u()}},startNextTask=function(){if(!(c>=e.options.FileParallelLimit)){for(;n[p]&&"waiting"!==n[p].state;)p++;if(!(p>=n.length)){var t=n[p];p++,c++,t.state="checking",t.params.onTaskStart&&t.params.onTaskStart(formatTask(t)),!t.params.UploadData&&(t.params.UploadData={});var a=r.formatParams(t.api,t.params);i[t.api].call(e,a,function(a,o){e._isRunningTask(t.id)&&("checking"!==t.state&&"uploading"!==t.state||(t.state=a?"error":"success",a&&(t.error=a),c--,u(),startNextTask(),t.callback&&t.callback(a,o),"success"===t.state&&(t.params&&(delete t.params.UploadData,delete t.params.Body,delete t.params),delete t.callback)),clearQueue())}),u(),setTimeout(startNextTask)}}},killTask=function(t,a){var r=s[t];if(r){var i=r&&"waiting"===r.state,n=r&&("checking"===r.state||"uploading"===r.state);if("canceled"===a&&"canceled"!==r.state||"paused"===a&&i||"paused"===a&&n){if("paused"===a&&r.params.Body&&"function"==typeof r.params.Body.pipe)return void console.error("stream not support pause");r.state=a,e.emit("inner-kill-task",{TaskId:t,toState:a});try{var p=r&&r.params&&r.params.UploadData.UploadId}catch(e){}"canceled"===a&&p&&o.removeUsing(p),u(),n&&(c--,startNextTask()),"canceled"===a&&(r.params&&(delete r.params.UploadData,delete r.params.Body,delete r.params),delete r.callback)}clearQueue()}};e._addTasks=function(t){r.each(t,function(t){e._addTask(t.api,t.params,t.callback,!0)}),u()};var l=!0;e._addTask=function(t,a,o,i){a=r.formatParams(t,a);var c=r.uuid();a.TaskId=c,a.onTaskReady&&a.onTaskReady(c),a.TaskReady&&(a.TaskReady(c),l&&console.warn('warning: Param "TaskReady" has been deprecated. Please use "onTaskReady" instead.'),l=!1);var p={params:a,callback:o,api:t,index:n.length,id:c,Bucket:a.Bucket,Region:a.Region,Key:a.Key,FilePath:a.FilePath||"",state:"waiting",loaded:0,size:0,speed:0,percent:0,hashPercent:0,error:null},m=a.onHashProgress;a.onHashProgress=function(t){e._isRunningTask(p.id)&&(p.hashPercent=t.percent,m&&m(t),u())};var f=a.onProgress;return a.onProgress=function(t){e._isRunningTask(p.id)&&("checking"===p.state&&(p.state="uploading"),p.loaded=t.loaded,p.speed=t.speed,p.percent=t.percent,f&&f(t),u())},r.getFileSize(t,a,function(e,t){if(e)return o(r.error(e));s[c]=p,n.push(p),p.size=t,!i&&u(),startNextTask(),clearQueue()}),c},e._isRunningTask=function(e){var t=s[e];return!(!t||"checking"!==t.state&&"uploading"!==t.state)},e.getTaskList=function(){return r.map(n,formatTask)},e.cancelTask=function(e){killTask(e,"canceled")},e.pauseTask=function(e){killTask(e,"paused")},e.restartTask=function(e){var t=s[e];!t||"paused"!==t.state&&"error"!==t.state||(t.state="waiting",u(),p=Math.min(p,t.index),startNextTask())},e.isUploadRunning=function(){return c||p<n.length}}},40627:function(e,t,a){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.getErrorMap=t.setErrorMap=t.defaultErrorMap=void 0;const r=o(a(68227));t.defaultErrorMap=r.default;let i=r.default;t.setErrorMap=function setErrorMap(e){i=e},t.getErrorMap=function getErrorMap(){return i}},40653:e=>{"use strict";e.exports={10029:"maccenteuro",maccenteuro:{type:"_sbcs",chars:"ÄĀāÉĄÖÜáąČäčĆćéŹźĎíďĒēĖóėôöõúĚěü†°Ę£§•¶ß®©™ę¨≠ģĮįĪ≤≥īĶ∂∑łĻļĽľĹĺŅņŃ¬√ńŇ∆«»… ňŐÕőŌ–—“”‘’÷◊ōŔŕŘ‹›řŖŗŠ‚„šŚśÁŤťÍŽžŪÓÔūŮÚůŰűŲųÝýķŻŁżĢˇ"},808:"cp808",ibm808:"cp808",cp808:{type:"_sbcs",chars:"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмноп░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀рстуфхцчшщъыьэюяЁёЄєЇїЎў°∙·√№€■ "},mik:{type:"_sbcs",chars:"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя└┴┬├─┼╣║╚╔╩╦╠═╬┐░▒▓│┤№§╗╝┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ "},ascii8bit:"ascii",usascii:"ascii",ansix34:"ascii",ansix341968:"ascii",ansix341986:"ascii",csascii:"ascii",cp367:"ascii",ibm367:"ascii",isoir6:"ascii",iso646us:"ascii",iso646irv:"ascii",us:"ascii",latin1:"iso88591",latin2:"iso88592",latin3:"iso88593",latin4:"iso88594",latin5:"iso88599",latin6:"iso885910",latin7:"iso885913",latin8:"iso885914",latin9:"iso885915",latin10:"iso885916",csisolatin1:"iso88591",csisolatin2:"iso88592",csisolatin3:"iso88593",csisolatin4:"iso88594",csisolatincyrillic:"iso88595",csisolatinarabic:"iso88596",csisolatingreek:"iso88597",csisolatinhebrew:"iso88598",csisolatin5:"iso88599",csisolatin6:"iso885910",l1:"iso88591",l2:"iso88592",l3:"iso88593",l4:"iso88594",l5:"iso88599",l6:"iso885910",l7:"iso885913",l8:"iso885914",l9:"iso885915",l10:"iso885916",isoir14:"iso646jp",isoir57:"iso646cn",isoir100:"iso88591",isoir101:"iso88592",isoir109:"iso88593",isoir110:"iso88594",isoir144:"iso88595",isoir127:"iso88596",isoir126:"iso88597",isoir138:"iso88598",isoir148:"iso88599",isoir157:"iso885910",isoir166:"tis620",isoir179:"iso885913",isoir199:"iso885914",isoir203:"iso885915",isoir226:"iso885916",cp819:"iso88591",ibm819:"iso88591",cyrillic:"iso88595",arabic:"iso88596",arabic8:"iso88596",ecma114:"iso88596",asmo708:"iso88596",greek:"iso88597",greek8:"iso88597",ecma118:"iso88597",elot928:"iso88597",hebrew:"iso88598",hebrew8:"iso88598",turkish:"iso88599",turkish8:"iso88599",thai:"iso885911",thai8:"iso885911",celtic:"iso885914",celtic8:"iso885914",isoceltic:"iso885914",tis6200:"tis620",tis62025291:"tis620",tis62025330:"tis620",1e4:"macroman",10006:"macgreek",10007:"maccyrillic",10079:"maciceland",10081:"macturkish",cspc8codepage437:"cp437",cspc775baltic:"cp775",cspc850multilingual:"cp850",cspcp852:"cp852",cspc862latinhebrew:"cp862",cpgr:"cp869",msee:"cp1250",mscyrl:"cp1251",msansi:"cp1252",msgreek:"cp1253",msturk:"cp1254",mshebr:"cp1255",msarab:"cp1256",winbaltrim:"cp1257",cp20866:"koi8r",20866:"koi8r",ibm878:"koi8r",cskoi8r:"koi8r",cp21866:"koi8u",21866:"koi8u",ibm1168:"koi8u",strk10482002:"rk1048",tcvn5712:"tcvn",tcvn57121:"tcvn",gb198880:"iso646cn",cn:"iso646cn",csiso14jisc6220ro:"iso646jp",jisc62201969ro:"iso646jp",jp:"iso646jp",cshproman8:"hproman8",r8:"hproman8",roman8:"hproman8",xroman8:"hproman8",ibm1051:"hproman8",mac:"macintosh",csmacintosh:"macintosh"}},40686:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseIntersectionDef=void 0;const o=a(73524);t.parseIntersectionDef=function parseIntersectionDef(e,t){const a=[(0,o.parseDef)(e.left._def,{...t,currentPath:[...t.currentPath,"allOf","0"]}),(0,o.parseDef)(e.right._def,{...t,currentPath:[...t.currentPath,"allOf","1"]})].filter(e=>!!e);let r="jsonSchema2019-09"===t.target?{unevaluatedProperties:!1}:void 0;const i=[];return a.forEach(e=>{if("type"in(t=e)&&"string"===t.type||!("allOf"in t)){let t=e;if("additionalProperties"in e&&!1===e.additionalProperties){const{additionalProperties:a,...o}=e;t=o}else r=void 0;i.push(t)}else i.push(...e.allOf),void 0===e.unevaluatedProperties&&(r=void 0);var t}),i.length?{allOf:i,...r}:void 0}},40736:(e,t,a)=>{e.exports=function setup(e){function createDebug(e){let t,a,o,r=null;function debug(...e){if(!debug.enabled)return;const a=debug,o=Number(new Date),r=o-(t||o);a.diff=r,a.prev=t,a.curr=o,t=o,e[0]=createDebug.coerce(e[0]),"string"!=typeof e[0]&&e.unshift("%O");let i=0;e[0]=e[0].replace(/%([a-zA-Z%])/g,(t,o)=>{if("%%"===t)return"%";i++;const r=createDebug.formatters[o];if("function"==typeof r){const o=e[i];t=r.call(a,o),e.splice(i,1),i--}return t}),createDebug.formatArgs.call(a,e);(a.log||createDebug.log).apply(a,e)}return debug.namespace=e,debug.useColors=createDebug.useColors(),debug.color=createDebug.selectColor(e),debug.extend=extend,debug.destroy=createDebug.destroy,Object.defineProperty(debug,"enabled",{enumerable:!0,configurable:!1,get:()=>null!==r?r:(a!==createDebug.namespaces&&(a=createDebug.namespaces,o=createDebug.enabled(e)),o),set:e=>{r=e}}),"function"==typeof createDebug.init&&createDebug.init(debug),debug}function extend(e,t){const a=createDebug(this.namespace+(void 0===t?":":t)+e);return a.log=this.log,a}function matchesTemplate(e,t){let a=0,o=0,r=-1,i=0;for(;a<e.length;)if(o<t.length&&(t[o]===e[a]||"*"===t[o]))"*"===t[o]?(r=o,i=a,o++):(a++,o++);else{if(-1===r)return!1;o=r+1,i++,a=i}for(;o<t.length&&"*"===t[o];)o++;return o===t.length}return createDebug.debug=createDebug,createDebug.default=createDebug,createDebug.coerce=function coerce(e){if(e instanceof Error)return e.stack||e.message;return e},createDebug.disable=function disable(){const e=[...createDebug.names,...createDebug.skips.map(e=>"-"+e)].join(",");return createDebug.enable(""),e},createDebug.enable=function enable(e){createDebug.save(e),createDebug.namespaces=e,createDebug.names=[],createDebug.skips=[];const t=("string"==typeof e?e:"").trim().replace(/\s+/g,",").split(",").filter(Boolean);for(const e of t)"-"===e[0]?createDebug.skips.push(e.slice(1)):createDebug.names.push(e)},createDebug.enabled=function enabled(e){for(const t of createDebug.skips)if(matchesTemplate(e,t))return!1;for(const t of createDebug.names)if(matchesTemplate(e,t))return!0;return!1},createDebug.humanize=a(6585),createDebug.destroy=function destroy(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")},Object.keys(e).forEach(t=>{createDebug[t]=e[t]}),createDebug.names=[],createDebug.skips=[],createDebug.formatters={},createDebug.selectColor=function selectColor(e){let t=0;for(let a=0;a<e.length;a++)t=(t<<5)-t+e.charCodeAt(a),t|=0;return createDebug.colors[Math.abs(t)%createDebug.colors.length]},createDebug.enable(createDebug.load()),createDebug}},40909:(e,t,a)=>{"use strict";const o=a(53908);e.exports=(e,t,a)=>{const r=new o(e,a),i=new o(t,a);return r.compare(i)||r.compareBuild(i)}},41237:e=>{"use strict";e.exports=EvalError},41261:(e,t,a)=>{"use strict";const o=a(53908),r=a(78311),i=a(35580);e.exports=(e,t)=>{e=new r(e,t);let a=new o("0.0.0");if(e.test(a))return a;if(a=new o("0.0.0-0"),e.test(a))return a;a=null;for(let t=0;t<e.set.length;++t){const r=e.set[t];let n=null;r.forEach(e=>{const t=new o(e.semver.version);switch(e.operator){case">":0===t.prerelease.length?t.patch++:t.prerelease.push(0),t.raw=t.format();case"":case">=":n&&!i(t,n)||(n=t);break;case"<":case"<=":break;default:throw new Error(`Unexpected operation: ${e.operator}`)}}),!n||a&&!i(a,n)||(a=n)}return a&&e.test(a)?a:null}},41333:e=>{"use strict";e.exports=function hasSymbols(){if("function"!=typeof Symbol||"function"!=typeof Object.getOwnPropertySymbols)return!1;if("symbol"==typeof Symbol.iterator)return!0;var e={},t=Symbol("test"),a=Object(t);if("string"==typeof t)return!1;if("[object Symbol]"!==Object.prototype.toString.call(t))return!1;if("[object Symbol]"!==Object.prototype.toString.call(a))return!1;for(var o in e[t]=42,e)return!1;if("function"==typeof Object.keys&&0!==Object.keys(e).length)return!1;if("function"==typeof Object.getOwnPropertyNames&&0!==Object.getOwnPropertyNames(e).length)return!1;var r=Object.getOwnPropertySymbols(e);if(1!==r.length||r[0]!==t)return!1;if(!Object.prototype.propertyIsEnumerable.call(e,t))return!1;if("function"==typeof Object.getOwnPropertyDescriptor){var i=Object.getOwnPropertyDescriptor(e,t);if(42!==i.value||!0!==i.enumerable)return!1}return!0}},41362:e=>{e.exports=function(e,t){return Object.keys(t).forEach(function(a){e[a]=e[a]||t[a]}),e}},41520:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getProperty=t.safeStringify=t.stringify=t.strConcat=t.addCodeArg=t.str=t._=t.nil=t._Code=t.Name=t.IDENTIFIER=t._CodeOrName=void 0;class _CodeOrName{}t._CodeOrName=_CodeOrName,t.IDENTIFIER=/^[a-z$_][a-z$_0-9]*$/i;class Name extends _CodeOrName{constructor(e){if(super(),!t.IDENTIFIER.test(e))throw new Error("CodeGen: name must be a valid identifier");this.str=e}toString(){return this.str}emptyStr(){return!1}get names(){return{[this.str]:1}}}t.Name=Name;class _Code extends _CodeOrName{constructor(e){super(),this._items="string"==typeof e?[e]:e}toString(){return this.str}emptyStr(){if(this._items.length>1)return!1;const e=this._items[0];return""===e||'""'===e}get str(){var e;return null!==(e=this._str)&&void 0!==e?e:this._str=this._items.reduce((e,t)=>`${e}${t}`,"")}get names(){var e;return null!==(e=this._names)&&void 0!==e?e:this._names=this._items.reduce((e,t)=>(t instanceof Name&&(e[t.str]=(e[t.str]||0)+1),e),{})}}function _(e,...t){const a=[e[0]];let o=0;for(;o<t.length;)addCodeArg(a,t[o]),a.push(e[++o]);return new _Code(a)}t._Code=_Code,t.nil=new _Code(""),t._=_;const a=new _Code("+");function str(e,...t){const o=[safeStringify(e[0])];let r=0;for(;r<t.length;)o.push(a),addCodeArg(o,t[r]),o.push(a,safeStringify(e[++r]));return function optimize(e){let t=1;for(;t<e.length-1;){if(e[t]===a){const a=mergeExprItems(e[t-1],e[t+1]);if(void 0!==a){e.splice(t-1,3,a);continue}e[t++]="+"}t++}}(o),new _Code(o)}function addCodeArg(e,t){t instanceof _Code?e.push(...t._items):t instanceof Name?e.push(t):e.push(function interpolate(e){return"number"==typeof e||"boolean"==typeof e||null===e?e:safeStringify(Array.isArray(e)?e.join(","):e)}(t))}function mergeExprItems(e,t){if('""'===t)return e;if('""'===e)return t;if("string"==typeof e){if(t instanceof Name||'"'!==e[e.length-1])return;return"string"!=typeof t?`${e.slice(0,-1)}${t}"`:'"'===t[0]?e.slice(0,-1)+t.slice(1):void 0}return"string"!=typeof t||'"'!==t[0]||e instanceof Name?void 0:`"${e}${t.slice(1)}`}function safeStringify(e){return JSON.stringify(e).replace(/\u2028/g,"\\u2028").replace(/\u2029/g,"\\u2029")}t.str=str,t.addCodeArg=addCodeArg,t.strConcat=function strConcat(e,t){return t.emptyStr()?e:e.emptyStr()?t:str`${e}${t}`},t.stringify=function stringify(e){return new _Code(safeStringify(e))},t.safeStringify=safeStringify,t.getProperty=function getProperty(e){return"string"==typeof e&&t.IDENTIFIER.test(e)?new _Code(`.${e}`):_`[${e}]`}},41524:(e,t,a)=>{e.exports=ForeverAgent,ForeverAgent.SSL=ForeverAgentSSL;var o=a(39023),r=a(58611).Agent,i=a(69278),n=a(64756),s=a(65692).Agent;function getConnectionName(e,t){return"string"==typeof e?e+":"+t:e.host+":"+e.port+":"+(e.localAddress?e.localAddress+":":":")}function ForeverAgent(e){var t=this;t.options=e||{},t.requests={},t.sockets={},t.freeSockets={},t.maxSockets=t.options.maxSockets||r.defaultMaxSockets,t.minSockets=t.options.minSockets||ForeverAgent.defaultMinSockets,t.on("free",function(e,a,o){var r=getConnectionName(a,o);if(t.requests[r]&&t.requests[r].length)t.requests[r].shift().onSocket(e);else if(t.sockets[r].length<t.minSockets){t.freeSockets[r]||(t.freeSockets[r]=[]),t.freeSockets[r].push(e);var onIdleError=function(){e.destroy()};e._onIdleError=onIdleError,e.on("error",onIdleError)}else e.destroy()})}function ForeverAgentSSL(e){ForeverAgent.call(this,e)}o.inherits(ForeverAgent,r),ForeverAgent.defaultMinSockets=5,ForeverAgent.prototype.createConnection=i.createConnection,ForeverAgent.prototype.addRequestNoreuse=r.prototype.addRequest,ForeverAgent.prototype.addRequest=function(e,t,a){var o=getConnectionName(t,a);if("string"!=typeof t){var r=t;a=r.port,t=r.host}if(this.freeSockets[o]&&this.freeSockets[o].length>0&&!e.useChunkedEncodingByDefault){var i=this.freeSockets[o].pop();i.removeListener("error",i._onIdleError),delete i._onIdleError,e._reusedSocket=!0,e.onSocket(i)}else this.addRequestNoreuse(e,t,a)},ForeverAgent.prototype.removeSocket=function(e,t,a,o){var r;this.sockets[t]?-1!==(r=this.sockets[t].indexOf(e))&&this.sockets[t].splice(r,1):this.sockets[t]&&0===this.sockets[t].length&&(delete this.sockets[t],delete this.requests[t]);this.freeSockets[t]&&(-1!==(r=this.freeSockets[t].indexOf(e))&&(this.freeSockets[t].splice(r,1),0===this.freeSockets[t].length&&delete this.freeSockets[t]));this.requests[t]&&this.requests[t].length&&this.createSocket(t,a,o).emit("free")},o.inherits(ForeverAgentSSL,ForeverAgent),ForeverAgentSSL.prototype.createConnection=function createConnectionSSL(e,t,a){"object"==typeof e?a=e:"object"==typeof t?a=t:"object"==typeof a||(a={});"number"==typeof e&&(a.port=e);"string"==typeof t&&(a.host=t);return n.connect(a)},ForeverAgentSSL.prototype.addRequestNoreuse=s.prototype.addRequest},41854:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseNullableDef=void 0;const o=a(73524),r=a(78348);t.parseNullableDef=function parseNullableDef(e,t){if(["ZodString","ZodNumber","ZodBigInt","ZodBoolean","ZodNull"].includes(e.innerType._def.typeName)&&(!e.innerType._def.checks||!e.innerType._def.checks.length))return"openApi3"===t.target?{type:r.primitiveMappings[e.innerType._def.typeName],nullable:!0}:{type:[r.primitiveMappings[e.innerType._def.typeName],"null"]};if("openApi3"===t.target){const a=(0,o.parseDef)(e.innerType._def,{...t,currentPath:[...t.currentPath]});return a&&"$ref"in a?{allOf:[a],nullable:!0}:a&&{...a,nullable:!0}}const a=(0,o.parseDef)(e.innerType._def,{...t,currentPath:[...t.currentPath,"anyOf","0"]});return a&&{anyOf:[a,{type:"null"}]}}},42023:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(99029),r={data:new o.Name("data"),valCxt:new o.Name("valCxt"),dataPath:new o.Name("dataPath"),parentData:new o.Name("parentData"),parentDataProperty:new o.Name("parentDataProperty"),rootData:new o.Name("rootData"),dynamicAnchors:new o.Name("dynamicAnchors"),vErrors:new o.Name("vErrors"),errors:new o.Name("errors"),this:new o.Name("this"),self:new o.Name("self"),scope:new o.Name("scope"),json:new o.Name("json"),jsonPos:new o.Name("jsonPos"),jsonLen:new o.Name("jsonLen"),jsonPart:new o.Name("jsonPart")};t.default=r},42474:(e,t,a)=>{var o,r,i,n=a(6176),s="cos_sdk_upload_cache",getCache=function(){var e,t={configName:"cos-nodejs-sdk-v5-storage"};this.options.ConfCwd&&(t.cwd=this.options.ConfCwd);try{var i=a(62888);e=(o=new i(t)).get(s)}catch(e){}e&&e instanceof Array||(e=[]),r=e},setCache=function(){try{r.length?o.set(s,r):o.delete(s)}catch(e){}},init=function(){if(!r){getCache.call(this);for(var e=!1,t=Math.round(Date.now()/1e3),a=r.length-1;a>=0;a--){var o=r[a][2];(!o||o+2592e3<t)&&(r.splice(a,1),e=!0)}e&&setCache()}},save=function(){i||(i=setTimeout(function(){setCache(),i=null},400))},c={using:{},setUsing:function(e){c.using[e]=!0},removeUsing:function(e){delete c.using[e]},getFileId:function(e,t,a,o){return e&&e.FilePath&&e.size&&e.ctime&&e.mtime&&t?n.md5([e.FilePath].join("::"))+"-"+n.md5([e.size,e.ctime,e.mtime,t,a,o].join("::")):null},getCopyFileId:function(e,t,a,o,r){var i=t["content-length"],s=t.etag||"",c=t["last-modified"];return e&&a?n.md5([e,i,s,c,a,o,r].join("::")):null},getUploadIdList:function(e){if(!e)return null;init.call(this);for(var t=[],a=0;a<r.length;a++)r[a][0]===e&&t.push(r[a][1]);return t.length?t:null},saveUploadId:function(e,t,a){if(init.call(this),e){for(var o=e.substr(0,e.indexOf("-")+1),i=r.length-1;i>=0;i--){var n=r[i];(n[0]===e&&n[1]===t||e!==n[0]&&0===n[0].indexOf(o))&&r.splice(i,1)}r.unshift([e,t,Math.round(Date.now()/1e3)]),r.length>a&&r.splice(a),save()}},removeUploadId:function(e){init.call(this),delete c.using[e];for(var t=r.length-1;t>=0;t--)r[t][1]===e&&r.splice(t,1);save()}};e.exports=c},42498:(e,t,a)=>{e.exports={Verifier,Signer};var o=a(88947),r=a(2203),i=a(39023),n=a(94742),s=a(54774).Buffer,c=a(57114);function Verifier(e,t){if("sha512"!==t.toLowerCase())throw new Error("ED25519 only supports the use of SHA-512 hashes");this.key=e,this.chunks=[],r.Writable.call(this,{})}function Signer(e,t){if("sha512"!==t.toLowerCase())throw new Error("ED25519 only supports the use of SHA-512 hashes");this.key=e,this.chunks=[],r.Writable.call(this,{})}i.inherits(Verifier,r.Writable),Verifier.prototype._write=function(e,t,a){this.chunks.push(e),a()},Verifier.prototype.update=function(e){"string"==typeof e&&(e=s.from(e,"binary")),this.chunks.push(e)},Verifier.prototype.verify=function(e,t){var a;if(c.isSignature(e,[2,0])){if("ed25519"!==e.type)return!1;a=e.toBuffer("raw")}else if("string"==typeof e)a=s.from(e,"base64");else if(c.isSignature(e,[1,0]))throw new Error("signature was created by too old a version of sshpk and cannot be verified");return n.buffer(a),o.sign.detached.verify(new Uint8Array(s.concat(this.chunks)),new Uint8Array(a),new Uint8Array(this.key.part.A.data))},i.inherits(Signer,r.Writable),Signer.prototype._write=function(e,t,a){this.chunks.push(e),a()},Signer.prototype.update=function(e){"string"==typeof e&&(e=s.from(e,"binary")),this.chunks.push(e)},Signer.prototype.sign=function(){var e=o.sign.detached(new Uint8Array(s.concat(this.chunks)),new Uint8Array(s.concat([this.key.part.k.data,this.key.part.A.data]))),t=s.from(e),a=c.parse(t,"ed25519","raw");return a.hashAlgorithm="sha512",a}},42613:e=>{"use strict";e.exports=require("assert")},43083:e=>{"use strict";e.exports=JSON.parse('{"$id":"browser.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","required":["name","version"],"properties":{"name":{"type":"string"},"version":{"type":"string"},"comment":{"type":"string"}}}')},43106:e=>{"use strict";e.exports=require("zlib")},43809:(e,t,a)=>{e.exports={read:function read(e,t,a){var c=e;"string"!=typeof e&&(o.buffer(e,"buf"),e=e.toString("ascii"));var p,x,k=e.trim().split(/[\r\n]+/g),j=-1;for(;!p&&j<k.length;)p=k[++j].match(/[-]+[ ]*BEGIN ([A-Z0-9][A-Za-z0-9]+ )?(PUBLIC|PRIVATE) KEY[ ]*[-]+/);o.ok(p,"invalid PEM header");var C=k.length;for(;!x&&C>0;)x=k[--C].match(/[-]+[ ]*END ([A-Z0-9][A-Za-z0-9]+ )?(PUBLIC|PRIVATE) KEY[ ]*[-]+/);o.ok(x,"invalid PEM footer"),o.equal(p[2],x[2]);var P,O=p[2].toLowerCase();p[1]&&(o.equal(p[1],x[1],"PEM header and footer mismatch"),P=p[1].trim());k=k.slice(j,C+1);var I,z,q,$={};for(;p=(k=k.slice(1))[0].match(/^([A-Za-z0-9-]+): (.+)$/);)$[p[1].toLowerCase()]=p[2];if(k=k.slice(0,-1).join(""),e=n.from(k,"base64"),$["proc-type"]){var H=$["proc-type"].split(",");if("4"===H[0]&&"ENCRYPTED"===H[1]){if("string"==typeof t.passphrase&&(t.passphrase=n.from(t.passphrase,"utf-8")),!n.isBuffer(t.passphrase))throw new h.KeyEncryptedError(t.filename,"PEM");H=$["dek-info"].split(","),o.ok(2===H.length),I=H[0].toLowerCase(),q=n.from(H[1],"hex"),z=s.opensslKeyDeriv(I,q,t.passphrase,1).key}}if(P&&"encrypted"===P.toLowerCase()){var V,G=new r.BerReader(e);G.readSequence(),G.readSequence(),V=G.offset+G.length;var W=G.readOID();if(W!==g)throw new Error("Unsupported PEM/PKCS8 encryption scheme: "+W);G.readSequence(),G.readSequence();var X=G.offset+G.length,Y=G.readOID();if(Y!==y)throw new Error("Unsupported PBES2 KDF: "+Y);G.readSequence();var ee=G.readString(r.Ber.OctetString,!0),te=G.readInt(),ae="sha1";if(G.offset<X){G.readSequence();var oe=G.readOID();if(void 0===(ae=w[oe]))throw new Error("Unsupported PBKDF2 hash: "+oe)}G._offset=X,G.readSequence();var re=G.readOID();if(void 0===(I=b[re]))throw new Error("Unsupported PBES2 cipher: "+re);if(q=G.readString(r.Ber.OctetString,!0),G._offset=V,e=G.readString(r.Ber.OctetString,!0),"string"==typeof t.passphrase&&(t.passphrase=n.from(t.passphrase,"utf-8")),!n.isBuffer(t.passphrase))throw new h.KeyEncryptedError(t.filename,"PEM");var ie=s.opensshCipherInfo(I);I=ie.opensslName,z=s.pbkdf2(ae,ee,te,ie.keySize,t.passphrase),P=void 0}if(I&&z&&q){var ne,se=i.createDecipheriv(I,z,q),ce=[];for(se.once("error",function(e){if(-1!==e.toString().indexOf("bad decrypt"))throw new Error("Incorrect passphrase supplied, could not decrypt key");throw e}),se.write(e),se.end();null!==(ne=se.read());)ce.push(ne);e=n.concat(ce)}if(P&&"openssh"===P.toLowerCase())return m.readSSHPrivate(O,e,t);if(P&&"ssh2"===P.toLowerCase())return f.readType(O,e,t);var pe=new r.BerReader(e);return pe.originalInput=c,pe.readSequence(),P?(a&&o.strictEqual(a,"pkcs1"),u.readPkcs1(P,O,pe)):(a&&o.strictEqual(a,"pkcs8"),l.readPkcs8(P,O,pe))},write:function write(e,t,a){o.object(e);var i,s={ecdsa:"EC",rsa:"RSA",dsa:"DSA",ed25519:"EdDSA"}[e.type],m=new r.BerWriter;if(p.isPrivateKey(e))a&&"pkcs8"===a?(i="PRIVATE KEY",l.writePkcs8(m,e)):(a&&o.strictEqual(a,"pkcs1"),i=s+" PRIVATE KEY",u.writePkcs1(m,e));else{if(!c.isKey(e))throw new Error("key is not a Key or PrivateKey");a&&"pkcs1"===a?(i=s+" PUBLIC KEY",u.writePkcs1(m,e)):(a&&o.strictEqual(a,"pkcs8"),i="PUBLIC KEY",l.writePkcs8(m,e))}var f=m.buffer.toString("base64"),h=f.length+f.length/64+18+16+2*i.length+10,g=n.alloc(h),y=0;y+=g.write("-----BEGIN "+i+"-----\n",y);for(var b=0;b<f.length;){var x=b+64;x>f.length&&(x=f.length),y+=g.write(f.slice(b,x),y),g[y++]=10,b=x}return y+=g.write("-----END "+i+"-----\n",y),g.slice(0,y)}};var o=a(94742),r=a(53100),i=a(76982),n=a(54774).Buffer,s=(a(6641),a(87461)),c=a(64479),p=a(90009),u=a(46397),l=a(78038),m=a(91243),f=a(34348),h=a(31741),g="1.2.840.113549.1.5.13",y="1.2.840.113549.1.5.12",b={"1.2.840.113549.3.7":"3des-cbc","2.16.840.1.101.3.4.1.2":"aes128-cbc","2.16.840.1.101.3.4.1.42":"aes256-cbc"},x={};Object.keys(b).forEach(function(e){x[b[e]]=e});var w={"1.2.840.113549.2.7":"sha1","1.2.840.113549.2.9":"sha256","1.2.840.113549.2.11":"sha512"},k={};Object.keys(w).forEach(function(e){k[w[e]]=e})},43918:(e,t,a)=>{"use strict";const o=a(35334),r={allowBooleanAttributes:!1,unpairedTags:[]};function isWhiteSpace(e){return" "===e||"\t"===e||"\n"===e||"\r"===e}function readPI(e,t){const a=t;for(;t<e.length;t++)if("?"==e[t]||" "==e[t]){const o=e.substr(a,t-a);if(t>5&&"xml"===o)return getErrorObject("InvalidXml","XML declaration allowed only at the start of the document.",getLineNumberForPosition(e,t));if("?"==e[t]&&">"==e[t+1]){t++;break}continue}return t}function readCommentAndCDATA(e,t){if(e.length>t+5&&"-"===e[t+1]&&"-"===e[t+2]){for(t+=3;t<e.length;t++)if("-"===e[t]&&"-"===e[t+1]&&">"===e[t+2]){t+=2;break}}else if(e.length>t+8&&"D"===e[t+1]&&"O"===e[t+2]&&"C"===e[t+3]&&"T"===e[t+4]&&"Y"===e[t+5]&&"P"===e[t+6]&&"E"===e[t+7]){let a=1;for(t+=8;t<e.length;t++)if("<"===e[t])a++;else if(">"===e[t]&&(a--,0===a))break}else if(e.length>t+9&&"["===e[t+1]&&"C"===e[t+2]&&"D"===e[t+3]&&"A"===e[t+4]&&"T"===e[t+5]&&"A"===e[t+6]&&"["===e[t+7])for(t+=8;t<e.length;t++)if("]"===e[t]&&"]"===e[t+1]&&">"===e[t+2]){t+=2;break}return t}t.validate=function(e,t){t=Object.assign({},r,t);const a=[];let o=!1,i=!1;"\ufeff"===e[0]&&(e=e.substr(1));for(let r=0;r<e.length;r++)if("<"===e[r]&&"?"===e[r+1]){if(r+=2,r=readPI(e,r),r.err)return r}else{if("<"!==e[r]){if(isWhiteSpace(e[r]))continue;return getErrorObject("InvalidChar","char '"+e[r]+"' is not expected.",getLineNumberForPosition(e,r))}{let n=r;if(r++,"!"===e[r]){r=readCommentAndCDATA(e,r);continue}{let s=!1;"/"===e[r]&&(s=!0,r++);let c="";for(;r<e.length&&">"!==e[r]&&" "!==e[r]&&"\t"!==e[r]&&"\n"!==e[r]&&"\r"!==e[r];r++)c+=e[r];if(c=c.trim(),"/"===c[c.length-1]&&(c=c.substring(0,c.length-1),r--),!validateTagName(c)){let t;return t=0===c.trim().length?"Invalid space after '<'.":"Tag '"+c+"' is an invalid name.",getErrorObject("InvalidTag",t,getLineNumberForPosition(e,r))}const p=readAttributeStr(e,r);if(!1===p)return getErrorObject("InvalidAttr","Attributes for '"+c+"' have open quote.",getLineNumberForPosition(e,r));let u=p.value;if(r=p.index,"/"===u[u.length-1]){const a=r-u.length;u=u.substring(0,u.length-1);const i=validateAttributeString(u,t);if(!0!==i)return getErrorObject(i.err.code,i.err.msg,getLineNumberForPosition(e,a+i.err.line));o=!0}else if(s){if(!p.tagClosed)return getErrorObject("InvalidTag","Closing tag '"+c+"' doesn't have proper closing.",getLineNumberForPosition(e,r));if(u.trim().length>0)return getErrorObject("InvalidTag","Closing tag '"+c+"' can't have attributes or invalid starting.",getLineNumberForPosition(e,n));{const t=a.pop();if(c!==t.tagName){let a=getLineNumberForPosition(e,t.tagStartPos);return getErrorObject("InvalidTag","Expected closing tag '"+t.tagName+"' (opened in line "+a.line+", col "+a.col+") instead of closing tag '"+c+"'.",getLineNumberForPosition(e,n))}0==a.length&&(i=!0)}}else{const s=validateAttributeString(u,t);if(!0!==s)return getErrorObject(s.err.code,s.err.msg,getLineNumberForPosition(e,r-u.length+s.err.line));if(!0===i)return getErrorObject("InvalidXml","Multiple possible root nodes found.",getLineNumberForPosition(e,r));-1!==t.unpairedTags.indexOf(c)||a.push({tagName:c,tagStartPos:n}),o=!0}for(r++;r<e.length;r++)if("<"===e[r]){if("!"===e[r+1]){r++,r=readCommentAndCDATA(e,r);continue}if("?"!==e[r+1])break;if(r=readPI(e,++r),r.err)return r}else if("&"===e[r]){const t=validateAmpersand(e,r);if(-1==t)return getErrorObject("InvalidChar","char '&' is not expected.",getLineNumberForPosition(e,r));r=t}else if(!0===i&&!isWhiteSpace(e[r]))return getErrorObject("InvalidXml","Extra text at the end",getLineNumberForPosition(e,r));"<"===e[r]&&r--}}}return o?1==a.length?getErrorObject("InvalidTag","Unclosed tag '"+a[0].tagName+"'.",getLineNumberForPosition(e,a[0].tagStartPos)):!(a.length>0)||getErrorObject("InvalidXml","Invalid '"+JSON.stringify(a.map(e=>e.tagName),null,4).replace(/\r?\n/g,"")+"' found.",{line:1,col:1}):getErrorObject("InvalidXml","Start tag expected.",1)};const i='"',n="'";function readAttributeStr(e,t){let a="",o="",r=!1;for(;t<e.length;t++){if(e[t]===i||e[t]===n)""===o?o=e[t]:o!==e[t]||(o="");else if(">"===e[t]&&""===o){r=!0;break}a+=e[t]}return""===o&&{value:a,index:t,tagClosed:r}}const s=new RegExp("(\\s*)([^\\s=]+)(\\s*=)?(\\s*(['\"])(([\\s\\S])*?)\\5)?","g");function validateAttributeString(e,t){const a=o.getAllMatches(e,s),r={};for(let e=0;e<a.length;e++){if(0===a[e][1].length)return getErrorObject("InvalidAttr","Attribute '"+a[e][2]+"' has no space in starting.",getPositionFromMatch(a[e]));if(void 0!==a[e][3]&&void 0===a[e][4])return getErrorObject("InvalidAttr","Attribute '"+a[e][2]+"' is without value.",getPositionFromMatch(a[e]));if(void 0===a[e][3]&&!t.allowBooleanAttributes)return getErrorObject("InvalidAttr","boolean attribute '"+a[e][2]+"' is not allowed.",getPositionFromMatch(a[e]));const o=a[e][2];if(!validateAttrName(o))return getErrorObject("InvalidAttr","Attribute '"+o+"' is an invalid name.",getPositionFromMatch(a[e]));if(r.hasOwnProperty(o))return getErrorObject("InvalidAttr","Attribute '"+o+"' is repeated.",getPositionFromMatch(a[e]));r[o]=1}return!0}function validateAmpersand(e,t){if(";"===e[++t])return-1;if("#"===e[t])return function validateNumberAmpersand(e,t){let a=/\d/;for("x"===e[t]&&(t++,a=/[\da-fA-F]/);t<e.length;t++){if(";"===e[t])return t;if(!e[t].match(a))break}return-1}(e,++t);let a=0;for(;t<e.length;t++,a++)if(!(e[t].match(/\w/)&&a<20)){if(";"===e[t])break;return-1}return t}function getErrorObject(e,t,a){return{err:{code:e,msg:t,line:a.line||a,col:a.col}}}function validateAttrName(e){return o.isName(e)}function validateTagName(e){return o.isName(e)}function getLineNumberForPosition(e,t){const a=e.substring(0,t).split(/\r?\n/);return{line:a.length,col:a[a.length-1].length+1}}function getPositionFromMatch(e){return e.startIndex+e[1].length}},43927:(e,t,a)=>{"use strict";const o=a(40909);e.exports=(e,t)=>e.sort((e,a)=>o(e,a,t))},44106:(e,t)=>{function serializer(e,t){var a=[],o=[];return null==t&&(t=function(e,t){return a[0]===t?"[Circular ~]":"[Circular ~."+o.slice(0,a.indexOf(t)).join(".")+"]"}),function(r,i){if(a.length>0){var n=a.indexOf(this);~n?a.splice(n+1):a.push(this),~n?o.splice(n,1/0,r):o.push(r),~a.indexOf(i)&&(i=t.call(this,r,i))}else a.push(i);return null==e?i:e.call(this,r,i)}}(e.exports=function stringify(e,t,a,o){return JSON.stringify(e,serializer(t,o),a)}).getSerialize=serializer},44954:(e,t,a)=>{"use strict";var o=a(12550),r=a(80801),i=a(54181),n=a(92861).Buffer;function Multipart(e){this.request=e,this.boundary=o(),this.chunked=!1,this.body=null}Multipart.prototype.isChunked=function(e){var t=this,a=!1,o=e.data||e;return o.forEach||t.request.emit("error",new Error("Argument error, options.multipart.")),void 0!==e.chunked&&(a=e.chunked),"chunked"===t.request.getHeader("transfer-encoding")&&(a=!0),a||o.forEach(function(e){void 0===e.body&&t.request.emit("error",new Error("Body attribute missing in multipart.")),i(e.body)&&(a=!0)}),a},Multipart.prototype.setHeaders=function(e){var t=this;e&&!t.request.hasHeader("transfer-encoding")&&t.request.setHeader("transfer-encoding","chunked");var a=t.request.getHeader("content-type");a&&-1!==a.indexOf("multipart")?-1!==a.indexOf("boundary")?t.boundary=a.replace(/.*boundary=([^\s;]+).*/,"$1"):t.request.setHeader("content-type",a+"; boundary="+t.boundary):t.request.setHeader("content-type","multipart/related; boundary="+t.boundary)},Multipart.prototype.build=function(e,t){var a=this,o=t?new r:[];function add(e){return"number"==typeof e&&(e=e.toString()),t?o.append(e):o.push(n.from(e))}return a.request.preambleCRLF&&add("\r\n"),e.forEach(function(e){var t="--"+a.boundary+"\r\n";Object.keys(e).forEach(function(a){"body"!==a&&(t+=a+": "+e[a]+"\r\n")}),add(t+="\r\n"),add(e.body),add("\r\n")}),add("--"+a.boundary+"--"),a.request.postambleCRLF&&add("\r\n"),o},Multipart.prototype.onRequest=function(e){var t=this,a=t.isChunked(e),o=e.data||e;t.setHeaders(a),t.chunked=a,t.body=t.build(o,a)},t.F=Multipart},45020:(e,t,a)=>{e.exports=Identity;var o=a(94742),r=(a(6641),a(76982),a(61244),a(57114),a(31741),a(39023),a(87461)),i=a(53100),n=a(54774).Buffer,s=/^([*]|[a-z0-9][a-z0-9\-]{0,62})(?:\.([*]|[a-z0-9][a-z0-9\-]{0,62}))*$/i,c={cn:"2.5.4.3",o:"2.5.4.10",ou:"2.5.4.11",l:"2.5.4.7",s:"2.5.4.8",c:"2.5.4.6",sn:"2.5.4.4",postalCode:"2.5.4.17",serialNumber:"2.5.4.5",street:"2.5.4.9",x500UniqueIdentifier:"2.5.4.45",role:"2.5.4.72",telephoneNumber:"2.5.4.20",description:"2.5.4.13",dc:"0.9.2342.19200300.100.1.25",uid:"0.9.2342.19200300.100.1.1",mail:"0.9.2342.19200300.100.1.3",title:"2.5.4.12",gn:"2.5.4.42",initials:"2.5.4.43",pseudonym:"2.5.4.65",emailAddress:"1.2.840.113549.1.9.1"},p={};function Identity(e){var t=this;if(o.object(e,"options"),o.arrayOfObject(e.components,"options.components"),this.components=e.components,this.componentLookup={},this.components.forEach(function(e){e.name&&!e.oid&&(e.oid=c[e.name]),e.oid&&!e.name&&(e.name=p[e.oid]),void 0===t.componentLookup[e.name]&&(t.componentLookup[e.name]=[]),t.componentLookup[e.name].push(e)}),this.componentLookup.cn&&this.componentLookup.cn.length>0&&(this.cn=this.componentLookup.cn[0].value),o.optionalString(e.type,"options.type"),void 0===e.type)1===this.components.length&&this.componentLookup.cn&&1===this.componentLookup.cn.length&&this.componentLookup.cn[0].value.match(s)?(this.type="host",this.hostname=this.componentLookup.cn[0].value):this.componentLookup.dc&&this.components.length===this.componentLookup.dc.length?(this.type="host",this.hostname=this.componentLookup.dc.map(function(e){return e.value}).join(".")):this.componentLookup.uid&&this.components.length===this.componentLookup.uid.length?(this.type="user",this.uid=this.componentLookup.uid[0].value):this.componentLookup.cn&&1===this.componentLookup.cn.length&&this.componentLookup.cn[0].value.match(s)?(this.type="host",this.hostname=this.componentLookup.cn[0].value):this.componentLookup.uid&&1===this.componentLookup.uid.length?(this.type="user",this.uid=this.componentLookup.uid[0].value):this.componentLookup.mail&&1===this.componentLookup.mail.length?(this.type="email",this.email=this.componentLookup.mail[0].value):this.componentLookup.cn&&1===this.componentLookup.cn.length?(this.type="user",this.uid=this.componentLookup.cn[0].value):this.type="unknown";else if(this.type=e.type,"host"===this.type)this.hostname=e.hostname;else if("user"===this.type)this.uid=e.uid;else{if("email"!==this.type)throw new Error("Unknown type "+this.type);this.email=e.email}}Object.keys(c).forEach(function(e){p[c[e]]=e}),Identity.prototype.toString=function(){return this.components.map(function(e){var t=e.name.toUpperCase();t=t.replace(/=/g,"\\=");var a=e.value;return t+"="+(a=a.replace(/,/g,"\\,"))}).join(", ")},Identity.prototype.get=function(e,t){o.string(e,"name");var a=this.componentLookup[e];if(void 0!==a&&0!==a.length){if(!t&&a.length>1)throw new Error("Multiple values for attribute "+e);return t?a.map(function(e){return e.value}):a[0].value}},Identity.prototype.toArray=function(e){return this.components.map(function(e){return{name:e.name,value:e.value}})};var u=/[^a-zA-Z0-9 '(),+.\/:=?-]/,l=/[^\x00-\x7f]/;function globMatch(e,t){if("**"===e||"**"===t)return!0;var a=e.split("."),o=t.split(".");if(a.length!==o.length)return!1;for(var r=0;r<a.length;++r)if("*"!==a[r]&&"*"!==o[r]&&a[r]!==o[r])return!1;return!0}Identity.prototype.toAsn1=function(e,t){e.startSequence(t),this.components.forEach(function(t){if(e.startSequence(i.Ber.Constructor|i.Ber.Set),e.startSequence(),e.writeOID(t.oid),t.asn1type===i.Ber.Utf8String||t.value.match(l)){var a=n.from(t.value,"utf8");e.writeBuffer(a,i.Ber.Utf8String)}else if(t.asn1type===i.Ber.IA5String||t.value.match(u))e.writeString(t.value,i.Ber.IA5String);else{var o=i.Ber.PrintableString;void 0!==t.asn1type&&(o=t.asn1type),e.writeString(t.value,o)}e.endSequence(),e.endSequence()}),e.endSequence()},Identity.prototype.equals=function(e){if(!Identity.isIdentity(e,[1,0]))return!1;if(e.components.length!==this.components.length)return!1;for(var t=0;t<this.components.length;++t){if(this.components[t].oid!==e.components[t].oid)return!1;if(!globMatch(this.components[t].value,e.components[t].value))return!1}return!0},Identity.forHost=function(e){return o.string(e,"hostname"),new Identity({type:"host",hostname:e,components:[{name:"cn",value:e}]})},Identity.forUser=function(e){return o.string(e,"uid"),new Identity({type:"user",uid:e,components:[{name:"uid",value:e}]})},Identity.forEmail=function(e){return o.string(e,"email"),new Identity({type:"email",email:e,components:[{name:"mail",value:e}]})},Identity.parseDN=function(e){o.string(e,"dn");for(var t=[""],a=0,r=e;r.length>0;){var i;if(null!==(i=/^,/.exec(r)))t[++a]="",r=r.slice(i[0].length);else if(null!==(i=/^\\,/.exec(r)))t[a]+=",",r=r.slice(i[0].length);else if(null!==(i=/^\\./.exec(r)))t[a]+=i[0],r=r.slice(i[0].length);else{if(null===(i=/^[^\\,]+/.exec(r)))throw new Error("Failed to parse DN");t[a]+=i[0],r=r.slice(i[0].length)}}return new Identity({components:t.map(function(e){for(var t=(e=e.trim()).indexOf("=");t>0&&"\\"===e.charAt(t-1);)t=e.indexOf("=",t+1);if(-1===t)throw new Error("Failed to parse DN");return{name:e.slice(0,t).toLowerCase().replace(/\\=/g,"="),value:e.slice(t+1)}})})},Identity.fromArray=function(e){return o.arrayOfObject(e,"components"),e.forEach(function(e){if(o.object(e,"component"),o.string(e.name,"component.name"),!n.isBuffer(e.value)&&"string"!=typeof e.value)throw new Error("Invalid component value")}),new Identity({components:e})},Identity.parseAsn1=function(e,t){var a=[];e.readSequence(t);for(var o=e.offset+e.length;e.offset<o;){e.readSequence(i.Ber.Constructor|i.Ber.Set);var r=e.offset+e.length;e.readSequence();var n,s=e.readOID(),c=e.peek();switch(c){case i.Ber.PrintableString:case i.Ber.IA5String:case i.Ber.OctetString:case i.Ber.T61String:n=e.readString(c);break;case i.Ber.Utf8String:n=(n=e.readString(c,!0)).toString("utf8");break;case i.Ber.CharacterString:case i.Ber.BMPString:n=(n=e.readString(c,!0)).toString("utf16le");break;default:throw new Error("Unknown asn1 type "+c)}a.push({oid:s,asn1type:c,value:n}),e._offset=r}return e._offset=o,new Identity({components:a})},Identity.isIdentity=function(e,t){return r.isCompatible(e,Identity,t)},Identity.prototype._sshpkApiVersion=[1,0],Identity._oldVersionDetect=function(e){return[1,0]}},45143:(e,t,a)=>{e.exports=a(90554)},45201:(e,t,a)=>{var o=a(94742),r=a(39023),i=a(1143),n=a(15622).bJ,s=i.sprintf;function parseConstructorArguments(e){var t,a,r,i;if(o.object(e,"args"),o.bool(e.strict,"args.strict"),o.array(e.argv,"args.argv"),0===(t=e.argv).length)a={},r=[];else if(n(t[0]))a={cause:t[0]},r=t.slice(1);else if("object"==typeof t[0]){for(i in a={},t[0])a[i]=t[0][i];r=t.slice(1)}else o.string(t[0],"first argument to VError, SError, or WError constructor must be a string, object, or Error"),a={},r=t;return o.object(a),a.strict||e.strict||(r=r.map(function(e){return null===e?"null":void 0===e?"undefined":e})),{options:a,shortmessage:0===r.length?"":s.apply(null,r)}}function VError(){var e,t,a,r,i,s,c;if(e=Array.prototype.slice.call(arguments,0),!(this instanceof VError))return t=Object.create(VError.prototype),VError.apply(t,arguments),t;if((a=parseConstructorArguments({argv:e,strict:!1})).options.name&&(o.string(a.options.name,'error\'s "name" must be a string'),this.name=a.options.name),this.jse_shortmsg=a.shortmessage,s=a.shortmessage,(r=a.options.cause)&&(o.ok(n(r),"cause is not an Error"),this.jse_cause=r,a.options.skipCauseMessage||(s+=": "+r.message)),this.jse_info={},a.options.info)for(c in a.options.info)this.jse_info[c]=a.options.info[c];return this.message=s,Error.call(this,s),Error.captureStackTrace&&(i=a.options.constructorOpt||this.constructor,Error.captureStackTrace(this,i)),this}function SError(){var e,t,a,o;return e=Array.prototype.slice.call(arguments,0),this instanceof SError?(o=(a=parseConstructorArguments({argv:e,strict:!0})).options,VError.call(this,o,"%s",a.shortmessage),this):(t=Object.create(SError.prototype),SError.apply(t,arguments),t)}function MultiError(e){o.array(e,"list of errors"),o.ok(e.length>0,"must be at least one error"),this.ase_errors=e,VError.call(this,{cause:e[0]},"first of %d error%s",e.length,1==e.length?"":"s")}function WError(){var e,t,a,o;return e=Array.prototype.slice.call(arguments,0),this instanceof WError?((o=(a=parseConstructorArguments({argv:e,strict:!1})).options).skipCauseMessage=!0,VError.call(this,o,"%s",a.shortmessage),this):(t=Object.create(WError.prototype),WError.apply(t,e),t)}e.exports=VError,VError.VError=VError,VError.SError=SError,VError.WError=WError,VError.MultiError=MultiError,r.inherits(VError,Error),VError.prototype.name="VError",VError.prototype.toString=function ve_toString(){var e=this.hasOwnProperty("name")&&this.name||this.constructor.name||this.constructor.prototype.name;return this.message&&(e+=": "+this.message),e},VError.prototype.cause=function ve_cause(){var e=VError.cause(this);return null===e?void 0:e},VError.cause=function(e){return o.ok(n(e),"err must be an Error"),n(e.jse_cause)?e.jse_cause:null},VError.info=function(e){var t,a,r;if(o.ok(n(e),"err must be an Error"),t=null!==(a=VError.cause(e))?VError.info(a):{},"object"==typeof e.jse_info&&null!==e.jse_info)for(r in e.jse_info)t[r]=e.jse_info[r];return t},VError.findCauseByName=function(e,t){var a;for(o.ok(n(e),"err must be an Error"),o.string(t,"name"),o.ok(t.length>0,"name cannot be empty"),a=e;null!==a;a=VError.cause(a))if(o.ok(n(a)),a.name==t)return a;return null},VError.hasCauseWithName=function(e,t){return null!==VError.findCauseByName(e,t)},VError.fullStack=function(e){o.ok(n(e),"err must be an Error");var t=VError.cause(e);return t?e.stack+"\ncaused by: "+VError.fullStack(t):e.stack},VError.errorFromList=function(e){return o.arrayOfObject(e,"errors"),0===e.length?null:(e.forEach(function(e){o.ok(n(e))}),1==e.length?e[0]:new MultiError(e))},VError.errorForEach=function(e,t){o.ok(n(e),"err must be an Error"),o.func(t,"func"),e instanceof MultiError?e.errors().forEach(function iterError(e){t(e)}):t(e)},r.inherits(SError,VError),r.inherits(MultiError,VError),MultiError.prototype.name="MultiError",MultiError.prototype.errors=function me_errors(){return this.ase_errors.slice(0)},r.inherits(WError,VError),WError.prototype.name="WError",WError.prototype.toString=function we_toString(){var e=this.hasOwnProperty("name")&&this.name||this.constructor.name||this.constructor.prototype.name;return this.message&&(e+=": "+this.message),this.jse_cause&&this.jse_cause.message&&(e+="; caused by "+this.jse_cause.toString()),e},WError.prototype.cause=function we_cause(e){return n(e)&&(this.jse_cause=e),this.jse_cause}},45291:e=>{"use strict";e.exports=JSON.parse('[["0","\\u0000",127],["8ea1","｡",62],["a1a1","　、。，．・：；？！゛゜´｀¨＾￣＿ヽヾゝゞ〃仝々〆〇ー―‐／＼～∥｜…‥‘’“”（）〔〕［］｛｝〈",9,"＋－±×÷＝≠＜＞≦≧∞∴♂♀°′″℃￥＄￠￡％＃＆＊＠§☆★○●◎◇"],["a2a1","◆□■△▲▽▼※〒→←↑↓〓"],["a2ba","∈∋⊆⊇⊂⊃∪∩"],["a2ca","∧∨￢⇒⇔∀∃"],["a2dc","∠⊥⌒∂∇≡≒≪≫√∽∝∵∫∬"],["a2f2","Å‰♯♭♪†‡¶"],["a2fe","◯"],["a3b0","０",9],["a3c1","Ａ",25],["a3e1","ａ",25],["a4a1","ぁ",82],["a5a1","ァ",85],["a6a1","Α",16,"Σ",6],["a6c1","α",16,"σ",6],["a7a1","А",5,"ЁЖ",25],["a7d1","а",5,"ёж",25],["a8a1","─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂"],["ada1","①",19,"Ⅰ",9],["adc0","㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㎡"],["addf","㍻〝〟№㏍℡㊤",4,"㈱㈲㈹㍾㍽㍼≒≡∫∮∑√⊥∠∟⊿∵∩∪"],["b0a1","亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭"],["b1a1","院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応"],["b2a1","押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改"],["b3a1","魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱"],["b4a1","粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄"],["b5a1","機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京"],["b6a1","供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈"],["b7a1","掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲"],["b8a1","検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向"],["b9a1","后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込"],["baa1","此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷"],["bba1","察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時"],["bca1","次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周"],["bda1","宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償"],["bea1","勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾"],["bfa1","拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾"],["c0a1","澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線"],["c1a1","繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎"],["c2a1","臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只"],["c3a1","叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵"],["c4a1","帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓"],["c5a1","邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到"],["c6a1","董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入"],["c7a1","如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦"],["c8a1","函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美"],["c9a1","鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服"],["caa1","福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋"],["cba1","法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満"],["cca1","漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉愈油癒"],["cda1","諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃"],["cea1","痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯"],["cfa1","蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕"],["d0a1","弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲"],["d1a1","僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨"],["d2a1","辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨"],["d3a1","咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉"],["d4a1","圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩"],["d5a1","奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓"],["d6a1","屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏"],["d7a1","廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚"],["d8a1","悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛"],["d9a1","戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼"],["daa1","據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼"],["dba1","曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘椢椦棡椌棍"],["dca1","棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣"],["dda1","檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾"],["dea1","沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌"],["dfa1","漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼"],["e0a1","燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱"],["e1a1","瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰"],["e2a1","癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬"],["e3a1","磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐"],["e4a1","筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆"],["e5a1","紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺"],["e6a1","罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋"],["e7a1","隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙"],["e8a1","茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈"],["e9a1","蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙"],["eaa1","蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞"],["eba1","襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫"],["eca1","譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊"],["eda1","蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸"],["eea1","遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮"],["efa1","錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞"],["f0a1","陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰"],["f1a1","顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷"],["f2a1","髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈"],["f3a1","鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠"],["f4a1","堯槇遙瑤凜熙"],["f9a1","纊褜鍈銈蓜俉炻昱棈鋹曻彅丨仡仼伀伃伹佖侒侊侚侔俍偀倢俿倞偆偰偂傔僴僘兊兤冝冾凬刕劜劦勀勛匀匇匤卲厓厲叝﨎咜咊咩哿喆坙坥垬埈埇﨏塚增墲夋奓奛奝奣妤妺孖寀甯寘寬尞岦岺峵崧嵓﨑嵂嵭嶸嶹巐弡弴彧德"],["faa1","忞恝悅悊惞惕愠惲愑愷愰憘戓抦揵摠撝擎敎昀昕昻昉昮昞昤晥晗晙晴晳暙暠暲暿曺朎朗杦枻桒柀栁桄棏﨓楨﨔榘槢樰橫橆橳橾櫢櫤毖氿汜沆汯泚洄涇浯涖涬淏淸淲淼渹湜渧渼溿澈澵濵瀅瀇瀨炅炫焏焄煜煆煇凞燁燾犱"],["fba1","犾猤猪獷玽珉珖珣珒琇珵琦琪琩琮瑢璉璟甁畯皂皜皞皛皦益睆劯砡硎硤硺礰礼神祥禔福禛竑竧靖竫箞精絈絜綷綠緖繒罇羡羽茁荢荿菇菶葈蒴蕓蕙蕫﨟薰蘒﨡蠇裵訒訷詹誧誾諟諸諶譓譿賰賴贒赶﨣軏﨤逸遧郞都鄕鄧釚"],["fca1","釗釞釭釮釤釥鈆鈐鈊鈺鉀鈼鉎鉙鉑鈹鉧銧鉷鉸鋧鋗鋙鋐﨧鋕鋠鋓錥錡鋻﨨錞鋿錝錂鍰鍗鎤鏆鏞鏸鐱鑅鑈閒隆﨩隝隯霳霻靃靍靏靑靕顗顥飯飼餧館馞驎髙髜魵魲鮏鮱鮻鰀鵰鵫鶴鸙黑"],["fcf1","ⅰ",9,"￢￤＇＂"],["8fa2af","˘ˇ¸˙˝¯˛˚～΄΅"],["8fa2c2","¡¦¿"],["8fa2eb","ºª©®™¤№"],["8fa6e1","ΆΈΉΊΪ"],["8fa6e7","Ό"],["8fa6e9","ΎΫ"],["8fa6ec","Ώ"],["8fa6f1","άέήίϊΐόςύϋΰώ"],["8fa7c2","Ђ",10,"ЎЏ"],["8fa7f2","ђ",10,"ўџ"],["8fa9a1","ÆĐ"],["8fa9a4","Ħ"],["8fa9a6","Ĳ"],["8fa9a8","ŁĿ"],["8fa9ab","ŊØŒ"],["8fa9af","ŦÞ"],["8fa9c1","æđðħıĳĸłŀŉŋøœßŧþ"],["8faaa1","ÁÀÄÂĂǍĀĄÅÃĆĈČÇĊĎÉÈËÊĚĖĒĘ"],["8faaba","ĜĞĢĠĤÍÌÏÎǏİĪĮĨĴĶĹĽĻŃŇŅÑÓÒÖÔǑŐŌÕŔŘŖŚŜŠŞŤŢÚÙÜÛŬǓŰŪŲŮŨǗǛǙǕŴÝŸŶŹŽŻ"],["8faba1","áàäâăǎāąåãćĉčçċďéèëêěėēęǵĝğ"],["8fabbd","ġĥíìïîǐ"],["8fabc5","īįĩĵķĺľļńňņñóòöôǒőōõŕřŗśŝšşťţúùüûŭǔűūųůũǘǜǚǖŵýÿŷźžż"],["8fb0a1","丂丄丅丌丒丟丣两丨丫丮丯丰丵乀乁乄乇乑乚乜乣乨乩乴乵乹乿亍亖亗亝亯亹仃仐仚仛仠仡仢仨仯仱仳仵份仾仿伀伂伃伈伋伌伒伕伖众伙伮伱你伳伵伷伹伻伾佀佂佈佉佋佌佒佔佖佘佟佣佪佬佮佱佷佸佹佺佽佾侁侂侄"],["8fb1a1","侅侉侊侌侎侐侒侓侔侗侙侚侞侟侲侷侹侻侼侽侾俀俁俅俆俈俉俋俌俍俏俒俜俠俢俰俲俼俽俿倀倁倄倇倊倌倎倐倓倗倘倛倜倝倞倢倧倮倰倲倳倵偀偁偂偅偆偊偌偎偑偒偓偗偙偟偠偢偣偦偧偪偭偰偱倻傁傃傄傆傊傎傏傐"],["8fb2a1","傒傓傔傖傛傜傞",4,"傪傯傰傹傺傽僀僃僄僇僌僎僐僓僔僘僜僝僟僢僤僦僨僩僯僱僶僺僾儃儆儇儈儋儌儍儎僲儐儗儙儛儜儝儞儣儧儨儬儭儯儱儳儴儵儸儹兂兊兏兓兕兗兘兟兤兦兾冃冄冋冎冘冝冡冣冭冸冺冼冾冿凂"],["8fb3a1","凈减凑凒凓凕凘凞凢凥凮凲凳凴凷刁刂刅划刓刕刖刘刢刨刱刲刵刼剅剉剕剗剘剚剜剟剠剡剦剮剷剸剹劀劂劅劊劌劓劕劖劗劘劚劜劤劥劦劧劯劰劶劷劸劺劻劽勀勄勆勈勌勏勑勔勖勛勜勡勥勨勩勪勬勰勱勴勶勷匀匃匊匋"],["8fb4a1","匌匑匓匘匛匜匞匟匥匧匨匩匫匬匭匰匲匵匼匽匾卂卌卋卙卛卡卣卥卬卭卲卹卾厃厇厈厎厓厔厙厝厡厤厪厫厯厲厴厵厷厸厺厽叀叅叏叒叓叕叚叝叞叠另叧叵吂吓吚吡吧吨吪启吱吴吵呃呄呇呍呏呞呢呤呦呧呩呫呭呮呴呿"],["8fb5a1","咁咃咅咈咉咍咑咕咖咜咟咡咦咧咩咪咭咮咱咷咹咺咻咿哆哊响哎哠哪哬哯哶哼哾哿唀唁唅唈唉唌唍唎唕唪唫唲唵唶唻唼唽啁啇啉啊啍啐啑啘啚啛啞啠啡啤啦啿喁喂喆喈喎喏喑喒喓喔喗喣喤喭喲喿嗁嗃嗆嗉嗋嗌嗎嗑嗒"],["8fb6a1","嗓嗗嗘嗛嗞嗢嗩嗶嗿嘅嘈嘊嘍",5,"嘙嘬嘰嘳嘵嘷嘹嘻嘼嘽嘿噀噁噃噄噆噉噋噍噏噔噞噠噡噢噣噦噩噭噯噱噲噵嚄嚅嚈嚋嚌嚕嚙嚚嚝嚞嚟嚦嚧嚨嚩嚫嚬嚭嚱嚳嚷嚾囅囉囊囋囏囐囌囍囙囜囝囟囡囤",4,"囱囫园"],["8fb7a1","囶囷圁圂圇圊圌圑圕圚圛圝圠圢圣圤圥圩圪圬圮圯圳圴圽圾圿坅坆坌坍坒坢坥坧坨坫坭",4,"坳坴坵坷坹坺坻坼坾垁垃垌垔垗垙垚垜垝垞垟垡垕垧垨垩垬垸垽埇埈埌埏埕埝埞埤埦埧埩埭埰埵埶埸埽埾埿堃堄堈堉埡"],["8fb8a1","堌堍堛堞堟堠堦堧堭堲堹堿塉塌塍塏塐塕塟塡塤塧塨塸塼塿墀墁墇墈墉墊墌墍墏墐墔墖墝墠墡墢墦墩墱墲壄墼壂壈壍壎壐壒壔壖壚壝壡壢壩壳夅夆夋夌夒夓夔虁夝夡夣夤夨夯夰夳夵夶夿奃奆奒奓奙奛奝奞奟奡奣奫奭"],["8fb9a1","奯奲奵奶她奻奼妋妌妎妒妕妗妟妤妧妭妮妯妰妳妷妺妼姁姃姄姈姊姍姒姝姞姟姣姤姧姮姯姱姲姴姷娀娄娌娍娎娒娓娞娣娤娧娨娪娭娰婄婅婇婈婌婐婕婞婣婥婧婭婷婺婻婾媋媐媓媖媙媜媞媟媠媢媧媬媱媲媳媵媸媺媻媿"],["8fbaa1","嫄嫆嫈嫏嫚嫜嫠嫥嫪嫮嫵嫶嫽嬀嬁嬈嬗嬴嬙嬛嬝嬡嬥嬭嬸孁孋孌孒孖孞孨孮孯孼孽孾孿宁宄宆宊宎宐宑宓宔宖宨宩宬宭宯宱宲宷宺宼寀寁寍寏寖",4,"寠寯寱寴寽尌尗尞尟尣尦尩尫尬尮尰尲尵尶屙屚屜屢屣屧屨屩"],["8fbba1","屭屰屴屵屺屻屼屽岇岈岊岏岒岝岟岠岢岣岦岪岲岴岵岺峉峋峒峝峗峮峱峲峴崁崆崍崒崫崣崤崦崧崱崴崹崽崿嵂嵃嵆嵈嵕嵑嵙嵊嵟嵠嵡嵢嵤嵪嵭嵰嵹嵺嵾嵿嶁嶃嶈嶊嶒嶓嶔嶕嶙嶛嶟嶠嶧嶫嶰嶴嶸嶹巃巇巋巐巎巘巙巠巤"],["8fbca1","巩巸巹帀帇帍帒帔帕帘帟帠帮帨帲帵帾幋幐幉幑幖幘幛幜幞幨幪",4,"幰庀庋庎庢庤庥庨庪庬庱庳庽庾庿廆廌廋廎廑廒廔廕廜廞廥廫异弆弇弈弎弙弜弝弡弢弣弤弨弫弬弮弰弴弶弻弽弿彀彄彅彇彍彐彔彘彛彠彣彤彧"],["8fbda1","彯彲彴彵彸彺彽彾徉徍徏徖徜徝徢徧徫徤徬徯徰徱徸忄忇忈忉忋忐",4,"忞忡忢忨忩忪忬忭忮忯忲忳忶忺忼怇怊怍怓怔怗怘怚怟怤怭怳怵恀恇恈恉恌恑恔恖恗恝恡恧恱恾恿悂悆悈悊悎悑悓悕悘悝悞悢悤悥您悰悱悷"],["8fbea1","悻悾惂惄惈惉惊惋惎惏惔惕惙惛惝惞惢惥惲惵惸惼惽愂愇愊愌愐",4,"愖愗愙愜愞愢愪愫愰愱愵愶愷愹慁慅慆慉慞慠慬慲慸慻慼慿憀憁憃憄憋憍憒憓憗憘憜憝憟憠憥憨憪憭憸憹憼懀懁懂懎懏懕懜懝懞懟懡懢懧懩懥"],["8fbfa1","懬懭懯戁戃戄戇戓戕戜戠戢戣戧戩戫戹戽扂扃扄扆扌扐扑扒扔扖扚扜扤扭扯扳扺扽抍抎抏抐抦抨抳抶抷抺抾抿拄拎拕拖拚拪拲拴拼拽挃挄挊挋挍挐挓挖挘挩挪挭挵挶挹挼捁捂捃捄捆捊捋捎捒捓捔捘捛捥捦捬捭捱捴捵"],["8fc0a1","捸捼捽捿掂掄掇掊掐掔掕掙掚掞掤掦掭掮掯掽揁揅揈揎揑揓揔揕揜揠揥揪揬揲揳揵揸揹搉搊搐搒搔搘搞搠搢搤搥搩搪搯搰搵搽搿摋摏摑摒摓摔摚摛摜摝摟摠摡摣摭摳摴摻摽撅撇撏撐撑撘撙撛撝撟撡撣撦撨撬撳撽撾撿"],["8fc1a1","擄擉擊擋擌擎擐擑擕擗擤擥擩擪擭擰擵擷擻擿攁攄攈攉攊攏攓攔攖攙攛攞攟攢攦攩攮攱攺攼攽敃敇敉敐敒敔敟敠敧敫敺敽斁斅斊斒斕斘斝斠斣斦斮斲斳斴斿旂旈旉旎旐旔旖旘旟旰旲旴旵旹旾旿昀昄昈昉昍昑昒昕昖昝"],["8fc2a1","昞昡昢昣昤昦昩昪昫昬昮昰昱昳昹昷晀晅晆晊晌晑晎晗晘晙晛晜晠晡曻晪晫晬晾晳晵晿晷晸晹晻暀晼暋暌暍暐暒暙暚暛暜暟暠暤暭暱暲暵暻暿曀曂曃曈曌曎曏曔曛曟曨曫曬曮曺朅朇朎朓朙朜朠朢朳朾杅杇杈杌杔杕杝"],["8fc3a1","杦杬杮杴杶杻极构枎枏枑枓枖枘枙枛枰枱枲枵枻枼枽柹柀柂柃柅柈柉柒柗柙柜柡柦柰柲柶柷桒栔栙栝栟栨栧栬栭栯栰栱栳栻栿桄桅桊桌桕桗桘桛桫桮",4,"桵桹桺桻桼梂梄梆梈梖梘梚梜梡梣梥梩梪梮梲梻棅棈棌棏"],["8fc4a1","棐棑棓棖棙棜棝棥棨棪棫棬棭棰棱棵棶棻棼棽椆椉椊椐椑椓椖椗椱椳椵椸椻楂楅楉楎楗楛楣楤楥楦楨楩楬楰楱楲楺楻楿榀榍榒榖榘榡榥榦榨榫榭榯榷榸榺榼槅槈槑槖槗槢槥槮槯槱槳槵槾樀樁樃樏樑樕樚樝樠樤樨樰樲"],["8fc5a1","樴樷樻樾樿橅橆橉橊橎橐橑橒橕橖橛橤橧橪橱橳橾檁檃檆檇檉檋檑檛檝檞檟檥檫檯檰檱檴檽檾檿櫆櫉櫈櫌櫐櫔櫕櫖櫜櫝櫤櫧櫬櫰櫱櫲櫼櫽欂欃欆欇欉欏欐欑欗欛欞欤欨欫欬欯欵欶欻欿歆歊歍歒歖歘歝歠歧歫歮歰歵歽"],["8fc6a1","歾殂殅殗殛殟殠殢殣殨殩殬殭殮殰殸殹殽殾毃毄毉毌毖毚毡毣毦毧毮毱毷毹毿氂氄氅氉氍氎氐氒氙氟氦氧氨氬氮氳氵氶氺氻氿汊汋汍汏汒汔汙汛汜汫汭汯汴汶汸汹汻沅沆沇沉沔沕沗沘沜沟沰沲沴泂泆泍泏泐泑泒泔泖"],["8fc7a1","泚泜泠泧泩泫泬泮泲泴洄洇洊洎洏洑洓洚洦洧洨汧洮洯洱洹洼洿浗浞浟浡浥浧浯浰浼涂涇涑涒涔涖涗涘涪涬涴涷涹涽涿淄淈淊淎淏淖淛淝淟淠淢淥淩淯淰淴淶淼渀渄渞渢渧渲渶渹渻渼湄湅湈湉湋湏湑湒湓湔湗湜湝湞"],["8fc8a1","湢湣湨湳湻湽溍溓溙溠溧溭溮溱溳溻溿滀滁滃滇滈滊滍滎滏滫滭滮滹滻滽漄漈漊漌漍漖漘漚漛漦漩漪漯漰漳漶漻漼漭潏潑潒潓潗潙潚潝潞潡潢潨潬潽潾澃澇澈澋澌澍澐澒澓澔澖澚澟澠澥澦澧澨澮澯澰澵澶澼濅濇濈濊"],["8fc9a1","濚濞濨濩濰濵濹濼濽瀀瀅瀆瀇瀍瀗瀠瀣瀯瀴瀷瀹瀼灃灄灈灉灊灋灔灕灝灞灎灤灥灬灮灵灶灾炁炅炆炔",4,"炛炤炫炰炱炴炷烊烑烓烔烕烖烘烜烤烺焃",4,"焋焌焏焞焠焫焭焯焰焱焸煁煅煆煇煊煋煐煒煗煚煜煞煠"],["8fcaa1","煨煹熀熅熇熌熒熚熛熠熢熯熰熲熳熺熿燀燁燄燋燌燓燖燙燚燜燸燾爀爇爈爉爓爗爚爝爟爤爫爯爴爸爹牁牂牃牅牎牏牐牓牕牖牚牜牞牠牣牨牫牮牯牱牷牸牻牼牿犄犉犍犎犓犛犨犭犮犱犴犾狁狇狉狌狕狖狘狟狥狳狴狺狻"],["8fcba1","狾猂猄猅猇猋猍猒猓猘猙猞猢猤猧猨猬猱猲猵猺猻猽獃獍獐獒獖獘獝獞獟獠獦獧獩獫獬獮獯獱獷獹獼玀玁玃玅玆玎玐玓玕玗玘玜玞玟玠玢玥玦玪玫玭玵玷玹玼玽玿珅珆珉珋珌珏珒珓珖珙珝珡珣珦珧珩珴珵珷珹珺珻珽"],["8fcca1","珿琀琁琄琇琊琑琚琛琤琦琨",9,"琹瑀瑃瑄瑆瑇瑋瑍瑑瑒瑗瑝瑢瑦瑧瑨瑫瑭瑮瑱瑲璀璁璅璆璇璉璏璐璑璒璘璙璚璜璟璠璡璣璦璨璩璪璫璮璯璱璲璵璹璻璿瓈瓉瓌瓐瓓瓘瓚瓛瓞瓟瓤瓨瓪瓫瓯瓴瓺瓻瓼瓿甆"],["8fcda1","甒甖甗甠甡甤甧甩甪甯甶甹甽甾甿畀畃畇畈畎畐畒畗畞畟畡畯畱畹",5,"疁疅疐疒疓疕疙疜疢疤疴疺疿痀痁痄痆痌痎痏痗痜痟痠痡痤痧痬痮痯痱痹瘀瘂瘃瘄瘇瘈瘊瘌瘏瘒瘓瘕瘖瘙瘛瘜瘝瘞瘣瘥瘦瘩瘭瘲瘳瘵瘸瘹"],["8fcea1","瘺瘼癊癀癁癃癄癅癉癋癕癙癟癤癥癭癮癯癱癴皁皅皌皍皕皛皜皝皟皠皢",6,"皪皭皽盁盅盉盋盌盎盔盙盠盦盨盬盰盱盶盹盼眀眆眊眎眒眔眕眗眙眚眜眢眨眭眮眯眴眵眶眹眽眾睂睅睆睊睍睎睏睒睖睗睜睞睟睠睢"],["8fcfa1","睤睧睪睬睰睲睳睴睺睽瞀瞄瞌瞍瞔瞕瞖瞚瞟瞢瞧瞪瞮瞯瞱瞵瞾矃矉矑矒矕矙矞矟矠矤矦矪矬矰矱矴矸矻砅砆砉砍砎砑砝砡砢砣砭砮砰砵砷硃硄硇硈硌硎硒硜硞硠硡硣硤硨硪确硺硾碊碏碔碘碡碝碞碟碤碨碬碭碰碱碲碳"],["8fd0a1","碻碽碿磇磈磉磌磎磒磓磕磖磤磛磟磠磡磦磪磲磳礀磶磷磺磻磿礆礌礐礚礜礞礟礠礥礧礩礭礱礴礵礻礽礿祄祅祆祊祋祏祑祔祘祛祜祧祩祫祲祹祻祼祾禋禌禑禓禔禕禖禘禛禜禡禨禩禫禯禱禴禸离秂秄秇秈秊秏秔秖秚秝秞"],["8fd1a1","秠秢秥秪秫秭秱秸秼稂稃稇稉稊稌稑稕稛稞稡稧稫稭稯稰稴稵稸稹稺穄穅穇穈穌穕穖穙穜穝穟穠穥穧穪穭穵穸穾窀窂窅窆窊窋窐窑窔窞窠窣窬窳窵窹窻窼竆竉竌竎竑竛竨竩竫竬竱竴竻竽竾笇笔笟笣笧笩笪笫笭笮笯笰"],["8fd2a1","笱笴笽笿筀筁筇筎筕筠筤筦筩筪筭筯筲筳筷箄箉箎箐箑箖箛箞箠箥箬箯箰箲箵箶箺箻箼箽篂篅篈篊篔篖篗篙篚篛篨篪篲篴篵篸篹篺篼篾簁簂簃簄簆簉簋簌簎簏簙簛簠簥簦簨簬簱簳簴簶簹簺籆籊籕籑籒籓籙",5],["8fd3a1","籡籣籧籩籭籮籰籲籹籼籽粆粇粏粔粞粠粦粰粶粷粺粻粼粿糄糇糈糉糍糏糓糔糕糗糙糚糝糦糩糫糵紃紇紈紉紏紑紒紓紖紝紞紣紦紪紭紱紼紽紾絀絁絇絈絍絑絓絗絙絚絜絝絥絧絪絰絸絺絻絿綁綂綃綅綆綈綋綌綍綑綖綗綝"],["8fd4a1","綞綦綧綪綳綶綷綹緂",4,"緌緍緎緗緙縀緢緥緦緪緫緭緱緵緶緹緺縈縐縑縕縗縜縝縠縧縨縬縭縯縳縶縿繄繅繇繎繐繒繘繟繡繢繥繫繮繯繳繸繾纁纆纇纊纍纑纕纘纚纝纞缼缻缽缾缿罃罄罇罏罒罓罛罜罝罡罣罤罥罦罭"],["8fd5a1","罱罽罾罿羀羋羍羏羐羑羖羗羜羡羢羦羪羭羴羼羿翀翃翈翎翏翛翟翣翥翨翬翮翯翲翺翽翾翿耇耈耊耍耎耏耑耓耔耖耝耞耟耠耤耦耬耮耰耴耵耷耹耺耼耾聀聄聠聤聦聭聱聵肁肈肎肜肞肦肧肫肸肹胈胍胏胒胔胕胗胘胠胭胮"],["8fd6a1","胰胲胳胶胹胺胾脃脋脖脗脘脜脞脠脤脧脬脰脵脺脼腅腇腊腌腒腗腠腡腧腨腩腭腯腷膁膐膄膅膆膋膎膖膘膛膞膢膮膲膴膻臋臃臅臊臎臏臕臗臛臝臞臡臤臫臬臰臱臲臵臶臸臹臽臿舀舃舏舓舔舙舚舝舡舢舨舲舴舺艃艄艅艆"],["8fd7a1","艋艎艏艑艖艜艠艣艧艭艴艻艽艿芀芁芃芄芇芉芊芎芑芔芖芘芚芛芠芡芣芤芧芨芩芪芮芰芲芴芷芺芼芾芿苆苐苕苚苠苢苤苨苪苭苯苶苷苽苾茀茁茇茈茊茋荔茛茝茞茟茡茢茬茭茮茰茳茷茺茼茽荂荃荄荇荍荎荑荕荖荗荰荸"],["8fd8a1","荽荿莀莂莄莆莍莒莔莕莘莙莛莜莝莦莧莩莬莾莿菀菇菉菏菐菑菔菝荓菨菪菶菸菹菼萁萆萊萏萑萕萙莭萯萹葅葇葈葊葍葏葑葒葖葘葙葚葜葠葤葥葧葪葰葳葴葶葸葼葽蒁蒅蒒蒓蒕蒞蒦蒨蒩蒪蒯蒱蒴蒺蒽蒾蓀蓂蓇蓈蓌蓏蓓"],["8fd9a1","蓜蓧蓪蓯蓰蓱蓲蓷蔲蓺蓻蓽蔂蔃蔇蔌蔎蔐蔜蔞蔢蔣蔤蔥蔧蔪蔫蔯蔳蔴蔶蔿蕆蕏",4,"蕖蕙蕜",6,"蕤蕫蕯蕹蕺蕻蕽蕿薁薅薆薉薋薌薏薓薘薝薟薠薢薥薧薴薶薷薸薼薽薾薿藂藇藊藋藎薭藘藚藟藠藦藨藭藳藶藼"],["8fdaa1","藿蘀蘄蘅蘍蘎蘐蘑蘒蘘蘙蘛蘞蘡蘧蘩蘶蘸蘺蘼蘽虀虂虆虒虓虖虗虘虙虝虠",4,"虩虬虯虵虶虷虺蚍蚑蚖蚘蚚蚜蚡蚦蚧蚨蚭蚱蚳蚴蚵蚷蚸蚹蚿蛀蛁蛃蛅蛑蛒蛕蛗蛚蛜蛠蛣蛥蛧蚈蛺蛼蛽蜄蜅蜇蜋蜎蜏蜐蜓蜔蜙蜞蜟蜡蜣"],["8fdba1","蜨蜮蜯蜱蜲蜹蜺蜼蜽蜾蝀蝃蝅蝍蝘蝝蝡蝤蝥蝯蝱蝲蝻螃",6,"螋螌螐螓螕螗螘螙螞螠螣螧螬螭螮螱螵螾螿蟁蟈蟉蟊蟎蟕蟖蟙蟚蟜蟟蟢蟣蟤蟪蟫蟭蟱蟳蟸蟺蟿蠁蠃蠆蠉蠊蠋蠐蠙蠒蠓蠔蠘蠚蠛蠜蠞蠟蠨蠭蠮蠰蠲蠵"],["8fdca1","蠺蠼衁衃衅衈衉衊衋衎衑衕衖衘衚衜衟衠衤衩衱衹衻袀袘袚袛袜袟袠袨袪袺袽袾裀裊",4,"裑裒裓裛裞裧裯裰裱裵裷褁褆褍褎褏褕褖褘褙褚褜褠褦褧褨褰褱褲褵褹褺褾襀襂襅襆襉襏襒襗襚襛襜襡襢襣襫襮襰襳襵襺"],["8fdda1","襻襼襽覉覍覐覔覕覛覜覟覠覥覰覴覵覶覷覼觔",4,"觥觩觫觭觱觳觶觹觽觿訄訅訇訏訑訒訔訕訞訠訢訤訦訫訬訯訵訷訽訾詀詃詅詇詉詍詎詓詖詗詘詜詝詡詥詧詵詶詷詹詺詻詾詿誀誃誆誋誏誐誒誖誗誙誟誧誩誮誯誳"],["8fdea1","誶誷誻誾諃諆諈諉諊諑諓諔諕諗諝諟諬諰諴諵諶諼諿謅謆謋謑謜謞謟謊謭謰謷謼譂",4,"譈譒譓譔譙譍譞譣譭譶譸譹譼譾讁讄讅讋讍讏讔讕讜讞讟谸谹谽谾豅豇豉豋豏豑豓豔豗豘豛豝豙豣豤豦豨豩豭豳豵豶豻豾貆"],["8fdfa1","貇貋貐貒貓貙貛貜貤貹貺賅賆賉賋賏賖賕賙賝賡賨賬賯賰賲賵賷賸賾賿贁贃贉贒贗贛赥赩赬赮赿趂趄趈趍趐趑趕趞趟趠趦趫趬趯趲趵趷趹趻跀跅跆跇跈跊跎跑跔跕跗跙跤跥跧跬跰趼跱跲跴跽踁踄踅踆踋踑踔踖踠踡踢"],["8fe0a1","踣踦踧踱踳踶踷踸踹踽蹀蹁蹋蹍蹎蹏蹔蹛蹜蹝蹞蹡蹢蹩蹬蹭蹯蹰蹱蹹蹺蹻躂躃躉躐躒躕躚躛躝躞躢躧躩躭躮躳躵躺躻軀軁軃軄軇軏軑軔軜軨軮軰軱軷軹軺軭輀輂輇輈輏輐輖輗輘輞輠輡輣輥輧輨輬輭輮輴輵輶輷輺轀轁"],["8fe1a1","轃轇轏轑",4,"轘轝轞轥辝辠辡辤辥辦辵辶辸达迀迁迆迊迋迍运迒迓迕迠迣迤迨迮迱迵迶迻迾适逄逈逌逘逛逨逩逯逪逬逭逳逴逷逿遃遄遌遛遝遢遦遧遬遰遴遹邅邈邋邌邎邐邕邗邘邙邛邠邡邢邥邰邲邳邴邶邽郌邾郃"],["8fe2a1","郄郅郇郈郕郗郘郙郜郝郟郥郒郶郫郯郰郴郾郿鄀鄄鄅鄆鄈鄍鄐鄔鄖鄗鄘鄚鄜鄞鄠鄥鄢鄣鄧鄩鄮鄯鄱鄴鄶鄷鄹鄺鄼鄽酃酇酈酏酓酗酙酚酛酡酤酧酭酴酹酺酻醁醃醅醆醊醎醑醓醔醕醘醞醡醦醨醬醭醮醰醱醲醳醶醻醼醽醿"],["8fe3a1","釂釃釅釓釔釗釙釚釞釤釥釩釪釬",5,"釷釹釻釽鈀鈁鈄鈅鈆鈇鈉鈊鈌鈐鈒鈓鈖鈘鈜鈝鈣鈤鈥鈦鈨鈮鈯鈰鈳鈵鈶鈸鈹鈺鈼鈾鉀鉂鉃鉆鉇鉊鉍鉎鉏鉑鉘鉙鉜鉝鉠鉡鉥鉧鉨鉩鉮鉯鉰鉵",4,"鉻鉼鉽鉿銈銉銊銍銎銒銗"],["8fe4a1","銙銟銠銤銥銧銨銫銯銲銶銸銺銻銼銽銿",4,"鋅鋆鋇鋈鋋鋌鋍鋎鋐鋓鋕鋗鋘鋙鋜鋝鋟鋠鋡鋣鋥鋧鋨鋬鋮鋰鋹鋻鋿錀錂錈錍錑錔錕錜錝錞錟錡錤錥錧錩錪錳錴錶錷鍇鍈鍉鍐鍑鍒鍕鍗鍘鍚鍞鍤鍥鍧鍩鍪鍭鍯鍰鍱鍳鍴鍶"],["8fe5a1","鍺鍽鍿鎀鎁鎂鎈鎊鎋鎍鎏鎒鎕鎘鎛鎞鎡鎣鎤鎦鎨鎫鎴鎵鎶鎺鎩鏁鏄鏅鏆鏇鏉",4,"鏓鏙鏜鏞鏟鏢鏦鏧鏹鏷鏸鏺鏻鏽鐁鐂鐄鐈鐉鐍鐎鐏鐕鐖鐗鐟鐮鐯鐱鐲鐳鐴鐻鐿鐽鑃鑅鑈鑊鑌鑕鑙鑜鑟鑡鑣鑨鑫鑭鑮鑯鑱鑲钄钃镸镹"],["8fe6a1","镾閄閈閌閍閎閝閞閟閡閦閩閫閬閴閶閺閽閿闆闈闉闋闐闑闒闓闙闚闝闞闟闠闤闦阝阞阢阤阥阦阬阱阳阷阸阹阺阼阽陁陒陔陖陗陘陡陮陴陻陼陾陿隁隂隃隄隉隑隖隚隝隟隤隥隦隩隮隯隳隺雊雒嶲雘雚雝雞雟雩雯雱雺霂"],["8fe7a1","霃霅霉霚霛霝霡霢霣霨霱霳靁靃靊靎靏靕靗靘靚靛靣靧靪靮靳靶靷靸靻靽靿鞀鞉鞕鞖鞗鞙鞚鞞鞟鞢鞬鞮鞱鞲鞵鞶鞸鞹鞺鞼鞾鞿韁韄韅韇韉韊韌韍韎韐韑韔韗韘韙韝韞韠韛韡韤韯韱韴韷韸韺頇頊頙頍頎頔頖頜頞頠頣頦"],["8fe8a1","頫頮頯頰頲頳頵頥頾顄顇顊顑顒顓顖顗顙顚顢顣顥顦顪顬颫颭颮颰颴颷颸颺颻颿飂飅飈飌飡飣飥飦飧飪飳飶餂餇餈餑餕餖餗餚餛餜餟餢餦餧餫餱",4,"餹餺餻餼饀饁饆饇饈饍饎饔饘饙饛饜饞饟饠馛馝馟馦馰馱馲馵"],["8fe9a1","馹馺馽馿駃駉駓駔駙駚駜駞駧駪駫駬駰駴駵駹駽駾騂騃騄騋騌騐騑騖騞騠騢騣騤騧騭騮騳騵騶騸驇驁驄驊驋驌驎驑驔驖驝骪骬骮骯骲骴骵骶骹骻骾骿髁髃髆髈髎髐髒髕髖髗髛髜髠髤髥髧髩髬髲髳髵髹髺髽髿",4],["8feaa1","鬄鬅鬈鬉鬋鬌鬍鬎鬐鬒鬖鬙鬛鬜鬠鬦鬫鬭鬳鬴鬵鬷鬹鬺鬽魈魋魌魕魖魗魛魞魡魣魥魦魨魪",4,"魳魵魷魸魹魿鮀鮄鮅鮆鮇鮉鮊鮋鮍鮏鮐鮔鮚鮝鮞鮦鮧鮩鮬鮰鮱鮲鮷鮸鮻鮼鮾鮿鯁鯇鯈鯎鯐鯗鯘鯝鯟鯥鯧鯪鯫鯯鯳鯷鯸"],["8feba1","鯹鯺鯽鯿鰀鰂鰋鰏鰑鰖鰘鰙鰚鰜鰞鰢鰣鰦",4,"鰱鰵鰶鰷鰽鱁鱃鱄鱅鱉鱊鱎鱏鱐鱓鱔鱖鱘鱛鱝鱞鱟鱣鱩鱪鱜鱫鱨鱮鱰鱲鱵鱷鱻鳦鳲鳷鳹鴋鴂鴑鴗鴘鴜鴝鴞鴯鴰鴲鴳鴴鴺鴼鵅鴽鵂鵃鵇鵊鵓鵔鵟鵣鵢鵥鵩鵪鵫鵰鵶鵷鵻"],["8feca1","鵼鵾鶃鶄鶆鶊鶍鶎鶒鶓鶕鶖鶗鶘鶡鶪鶬鶮鶱鶵鶹鶼鶿鷃鷇鷉鷊鷔鷕鷖鷗鷚鷞鷟鷠鷥鷧鷩鷫鷮鷰鷳鷴鷾鸊鸂鸇鸎鸐鸑鸒鸕鸖鸙鸜鸝鹺鹻鹼麀麂麃麄麅麇麎麏麖麘麛麞麤麨麬麮麯麰麳麴麵黆黈黋黕黟黤黧黬黭黮黰黱黲黵"],["8feda1","黸黿鼂鼃鼉鼏鼐鼑鼒鼔鼖鼗鼙鼚鼛鼟鼢鼦鼪鼫鼯鼱鼲鼴鼷鼹鼺鼼鼽鼿齁齃",4,"齓齕齖齗齘齚齝齞齨齩齭",4,"齳齵齺齽龏龐龑龒龔龖龗龞龡龢龣龥"]]')},45333:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(15765),r=a(99029),i=a(25206),n=a(62586),s=a(94227),c={keyword:"patternProperties",type:"object",schemaType:"object",code(e){const{gen:t,schema:a,data:c,parentSchema:p,it:u}=e,{opts:l}=u,m=o.schemaProperties(u,a);if(0===m.length)return;const f=l.strict&&!l.allowMatchingProperties&&p.properties,h=t.name("valid");!0===u.props||u.props instanceof r.Name||(u.props=s.evaluatedPropsToName(t,u.props));const{props:g}=u;function checkMatchingProperties(e){for(const t in f)new RegExp(e).test(t)&&n.checkStrictMode(u,`property ${t} matches pattern ${e} (use allowMatchingProperties)`)}function validateProperties(a){t.forIn("key",c,n=>{t.if(r._`${o.usePattern(t,a)}.test(${n})`,()=>{e.subschema({keyword:"patternProperties",schemaProp:a,dataProp:n,dataPropType:i.Type.Str},h),u.opts.unevaluated&&!0!==g?t.assign(r._`${g}[${n}]`,!0):u.allErrors||t.if(r.not(h),()=>t.break())})})}!function validatePatternProperties(){for(const e of m)f&&checkMatchingProperties(e),u.allErrors?validateProperties(e):(t.var(h,!0),validateProperties(e),t.if(h))}()}};t.default=c},45587:(e,t,a)=>{"use strict";var o=a(7598),r=a(16928).extname,i=/^\s*([^;\s]*)(?:;|\s|$)/,n=/^text\//i;function charset(e){if(!e||"string"!=typeof e)return!1;var t=i.exec(e),a=t&&o[t[1].toLowerCase()];return a&&a.charset?a.charset:!(!t||!n.test(t[1]))&&"UTF-8"}t.charset=charset,t.charsets={lookup:charset},t.contentType=function contentType(e){if(!e||"string"!=typeof e)return!1;var a=-1===e.indexOf("/")?t.lookup(e):e;if(!a)return!1;if(-1===a.indexOf("charset")){var o=t.charset(a);o&&(a+="; charset="+o.toLowerCase())}return a},t.extension=function extension(e){if(!e||"string"!=typeof e)return!1;var a=i.exec(e),o=a&&t.extensions[a[1].toLowerCase()];if(!o||!o.length)return!1;return o[0]},t.extensions=Object.create(null),t.lookup=function lookup(e){if(!e||"string"!=typeof e)return!1;var a=r("x."+e).toLowerCase().substr(1);if(!a)return!1;return t.types[a]||!1},t.types=Object.create(null),function populateMaps(e,t){var a=["nginx","apache",void 0,"iana"];Object.keys(o).forEach(function forEachMimeType(r){var i=o[r],n=i.extensions;if(n&&n.length){e[r]=n;for(var s=0;s<n.length;s++){var c=n[s];if(t[c]){var p=a.indexOf(o[t[c]].source),u=a.indexOf(i.source);if("application/octet-stream"!==t[c]&&(p>u||p===u&&"application/"===t[c].substr(0,12)))continue}t[c]=r}}})}(t.extensions,t.types)},45736:e=>{"use strict";e.exports=function generate_uniqueItems(e,t,a){var o,r=" ",i=e.level,n=e.dataLevel,s=e.schema[t],c=e.schemaPath+e.util.getProperty(t),p=e.errSchemaPath+"/"+t,u=!e.opts.allErrors,l="data"+(n||""),m="valid"+i,f=e.opts.$data&&s&&s.$data;if(f?(r+=" var schema"+i+" = "+e.util.getData(s.$data,n,e.dataPathArr)+"; ",o="schema"+i):o=s,(s||f)&&!1!==e.opts.uniqueItems){f&&(r+=" var "+m+"; if ("+o+" === false || "+o+" === undefined) "+m+" = true; else if (typeof "+o+" != 'boolean') "+m+" = false; else { "),r+=" var i = "+l+".length , "+m+" = true , j; if (i > 1) { ";var h=e.schema.items&&e.schema.items.type,g=Array.isArray(h);if(!h||"object"==h||"array"==h||g&&(h.indexOf("object")>=0||h.indexOf("array")>=0))r+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+l+"[i], "+l+"[j])) { "+m+" = false; break outer; } } } ";else{r+=" var itemIndices = {}, item; for (;i--;) { var item = "+l+"[i]; ";var y="checkDataType"+(g?"s":"");r+=" if ("+e.util[y](h,"item",e.opts.strictNumbers,!0)+") continue; ",g&&(r+=" if (typeof item == 'string') item = '\"' + item; "),r+=" if (typeof itemIndices[item] == 'number') { "+m+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "}r+=" } ",f&&(r+="  }  "),r+=" if (!"+m+") {   ";var b=b||[];b.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(p)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(r+=" , schema:  ",r+=f?"validate.schema"+c:""+s,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+l+" "),r+=" } "):r+=" {} ";var x=r;r=b.pop(),!e.compositeRule&&u?e.async?r+=" throw new ValidationError(["+x+"]); ":r+=" validate.errors = ["+x+"]; return false; ":r+=" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } ",u&&(r+=" else { ")}else u&&(r+=" if (true) { ");return r}},45753:(e,t,a)=>{"undefined"==typeof process||"renderer"===process.type||!0===process.browser||process.__nwjs?e.exports=a(17833):e.exports=a(76033)},45905:e=>{"use strict";e.exports=preferredEncodings,e.exports.preferredEncodings=preferredEncodings;var t=/^\s*([^\s;]+)\s*(?:;(.*))?$/;function parseEncoding(e,a){var o=t.exec(e);if(!o)return null;var r=o[1],i=1;if(o[2])for(var n=o[2].split(";"),s=0;s<n.length;s++){var c=n[s].trim().split("=");if("q"===c[0]){i=parseFloat(c[1]);break}}return{encoding:r,q:i,i:a}}function specify(e,t,a){var o=0;if(t.encoding.toLowerCase()===e.toLowerCase())o|=1;else if("*"!==t.encoding)return null;return{i:a,o:t.i,q:t.q,s:o}}function preferredEncodings(e,t){var a=function parseAcceptEncoding(e){for(var t=e.split(","),a=!1,o=1,r=0,i=0;r<t.length;r++){var n=parseEncoding(t[r].trim(),r);n&&(t[i++]=n,a=a||specify("identity",n),o=Math.min(o,n.q||1))}return a||(t[i++]={encoding:"identity",q:o,i:r}),t.length=i,t}(e||"");if(!t)return a.filter(isQuality).sort(compareSpecs).map(getFullEncoding);var o=t.map(function getPriority(e,t){return function getEncodingPriority(e,t,a){for(var o={o:-1,q:0,s:0},r=0;r<t.length;r++){var i=specify(e,t[r],a);i&&(o.s-i.s||o.q-i.q||o.o-i.o)<0&&(o=i)}return o}(e,a,t)});return o.filter(isQuality).sort(compareSpecs).map(function getEncoding(e){return t[o.indexOf(e)]})}function compareSpecs(e,t){return t.q-e.q||t.s-e.s||e.o-t.o||e.i-t.i||0}function getFullEncoding(e){return e.encoding}function isQuality(e){return e.q>0}},46163:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseBrandedDef=void 0;const o=a(73524);t.parseBrandedDef=function parseBrandedDef(e,t){return(0,o.parseDef)(e.type._def,t)}},46170:(e,t,a)=>{"use strict";const o=a(53908),r=a(30144),{safeRe:i,t:n}=a(99718);e.exports=(e,t)=>{if(e instanceof o)return e;if("number"==typeof e&&(e=String(e)),"string"!=typeof e)return null;let a=null;if((t=t||{}).rtl){const o=t.includePrerelease?i[n.COERCERTLFULL]:i[n.COERCERTL];let r;for(;(r=o.exec(e))&&(!a||a.index+a[0].length!==e.length);)a&&r.index+r[0].length===a.index+a[0].length||(a=r),o.lastIndex=r.index+r[1].length+r[2].length;o.lastIndex=-1}else a=e.match(t.includePrerelease?i[n.COERCEFULL]:i[n.COERCE]);if(null===a)return null;const s=a[2],c=a[3]||"0",p=a[4]||"0",u=t.includePrerelease&&a[5]?`-${a[5]}`:"",l=t.includePrerelease&&a[6]?`+${a[6]}`:"";return r(`${s}.${c}.${p}${u}${l}`,t)}},46172:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.parseObjectDef=void 0;const o=a(21614),r=a(73524);function safeIsOptional(e){try{return e.isOptional()}catch{return!0}}t.parseObjectDef=function parseObjectDef(e,t){const a="openAi"===t.target,i={type:"object",properties:{}},n=[],s=e.shape();for(const e in s){let c=s[e];if(void 0===c||void 0===c._def)continue;let p=safeIsOptional(c);p&&a&&(c instanceof o.ZodOptional&&(c=c._def.innerType),c.isNullable()||(c=c.nullable()),p=!1);const u=(0,r.parseDef)(c._def,{...t,currentPath:[...t.currentPath,"properties",e],propertyPath:[...t.currentPath,"properties",e]});void 0!==u&&(i.properties[e]=u,p||n.push(e))}n.length&&(i.required=n);const c=function decideAdditionalProperties(e,t){if("ZodNever"!==e.catchall._def.typeName)return(0,r.parseDef)(e.catchall._def,{...t,currentPath:[...t.currentPath,"additionalProperties"]});switch(e.unknownKeys){case"passthrough":return t.allowedAdditionalProperties;case"strict":return t.rejectedAdditionalProperties;case"strip":return"strict"===t.removeAdditionalStrategy?t.allowedAdditionalProperties:t.rejectedAdditionalProperties}}(e,t);return void 0!==c&&(i.additionalProperties=c),i}},46254:(e,t,a)=>{"use strict";const o=a(53908);e.exports=(e,t)=>new o(e,t).minor},46309:(e,t,a)=>{e.exports=SSHBuffer;var o=a(94742),r=a(54774).Buffer;function SSHBuffer(e){o.object(e,"options"),void 0!==e.buffer&&o.buffer(e.buffer,"options.buffer"),this._size=e.buffer?e.buffer.length:1024,this._buffer=e.buffer||r.alloc(this._size),this._offset=0}SSHBuffer.prototype.toBuffer=function(){return this._buffer.slice(0,this._offset)},SSHBuffer.prototype.atEnd=function(){return this._offset>=this._buffer.length},SSHBuffer.prototype.remainder=function(){return this._buffer.slice(this._offset)},SSHBuffer.prototype.skip=function(e){this._offset+=e},SSHBuffer.prototype.expand=function(){this._size*=2;var e=r.alloc(this._size);this._buffer.copy(e,0),this._buffer=e},SSHBuffer.prototype.readPart=function(){return{data:this.readBuffer()}},SSHBuffer.prototype.readBuffer=function(){var e=this._buffer.readUInt32BE(this._offset);this._offset+=4,o.ok(this._offset+e<=this._buffer.length,"length out of bounds at +0x"+this._offset.toString(16)+" (data truncated?)");var t=this._buffer.slice(this._offset,this._offset+e);return this._offset+=e,t},SSHBuffer.prototype.readString=function(){return this.readBuffer().toString()},SSHBuffer.prototype.readCString=function(){for(var e=this._offset;e<this._buffer.length&&0!==this._buffer[e];)e++;o.ok(e<this._buffer.length,"c string does not terminate");var t=this._buffer.slice(this._offset,e).toString();return this._offset=e+1,t},SSHBuffer.prototype.readInt=function(){var e=this._buffer.readUInt32BE(this._offset);return this._offset+=4,e},SSHBuffer.prototype.readInt64=function(){o.ok(this._offset+8<this._buffer.length,"buffer not long enough to read Int64");var e=this._buffer.slice(this._offset,this._offset+8);return this._offset+=8,e},SSHBuffer.prototype.readChar=function(){return this._buffer[this._offset++]},SSHBuffer.prototype.writeBuffer=function(e){for(;this._offset+4+e.length>this._size;)this.expand();this._buffer.writeUInt32BE(e.length,this._offset),this._offset+=4,e.copy(this._buffer,this._offset),this._offset+=e.length},SSHBuffer.prototype.writeString=function(e){this.writeBuffer(r.from(e,"utf8"))},SSHBuffer.prototype.writeCString=function(e){for(;this._offset+1+e.length>this._size;)this.expand();this._buffer.write(e,this._offset),this._offset+=e.length,this._buffer[this._offset++]=0},SSHBuffer.prototype.writeInt=function(e){for(;this._offset+4>this._size;)this.expand();this._buffer.writeUInt32BE(e,this._offset),this._offset+=4},SSHBuffer.prototype.writeInt64=function(e){if(o.buffer(e,"value"),e.length>8){for(var t=e.slice(0,e.length-8),a=0;a<t.length;++a)o.strictEqual(t[a],0,"must fit in 64 bits of precision");e=e.slice(e.length-8,e.length)}for(;this._offset+8>this._size;)this.expand();e.copy(this._buffer,this._offset),this._offset+=8},SSHBuffer.prototype.writeChar=function(e){for(;this._offset+1>this._size;)this.expand();this._buffer[this._offset++]=e},SSHBuffer.prototype.writePart=function(e){this.writeBuffer(e.data)},SSHBuffer.prototype.write=function(e){for(;this._offset+e.length>this._size;)this.expand();e.copy(this._buffer,this._offset),this._offset+=e.length}},46397:(e,t,a)=>{e.exports={read:function read(e,t){return u.read(e,t,"pkcs1")},readPkcs1:function readPkcs1(e,t,a){switch(e){case"RSA":if("public"===t)return function readPkcs1RSAPublic(e){var t=readMPInt(e,"modulus"),a=readMPInt(e,"exponent");return new c({type:"rsa",parts:[{name:"e",data:a},{name:"n",data:t}]})}(a);if("private"===t)return function readPkcs1RSAPrivate(e){var t=readMPInt(e,"version");o.strictEqual(t[0],0);var a=readMPInt(e,"modulus"),r=readMPInt(e,"public exponent"),i=readMPInt(e,"private exponent"),n=readMPInt(e,"prime1"),s=readMPInt(e,"prime2"),c=readMPInt(e,"exponent1"),u=readMPInt(e,"exponent2"),l=readMPInt(e,"iqmp");return new p({type:"rsa",parts:[{name:"n",data:a},{name:"e",data:r},{name:"d",data:i},{name:"iqmp",data:l},{name:"p",data:n},{name:"q",data:s},{name:"dmodp",data:c},{name:"dmodq",data:u}]})}(a);throw new Error("Unknown key type: "+t);case"DSA":if("public"===t)return function readPkcs1DSAPublic(e){var t=readMPInt(e,"y"),a=readMPInt(e,"p"),o=readMPInt(e,"q"),r=readMPInt(e,"g");return new c({type:"dsa",parts:[{name:"y",data:t},{name:"p",data:a},{name:"q",data:o},{name:"g",data:r}]})}(a);if("private"===t)return function readPkcs1DSAPrivate(e){var t=readMPInt(e,"version");o.strictEqual(t.readUInt8(0),0);var a=readMPInt(e,"p"),r=readMPInt(e,"q"),i=readMPInt(e,"g"),n=readMPInt(e,"y"),s=readMPInt(e,"x");return new p({type:"dsa",parts:[{name:"p",data:a},{name:"q",data:r},{name:"g",data:i},{name:"y",data:n},{name:"x",data:s}]})}(a);throw new Error("Unknown key type: "+t);case"EC":case"ECDSA":if("private"===t)return function readPkcs1ECDSAPrivate(e){var t=readMPInt(e,"version");o.strictEqual(t.readUInt8(0),1);var a=e.readString(r.Ber.OctetString,!0);e.readSequence(160);var n=l(e);o.string(n,"a known elliptic curve"),e.readSequence(161);var c=e.readString(r.Ber.BitString,!0);c=s.ecNormalize(c);var u={type:"ecdsa",parts:[{name:"curve",data:i.from(n)},{name:"Q",data:c},{name:"d",data:a}]};return new p(u)}(a);if("public"===t)return function readPkcs1ECDSAPublic(e){e.readSequence();var t=e.readOID();o.strictEqual(t,"1.2.840.10045.2.1","must be ecPublicKey");for(var a,p=e.readOID(),u=Object.keys(n.curves),l=0;l<u.length;++l){var m=u[l];if(n.curves[m].pkcs8oid===p){a=m;break}}o.string(a,"a known ECDSA named curve");var f=e.readString(r.Ber.BitString,!0);f=s.ecNormalize(f);var h={type:"ecdsa",parts:[{name:"curve",data:i.from(a)},{name:"Q",data:f}]};return new c(h)}(a);throw new Error("Unknown key type: "+t);case"EDDSA":case"EdDSA":if("private"===t)return function readPkcs1EdDSAPrivate(e){var t=readMPInt(e,"version");o.strictEqual(t.readUInt8(0),1);var a=e.readString(r.Ber.OctetString,!0);e.readSequence(160);var i=e.readOID();o.strictEqual(i,"1.3.101.112","the ed25519 curve identifier"),e.readSequence(161);var n=s.readBitString(e),c={type:"ed25519",parts:[{name:"A",data:s.zeroPadToLength(n,32)},{name:"k",data:a}]};return new p(c)}(a);throw new Error(t+" keys not supported with EdDSA");default:throw new Error("Unknown key algo: "+e)}},write:function write(e,t){return u.write(e,t,"pkcs1")},writePkcs1:function writePkcs1(e,t){switch(e.startSequence(),t.type){case"rsa":p.isPrivateKey(t)?function writePkcs1RSAPrivate(e,t){var a=i.from([0]);e.writeBuffer(a,r.Ber.Integer),e.writeBuffer(t.part.n.data,r.Ber.Integer),e.writeBuffer(t.part.e.data,r.Ber.Integer),e.writeBuffer(t.part.d.data,r.Ber.Integer),e.writeBuffer(t.part.p.data,r.Ber.Integer),e.writeBuffer(t.part.q.data,r.Ber.Integer),t.part.dmodp&&t.part.dmodq||s.addRSAMissing(t);e.writeBuffer(t.part.dmodp.data,r.Ber.Integer),e.writeBuffer(t.part.dmodq.data,r.Ber.Integer),e.writeBuffer(t.part.iqmp.data,r.Ber.Integer)}(e,t):function writePkcs1RSAPublic(e,t){e.writeBuffer(t.part.n.data,r.Ber.Integer),e.writeBuffer(t.part.e.data,r.Ber.Integer)}(e,t);break;case"dsa":p.isPrivateKey(t)?function writePkcs1DSAPrivate(e,t){var a=i.from([0]);e.writeBuffer(a,r.Ber.Integer),e.writeBuffer(t.part.p.data,r.Ber.Integer),e.writeBuffer(t.part.q.data,r.Ber.Integer),e.writeBuffer(t.part.g.data,r.Ber.Integer),e.writeBuffer(t.part.y.data,r.Ber.Integer),e.writeBuffer(t.part.x.data,r.Ber.Integer)}(e,t):function writePkcs1DSAPublic(e,t){e.writeBuffer(t.part.y.data,r.Ber.Integer),e.writeBuffer(t.part.p.data,r.Ber.Integer),e.writeBuffer(t.part.q.data,r.Ber.Integer),e.writeBuffer(t.part.g.data,r.Ber.Integer)}(e,t);break;case"ecdsa":p.isPrivateKey(t)?function writePkcs1ECDSAPrivate(e,t){var a=i.from([1]);e.writeBuffer(a,r.Ber.Integer),e.writeBuffer(t.part.d.data,r.Ber.OctetString),e.startSequence(160);var c=t.part.curve.data.toString(),p=n.curves[c].pkcs8oid;o.string(p,"a known ECDSA named curve"),e.writeOID(p),e.endSequence(),e.startSequence(161);var u=s.ecNormalize(t.part.Q.data,!0);e.writeBuffer(u,r.Ber.BitString),e.endSequence()}(e,t):function writePkcs1ECDSAPublic(e,t){e.startSequence(),e.writeOID("1.2.840.10045.2.1");var a=t.part.curve.data.toString(),i=n.curves[a].pkcs8oid;o.string(i,"a known ECDSA named curve"),e.writeOID(i),e.endSequence();var c=s.ecNormalize(t.part.Q.data,!0);e.writeBuffer(c,r.Ber.BitString)}(e,t);break;case"ed25519":p.isPrivateKey(t)?function writePkcs1EdDSAPrivate(e,t){var a=i.from([1]);e.writeBuffer(a,r.Ber.Integer),e.writeBuffer(t.part.k.data,r.Ber.OctetString),e.startSequence(160),e.writeOID("1.3.101.112"),e.endSequence(),e.startSequence(161),s.writeBitString(e,t.part.A.data),e.endSequence()}(e,t):function writePkcs1EdDSAPublic(e,t){throw new Error("Public keys are not supported for EdDSA PKCS#1")}();break;default:throw new Error("Unknown key algo: "+t.type)}e.endSequence()}};var o=a(94742),r=a(53100),i=a(54774).Buffer,n=a(6641),s=a(87461),c=a(64479),p=a(90009),u=a(43809),l=a(78038).readECDSACurve;function readMPInt(e,t){return o.strictEqual(e.peek(),r.Ber.Integer,t+" is not an Integer"),s.mpNormalize(e.readString(r.Ber.Integer,!0))}},46429:(e,t,a)=>{"use strict";var o=a(61823),r=Object.prototype.hasOwnProperty,i={allowDots:!1,allowPrototypes:!1,arrayLimit:20,decoder:o.decode,delimiter:"&",depth:5,parameterLimit:1e3,plainObjects:!1,strictNullHandling:!1},n=function parseQueryStringKeys(e,t,a){if(e){var o=a.allowDots?e.replace(/\.([^.[]+)/g,"[$1]"):e,i=/(\[[^[\]]*])/g,n=/(\[[^[\]]*])/.exec(o),s=n?o.slice(0,n.index):o,c=[];if(s){if(!a.plainObjects&&r.call(Object.prototype,s)&&!a.allowPrototypes)return;c.push(s)}for(var p=0;null!==(n=i.exec(o))&&p<a.depth;){if(p+=1,!a.plainObjects&&r.call(Object.prototype,n[1].slice(1,-1))&&!a.allowPrototypes)return;c.push(n[1])}return n&&c.push("["+o.slice(n.index)+"]"),function(e,t,a){for(var o=t,r=e.length-1;r>=0;--r){var i,n=e[r];if("[]"===n&&a.parseArrays)i=[].concat(o);else{i=a.plainObjects?Object.create(null):{};var s="["===n.charAt(0)&&"]"===n.charAt(n.length-1)?n.slice(1,-1):n,c=parseInt(s,10);a.parseArrays||""!==s?!isNaN(c)&&n!==s&&String(c)===s&&c>=0&&a.parseArrays&&c<=a.arrayLimit?(i=[])[c]=o:"__proto__"!==s&&(i[s]=o):i={0:o}}o=i}return o}(c,t,a)}};e.exports=function(e,t){var a=t?o.assign({},t):{};if(null!==a.decoder&&void 0!==a.decoder&&"function"!=typeof a.decoder)throw new TypeError("Decoder has to be a function.");if(a.ignoreQueryPrefix=!0===a.ignoreQueryPrefix,a.delimiter="string"==typeof a.delimiter||o.isRegExp(a.delimiter)?a.delimiter:i.delimiter,a.depth="number"==typeof a.depth?a.depth:i.depth,a.arrayLimit="number"==typeof a.arrayLimit?a.arrayLimit:i.arrayLimit,a.parseArrays=!1!==a.parseArrays,a.decoder="function"==typeof a.decoder?a.decoder:i.decoder,a.allowDots="boolean"==typeof a.allowDots?a.allowDots:i.allowDots,a.plainObjects="boolean"==typeof a.plainObjects?a.plainObjects:i.plainObjects,a.allowPrototypes="boolean"==typeof a.allowPrototypes?a.allowPrototypes:i.allowPrototypes,a.parameterLimit="number"==typeof a.parameterLimit?a.parameterLimit:i.parameterLimit,a.strictNullHandling="boolean"==typeof a.strictNullHandling?a.strictNullHandling:i.strictNullHandling,""===e||null==e)return a.plainObjects?Object.create(null):{};for(var s="string"==typeof e?function parseQueryStringValues(e,t){for(var a={},o=t.ignoreQueryPrefix?e.replace(/^\?/,""):e,n=t.parameterLimit===1/0?void 0:t.parameterLimit,s=o.split(t.delimiter,n),c=0;c<s.length;++c){var p,u,l=s[c],m=l.indexOf("]="),f=-1===m?l.indexOf("="):m+1;-1===f?(p=t.decoder(l,i.decoder),u=t.strictNullHandling?null:""):(p=t.decoder(l.slice(0,f),i.decoder),u=t.decoder(l.slice(f+1),i.decoder)),r.call(a,p)?a[p]=[].concat(a[p]).concat(u):a[p]=u}return a}(e,a):e,c=a.plainObjects?Object.create(null):{},p=Object.keys(s),u=0;u<p.length;++u){var l=p[u],m=n(l,s[l],a);c=o.merge(c,m,a)}return o.compact(c)}},46579:function(e,t){!function(e){"use strict";function merge(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++)t[a]=arguments[a];if(t.length>1){t[0]=t[0].slice(0,-1);for(var o=t.length-1,r=1;r<o;++r)t[r]=t[r].slice(1,-1);return t[o]=t[o].slice(1),t.join("")}return t[0]}function subexp(e){return"(?:"+e+")"}function typeOf(e){return void 0===e?"undefined":null===e?"null":Object.prototype.toString.call(e).split(" ").pop().split("]").shift().toLowerCase()}function toUpperCase(e){return e.toUpperCase()}function toArray(e){return null!=e?e instanceof Array?e:"number"!=typeof e.length||e.split||e.setInterval||e.call?[e]:Array.prototype.slice.call(e):[]}function assign(e,t){var a=e;if(t)for(var o in t)a[o]=t[o];return a}function buildExps(e){var t="[A-Za-z]",a="[0-9]",o=merge(a,"[A-Fa-f]"),r=subexp(subexp("%[EFef]"+o+"%"+o+o+"%"+o+o)+"|"+subexp("%[89A-Fa-f]"+o+"%"+o+o)+"|"+subexp("%"+o+o)),i="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",n=merge("[\\:\\/\\?\\#\\[\\]\\@]",i),s=e?"[\\uE000-\\uF8FF]":"[]",c=merge(t,a,"[\\-\\.\\_\\~]",e?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]"),p=subexp(t+merge(t,a,"[\\+\\-\\.]")+"*"),u=subexp(subexp(r+"|"+merge(c,i,"[\\:]"))+"*"),l=(subexp(subexp("25[0-5]")+"|"+subexp("2[0-4]"+a)+"|"+subexp("1"+a+a)+"|"+subexp("[1-9]"+a)+"|"+a),subexp(subexp("25[0-5]")+"|"+subexp("2[0-4]"+a)+"|"+subexp("1"+a+a)+"|"+subexp("0?[1-9]"+a)+"|0?0?"+a)),m=subexp(l+"\\."+l+"\\."+l+"\\."+l),f=subexp(o+"{1,4}"),h=subexp(subexp(f+"\\:"+f)+"|"+m),g=subexp(subexp(f+"\\:")+"{6}"+h),y=subexp("\\:\\:"+subexp(f+"\\:")+"{5}"+h),b=subexp(subexp(f)+"?\\:\\:"+subexp(f+"\\:")+"{4}"+h),x=subexp(subexp(subexp(f+"\\:")+"{0,1}"+f)+"?\\:\\:"+subexp(f+"\\:")+"{3}"+h),w=subexp(subexp(subexp(f+"\\:")+"{0,2}"+f)+"?\\:\\:"+subexp(f+"\\:")+"{2}"+h),k=subexp(subexp(subexp(f+"\\:")+"{0,3}"+f)+"?\\:\\:"+f+"\\:"+h),j=subexp(subexp(subexp(f+"\\:")+"{0,4}"+f)+"?\\:\\:"+h),C=subexp(subexp(subexp(f+"\\:")+"{0,5}"+f)+"?\\:\\:"+f),P=subexp(subexp(subexp(f+"\\:")+"{0,6}"+f)+"?\\:\\:"),O=subexp([g,y,b,x,w,k,j,C,P].join("|")),I=subexp(subexp(c+"|"+r)+"+"),z=(subexp(O+"\\%25"+I),subexp(O+subexp("\\%25|\\%(?!"+o+"{2})")+I)),q=subexp("[vV]"+o+"+\\."+merge(c,i,"[\\:]")+"+"),$=subexp("\\["+subexp(z+"|"+O+"|"+q)+"\\]"),H=subexp(subexp(r+"|"+merge(c,i))+"*"),V=subexp($+"|"+m+"(?!"+H+")|"+H),G=subexp(a+"*"),W=subexp(subexp(u+"@")+"?"+V+subexp("\\:"+G)+"?"),X=subexp(r+"|"+merge(c,i,"[\\:\\@]")),Y=subexp(X+"*"),ee=subexp(X+"+"),te=subexp(subexp(r+"|"+merge(c,i,"[\\@]"))+"+"),ae=subexp(subexp("\\/"+Y)+"*"),oe=subexp("\\/"+subexp(ee+ae)+"?"),re=subexp(te+ae),ie=subexp(ee+ae),ne="(?!"+X+")",se=(subexp(ae+"|"+oe+"|"+re+"|"+ie+"|"+ne),subexp(subexp(X+"|"+merge("[\\/\\?]",s))+"*")),ce=subexp(subexp(X+"|[\\/\\?]")+"*"),pe=subexp(subexp("\\/\\/"+W+ae)+"|"+oe+"|"+ie+"|"+ne),ue=subexp(p+"\\:"+pe+subexp("\\?"+se)+"?"+subexp("\\#"+ce)+"?"),le=subexp(subexp("\\/\\/"+W+ae)+"|"+oe+"|"+re+"|"+ne),de=subexp(le+subexp("\\?"+se)+"?"+subexp("\\#"+ce)+"?");return subexp(ue+"|"+de),subexp(p+"\\:"+pe+subexp("\\?"+se)+"?"),subexp(subexp("\\/\\/("+subexp("("+u+")@")+"?("+V+")"+subexp("\\:("+G+")")+"?)")+"?("+ae+"|"+oe+"|"+ie+"|"+ne+")"),subexp("\\?("+se+")"),subexp("\\#("+ce+")"),subexp(subexp("\\/\\/("+subexp("("+u+")@")+"?("+V+")"+subexp("\\:("+G+")")+"?)")+"?("+ae+"|"+oe+"|"+re+"|"+ne+")"),subexp("\\?("+se+")"),subexp("\\#("+ce+")"),subexp(subexp("\\/\\/("+subexp("("+u+")@")+"?("+V+")"+subexp("\\:("+G+")")+"?)")+"?("+ae+"|"+oe+"|"+ie+"|"+ne+")"),subexp("\\?("+se+")"),subexp("\\#("+ce+")"),subexp("("+u+")@"),subexp("\\:("+G+")"),{NOT_SCHEME:new RegExp(merge("[^]",t,a,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(merge("[^\\%\\:]",c,i),"g"),NOT_HOST:new RegExp(merge("[^\\%\\[\\]\\:]",c,i),"g"),NOT_PATH:new RegExp(merge("[^\\%\\/\\:\\@]",c,i),"g"),NOT_PATH_NOSCHEME:new RegExp(merge("[^\\%\\/\\@]",c,i),"g"),NOT_QUERY:new RegExp(merge("[^\\%]",c,i,"[\\:\\@\\/\\?]",s),"g"),NOT_FRAGMENT:new RegExp(merge("[^\\%]",c,i,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(merge("[^]",c,i),"g"),UNRESERVED:new RegExp(c,"g"),OTHER_CHARS:new RegExp(merge("[^\\%]",c,n),"g"),PCT_ENCODED:new RegExp(r,"g"),IPV4ADDRESS:new RegExp("^("+m+")$"),IPV6ADDRESS:new RegExp("^\\[?("+O+")"+subexp(subexp("\\%25|\\%(?!"+o+"{2})")+"("+I+")")+"?\\]?$")}}var t=buildExps(!1),a=buildExps(!0),o=function(){function sliceIterator(e,t){var a=[],o=!0,r=!1,i=void 0;try{for(var n,s=e[Symbol.iterator]();!(o=(n=s.next()).done)&&(a.push(n.value),!t||a.length!==t);o=!0);}catch(e){r=!0,i=e}finally{try{!o&&s.return&&s.return()}finally{if(r)throw i}}return a}return function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return sliceIterator(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),toConsumableArray=function(e){if(Array.isArray(e)){for(var t=0,a=Array(e.length);t<e.length;t++)a[t]=e[t];return a}return Array.from(e)},r=2147483647,i=36,n=1,s=26,c=38,p=700,u=72,l=128,m="-",f=/^xn--/,h=/[^\0-\x7E]/,g=/[\x2E\u3002\uFF0E\uFF61]/g,y={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},b=i-n,x=Math.floor,w=String.fromCharCode;function error$1(e){throw new RangeError(y[e])}function map(e,t){for(var a=[],o=e.length;o--;)a[o]=t(e[o]);return a}function mapDomain(e,t){var a=e.split("@"),o="";return a.length>1&&(o=a[0]+"@",e=a[1]),o+map((e=e.replace(g,".")).split("."),t).join(".")}function ucs2decode(e){for(var t=[],a=0,o=e.length;a<o;){var r=e.charCodeAt(a++);if(r>=55296&&r<=56319&&a<o){var i=e.charCodeAt(a++);56320==(64512&i)?t.push(((1023&r)<<10)+(1023&i)+65536):(t.push(r),a--)}else t.push(r)}return t}var k=function basicToDigit(e){return e-48<10?e-22:e-65<26?e-65:e-97<26?e-97:i},j=function digitToBasic(e,t){return e+22+75*(e<26)-((0!=t)<<5)},C=function adapt(e,t,a){var o=0;for(e=a?x(e/p):e>>1,e+=x(e/t);e>b*s>>1;o+=i)e=x(e/b);return x(o+(b+1)*e/(e+c))},P=function decode(e){var t=[],a=e.length,o=0,c=l,p=u,f=e.lastIndexOf(m);f<0&&(f=0);for(var h=0;h<f;++h)e.charCodeAt(h)>=128&&error$1("not-basic"),t.push(e.charCodeAt(h));for(var g=f>0?f+1:0;g<a;){for(var y=o,b=1,w=i;;w+=i){g>=a&&error$1("invalid-input");var j=k(e.charCodeAt(g++));(j>=i||j>x((r-o)/b))&&error$1("overflow"),o+=j*b;var P=w<=p?n:w>=p+s?s:w-p;if(j<P)break;var O=i-P;b>x(r/O)&&error$1("overflow"),b*=O}var I=t.length+1;p=C(o-y,I,0==y),x(o/I)>r-c&&error$1("overflow"),c+=x(o/I),o%=I,t.splice(o++,0,c)}return String.fromCodePoint.apply(String,t)},O=function encode(e){var t=[],a=(e=ucs2decode(e)).length,o=l,c=0,p=u,f=!0,h=!1,g=void 0;try{for(var y,b=e[Symbol.iterator]();!(f=(y=b.next()).done);f=!0){var k=y.value;k<128&&t.push(w(k))}}catch(e){h=!0,g=e}finally{try{!f&&b.return&&b.return()}finally{if(h)throw g}}var P=t.length,O=P;for(P&&t.push(m);O<a;){var I=r,z=!0,q=!1,$=void 0;try{for(var H,V=e[Symbol.iterator]();!(z=(H=V.next()).done);z=!0){var G=H.value;G>=o&&G<I&&(I=G)}}catch(e){q=!0,$=e}finally{try{!z&&V.return&&V.return()}finally{if(q)throw $}}var W=O+1;I-o>x((r-c)/W)&&error$1("overflow"),c+=(I-o)*W,o=I;var X=!0,Y=!1,ee=void 0;try{for(var te,ae=e[Symbol.iterator]();!(X=(te=ae.next()).done);X=!0){var oe=te.value;if(oe<o&&++c>r&&error$1("overflow"),oe==o){for(var re=c,ie=i;;ie+=i){var ne=ie<=p?n:ie>=p+s?s:ie-p;if(re<ne)break;var se=re-ne,ce=i-ne;t.push(w(j(ne+se%ce,0))),re=x(se/ce)}t.push(w(j(re,0))),p=C(c,W,O==P),c=0,++O}}}catch(e){Y=!0,ee=e}finally{try{!X&&ae.return&&ae.return()}finally{if(Y)throw ee}}++c,++o}return t.join("")},I=function toUnicode(e){return mapDomain(e,function(e){return f.test(e)?P(e.slice(4).toLowerCase()):e})},z=function toASCII(e){return mapDomain(e,function(e){return h.test(e)?"xn--"+O(e):e})},q={version:"2.1.0",ucs2:{decode:ucs2decode,encode:function ucs2encode(e){return String.fromCodePoint.apply(String,toConsumableArray(e))}},decode:P,encode:O,toASCII:z,toUnicode:I},$={};function pctEncChar(e){var t=e.charCodeAt(0);return t<16?"%0"+t.toString(16).toUpperCase():t<128?"%"+t.toString(16).toUpperCase():t<2048?"%"+(t>>6|192).toString(16).toUpperCase()+"%"+(63&t|128).toString(16).toUpperCase():"%"+(t>>12|224).toString(16).toUpperCase()+"%"+(t>>6&63|128).toString(16).toUpperCase()+"%"+(63&t|128).toString(16).toUpperCase()}function pctDecChars(e){for(var t="",a=0,o=e.length;a<o;){var r=parseInt(e.substr(a+1,2),16);if(r<128)t+=String.fromCharCode(r),a+=3;else if(r>=194&&r<224){if(o-a>=6){var i=parseInt(e.substr(a+4,2),16);t+=String.fromCharCode((31&r)<<6|63&i)}else t+=e.substr(a,6);a+=6}else if(r>=224){if(o-a>=9){var n=parseInt(e.substr(a+4,2),16),s=parseInt(e.substr(a+7,2),16);t+=String.fromCharCode((15&r)<<12|(63&n)<<6|63&s)}else t+=e.substr(a,9);a+=9}else t+=e.substr(a,3),a+=3}return t}function _normalizeComponentEncoding(e,t){function decodeUnreserved(e){var a=pctDecChars(e);return a.match(t.UNRESERVED)?a:e}return e.scheme&&(e.scheme=String(e.scheme).replace(t.PCT_ENCODED,decodeUnreserved).toLowerCase().replace(t.NOT_SCHEME,"")),void 0!==e.userinfo&&(e.userinfo=String(e.userinfo).replace(t.PCT_ENCODED,decodeUnreserved).replace(t.NOT_USERINFO,pctEncChar).replace(t.PCT_ENCODED,toUpperCase)),void 0!==e.host&&(e.host=String(e.host).replace(t.PCT_ENCODED,decodeUnreserved).toLowerCase().replace(t.NOT_HOST,pctEncChar).replace(t.PCT_ENCODED,toUpperCase)),void 0!==e.path&&(e.path=String(e.path).replace(t.PCT_ENCODED,decodeUnreserved).replace(e.scheme?t.NOT_PATH:t.NOT_PATH_NOSCHEME,pctEncChar).replace(t.PCT_ENCODED,toUpperCase)),void 0!==e.query&&(e.query=String(e.query).replace(t.PCT_ENCODED,decodeUnreserved).replace(t.NOT_QUERY,pctEncChar).replace(t.PCT_ENCODED,toUpperCase)),void 0!==e.fragment&&(e.fragment=String(e.fragment).replace(t.PCT_ENCODED,decodeUnreserved).replace(t.NOT_FRAGMENT,pctEncChar).replace(t.PCT_ENCODED,toUpperCase)),e}function _stripLeadingZeros(e){return e.replace(/^0*(.*)/,"$1")||"0"}function _normalizeIPv4(e,t){var a=e.match(t.IPV4ADDRESS)||[],r=o(a,2)[1];return r?r.split(".").map(_stripLeadingZeros).join("."):e}function _normalizeIPv6(e,t){var a=e.match(t.IPV6ADDRESS)||[],r=o(a,3),i=r[1],n=r[2];if(i){for(var s=i.toLowerCase().split("::").reverse(),c=o(s,2),p=c[0],u=c[1],l=u?u.split(":").map(_stripLeadingZeros):[],m=p.split(":").map(_stripLeadingZeros),f=t.IPV4ADDRESS.test(m[m.length-1]),h=f?7:8,g=m.length-h,y=Array(h),b=0;b<h;++b)y[b]=l[b]||m[g+b]||"";f&&(y[h-1]=_normalizeIPv4(y[h-1],t));var x=y.reduce(function(e,t,a){if(!t||"0"===t){var o=e[e.length-1];o&&o.index+o.length===a?o.length++:e.push({index:a,length:1})}return e},[]).sort(function(e,t){return t.length-e.length})[0],w=void 0;if(x&&x.length>1){var k=y.slice(0,x.index),j=y.slice(x.index+x.length);w=k.join(":")+"::"+j.join(":")}else w=y.join(":");return n&&(w+="%"+n),w}return e}var H=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,V=void 0==="".match(/(){0}/)[1];function parse(e){var o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r={},i=!1!==o.iri?a:t;"suffix"===o.reference&&(e=(o.scheme?o.scheme+":":"")+"//"+e);var n=e.match(H);if(n){V?(r.scheme=n[1],r.userinfo=n[3],r.host=n[4],r.port=parseInt(n[5],10),r.path=n[6]||"",r.query=n[7],r.fragment=n[8],isNaN(r.port)&&(r.port=n[5])):(r.scheme=n[1]||void 0,r.userinfo=-1!==e.indexOf("@")?n[3]:void 0,r.host=-1!==e.indexOf("//")?n[4]:void 0,r.port=parseInt(n[5],10),r.path=n[6]||"",r.query=-1!==e.indexOf("?")?n[7]:void 0,r.fragment=-1!==e.indexOf("#")?n[8]:void 0,isNaN(r.port)&&(r.port=e.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?n[4]:void 0)),r.host&&(r.host=_normalizeIPv6(_normalizeIPv4(r.host,i),i)),void 0!==r.scheme||void 0!==r.userinfo||void 0!==r.host||void 0!==r.port||r.path||void 0!==r.query?void 0===r.scheme?r.reference="relative":void 0===r.fragment?r.reference="absolute":r.reference="uri":r.reference="same-document",o.reference&&"suffix"!==o.reference&&o.reference!==r.reference&&(r.error=r.error||"URI is not a "+o.reference+" reference.");var s=$[(o.scheme||r.scheme||"").toLowerCase()];if(o.unicodeSupport||s&&s.unicodeSupport)_normalizeComponentEncoding(r,i);else{if(r.host&&(o.domainHost||s&&s.domainHost))try{r.host=q.toASCII(r.host.replace(i.PCT_ENCODED,pctDecChars).toLowerCase())}catch(e){r.error=r.error||"Host's domain name can not be converted to ASCII via punycode: "+e}_normalizeComponentEncoding(r,t)}s&&s.parse&&s.parse(r,o)}else r.error=r.error||"URI can not be parsed.";return r}function _recomposeAuthority(e,o){var r=!1!==o.iri?a:t,i=[];return void 0!==e.userinfo&&(i.push(e.userinfo),i.push("@")),void 0!==e.host&&i.push(_normalizeIPv6(_normalizeIPv4(String(e.host),r),r).replace(r.IPV6ADDRESS,function(e,t,a){return"["+t+(a?"%25"+a:"")+"]"})),"number"!=typeof e.port&&"string"!=typeof e.port||(i.push(":"),i.push(String(e.port))),i.length?i.join(""):void 0}var G=/^\.\.?\//,W=/^\/\.(\/|$)/,X=/^\/\.\.(\/|$)/,Y=/^\/?(?:.|\n)*?(?=\/|$)/;function removeDotSegments(e){for(var t=[];e.length;)if(e.match(G))e=e.replace(G,"");else if(e.match(W))e=e.replace(W,"/");else if(e.match(X))e=e.replace(X,"/"),t.pop();else if("."===e||".."===e)e="";else{var a=e.match(Y);if(!a)throw new Error("Unexpected dot segment condition");var o=a[0];e=e.slice(o.length),t.push(o)}return t.join("")}function serialize(e){var o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=o.iri?a:t,i=[],n=$[(o.scheme||e.scheme||"").toLowerCase()];if(n&&n.serialize&&n.serialize(e,o),e.host)if(r.IPV6ADDRESS.test(e.host));else if(o.domainHost||n&&n.domainHost)try{e.host=o.iri?q.toUnicode(e.host):q.toASCII(e.host.replace(r.PCT_ENCODED,pctDecChars).toLowerCase())}catch(t){e.error=e.error||"Host's domain name can not be converted to "+(o.iri?"Unicode":"ASCII")+" via punycode: "+t}_normalizeComponentEncoding(e,r),"suffix"!==o.reference&&e.scheme&&(i.push(e.scheme),i.push(":"));var s=_recomposeAuthority(e,o);if(void 0!==s&&("suffix"!==o.reference&&i.push("//"),i.push(s),e.path&&"/"!==e.path.charAt(0)&&i.push("/")),void 0!==e.path){var c=e.path;o.absolutePath||n&&n.absolutePath||(c=removeDotSegments(c)),void 0===s&&(c=c.replace(/^\/\//,"/%2F")),i.push(c)}return void 0!==e.query&&(i.push("?"),i.push(e.query)),void 0!==e.fragment&&(i.push("#"),i.push(e.fragment)),i.join("")}function resolveComponents(e,t){var a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o={};return arguments[3]||(e=parse(serialize(e,a),a),t=parse(serialize(t,a),a)),!(a=a||{}).tolerant&&t.scheme?(o.scheme=t.scheme,o.userinfo=t.userinfo,o.host=t.host,o.port=t.port,o.path=removeDotSegments(t.path||""),o.query=t.query):(void 0!==t.userinfo||void 0!==t.host||void 0!==t.port?(o.userinfo=t.userinfo,o.host=t.host,o.port=t.port,o.path=removeDotSegments(t.path||""),o.query=t.query):(t.path?("/"===t.path.charAt(0)?o.path=removeDotSegments(t.path):(void 0===e.userinfo&&void 0===e.host&&void 0===e.port||e.path?e.path?o.path=e.path.slice(0,e.path.lastIndexOf("/")+1)+t.path:o.path=t.path:o.path="/"+t.path,o.path=removeDotSegments(o.path)),o.query=t.query):(o.path=e.path,void 0!==t.query?o.query=t.query:o.query=e.query),o.userinfo=e.userinfo,o.host=e.host,o.port=e.port),o.scheme=e.scheme),o.fragment=t.fragment,o}function resolve(e,t,a){var o=assign({scheme:"null"},a);return serialize(resolveComponents(parse(e,o),parse(t,o),o,!0),o)}function normalize(e,t){return"string"==typeof e?e=serialize(parse(e,t),t):"object"===typeOf(e)&&(e=parse(serialize(e,t),t)),e}function equal(e,t,a){return"string"==typeof e?e=serialize(parse(e,a),a):"object"===typeOf(e)&&(e=serialize(e,a)),"string"==typeof t?t=serialize(parse(t,a),a):"object"===typeOf(t)&&(t=serialize(t,a)),e===t}function escapeComponent(e,o){return e&&e.toString().replace(o&&o.iri?a.ESCAPE:t.ESCAPE,pctEncChar)}function unescapeComponent(e,o){return e&&e.toString().replace(o&&o.iri?a.PCT_ENCODED:t.PCT_ENCODED,pctDecChars)}var ee={scheme:"http",domainHost:!0,parse:function parse(e,t){return e.host||(e.error=e.error||"HTTP URIs must have a host."),e},serialize:function serialize(e,t){var a="https"===String(e.scheme).toLowerCase();return e.port!==(a?443:80)&&""!==e.port||(e.port=void 0),e.path||(e.path="/"),e}},te={scheme:"https",domainHost:ee.domainHost,parse:ee.parse,serialize:ee.serialize};function isSecure(e){return"boolean"==typeof e.secure?e.secure:"wss"===String(e.scheme).toLowerCase()}var ae={scheme:"ws",domainHost:!0,parse:function parse(e,t){var a=e;return a.secure=isSecure(a),a.resourceName=(a.path||"/")+(a.query?"?"+a.query:""),a.path=void 0,a.query=void 0,a},serialize:function serialize(e,t){if(e.port!==(isSecure(e)?443:80)&&""!==e.port||(e.port=void 0),"boolean"==typeof e.secure&&(e.scheme=e.secure?"wss":"ws",e.secure=void 0),e.resourceName){var a=e.resourceName.split("?"),r=o(a,2),i=r[0],n=r[1];e.path=i&&"/"!==i?i:void 0,e.query=n,e.resourceName=void 0}return e.fragment=void 0,e}},oe={scheme:"wss",domainHost:ae.domainHost,parse:ae.parse,serialize:ae.serialize},re={},ie="[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",ne="[0-9A-Fa-f]",se=subexp(subexp("%[EFef]"+ne+"%"+ne+ne+"%"+ne+ne)+"|"+subexp("%[89A-Fa-f]"+ne+"%"+ne+ne)+"|"+subexp("%"+ne+ne)),ce="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",pe=merge("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),ue="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",le=new RegExp(ie,"g"),de=new RegExp(se,"g"),me=new RegExp(merge("[^]",ce,"[\\.]",'[\\"]',pe),"g"),fe=new RegExp(merge("[^]",ie,ue),"g"),he=fe;function decodeUnreserved(e){var t=pctDecChars(e);return t.match(le)?t:e}var ge={scheme:"mailto",parse:function parse$$1(e,t){var a=e,o=a.to=a.path?a.path.split(","):[];if(a.path=void 0,a.query){for(var r=!1,i={},n=a.query.split("&"),s=0,c=n.length;s<c;++s){var p=n[s].split("=");switch(p[0]){case"to":for(var u=p[1].split(","),l=0,m=u.length;l<m;++l)o.push(u[l]);break;case"subject":a.subject=unescapeComponent(p[1],t);break;case"body":a.body=unescapeComponent(p[1],t);break;default:r=!0,i[unescapeComponent(p[0],t)]=unescapeComponent(p[1],t)}}r&&(a.headers=i)}a.query=void 0;for(var f=0,h=o.length;f<h;++f){var g=o[f].split("@");if(g[0]=unescapeComponent(g[0]),t.unicodeSupport)g[1]=unescapeComponent(g[1],t).toLowerCase();else try{g[1]=q.toASCII(unescapeComponent(g[1],t).toLowerCase())}catch(e){a.error=a.error||"Email address's domain name can not be converted to ASCII via punycode: "+e}o[f]=g.join("@")}return a},serialize:function serialize$$1(e,t){var a=e,o=toArray(e.to);if(o){for(var r=0,i=o.length;r<i;++r){var n=String(o[r]),s=n.lastIndexOf("@"),c=n.slice(0,s).replace(de,decodeUnreserved).replace(de,toUpperCase).replace(me,pctEncChar),p=n.slice(s+1);try{p=t.iri?q.toUnicode(p):q.toASCII(unescapeComponent(p,t).toLowerCase())}catch(e){a.error=a.error||"Email address's domain name can not be converted to "+(t.iri?"Unicode":"ASCII")+" via punycode: "+e}o[r]=c+"@"+p}a.path=o.join(",")}var u=e.headers=e.headers||{};e.subject&&(u.subject=e.subject),e.body&&(u.body=e.body);var l=[];for(var m in u)u[m]!==re[m]&&l.push(m.replace(de,decodeUnreserved).replace(de,toUpperCase).replace(fe,pctEncChar)+"="+u[m].replace(de,decodeUnreserved).replace(de,toUpperCase).replace(he,pctEncChar));return l.length&&(a.query=l.join("&")),a}},ve=/^([^\:]+)\:(.*)/,ye={scheme:"urn",parse:function parse$$1(e,t){var a=e.path&&e.path.match(ve),o=e;if(a){var r=t.scheme||o.scheme||"urn",i=a[1].toLowerCase(),n=a[2],s=r+":"+(t.nid||i),c=$[s];o.nid=i,o.nss=n,o.path=void 0,c&&(o=c.parse(o,t))}else o.error=o.error||"URN can not be parsed.";return o},serialize:function serialize$$1(e,t){var a=t.scheme||e.scheme||"urn",o=e.nid,r=a+":"+(t.nid||o),i=$[r];i&&(e=i.serialize(e,t));var n=e,s=e.nss;return n.path=(o||t.nid)+":"+s,n}},be=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,xe={scheme:"urn:uuid",parse:function parse(e,t){var a=e;return a.uuid=a.nss,a.nss=void 0,t.tolerant||a.uuid&&a.uuid.match(be)||(a.error=a.error||"UUID is not valid."),a},serialize:function serialize(e,t){var a=e;return a.nss=(e.uuid||"").toLowerCase(),a}};$[ee.scheme]=ee,$[te.scheme]=te,$[ae.scheme]=ae,$[oe.scheme]=oe,$[ge.scheme]=ge,$[ye.scheme]=ye,$[xe.scheme]=xe,e.SCHEMES=$,e.pctEncChar=pctEncChar,e.pctDecChars=pctDecChars,e.parse=parse,e.removeDotSegments=removeDotSegments,e.serialize=serialize,e.resolveComponents=resolveComponents,e.resolve=resolve,e.normalize=normalize,e.equal=equal,e.escapeComponent=escapeComponent,e.unescapeComponent=unescapeComponent,Object.defineProperty(e,"__esModule",{value:!0})}(t)},47119:e=>{"use strict";e.exports="undefined"!=typeof Reflect&&Reflect&&Reflect.apply},47156:e=>{"use strict";e.exports=function generate_required(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="valid"+r,m=e.opts.$data&&n&&n.$data;m&&(o+=" var schema"+r+" = "+e.util.getData(n.$data,i,e.dataPathArr)+"; ");var f="schema"+r;if(!m)if(n.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var h=[],g=n;if(g)for(var y,b=-1,x=g.length-1;b<x;){y=g[b+=1];var w=e.schema.properties[y];w&&(e.opts.strictKeywords?"object"==typeof w&&Object.keys(w).length>0||!1===w:e.util.schemaHasRules(w,e.RULES.all))||(h[h.length]=y)}}else h=n;if(m||h.length){var k=e.errorPath,j=m||h.length>=e.opts.loopRequired,C=e.opts.ownProperties;if(p)if(o+=" var missing"+r+"; ",j){m||(o+=" var "+f+" = validate.schema"+s+"; ");var P="' + "+(H="schema"+r+"["+(z="i"+r)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(k,H,e.opts.jsonPointers)),o+=" var "+l+" = true; ",m&&(o+=" if (schema"+r+" === undefined) "+l+" = true; else if (!Array.isArray(schema"+r+")) "+l+" = false; else {"),o+=" for (var "+z+" = 0; "+z+" < "+f+".length; "+z+"++) { "+l+" = "+u+"["+f+"["+z+"]] !== undefined ",C&&(o+=" &&   Object.prototype.hasOwnProperty.call("+u+", "+f+"["+z+"]) "),o+="; if (!"+l+") break; } ",m&&(o+="  }  "),o+="  if (!"+l+") {   ",($=$||[]).push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { missingProperty: '"+P+"' } ",!1!==e.opts.messages&&(o+=" , message: '",e.opts._errorDataPathProperty?o+="is a required property":o+="should have required property \\'"+P+"\\'",o+="' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var O=o;o=$.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+O+"]); ":o+=" validate.errors = ["+O+"]; return false; ":o+=" var err = "+O+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } else { "}else{o+=" if ( ";var I=h;if(I)for(var z=-1,q=I.length-1;z<q;){G=I[z+=1],z&&(o+=" || "),o+=" ( ( "+(ee=u+(Y=e.util.getProperty(G)))+" === undefined ",C&&(o+=" || ! Object.prototype.hasOwnProperty.call("+u+", '"+e.util.escapeQuotes(G)+"') "),o+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?G:Y)+") ) "}o+=") {  ";var $;P="' + "+(H="missing"+r)+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(k,H,!0):k+" + "+H),($=$||[]).push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { missingProperty: '"+P+"' } ",!1!==e.opts.messages&&(o+=" , message: '",e.opts._errorDataPathProperty?o+="is a required property":o+="should have required property \\'"+P+"\\'",o+="' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";O=o;o=$.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+O+"]); ":o+=" validate.errors = ["+O+"]; return false; ":o+=" var err = "+O+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } else { "}else if(j){m||(o+=" var "+f+" = validate.schema"+s+"; ");var H;P="' + "+(H="schema"+r+"["+(z="i"+r)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(k,H,e.opts.jsonPointers)),m&&(o+=" if ("+f+" && !Array.isArray("+f+")) {  var err =   ",!1!==e.createErrors?(o+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { missingProperty: '"+P+"' } ",!1!==e.opts.messages&&(o+=" , message: '",e.opts._errorDataPathProperty?o+="is a required property":o+="should have required property \\'"+P+"\\'",o+="' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+f+" !== undefined) { "),o+=" for (var "+z+" = 0; "+z+" < "+f+".length; "+z+"++) { if ("+u+"["+f+"["+z+"]] === undefined ",C&&(o+=" || ! Object.prototype.hasOwnProperty.call("+u+", "+f+"["+z+"]) "),o+=") {  var err =   ",!1!==e.createErrors?(o+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { missingProperty: '"+P+"' } ",!1!==e.opts.messages&&(o+=" , message: '",e.opts._errorDataPathProperty?o+="is a required property":o+="should have required property \\'"+P+"\\'",o+="' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",m&&(o+="  }  ")}else{var V=h;if(V)for(var G,W=-1,X=V.length-1;W<X;){G=V[W+=1];var Y=e.util.getProperty(G),ee=(P=e.util.escapeQuotes(G),u+Y);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(k,G,e.opts.jsonPointers)),o+=" if ( "+ee+" === undefined ",C&&(o+=" || ! Object.prototype.hasOwnProperty.call("+u+", '"+e.util.escapeQuotes(G)+"') "),o+=") {  var err =   ",!1!==e.createErrors?(o+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { missingProperty: '"+P+"' } ",!1!==e.opts.messages&&(o+=" , message: '",e.opts._errorDataPathProperty?o+="is a required property":o+="should have required property \\'"+P+"\\'",o+="' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=k}else p&&(o+=" if (true) {");return o}},47255:function(e,t,a){"use strict";var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.restartProcess=t.checkAndUpdateIfNeeded=t.getCurrentVersion=void 0;const r=a(79896),i=o(a(16928)),n=a(93295),s=a(67587);t.getCurrentVersion=()=>(0,s.getPackageVersion)();t.checkAndUpdateIfNeeded=async()=>{try{const e=(0,t.getCurrentVersion)(),a=(()=>{const e=process.argv[1];return i.default.dirname(e)})(),o=i.default.join(a,"index.js"),s=await(async(e=1e3)=>{try{const t=new AbortController,a=setTimeout(()=>t.abort(),e),o=await(0,n.proxyFetch)("https://codebuddy-update.edgeone.site/version.json",{signal:t.signal,headers:{"User-Agent":"cb-pages-mcp-updater"}});return clearTimeout(a),o.ok?await o.json():null}catch(e){return null}})();if(!s)return!1;if(!((e,t)=>{const parseVersion=e=>e.split(".").map(e=>parseInt(e,10)),a=parseVersion(e),o=parseVersion(t);for(let e=0;e<Math.max(a.length,o.length);e++){const t=a[e]||0,r=o[e]||0;if(r>t)return!0;if(r<t)return!1}return!1})(e,s.latestVersion))return!1;console.log(`🔄 发现新版本 ${s.latestVersion}，当前版本 ${e}`),console.log("📥 正在下载更新...");return await(async(e,t,a=5e3)=>{try{const o=new AbortController,i=setTimeout(()=>o.abort(),a),s=await(0,n.proxyFetch)(e,{signal:o.signal,headers:{"User-Agent":"cb-pages-mcp-updater","Accept-Encoding":"gzip, deflate"}});if(clearTimeout(i),!s.ok)return!1;const c=await s.arrayBuffer();return await r.promises.writeFile(t,Buffer.from(c)),await r.promises.chmod(t,493),!0}catch(e){return!1}})(s.latestReleaseURL,o)?(console.log(`✅ 更新下载完成，版本 ${s.latestVersion}`),!0):(console.log(`❌ 更新下载失败，继续使用当前版本 ${e}`),!1)}catch(e){return!1}};t.restartProcess=()=>{const e=process.argv.slice(1),{spawn:t}=a(35317);console.log("🔄 重新启动进程...");t(process.execPath,e,{detached:!0,stdio:"inherit"}).unref(),process.exit(0)}},48067:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TokenData=void 0,t.parse=parse,t.compile=function compile(e,t={}){const{encode:o=encodeURIComponent,delimiter:r=a}=t,i=tokensToFunction((e instanceof TokenData?e:parse(e,t)).tokens,r,o);return function path(e={}){const[path,...t]=i(e);if(t.length)throw new TypeError(`Missing parameters: ${t.join(", ")}`);return path}},t.match=function match(e,t={}){const{decode:o=decodeURIComponent,delimiter:r=a}=t,{regexp:i,keys:n}=pathToRegexp(e,t),s=n.map(e=>!1===o?NOOP_VALUE:"param"===e.type?o:e=>e.split(r).map(o));return function match(e){const t=i.exec(e);if(!t)return!1;const a=t[0],o=Object.create(null);for(let e=1;e<t.length;e++){if(void 0===t[e])continue;const a=n[e-1],r=s[e-1];o[a.name]=r(t[e])}return{path:a,params:o}}},t.pathToRegexp=pathToRegexp,t.stringify=function stringify(e){return e.tokens.map(function stringifyToken(e,t,a){if("text"===e.type)return function escapeText(e){return e.replace(/[{}()\[\]+?!:*]/g,"\\$&")}(e.value);if("group"===e.type)return`{${e.tokens.map(stringifyToken).join("")}}`;const i=function isNameSafe(e){const[t,...a]=e;return!!o.test(t)&&a.every(e=>r.test(e))}(e.name)&&function isNextNameSafe(e){return"text"!==(null==e?void 0:e.type)||!r.test(e.value[0])}(a[t+1]),n=i?e.name:JSON.stringify(e.name);if("param"===e.type)return`:${n}`;if("wildcard"===e.type)return`*${n}`;throw new TypeError(`Unexpected token: ${e}`)}).join("")};const a="/",NOOP_VALUE=e=>e,o=/^[$_\p{ID_Start}]$/u,r=/^[$\u200c\u200d\p{ID_Continue}]$/u,i="https://git.new/pathToRegexpError",n={"{":"{","}":"}","(":"(",")":")","[":"[","]":"]","+":"+","?":"?","!":"!"};function escape(e){return e.replace(/[.+*?^${}()[\]|/\\]/g,"\\$&")}class Iter{constructor(e){this.tokens=e}peek(){if(!this._peek){const e=this.tokens.next();this._peek=e.value}return this._peek}tryConsume(e){const t=this.peek();if(t.type===e)return this._peek=void 0,t.value}consume(e){const t=this.tryConsume(e);if(void 0!==t)return t;const{type:a,index:o}=this.peek();throw new TypeError(`Unexpected ${a} at ${o}, expected ${e}: ${i}`)}text(){let e,t="";for(;e=this.tryConsume("CHAR")||this.tryConsume("ESCAPED");)t+=e;return t}}class TokenData{constructor(e){this.tokens=e}}function parse(e,t={}){const{encodePath:a=NOOP_VALUE}=t,s=new Iter(function*lexer(e){const t=[...e];let a=0;function name(){let e="";if(o.test(t[++a]))for(e+=t[a];r.test(t[++a]);)e+=t[a];else if('"'===t[a]){let o=a;for(;a<t.length;){if('"'===t[++a]){a++,o=0;break}e+="\\"===t[a]?t[++a]:t[a]}if(o)throw new TypeError(`Unterminated quote at ${o}: ${i}`)}if(!e)throw new TypeError(`Missing parameter name at ${a}: ${i}`);return e}for(;a<t.length;){const e=t[a],o=n[e];if(o)yield{type:o,index:a++,value:e};else if("\\"===e)yield{type:"ESCAPED",index:a++,value:t[a++]};else if(":"===e){const e=name();yield{type:"PARAM",index:a,value:e}}else if("*"===e){const e=name();yield{type:"WILDCARD",index:a,value:e}}else yield{type:"CHAR",index:a,value:t[a++]}}return{type:"END",index:a,value:""}}(e));const c=function consume(e){const t=[];for(;;){const o=s.text();o&&t.push({type:"text",value:a(o)});const r=s.tryConsume("PARAM");if(r){t.push({type:"param",name:r});continue}const i=s.tryConsume("WILDCARD");if(i){t.push({type:"wildcard",name:i});continue}if(!s.tryConsume("{"))return s.consume(e),t;t.push({type:"group",tokens:consume("}")})}}("END");return new TokenData(c)}function tokensToFunction(e,t,a){const o=e.map(e=>function tokenToFunction(e,t,a){if("text"===e.type)return()=>[e.value];if("group"===e.type){const o=tokensToFunction(e.tokens,t,a);return e=>{const[t,...a]=o(e);return a.length?[""]:[t]}}const o=a||NOOP_VALUE;if("wildcard"===e.type&&!1!==a)return a=>{const r=a[e.name];if(null==r)return["",e.name];if(!Array.isArray(r)||0===r.length)throw new TypeError(`Expected "${e.name}" to be a non-empty array`);return[r.map((t,a)=>{if("string"!=typeof t)throw new TypeError(`Expected "${e.name}/${a}" to be a string`);return o(t)}).join(t)]};return t=>{const a=t[e.name];if(null==a)return["",e.name];if("string"!=typeof a)throw new TypeError(`Expected "${e.name}" to be a string`);return[o(a)]}}(e,t,a));return e=>{const t=[""];for(const a of o){const[o,...r]=a(e);t[0]+=o,t.push(...r)}return t}}function pathToRegexp(e,t={}){const{delimiter:o=a,end:r=!0,sensitive:i=!1,trailing:n=!0}=t,s=[],c=[],p=i?"":"i",u=(Array.isArray(e)?e:[e]).map(e=>e instanceof TokenData?e:parse(e,t));for(const{tokens:e}of u)for(const t of flatten(e,0,[])){const e=sequenceToRegExp(t,o,s);c.push(e)}let l=`^(?:${c.join("|")})`;n&&(l+=`(?:${escape(o)}$)?`),l+=r?"$":`(?=${escape(o)}|$)`;return{regexp:new RegExp(l,p),keys:s}}function*flatten(e,t,a){if(t===e.length)return yield a;const o=e[t];if("group"===o.type){const r=a.slice();for(const a of flatten(o.tokens,0,r))yield*flatten(e,t+1,a)}else a.push(o);yield*flatten(e,t+1,a)}function sequenceToRegExp(e,t,a){let o="",r="",n=!0;for(let s=0;s<e.length;s++){const c=e[s];if("text"!==c.type)if("param"!==c.type&&"wildcard"!==c.type);else{if(!n&&!r)throw new TypeError(`Missing text after "${c.name}": ${i}`);"param"===c.type?o+=`(${negate(t,n?"":r)}+)`:o+="([\\s\\S]+)",a.push(c),r="",n=!1}else o+=escape(c.value),r+=c.value,n||(n=c.value.includes(t))}return o}function negate(e,t){return t.length<2?e.length<2?`[^${escape(e+t)}]`:`(?:(?!${escape(e)})[^${escape(t)}])`:e.length<2?`(?:(?!${escape(t)})[^${escape(e)}])`:`(?:(?!${escape(t)}|${escape(e)})[\\s\\S])`}t.TokenData=TokenData},48244:(e,t,a)=>{"use strict";var o=a(80613).MissingRef;e.exports=function compileAsync(e,t,a){var r=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof t&&(a=t,t=void 0);var i=loadMetaSchemaOf(e).then(function(){var a=r._addSchema(e,void 0,t);return a.validate||_compileAsync(a)});a&&i.then(function(e){a(null,e)},a);return i;function loadMetaSchemaOf(e){var t=e.$schema;return t&&!r.getSchema(t)?compileAsync.call(r,{$ref:t},!0):Promise.resolve()}function _compileAsync(e){try{return r._compile(e)}catch(a){if(a instanceof o)return function loadMissingSchema(a){var o=a.missingSchema;if(added(o))throw new Error("Schema "+o+" is loaded but "+a.missingRef+" cannot be resolved");var i=r._loadingSchemas[o];i||(i=r._loadingSchemas[o]=r._opts.loadSchema(o)).then(removePromise,removePromise);return i.then(function(e){if(!added(o))return loadMetaSchemaOf(e).then(function(){added(o)||r.addSchema(e,o,void 0,t)})}).then(function(){return _compileAsync(e)});function removePromise(){delete r._loadingSchemas[o]}function added(e){return r._refs[e]||r._schemas[e]}}(a);throw a}}}},48297:(e,t,a)=>{const{parse:o,format:r}=a(73136),{pathToRegexp:i,compile:n,parse:s}=a(48067);function safeDecodeURIComponent(e){try{return decodeURIComponent(e.replace(/\+/g," "))}catch{return e}}e.exports=class Layer{constructor(e,t,a,o={}){this.opts=o,this.name=this.opts.name||null,this.methods=[];for(const e of t){const t=this.methods.push(e.toUpperCase());"GET"===this.methods[t-1]&&this.methods.unshift("HEAD")}this.stack=Array.isArray(a)?a:[a];for(let a=0;a<this.stack.length;a++){const o=typeof this.stack[a];if("function"!==o)throw new Error(`${t.toString()} \`${this.opts.name||e}\`: \`middleware\` must be a function, not \`${o}\``)}if(this.path=e,this.paramNames=[],!0===this.opts.pathAsRegExp)this.regexp=new RegExp(e);else if(this.path){"strict"in this.opts&&(this.opts.trailing=!0!==this.opts.strict);const{regexp:e,keys:t}=i(this.path,this.opts);this.regexp=e,this.paramNames=t}}match(e){return this.regexp.test(e)}params(e,t,a={}){for(let e=t.length,o=0;o<e;o++)if(this.paramNames[o]){const e=t[o];e&&e.length>0&&(a[this.paramNames[o].name]=e?safeDecodeURIComponent(e):e)}return a}captures(e){return this.opts.ignoreCaptures?[]:e.match(this.regexp).slice(1)}url(e,t){let a=e;const i=this.path.replace(/\(\.\*\)/g,"");"object"!=typeof e&&(a=Array.prototype.slice.call(arguments),"object"==typeof a[a.length-1]&&(t=a[a.length-1],a=a.slice(0,-1)));const c=n(i,{encode:encodeURIComponent,...t});let p;const{tokens:u}=s(i);let l={};if(Array.isArray(a))for(let e=u.length,t=0,o=0;t<e;t++)u[t].name&&(l[u[t].name]=a[o++]);else u.some(e=>e.name)?l=e:t||(t=e);for(const[e,t]of Object.entries(l))l[e]=String(t);return p=c(l),t&&t.query?(p=o(p),"string"==typeof t.query?p.search=t.query:(p.search=void 0,p.query=t.query),r(p)):p}param(e,t){const{stack:a}=this,o=this.paramNames,middleware=function(a,o){return t.call(this,a.params[e],a,o)};middleware.param=e;const r=o.map(function(e){return e.name}),i=r.indexOf(e);return i>-1&&a.some((e,t)=>{if(!e.param||r.indexOf(e.param)>i)return a.splice(t,0,middleware),!0}),this}setPrefix(e){if(this.path)if(this.path="/"!==this.path||!0===this.opts.strict?`${e}${this.path}`:e,!0===this.opts.pathAsRegExp||e instanceof RegExp)this.regexp=new RegExp(this.path);else if(this.path){const{regexp:e,keys:t}=i(this.path,this.opts);this.regexp=e,this.paramNames=t}return this}}},48406:e=>{"use strict";e.exports=function generate_custom(e,t,a){var o,r,i=" ",n=e.level,s=e.dataLevel,c=e.schema[t],p=e.schemaPath+e.util.getProperty(t),u=e.errSchemaPath+"/"+t,l=!e.opts.allErrors,m="data"+(s||""),f="valid"+n,h="errs__"+n,g=e.opts.$data&&c&&c.$data;g?(i+=" var schema"+n+" = "+e.util.getData(c.$data,s,e.dataPathArr)+"; ",r="schema"+n):r=c;var y,b,x,w,k,j=this,C="definition"+n,P=j.definition,O="";if(g&&P.$data){k="keywordValidate"+n;var I=P.validateSchema;i+=" var "+C+" = RULES.custom['"+t+"'].definition; var "+k+" = "+C+".validate;"}else{if(!(w=e.useCustomRule(j,c,e.schema,e)))return;r="validate.schema"+p,k=w.code,y=P.compile,b=P.inline,x=P.macro}var z=k+".errors",q="i"+n,$="ruleErr"+n,H=P.async;if(H&&!e.async)throw new Error("async keyword in sync schema");if(b||x||(i+=z+" = null;"),i+="var "+h+" = errors;var "+f+";",g&&P.$data&&(O+="}",i+=" if ("+r+" === undefined) { "+f+" = true; } else { ",I&&(O+="}",i+=" "+f+" = "+C+".validateSchema("+r+"); if ("+f+") { ")),b)P.statements?i+=" "+w.validate+" ":i+=" "+f+" = "+w.validate+"; ";else if(x){var V=e.util.copy(e);O="";V.level++;var G="valid"+V.level;V.schema=w.validate,V.schemaPath="";var W=e.compositeRule;e.compositeRule=V.compositeRule=!0;var X=e.validate(V).replace(/validate\.schema/g,k);e.compositeRule=V.compositeRule=W,i+=" "+X}else{(ae=ae||[]).push(i),i="",i+="  "+k+".call( ",e.opts.passContext?i+="this":i+="self",y||!1===P.schema?i+=" , "+m+" ":i+=" , "+r+" , "+m+" , validate.schema"+e.schemaPath+" ",i+=" , (dataPath || '')",'""'!=e.errorPath&&(i+=" + "+e.errorPath);var Y=s?"data"+(s-1||""):"parentData",ee=s?e.dataPathArr[s]:"parentDataProperty",te=i+=" , "+Y+" , "+ee+" , rootData )  ";i=ae.pop(),!1===P.errors?(i+=" "+f+" = ",H&&(i+="await "),i+=te+"; "):i+=H?" var "+(z="customErrors"+n)+" = null; try { "+f+" = await "+te+"; } catch (e) { "+f+" = false; if (e instanceof ValidationError) "+z+" = e.errors; else throw e; } ":" "+z+" = null; "+f+" = "+te+"; "}if(P.modifying&&(i+=" if ("+Y+") "+m+" = "+Y+"["+ee+"];"),i+=""+O,P.valid)l&&(i+=" if (true) { ");else{var ae;i+=" if ( ",void 0===P.valid?(i+=" !",i+=x?""+G:""+f):i+=" "+!P.valid+" ",i+=") { ",o=j.keyword,(ae=ae||[]).push(i),i="",(ae=ae||[]).push(i),i="",!1!==e.createErrors?(i+=" { keyword: '"+(o||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(u)+" , params: { keyword: '"+j.keyword+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should pass \""+j.keyword+"\" keyword validation' "),e.opts.verbose&&(i+=" , schema: validate.schema"+p+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+m+" "),i+=" } "):i+=" {} ";var oe=i;i=ae.pop(),!e.compositeRule&&l?e.async?i+=" throw new ValidationError(["+oe+"]); ":i+=" validate.errors = ["+oe+"]; return false; ":i+=" var err = "+oe+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";var re=i;i=ae.pop(),b?P.errors?"full"!=P.errors&&(i+="  for (var "+q+"="+h+"; "+q+"<errors; "+q+"++) { var "+$+" = vErrors["+q+"]; if ("+$+".dataPath === undefined) "+$+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+$+".schemaPath === undefined) { "+$+'.schemaPath = "'+u+'"; } ',e.opts.verbose&&(i+=" "+$+".schema = "+r+"; "+$+".data = "+m+"; "),i+=" } "):!1===P.errors?i+=" "+re+" ":(i+=" if ("+h+" == errors) { "+re+" } else {  for (var "+q+"="+h+"; "+q+"<errors; "+q+"++) { var "+$+" = vErrors["+q+"]; if ("+$+".dataPath === undefined) "+$+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+$+".schemaPath === undefined) { "+$+'.schemaPath = "'+u+'"; } ',e.opts.verbose&&(i+=" "+$+".schema = "+r+"; "+$+".data = "+m+"; "),i+=" } } "):x?(i+="   var err =   ",!1!==e.createErrors?(i+=" { keyword: '"+(o||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(u)+" , params: { keyword: '"+j.keyword+"' } ",!1!==e.opts.messages&&(i+=" , message: 'should pass \""+j.keyword+"\" keyword validation' "),e.opts.verbose&&(i+=" , schema: validate.schema"+p+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+m+" "),i+=" } "):i+=" {} ",i+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&l&&(e.async?i+=" throw new ValidationError(vErrors); ":i+=" validate.errors = vErrors; return false; ")):!1===P.errors?i+=" "+re+" ":(i+=" if (Array.isArray("+z+")) { if (vErrors === null) vErrors = "+z+"; else vErrors = vErrors.concat("+z+"); errors = vErrors.length;  for (var "+q+"="+h+"; "+q+"<errors; "+q+"++) { var "+$+" = vErrors["+q+"]; if ("+$+".dataPath === undefined) "+$+".dataPath = (dataPath || '') + "+e.errorPath+";  "+$+'.schemaPath = "'+u+'";  ',e.opts.verbose&&(i+=" "+$+".schema = "+r+"; "+$+".data = "+m+"; "),i+=" } } else { "+re+" } "),i+=" } ",l&&(i+=" else { ")}return i}},48407:(e,t,a)=>{"use strict";var o=a(34610);e.exports=function SchemaObject(e){o.copy(e,this)}},48648:e=>{"use strict";e.exports="undefined"!=typeof Reflect&&Reflect.getPrototypeOf||null},48708:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.extendErrors=t.resetErrorsCount=t.reportExtraError=t.reportError=t.keyword$DataError=t.keywordError=void 0;const o=a(99029),r=a(42023);function addError(e,t){const a=e.const("err",t);e.if(o._`${r.default.vErrors} === null`,()=>e.assign(r.default.vErrors,o._`[${a}]`),o._`${r.default.vErrors}.push(${a})`),e.code(o._`${r.default.errors}++`)}function returnErrors(e,t){const{gen:a,validateName:r,schemaEnv:i}=e;i.$async?a.throw(o._`new ${e.ValidationError}(${t})`):(a.assign(o._`${r}.errors`,t),a.return(!1))}t.keywordError={message:({keyword:e})=>o.str`should pass "${e}" keyword validation`},t.keyword$DataError={message:({keyword:e,schemaType:t})=>t?o.str`"${e}" keyword must be ${t} ($data)`:o.str`"${e}" keyword is invalid ($data)`},t.reportError=function reportError(e,a=t.keywordError,r){const{it:i}=e,{gen:n,compositeRule:s,allErrors:c}=i,p=errorObjectCode(e,a);(null!=r?r:s||c)?addError(n,p):returnErrors(i,o._`[${p}]`)},t.reportExtraError=function reportExtraError(e,a=t.keywordError){const{it:o}=e,{gen:i,compositeRule:n,allErrors:s}=o;addError(i,errorObjectCode(e,a)),n||s||returnErrors(o,r.default.vErrors)},t.resetErrorsCount=function resetErrorsCount(e,t){e.assign(r.default.errors,t),e.if(o._`${r.default.vErrors} !== null`,()=>e.if(t,()=>e.assign(o._`${r.default.vErrors}.length`,t),()=>e.assign(r.default.vErrors,null)))},t.extendErrors=function extendErrors({gen:e,keyword:t,schemaValue:a,data:i,errsCount:n,it:s}){if(void 0===n)throw new Error("ajv implementation error");const c=e.name("err");e.forRange("i",n,r.default.errors,n=>{e.const(c,o._`${r.default.vErrors}[${n}]`),e.if(o._`${c}.dataPath === undefined`,()=>e.assign(o._`${c}.dataPath`,o.strConcat(r.default.dataPath,s.errorPath))),e.assign(o._`${c}.schemaPath`,o.str`${s.errSchemaPath}/${t}`),s.opts.verbose&&(e.assign(o._`${c}.schema`,a),e.assign(o._`${c}.data`,i))})};const i={keyword:new o.Name("keyword"),schemaPath:new o.Name("schemaPath"),params:new o.Name("params"),propertyName:new o.Name("propertyName"),message:new o.Name("message"),schema:new o.Name("schema"),parentSchema:new o.Name("parentSchema"),instancePath:new o.Name("instancePath")};function errorObjectCode(e,t){const{createErrors:a,opts:r}=e.it;return!1===a?o._`{}`:(r.jtd&&!r.ajvErrors?jtdErrorObject:ajvErrorObject)(e,t)}function jtdErrorObject(e,{message:t}){const{gen:a,keyword:n,it:s}=e,{errorPath:c,errSchemaPath:p,opts:u}=s,l=[[i.instancePath,o.strConcat(r.default.dataPath,c)],[i.schemaPath,o.str`${p}/${n}`]];return u.messages&&l.push([i.message,"function"==typeof t?t(e):t]),a.object(...l)}function ajvErrorObject(e,t){const{gen:a,keyword:n,data:s,schemaValue:c,it:p}=e,{topSchemaRef:u,schemaPath:l,errorPath:m,errSchemaPath:f,propertyName:h,opts:g}=p,{params:y,message:b}=t,x=[[i.keyword,n],[r.default.dataPath,o.strConcat(r.default.dataPath,m)],[i.schemaPath,o.str`${f}/${n}`],[i.params,"function"==typeof y?y(e):y||o._`{}`]];return h&&x.push([i.propertyName,h]),g.messages&&x.push([i.message,"function"==typeof b?b(e):b]),g.verbose&&x.push([i.schema,c],[i.parentSchema,o._`${u}${l}`],[r.default.data,s]),a.object(...x)}},49008:e=>{"use strict";e.exports=function generate_contains(e,t,a){var o=" ",r=e.level,i=e.dataLevel,n=e.schema[t],s=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,p=!e.opts.allErrors,u="data"+(i||""),l="valid"+r,m="errs__"+r,f=e.util.copy(e);f.level++;var h="valid"+f.level,g="i"+r,y=f.dataLevel=e.dataLevel+1,b="data"+y,x=e.baseId,w=e.opts.strictKeywords?"object"==typeof n&&Object.keys(n).length>0||!1===n:e.util.schemaHasRules(n,e.RULES.all);if(o+="var "+m+" = errors;var "+l+";",w){var k=e.compositeRule;e.compositeRule=f.compositeRule=!0,f.schema=n,f.schemaPath=s,f.errSchemaPath=c,o+=" var "+h+" = false; for (var "+g+" = 0; "+g+" < "+u+".length; "+g+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers,!0);var j=u+"["+g+"]";f.dataPathArr[y]=g;var C=e.validate(f);f.baseId=x,e.util.varOccurences(C,b)<2?o+=" "+e.util.varReplace(C,b,j)+" ":o+=" var "+b+" = "+j+"; "+C+" ",o+=" if ("+h+") break; }  ",e.compositeRule=f.compositeRule=k,o+="  if (!"+h+") {"}else o+=" if ("+u+".length == 0) {";var P=P||[];P.push(o),o="",!1!==e.createErrors?(o+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: {} ",!1!==e.opts.messages&&(o+=" , message: 'should contain a valid item' "),e.opts.verbose&&(o+=" , schema: validate.schema"+s+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var O=o;return o=P.pop(),!e.compositeRule&&p?e.async?o+=" throw new ValidationError(["+O+"]); ":o+=" validate.errors = ["+O+"]; return false; ":o+=" var err = "+O+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",o+=" } else { ",w&&(o+="  errors = "+m+"; if (vErrors !== null) { if ("+m+") vErrors.length = "+m+"; else vErrors = null; } "),e.opts.allErrors&&(o+=" } "),o}},49301:e=>{"use strict";e.exports=function generate__limitLength(e,t,a){var o,r=" ",i=e.level,n=e.dataLevel,s=e.schema[t],c=e.schemaPath+e.util.getProperty(t),p=e.errSchemaPath+"/"+t,u=!e.opts.allErrors,l="data"+(n||""),m=e.opts.$data&&s&&s.$data;if(m?(r+=" var schema"+i+" = "+e.util.getData(s.$data,n,e.dataPathArr)+"; ",o="schema"+i):o=s,!m&&"number"!=typeof s)throw new Error(t+" must be number");var f="maxLength"==t?">":"<";r+="if ( ",m&&(r+=" ("+o+" !== undefined && typeof "+o+" != 'number') || "),!1===e.opts.unicode?r+=" "+l+".length ":r+=" ucs2length("+l+") ",r+=" "+f+" "+o+") { ";var h=t,g=g||[];g.push(r),r="",!1!==e.createErrors?(r+=" { keyword: '"+(h||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(p)+" , params: { limit: "+o+" } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT be ",r+="maxLength"==t?"longer":"shorter",r+=" than ",r+=m?"' + "+o+" + '":""+s,r+=" characters' "),e.opts.verbose&&(r+=" , schema:  ",r+=m?"validate.schema"+c:""+s,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+l+" "),r+=" } "):r+=" {} ";var y=r;return r=g.pop(),!e.compositeRule&&u?e.async?r+=" throw new ValidationError(["+y+"]); ":r+=" validate.errors = ["+y+"]; return false; ":r+=" var err = "+y+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",u&&(r+=" else { "),r}},49367:e=>{"use strict";e.exports=JSON.parse('{"$id":"entry.json#","$schema":"http://json-schema.org/draft-06/schema#","type":"object","optional":true,"required":["startedDateTime","time","request","response","cache","timings"],"properties":{"pageref":{"type":"string"},"startedDateTime":{"type":"string","format":"date-time","pattern":"^(\\\\d{4})(-)?(\\\\d\\\\d)(-)?(\\\\d\\\\d)(T)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(:)?(\\\\d\\\\d)(\\\\.\\\\d+)?(Z|([+-])(\\\\d\\\\d)(:)?(\\\\d\\\\d))"},"time":{"type":"number","min":0},"request":{"$ref":"request.json#"},"response":{"$ref":"response.json#"},"cache":{"$ref":"cache.json#"},"timings":{"$ref":"timings.json#"},"serverIPAddress":{"type":"string","oneOf":[{"format":"ipv4"},{"format":"ipv6"}]},"connection":{"type":"string"},"comment":{"type":"string"}}}')},49903:(e,t,a)=>{"use strict";var o=function tryRequireAsyncHooks(){try{return a(90290)}catch(e){return{}}}(),r=a(25508),i=a(72771),n=a(24302),s=a(71170);e.exports=function getRawBody(e,t,a){var i=a,n=t||{};if(void 0===e)throw new TypeError("argument stream is required");if("object"!=typeof e||null===e||"function"!=typeof e.on)throw new TypeError("argument stream must be a stream");!0!==t&&"string"!=typeof t||(n={encoding:t});"function"==typeof t&&(i=t,n={});if(void 0!==i&&"function"!=typeof i)throw new TypeError("argument callback must be a function");if(!i&&!global.Promise)throw new TypeError("argument callback is required");var s=!0!==n.encoding?n.encoding:"utf-8",c=r.parse(n.limit),p=null==n.length||isNaN(n.length)?null:parseInt(n.length,10);if(i)return readStream(e,s,p,c,function wrap(e){var t;o.AsyncResource&&(t=new o.AsyncResource(e.name||"bound-anonymous-fn"));if(!t||!t.runInAsyncScope)return e;return t.runInAsyncScope.bind(t,e,null)}(i));return new Promise(function executor(t,a){readStream(e,s,p,c,function onRead(e,o){if(e)return a(e);t(o)})})};var c=/^Encoding not recognized: /;function readStream(e,t,a,o,r){var p=!1,u=!0;if(null!==o&&null!==a&&a>o)return done(i(413,"request entity too large",{expected:a,length:a,limit:o,type:"entity.too.large"}));var l=e._readableState;if(e._decoder||l&&(l.encoding||l.decoder))return done(i(500,"stream encoding should not be set",{type:"stream.encoding.set"}));if(void 0!==e.readable&&!e.readable)return done(i(500,"stream is not readable",{type:"stream.not.readable"}));var m,f=0;try{m=function getDecoder(e){if(!e)return null;try{return n.getDecoder(e)}catch(t){if(!c.test(t.message))throw t;throw i(415,"specified encoding unsupported",{encoding:e,type:"encoding.unsupported"})}}(t)}catch(e){return done(e)}var h=m?"":[];function done(){for(var t=new Array(arguments.length),a=0;a<t.length;a++)t[a]=arguments[a];function invokeCallback(){cleanup(),t[0]&&function halt(e){s(e),"function"==typeof e.pause&&e.pause()}(e),r.apply(null,t)}p=!0,u?process.nextTick(invokeCallback):invokeCallback()}function onAborted(){p||done(i(400,"request aborted",{code:"ECONNABORTED",expected:a,length:a,received:f,type:"request.aborted"}))}function onData(e){p||(f+=e.length,null!==o&&f>o?done(i(413,"request entity too large",{limit:o,received:f,type:"entity.too.large"})):m?h+=m.write(e):h.push(e))}function onEnd(e){if(!p){if(e)return done(e);if(null!==a&&f!==a)done(i(400,"request size did not match content length",{expected:a,length:a,received:f,type:"request.size.invalid"}));else done(null,m?h+(m.end()||""):Buffer.concat(h))}}function cleanup(){h=null,e.removeListener("aborted",onAborted),e.removeListener("data",onData),e.removeListener("end",onEnd),e.removeListener("error",onEnd),e.removeListener("close",cleanup)}e.on("aborted",onAborted),e.on("close",cleanup),e.on("data",onData),e.on("end",onEnd),e.on("error",onEnd),u=!1}},50460:(e,t)=>{const a={preserveOrder:!1,attributeNamePrefix:"@_",attributesGroupName:!1,textNodeName:"#text",ignoreAttributes:!0,removeNSPrefix:!1,allowBooleanAttributes:!1,parseTagValue:!0,parseAttributeValue:!1,trimValues:!0,cdataPropName:!1,numberParseOptions:{hex:!0,leadingZeros:!0,eNotation:!0},tagValueProcessor:function(e,t){return t},attributeValueProcessor:function(e,t){return t},stopNodes:[],alwaysCreateTextNode:!1,isArray:()=>!1,commentPropName:!1,unpairedTags:[],processEntities:!0,htmlEntities:!1,ignoreDeclaration:!1,ignorePiTags:!1,transformTagName:!1,transformAttributeName:!1,updateTag:function(e,t,a){return e}};t.buildOptions=function(e){return Object.assign({},a,e)},t.defaultOptions=a},50560:(e,t,a)=>{"use strict";const o=a(53908);e.exports=(e,t,a)=>new o(e,a).compare(new o(t,a))},50611:(e,t,a)=>{"use strict";var o=a(61823),r=a(19402),i={brackets:function brackets(e){return e+"[]"},indices:function indices(e,t){return e+"["+t+"]"},repeat:function repeat(e){return e}},n=Array.isArray,s=Array.prototype.push,pushToArray=function(e,t){s.apply(e,n(t)?t:[t])},c=Date.prototype.toISOString,p={delimiter:"&",encode:!0,encoder:o.encode,encodeValuesOnly:!1,serializeDate:function serializeDate(e){return c.call(e)},skipNulls:!1,strictNullHandling:!1},u=function stringify(e,t,a,r,i,s,c,u,l,m,f,h){var g=e;if("function"==typeof c?g=c(t,g):g instanceof Date&&(g=m(g)),null===g){if(r)return s&&!h?s(t,p.encoder):t;g=""}if("string"==typeof g||"number"==typeof g||"boolean"==typeof g||o.isBuffer(g))return s?[f(h?t:s(t,p.encoder))+"="+f(s(g,p.encoder))]:[f(t)+"="+f(String(g))];var y,b=[];if(void 0===g)return b;if(n(c))y=c;else{var x=Object.keys(g);y=u?x.sort(u):x}for(var w=0;w<y.length;++w){var k=y[w];i&&null===g[k]||(n(g)?pushToArray(b,stringify(g[k],a(t,k),a,r,i,s,c,u,l,m,f,h)):pushToArray(b,stringify(g[k],t+(l?"."+k:"["+k+"]"),a,r,i,s,c,u,l,m,f,h)))}return b};e.exports=function(e,t){var a=e,s=t?o.assign({},t):{};if(null!==s.encoder&&void 0!==s.encoder&&"function"!=typeof s.encoder)throw new TypeError("Encoder has to be a function.");var c=void 0===s.delimiter?p.delimiter:s.delimiter,l="boolean"==typeof s.strictNullHandling?s.strictNullHandling:p.strictNullHandling,m="boolean"==typeof s.skipNulls?s.skipNulls:p.skipNulls,f="boolean"==typeof s.encode?s.encode:p.encode,h="function"==typeof s.encoder?s.encoder:p.encoder,g="function"==typeof s.sort?s.sort:null,y=void 0!==s.allowDots&&s.allowDots,b="function"==typeof s.serializeDate?s.serializeDate:p.serializeDate,x="boolean"==typeof s.encodeValuesOnly?s.encodeValuesOnly:p.encodeValuesOnly;if(void 0===s.format)s.format=r.default;else if(!Object.prototype.hasOwnProperty.call(r.formatters,s.format))throw new TypeError("Unknown format option provided.");var w,k,j=r.formatters[s.format];"function"==typeof s.filter?a=(k=s.filter)("",a):n(s.filter)&&(w=k=s.filter);var C,P=[];if("object"!=typeof a||null===a)return"";C=s.arrayFormat in i?s.arrayFormat:"indices"in s?s.indices?"indices":"repeat":"indices";var O=i[C];w||(w=Object.keys(a)),g&&w.sort(g);for(var I=0;I<w.length;++I){var z=w[I];m&&null===a[z]||pushToArray(P,u(a[z],z,O,l,m,f?h:null,k,g,y,b,j,x))}var q=P.join(c),$=!0===s.addQueryPrefix?"?":"";return q.length>0?$+q:""}},50864:(e,t)=>{"use strict";var a=/^[A-Za-z0-9][A-Za-z0-9!#$&^_.-]{0,126}$/,o=/^[A-Za-z0-9][A-Za-z0-9!#$&^_-]{0,126}$/,r=/^ *([A-Za-z0-9][A-Za-z0-9!#$&^_-]{0,126})\/([A-Za-z0-9][A-Za-z0-9!#$&^_.+-]{0,126}) *$/;function MediaType(e,t,a){this.type=e,this.subtype=t,this.suffix=a}t.format=function format(e){if(!e||"object"!=typeof e)throw new TypeError("argument obj is required");var t=e.subtype,r=e.suffix,i=e.type;if(!i||!o.test(i))throw new TypeError("invalid type");if(!t||!a.test(t))throw new TypeError("invalid subtype");var n=i+"/"+t;if(r){if(!o.test(r))throw new TypeError("invalid suffix");n+="+"+r}return n},t.parse=function parse(e){if(!e)throw new TypeError("argument string is required");if("string"!=typeof e)throw new TypeError("argument string is required to be a string");var t=r.exec(e.toLowerCase());if(!t)throw new TypeError("invalid media type");var a,o=t[1],i=t[2],n=i.lastIndexOf("+");-1!==n&&(a=i.substr(n+1),i=i.substr(0,n));return new MediaType(o,i,a)},t.test=function test(e){if(!e)throw new TypeError("argument string is required");if("string"!=typeof e)throw new TypeError("argument string is required to be a string");return r.test(e.toLowerCase())}},50888:(e,t,a)=>{"use strict";const o=a(59893),r=a(56458),i=a(66354),n=a(25507),s=["json","application/*+json","application/csp-report"],c=["urlencoded"],p=["text"];e.exports=async function(e,t){e=e.req||e;const a=(t=t||{}).jsonTypes||s;if(o(e,a))return r(e,t);const u=t.formTypes||c;if(o(e,u))return i(e,t);const l=t.textTypes||p;if(o(e,l))return n(e,t);const m=e.headers["content-type"]||"",f=new Error(m?"Unsupported content-type: "+m:"Missing content-type");throw f.status=415,f}},51410:e=>{"use strict";e.exports=preferredLanguages,e.exports.preferredLanguages=preferredLanguages;var t=/^\s*([^\s\-;]+)(?:-([^\s;]+))?\s*(?:;(.*))?$/;function parseLanguage(e,a){var o=t.exec(e);if(!o)return null;var r=o[1],i=o[2],n=r;i&&(n+="-"+i);var s=1;if(o[3])for(var c=o[3].split(";"),p=0;p<c.length;p++){var u=c[p].split("=");"q"===u[0]&&(s=parseFloat(u[1]))}return{prefix:r,suffix:i,q:s,i:a,full:n}}function specify(e,t,a){var o=parseLanguage(e);if(!o)return null;var r=0;if(t.full.toLowerCase()===o.full.toLowerCase())r|=4;else if(t.prefix.toLowerCase()===o.full.toLowerCase())r|=2;else if(t.full.toLowerCase()===o.prefix.toLowerCase())r|=1;else if("*"!==t.full)return null;return{i:a,o:t.i,q:t.q,s:r}}function preferredLanguages(e,t){var a=function parseAcceptLanguage(e){for(var t=e.split(","),a=0,o=0;a<t.length;a++){var r=parseLanguage(t[a].trim(),a);r&&(t[o++]=r)}return t.length=o,t}(void 0===e?"*":e||"");if(!t)return a.filter(isQuality).sort(compareSpecs).map(getFullLanguage);var o=t.map(function getPriority(e,t){return function getLanguagePriority(e,t,a){for(var o={o:-1,q:0,s:0},r=0;r<t.length;r++){var i=specify(e,t[r],a);i&&(o.s-i.s||o.q-i.q||o.o-i.o)<0&&(o=i)}return o}(e,a,t)});return o.filter(isQuality).sort(compareSpecs).map(function getLanguage(e){return t[o.indexOf(e)]})}function compareSpecs(e,t){return t.q-e.q||t.s-e.s||e.o-t.o||e.i-t.i||0}function getFullLanguage(e){return e.full}function isQuality(e){return e.q>0}},51474:(e,t,a)=>{var o=a(76982),r=a(19534).BigInteger,i=(a(92236).ECPointFp,a(54774).Buffer);function unstupid(e,t){return e.length>=t?e:unstupid("0"+e,t)}t.ECCurves=a(687),t.ECKey=function(e,t,a){var n,s=e(),c=s.getN(),p=Math.floor(c.bitLength()/8);if(t)if(a){e=s.getCurve();this.P=e.decodePointHex(t.toString("hex"))}else{if(t.length!=p)return!1;n=new r(t.toString("hex"),16)}else{var u=c.subtract(r.ONE),l=new r(o.randomBytes(c.bitLength()));n=l.mod(u).add(r.ONE),this.P=s.getG().multiply(n)}this.P&&(this.PublicKey=i.from(s.getCurve().encodeCompressedPointHex(this.P),"hex")),n&&(this.PrivateKey=i.from(unstupid(n.toString(16),2*p),"hex"),this.deriveSharedSecret=function(e){if(!e||!e.P)return!1;var t=e.P.multiply(n);return i.from(unstupid(t.getX().toBigInteger().toString(16),2*p),"hex")})}},51832:(e,t,a)=>{"use strict";const o=a(30144);e.exports=(e,t)=>{const a=o(e,null,!0),r=o(t,null,!0),i=a.compare(r);if(0===i)return null;const n=i>0,s=n?a:r,c=n?r:a,p=!!s.prerelease.length;if(!!c.prerelease.length&&!p){if(!c.patch&&!c.minor)return"major";if(0===c.compareMain(s))return c.minor&&!c.patch?"minor":"patch"}const u=p?"pre":"";return a.major!==r.major?u+"major":a.minor!==r.minor?u+"minor":a.patch!==r.patch?u+"patch":"prerelease"}},52018:e=>{"use strict";e.exports=require("tty")},52056:function(e,t,a){"use strict";var o,r=this&&this.__createBinding||(Object.create?function(e,t,a,o){void 0===o&&(o=a);var r=Object.getOwnPropertyDescriptor(t,a);r&&!("get"in r?!t.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return t[a]}}),Object.defineProperty(e,o,r)}:function(e,t,a,o){void 0===o&&(o=a),e[o]=t[a]}),i=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),n=this&&this.__importStar||(o=function(e){return o=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t},o(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var a=o(e),n=0;n<a.length;n++)"default"!==a[n]&&r(t,e,a[n]);return i(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.handleProjectQuery=t.queryProjectInfo=t.generateProjectStructuredResult=t.getProjectConsoleUrl=t.describePagesEncipherToken=void 0;const s=n(a(16928)),c=a(66119),p=a(73364),u=a(34574);t.describePagesEncipherToken=async e=>await(async e=>{const{action:t,data:a={},baseUrl:o=await(0,p.getBaseApiUrl)(),throwOnError:r=!0}=e,i={Action:t,...a};try{const e=await fetch(o,{method:"POST",headers:{"Content-Type":"application/json",Authorization:await(0,p.getAuthorization)()},body:JSON.stringify(i)});if(!e.ok){const t=await e.text(),a=new Error(`API request failed (${e.status}): ${t}`);if(r)throw a;return{Code:-1,Data:{},Message:a.message,RequestId:""}}const t=await e.json();if(0!==t.Code&&r)throw new Error(`API error: ${t.Message}`);return t}catch(e){if(r)throw console.log(`[callApi] ${t} failed: ${e instanceof Error?e.message:String(e)}`),e;return{Code:-1,Data:{},Message:e instanceof Error?e.message:String(e),RequestId:""}}})({action:"DescribePagesEncipherToken",data:{Text:e}});t.getProjectConsoleUrl=async e=>{const t=await(0,p.getBaseApiUrl)(),a=`https://console.cloud.tencent.com/edgeone/pages/project/${e}/index`;return"https://pages-api.cloud.tencent.com/v1"===t?a:"https://pages-api.edgeone.ai/v1"===t?`https://console.tencentcloud.com/edgeone/pages/project/${e}/index`:a};t.generateProjectStructuredResult=async(e,a="Production",o)=>{const r=e.ProjectId,i=await(0,t.getProjectConsoleUrl)(r);if("Production"===a&&e.CustomDomains&&e.CustomDomains.length>0){const t=e.CustomDomains[0];if("Pass"===t.Status)return{type:"custom",url:`https://${t.Domain}`,projectId:r,projectName:e.Name,consoleUrl:i}}const n=o?.PreviewUrl?o.PreviewUrl.replace("https://",""):e.PresetDomain,s="For mainland China access, the preview URL requires eo_token and eo_time parameters. This is a preset preview link only. For long-term access, please go to the project console to bind a custom domain.";try{const a=await(0,t.describePagesEncipherToken)(n);if(0===a.Code&&a?.Data?.Response?.Token&&a?.Data?.Response?.Timestamp){const{Token:t,Timestamp:o}=a.Data.Response;return{type:"preset",url:`https://${n}?eo_token=${t}&eo_time=${o}`,projectId:r,projectName:e.Name,consoleUrl:i,instruction:s}}}catch(e){console.log(`[generateProjectStructuredResult] Failed to get encipher token: ${e}`)}return{type:"preset",url:`https://${n}`,projectId:r,projectName:e.Name,consoleUrl:i,instruction:s}};t.queryProjectInfo=async e=>{try{const a=s.resolve(e),o=await u.cacheManager.getCachedResult(a);if(o)return o;const r=await(0,c.getProjectNameFromConfig)(a);if(r){const e=(await(0,p.describePagesProjects)({projectName:r})).Data.Response.Projects[0];if(e){const o=await(0,t.generateProjectStructuredResult)(e,"Production");return await u.cacheManager.setCachedResult(a,o),o}}return null}catch(e){return null}};t.handleProjectQuery=async e=>{const a=await(0,t.queryProjectInfo)(e);if(a){const e={success:!0,data:a};console.log(JSON.stringify(e,null,2)),process.exit(0)}else{const e={success:!1,error:"Failed to query project information, please deploy first."};console.log(JSON.stringify(e,null,2)),process.exit(1)}}},52080:(e,t,a)=>{"use strict";var o=a(86965),r=a(16928).extname,i=a(2190),n=/^\s*([^;\s]*)(?:;|\s|$)/,s=/^text\//i;function charset(e){if(!e||"string"!=typeof e)return!1;var t=n.exec(e),a=t&&o[t[1].toLowerCase()];return a&&a.charset?a.charset:!(!t||!s.test(t[1]))&&"UTF-8"}function extension(e){if(!e||"string"!=typeof e)return!1;var a=n.exec(e),o=a&&t.extensions[a[1].toLowerCase()];return!(!o||!o.length)&&o[0]}function _preferredType(e,t,a){return(t?i(t,o[t].source):0)>(a?i(a,o[a].source):0)?t:a}function _preferredTypeLegacy(e,a,r){var i=["nginx","apache",void 0,"iana"],n=a?i.indexOf(o[a].source):0,s=r?i.indexOf(o[r].source):0;return"application/octet-stream"!==t.types[extension]&&(n>s||n===s&&"application/"===t.types[extension]?.slice(0,12))||n>s?a:r}t.charset=charset,t.charsets={lookup:charset},t.contentType=function contentType(e){if(!e||"string"!=typeof e)return!1;var a=-1===e.indexOf("/")?t.lookup(e):e;if(!a)return!1;if(-1===a.indexOf("charset")){var o=t.charset(a);o&&(a+="; charset="+o.toLowerCase())}return a},t.extension=extension,t.extensions=Object.create(null),t.lookup=function lookup(e){if(!e||"string"!=typeof e)return!1;var a=r("x."+e).toLowerCase().slice(1);if(!a)return!1;return t.types[a]||!1},t.types=Object.create(null),t._extensionConflicts=[],function populateMaps(e,a){Object.keys(o).forEach(function forEachMimeType(r){var i=o[r].extensions;if(i&&i.length){e[r]=i;for(var n=0;n<i.length;n++){var s=i[n];a[s]=_preferredType(s,a[s],r);const e=_preferredTypeLegacy(s,a[s],r);e!==a[s]&&t._extensionConflicts.push([s,e,a[s]])}}})}(t.extensions,t.types)},52081:(e,t,a)=>{var o=a(90028);e.exports=function serial(e,t,a){return o(e,t,null,a)}},52224:e=>{"use strict";e.exports=function encodeUrl(e){return String(e).replace(a,o).replace(t,encodeURI)};var t=/(?:[^\x21\x23-\x3B\x3D\x3F-\x5F\x61-\x7A\x7C\x7E]|%(?:[^0-9A-Fa-f]|[0-9A-Fa-f][^0-9A-Fa-f]|$))+/g,a=/(^|[^\uD800-\uDBFF])[\uDC00-\uDFFF]|[\uD800-\uDBFF]([^\uDC00-\uDFFF]|$)/g,o="$1�$2"},52403:(e,t,a)=>{"use strict";var o=a(17662);function getStatusMessage(e){if(!Object.prototype.hasOwnProperty.call(status.message,e))throw new Error("invalid status code: "+e);return status.message[e]}function status(e){if("number"==typeof e)return getStatusMessage(e);if("string"!=typeof e)throw new TypeError("code must be a number or string");var t=parseInt(e,10);return isNaN(t)?function getStatusCode(e){var t=e.toLowerCase();if(!Object.prototype.hasOwnProperty.call(status.code,t))throw new Error('invalid status message: "'+e+'"');return status.code[t]}(e):getStatusMessage(t)}e.exports=status,status.message=o,status.code=function createMessageToStatusCodeMap(e){var t={};return Object.keys(e).forEach(function forEachCode(a){var o=e[a],r=Number(a);t[o.toLowerCase()]=r}),t}(o),status.codes=function createStatusCodeList(e){return Object.keys(e).map(function mapCode(e){return Number(e)})}(o),status.redirect={300:!0,301:!0,302:!0,303:!0,305:!0,307:!0,308:!0},status.empty={204:!0,205:!0,304:!0},status.retry={502:!0,503:!0,504:!0}},52916:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const a={},o={next:e=>{const t=a[e];if(!t)return;t.shift();const r=t[0];r?r(()=>o.next(e)):delete a[e]},schedule:e=>new Promise(t=>{let r=a[e];r||(r=a[e]=[]),r.push(t),r.length>1||t(()=>o.next(e))})};t.default=o},53100:(e,t,a)=>{var o=a(55670);e.exports={Ber:o,BerReader:o.Reader,BerWriter:o.Writer}},53903:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.hookManager=t.setupCodeBuddyIntegration=void 0;const o=a(35317),openWithSystemBrowser=async e=>{const{command:t,args:a}=(e=>{return"win32"===process.platform?{command:"powershell.exe",args:["-NoProfile","-Command",`Start-Process '${t=e,t.replace(/'/g,"''")}'`]}:"darwin"===process.platform?{command:"open",args:[e]}:{command:"xdg-open",args:[e]};var t})(e),r="win32"!==process.platform;await new Promise((e,i)=>{const n=(0,o.spawn)(t,a,{stdio:"ignore",detached:r});n.once("error",i),n.once("close",a=>{"number"==typeof a&&a>0?i(new Error(`${t} exited with code ${a}`)):e()}),r&&n.unref()})};t.setupCodeBuddyIntegration=e=>{process.env.INTEGRATION_IDE&&(process.env.PAGES_SOURCE="codebuddy",t.hookManager.registerServer(e),t.hookManager.registerOpenUrlHook(async t=>{e.server.sendLoggingMessage({level:"notice",data:{type:"edgeone-pages",url:t}})}),t.hookManager.registerAfterDeployHook(t=>{e.server.sendLoggingMessage({level:"notice",data:{type:"eop",event:"deploy",data:t}})}))},t.hookManager=new class HookManager{constructor(){this.serverInstance=null,this.openUrlHook=this.defaultOpenUrl,this.afterDeployHook=this.defaultAfterDeploy}async defaultOpenUrl(e){await openWithSystemBrowser(e)}defaultAfterDeploy(e){}registerServer(e){this.serverInstance=e}registerOpenUrlHook(e){this.openUrlHook=e}registerAfterDeployHook(e){this.afterDeployHook=e}async openUrl(e){await this.openUrlHook(e)}triggerAfterDeploy(e){this.afterDeployHook(e)}}},53908:(e,t,a)=>{"use strict";const o=a(57272),{MAX_LENGTH:r,MAX_SAFE_INTEGER:i}=a(16874),{safeRe:n,t:s}=a(99718),c=a(98587),{compareIdentifiers:p}=a(61123);class SemVer{constructor(e,t){if(t=c(t),e instanceof SemVer){if(e.loose===!!t.loose&&e.includePrerelease===!!t.includePrerelease)return e;e=e.version}else if("string"!=typeof e)throw new TypeError(`Invalid version. Must be a string. Got type "${typeof e}".`);if(e.length>r)throw new TypeError(`version is longer than ${r} characters`);o("SemVer",e,t),this.options=t,this.loose=!!t.loose,this.includePrerelease=!!t.includePrerelease;const a=e.trim().match(t.loose?n[s.LOOSE]:n[s.FULL]);if(!a)throw new TypeError(`Invalid Version: ${e}`);if(this.raw=e,this.major=+a[1],this.minor=+a[2],this.patch=+a[3],this.major>i||this.major<0)throw new TypeError("Invalid major version");if(this.minor>i||this.minor<0)throw new TypeError("Invalid minor version");if(this.patch>i||this.patch<0)throw new TypeError("Invalid patch version");a[4]?this.prerelease=a[4].split(".").map(e=>{if(/^[0-9]+$/.test(e)){const t=+e;if(t>=0&&t<i)return t}return e}):this.prerelease=[],this.build=a[5]?a[5].split("."):[],this.format()}format(){return this.version=`${this.major}.${this.minor}.${this.patch}`,this.prerelease.length&&(this.version+=`-${this.prerelease.join(".")}`),this.version}toString(){return this.version}compare(e){if(o("SemVer.compare",this.version,this.options,e),!(e instanceof SemVer)){if("string"==typeof e&&e===this.version)return 0;e=new SemVer(e,this.options)}return e.version===this.version?0:this.compareMain(e)||this.comparePre(e)}compareMain(e){return e instanceof SemVer||(e=new SemVer(e,this.options)),p(this.major,e.major)||p(this.minor,e.minor)||p(this.patch,e.patch)}comparePre(e){if(e instanceof SemVer||(e=new SemVer(e,this.options)),this.prerelease.length&&!e.prerelease.length)return-1;if(!this.prerelease.length&&e.prerelease.length)return 1;if(!this.prerelease.length&&!e.prerelease.length)return 0;let t=0;do{const a=this.prerelease[t],r=e.prerelease[t];if(o("prerelease compare",t,a,r),void 0===a&&void 0===r)return 0;if(void 0===r)return 1;if(void 0===a)return-1;if(a!==r)return p(a,r)}while(++t)}compareBuild(e){e instanceof SemVer||(e=new SemVer(e,this.options));let t=0;do{const a=this.build[t],r=e.build[t];if(o("build compare",t,a,r),void 0===a&&void 0===r)return 0;if(void 0===r)return 1;if(void 0===a)return-1;if(a!==r)return p(a,r)}while(++t)}inc(e,t,a){if(e.startsWith("pre")){if(!t&&!1===a)throw new Error("invalid increment argument: identifier is empty");if(t){const e=`-${t}`.match(this.options.loose?n[s.PRERELEASELOOSE]:n[s.PRERELEASE]);if(!e||e[1]!==t)throw new Error(`invalid identifier: ${t}`)}}switch(e){case"premajor":this.prerelease.length=0,this.patch=0,this.minor=0,this.major++,this.inc("pre",t,a);break;case"preminor":this.prerelease.length=0,this.patch=0,this.minor++,this.inc("pre",t,a);break;case"prepatch":this.prerelease.length=0,this.inc("patch",t,a),this.inc("pre",t,a);break;case"prerelease":0===this.prerelease.length&&this.inc("patch",t,a),this.inc("pre",t,a);break;case"release":if(0===this.prerelease.length)throw new Error(`version ${this.raw} is not a prerelease`);this.prerelease.length=0;break;case"major":0===this.minor&&0===this.patch&&0!==this.prerelease.length||this.major++,this.minor=0,this.patch=0,this.prerelease=[];break;case"minor":0===this.patch&&0!==this.prerelease.length||this.minor++,this.patch=0,this.prerelease=[];break;case"patch":0===this.prerelease.length&&this.patch++,this.prerelease=[];break;case"pre":{const e=Number(a)?1:0;if(0===this.prerelease.length)this.prerelease=[e];else{let o=this.prerelease.length;for(;--o>=0;)"number"==typeof this.prerelease[o]&&(this.prerelease[o]++,o=-2);if(-1===o){if(t===this.prerelease.join(".")&&!1===a)throw new Error("invalid increment argument: identifier already exists");this.prerelease.push(e)}}if(t){let o=[t,e];!1===a&&(o=[t]),0===p(this.prerelease[0],t)?isNaN(this.prerelease[1])&&(this.prerelease=o):this.prerelease=o}break}default:throw new Error(`invalid increment argument: ${e}`)}return this.raw=this.format(),this.build.length&&(this.raw+=`+${this.build.join(".")}`),this}}e.exports=SemVer},53945:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.UriTemplate=void 0;const a=1e6,o=1e6;class UriTemplate{static isTemplate(e){return/\{[^}\s]+\}/.test(e)}static validateLength(e,t,a){if(e.length>t)throw new Error(`${a} exceeds maximum length of ${t} characters (got ${e.length})`)}get variableNames(){return this.parts.flatMap(e=>"string"==typeof e?[]:e.names)}constructor(e){UriTemplate.validateLength(e,a,"Template"),this.template=e,this.parts=this.parse(e)}toString(){return this.template}parse(e){const t=[];let a="",r=0,i=0;for(;r<e.length;)if("{"===e[r]){a&&(t.push(a),a="");const n=e.indexOf("}",r);if(-1===n)throw new Error("Unclosed template expression");if(i++,i>1e4)throw new Error("Template contains too many expressions (max 10000)");const s=e.slice(r+1,n),c=this.getOperator(s),p=s.includes("*"),u=this.getNames(s),l=u[0];for(const e of u)UriTemplate.validateLength(e,o,"Variable name");t.push({name:l,operator:c,names:u,exploded:p}),r=n+1}else a+=e[r],r++;return a&&t.push(a),t}getOperator(e){return["+","#",".","/","?","&"].find(t=>e.startsWith(t))||""}getNames(e){const t=this.getOperator(e);return e.slice(t.length).split(",").map(e=>e.replace("*","").trim()).filter(e=>e.length>0)}encodeValue(e,t){return UriTemplate.validateLength(e,o,"Variable value"),"+"===t||"#"===t?encodeURI(e):encodeURIComponent(e)}expandPart(e,t){if("?"===e.operator||"&"===e.operator){const a=e.names.map(a=>{const o=t[a];if(void 0===o)return"";return`${a}=${Array.isArray(o)?o.map(t=>this.encodeValue(t,e.operator)).join(","):this.encodeValue(o.toString(),e.operator)}`}).filter(e=>e.length>0);if(0===a.length)return"";return("?"===e.operator?"?":"&")+a.join("&")}if(e.names.length>1){const a=e.names.map(e=>t[e]).filter(e=>void 0!==e);return 0===a.length?"":a.map(e=>Array.isArray(e)?e[0]:e).join(",")}const a=t[e.name];if(void 0===a)return"";const o=(Array.isArray(a)?a:[a]).map(t=>this.encodeValue(t,e.operator));switch(e.operator){case"":case"+":default:return o.join(",");case"#":return"#"+o.join(",");case".":return"."+o.join(".");case"/":return"/"+o.join("/")}}expand(e){let t="",a=!1;for(const o of this.parts){if("string"==typeof o){t+=o;continue}const r=this.expandPart(o,e);r&&("?"!==o.operator&&"&"!==o.operator||!a?t+=r:t+=r.replace("?","&"),"?"!==o.operator&&"&"!==o.operator||(a=!0))}return t}escapeRegExp(e){return e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}partToRegExp(e){const t=[];for(const t of e.names)UriTemplate.validateLength(t,o,"Variable name");if("?"===e.operator||"&"===e.operator){for(let a=0;a<e.names.length;a++){const o=e.names[a],r=0===a?"\\"+e.operator:"&";t.push({pattern:r+this.escapeRegExp(o)+"=([^&]+)",name:o})}return t}let a;const r=e.name;switch(e.operator){case"":a=e.exploded?"([^/]+(?:,[^/]+)*)":"([^/,]+)";break;case"+":case"#":a="(.+)";break;case".":a="\\.([^/,]+)";break;case"/":a="/"+(e.exploded?"([^/]+(?:,[^/]+)*)":"([^/,]+)");break;default:a="([^/]+)"}return t.push({pattern:a,name:r}),t}match(e){UriTemplate.validateLength(e,a,"URI");let t="^";const o=[];for(const e of this.parts)if("string"==typeof e)t+=this.escapeRegExp(e);else{const a=this.partToRegExp(e);for(const{pattern:r,name:i}of a)t+=r,o.push({name:i,exploded:e.exploded})}t+="$",UriTemplate.validateLength(t,1e6,"Generated regex pattern");const r=new RegExp(t),i=e.match(r);if(!i)return null;const n={};for(let e=0;e<o.length;e++){const{name:t,exploded:a}=o[e],r=i[e+1],s=t.replace("*","");a&&r.includes(",")?n[s]=r.split(","):n[s]=r}return n}}t.UriTemplate=UriTemplate},54089:(e,t,a)=>{"use strict";const o=a(50560);e.exports=(e,t,a)=>o(e,t,a)>=0},54181:(e,t,a)=>{var o=a(2203);function isStream(e){return e instanceof o.Stream}function isReadable(e){return isStream(e)&&"function"==typeof e._read&&"object"==typeof e._readableState}function isWritable(e){return isStream(e)&&"function"==typeof e._write&&"object"==typeof e._writableState}e.exports=isStream,e.exports.isReadable=isReadable,e.exports.isWritable=isWritable,e.exports.isDuplex=function isDuplex(e){return isReadable(e)&&isWritable(e)}},54763:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.NOOP=t.LIMIT_FILES_DESCRIPTORS=t.LIMIT_BASENAME_LENGTH=t.IS_USER_ROOT=t.IS_POSIX=t.DEFAULT_TIMEOUT_SYNC=t.DEFAULT_TIMEOUT_ASYNC=t.DEFAULT_WRITE_OPTIONS=t.DEFAULT_READ_OPTIONS=t.DEFAULT_FOLDER_MODE=t.DEFAULT_FILE_MODE=t.DEFAULT_ENCODING=void 0;t.DEFAULT_ENCODING="utf8";t.DEFAULT_FILE_MODE=438;t.DEFAULT_FOLDER_MODE=511;t.DEFAULT_READ_OPTIONS={};t.DEFAULT_WRITE_OPTIONS={};t.DEFAULT_TIMEOUT_ASYNC=5e3;t.DEFAULT_TIMEOUT_SYNC=100;const a=!!process.getuid;t.IS_POSIX=a;const o=!!process.getuid&&!process.getuid();t.IS_USER_ROOT=o;t.LIMIT_BASENAME_LENGTH=128;t.LIMIT_FILES_DESCRIPTORS=1e4;t.NOOP=()=>{}},54774:(e,t,a)=>{"use strict";var o,r=a(20181),i=r.Buffer,n={};for(o in r)r.hasOwnProperty(o)&&"SlowBuffer"!==o&&"Buffer"!==o&&(n[o]=r[o]);var s=n.Buffer={};for(o in i)i.hasOwnProperty(o)&&"allocUnsafe"!==o&&"allocUnsafeSlow"!==o&&(s[o]=i[o]);if(n.Buffer.prototype=i.prototype,s.from&&s.from!==Uint8Array.from||(s.from=function(e,t,a){if("number"==typeof e)throw new TypeError('The "value" argument must not be of type number. Received type '+typeof e);if(e&&void 0===e.length)throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e);return i(e,t,a)}),s.alloc||(s.alloc=function(e,t,a){if("number"!=typeof e)throw new TypeError('The "size" argument must be of type number. Received type '+typeof e);if(e<0||e>=2*(1<<30))throw new RangeError('The value "'+e+'" is invalid for option "size"');var o=i(e);return t&&0!==t.length?"string"==typeof a?o.fill(t,a):o.fill(t):o.fill(0),o}),!n.kStringMaxLength)try{n.kStringMaxLength=process.binding("buffer").kStringMaxLength}catch(e){}n.constants||(n.constants={MAX_LENGTH:n.kMaxLength},n.kStringMaxLength&&(n.constants.MAX_STRING_LENGTH=n.kStringMaxLength)),e.exports=n},54926:(e,t,a)=>{"use strict";var o=a(50611),r=a(46429),i=a(19402);e.exports={formats:i,parse:r,stringify:o}},55373:(e,t,a)=>{"use strict";var o=a(98636),r=a(62642),i=a(74765);e.exports={formats:i,parse:r,stringify:o}},55589:(e,t,a)=>{"use strict";const o=a(79896),r=a(16928),{promisify:i}=a(39023),n=a(86385).satisfies(process.version,">=10.12.0"),checkPath=e=>{if("win32"===process.platform){if(/[<>:"|?*]/.test(e.replace(r.parse(e).root,""))){const t=new Error(`Path contains invalid characters: ${e}`);throw t.code="EINVAL",t}}},processOptions=e=>({...{mode:511,fs:o},...e}),permissionError=e=>{const t=new Error(`operation not permitted, mkdir '${e}'`);return t.code="EPERM",t.errno=-4048,t.path=e,t.syscall="mkdir",t};e.exports=async(e,t)=>{checkPath(e),t=processOptions(t);const a=i(t.fs.mkdir),s=i(t.fs.stat);if(n&&t.fs.mkdir===o.mkdir){const o=r.resolve(e);return await a(o,{mode:t.mode,recursive:!0}),o}const make=async e=>{try{return await a(e,t.mode),e}catch(t){if("EPERM"===t.code)throw t;if("ENOENT"===t.code){if(r.dirname(e)===e)throw permissionError(e);if(t.message.includes("null bytes"))throw t;return await make(r.dirname(e)),make(e)}try{if(!(await s(e)).isDirectory())throw new Error("The path is not a directory")}catch(e){throw t}return e}};return make(r.resolve(e))},e.exports.sync=(e,t)=>{if(checkPath(e),t=processOptions(t),n&&t.fs.mkdirSync===o.mkdirSync){const a=r.resolve(e);return o.mkdirSync(a,{mode:t.mode,recursive:!0}),a}const make=e=>{try{t.fs.mkdirSync(e,t.mode)}catch(a){if("EPERM"===a.code)throw a;if("ENOENT"===a.code){if(r.dirname(e)===e)throw permissionError(e);if(a.message.includes("null bytes"))throw a;return make(r.dirname(e)),make(e)}try{if(!t.fs.statSync(e).isDirectory())throw new Error("The path is not a directory")}catch(e){throw a}}return e};return make(r.resolve(e))}},55670:(e,t,a)=>{var o=a(76395),r=a(16299),i=a(3319),n=a(11431);for(var s in e.exports={Reader:i,Writer:n},r)r.hasOwnProperty(s)&&(e.exports[s]=r[s]);for(var c in o)o.hasOwnProperty(c)&&(e.exports[c]=o[c])},55856:(e,t,a)=>{"use strict";const o=a(57975),r=o.debuglog("koa:application"),i=a(78474),n=a(57075),s=a(37067),{AsyncLocalStorage:c}=a(16698),p=a(15649),u=a(68287),l=a(52403),{HttpError:m}=a(72771),f=a(72043),h=a(91631),g=a(72013),y=a(38833),b=a(81846);e.exports=class Application extends i{constructor(e){super(),e=e||{},this.proxy=e.proxy||!1,this.subdomainOffset=e.subdomainOffset||2,this.proxyIpHeader=e.proxyIpHeader||"X-Forwarded-For",this.maxIpsCount=e.maxIpsCount||0,this.env=e.env||"production",this.compose=e.compose||u,e.keys&&(this.keys=e.keys),this.middleware=[],this.context=Object.create(g),this.request=Object.create(f),this.response=Object.create(h),o.inspect.custom&&(this[o.inspect.custom]=this.inspect),e.asyncLocalStorage&&(e.asyncLocalStorage instanceof c?this.ctxStorage=e.asyncLocalStorage:this.ctxStorage=new c)}listen(...e){r("listen");return s.createServer(this.callback()).listen(...e)}toJSON(){return b(this,["subdomainOffset","proxy","env"])}inspect(){return this.toJSON()}use(e){if("function"!=typeof e)throw new TypeError("middleware must be a function!");return r("use %s",e._name||e.name||"-"),this.middleware.push(e),this}callback(){const e=this.compose(this.middleware);this.listenerCount("error")||this.on("error",this.onerror);return(t,a)=>{const o=this.createContext(t,a);return this.ctxStorage?this.ctxStorage.run(o,async()=>await this.handleRequest(o,e)):this.handleRequest(o,e)}}get currentContext(){if(this.ctxStorage)return this.ctxStorage.getStore()}handleRequest(e,t){const a=e.res;a.statusCode=404;const onerror=t=>e.onerror(t);return p(a,onerror),t(e).then(()=>function respond(e){if(!1===e.respond)return;const t=e.res;if(!e.writable)return t.end();let a=e.body;const o=e.status;if(l.empty[o])return e.body=null,t.end();if("HEAD"===e.method){if(!t.headersSent&&!e.response.has("Content-Length")){const{length:t}=e.response;Number.isInteger(t)&&(e.length=t)}return t.end()}if(null==a)return e.response._explicitNullBody?(e.response.remove("Content-Type"),e.response.remove("Transfer-Encoding"),e.length=0,t.end()):(a=e.req.httpVersionMajor>=2?String(o):e.message||String(o),t.headersSent||(e.type="text",e.length=Buffer.byteLength(a)),t.end(a));if(Buffer.isBuffer(a))return t.end(a);if("string"==typeof a)return t.end(a);if(a instanceof Blob)return n.Readable.from(a.stream()).pipe(t);if(a instanceof ReadableStream)return n.Readable.from(a).pipe(t);if(a instanceof Response)return n.Readable.from(a?.body||"").pipe(t);if(y(a))return a.pipe(t);a=JSON.stringify(a),t.headersSent||(e.length=Buffer.byteLength(a));t.end(a)}(e)).catch(onerror)}createContext(e,t){const a=Object.create(this.context),o=a.request=Object.create(this.request),r=a.response=Object.create(this.response);return a.app=o.app=r.app=this,a.req=o.req=r.req=e,a.res=o.res=r.res=t,o.ctx=r.ctx=a,o.response=r,r.request=o,a.originalUrl=o.originalUrl=e.url,a.state={},a}onerror(e){if(!("[object Error]"===Object.prototype.toString.call(e)||e instanceof Error))throw new TypeError(o.format("non-error thrown: %j",e));if(404===e.status||e.expose)return;if(this.silent)return;const t=e.stack||e.toString();console.error(`\n${t.replace(/^/gm,"  ")}\n`)}static get default(){return Application}},e.exports.HttpError=m},55984:(e,t,a)=>{"use strict";e.exports={shiftjis:{type:"_dbcs",table:function(){return a(19584)},encodeAdd:{"¥":92,"‾":126},encodeSkipVals:[{from:60736,to:63808}]},csshiftjis:"shiftjis",mskanji:"shiftjis",sjis:"shiftjis",windows31j:"shiftjis",ms31j:"shiftjis",xsjis:"shiftjis",windows932:"shiftjis",ms932:"shiftjis",932:"shiftjis",cp932:"shiftjis",eucjp:{type:"_dbcs",table:function(){return a(45291)},encodeAdd:{"¥":92,"‾":126}},gb2312:"cp936",gb231280:"cp936",gb23121980:"cp936",csgb2312:"cp936",csiso58gb231280:"cp936",euccn:"cp936",windows936:"cp936",ms936:"cp936",936:"cp936",cp936:{type:"_dbcs",table:function(){return a(19169)}},gbk:{type:"_dbcs",table:function(){return a(19169).concat(a(99239))}},xgbk:"gbk",isoir58:"gbk",gb18030:{type:"_dbcs",table:function(){return a(19169).concat(a(99239))},gb18030:function(){return a(19642)},encodeSkipVals:[128],encodeAdd:{"€":41699}},chinese:"gb18030",windows949:"cp949",ms949:"cp949",949:"cp949",cp949:{type:"_dbcs",table:function(){return a(29167)}},cseuckr:"cp949",csksc56011987:"cp949",euckr:"cp949",isoir149:"cp949",korean:"cp949",ksc56011987:"cp949",ksc56011989:"cp949",ksc5601:"cp949",windows950:"cp950",ms950:"cp950",950:"cp950",cp950:{type:"_dbcs",table:function(){return a(88657)}},big5:"big5hkscs",big5hkscs:{type:"_dbcs",table:function(){return a(88657).concat(a(34184))},encodeSkipVals:[41676]},cnbig5:"big5hkscs",csbig5:"big5hkscs",xxbig5:"big5hkscs"}},56378:(e,t,a)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0});const o=a(15457),r=a(20494),i=a(12661),n=a(83025),s=a(19713),c=a(38660),p=a(40117),u=a(45333),l=a(57923),m=a(16505),f=a(96163),h=a(15844),g=a(1239),y=a(14426),b=[l.default,m.default,f.default,h.default,g.default,y.default,o.default,r.default,i.default,s.default,c.default,n.default,p.default,u.default];t.default=b},56458:(e,t,a)=>{"use strict";const o=a(49903),r=a(84881),i=a(25477),n=a(94099),s=/^[\x20\x09\x0a\x0d]*(\[|\{)/;e.exports=async function(e,t){e=e.req||e,t=n.clone(t);const a=e.headers["content-length"],c=e.headers["content-encoding"]||"identity";a&&"identity"===c&&(t.length=~~a),t.encoding=t.encoding||"utf8",t.limit=t.limit||"1mb";const p=!1!==t.strict,u=t.onProtoPoisoning||"error",l=await o(r(e),t);try{const e=function parse(e){if(!p)return e?i.parse(e,{protoAction:u}):e;if(!e)return{};if(!s.test(e))throw new SyntaxError("invalid JSON, only supports object and array");return i.parse(e,{protoAction:u})}(l);return t.returnRawBody?{parsed:e,raw:l}:e}catch(e){throw e.status=400,e.body=l,e}}},56696:(e,t,a)=>{"use strict";var o=a(87016),r=/^https?:/;function Redirect(e){this.request=e,this.followRedirect=!0,this.followRedirects=!0,this.followAllRedirects=!1,this.followOriginalHttpMethod=!1,this.allowRedirect=function(){return!0},this.maxRedirects=10,this.redirects=[],this.redirectsFollowed=0,this.removeRefererHeader=!1}Redirect.prototype.onRequest=function(e){var t=this;void 0!==e.maxRedirects&&(t.maxRedirects=e.maxRedirects),"function"==typeof e.followRedirect&&(t.allowRedirect=e.followRedirect),void 0!==e.followRedirect&&(t.followRedirects=!!e.followRedirect),void 0!==e.followAllRedirects&&(t.followAllRedirects=e.followAllRedirects),(t.followRedirects||t.followAllRedirects)&&(t.redirects=t.redirects||[]),void 0!==e.removeRefererHeader&&(t.removeRefererHeader=e.removeRefererHeader),void 0!==e.followOriginalHttpMethod&&(t.followOriginalHttpMethod=e.followOriginalHttpMethod)},Redirect.prototype.redirectTo=function(e){var t=this,a=t.request,o=null;if(e.statusCode>=300&&e.statusCode<400&&e.caseless.has("location")){var r=e.caseless.get("location");if(a.debug("redirect",r),t.followAllRedirects)o=r;else if(t.followRedirects)switch(a.method){case"PATCH":case"PUT":case"POST":case"DELETE":break;default:o=r}}else if(401===e.statusCode){var i=a._auth.onResponse(e);i&&(a.setHeader("authorization",i),o=a.uri)}return o},Redirect.prototype.onResponse=function(e){var t=this,a=t.request,i=t.redirectTo(e);if(!i||!t.allowRedirect.call(a,e))return!1;if(a.debug("redirect to",i),e.resume&&e.resume(),t.redirectsFollowed>=t.maxRedirects)return a.emit("error",new Error("Exceeded maxRedirects. Probably stuck in a redirect loop "+a.uri.href)),!1;t.redirectsFollowed+=1,r.test(i)||(i=o.resolve(a.uri.href,i));var n=a.uri;return a.uri=o.parse(i),a.uri.protocol!==n.protocol&&delete a.agent,t.redirects.push({statusCode:e.statusCode,redirectUri:i}),t.followAllRedirects&&"HEAD"!==a.method&&401!==e.statusCode&&307!==e.statusCode&&(a.method=t.followOriginalHttpMethod?a.method:"GET"),delete a.src,delete a.req,delete a._started,401!==e.statusCode&&307!==e.statusCode&&(delete a.body,delete a._form,a.headers&&(a.removeHeader("host"),a.removeHeader("content-type"),a.removeHeader("content-length"),a.uri.hostname!==a.originalHost.split(":")[0]&&a.removeHeader("authorization"))),t.removeRefererHeader||a.setHeader("referer",n.href),a.emit("redirect"),a.init(),!0},t.r=Redirect},56698:e=>{"function"==typeof Object.create?e.exports=function inherits(e,t){t&&(e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}))}:e.exports=function inherits(e,t){if(t){e.super_=t;var TempCtor=function(){};TempCtor.prototype=t.prototype,e.prototype=new TempCtor,e.prototype.constructor=e}}},56953:(e,t,a)=>{"use strict";const o=a(30144);e.exports=(e,t)=>{const a=o(e,t);return a?a.version:null}},57034:(e,t)=>{"use strict";var a,o;Object.defineProperties(t,{__esModule:{value:!0},[Symbol.toStringTag]:{value:"Module"}});const r=function K(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}(function Q(){if(o)return a;o=1;const e=2147483647,t=36,r=/^xn--/,i=/[^\0-\x7F]/,n=/[\x2E\u3002\uFF0E\uFF61]/g,s={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},c=Math.floor,p=String.fromCharCode;function v(e){throw new RangeError(s[e])}function S(e,t){const a=e.split("@");let o="";a.length>1&&(o=a[0]+"@",e=a[1]);const r=function U(e,t){const a=[];let o=e.length;for(;o--;)a[o]=t(e[o]);return a}((e=e.replace(n,".")).split("."),t).join(".");return o+r}function L(e){const t=[];let a=0;const o=e.length;for(;a<o;){const r=e.charCodeAt(a++);if(r>=55296&&r<=56319&&a<o){const o=e.charCodeAt(a++);56320==(64512&o)?t.push(((1023&r)<<10)+(1023&o)+65536):(t.push(r),a--)}else t.push(r)}return t}const J=function(e){return e>=48&&e<58?e-48+26:e>=65&&e<91?e-65:e>=97&&e<123?e-97:t},D=function(e,t){return e+22+75*(e<26)-((0!=t)<<5)},T=function(e,a,o){let r=0;for(e=o?c(e/700):e>>1,e+=c(e/a);e>455;r+=t)e=c(e/35);return c(r+36*e/(e+38))},E=function(a){const o=[],r=a.length;let i=0,n=128,s=72,p=a.lastIndexOf("-");p<0&&(p=0);for(let e=0;e<p;++e)a.charCodeAt(e)>=128&&v("not-basic"),o.push(a.charCodeAt(e));for(let u=p>0?p+1:0;u<r;){const p=i;for(let o=1,n=t;;n+=t){u>=r&&v("invalid-input");const p=J(a.charCodeAt(u++));p>=t&&v("invalid-input"),p>c((e-i)/o)&&v("overflow"),i+=p*o;const l=n<=s?1:n>=s+26?26:n-s;if(p<l)break;const m=t-l;o>c(e/m)&&v("overflow"),o*=m}const l=o.length+1;s=T(i-p,l,0==p),c(i/l)>e-n&&v("overflow"),n+=c(i/l),i%=l,o.splice(i++,0,n)}return String.fromCodePoint(...o)},B=function(a){const o=[],r=(a=L(a)).length;let i=128,n=0,s=72;for(const e of a)e<128&&o.push(p(e));const u=o.length;let l=u;for(u&&o.push("-");l<r;){let r=e;for(const e of a)e>=i&&e<r&&(r=e);const m=l+1;r-i>c((e-n)/m)&&v("overflow"),n+=(r-i)*m,i=r;for(const r of a)if(r<i&&++n>e&&v("overflow"),r===i){let e=n;for(let a=t;;a+=t){const r=a<=s?1:a>=s+26?26:a-s;if(e<r)break;const i=e-r,n=t-r;o.push(p(D(r+i%n,0))),e=c(i/n)}o.push(p(D(e,0))),s=T(n,m,l===u),n=0,++l}++n,++i}return o.join("")};return a={version:"2.3.1",ucs2:{decode:L,encode:e=>String.fromCodePoint(...e)},decode:E,encode:B,toASCII:function(e){return S(e,function(e){return i.test(e)?"xn--"+B(e):e})},toUnicode:function(e){return S(e,function(e){return r.test(e)?E(e.slice(4).toLowerCase()):e})}}}()),i=["ac","com.ac","edu.ac","gov.ac","mil.ac","net.ac","org.ac","ad","ae","ac.ae","co.ae","gov.ae","mil.ae","net.ae","org.ae","sch.ae","aero","airline.aero","airport.aero","accident-investigation.aero","accident-prevention.aero","aerobatic.aero","aeroclub.aero","aerodrome.aero","agents.aero","air-surveillance.aero","air-traffic-control.aero","aircraft.aero","airtraffic.aero","ambulance.aero","association.aero","author.aero","ballooning.aero","broker.aero","caa.aero","cargo.aero","catering.aero","certification.aero","championship.aero","charter.aero","civilaviation.aero","club.aero","conference.aero","consultant.aero","consulting.aero","control.aero","council.aero","crew.aero","design.aero","dgca.aero","educator.aero","emergency.aero","engine.aero","engineer.aero","entertainment.aero","equipment.aero","exchange.aero","express.aero","federation.aero","flight.aero","freight.aero","fuel.aero","gliding.aero","government.aero","groundhandling.aero","group.aero","hanggliding.aero","homebuilt.aero","insurance.aero","journal.aero","journalist.aero","leasing.aero","logistics.aero","magazine.aero","maintenance.aero","marketplace.aero","media.aero","microlight.aero","modelling.aero","navigation.aero","parachuting.aero","paragliding.aero","passenger-association.aero","pilot.aero","press.aero","production.aero","recreation.aero","repbody.aero","res.aero","research.aero","rotorcraft.aero","safety.aero","scientist.aero","services.aero","show.aero","skydiving.aero","software.aero","student.aero","taxi.aero","trader.aero","trading.aero","trainer.aero","union.aero","workinggroup.aero","works.aero","af","com.af","edu.af","gov.af","net.af","org.af","ag","co.ag","com.ag","net.ag","nom.ag","org.ag","ai","com.ai","net.ai","off.ai","org.ai","al","com.al","edu.al","gov.al","mil.al","net.al","org.al","am","co.am","com.am","commune.am","net.am","org.am","ao","co.ao","ed.ao","edu.ao","gov.ao","gv.ao","it.ao","og.ao","org.ao","pb.ao","aq","ar","bet.ar","com.ar","coop.ar","edu.ar","gob.ar","gov.ar","int.ar","mil.ar","musica.ar","mutual.ar","net.ar","org.ar","senasa.ar","tur.ar","arpa","e164.arpa","home.arpa","in-addr.arpa","ip6.arpa","iris.arpa","uri.arpa","urn.arpa","as","gov.as","asia","at","ac.at","sth.ac.at","co.at","gv.at","or.at","au","asn.au","com.au","edu.au","gov.au","id.au","net.au","org.au","conf.au","oz.au","act.au","nsw.au","nt.au","qld.au","sa.au","tas.au","vic.au","wa.au","act.edu.au","catholic.edu.au","nsw.edu.au","nt.edu.au","qld.edu.au","sa.edu.au","tas.edu.au","vic.edu.au","wa.edu.au","qld.gov.au","sa.gov.au","tas.gov.au","vic.gov.au","wa.gov.au","schools.nsw.edu.au","aw","com.aw","ax","az","biz.az","com.az","edu.az","gov.az","info.az","int.az","mil.az","name.az","net.az","org.az","pp.az","pro.az","ba","com.ba","edu.ba","gov.ba","mil.ba","net.ba","org.ba","bb","biz.bb","co.bb","com.bb","edu.bb","gov.bb","info.bb","net.bb","org.bb","store.bb","tv.bb","*.bd","be","ac.be","bf","gov.bf","bg","0.bg","1.bg","2.bg","3.bg","4.bg","5.bg","6.bg","7.bg","8.bg","9.bg","a.bg","b.bg","c.bg","d.bg","e.bg","f.bg","g.bg","h.bg","i.bg","j.bg","k.bg","l.bg","m.bg","n.bg","o.bg","p.bg","q.bg","r.bg","s.bg","t.bg","u.bg","v.bg","w.bg","x.bg","y.bg","z.bg","bh","com.bh","edu.bh","gov.bh","net.bh","org.bh","bi","co.bi","com.bi","edu.bi","or.bi","org.bi","biz","bj","africa.bj","agro.bj","architectes.bj","assur.bj","avocats.bj","co.bj","com.bj","eco.bj","econo.bj","edu.bj","info.bj","loisirs.bj","money.bj","net.bj","org.bj","ote.bj","restaurant.bj","resto.bj","tourism.bj","univ.bj","bm","com.bm","edu.bm","gov.bm","net.bm","org.bm","bn","com.bn","edu.bn","gov.bn","net.bn","org.bn","bo","com.bo","edu.bo","gob.bo","int.bo","mil.bo","net.bo","org.bo","tv.bo","web.bo","academia.bo","agro.bo","arte.bo","blog.bo","bolivia.bo","ciencia.bo","cooperativa.bo","democracia.bo","deporte.bo","ecologia.bo","economia.bo","empresa.bo","indigena.bo","industria.bo","info.bo","medicina.bo","movimiento.bo","musica.bo","natural.bo","nombre.bo","noticias.bo","patria.bo","plurinacional.bo","politica.bo","profesional.bo","pueblo.bo","revista.bo","salud.bo","tecnologia.bo","tksat.bo","transporte.bo","wiki.bo","br","9guacu.br","abc.br","adm.br","adv.br","agr.br","aju.br","am.br","anani.br","aparecida.br","app.br","arq.br","art.br","ato.br","b.br","barueri.br","belem.br","bet.br","bhz.br","bib.br","bio.br","blog.br","bmd.br","boavista.br","bsb.br","campinagrande.br","campinas.br","caxias.br","cim.br","cng.br","cnt.br","com.br","contagem.br","coop.br","coz.br","cri.br","cuiaba.br","curitiba.br","def.br","des.br","det.br","dev.br","ecn.br","eco.br","edu.br","emp.br","enf.br","eng.br","esp.br","etc.br","eti.br","far.br","feira.br","flog.br","floripa.br","fm.br","fnd.br","fortal.br","fot.br","foz.br","fst.br","g12.br","geo.br","ggf.br","goiania.br","gov.br","ac.gov.br","al.gov.br","am.gov.br","ap.gov.br","ba.gov.br","ce.gov.br","df.gov.br","es.gov.br","go.gov.br","ma.gov.br","mg.gov.br","ms.gov.br","mt.gov.br","pa.gov.br","pb.gov.br","pe.gov.br","pi.gov.br","pr.gov.br","rj.gov.br","rn.gov.br","ro.gov.br","rr.gov.br","rs.gov.br","sc.gov.br","se.gov.br","sp.gov.br","to.gov.br","gru.br","imb.br","ind.br","inf.br","jab.br","jampa.br","jdf.br","joinville.br","jor.br","jus.br","leg.br","leilao.br","lel.br","log.br","londrina.br","macapa.br","maceio.br","manaus.br","maringa.br","mat.br","med.br","mil.br","morena.br","mp.br","mus.br","natal.br","net.br","niteroi.br","*.nom.br","not.br","ntr.br","odo.br","ong.br","org.br","osasco.br","palmas.br","poa.br","ppg.br","pro.br","psc.br","psi.br","pvh.br","qsl.br","radio.br","rec.br","recife.br","rep.br","ribeirao.br","rio.br","riobranco.br","riopreto.br","salvador.br","sampa.br","santamaria.br","santoandre.br","saobernardo.br","saogonca.br","seg.br","sjc.br","slg.br","slz.br","sorocaba.br","srv.br","taxi.br","tc.br","tec.br","teo.br","the.br","tmp.br","trd.br","tur.br","tv.br","udi.br","vet.br","vix.br","vlog.br","wiki.br","zlg.br","bs","com.bs","edu.bs","gov.bs","net.bs","org.bs","bt","com.bt","edu.bt","gov.bt","net.bt","org.bt","bv","bw","co.bw","org.bw","by","gov.by","mil.by","com.by","of.by","bz","co.bz","com.bz","edu.bz","gov.bz","net.bz","org.bz","ca","ab.ca","bc.ca","mb.ca","nb.ca","nf.ca","nl.ca","ns.ca","nt.ca","nu.ca","on.ca","pe.ca","qc.ca","sk.ca","yk.ca","gc.ca","cat","cc","cd","gov.cd","cf","cg","ch","ci","ac.ci","aéroport.ci","asso.ci","co.ci","com.ci","ed.ci","edu.ci","go.ci","gouv.ci","int.ci","net.ci","or.ci","org.ci","*.ck","!www.ck","cl","co.cl","gob.cl","gov.cl","mil.cl","cm","co.cm","com.cm","gov.cm","net.cm","cn","ac.cn","com.cn","edu.cn","gov.cn","mil.cn","net.cn","org.cn","公司.cn","網絡.cn","网络.cn","ah.cn","bj.cn","cq.cn","fj.cn","gd.cn","gs.cn","gx.cn","gz.cn","ha.cn","hb.cn","he.cn","hi.cn","hk.cn","hl.cn","hn.cn","jl.cn","js.cn","jx.cn","ln.cn","mo.cn","nm.cn","nx.cn","qh.cn","sc.cn","sd.cn","sh.cn","sn.cn","sx.cn","tj.cn","tw.cn","xj.cn","xz.cn","yn.cn","zj.cn","co","com.co","edu.co","gov.co","mil.co","net.co","nom.co","org.co","com","coop","cr","ac.cr","co.cr","ed.cr","fi.cr","go.cr","or.cr","sa.cr","cu","com.cu","edu.cu","gob.cu","inf.cu","nat.cu","net.cu","org.cu","cv","com.cv","edu.cv","id.cv","int.cv","net.cv","nome.cv","org.cv","publ.cv","cw","com.cw","edu.cw","net.cw","org.cw","cx","gov.cx","cy","ac.cy","biz.cy","com.cy","ekloges.cy","gov.cy","ltd.cy","mil.cy","net.cy","org.cy","press.cy","pro.cy","tm.cy","cz","de","dj","dk","dm","co.dm","com.dm","edu.dm","gov.dm","net.dm","org.dm","do","art.do","com.do","edu.do","gob.do","gov.do","mil.do","net.do","org.do","sld.do","web.do","dz","art.dz","asso.dz","com.dz","edu.dz","gov.dz","net.dz","org.dz","pol.dz","soc.dz","tm.dz","ec","com.ec","edu.ec","fin.ec","gob.ec","gov.ec","info.ec","k12.ec","med.ec","mil.ec","net.ec","org.ec","pro.ec","edu","ee","aip.ee","com.ee","edu.ee","fie.ee","gov.ee","lib.ee","med.ee","org.ee","pri.ee","riik.ee","eg","ac.eg","com.eg","edu.eg","eun.eg","gov.eg","info.eg","me.eg","mil.eg","name.eg","net.eg","org.eg","sci.eg","sport.eg","tv.eg","*.er","es","com.es","edu.es","gob.es","nom.es","org.es","et","biz.et","com.et","edu.et","gov.et","info.et","name.et","net.et","org.et","eu","fi","aland.fi","fj","ac.fj","biz.fj","com.fj","gov.fj","info.fj","mil.fj","name.fj","net.fj","org.fj","pro.fj","*.fk","fm","com.fm","edu.fm","net.fm","org.fm","fo","fr","asso.fr","com.fr","gouv.fr","nom.fr","prd.fr","tm.fr","avoues.fr","cci.fr","greta.fr","huissier-justice.fr","ga","gb","gd","edu.gd","gov.gd","ge","com.ge","edu.ge","gov.ge","net.ge","org.ge","pvt.ge","school.ge","gf","gg","co.gg","net.gg","org.gg","gh","com.gh","edu.gh","gov.gh","mil.gh","org.gh","gi","com.gi","edu.gi","gov.gi","ltd.gi","mod.gi","org.gi","gl","co.gl","com.gl","edu.gl","net.gl","org.gl","gm","gn","ac.gn","com.gn","edu.gn","gov.gn","net.gn","org.gn","gov","gp","asso.gp","com.gp","edu.gp","mobi.gp","net.gp","org.gp","gq","gr","com.gr","edu.gr","gov.gr","net.gr","org.gr","gs","gt","com.gt","edu.gt","gob.gt","ind.gt","mil.gt","net.gt","org.gt","gu","com.gu","edu.gu","gov.gu","guam.gu","info.gu","net.gu","org.gu","web.gu","gw","gy","co.gy","com.gy","edu.gy","gov.gy","net.gy","org.gy","hk","com.hk","edu.hk","gov.hk","idv.hk","net.hk","org.hk","个人.hk","個人.hk","公司.hk","政府.hk","敎育.hk","教育.hk","箇人.hk","組織.hk","組织.hk","網絡.hk","網络.hk","组織.hk","组织.hk","网絡.hk","网络.hk","hm","hn","com.hn","edu.hn","gob.hn","mil.hn","net.hn","org.hn","hr","com.hr","from.hr","iz.hr","name.hr","ht","adult.ht","art.ht","asso.ht","com.ht","coop.ht","edu.ht","firm.ht","gouv.ht","info.ht","med.ht","net.ht","org.ht","perso.ht","pol.ht","pro.ht","rel.ht","shop.ht","hu","2000.hu","agrar.hu","bolt.hu","casino.hu","city.hu","co.hu","erotica.hu","erotika.hu","film.hu","forum.hu","games.hu","hotel.hu","info.hu","ingatlan.hu","jogasz.hu","konyvelo.hu","lakas.hu","media.hu","news.hu","org.hu","priv.hu","reklam.hu","sex.hu","shop.hu","sport.hu","suli.hu","szex.hu","tm.hu","tozsde.hu","utazas.hu","video.hu","id","ac.id","biz.id","co.id","desa.id","go.id","mil.id","my.id","net.id","or.id","ponpes.id","sch.id","web.id","ie","gov.ie","il","ac.il","co.il","gov.il","idf.il","k12.il","muni.il","net.il","org.il","ישראל","אקדמיה.ישראל","ישוב.ישראל","צהל.ישראל","ממשל.ישראל","im","ac.im","co.im","ltd.co.im","plc.co.im","com.im","net.im","org.im","tt.im","tv.im","in","5g.in","6g.in","ac.in","ai.in","am.in","bihar.in","biz.in","business.in","ca.in","cn.in","co.in","com.in","coop.in","cs.in","delhi.in","dr.in","edu.in","er.in","firm.in","gen.in","gov.in","gujarat.in","ind.in","info.in","int.in","internet.in","io.in","me.in","mil.in","net.in","nic.in","org.in","pg.in","post.in","pro.in","res.in","travel.in","tv.in","uk.in","up.in","us.in","info","int","eu.int","io","co.io","com.io","edu.io","gov.io","mil.io","net.io","nom.io","org.io","iq","com.iq","edu.iq","gov.iq","mil.iq","net.iq","org.iq","ir","ac.ir","co.ir","gov.ir","id.ir","net.ir","org.ir","sch.ir","ایران.ir","ايران.ir","is","it","edu.it","gov.it","abr.it","abruzzo.it","aosta-valley.it","aostavalley.it","bas.it","basilicata.it","cal.it","calabria.it","cam.it","campania.it","emilia-romagna.it","emiliaromagna.it","emr.it","friuli-v-giulia.it","friuli-ve-giulia.it","friuli-vegiulia.it","friuli-venezia-giulia.it","friuli-veneziagiulia.it","friuli-vgiulia.it","friuliv-giulia.it","friulive-giulia.it","friulivegiulia.it","friulivenezia-giulia.it","friuliveneziagiulia.it","friulivgiulia.it","fvg.it","laz.it","lazio.it","lig.it","liguria.it","lom.it","lombardia.it","lombardy.it","lucania.it","mar.it","marche.it","mol.it","molise.it","piedmont.it","piemonte.it","pmn.it","pug.it","puglia.it","sar.it","sardegna.it","sardinia.it","sic.it","sicilia.it","sicily.it","taa.it","tos.it","toscana.it","trentin-sud-tirol.it","trentin-süd-tirol.it","trentin-sudtirol.it","trentin-südtirol.it","trentin-sued-tirol.it","trentin-suedtirol.it","trentino.it","trentino-a-adige.it","trentino-aadige.it","trentino-alto-adige.it","trentino-altoadige.it","trentino-s-tirol.it","trentino-stirol.it","trentino-sud-tirol.it","trentino-süd-tirol.it","trentino-sudtirol.it","trentino-südtirol.it","trentino-sued-tirol.it","trentino-suedtirol.it","trentinoa-adige.it","trentinoaadige.it","trentinoalto-adige.it","trentinoaltoadige.it","trentinos-tirol.it","trentinostirol.it","trentinosud-tirol.it","trentinosüd-tirol.it","trentinosudtirol.it","trentinosüdtirol.it","trentinosued-tirol.it","trentinosuedtirol.it","trentinsud-tirol.it","trentinsüd-tirol.it","trentinsudtirol.it","trentinsüdtirol.it","trentinsued-tirol.it","trentinsuedtirol.it","tuscany.it","umb.it","umbria.it","val-d-aosta.it","val-daosta.it","vald-aosta.it","valdaosta.it","valle-aosta.it","valle-d-aosta.it","valle-daosta.it","valleaosta.it","valled-aosta.it","valledaosta.it","vallee-aoste.it","vallée-aoste.it","vallee-d-aoste.it","vallée-d-aoste.it","valleeaoste.it","valléeaoste.it","valleedaoste.it","valléedaoste.it","vao.it","vda.it","ven.it","veneto.it","ag.it","agrigento.it","al.it","alessandria.it","alto-adige.it","altoadige.it","an.it","ancona.it","andria-barletta-trani.it","andria-trani-barletta.it","andriabarlettatrani.it","andriatranibarletta.it","ao.it","aosta.it","aoste.it","ap.it","aq.it","aquila.it","ar.it","arezzo.it","ascoli-piceno.it","ascolipiceno.it","asti.it","at.it","av.it","avellino.it","ba.it","balsan.it","balsan-sudtirol.it","balsan-südtirol.it","balsan-suedtirol.it","bari.it","barletta-trani-andria.it","barlettatraniandria.it","belluno.it","benevento.it","bergamo.it","bg.it","bi.it","biella.it","bl.it","bn.it","bo.it","bologna.it","bolzano.it","bolzano-altoadige.it","bozen.it","bozen-sudtirol.it","bozen-südtirol.it","bozen-suedtirol.it","br.it","brescia.it","brindisi.it","bs.it","bt.it","bulsan.it","bulsan-sudtirol.it","bulsan-südtirol.it","bulsan-suedtirol.it","bz.it","ca.it","cagliari.it","caltanissetta.it","campidano-medio.it","campidanomedio.it","campobasso.it","carbonia-iglesias.it","carboniaiglesias.it","carrara-massa.it","carraramassa.it","caserta.it","catania.it","catanzaro.it","cb.it","ce.it","cesena-forli.it","cesena-forlì.it","cesenaforli.it","cesenaforlì.it","ch.it","chieti.it","ci.it","cl.it","cn.it","co.it","como.it","cosenza.it","cr.it","cremona.it","crotone.it","cs.it","ct.it","cuneo.it","cz.it","dell-ogliastra.it","dellogliastra.it","en.it","enna.it","fc.it","fe.it","fermo.it","ferrara.it","fg.it","fi.it","firenze.it","florence.it","fm.it","foggia.it","forli-cesena.it","forlì-cesena.it","forlicesena.it","forlìcesena.it","fr.it","frosinone.it","ge.it","genoa.it","genova.it","go.it","gorizia.it","gr.it","grosseto.it","iglesias-carbonia.it","iglesiascarbonia.it","im.it","imperia.it","is.it","isernia.it","kr.it","la-spezia.it","laquila.it","laspezia.it","latina.it","lc.it","le.it","lecce.it","lecco.it","li.it","livorno.it","lo.it","lodi.it","lt.it","lu.it","lucca.it","macerata.it","mantova.it","massa-carrara.it","massacarrara.it","matera.it","mb.it","mc.it","me.it","medio-campidano.it","mediocampidano.it","messina.it","mi.it","milan.it","milano.it","mn.it","mo.it","modena.it","monza.it","monza-brianza.it","monza-e-della-brianza.it","monzabrianza.it","monzaebrianza.it","monzaedellabrianza.it","ms.it","mt.it","na.it","naples.it","napoli.it","no.it","novara.it","nu.it","nuoro.it","og.it","ogliastra.it","olbia-tempio.it","olbiatempio.it","or.it","oristano.it","ot.it","pa.it","padova.it","padua.it","palermo.it","parma.it","pavia.it","pc.it","pd.it","pe.it","perugia.it","pesaro-urbino.it","pesarourbino.it","pescara.it","pg.it","pi.it","piacenza.it","pisa.it","pistoia.it","pn.it","po.it","pordenone.it","potenza.it","pr.it","prato.it","pt.it","pu.it","pv.it","pz.it","ra.it","ragusa.it","ravenna.it","rc.it","re.it","reggio-calabria.it","reggio-emilia.it","reggiocalabria.it","reggioemilia.it","rg.it","ri.it","rieti.it","rimini.it","rm.it","rn.it","ro.it","roma.it","rome.it","rovigo.it","sa.it","salerno.it","sassari.it","savona.it","si.it","siena.it","siracusa.it","so.it","sondrio.it","sp.it","sr.it","ss.it","südtirol.it","suedtirol.it","sv.it","ta.it","taranto.it","te.it","tempio-olbia.it","tempioolbia.it","teramo.it","terni.it","tn.it","to.it","torino.it","tp.it","tr.it","trani-andria-barletta.it","trani-barletta-andria.it","traniandriabarletta.it","tranibarlettaandria.it","trapani.it","trento.it","treviso.it","trieste.it","ts.it","turin.it","tv.it","ud.it","udine.it","urbino-pesaro.it","urbinopesaro.it","va.it","varese.it","vb.it","vc.it","ve.it","venezia.it","venice.it","verbania.it","vercelli.it","verona.it","vi.it","vibo-valentia.it","vibovalentia.it","vicenza.it","viterbo.it","vr.it","vs.it","vt.it","vv.it","je","co.je","net.je","org.je","*.jm","jo","agri.jo","ai.jo","com.jo","edu.jo","eng.jo","fm.jo","gov.jo","mil.jo","net.jo","org.jo","per.jo","phd.jo","sch.jo","tv.jo","jobs","jp","ac.jp","ad.jp","co.jp","ed.jp","go.jp","gr.jp","lg.jp","ne.jp","or.jp","aichi.jp","akita.jp","aomori.jp","chiba.jp","ehime.jp","fukui.jp","fukuoka.jp","fukushima.jp","gifu.jp","gunma.jp","hiroshima.jp","hokkaido.jp","hyogo.jp","ibaraki.jp","ishikawa.jp","iwate.jp","kagawa.jp","kagoshima.jp","kanagawa.jp","kochi.jp","kumamoto.jp","kyoto.jp","mie.jp","miyagi.jp","miyazaki.jp","nagano.jp","nagasaki.jp","nara.jp","niigata.jp","oita.jp","okayama.jp","okinawa.jp","osaka.jp","saga.jp","saitama.jp","shiga.jp","shimane.jp","shizuoka.jp","tochigi.jp","tokushima.jp","tokyo.jp","tottori.jp","toyama.jp","wakayama.jp","yamagata.jp","yamaguchi.jp","yamanashi.jp","三重.jp","京都.jp","佐賀.jp","兵庫.jp","北海道.jp","千葉.jp","和歌山.jp","埼玉.jp","大分.jp","大阪.jp","奈良.jp","宮城.jp","宮崎.jp","富山.jp","山口.jp","山形.jp","山梨.jp","岐阜.jp","岡山.jp","岩手.jp","島根.jp","広島.jp","徳島.jp","愛媛.jp","愛知.jp","新潟.jp","東京.jp","栃木.jp","沖縄.jp","滋賀.jp","熊本.jp","石川.jp","神奈川.jp","福井.jp","福岡.jp","福島.jp","秋田.jp","群馬.jp","茨城.jp","長崎.jp","長野.jp","青森.jp","静岡.jp","香川.jp","高知.jp","鳥取.jp","鹿児島.jp","*.kawasaki.jp","!city.kawasaki.jp","*.kitakyushu.jp","!city.kitakyushu.jp","*.kobe.jp","!city.kobe.jp","*.nagoya.jp","!city.nagoya.jp","*.sapporo.jp","!city.sapporo.jp","*.sendai.jp","!city.sendai.jp","*.yokohama.jp","!city.yokohama.jp","aisai.aichi.jp","ama.aichi.jp","anjo.aichi.jp","asuke.aichi.jp","chiryu.aichi.jp","chita.aichi.jp","fuso.aichi.jp","gamagori.aichi.jp","handa.aichi.jp","hazu.aichi.jp","hekinan.aichi.jp","higashiura.aichi.jp","ichinomiya.aichi.jp","inazawa.aichi.jp","inuyama.aichi.jp","isshiki.aichi.jp","iwakura.aichi.jp","kanie.aichi.jp","kariya.aichi.jp","kasugai.aichi.jp","kira.aichi.jp","kiyosu.aichi.jp","komaki.aichi.jp","konan.aichi.jp","kota.aichi.jp","mihama.aichi.jp","miyoshi.aichi.jp","nishio.aichi.jp","nisshin.aichi.jp","obu.aichi.jp","oguchi.aichi.jp","oharu.aichi.jp","okazaki.aichi.jp","owariasahi.aichi.jp","seto.aichi.jp","shikatsu.aichi.jp","shinshiro.aichi.jp","shitara.aichi.jp","tahara.aichi.jp","takahama.aichi.jp","tobishima.aichi.jp","toei.aichi.jp","togo.aichi.jp","tokai.aichi.jp","tokoname.aichi.jp","toyoake.aichi.jp","toyohashi.aichi.jp","toyokawa.aichi.jp","toyone.aichi.jp","toyota.aichi.jp","tsushima.aichi.jp","yatomi.aichi.jp","akita.akita.jp","daisen.akita.jp","fujisato.akita.jp","gojome.akita.jp","hachirogata.akita.jp","happou.akita.jp","higashinaruse.akita.jp","honjo.akita.jp","honjyo.akita.jp","ikawa.akita.jp","kamikoani.akita.jp","kamioka.akita.jp","katagami.akita.jp","kazuno.akita.jp","kitaakita.akita.jp","kosaka.akita.jp","kyowa.akita.jp","misato.akita.jp","mitane.akita.jp","moriyoshi.akita.jp","nikaho.akita.jp","noshiro.akita.jp","odate.akita.jp","oga.akita.jp","ogata.akita.jp","semboku.akita.jp","yokote.akita.jp","yurihonjo.akita.jp","aomori.aomori.jp","gonohe.aomori.jp","hachinohe.aomori.jp","hashikami.aomori.jp","hiranai.aomori.jp","hirosaki.aomori.jp","itayanagi.aomori.jp","kuroishi.aomori.jp","misawa.aomori.jp","mutsu.aomori.jp","nakadomari.aomori.jp","noheji.aomori.jp","oirase.aomori.jp","owani.aomori.jp","rokunohe.aomori.jp","sannohe.aomori.jp","shichinohe.aomori.jp","shingo.aomori.jp","takko.aomori.jp","towada.aomori.jp","tsugaru.aomori.jp","tsuruta.aomori.jp","abiko.chiba.jp","asahi.chiba.jp","chonan.chiba.jp","chosei.chiba.jp","choshi.chiba.jp","chuo.chiba.jp","funabashi.chiba.jp","futtsu.chiba.jp","hanamigawa.chiba.jp","ichihara.chiba.jp","ichikawa.chiba.jp","ichinomiya.chiba.jp","inzai.chiba.jp","isumi.chiba.jp","kamagaya.chiba.jp","kamogawa.chiba.jp","kashiwa.chiba.jp","katori.chiba.jp","katsuura.chiba.jp","kimitsu.chiba.jp","kisarazu.chiba.jp","kozaki.chiba.jp","kujukuri.chiba.jp","kyonan.chiba.jp","matsudo.chiba.jp","midori.chiba.jp","mihama.chiba.jp","minamiboso.chiba.jp","mobara.chiba.jp","mutsuzawa.chiba.jp","nagara.chiba.jp","nagareyama.chiba.jp","narashino.chiba.jp","narita.chiba.jp","noda.chiba.jp","oamishirasato.chiba.jp","omigawa.chiba.jp","onjuku.chiba.jp","otaki.chiba.jp","sakae.chiba.jp","sakura.chiba.jp","shimofusa.chiba.jp","shirako.chiba.jp","shiroi.chiba.jp","shisui.chiba.jp","sodegaura.chiba.jp","sosa.chiba.jp","tako.chiba.jp","tateyama.chiba.jp","togane.chiba.jp","tohnosho.chiba.jp","tomisato.chiba.jp","urayasu.chiba.jp","yachimata.chiba.jp","yachiyo.chiba.jp","yokaichiba.chiba.jp","yokoshibahikari.chiba.jp","yotsukaido.chiba.jp","ainan.ehime.jp","honai.ehime.jp","ikata.ehime.jp","imabari.ehime.jp","iyo.ehime.jp","kamijima.ehime.jp","kihoku.ehime.jp","kumakogen.ehime.jp","masaki.ehime.jp","matsuno.ehime.jp","matsuyama.ehime.jp","namikata.ehime.jp","niihama.ehime.jp","ozu.ehime.jp","saijo.ehime.jp","seiyo.ehime.jp","shikokuchuo.ehime.jp","tobe.ehime.jp","toon.ehime.jp","uchiko.ehime.jp","uwajima.ehime.jp","yawatahama.ehime.jp","echizen.fukui.jp","eiheiji.fukui.jp","fukui.fukui.jp","ikeda.fukui.jp","katsuyama.fukui.jp","mihama.fukui.jp","minamiechizen.fukui.jp","obama.fukui.jp","ohi.fukui.jp","ono.fukui.jp","sabae.fukui.jp","sakai.fukui.jp","takahama.fukui.jp","tsuruga.fukui.jp","wakasa.fukui.jp","ashiya.fukuoka.jp","buzen.fukuoka.jp","chikugo.fukuoka.jp","chikuho.fukuoka.jp","chikujo.fukuoka.jp","chikushino.fukuoka.jp","chikuzen.fukuoka.jp","chuo.fukuoka.jp","dazaifu.fukuoka.jp","fukuchi.fukuoka.jp","hakata.fukuoka.jp","higashi.fukuoka.jp","hirokawa.fukuoka.jp","hisayama.fukuoka.jp","iizuka.fukuoka.jp","inatsuki.fukuoka.jp","kaho.fukuoka.jp","kasuga.fukuoka.jp","kasuya.fukuoka.jp","kawara.fukuoka.jp","keisen.fukuoka.jp","koga.fukuoka.jp","kurate.fukuoka.jp","kurogi.fukuoka.jp","kurume.fukuoka.jp","minami.fukuoka.jp","miyako.fukuoka.jp","miyama.fukuoka.jp","miyawaka.fukuoka.jp","mizumaki.fukuoka.jp","munakata.fukuoka.jp","nakagawa.fukuoka.jp","nakama.fukuoka.jp","nishi.fukuoka.jp","nogata.fukuoka.jp","ogori.fukuoka.jp","okagaki.fukuoka.jp","okawa.fukuoka.jp","oki.fukuoka.jp","omuta.fukuoka.jp","onga.fukuoka.jp","onojo.fukuoka.jp","oto.fukuoka.jp","saigawa.fukuoka.jp","sasaguri.fukuoka.jp","shingu.fukuoka.jp","shinyoshitomi.fukuoka.jp","shonai.fukuoka.jp","soeda.fukuoka.jp","sue.fukuoka.jp","tachiarai.fukuoka.jp","tagawa.fukuoka.jp","takata.fukuoka.jp","toho.fukuoka.jp","toyotsu.fukuoka.jp","tsuiki.fukuoka.jp","ukiha.fukuoka.jp","umi.fukuoka.jp","usui.fukuoka.jp","yamada.fukuoka.jp","yame.fukuoka.jp","yanagawa.fukuoka.jp","yukuhashi.fukuoka.jp","aizubange.fukushima.jp","aizumisato.fukushima.jp","aizuwakamatsu.fukushima.jp","asakawa.fukushima.jp","bandai.fukushima.jp","date.fukushima.jp","fukushima.fukushima.jp","furudono.fukushima.jp","futaba.fukushima.jp","hanawa.fukushima.jp","higashi.fukushima.jp","hirata.fukushima.jp","hirono.fukushima.jp","iitate.fukushima.jp","inawashiro.fukushima.jp","ishikawa.fukushima.jp","iwaki.fukushima.jp","izumizaki.fukushima.jp","kagamiishi.fukushima.jp","kaneyama.fukushima.jp","kawamata.fukushima.jp","kitakata.fukushima.jp","kitashiobara.fukushima.jp","koori.fukushima.jp","koriyama.fukushima.jp","kunimi.fukushima.jp","miharu.fukushima.jp","mishima.fukushima.jp","namie.fukushima.jp","nango.fukushima.jp","nishiaizu.fukushima.jp","nishigo.fukushima.jp","okuma.fukushima.jp","omotego.fukushima.jp","ono.fukushima.jp","otama.fukushima.jp","samegawa.fukushima.jp","shimogo.fukushima.jp","shirakawa.fukushima.jp","showa.fukushima.jp","soma.fukushima.jp","sukagawa.fukushima.jp","taishin.fukushima.jp","tamakawa.fukushima.jp","tanagura.fukushima.jp","tenei.fukushima.jp","yabuki.fukushima.jp","yamato.fukushima.jp","yamatsuri.fukushima.jp","yanaizu.fukushima.jp","yugawa.fukushima.jp","anpachi.gifu.jp","ena.gifu.jp","gifu.gifu.jp","ginan.gifu.jp","godo.gifu.jp","gujo.gifu.jp","hashima.gifu.jp","hichiso.gifu.jp","hida.gifu.jp","higashishirakawa.gifu.jp","ibigawa.gifu.jp","ikeda.gifu.jp","kakamigahara.gifu.jp","kani.gifu.jp","kasahara.gifu.jp","kasamatsu.gifu.jp","kawaue.gifu.jp","kitagata.gifu.jp","mino.gifu.jp","minokamo.gifu.jp","mitake.gifu.jp","mizunami.gifu.jp","motosu.gifu.jp","nakatsugawa.gifu.jp","ogaki.gifu.jp","sakahogi.gifu.jp","seki.gifu.jp","sekigahara.gifu.jp","shirakawa.gifu.jp","tajimi.gifu.jp","takayama.gifu.jp","tarui.gifu.jp","toki.gifu.jp","tomika.gifu.jp","wanouchi.gifu.jp","yamagata.gifu.jp","yaotsu.gifu.jp","yoro.gifu.jp","annaka.gunma.jp","chiyoda.gunma.jp","fujioka.gunma.jp","higashiagatsuma.gunma.jp","isesaki.gunma.jp","itakura.gunma.jp","kanna.gunma.jp","kanra.gunma.jp","katashina.gunma.jp","kawaba.gunma.jp","kiryu.gunma.jp","kusatsu.gunma.jp","maebashi.gunma.jp","meiwa.gunma.jp","midori.gunma.jp","minakami.gunma.jp","naganohara.gunma.jp","nakanojo.gunma.jp","nanmoku.gunma.jp","numata.gunma.jp","oizumi.gunma.jp","ora.gunma.jp","ota.gunma.jp","shibukawa.gunma.jp","shimonita.gunma.jp","shinto.gunma.jp","showa.gunma.jp","takasaki.gunma.jp","takayama.gunma.jp","tamamura.gunma.jp","tatebayashi.gunma.jp","tomioka.gunma.jp","tsukiyono.gunma.jp","tsumagoi.gunma.jp","ueno.gunma.jp","yoshioka.gunma.jp","asaminami.hiroshima.jp","daiwa.hiroshima.jp","etajima.hiroshima.jp","fuchu.hiroshima.jp","fukuyama.hiroshima.jp","hatsukaichi.hiroshima.jp","higashihiroshima.hiroshima.jp","hongo.hiroshima.jp","jinsekikogen.hiroshima.jp","kaita.hiroshima.jp","kui.hiroshima.jp","kumano.hiroshima.jp","kure.hiroshima.jp","mihara.hiroshima.jp","miyoshi.hiroshima.jp","naka.hiroshima.jp","onomichi.hiroshima.jp","osakikamijima.hiroshima.jp","otake.hiroshima.jp","saka.hiroshima.jp","sera.hiroshima.jp","seranishi.hiroshima.jp","shinichi.hiroshima.jp","shobara.hiroshima.jp","takehara.hiroshima.jp","abashiri.hokkaido.jp","abira.hokkaido.jp","aibetsu.hokkaido.jp","akabira.hokkaido.jp","akkeshi.hokkaido.jp","asahikawa.hokkaido.jp","ashibetsu.hokkaido.jp","ashoro.hokkaido.jp","assabu.hokkaido.jp","atsuma.hokkaido.jp","bibai.hokkaido.jp","biei.hokkaido.jp","bifuka.hokkaido.jp","bihoro.hokkaido.jp","biratori.hokkaido.jp","chippubetsu.hokkaido.jp","chitose.hokkaido.jp","date.hokkaido.jp","ebetsu.hokkaido.jp","embetsu.hokkaido.jp","eniwa.hokkaido.jp","erimo.hokkaido.jp","esan.hokkaido.jp","esashi.hokkaido.jp","fukagawa.hokkaido.jp","fukushima.hokkaido.jp","furano.hokkaido.jp","furubira.hokkaido.jp","haboro.hokkaido.jp","hakodate.hokkaido.jp","hamatonbetsu.hokkaido.jp","hidaka.hokkaido.jp","higashikagura.hokkaido.jp","higashikawa.hokkaido.jp","hiroo.hokkaido.jp","hokuryu.hokkaido.jp","hokuto.hokkaido.jp","honbetsu.hokkaido.jp","horokanai.hokkaido.jp","horonobe.hokkaido.jp","ikeda.hokkaido.jp","imakane.hokkaido.jp","ishikari.hokkaido.jp","iwamizawa.hokkaido.jp","iwanai.hokkaido.jp","kamifurano.hokkaido.jp","kamikawa.hokkaido.jp","kamishihoro.hokkaido.jp","kamisunagawa.hokkaido.jp","kamoenai.hokkaido.jp","kayabe.hokkaido.jp","kembuchi.hokkaido.jp","kikonai.hokkaido.jp","kimobetsu.hokkaido.jp","kitahiroshima.hokkaido.jp","kitami.hokkaido.jp","kiyosato.hokkaido.jp","koshimizu.hokkaido.jp","kunneppu.hokkaido.jp","kuriyama.hokkaido.jp","kuromatsunai.hokkaido.jp","kushiro.hokkaido.jp","kutchan.hokkaido.jp","kyowa.hokkaido.jp","mashike.hokkaido.jp","matsumae.hokkaido.jp","mikasa.hokkaido.jp","minamifurano.hokkaido.jp","mombetsu.hokkaido.jp","moseushi.hokkaido.jp","mukawa.hokkaido.jp","muroran.hokkaido.jp","naie.hokkaido.jp","nakagawa.hokkaido.jp","nakasatsunai.hokkaido.jp","nakatombetsu.hokkaido.jp","nanae.hokkaido.jp","nanporo.hokkaido.jp","nayoro.hokkaido.jp","nemuro.hokkaido.jp","niikappu.hokkaido.jp","niki.hokkaido.jp","nishiokoppe.hokkaido.jp","noboribetsu.hokkaido.jp","numata.hokkaido.jp","obihiro.hokkaido.jp","obira.hokkaido.jp","oketo.hokkaido.jp","okoppe.hokkaido.jp","otaru.hokkaido.jp","otobe.hokkaido.jp","otofuke.hokkaido.jp","otoineppu.hokkaido.jp","oumu.hokkaido.jp","ozora.hokkaido.jp","pippu.hokkaido.jp","rankoshi.hokkaido.jp","rebun.hokkaido.jp","rikubetsu.hokkaido.jp","rishiri.hokkaido.jp","rishirifuji.hokkaido.jp","saroma.hokkaido.jp","sarufutsu.hokkaido.jp","shakotan.hokkaido.jp","shari.hokkaido.jp","shibecha.hokkaido.jp","shibetsu.hokkaido.jp","shikabe.hokkaido.jp","shikaoi.hokkaido.jp","shimamaki.hokkaido.jp","shimizu.hokkaido.jp","shimokawa.hokkaido.jp","shinshinotsu.hokkaido.jp","shintoku.hokkaido.jp","shiranuka.hokkaido.jp","shiraoi.hokkaido.jp","shiriuchi.hokkaido.jp","sobetsu.hokkaido.jp","sunagawa.hokkaido.jp","taiki.hokkaido.jp","takasu.hokkaido.jp","takikawa.hokkaido.jp","takinoue.hokkaido.jp","teshikaga.hokkaido.jp","tobetsu.hokkaido.jp","tohma.hokkaido.jp","tomakomai.hokkaido.jp","tomari.hokkaido.jp","toya.hokkaido.jp","toyako.hokkaido.jp","toyotomi.hokkaido.jp","toyoura.hokkaido.jp","tsubetsu.hokkaido.jp","tsukigata.hokkaido.jp","urakawa.hokkaido.jp","urausu.hokkaido.jp","uryu.hokkaido.jp","utashinai.hokkaido.jp","wakkanai.hokkaido.jp","wassamu.hokkaido.jp","yakumo.hokkaido.jp","yoichi.hokkaido.jp","aioi.hyogo.jp","akashi.hyogo.jp","ako.hyogo.jp","amagasaki.hyogo.jp","aogaki.hyogo.jp","asago.hyogo.jp","ashiya.hyogo.jp","awaji.hyogo.jp","fukusaki.hyogo.jp","goshiki.hyogo.jp","harima.hyogo.jp","himeji.hyogo.jp","ichikawa.hyogo.jp","inagawa.hyogo.jp","itami.hyogo.jp","kakogawa.hyogo.jp","kamigori.hyogo.jp","kamikawa.hyogo.jp","kasai.hyogo.jp","kasuga.hyogo.jp","kawanishi.hyogo.jp","miki.hyogo.jp","minamiawaji.hyogo.jp","nishinomiya.hyogo.jp","nishiwaki.hyogo.jp","ono.hyogo.jp","sanda.hyogo.jp","sannan.hyogo.jp","sasayama.hyogo.jp","sayo.hyogo.jp","shingu.hyogo.jp","shinonsen.hyogo.jp","shiso.hyogo.jp","sumoto.hyogo.jp","taishi.hyogo.jp","taka.hyogo.jp","takarazuka.hyogo.jp","takasago.hyogo.jp","takino.hyogo.jp","tamba.hyogo.jp","tatsuno.hyogo.jp","toyooka.hyogo.jp","yabu.hyogo.jp","yashiro.hyogo.jp","yoka.hyogo.jp","yokawa.hyogo.jp","ami.ibaraki.jp","asahi.ibaraki.jp","bando.ibaraki.jp","chikusei.ibaraki.jp","daigo.ibaraki.jp","fujishiro.ibaraki.jp","hitachi.ibaraki.jp","hitachinaka.ibaraki.jp","hitachiomiya.ibaraki.jp","hitachiota.ibaraki.jp","ibaraki.ibaraki.jp","ina.ibaraki.jp","inashiki.ibaraki.jp","itako.ibaraki.jp","iwama.ibaraki.jp","joso.ibaraki.jp","kamisu.ibaraki.jp","kasama.ibaraki.jp","kashima.ibaraki.jp","kasumigaura.ibaraki.jp","koga.ibaraki.jp","miho.ibaraki.jp","mito.ibaraki.jp","moriya.ibaraki.jp","naka.ibaraki.jp","namegata.ibaraki.jp","oarai.ibaraki.jp","ogawa.ibaraki.jp","omitama.ibaraki.jp","ryugasaki.ibaraki.jp","sakai.ibaraki.jp","sakuragawa.ibaraki.jp","shimodate.ibaraki.jp","shimotsuma.ibaraki.jp","shirosato.ibaraki.jp","sowa.ibaraki.jp","suifu.ibaraki.jp","takahagi.ibaraki.jp","tamatsukuri.ibaraki.jp","tokai.ibaraki.jp","tomobe.ibaraki.jp","tone.ibaraki.jp","toride.ibaraki.jp","tsuchiura.ibaraki.jp","tsukuba.ibaraki.jp","uchihara.ibaraki.jp","ushiku.ibaraki.jp","yachiyo.ibaraki.jp","yamagata.ibaraki.jp","yawara.ibaraki.jp","yuki.ibaraki.jp","anamizu.ishikawa.jp","hakui.ishikawa.jp","hakusan.ishikawa.jp","kaga.ishikawa.jp","kahoku.ishikawa.jp","kanazawa.ishikawa.jp","kawakita.ishikawa.jp","komatsu.ishikawa.jp","nakanoto.ishikawa.jp","nanao.ishikawa.jp","nomi.ishikawa.jp","nonoichi.ishikawa.jp","noto.ishikawa.jp","shika.ishikawa.jp","suzu.ishikawa.jp","tsubata.ishikawa.jp","tsurugi.ishikawa.jp","uchinada.ishikawa.jp","wajima.ishikawa.jp","fudai.iwate.jp","fujisawa.iwate.jp","hanamaki.iwate.jp","hiraizumi.iwate.jp","hirono.iwate.jp","ichinohe.iwate.jp","ichinoseki.iwate.jp","iwaizumi.iwate.jp","iwate.iwate.jp","joboji.iwate.jp","kamaishi.iwate.jp","kanegasaki.iwate.jp","karumai.iwate.jp","kawai.iwate.jp","kitakami.iwate.jp","kuji.iwate.jp","kunohe.iwate.jp","kuzumaki.iwate.jp","miyako.iwate.jp","mizusawa.iwate.jp","morioka.iwate.jp","ninohe.iwate.jp","noda.iwate.jp","ofunato.iwate.jp","oshu.iwate.jp","otsuchi.iwate.jp","rikuzentakata.iwate.jp","shiwa.iwate.jp","shizukuishi.iwate.jp","sumita.iwate.jp","tanohata.iwate.jp","tono.iwate.jp","yahaba.iwate.jp","yamada.iwate.jp","ayagawa.kagawa.jp","higashikagawa.kagawa.jp","kanonji.kagawa.jp","kotohira.kagawa.jp","manno.kagawa.jp","marugame.kagawa.jp","mitoyo.kagawa.jp","naoshima.kagawa.jp","sanuki.kagawa.jp","tadotsu.kagawa.jp","takamatsu.kagawa.jp","tonosho.kagawa.jp","uchinomi.kagawa.jp","utazu.kagawa.jp","zentsuji.kagawa.jp","akune.kagoshima.jp","amami.kagoshima.jp","hioki.kagoshima.jp","isa.kagoshima.jp","isen.kagoshima.jp","izumi.kagoshima.jp","kagoshima.kagoshima.jp","kanoya.kagoshima.jp","kawanabe.kagoshima.jp","kinko.kagoshima.jp","kouyama.kagoshima.jp","makurazaki.kagoshima.jp","matsumoto.kagoshima.jp","minamitane.kagoshima.jp","nakatane.kagoshima.jp","nishinoomote.kagoshima.jp","satsumasendai.kagoshima.jp","soo.kagoshima.jp","tarumizu.kagoshima.jp","yusui.kagoshima.jp","aikawa.kanagawa.jp","atsugi.kanagawa.jp","ayase.kanagawa.jp","chigasaki.kanagawa.jp","ebina.kanagawa.jp","fujisawa.kanagawa.jp","hadano.kanagawa.jp","hakone.kanagawa.jp","hiratsuka.kanagawa.jp","isehara.kanagawa.jp","kaisei.kanagawa.jp","kamakura.kanagawa.jp","kiyokawa.kanagawa.jp","matsuda.kanagawa.jp","minamiashigara.kanagawa.jp","miura.kanagawa.jp","nakai.kanagawa.jp","ninomiya.kanagawa.jp","odawara.kanagawa.jp","oi.kanagawa.jp","oiso.kanagawa.jp","sagamihara.kanagawa.jp","samukawa.kanagawa.jp","tsukui.kanagawa.jp","yamakita.kanagawa.jp","yamato.kanagawa.jp","yokosuka.kanagawa.jp","yugawara.kanagawa.jp","zama.kanagawa.jp","zushi.kanagawa.jp","aki.kochi.jp","geisei.kochi.jp","hidaka.kochi.jp","higashitsuno.kochi.jp","ino.kochi.jp","kagami.kochi.jp","kami.kochi.jp","kitagawa.kochi.jp","kochi.kochi.jp","mihara.kochi.jp","motoyama.kochi.jp","muroto.kochi.jp","nahari.kochi.jp","nakamura.kochi.jp","nankoku.kochi.jp","nishitosa.kochi.jp","niyodogawa.kochi.jp","ochi.kochi.jp","okawa.kochi.jp","otoyo.kochi.jp","otsuki.kochi.jp","sakawa.kochi.jp","sukumo.kochi.jp","susaki.kochi.jp","tosa.kochi.jp","tosashimizu.kochi.jp","toyo.kochi.jp","tsuno.kochi.jp","umaji.kochi.jp","yasuda.kochi.jp","yusuhara.kochi.jp","amakusa.kumamoto.jp","arao.kumamoto.jp","aso.kumamoto.jp","choyo.kumamoto.jp","gyokuto.kumamoto.jp","kamiamakusa.kumamoto.jp","kikuchi.kumamoto.jp","kumamoto.kumamoto.jp","mashiki.kumamoto.jp","mifune.kumamoto.jp","minamata.kumamoto.jp","minamioguni.kumamoto.jp","nagasu.kumamoto.jp","nishihara.kumamoto.jp","oguni.kumamoto.jp","ozu.kumamoto.jp","sumoto.kumamoto.jp","takamori.kumamoto.jp","uki.kumamoto.jp","uto.kumamoto.jp","yamaga.kumamoto.jp","yamato.kumamoto.jp","yatsushiro.kumamoto.jp","ayabe.kyoto.jp","fukuchiyama.kyoto.jp","higashiyama.kyoto.jp","ide.kyoto.jp","ine.kyoto.jp","joyo.kyoto.jp","kameoka.kyoto.jp","kamo.kyoto.jp","kita.kyoto.jp","kizu.kyoto.jp","kumiyama.kyoto.jp","kyotamba.kyoto.jp","kyotanabe.kyoto.jp","kyotango.kyoto.jp","maizuru.kyoto.jp","minami.kyoto.jp","minamiyamashiro.kyoto.jp","miyazu.kyoto.jp","muko.kyoto.jp","nagaokakyo.kyoto.jp","nakagyo.kyoto.jp","nantan.kyoto.jp","oyamazaki.kyoto.jp","sakyo.kyoto.jp","seika.kyoto.jp","tanabe.kyoto.jp","uji.kyoto.jp","ujitawara.kyoto.jp","wazuka.kyoto.jp","yamashina.kyoto.jp","yawata.kyoto.jp","asahi.mie.jp","inabe.mie.jp","ise.mie.jp","kameyama.mie.jp","kawagoe.mie.jp","kiho.mie.jp","kisosaki.mie.jp","kiwa.mie.jp","komono.mie.jp","kumano.mie.jp","kuwana.mie.jp","matsusaka.mie.jp","meiwa.mie.jp","mihama.mie.jp","minamiise.mie.jp","misugi.mie.jp","miyama.mie.jp","nabari.mie.jp","shima.mie.jp","suzuka.mie.jp","tado.mie.jp","taiki.mie.jp","taki.mie.jp","tamaki.mie.jp","toba.mie.jp","tsu.mie.jp","udono.mie.jp","ureshino.mie.jp","watarai.mie.jp","yokkaichi.mie.jp","furukawa.miyagi.jp","higashimatsushima.miyagi.jp","ishinomaki.miyagi.jp","iwanuma.miyagi.jp","kakuda.miyagi.jp","kami.miyagi.jp","kawasaki.miyagi.jp","marumori.miyagi.jp","matsushima.miyagi.jp","minamisanriku.miyagi.jp","misato.miyagi.jp","murata.miyagi.jp","natori.miyagi.jp","ogawara.miyagi.jp","ohira.miyagi.jp","onagawa.miyagi.jp","osaki.miyagi.jp","rifu.miyagi.jp","semine.miyagi.jp","shibata.miyagi.jp","shichikashuku.miyagi.jp","shikama.miyagi.jp","shiogama.miyagi.jp","shiroishi.miyagi.jp","tagajo.miyagi.jp","taiwa.miyagi.jp","tome.miyagi.jp","tomiya.miyagi.jp","wakuya.miyagi.jp","watari.miyagi.jp","yamamoto.miyagi.jp","zao.miyagi.jp","aya.miyazaki.jp","ebino.miyazaki.jp","gokase.miyazaki.jp","hyuga.miyazaki.jp","kadogawa.miyazaki.jp","kawaminami.miyazaki.jp","kijo.miyazaki.jp","kitagawa.miyazaki.jp","kitakata.miyazaki.jp","kitaura.miyazaki.jp","kobayashi.miyazaki.jp","kunitomi.miyazaki.jp","kushima.miyazaki.jp","mimata.miyazaki.jp","miyakonojo.miyazaki.jp","miyazaki.miyazaki.jp","morotsuka.miyazaki.jp","nichinan.miyazaki.jp","nishimera.miyazaki.jp","nobeoka.miyazaki.jp","saito.miyazaki.jp","shiiba.miyazaki.jp","shintomi.miyazaki.jp","takaharu.miyazaki.jp","takanabe.miyazaki.jp","takazaki.miyazaki.jp","tsuno.miyazaki.jp","achi.nagano.jp","agematsu.nagano.jp","anan.nagano.jp","aoki.nagano.jp","asahi.nagano.jp","azumino.nagano.jp","chikuhoku.nagano.jp","chikuma.nagano.jp","chino.nagano.jp","fujimi.nagano.jp","hakuba.nagano.jp","hara.nagano.jp","hiraya.nagano.jp","iida.nagano.jp","iijima.nagano.jp","iiyama.nagano.jp","iizuna.nagano.jp","ikeda.nagano.jp","ikusaka.nagano.jp","ina.nagano.jp","karuizawa.nagano.jp","kawakami.nagano.jp","kiso.nagano.jp","kisofukushima.nagano.jp","kitaaiki.nagano.jp","komagane.nagano.jp","komoro.nagano.jp","matsukawa.nagano.jp","matsumoto.nagano.jp","miasa.nagano.jp","minamiaiki.nagano.jp","minamimaki.nagano.jp","minamiminowa.nagano.jp","minowa.nagano.jp","miyada.nagano.jp","miyota.nagano.jp","mochizuki.nagano.jp","nagano.nagano.jp","nagawa.nagano.jp","nagiso.nagano.jp","nakagawa.nagano.jp","nakano.nagano.jp","nozawaonsen.nagano.jp","obuse.nagano.jp","ogawa.nagano.jp","okaya.nagano.jp","omachi.nagano.jp","omi.nagano.jp","ookuwa.nagano.jp","ooshika.nagano.jp","otaki.nagano.jp","otari.nagano.jp","sakae.nagano.jp","sakaki.nagano.jp","saku.nagano.jp","sakuho.nagano.jp","shimosuwa.nagano.jp","shinanomachi.nagano.jp","shiojiri.nagano.jp","suwa.nagano.jp","suzaka.nagano.jp","takagi.nagano.jp","takamori.nagano.jp","takayama.nagano.jp","tateshina.nagano.jp","tatsuno.nagano.jp","togakushi.nagano.jp","togura.nagano.jp","tomi.nagano.jp","ueda.nagano.jp","wada.nagano.jp","yamagata.nagano.jp","yamanouchi.nagano.jp","yasaka.nagano.jp","yasuoka.nagano.jp","chijiwa.nagasaki.jp","futsu.nagasaki.jp","goto.nagasaki.jp","hasami.nagasaki.jp","hirado.nagasaki.jp","iki.nagasaki.jp","isahaya.nagasaki.jp","kawatana.nagasaki.jp","kuchinotsu.nagasaki.jp","matsuura.nagasaki.jp","nagasaki.nagasaki.jp","obama.nagasaki.jp","omura.nagasaki.jp","oseto.nagasaki.jp","saikai.nagasaki.jp","sasebo.nagasaki.jp","seihi.nagasaki.jp","shimabara.nagasaki.jp","shinkamigoto.nagasaki.jp","togitsu.nagasaki.jp","tsushima.nagasaki.jp","unzen.nagasaki.jp","ando.nara.jp","gose.nara.jp","heguri.nara.jp","higashiyoshino.nara.jp","ikaruga.nara.jp","ikoma.nara.jp","kamikitayama.nara.jp","kanmaki.nara.jp","kashiba.nara.jp","kashihara.nara.jp","katsuragi.nara.jp","kawai.nara.jp","kawakami.nara.jp","kawanishi.nara.jp","koryo.nara.jp","kurotaki.nara.jp","mitsue.nara.jp","miyake.nara.jp","nara.nara.jp","nosegawa.nara.jp","oji.nara.jp","ouda.nara.jp","oyodo.nara.jp","sakurai.nara.jp","sango.nara.jp","shimoichi.nara.jp","shimokitayama.nara.jp","shinjo.nara.jp","soni.nara.jp","takatori.nara.jp","tawaramoto.nara.jp","tenkawa.nara.jp","tenri.nara.jp","uda.nara.jp","yamatokoriyama.nara.jp","yamatotakada.nara.jp","yamazoe.nara.jp","yoshino.nara.jp","aga.niigata.jp","agano.niigata.jp","gosen.niigata.jp","itoigawa.niigata.jp","izumozaki.niigata.jp","joetsu.niigata.jp","kamo.niigata.jp","kariwa.niigata.jp","kashiwazaki.niigata.jp","minamiuonuma.niigata.jp","mitsuke.niigata.jp","muika.niigata.jp","murakami.niigata.jp","myoko.niigata.jp","nagaoka.niigata.jp","niigata.niigata.jp","ojiya.niigata.jp","omi.niigata.jp","sado.niigata.jp","sanjo.niigata.jp","seiro.niigata.jp","seirou.niigata.jp","sekikawa.niigata.jp","shibata.niigata.jp","tagami.niigata.jp","tainai.niigata.jp","tochio.niigata.jp","tokamachi.niigata.jp","tsubame.niigata.jp","tsunan.niigata.jp","uonuma.niigata.jp","yahiko.niigata.jp","yoita.niigata.jp","yuzawa.niigata.jp","beppu.oita.jp","bungoono.oita.jp","bungotakada.oita.jp","hasama.oita.jp","hiji.oita.jp","himeshima.oita.jp","hita.oita.jp","kamitsue.oita.jp","kokonoe.oita.jp","kuju.oita.jp","kunisaki.oita.jp","kusu.oita.jp","oita.oita.jp","saiki.oita.jp","taketa.oita.jp","tsukumi.oita.jp","usa.oita.jp","usuki.oita.jp","yufu.oita.jp","akaiwa.okayama.jp","asakuchi.okayama.jp","bizen.okayama.jp","hayashima.okayama.jp","ibara.okayama.jp","kagamino.okayama.jp","kasaoka.okayama.jp","kibichuo.okayama.jp","kumenan.okayama.jp","kurashiki.okayama.jp","maniwa.okayama.jp","misaki.okayama.jp","nagi.okayama.jp","niimi.okayama.jp","nishiawakura.okayama.jp","okayama.okayama.jp","satosho.okayama.jp","setouchi.okayama.jp","shinjo.okayama.jp","shoo.okayama.jp","soja.okayama.jp","takahashi.okayama.jp","tamano.okayama.jp","tsuyama.okayama.jp","wake.okayama.jp","yakage.okayama.jp","aguni.okinawa.jp","ginowan.okinawa.jp","ginoza.okinawa.jp","gushikami.okinawa.jp","haebaru.okinawa.jp","higashi.okinawa.jp","hirara.okinawa.jp","iheya.okinawa.jp","ishigaki.okinawa.jp","ishikawa.okinawa.jp","itoman.okinawa.jp","izena.okinawa.jp","kadena.okinawa.jp","kin.okinawa.jp","kitadaito.okinawa.jp","kitanakagusuku.okinawa.jp","kumejima.okinawa.jp","kunigami.okinawa.jp","minamidaito.okinawa.jp","motobu.okinawa.jp","nago.okinawa.jp","naha.okinawa.jp","nakagusuku.okinawa.jp","nakijin.okinawa.jp","nanjo.okinawa.jp","nishihara.okinawa.jp","ogimi.okinawa.jp","okinawa.okinawa.jp","onna.okinawa.jp","shimoji.okinawa.jp","taketomi.okinawa.jp","tarama.okinawa.jp","tokashiki.okinawa.jp","tomigusuku.okinawa.jp","tonaki.okinawa.jp","urasoe.okinawa.jp","uruma.okinawa.jp","yaese.okinawa.jp","yomitan.okinawa.jp","yonabaru.okinawa.jp","yonaguni.okinawa.jp","zamami.okinawa.jp","abeno.osaka.jp","chihayaakasaka.osaka.jp","chuo.osaka.jp","daito.osaka.jp","fujiidera.osaka.jp","habikino.osaka.jp","hannan.osaka.jp","higashiosaka.osaka.jp","higashisumiyoshi.osaka.jp","higashiyodogawa.osaka.jp","hirakata.osaka.jp","ibaraki.osaka.jp","ikeda.osaka.jp","izumi.osaka.jp","izumiotsu.osaka.jp","izumisano.osaka.jp","kadoma.osaka.jp","kaizuka.osaka.jp","kanan.osaka.jp","kashiwara.osaka.jp","katano.osaka.jp","kawachinagano.osaka.jp","kishiwada.osaka.jp","kita.osaka.jp","kumatori.osaka.jp","matsubara.osaka.jp","minato.osaka.jp","minoh.osaka.jp","misaki.osaka.jp","moriguchi.osaka.jp","neyagawa.osaka.jp","nishi.osaka.jp","nose.osaka.jp","osakasayama.osaka.jp","sakai.osaka.jp","sayama.osaka.jp","sennan.osaka.jp","settsu.osaka.jp","shijonawate.osaka.jp","shimamoto.osaka.jp","suita.osaka.jp","tadaoka.osaka.jp","taishi.osaka.jp","tajiri.osaka.jp","takaishi.osaka.jp","takatsuki.osaka.jp","tondabayashi.osaka.jp","toyonaka.osaka.jp","toyono.osaka.jp","yao.osaka.jp","ariake.saga.jp","arita.saga.jp","fukudomi.saga.jp","genkai.saga.jp","hamatama.saga.jp","hizen.saga.jp","imari.saga.jp","kamimine.saga.jp","kanzaki.saga.jp","karatsu.saga.jp","kashima.saga.jp","kitagata.saga.jp","kitahata.saga.jp","kiyama.saga.jp","kouhoku.saga.jp","kyuragi.saga.jp","nishiarita.saga.jp","ogi.saga.jp","omachi.saga.jp","ouchi.saga.jp","saga.saga.jp","shiroishi.saga.jp","taku.saga.jp","tara.saga.jp","tosu.saga.jp","yoshinogari.saga.jp","arakawa.saitama.jp","asaka.saitama.jp","chichibu.saitama.jp","fujimi.saitama.jp","fujimino.saitama.jp","fukaya.saitama.jp","hanno.saitama.jp","hanyu.saitama.jp","hasuda.saitama.jp","hatogaya.saitama.jp","hatoyama.saitama.jp","hidaka.saitama.jp","higashichichibu.saitama.jp","higashimatsuyama.saitama.jp","honjo.saitama.jp","ina.saitama.jp","iruma.saitama.jp","iwatsuki.saitama.jp","kamiizumi.saitama.jp","kamikawa.saitama.jp","kamisato.saitama.jp","kasukabe.saitama.jp","kawagoe.saitama.jp","kawaguchi.saitama.jp","kawajima.saitama.jp","kazo.saitama.jp","kitamoto.saitama.jp","koshigaya.saitama.jp","kounosu.saitama.jp","kuki.saitama.jp","kumagaya.saitama.jp","matsubushi.saitama.jp","minano.saitama.jp","misato.saitama.jp","miyashiro.saitama.jp","miyoshi.saitama.jp","moroyama.saitama.jp","nagatoro.saitama.jp","namegawa.saitama.jp","niiza.saitama.jp","ogano.saitama.jp","ogawa.saitama.jp","ogose.saitama.jp","okegawa.saitama.jp","omiya.saitama.jp","otaki.saitama.jp","ranzan.saitama.jp","ryokami.saitama.jp","saitama.saitama.jp","sakado.saitama.jp","satte.saitama.jp","sayama.saitama.jp","shiki.saitama.jp","shiraoka.saitama.jp","soka.saitama.jp","sugito.saitama.jp","toda.saitama.jp","tokigawa.saitama.jp","tokorozawa.saitama.jp","tsurugashima.saitama.jp","urawa.saitama.jp","warabi.saitama.jp","yashio.saitama.jp","yokoze.saitama.jp","yono.saitama.jp","yorii.saitama.jp","yoshida.saitama.jp","yoshikawa.saitama.jp","yoshimi.saitama.jp","aisho.shiga.jp","gamo.shiga.jp","higashiomi.shiga.jp","hikone.shiga.jp","koka.shiga.jp","konan.shiga.jp","kosei.shiga.jp","koto.shiga.jp","kusatsu.shiga.jp","maibara.shiga.jp","moriyama.shiga.jp","nagahama.shiga.jp","nishiazai.shiga.jp","notogawa.shiga.jp","omihachiman.shiga.jp","otsu.shiga.jp","ritto.shiga.jp","ryuoh.shiga.jp","takashima.shiga.jp","takatsuki.shiga.jp","torahime.shiga.jp","toyosato.shiga.jp","yasu.shiga.jp","akagi.shimane.jp","ama.shimane.jp","gotsu.shimane.jp","hamada.shimane.jp","higashiizumo.shimane.jp","hikawa.shimane.jp","hikimi.shimane.jp","izumo.shimane.jp","kakinoki.shimane.jp","masuda.shimane.jp","matsue.shimane.jp","misato.shimane.jp","nishinoshima.shimane.jp","ohda.shimane.jp","okinoshima.shimane.jp","okuizumo.shimane.jp","shimane.shimane.jp","tamayu.shimane.jp","tsuwano.shimane.jp","unnan.shimane.jp","yakumo.shimane.jp","yasugi.shimane.jp","yatsuka.shimane.jp","arai.shizuoka.jp","atami.shizuoka.jp","fuji.shizuoka.jp","fujieda.shizuoka.jp","fujikawa.shizuoka.jp","fujinomiya.shizuoka.jp","fukuroi.shizuoka.jp","gotemba.shizuoka.jp","haibara.shizuoka.jp","hamamatsu.shizuoka.jp","higashiizu.shizuoka.jp","ito.shizuoka.jp","iwata.shizuoka.jp","izu.shizuoka.jp","izunokuni.shizuoka.jp","kakegawa.shizuoka.jp","kannami.shizuoka.jp","kawanehon.shizuoka.jp","kawazu.shizuoka.jp","kikugawa.shizuoka.jp","kosai.shizuoka.jp","makinohara.shizuoka.jp","matsuzaki.shizuoka.jp","minamiizu.shizuoka.jp","mishima.shizuoka.jp","morimachi.shizuoka.jp","nishiizu.shizuoka.jp","numazu.shizuoka.jp","omaezaki.shizuoka.jp","shimada.shizuoka.jp","shimizu.shizuoka.jp","shimoda.shizuoka.jp","shizuoka.shizuoka.jp","susono.shizuoka.jp","yaizu.shizuoka.jp","yoshida.shizuoka.jp","ashikaga.tochigi.jp","bato.tochigi.jp","haga.tochigi.jp","ichikai.tochigi.jp","iwafune.tochigi.jp","kaminokawa.tochigi.jp","kanuma.tochigi.jp","karasuyama.tochigi.jp","kuroiso.tochigi.jp","mashiko.tochigi.jp","mibu.tochigi.jp","moka.tochigi.jp","motegi.tochigi.jp","nasu.tochigi.jp","nasushiobara.tochigi.jp","nikko.tochigi.jp","nishikata.tochigi.jp","nogi.tochigi.jp","ohira.tochigi.jp","ohtawara.tochigi.jp","oyama.tochigi.jp","sakura.tochigi.jp","sano.tochigi.jp","shimotsuke.tochigi.jp","shioya.tochigi.jp","takanezawa.tochigi.jp","tochigi.tochigi.jp","tsuga.tochigi.jp","ujiie.tochigi.jp","utsunomiya.tochigi.jp","yaita.tochigi.jp","aizumi.tokushima.jp","anan.tokushima.jp","ichiba.tokushima.jp","itano.tokushima.jp","kainan.tokushima.jp","komatsushima.tokushima.jp","matsushige.tokushima.jp","mima.tokushima.jp","minami.tokushima.jp","miyoshi.tokushima.jp","mugi.tokushima.jp","nakagawa.tokushima.jp","naruto.tokushima.jp","sanagochi.tokushima.jp","shishikui.tokushima.jp","tokushima.tokushima.jp","wajiki.tokushima.jp","adachi.tokyo.jp","akiruno.tokyo.jp","akishima.tokyo.jp","aogashima.tokyo.jp","arakawa.tokyo.jp","bunkyo.tokyo.jp","chiyoda.tokyo.jp","chofu.tokyo.jp","chuo.tokyo.jp","edogawa.tokyo.jp","fuchu.tokyo.jp","fussa.tokyo.jp","hachijo.tokyo.jp","hachioji.tokyo.jp","hamura.tokyo.jp","higashikurume.tokyo.jp","higashimurayama.tokyo.jp","higashiyamato.tokyo.jp","hino.tokyo.jp","hinode.tokyo.jp","hinohara.tokyo.jp","inagi.tokyo.jp","itabashi.tokyo.jp","katsushika.tokyo.jp","kita.tokyo.jp","kiyose.tokyo.jp","kodaira.tokyo.jp","koganei.tokyo.jp","kokubunji.tokyo.jp","komae.tokyo.jp","koto.tokyo.jp","kouzushima.tokyo.jp","kunitachi.tokyo.jp","machida.tokyo.jp","meguro.tokyo.jp","minato.tokyo.jp","mitaka.tokyo.jp","mizuho.tokyo.jp","musashimurayama.tokyo.jp","musashino.tokyo.jp","nakano.tokyo.jp","nerima.tokyo.jp","ogasawara.tokyo.jp","okutama.tokyo.jp","ome.tokyo.jp","oshima.tokyo.jp","ota.tokyo.jp","setagaya.tokyo.jp","shibuya.tokyo.jp","shinagawa.tokyo.jp","shinjuku.tokyo.jp","suginami.tokyo.jp","sumida.tokyo.jp","tachikawa.tokyo.jp","taito.tokyo.jp","tama.tokyo.jp","toshima.tokyo.jp","chizu.tottori.jp","hino.tottori.jp","kawahara.tottori.jp","koge.tottori.jp","kotoura.tottori.jp","misasa.tottori.jp","nanbu.tottori.jp","nichinan.tottori.jp","sakaiminato.tottori.jp","tottori.tottori.jp","wakasa.tottori.jp","yazu.tottori.jp","yonago.tottori.jp","asahi.toyama.jp","fuchu.toyama.jp","fukumitsu.toyama.jp","funahashi.toyama.jp","himi.toyama.jp","imizu.toyama.jp","inami.toyama.jp","johana.toyama.jp","kamiichi.toyama.jp","kurobe.toyama.jp","nakaniikawa.toyama.jp","namerikawa.toyama.jp","nanto.toyama.jp","nyuzen.toyama.jp","oyabe.toyama.jp","taira.toyama.jp","takaoka.toyama.jp","tateyama.toyama.jp","toga.toyama.jp","tonami.toyama.jp","toyama.toyama.jp","unazuki.toyama.jp","uozu.toyama.jp","yamada.toyama.jp","arida.wakayama.jp","aridagawa.wakayama.jp","gobo.wakayama.jp","hashimoto.wakayama.jp","hidaka.wakayama.jp","hirogawa.wakayama.jp","inami.wakayama.jp","iwade.wakayama.jp","kainan.wakayama.jp","kamitonda.wakayama.jp","katsuragi.wakayama.jp","kimino.wakayama.jp","kinokawa.wakayama.jp","kitayama.wakayama.jp","koya.wakayama.jp","koza.wakayama.jp","kozagawa.wakayama.jp","kudoyama.wakayama.jp","kushimoto.wakayama.jp","mihama.wakayama.jp","misato.wakayama.jp","nachikatsuura.wakayama.jp","shingu.wakayama.jp","shirahama.wakayama.jp","taiji.wakayama.jp","tanabe.wakayama.jp","wakayama.wakayama.jp","yuasa.wakayama.jp","yura.wakayama.jp","asahi.yamagata.jp","funagata.yamagata.jp","higashine.yamagata.jp","iide.yamagata.jp","kahoku.yamagata.jp","kaminoyama.yamagata.jp","kaneyama.yamagata.jp","kawanishi.yamagata.jp","mamurogawa.yamagata.jp","mikawa.yamagata.jp","murayama.yamagata.jp","nagai.yamagata.jp","nakayama.yamagata.jp","nanyo.yamagata.jp","nishikawa.yamagata.jp","obanazawa.yamagata.jp","oe.yamagata.jp","oguni.yamagata.jp","ohkura.yamagata.jp","oishida.yamagata.jp","sagae.yamagata.jp","sakata.yamagata.jp","sakegawa.yamagata.jp","shinjo.yamagata.jp","shirataka.yamagata.jp","shonai.yamagata.jp","takahata.yamagata.jp","tendo.yamagata.jp","tozawa.yamagata.jp","tsuruoka.yamagata.jp","yamagata.yamagata.jp","yamanobe.yamagata.jp","yonezawa.yamagata.jp","yuza.yamagata.jp","abu.yamaguchi.jp","hagi.yamaguchi.jp","hikari.yamaguchi.jp","hofu.yamaguchi.jp","iwakuni.yamaguchi.jp","kudamatsu.yamaguchi.jp","mitou.yamaguchi.jp","nagato.yamaguchi.jp","oshima.yamaguchi.jp","shimonoseki.yamaguchi.jp","shunan.yamaguchi.jp","tabuse.yamaguchi.jp","tokuyama.yamaguchi.jp","toyota.yamaguchi.jp","ube.yamaguchi.jp","yuu.yamaguchi.jp","chuo.yamanashi.jp","doshi.yamanashi.jp","fuefuki.yamanashi.jp","fujikawa.yamanashi.jp","fujikawaguchiko.yamanashi.jp","fujiyoshida.yamanashi.jp","hayakawa.yamanashi.jp","hokuto.yamanashi.jp","ichikawamisato.yamanashi.jp","kai.yamanashi.jp","kofu.yamanashi.jp","koshu.yamanashi.jp","kosuge.yamanashi.jp","minami-alps.yamanashi.jp","minobu.yamanashi.jp","nakamichi.yamanashi.jp","nanbu.yamanashi.jp","narusawa.yamanashi.jp","nirasaki.yamanashi.jp","nishikatsura.yamanashi.jp","oshino.yamanashi.jp","otsuki.yamanashi.jp","showa.yamanashi.jp","tabayama.yamanashi.jp","tsuru.yamanashi.jp","uenohara.yamanashi.jp","yamanakako.yamanashi.jp","yamanashi.yamanashi.jp","ke","ac.ke","co.ke","go.ke","info.ke","me.ke","mobi.ke","ne.ke","or.ke","sc.ke","kg","com.kg","edu.kg","gov.kg","mil.kg","net.kg","org.kg","*.kh","ki","biz.ki","com.ki","edu.ki","gov.ki","info.ki","net.ki","org.ki","km","ass.km","com.km","edu.km","gov.km","mil.km","nom.km","org.km","prd.km","tm.km","asso.km","coop.km","gouv.km","medecin.km","notaires.km","pharmaciens.km","presse.km","veterinaire.km","kn","edu.kn","gov.kn","net.kn","org.kn","kp","com.kp","edu.kp","gov.kp","org.kp","rep.kp","tra.kp","kr","ac.kr","co.kr","es.kr","go.kr","hs.kr","kg.kr","mil.kr","ms.kr","ne.kr","or.kr","pe.kr","re.kr","sc.kr","busan.kr","chungbuk.kr","chungnam.kr","daegu.kr","daejeon.kr","gangwon.kr","gwangju.kr","gyeongbuk.kr","gyeonggi.kr","gyeongnam.kr","incheon.kr","jeju.kr","jeonbuk.kr","jeonnam.kr","seoul.kr","ulsan.kr","kw","com.kw","edu.kw","emb.kw","gov.kw","ind.kw","net.kw","org.kw","ky","com.ky","edu.ky","net.ky","org.ky","kz","com.kz","edu.kz","gov.kz","mil.kz","net.kz","org.kz","la","com.la","edu.la","gov.la","info.la","int.la","net.la","org.la","per.la","lb","com.lb","edu.lb","gov.lb","net.lb","org.lb","lc","co.lc","com.lc","edu.lc","gov.lc","net.lc","org.lc","li","lk","ac.lk","assn.lk","com.lk","edu.lk","gov.lk","grp.lk","hotel.lk","int.lk","ltd.lk","net.lk","ngo.lk","org.lk","sch.lk","soc.lk","web.lk","lr","com.lr","edu.lr","gov.lr","net.lr","org.lr","ls","ac.ls","biz.ls","co.ls","edu.ls","gov.ls","info.ls","net.ls","org.ls","sc.ls","lt","gov.lt","lu","lv","asn.lv","com.lv","conf.lv","edu.lv","gov.lv","id.lv","mil.lv","net.lv","org.lv","ly","com.ly","edu.ly","gov.ly","id.ly","med.ly","net.ly","org.ly","plc.ly","sch.ly","ma","ac.ma","co.ma","gov.ma","net.ma","org.ma","press.ma","mc","asso.mc","tm.mc","md","me","ac.me","co.me","edu.me","gov.me","its.me","net.me","org.me","priv.me","mg","co.mg","com.mg","edu.mg","gov.mg","mil.mg","nom.mg","org.mg","prd.mg","mh","mil","mk","com.mk","edu.mk","gov.mk","inf.mk","name.mk","net.mk","org.mk","ml","com.ml","edu.ml","gouv.ml","gov.ml","net.ml","org.ml","presse.ml","*.mm","mn","edu.mn","gov.mn","org.mn","mo","com.mo","edu.mo","gov.mo","net.mo","org.mo","mobi","mp","mq","mr","gov.mr","ms","com.ms","edu.ms","gov.ms","net.ms","org.ms","mt","com.mt","edu.mt","net.mt","org.mt","mu","ac.mu","co.mu","com.mu","gov.mu","net.mu","or.mu","org.mu","museum","mv","aero.mv","biz.mv","com.mv","coop.mv","edu.mv","gov.mv","info.mv","int.mv","mil.mv","museum.mv","name.mv","net.mv","org.mv","pro.mv","mw","ac.mw","biz.mw","co.mw","com.mw","coop.mw","edu.mw","gov.mw","int.mw","net.mw","org.mw","mx","com.mx","edu.mx","gob.mx","net.mx","org.mx","my","biz.my","com.my","edu.my","gov.my","mil.my","name.my","net.my","org.my","mz","ac.mz","adv.mz","co.mz","edu.mz","gov.mz","mil.mz","net.mz","org.mz","na","alt.na","co.na","com.na","gov.na","net.na","org.na","name","nc","asso.nc","nom.nc","ne","net","nf","arts.nf","com.nf","firm.nf","info.nf","net.nf","other.nf","per.nf","rec.nf","store.nf","web.nf","ng","com.ng","edu.ng","gov.ng","i.ng","mil.ng","mobi.ng","name.ng","net.ng","org.ng","sch.ng","ni","ac.ni","biz.ni","co.ni","com.ni","edu.ni","gob.ni","in.ni","info.ni","int.ni","mil.ni","net.ni","nom.ni","org.ni","web.ni","nl","no","fhs.no","folkebibl.no","fylkesbibl.no","idrett.no","museum.no","priv.no","vgs.no","dep.no","herad.no","kommune.no","mil.no","stat.no","aa.no","ah.no","bu.no","fm.no","hl.no","hm.no","jan-mayen.no","mr.no","nl.no","nt.no","of.no","ol.no","oslo.no","rl.no","sf.no","st.no","svalbard.no","tm.no","tr.no","va.no","vf.no","gs.aa.no","gs.ah.no","gs.bu.no","gs.fm.no","gs.hl.no","gs.hm.no","gs.jan-mayen.no","gs.mr.no","gs.nl.no","gs.nt.no","gs.of.no","gs.ol.no","gs.oslo.no","gs.rl.no","gs.sf.no","gs.st.no","gs.svalbard.no","gs.tm.no","gs.tr.no","gs.va.no","gs.vf.no","akrehamn.no","åkrehamn.no","algard.no","ålgård.no","arna.no","bronnoysund.no","brønnøysund.no","brumunddal.no","bryne.no","drobak.no","drøbak.no","egersund.no","fetsund.no","floro.no","florø.no","fredrikstad.no","hokksund.no","honefoss.no","hønefoss.no","jessheim.no","jorpeland.no","jørpeland.no","kirkenes.no","kopervik.no","krokstadelva.no","langevag.no","langevåg.no","leirvik.no","mjondalen.no","mjøndalen.no","mo-i-rana.no","mosjoen.no","mosjøen.no","nesoddtangen.no","orkanger.no","osoyro.no","osøyro.no","raholt.no","råholt.no","sandnessjoen.no","sandnessjøen.no","skedsmokorset.no","slattum.no","spjelkavik.no","stathelle.no","stavern.no","stjordalshalsen.no","stjørdalshalsen.no","tananger.no","tranby.no","vossevangen.no","aarborte.no","aejrie.no","afjord.no","åfjord.no","agdenes.no","nes.akershus.no","aknoluokta.no","ákŋoluokta.no","al.no","ål.no","alaheadju.no","álaheadju.no","alesund.no","ålesund.no","alstahaug.no","alta.no","áltá.no","alvdal.no","amli.no","åmli.no","amot.no","åmot.no","andasuolo.no","andebu.no","andoy.no","andøy.no","ardal.no","årdal.no","aremark.no","arendal.no","ås.no","aseral.no","åseral.no","asker.no","askim.no","askoy.no","askøy.no","askvoll.no","asnes.no","åsnes.no","audnedaln.no","aukra.no","aure.no","aurland.no","aurskog-holand.no","aurskog-høland.no","austevoll.no","austrheim.no","averoy.no","averøy.no","badaddja.no","bådåddjå.no","bærum.no","bahcavuotna.no","báhcavuotna.no","bahccavuotna.no","báhccavuotna.no","baidar.no","báidár.no","bajddar.no","bájddar.no","balat.no","bálát.no","balestrand.no","ballangen.no","balsfjord.no","bamble.no","bardu.no","barum.no","batsfjord.no","båtsfjord.no","bearalvahki.no","bearalváhki.no","beardu.no","beiarn.no","berg.no","bergen.no","berlevag.no","berlevåg.no","bievat.no","bievát.no","bindal.no","birkenes.no","bjarkoy.no","bjarkøy.no","bjerkreim.no","bjugn.no","bodo.no","bodø.no","bokn.no","bomlo.no","bømlo.no","bremanger.no","bronnoy.no","brønnøy.no","budejju.no","nes.buskerud.no","bygland.no","bykle.no","cahcesuolo.no","čáhcesuolo.no","davvenjarga.no","davvenjárga.no","davvesiida.no","deatnu.no","dielddanuorri.no","divtasvuodna.no","divttasvuotna.no","donna.no","dønna.no","dovre.no","drammen.no","drangedal.no","dyroy.no","dyrøy.no","eid.no","eidfjord.no","eidsberg.no","eidskog.no","eidsvoll.no","eigersund.no","elverum.no","enebakk.no","engerdal.no","etne.no","etnedal.no","evenassi.no","evenášši.no","evenes.no","evje-og-hornnes.no","farsund.no","fauske.no","fedje.no","fet.no","finnoy.no","finnøy.no","fitjar.no","fjaler.no","fjell.no","fla.no","flå.no","flakstad.no","flatanger.no","flekkefjord.no","flesberg.no","flora.no","folldal.no","forde.no","førde.no","forsand.no","fosnes.no","fræna.no","frana.no","frei.no","frogn.no","froland.no","frosta.no","froya.no","frøya.no","fuoisku.no","fuossko.no","fusa.no","fyresdal.no","gaivuotna.no","gáivuotna.no","galsa.no","gálsá.no","gamvik.no","gangaviika.no","gáŋgaviika.no","gaular.no","gausdal.no","giehtavuoatna.no","gildeskal.no","gildeskål.no","giske.no","gjemnes.no","gjerdrum.no","gjerstad.no","gjesdal.no","gjovik.no","gjøvik.no","gloppen.no","gol.no","gran.no","grane.no","granvin.no","gratangen.no","grimstad.no","grong.no","grue.no","gulen.no","guovdageaidnu.no","ha.no","hå.no","habmer.no","hábmer.no","hadsel.no","hægebostad.no","hagebostad.no","halden.no","halsa.no","hamar.no","hamaroy.no","hammarfeasta.no","hámmárfeasta.no","hammerfest.no","hapmir.no","hápmir.no","haram.no","hareid.no","harstad.no","hasvik.no","hattfjelldal.no","haugesund.no","os.hedmark.no","valer.hedmark.no","våler.hedmark.no","hemne.no","hemnes.no","hemsedal.no","hitra.no","hjartdal.no","hjelmeland.no","hobol.no","hobøl.no","hof.no","hol.no","hole.no","holmestrand.no","holtalen.no","holtålen.no","os.hordaland.no","hornindal.no","horten.no","hoyanger.no","høyanger.no","hoylandet.no","høylandet.no","hurdal.no","hurum.no","hvaler.no","hyllestad.no","ibestad.no","inderoy.no","inderøy.no","iveland.no","ivgu.no","jevnaker.no","jolster.no","jølster.no","jondal.no","kafjord.no","kåfjord.no","karasjohka.no","kárášjohka.no","karasjok.no","karlsoy.no","karmoy.no","karmøy.no","kautokeino.no","klabu.no","klæbu.no","klepp.no","kongsberg.no","kongsvinger.no","kraanghke.no","kråanghke.no","kragero.no","kragerø.no","kristiansand.no","kristiansund.no","krodsherad.no","krødsherad.no","kvæfjord.no","kvænangen.no","kvafjord.no","kvalsund.no","kvam.no","kvanangen.no","kvinesdal.no","kvinnherad.no","kviteseid.no","kvitsoy.no","kvitsøy.no","laakesvuemie.no","lærdal.no","lahppi.no","láhppi.no","lardal.no","larvik.no","lavagis.no","lavangen.no","leangaviika.no","leaŋgaviika.no","lebesby.no","leikanger.no","leirfjord.no","leka.no","leksvik.no","lenvik.no","lerdal.no","lesja.no","levanger.no","lier.no","lierne.no","lillehammer.no","lillesand.no","lindas.no","lindås.no","lindesnes.no","loabat.no","loabát.no","lodingen.no","lødingen.no","lom.no","loppa.no","lorenskog.no","lørenskog.no","loten.no","løten.no","lund.no","lunner.no","luroy.no","lurøy.no","luster.no","lyngdal.no","lyngen.no","malatvuopmi.no","málatvuopmi.no","malselv.no","målselv.no","malvik.no","mandal.no","marker.no","marnardal.no","masfjorden.no","masoy.no","måsøy.no","matta-varjjat.no","mátta-várjjat.no","meland.no","meldal.no","melhus.no","meloy.no","meløy.no","meraker.no","meråker.no","midsund.no","midtre-gauldal.no","moareke.no","moåreke.no","modalen.no","modum.no","molde.no","heroy.more-og-romsdal.no","sande.more-og-romsdal.no","herøy.møre-og-romsdal.no","sande.møre-og-romsdal.no","moskenes.no","moss.no","mosvik.no","muosat.no","muosát.no","naamesjevuemie.no","nååmesjevuemie.no","nærøy.no","namdalseid.no","namsos.no","namsskogan.no","nannestad.no","naroy.no","narviika.no","narvik.no","naustdal.no","navuotna.no","návuotna.no","nedre-eiker.no","nesna.no","nesodden.no","nesseby.no","nesset.no","nissedal.no","nittedal.no","nord-aurdal.no","nord-fron.no","nord-odal.no","norddal.no","nordkapp.no","bo.nordland.no","bø.nordland.no","heroy.nordland.no","herøy.nordland.no","nordre-land.no","nordreisa.no","nore-og-uvdal.no","notodden.no","notteroy.no","nøtterøy.no","odda.no","oksnes.no","øksnes.no","omasvuotna.no","oppdal.no","oppegard.no","oppegård.no","orkdal.no","orland.no","ørland.no","orskog.no","ørskog.no","orsta.no","ørsta.no","osen.no","osteroy.no","osterøy.no","valer.ostfold.no","våler.østfold.no","ostre-toten.no","østre-toten.no","overhalla.no","ovre-eiker.no","øvre-eiker.no","oyer.no","øyer.no","oygarden.no","øygarden.no","oystre-slidre.no","øystre-slidre.no","porsanger.no","porsangu.no","porsáŋgu.no","porsgrunn.no","rade.no","råde.no","radoy.no","radøy.no","rælingen.no","rahkkeravju.no","ráhkkerávju.no","raisa.no","ráisa.no","rakkestad.no","ralingen.no","rana.no","randaberg.no","rauma.no","rendalen.no","rennebu.no","rennesoy.no","rennesøy.no","rindal.no","ringebu.no","ringerike.no","ringsaker.no","risor.no","risør.no","rissa.no","roan.no","rodoy.no","rødøy.no","rollag.no","romsa.no","romskog.no","rømskog.no","roros.no","røros.no","rost.no","røst.no","royken.no","røyken.no","royrvik.no","røyrvik.no","ruovat.no","rygge.no","salangen.no","salat.no","sálat.no","sálát.no","saltdal.no","samnanger.no","sandefjord.no","sandnes.no","sandoy.no","sandøy.no","sarpsborg.no","sauda.no","sauherad.no","sel.no","selbu.no","selje.no","seljord.no","siellak.no","sigdal.no","siljan.no","sirdal.no","skanit.no","skánit.no","skanland.no","skånland.no","skaun.no","skedsmo.no","ski.no","skien.no","skierva.no","skiervá.no","skiptvet.no","skjak.no","skjåk.no","skjervoy.no","skjervøy.no","skodje.no","smola.no","smøla.no","snaase.no","snåase.no","snasa.no","snåsa.no","snillfjord.no","snoasa.no","sogndal.no","sogne.no","søgne.no","sokndal.no","sola.no","solund.no","somna.no","sømna.no","sondre-land.no","søndre-land.no","songdalen.no","sor-aurdal.no","sør-aurdal.no","sor-fron.no","sør-fron.no","sor-odal.no","sør-odal.no","sor-varanger.no","sør-varanger.no","sorfold.no","sørfold.no","sorreisa.no","sørreisa.no","sortland.no","sorum.no","sørum.no","spydeberg.no","stange.no","stavanger.no","steigen.no","steinkjer.no","stjordal.no","stjørdal.no","stokke.no","stor-elvdal.no","stord.no","stordal.no","storfjord.no","strand.no","stranda.no","stryn.no","sula.no","suldal.no","sund.no","sunndal.no","surnadal.no","sveio.no","svelvik.no","sykkylven.no","tana.no","bo.telemark.no","bø.telemark.no","time.no","tingvoll.no","tinn.no","tjeldsund.no","tjome.no","tjøme.no","tokke.no","tolga.no","tonsberg.no","tønsberg.no","torsken.no","træna.no","trana.no","tranoy.no","tranøy.no","troandin.no","trogstad.no","trøgstad.no","tromsa.no","tromso.no","tromsø.no","trondheim.no","trysil.no","tvedestrand.no","tydal.no","tynset.no","tysfjord.no","tysnes.no","tysvær.no","tysvar.no","ullensaker.no","ullensvang.no","ulvik.no","unjarga.no","unjárga.no","utsira.no","vaapste.no","vadso.no","vadsø.no","værøy.no","vaga.no","vågå.no","vagan.no","vågan.no","vagsoy.no","vågsøy.no","vaksdal.no","valle.no","vang.no","vanylven.no","vardo.no","vardø.no","varggat.no","várggát.no","varoy.no","vefsn.no","vega.no","vegarshei.no","vegårshei.no","vennesla.no","verdal.no","verran.no","vestby.no","sande.vestfold.no","vestnes.no","vestre-slidre.no","vestre-toten.no","vestvagoy.no","vestvågøy.no","vevelstad.no","vik.no","vikna.no","vindafjord.no","voagat.no","volda.no","voss.no","*.np","nr","biz.nr","com.nr","edu.nr","gov.nr","info.nr","net.nr","org.nr","nu","nz","ac.nz","co.nz","cri.nz","geek.nz","gen.nz","govt.nz","health.nz","iwi.nz","kiwi.nz","maori.nz","māori.nz","mil.nz","net.nz","org.nz","parliament.nz","school.nz","om","co.om","com.om","edu.om","gov.om","med.om","museum.om","net.om","org.om","pro.om","onion","org","pa","abo.pa","ac.pa","com.pa","edu.pa","gob.pa","ing.pa","med.pa","net.pa","nom.pa","org.pa","sld.pa","pe","com.pe","edu.pe","gob.pe","mil.pe","net.pe","nom.pe","org.pe","pf","com.pf","edu.pf","org.pf","*.pg","ph","com.ph","edu.ph","gov.ph","i.ph","mil.ph","net.ph","ngo.ph","org.ph","pk","ac.pk","biz.pk","com.pk","edu.pk","fam.pk","gkp.pk","gob.pk","gog.pk","gok.pk","gon.pk","gop.pk","gos.pk","gov.pk","net.pk","org.pk","web.pk","pl","com.pl","net.pl","org.pl","agro.pl","aid.pl","atm.pl","auto.pl","biz.pl","edu.pl","gmina.pl","gsm.pl","info.pl","mail.pl","media.pl","miasta.pl","mil.pl","nieruchomosci.pl","nom.pl","pc.pl","powiat.pl","priv.pl","realestate.pl","rel.pl","sex.pl","shop.pl","sklep.pl","sos.pl","szkola.pl","targi.pl","tm.pl","tourism.pl","travel.pl","turystyka.pl","gov.pl","ap.gov.pl","griw.gov.pl","ic.gov.pl","is.gov.pl","kmpsp.gov.pl","konsulat.gov.pl","kppsp.gov.pl","kwp.gov.pl","kwpsp.gov.pl","mup.gov.pl","mw.gov.pl","oia.gov.pl","oirm.gov.pl","oke.gov.pl","oow.gov.pl","oschr.gov.pl","oum.gov.pl","pa.gov.pl","pinb.gov.pl","piw.gov.pl","po.gov.pl","pr.gov.pl","psp.gov.pl","psse.gov.pl","pup.gov.pl","rzgw.gov.pl","sa.gov.pl","sdn.gov.pl","sko.gov.pl","so.gov.pl","sr.gov.pl","starostwo.gov.pl","ug.gov.pl","ugim.gov.pl","um.gov.pl","umig.gov.pl","upow.gov.pl","uppo.gov.pl","us.gov.pl","uw.gov.pl","uzs.gov.pl","wif.gov.pl","wiih.gov.pl","winb.gov.pl","wios.gov.pl","witd.gov.pl","wiw.gov.pl","wkz.gov.pl","wsa.gov.pl","wskr.gov.pl","wsse.gov.pl","wuoz.gov.pl","wzmiuw.gov.pl","zp.gov.pl","zpisdn.gov.pl","augustow.pl","babia-gora.pl","bedzin.pl","beskidy.pl","bialowieza.pl","bialystok.pl","bielawa.pl","bieszczady.pl","boleslawiec.pl","bydgoszcz.pl","bytom.pl","cieszyn.pl","czeladz.pl","czest.pl","dlugoleka.pl","elblag.pl","elk.pl","glogow.pl","gniezno.pl","gorlice.pl","grajewo.pl","ilawa.pl","jaworzno.pl","jelenia-gora.pl","jgora.pl","kalisz.pl","karpacz.pl","kartuzy.pl","kaszuby.pl","katowice.pl","kazimierz-dolny.pl","kepno.pl","ketrzyn.pl","klodzko.pl","kobierzyce.pl","kolobrzeg.pl","konin.pl","konskowola.pl","kutno.pl","lapy.pl","lebork.pl","legnica.pl","lezajsk.pl","limanowa.pl","lomza.pl","lowicz.pl","lubin.pl","lukow.pl","malbork.pl","malopolska.pl","mazowsze.pl","mazury.pl","mielec.pl","mielno.pl","mragowo.pl","naklo.pl","nowaruda.pl","nysa.pl","olawa.pl","olecko.pl","olkusz.pl","olsztyn.pl","opoczno.pl","opole.pl","ostroda.pl","ostroleka.pl","ostrowiec.pl","ostrowwlkp.pl","pila.pl","pisz.pl","podhale.pl","podlasie.pl","polkowice.pl","pomorskie.pl","pomorze.pl","prochowice.pl","pruszkow.pl","przeworsk.pl","pulawy.pl","radom.pl","rawa-maz.pl","rybnik.pl","rzeszow.pl","sanok.pl","sejny.pl","skoczow.pl","slask.pl","slupsk.pl","sosnowiec.pl","stalowa-wola.pl","starachowice.pl","stargard.pl","suwalki.pl","swidnica.pl","swiebodzin.pl","swinoujscie.pl","szczecin.pl","szczytno.pl","tarnobrzeg.pl","tgory.pl","turek.pl","tychy.pl","ustka.pl","walbrzych.pl","warmia.pl","warszawa.pl","waw.pl","wegrow.pl","wielun.pl","wlocl.pl","wloclawek.pl","wodzislaw.pl","wolomin.pl","wroclaw.pl","zachpomor.pl","zagan.pl","zarow.pl","zgora.pl","zgorzelec.pl","pm","pn","co.pn","edu.pn","gov.pn","net.pn","org.pn","post","pr","biz.pr","com.pr","edu.pr","gov.pr","info.pr","isla.pr","name.pr","net.pr","org.pr","pro.pr","ac.pr","est.pr","prof.pr","pro","aaa.pro","aca.pro","acct.pro","avocat.pro","bar.pro","cpa.pro","eng.pro","jur.pro","law.pro","med.pro","recht.pro","ps","com.ps","edu.ps","gov.ps","net.ps","org.ps","plo.ps","sec.ps","pt","com.pt","edu.pt","gov.pt","int.pt","net.pt","nome.pt","org.pt","publ.pt","pw","belau.pw","co.pw","ed.pw","go.pw","or.pw","py","com.py","coop.py","edu.py","gov.py","mil.py","net.py","org.py","qa","com.qa","edu.qa","gov.qa","mil.qa","name.qa","net.qa","org.qa","sch.qa","re","asso.re","com.re","ro","arts.ro","com.ro","firm.ro","info.ro","nom.ro","nt.ro","org.ro","rec.ro","store.ro","tm.ro","www.ro","rs","ac.rs","co.rs","edu.rs","gov.rs","in.rs","org.rs","ru","rw","ac.rw","co.rw","coop.rw","gov.rw","mil.rw","net.rw","org.rw","sa","com.sa","edu.sa","gov.sa","med.sa","net.sa","org.sa","pub.sa","sch.sa","sb","com.sb","edu.sb","gov.sb","net.sb","org.sb","sc","com.sc","edu.sc","gov.sc","net.sc","org.sc","sd","com.sd","edu.sd","gov.sd","info.sd","med.sd","net.sd","org.sd","tv.sd","se","a.se","ac.se","b.se","bd.se","brand.se","c.se","d.se","e.se","f.se","fh.se","fhsk.se","fhv.se","g.se","h.se","i.se","k.se","komforb.se","kommunalforbund.se","komvux.se","l.se","lanbib.se","m.se","n.se","naturbruksgymn.se","o.se","org.se","p.se","parti.se","pp.se","press.se","r.se","s.se","t.se","tm.se","u.se","w.se","x.se","y.se","z.se","sg","com.sg","edu.sg","gov.sg","net.sg","org.sg","sh","com.sh","gov.sh","mil.sh","net.sh","org.sh","si","sj","sk","sl","com.sl","edu.sl","gov.sl","net.sl","org.sl","sm","sn","art.sn","com.sn","edu.sn","gouv.sn","org.sn","perso.sn","univ.sn","so","com.so","edu.so","gov.so","me.so","net.so","org.so","sr","ss","biz.ss","co.ss","com.ss","edu.ss","gov.ss","me.ss","net.ss","org.ss","sch.ss","st","co.st","com.st","consulado.st","edu.st","embaixada.st","mil.st","net.st","org.st","principe.st","saotome.st","store.st","su","sv","com.sv","edu.sv","gob.sv","org.sv","red.sv","sx","gov.sx","sy","com.sy","edu.sy","gov.sy","mil.sy","net.sy","org.sy","sz","ac.sz","co.sz","org.sz","tc","td","tel","tf","tg","th","ac.th","co.th","go.th","in.th","mi.th","net.th","or.th","tj","ac.tj","biz.tj","co.tj","com.tj","edu.tj","go.tj","gov.tj","int.tj","mil.tj","name.tj","net.tj","nic.tj","org.tj","test.tj","web.tj","tk","tl","gov.tl","tm","co.tm","com.tm","edu.tm","gov.tm","mil.tm","net.tm","nom.tm","org.tm","tn","com.tn","ens.tn","fin.tn","gov.tn","ind.tn","info.tn","intl.tn","mincom.tn","nat.tn","net.tn","org.tn","perso.tn","tourism.tn","to","com.to","edu.to","gov.to","mil.to","net.to","org.to","tr","av.tr","bbs.tr","bel.tr","biz.tr","com.tr","dr.tr","edu.tr","gen.tr","gov.tr","info.tr","k12.tr","kep.tr","mil.tr","name.tr","net.tr","org.tr","pol.tr","tel.tr","tsk.tr","tv.tr","web.tr","nc.tr","gov.nc.tr","tt","biz.tt","co.tt","com.tt","edu.tt","gov.tt","info.tt","mil.tt","name.tt","net.tt","org.tt","pro.tt","tv","tw","club.tw","com.tw","ebiz.tw","edu.tw","game.tw","gov.tw","idv.tw","mil.tw","net.tw","org.tw","tz","ac.tz","co.tz","go.tz","hotel.tz","info.tz","me.tz","mil.tz","mobi.tz","ne.tz","or.tz","sc.tz","tv.tz","ua","com.ua","edu.ua","gov.ua","in.ua","net.ua","org.ua","cherkassy.ua","cherkasy.ua","chernigov.ua","chernihiv.ua","chernivtsi.ua","chernovtsy.ua","ck.ua","cn.ua","cr.ua","crimea.ua","cv.ua","dn.ua","dnepropetrovsk.ua","dnipropetrovsk.ua","donetsk.ua","dp.ua","if.ua","ivano-frankivsk.ua","kh.ua","kharkiv.ua","kharkov.ua","kherson.ua","khmelnitskiy.ua","khmelnytskyi.ua","kiev.ua","kirovograd.ua","km.ua","kr.ua","kropyvnytskyi.ua","krym.ua","ks.ua","kv.ua","kyiv.ua","lg.ua","lt.ua","lugansk.ua","luhansk.ua","lutsk.ua","lv.ua","lviv.ua","mk.ua","mykolaiv.ua","nikolaev.ua","od.ua","odesa.ua","odessa.ua","pl.ua","poltava.ua","rivne.ua","rovno.ua","rv.ua","sb.ua","sebastopol.ua","sevastopol.ua","sm.ua","sumy.ua","te.ua","ternopil.ua","uz.ua","uzhgorod.ua","uzhhorod.ua","vinnica.ua","vinnytsia.ua","vn.ua","volyn.ua","yalta.ua","zakarpattia.ua","zaporizhzhe.ua","zaporizhzhia.ua","zhitomir.ua","zhytomyr.ua","zp.ua","zt.ua","ug","ac.ug","co.ug","com.ug","go.ug","ne.ug","or.ug","org.ug","sc.ug","uk","ac.uk","co.uk","gov.uk","ltd.uk","me.uk","net.uk","nhs.uk","org.uk","plc.uk","police.uk","*.sch.uk","us","dni.us","fed.us","isa.us","kids.us","nsn.us","ak.us","al.us","ar.us","as.us","az.us","ca.us","co.us","ct.us","dc.us","de.us","fl.us","ga.us","gu.us","hi.us","ia.us","id.us","il.us","in.us","ks.us","ky.us","la.us","ma.us","md.us","me.us","mi.us","mn.us","mo.us","ms.us","mt.us","nc.us","nd.us","ne.us","nh.us","nj.us","nm.us","nv.us","ny.us","oh.us","ok.us","or.us","pa.us","pr.us","ri.us","sc.us","sd.us","tn.us","tx.us","ut.us","va.us","vi.us","vt.us","wa.us","wi.us","wv.us","wy.us","k12.ak.us","k12.al.us","k12.ar.us","k12.as.us","k12.az.us","k12.ca.us","k12.co.us","k12.ct.us","k12.dc.us","k12.fl.us","k12.ga.us","k12.gu.us","k12.ia.us","k12.id.us","k12.il.us","k12.in.us","k12.ks.us","k12.ky.us","k12.la.us","k12.ma.us","k12.md.us","k12.me.us","k12.mi.us","k12.mn.us","k12.mo.us","k12.ms.us","k12.mt.us","k12.nc.us","k12.ne.us","k12.nh.us","k12.nj.us","k12.nm.us","k12.nv.us","k12.ny.us","k12.oh.us","k12.ok.us","k12.or.us","k12.pa.us","k12.pr.us","k12.sc.us","k12.tn.us","k12.tx.us","k12.ut.us","k12.va.us","k12.vi.us","k12.vt.us","k12.wa.us","k12.wi.us","cc.ak.us","lib.ak.us","cc.al.us","lib.al.us","cc.ar.us","lib.ar.us","cc.as.us","lib.as.us","cc.az.us","lib.az.us","cc.ca.us","lib.ca.us","cc.co.us","lib.co.us","cc.ct.us","lib.ct.us","cc.dc.us","lib.dc.us","cc.de.us","cc.fl.us","cc.ga.us","cc.gu.us","cc.hi.us","cc.ia.us","cc.id.us","cc.il.us","cc.in.us","cc.ks.us","cc.ky.us","cc.la.us","cc.ma.us","cc.md.us","cc.me.us","cc.mi.us","cc.mn.us","cc.mo.us","cc.ms.us","cc.mt.us","cc.nc.us","cc.nd.us","cc.ne.us","cc.nh.us","cc.nj.us","cc.nm.us","cc.nv.us","cc.ny.us","cc.oh.us","cc.ok.us","cc.or.us","cc.pa.us","cc.pr.us","cc.ri.us","cc.sc.us","cc.sd.us","cc.tn.us","cc.tx.us","cc.ut.us","cc.va.us","cc.vi.us","cc.vt.us","cc.wa.us","cc.wi.us","cc.wv.us","cc.wy.us","k12.wy.us","lib.fl.us","lib.ga.us","lib.gu.us","lib.hi.us","lib.ia.us","lib.id.us","lib.il.us","lib.in.us","lib.ks.us","lib.ky.us","lib.la.us","lib.ma.us","lib.md.us","lib.me.us","lib.mi.us","lib.mn.us","lib.mo.us","lib.ms.us","lib.mt.us","lib.nc.us","lib.nd.us","lib.ne.us","lib.nh.us","lib.nj.us","lib.nm.us","lib.nv.us","lib.ny.us","lib.oh.us","lib.ok.us","lib.or.us","lib.pa.us","lib.pr.us","lib.ri.us","lib.sc.us","lib.sd.us","lib.tn.us","lib.tx.us","lib.ut.us","lib.va.us","lib.vi.us","lib.vt.us","lib.wa.us","lib.wi.us","lib.wy.us","chtr.k12.ma.us","paroch.k12.ma.us","pvt.k12.ma.us","ann-arbor.mi.us","cog.mi.us","dst.mi.us","eaton.mi.us","gen.mi.us","mus.mi.us","tec.mi.us","washtenaw.mi.us","uy","com.uy","edu.uy","gub.uy","mil.uy","net.uy","org.uy","uz","co.uz","com.uz","net.uz","org.uz","va","vc","com.vc","edu.vc","gov.vc","mil.vc","net.vc","org.vc","ve","arts.ve","bib.ve","co.ve","com.ve","e12.ve","edu.ve","firm.ve","gob.ve","gov.ve","info.ve","int.ve","mil.ve","net.ve","nom.ve","org.ve","rar.ve","rec.ve","store.ve","tec.ve","web.ve","vg","vi","co.vi","com.vi","k12.vi","net.vi","org.vi","vn","ac.vn","ai.vn","biz.vn","com.vn","edu.vn","gov.vn","health.vn","id.vn","info.vn","int.vn","io.vn","name.vn","net.vn","org.vn","pro.vn","angiang.vn","bacgiang.vn","backan.vn","baclieu.vn","bacninh.vn","baria-vungtau.vn","bentre.vn","binhdinh.vn","binhduong.vn","binhphuoc.vn","binhthuan.vn","camau.vn","cantho.vn","caobang.vn","daklak.vn","daknong.vn","danang.vn","dienbien.vn","dongnai.vn","dongthap.vn","gialai.vn","hagiang.vn","haiduong.vn","haiphong.vn","hanam.vn","hanoi.vn","hatinh.vn","haugiang.vn","hoabinh.vn","hungyen.vn","khanhhoa.vn","kiengiang.vn","kontum.vn","laichau.vn","lamdong.vn","langson.vn","laocai.vn","longa